/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = %%s %%s %%s */

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/*********************************************************************/
/*                                                                   */
/*  SOURCE FILE NAME: dispcall.h                                     */
/*                                                                   */
/*  DESCRIPTIVE NAME: Call prototype file for DISPINST               */
/*                                                                   */
/*  FUNCTION: This include file contains the call prototypes.        */
/*                                                                   */
/*  ENTRY POINT: None                                                */
/*                                                                   */
/*  PARAMETERS: None                                                 */
/*   Input:                                                          */
/*   Output:                                                         */
/*                                                                   */
/*  REFERENCES: None                                                 */
/*                                                                   */
/*********************************************************************/

/*--------------------------------------------------------------*\
 * dispmain.c                                                   *
\*--------------------------------------------------------------*/
INT     main(USHORT argc, CHAR **argv);
MRESULT EXPENTRY MainWndProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
VOID    UpdateInstallDlg(HWND hwndDlg);
MRESULT MainWorker(HWND hwnd, MPARAM mp1, MPARAM mp2);
MRESULT MainHelpError(HWND hwnd, MPARAM mp1, MPARAM mp2);
BOOL    EXPENTRY InputHook(HAB hab, PQMSG pqmsg, USHORT fs);
VOID    MainFSM(HWND hwnd, MPARAM state, MPARAM mp2,PULONG pulExitCode);
ULONG   InstallNextDisk(HWND hwnd,PDSPINSTL_CHAIN pCurrentDiskData,
                             ULONG ulNextDiskette,
                             ULONG ulFlags);
/*--------------------------------------------------------------*\
 * dispinit.c                                                   *
\*--------------------------------------------------------------*/
BOOL Init(SHORT Argc,PSZ *pArgv);
BOOL InitEnv(VOID);                              // warp
VOID EXPENTRY MainExitProc(USHORT usTermCode);
VOID InitDlgWindow(HWND hwndDlg);
BOOL InitDriveArray(VOID);
VOID InitHelp(HWND *phwndHelpInstance);
VOID InitAdapterType(PADAPTERTYPE pAdapterType);
BOOL ValidateArgCount(PSZ pszCount);
BOOL LoadStrings(VOID);
BOOL IsAnyABIOSPresent(VOID);                   /* DonW 68000 */

/*--------------------------------------------------------------*\
 * dispdlg.c                                                    *
\*--------------------------------------------------------------*/
MRESULT EXPENTRY AboutDlgProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY SelectDirDlgProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY SourceDlgProc(HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY AdapterTypeDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY NullChildDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY AdapterDlgProc(HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY SpecifyAdapterDlgProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY SpecifyMonitorDlgProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY SpecifyResolutionsDlgProc(HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY ReportErrorWndProc(HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY DisplayLogfileWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
ULONG   APIENTRY GetNextDisk(HWND hwnd, ULONG  msg,PSZ pszLabel);
VOID    FillDirListBox(PFILDLG pfile);
BOOL    DirFromSelection(PFILDLG pfile);
BOOL    VerifyDir(PSZ pszPath, HWND hwndOwner,BOOL fShowMessageBox);
BOOL    FindDDPOnSource(PSZ pszSrcDir);
VOID    CenterDialog(HWND hwnd);
VOID    SetSystemMenu(HWND hwnd);
ULONG   APIENTRY CheckNextDisk(HWND hwnd,
                              PSZ pszVolumeLabel,
                              PSZ pszDiskettePrompt,
                              PSZ pszKey,
                              ULONG ulCurrentDisk);
ULONG  APIENTRY TransferNextDisk(HWND hwnd,
                                  PSZ pszKey,
                                  ULONG ulFlags,
                                  PSZ pszVolumeLabel);
MRESULT EXPENTRY InsertDiskWndProc(HWND hwnd,ULONG  msg,
                                   MPARAM mp1,MPARAM mp2);


VOID MainInitDlgWindow(HWND hwndDlg);
BOOL SupportedResolution(PSZ pResolutionString,
                              PRESOLUTIONS pResolutions);

USHORT APIENTRY CountKeyMatches(PSZ pszKey, USHORT iAdapterSubtype,
                       PADAPTERTYPE padptypeRet);

/*--------------------------------------------------------------*\
 * dispwork.c                                                   *
\*--------------------------------------------------------------*/
BOOL StartWorkerThread(VOID);
VOID _Optlink Worker(PVOID);
BOOL InitWorker(VOID);
BOOL WorkerPostMsg(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
VOID WorkerWndProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
APIRET APIENTRY InitTransferThread(VOID );
VOID _Optlink  ResponseTransferThread(PVOID );
APIRET SendWorkerMessage(PWINDATA  pwin);

/*--------------------------------------------------------------*\
 * displog.c                                                    *
\*--------------------------------------------------------------*/
VOID LogAFile(PSZ psz);

/*--------------------------------------------------------------*\
 * dbcs.c                                                       *
\*--------------------------------------------------------------*/
char *dbcs_strncpy(char *target, char *source, unsigned int length);
char *dbcs_strncat(char *target, char *source, unsigned int length);
char *dbcs_lastchr(char *source);
char *dbcs_appendslash(char *path);

/*--------------------------------------------------------------*\
 * dispdsp.c                                                    *
\*--------------------------------------------------------------*/
ULONG GetMatchingDsps(PHEAD pheadDsps, PSZ pszDir, PSZ pszKey);
ULONG ReadDsp(PSZ pszDsp, PDSP *ppdsp);
ULONG ReadDspLines(HFILE hf, PHEAD pheadLines);
VOID  FreeDsp(PDSP pdsp);

/*--------------------------------------------------------------*\
 * dispinst.c                                                   *
\*--------------------------------------------------------------*/
MRESULT EXPENTRY InstallDlgProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
ULONG InstallDspList(PHEAD pheadDsps, ULONG ulFlags);
ULONG CalcNumOfFiles (PHEAD pheadFiles, BOOL fFlag, PSZ *ppszErrMsg);  /* D87507 */
VOID UpdateReinstalIni(PSZ pszDialogButton);            // warp

/*--------------------------------------------------------------*\
 * dispcfg.c                                                    *
\*--------------------------------------------------------------*/
VOID   WriteConfig(PCHAR pchLine, PHEAD pheadConfig);
VOID   WriteConfigDelLines(PCHAR pchLine, PHEAD pheadConfig);
ULONG  FlushConfig(PHEAD pheadConfig, BOOL fFlag);
ULONG  FlushConfigDeletes(PHEAD pheadConfig, BOOL fFlag);
VOID _Optlink FlushConfigThread( PVOID );      //@MTD

/*--------------------------------------------------------------*\
 * dispfile.c                                                   *
\*--------------------------------------------------------------*/
ULONG AddFiles(PCHAR pchLine, PHEAD pheadFiles,PSZ pszSourcePath);
VOID  AddDrivePath(PSZ pszRawName, PSZ pszDefaultPath, PSZ pszFullName);
ULONG CopyFiles(PHEAD pheadFiles, BOOL fFlag, PSZ *ppszErrMsg);
ULONG CreateDir(PSZ pszDir);
BOOL  IsSrcNewer(PSZ pszSrc, PSZ pszDst);
ULONG AppendFileNames(PHEAD pheadFiles);
ULONG AddFilesForAppend(PCHAR pchLine, PHEAD pheadFiles);

/*--------------------------------------------------------------*\
 * dispini.c                                                    *
\*--------------------------------------------------------------*/
VOID  WriteOS2ini(PCHAR pchLine, PHEAD pheadOS2Ini, ULONG iTagLine);
ULONG FlushOS2ini(PHEAD pheadOS2Ini, BOOL fFlag);
VOID _Optlink FlushOS2iniThread( PVOID );        //@MTD
ULONG FindNextSpace(PCHAR pchLine);
ULONG FindNextNonSpace(PCHAR pchLine);

/*--------------------------------------------------------------*\
 * dispmisc.c                                                   *
\*--------------------------------------------------------------*/
BOOL     FileExists(PSZ pszFile);
USHORT   QueryVolumeLabel(PSZ pszVolumeLabel, CHAR chDriveLetter);
PADAPTERTYPE  GetSelectedAdapter(PADAPTERTYPE pAdapterType,USHORT usMonitorType);
VOID     SetFlags(PADAPTERTYPE pAdapterType,LONG lFlags);
VOID     ReSetFlags(PADAPTERTYPE pAdapterType,LONG lFlags);
BOOL     IsRemovableMedia(CHAR chDriveLetter);
VOID     CopyHelpFile(VOID);
VOID     DeleteHelpFile(VOID);
VOID     SetDetectedAdapterType(PADAPTERTYPE pAdapterType,USHORT usType,
                                USHORT usAdapterType);
VOID     SetAdapterPointers(VOID);
HWND     MainLoadDlg(HWND hwndOwner, PFNWP pfnDlgProc, USHORT idDlg,
                     PVOID pCreateParams, BOOL fDestroy);
ULONG    MainDlgBox(HWND hwndOwner, PFNWP pfnDlgProc, USHORT idDlg,
                    PVOID pCreateParams);
VOID SetAdapterType(PADAPTERTYPE pAdapterType,USHORT usType);

ULONG LoadString(ULONG id, ULONG cbBuf, PCHAR pchBuf);

ULONG MessageBox(HWND hwndOwner, USHORT id, PSZ pszText, PSZ pszTitle,
                 USHORT flStyle);

VOID ReportError(ULONG id, PSZ pszMsg, HWND hwndOwner, ULONG ulFlags,
                 ULONG ulExitCode);

VOID Alarm(ULONG ulType);

USHORT CountKeyMatches(PSZ pszKey, USHORT iAdapterSubtype,
                       PADAPTERTYPE padptypeRet);

USHORT  GetArgument(PSZ pszString,PSZ *ppszToken );

BOOL    ProcessCmdLine(SHORT sArgc,CHAR **ppArgv,PULONG pulError,
                       PULONG pulExecutionMode);

BOOL    BootDriveSet(SHORT sArgc,CHAR **ppArgv);

BOOL    IsSelAdapterValidForDestAdapter(ULONG  ulSelected,
                                        ULONG  ulInstalled);
/*--------------------------------------------------------------*\
 * dispact.c                                                    *
\*--------------------------------------------------------------*/

LONG PrimaryAction(HWND hwnd,PFN pfnResolutionProc,PFN pfnAdapterDlgProc,
                         PFN pfnReportError,
                         PFN pfnSpecifyMonitor,
                         BOOL fResponseFile);

LONG SecondaryAction(HWND hwnd,PFN pfnResolutionProc,PFN pfnAdapterDlgProc,
                         PFN pfnReportError,
                         PFN pfnSpecifyMonitor,
                         BOOL fResponseFile);
/*--------------------------------------------------------------*\
 * dispwini.c                                                   *
\*--------------------------------------------------------------*/

ULONG WriteWinIni(PCHAR pchLine, ULONG iTagLine);
ULONG FlushWinIni(BOOL fFlush);
VOID  InsProfileInit(VOID);
PSZ   StrTokQuote(PSZ pszLine, PSZ pszDelim);
/*--------------------------------------------------------------*\
 * disprun.c                                                    *
\*--------------------------------------------------------------*/
VOID ProcessRun(PDSP pdsp, PSZ pszRunLine);

/*--------------------------------------------------------------*\
 * dispgre.c                                                    *
\*--------------------------------------------------------------*/
ULONG WriteDriver(PSZ pszLine, PDSPINFO pdspnfo);
ULONG WriteResolution(PSZ pszLine, PSCREENRESOLUTION pscrres);
ULONG FlushDriver(PDSPINFO pdspnfo, BOOL fFlush);
ULONG FlushResolution(PSCREENRESOLUTION pscrres, BOOL fFlush);
APIRET WriteAutoExec(PHEAD phead, BOOL fFlag );
/*
 *specify.c
 */
#ifndef RESPONSE_FILE
LONG EXPENTRY SpecifyMonitor(HWND hwnd, PSZ pszFile, PVIDEOENTRY pvidentry);
LONG EXPENTRY SpecifyAdapter(HWND hwnd, PSZ pszFile, PADAPTERENTRY padpentry);
LONG EXPENTRY SpecifyResolutions(HWND hwnd,PRESOLUTIONS pResolutions,
                                 ULONG ulResolutionCount,
                                 BOOL  bAllowMultipleResolutions);
VOID FreeMonitors(PHEAD pheadMonitors);
VOID FreeAdapters(PHEAD pheadAdapters);
#endif

/*
 *wrtplin.c
 */
BOOL WrtPlinData(ULONG ulType,BOOL  fSelectedPrimary,
                 BOOL fIsoComp,
                 ULONG ulMonitor,
                 BOOL fCancelOperation);


/*
 *disprsp.c
 */
VOID  DispVioInsertDiskPanel(CHAR chDriveLetter,PSZ pszDriveLabel);


/* D87507
 * dispprgs.c
 */
MRESULT EXPENTRY ProgressWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY SliderWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY TransFilesWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
VOID CenterProgressWnd (HWND hwnd, LONG sXsize, LONG sYsize);

