.**************************************************************************
.*                            Lexmark Confidential
.*
.*  History
.*
.*  06/24/91 Sue Murch       -  Update Help Files
.*                           -  Reformat help files to become more
.*                              like the Boca version of help
.*                           -  Added glossary terms
.*
.*  07/23/91 Sue Murch       -  Final Edit before translation
.*
.*  11/25/91 Sue Murch       -  Update Help Version to 1.209
.*
.*  12/04/91 Dan Howell      -  PD00604: Added new Limited Code Pages
.*                              radio button description
.*
.*  05/07/92 Sue Murch       -  Update Help Version to 1.209
.*
.*  05/18/92 D. Howell       -  Replicate hyper text from About driver to
.*                              Printer Properties
.*
.*  05/19/92 Sue Murch       -  Update help version.  Add switch settings for
.*                              the ExecJet.  Add paper position settings for
.*                              the ExecJet in the Form Connections help.
.*
.*  05/21/92 Sue Murch       -  Update help version.  Add 4070 specific help
.*
.*  05/26/92 Sue Murch       -  Update help version.  Add 4070 specific help
.*
.*  06/04/92 D. Howell       -  PD00715 : Corrected "queue" hyper-link in
.*                              Spool File Type.  Also "pp_items" in all cases
.*
.*  06/16/92 D. Howell       -  4072: Corrected "Slot 1/2" to "Left/Right Slot"
.*                           -  4072: Added printer to No Locking list
.*
.*  07/07/92 D. Howell       -  PD00735 : Corrected hyper-link for First Page
.*
.*  07/10/92 D. Howell       -  4072: Changed "code pages" to "device fonts"
.*
.*  07/13/92 D. Howell       -  PD00741: Added Font Cards hyper link and
.*                              added hyper link for other Paper Sources
.*
.*  07/14/92 D. Howell       -  4070: Add 4070 to printer settings sections &
.*                              mention Model 002 optional auto sheet feed
.*
.*  8/04/92 D. Howell        - PD00765 : 4070 has a top margin of .11 inches
.*
.*  8/04/92 Sue Murch        - PD00786 : Changed Pinwheel Form Feed to
.*                             Continous Forms
.*
.*  End History
.**************************************************************************
.**********************************************************************
.*
.* Help File     : PRD42XX.IPF
.*
.* Contains      : All help panels. Most as separate includes of IPF files,
.*
.* Includes      : PRDHPP42.IPF
.*                 PRDHJP42.IPF
.*                 PRD42FRM.IPF
.*                 PRDHCODE.IPF
.*                 PRD42DFN.IPF
.*
.* Index Titles  : None
.*
.* Created       : PS 15th May 1991
.* Updated       : SM 29th May 1991
.*                 SM 5th June 1991
.*                 DV 10th June 1991
.*                 AK 28th June 1991 - July 3
.* Edited        : FS/AK 19th July 1991
.**********************************************************************
.*****************************************************************************
.*  Note to anybody reading this text:  All of the ":h*." headers listed
.*                                      in any of the files appear on
.*                                      screen in the exact same format.
.*                                      There is no difference between
.*                                      an h1 and an h2 header except in
.*                                      the table of contents entry, and
.*                                      there an h2 will always be indented
.*                                      beneath an h1.   Likewise an h3 would
.*                                      be indented under an h2 header.
.*****************************************************************************
:userdoc.
:title.DDK42XX Printer Device Driver Help
:body.
.**********************************************************************
.*
.* INDEX TITLES
.*
.**********************************************************************
:h1 res=999.Help for the DDK42XX Printer Driver
:i1.DDK42XX printer model selection and panel settings
:p.The DDK42XX :link reftype=hd res=17169.printer&rbl.driver:elink.
supports
the following printer models&colon.
:ul compact.
:li.:link reftype=hd res=5022.IBM*:elink. 2380 Personal Printer Series II
:li.IBM 2381 Personal Printer Series II
:li.IBM 2390 Personal Printer Series II
.* LEXMARK 5 add
:li.IBM 2390 PS/1
.*
:li.IBM 2391 Personal Printer Series II
:li.IBM 4201 :link reftype=hd res=5022.Proprinter*:elink.
:li.IBM 4201 Proprinter II
:li.IBM 4201 Proprinter III
:li.IBM 4202 Proprinter XL
:li.IBM 4202 Proprinter II XL
:li.IBM 4202 Proprinter III XL
:li.IBM 4207 Proprinter X24
:li.IBM 4207 Proprinter X24E
:li.IBM 4208 Proprinter XL24
:li.IBM 4208 Proprinter XL24E
:li.IBM 4224 Model 3C2
:li.IBM 4224 Models 301, 302, and 3E3
:li.IBM 4226 Model 302
:eul.
:p.If you have an
IBM 4212 Proprinter 24P, select the printer driver,
:hp1.DDK42XX.IBM 2390 PPS II:ehp1..  If you
have an IBM 4234 Dot Band Printer Model 013, select
the printer driver, :hp1.DDK42XX.IBM 4202 Proprinter&rbl.XL:ehp1.,
then set up the printer properties window by selecting
:hp2.Not Available:ehp2. in the :hp2.Printer Fonts:ehp2. field.
:p.Printer language support&colon.  This printer
driver supports only the Personal Printer Data Stream
(PPDS) printer-control language, formerly called
IBM ASCII.
:p.Related Information&colon.
:ul compact.
:li.:link reftype=hd res=15202.Printer&rbl.messages:elink.
:li.:link reftype=hd res=15203.Unattended&rbl.printer&rbl.operation:elink.
:li.:link reftype=hd res=15205.Printer&rbl.settings:elink.
:li.:link reftype=hd res=15204.Help&rbl.version:elink.
:eul.
.**********************************************************************
.*
.*  HELP FOR PRINTER PROPERTIES DIALOGS
.*
.*  - common context help for all drivers
.*  - specific context help for each individual driver
.*
.**********************************************************************
.**********************************************************************
.*
.*  INCLUDE THE PRINTER PROPERTIES DDK42XX EXTENSIONS
.*
.**********************************************************************
.**********************************************************************
.* PRINTER PROPERTIES EXTENDED HELP TEXT
.**********************************************************************
:h1 res=202.Help for Printer Properties
:i1 id=pp_push.printer properties pushbuttons
:i1 id=soft_config.print-job setup
:i1 id=hard_config.physical printer setup
:i1 id=pp_items.printer properties
:p.Use this window to select from the characteristics that
describe the physical setup of your printer, and to
select
:link reftype=hd res=17034.default:elink.
characteristics for individual print
jobs.  The information provided concerns the characteristics of the
printer named in the heading of the window.
:p.Setup fields in this window enable you to specify
the forms available for the printer.  Pushbuttons
give access to other setup windows in which you
can link forms to each paper source,
and make fonts available.  You
can also use this window to indicate, if your printer supports
an extended NLS version.
:p.The default print-job setup fields in this window enable you specify
:link reftype=hd  res=17177.resolution:elink.,
the orientation of characters on the paper, and
:link reftype=hd  res=17307.spool&rbl.file:elink.
type.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=302.Orientation:elink.
:li.:link reftype=hd res=301.Resolution:elink.
:li.:link reftype=hd res=304.Spool&rbl.File&rbl.Type:elink.
:li.:link reftype=hd res=318.Form&rbl.Feed&rbl.Control:elink.
:li.:link reftype=hd res=316.Printer&rbl.Fonts:elink.
:li.:link reftype=hd res=242.Forms:elink.
:li.:link reftype=hd res=331.Extended&rbl.NLS&rbl.Version:elink.
:li.:link reftype=hd res=323.Default&rbl.Font:elink.
:li.:link reftype=hd res=325.Form&rbl.Connections:elink.
.* LEXMARK 5 change: add (4224 printers)
:li.:link reftype=hd res=309.Paper&rbl.Sources&rbl.(4224&rbl.printers):elink.
:li.:link reftype=hd res=317.Code&rbl.Page&rbl.Memory:elink.
:li.:link reftype=hd res=329.Code&rbl.Pages:elink.
:li.:link reftype=hd res=1090.OK:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
:p.Related Information&colon.
.* LEXMARK 5 change to unordered list
:ul compact.
:li.:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.* LEXMARK 5 add
:li.:link reftype=hd res=15202.Printer&rbl.messages:elink.
:li.:link reftype=hd res=15203.Unattended&rbl.printer&rbl.operation:elink.
:li.:link reftype=hd res=15205.Printer&rbl.settings:elink.
:eul.
.*
.**********************************************************************
.* PRINTER PROPERTIES HELP PANELS
.**********************************************************************
:h2 res=301.Help for Resolution
:i1.resolution
:i2 refid=soft_config.resolution
:i2 refid=pp_items.resolution
:p.Select the number, in dots-per-inch (dpi) increments,
representing the
:link reftype=hd res=17177.resolution:elink.
in which you want graphics produced on your printer.
:p.Select the highest number
for the best quality.  Because printing in high resolution takes longer,
you can reserve this setting
for final documents.  Select a low number to print faster; for example, to produce
drafts of documents.
:p.This option only applies to
:link reftype=hd res=450.graphics&rbl.data:elink. jobs.  It does not apply to
:link reftype=hd res=450.raw&rbl.data:elink. jobs.
:p.Related Information&colon.
:p.
:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.**********************************************************************
:h2 res=302.Help for Orientation
:i1.orientation
:i2 refid=soft_config.orientation
:i2 refid=pp_items.orientation
:p.Select :hp2.Portrait:ehp2. (upright) to
print with
the top of the printed material in the same
direction as the top of the
paper.  Letters, books, and reports usually have
portrait orientation.
:p.Select :hp2.Landscape:ehp2. (rotated) to
print
perpendicular to the
direction in which the paper is fed.  Landscape is frequently selected
for documents such as spreadsheets or
plotted graphics, which are wider than they are long.
:p.This option only applies
to :link reftype=hd res=450.graphics&rbl.data:elink. jobs.  It does
not apply to :link reftype=hd res=450.raw&rbl.data:elink. jobs.
:p.Related Information&colon.
:p.
:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.**********************************************************************
:h2 res=242.Help for Defined Forms
:p.Use the :hp2.Forms:ehp2. fields to select a form you want to
add, change, or delete.
:p.:hp2.Defined Forms:ehp2. lists all of the forms
defined for this logical printer, by form name and size.  Select
the form you want to use
as a sample for one you want to add, or select a form you want
to change or delete.   You can scroll the list to see more forms.
:nt.When you load a form in your printer, be sure to select
the :hp2.Form Connections:ehp2. pushbutton at the bottom of the
printer properties window to indicate which form is loaded in each
paper source.
:ent.
:p.For a detailed explanation of each forms-related
pushbutton, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=15313.Add:elink.
:li.:link reftype=hd res=15314.Change:elink.
:li.:link reftype=hd res=15315.Delete:elink.
:eul.
:p.Related Information&colon.
:p.:link reftype=hd res=325.Form&rbl.Connections:elink.
.**********************************************************************
:h2 res=15313.Help for Add
:i2 refid=pp_push.add form pushbutton
:p.Select :hp2.Add:ehp2. to define a new form name and
size.  The Add Form
window will appear.
.**********************************************************************
:h2 res=15314.Help for Change
:i2 refid=pp_push.change form pushbutton
:p.Select :hp2.Change:ehp2. to alter the name or size of the selected
form.  The Change Form
window will appear.  You cannot change a form supplied with the
:link reftype=hd res=17169.printer&rbl.driver:elink..
.**********************************************************************
:h2 res=15315.Help for Delete
:i1.delete form
:i2 refid=pp_push.delete form pushbutton
:p.Select :hp2.Delete:ehp2. to remove the selected form from the list.  You
cannot delete a form supplied with the
:link reftype=hd res=17169.printer&rbl.driver:elink.,
or a currently connected form.
:p.Selecting :hp2.Delete:ehp2. causes a window to appear,
in which you can verify or cancel the deletion.  Selecting
:hp2.Yes:ehp2. deletes the selected form.  Selecting :hp2.No:ehp2.
returns the :hp2.Defined Forms:ehp2. selection list without deleting the form.
.**********************************************************************
:h2 res=304.Help for Spool File Type
:i1.spool file type
:i2 refid=soft_config.spool file type
:i2 refid=pp_items.spool file type
:p.Use the :hp2.Spool File Type:ehp2. list to select the default
format of jobs that are printed to the spool
.* LEXMARK 5 change 17188 to 17242
:link reftype=hd res=17242.queue:elink.&per.
.*
:parml compact break=all.
:pt.PM_Q_RAW
:pd.The file created when the job is added to the spool queue consists
of device-dependent Personal Printer Data Stream (PPDS) commands.  PM_Q_RAW
jobs might
take more time to be added to the spool queue, but might take less time to be
removed from the spool queue than PM_Q_STD jobs.
:pt.PM_Q_STD
:pd.The file created when the job is added to the spool queue consists of
device-independent
:link reftype=hd res=5022.Presentation&rbl.Manager*:elink.
commands.  PM_Q_STD jobs might take less time to be
added to the spool queue, but might take more time to be removed from the
spool queue than PM_Q_RAW jobs.
:eparml.
:nt.This selection can be overridden by a Presentation Manager program.
:ent.
.**********************************************************************
:h2 res=316.Help for Printer Fonts
:i1.printer fonts
:i2 refid=soft_config.printer fonts
:i2 refid=pp_items.printer fonts
:p.Use the :hp2.Printer Fonts:ehp2.
:link reftype=hd res=17245.radio&rbl.buttons:elink. to indicate
.* LEXMARK 4 change
which printer
.*
:link reftype=hd res=17580.device&rbl.fonts:elink. are available for
:link reftype=hd res=450.graphics&rbl.data:elink.
.* LEXMARK 5 change
jobs.  With :hp2.Available:ehp2.&comma.
.* LEXMARK 4 add
.* LEXMARK 5 change
:hp2.Limited Code Pages:ehp2.&comma. or
.*
.* LEXMARK 5 add
:hp2.Limited:ehp2.
.*
selected, programs can choose printer device
fonts for your job to be printed faster.  In addition, a smaller
:link reftype=hd res=17307.spool&rbl.file:elink. is created than when
:link reftype=hd res=17193.system&rbl.fonts:elink. are used.
:nt.Occasionally, printer device fonts produce
different results on the printer than on the display.  In these
cases, selecting :hp2.Not Available:ehp2. might give the desired results.
:ent.
.* LEXMARK 4 add
:nt.Some printers support a large number of fonts and
:link reftype=hd res=17062.code&rbl.pages:elink..  With all of these
printer device fonts available, some applications will not work or will
produce different results on the printer than on the display.  In these
cases, selecting :hp2.Limited Code Pages:ehp2.
.* LEXMARK 5 add
or :hp2.Limited:ehp2.
.*
might give the desired results.
.* LEXMARK 5 add next 4 lines
Selecting :hp2.Limited:ehp2. will reduce not only the number of
code pages but it will also limit the actual number of font type faces returned
to the application.  Selecting :hp2.Limited Code Pages:ehp2. will limit only
the number of code pages returned to the application.
.*
Selecting :hp2.Available:ehp2. will make all of the printer
.* LEXMARK 5 change code pages to device fonts
device fonts available for graphics data jobs.
.*
:ent.
.*
.**********************************************************************
:h2 res=318.Help for Form Feed Control
:i1.form feed control
:i2 refid=soft_config.form feed control
:i2 refid=pp_items.form feed control
:p.Use the :hp2.Form Feed Control:ehp2.
:link reftype=hd res=17245.radio&rbl.buttons:elink. to indicate
if the :link reftype=hd res=17169.printer&rbl.driver:elink. is to send a
form-feed control at the end of each job.  The three choices are&colon.
:ul compact.
:li.:hp2.None:ehp2..  A form feed is not added to the end of each job.
:li.:hp2.Compulsory:ehp2..  A form feed is always added to the end of each job.
:li.:hp2.Conditional:ehp2.. A form feed is only added to the end of the job if
the job does not end with a form feed.
:eul.
:p.These radio buttons only apply to
:link reftype=hd res=450.raw&rbl.data:elink. jobs.
.**********************************************************************
:h2 res=309.Help for Paper Sources (4224 printers)
:i1.paper sources (4224 printers)
.* LEXMARK 5 change: add (4224 printers)
:i2 refid=hard_config.paper sources (4224 printers)
.* LEXMARK 5 change: add (4224 printers)
:i2 refid=pp_items.paper sources (4224 printers)
:p.Select one :link reftype=hd res=17245.radio&rbl.button:elink. to indicate which
paper source is attached to the printer.  Four types are available&colon.
:ul compact.
:li.Continuous Forms (F1)
:li.Document on Demand (F2)
:li.Document Insertion (F3)
:li.Automatic Sheet Feed (ASF 530) (F4)
:eul.
:p.To connect a form to each paper source, select
:hp2.Form Connections:ehp2..
.**********************************************************************
:h2 res=317.Help for Code Page Memory (Proprinters)
:i1.code page memory (Proprinters)
:i2 refid=hard_config.printer memory for downloadable code pages
:i2 refid=pp_items.code page memory for downloadable code pages
:p.Select one :link reftype=hd res=17245.radio&rbl.button:elink. to
indicate if
your printer has additional memory installed
to hold versions of the printer fonts for
:link reftype=hd res=17062.code&rbl.pages:elink. other than those
resident in the printer.
:p.For :link reftype=hd res=5022.Proprinters*:elink., the code-page memory
is&colon.
:ul compact.
:li.Always installed in printers other than those used in the U.S. and Canada.
:li.Available as an option for printers in the U.S. and Canada,
with the following exceptions&colon.
:ul compact.
:li.Proprinter&colon.  Memory is not available in the U.S. and Canada.
:li.Proprinter XL&colon.  Memory is always installed in printers in the
U.S. and Canada.
:eul.
:eul.
:p.To use a code page, select :hp2.Code Pages:ehp2..
.**********************************************************************
.* PPS II EXTENDED NLS MACHINES
.**********************************************************************
:h2 res=331.Help for Extended NLS Version (PPS II printers)
:i1.extended NLS version (PPS II printers)
:i2 refid=hard_config.extended NLS version
:i2 refid=pp_items.extended NLS version
:p.Use the :hp2.Extended NLS Version:ehp2.
:link reftype=hd res=17245.radio&rbl.buttons:elink. to indicate if you
have a version of the printer that supports fonts in an extended range
of :link reftype=hd res=17062.code&rbl.pages:elink..  The choices are&colon.
:ul compact.
:li.:hp2.Yes:ehp2..  The printer contains fonts for code pages&colon.
:xmp.
         437    857    864
         850    860    865
         852    862    869
         855    863
:exmp.
:li.:hp2.No:ehp2..  The printer contains fonts for code pages&colon.
:xmp.
         437    863
         850    865
         860
:exmp.
:eul.
.**********************************************************************
:h2 res=323.Help for Default Font
:i2 refid=pp_push.default font
:p.Select :hp2.Default Font:ehp2.
to select a font for
a :link reftype=hd res=450.graphics&rbl.data:elink. job that does not
already have a font selected, and for
:link reftype=hd res=450.raw&rbl.data:elink. jobs.
:p.Related Information&colon.
:p.:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.**********************************************************************
:h2 res=325.Help for Form Connections
:i2 refid=pp_push.form connections pushbutton
:p.Select :hp2.Form Connections:ehp2.
to cause a window to appear in which you indicate the form or forms
present in each paper source on the printer.
:p.Related Information&colon.
:p.:link reftype=hd res=15202.Printer&rbl.messages:elink.
.**********************************************************************
.* Download code page pushbutton
.**********************************************************************
:h2 res=329.Help for Code Pages
:i2 refid=pp_push.code pages pushbutton
:p.Select :hp2.Code Pages:ehp2.
to indicate :link reftype=hd res=17062.code&rbl.pages:elink.
that can be downloaded to printer
memory, if required by a print job.
.**********************************************************************
:h2 res=1090.Help for OK
:p.Select :hp2.OK:ehp2. to send any changed information to the
:link reftype=hd res=17169.printer&rbl.driver:elink., then close the window.
.**********************************************************************
:h2 res=1091.Help for Cancel
:p.Select :hp2.Cancel:ehp2. if you decide not to change the current settings.
.**********************************************************************
.*
.*  HELP FOR JOB PROPERTIES DIALOGS
.*
.*  INCLUDE THE JOB PROPERTIES DDK42XX EXTENSIONS
.*
.**********************************************************************
:h1 res=207.Help for Job Properties
:i1 id=job.job properties
:p.Use the Job Properties window to specify the setup for each print
job.  These values can override the default print-job
setup defined in the printer properties window.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=402.Orientation:elink.
:li.:link reftype=hd res=401.Resolution:elink.
:li.:link reftype=hd res=404.Form&rbl.Configuration:elink.
:li.:link reftype=hd res=405.Select&rbl.Form:elink.
.* LEXMARK 5 change 406 to 411
:li.:link reftype=hd res=411.First&rbl.Page:elink.
:li.:link reftype=hd res=406.Rest&rbl.of&rbl.Document:elink.
:li.:link reftype=hd res=403.Default&rbl.Font:elink.
:li.:link reftype=hd res=1092.OK:elink.
:li.:link reftype=hd res=1093.Cancel:elink.
:eul.
:p.Related Information&colon.
:p.:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.**********************************************************************
.* JOB PROPERTIES COMMON HELP
.**********************************************************************
:h2 res=401.Help for Resolution
:i2 refid=job.resolution
:p.Select the number, in dots-per-inch (dpi) increments,
that represents the
:link reftype=hd res=17177.resolution:elink.
in which you want graphics produced on your printer.  The printers process
:link reftype=hd res=17580.device&rbl.fonts:elink.
in the highest available resolution, and can mix high resolution text
with lower resolution graphics.
:p.Select the highest number
for the best quality.  Because printing high resolution takes longer,
you can reserve this setting
for final documents.  Select a low number to print faster; for example, to produce
drafts of documents.
:p.This option only applies to
:link reftype=hd res=450.graphics&rbl.data:elink. jobs.  It does not apply to
:link reftype=hd res=450.raw&rbl.data:elink. jobs.
:p.Related Information&colon.
:p.:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.**********************************************************************
:h2 res=402.Help for Orientation
:i2 refid=job.orientation
:p.Select :hp2.Portrait:ehp2. (upright) to
print with
the top of the printed material in the same
direction as the top of the
paper.  Letters, books, and reports usually have
portrait orientation.
:p.Select :hp2.Landscape:ehp2. (rotated) to
print perpendicular to the
direction in which the paper is fed.  Landscape is frequently selected
for documents such as spreadsheets or
plotted graphics, which are wider than they are long.
:p.This option only applies
to :link reftype=hd res=450.graphics&rbl.data:elink. jobs.  It does
not apply to :link reftype=hd res=450.raw&rbl.data:elink. jobs.
:p.Related Information&colon.
:p.:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.**********************************************************************
:h2 res=403.Help for Default Font
:i2 refid=job.default font
:p.The list shows the fonts available on your printer.  Select a font
to use for a
:link reftype=hd res=450.graphics&rbl.data:elink. job that does not already have
a font selected, and for
:link reftype=hd res=450.raw&rbl.data:elink. jobs.  You
can scroll the list to see more fonts.
Select :hp2.System Font:ehp2. to use
a :link reftype=hd res=17110.font:elink.
supplied by the operating system.  For raw
data jobs, which cannot use :link reftype=hd res=17193.system&rbl.fonts:elink.,
the :link reftype=hd res=17169.printer&rbl.driver:elink.
substitutes the first
device font in the :hp2.Default Font:ehp2. list.  Select any other typeface
to use a :link reftype=hd res=17580.device&rbl.font:elink..
:p.:hp2.Code Pages:ehp2.&colon.
The :link reftype=hd res=17062.code&rbl.page:elink. used for
printing is the current system code page
or a code page selected by the program.  Fonts listed with no
code page number are supported in all
:link reftype=hd res=5022.OS/2*:elink. operating system
code pages.  Fonts listed with a
code page number are only supported for that code page.
:p.Related Information&colon.
:p.:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.**********************************************************************
.* LEXMARK 5 change: remove (4224 printers)
:h2 res=404.Help for Form Configuration
.*
:i2 refid=job.form configuration
:i2 refid=job.single form job
:i2 refid=job.dual form job
:p.Select one :link reftype=hd res=17245.radio&rbl.button:elink.
to indicate the number of different
forms used by the job.  Select :hp2.Single Form:ehp2.
if your entire job prints on the
form you select in the :hp2.Select Form:ehp2. list.  Select
:hp2.Dual Form:ehp2. if your
job uses two types of forms.  Selecting :hp2.Dual Form:ehp2. causes
two additional lists to appear, in which you select the form
for the first page, and a different form for subsequent pages.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=405.Select&rbl.Form:elink.
:li.:link reftype=hd res=411.First&rbl.Page:elink.
:li.:link reftype=hd res=406.Rest&rbl.of&rbl.Document:elink.
:eul.
.**********************************************************************
:h3 res=405.Help for Select Form
:i2 refid=job.single form job - select form
:i2 refid=job.select form
:p.This list contains all the forms defined for this
printer.  You can
scroll the list to see more form names.  Select the
form on which your job should print.
.*************************
:h3 res=411.Help for First Page
:i2 refid=job.dual form job - first page
:i2 refid=job.first page
:p.This list contains all the forms defined for this
printer.  You can
scroll the list to see more form names.  Select the
form on which the first page of your job should print.
.********************
:h3 res=406.Help for Rest of Document
:i2 refid=job.dual form job - rest of document
:i2 refid=job.rest of document
:p.This list contains all the forms defined for this
printer.  You can
scroll the list to see more form names.  Select the
form on which all pages after the first page
of your job should print.
.**********************************************************************
:h2 res=1092.Help for OK
:p.Select :hp2.OK:ehp2. to send any changed information to the
program, then close the window.
.**********************************************************************
:h2 res=1093.Help for Cancel
:p.Select :hp2.Cancel:ehp2. if you decide not to change the current settings.
.**********************************************************************
.*
.*  HYPERTEXT LINKING TO TEXT FOR DEFINITIONS OF RAW AND GRAPHICS DATA
.*
.**********************************************************************
:h1 res=450.Help for Job Types
:i1.job types
:i1.graphics data jobs
:i1.raw data jobs
:p.The effect of printer or job properties on a job depends
on the job type&colon.
:hp1.Graphics data jobs:ehp1. are created by
:link reftype=hd res=5022.Presentation&rbl.Manager*:elink.
programs and typically have a graphical content.
:hp1.Raw data jobs:ehp1. are initiated by
:link reftype=hd res=5022.OS/2*:elink. operating system commands such as&colon.
:xmp.
     PRINT SCREEN key
     COPY /B <file> LPT1
     PRINT <file>
:exmp.
:p.Raw data jobs typically consist of Personal Printer Data Stream (PPDS)
commands.
:p.The following table lists which printer properties or job properties are
honored by each type of job.
:xmp.
                       Graphics        Raw
    Properties         Data Jobs    Data Jobs
  
    Resolution            Yes          No
    Orientation           Yes          No
    Default font          Yes          Yes
    Form feed control     No           Yes
    Form length           Yes          Yes
    Form width            Yes          No
    Form clipping         Yes          No
:exmp.
.**********************************************************************
.*
.*  HELP FOR FORMS AND CONNECTIONS
.*
.**********************************************************************
:h1 res=218.Help for Form Connections
:i1 id=fcon.form connections
:p.Use the Form Connections window to indicate what type of form
is loaded in each of your printer's automatic paper-source feeds,
and which forms, if any, you intend to feed manually.
:ol compact.
:li.Select a :hp2.Paper Source:ehp2. from the list.
:li.Select one (automatic feed) or more (manual feed) forms from the
:hp2.Available Forms:ehp2. list.
:li.Select :hp2.OK:ehp2..
:eol.
.* LEXMARK 5 added lines until next "LEXMARK 5 add ends here" reached
:nt.When using an :link reftype=hd res=5022.IBM*:elink.
:link reftype=hd res=5022.ExecJet*:elink. Printer different forms should be
set to different physical positions on the printer.  Forms A4 and A5 should
be lined up with the A4 mark on the printer.  Forms B4 and B5 should be lined
up with the B4 mark on the printer.  Envelopes should be lined up with the
envelope mark on the printer.  All other forms should be lined up with the
LTR&slash.LGL mark on the printer.
:ent.
.* LEXMARK 5 add ends here
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=219.Paper&rbl.Source:elink.
:li.:link reftype=hd res=247.Available&rbl.Forms:elink.
:li.:link reftype=hd res=1094.OK:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
.**********************************************************************
:h2 res=219.Help for Paper Source
:i2 refid=fcon.paper source
:p.This list shows the paper sources you can have with your
printer.  The items listed
depend on your printer, as well as the :hp2.Paper Sources:ehp2.
you select in the printer properties window.  Select
a type of paper source, then select
the forms loaded in that paper source from the
:hp2.Available Forms:ehp2. list.
:nt.Depending upon the printer model you have, your
printer might have manual
sources, document insertion devices, or a fourth bin.  For
each of these, the paper and envelope sources are the same physical
source on the printer, but have different selections from the
:hp2.Available Forms:ehp2. list.   If
a job requests a form associated with a manual source, insertion device,
or bin 4,
you are prompted to insert that form when the system is ready to
print the job.
:ent.
.**********************************************************************
:h2 res=247.Help for Available Forms
:i2 refid=fcon.available forms
:p.This list shows the forms that can be fed from the selection
in the :hp2.Paper Source:ehp2. list.  You
can scroll the list to see more forms.
:p.For a source that feeds paper automatically,
select, from the :hp2.Available Forms:ehp2. list,
the choice that identifies the form loaded in your printer's
paper source.  Depending upon your printer, any
of the following automatic paper sources might be available in
the :hp2.Paper Source:ehp2. list&colon.
Pinwheel/Sheet Feed,
.* LEXMARK 5 add
Tray 1 - Paper/Envelope, Tray 2 - Paper, Paper Tray,
.*
Continuous Forms Device,
Document on Demand Device, Bin 1, 2, or 3.
:p.For manual-feed paper sources,
you can select more than one form in the :hp2.Available Forms:ehp2.
list.  If a job requests a form associated with a
manual-feed source, you are prompted to insert that form when the
system is ready to print the job.  Depending upon your printer, any
of the following manual sources might be available in
the :hp2.Paper Source:ehp2. list&colon.
:ul compact.
:li.Manual Paper
:li.Manual Envelope
:li.Document Insertion Device
:li.Bin 4.
:eul.
:p.Only paper forms are listed if you select Pinwheel/Sheet Feed,
.* LEXMARK 5 add
Tray 2 - Paper, Paper Tray,
.*
Continuous
Forms device, Document on Demand Device, Document Insertion Device,
Manual Paper Source, or Bin 1, 2, 3, or 4 in the :hp2.Paper
Source:ehp2. list.
:p.Only envelope forms are listed if you select a Manual Envelope source
in the :hp2.Paper Sources:ehp2. list.


:h2 res=1094.Help for OK
:p.Select :hp2.OK:ehp2. to keep any changed information,
then close the window.
:nt.You must select :hp2.OK:ehp2. when exiting the printer properties window
to send any changed information to the
:link reftype=hd res=17169.printer&rbl.driver:elink..
:ent.
.**********************************************************************
.*:h1 res=1091.Help for Cancel
.**********************************************************************
.*
.* HELP FOR ADD AND CHANGE FORM DIALOGS WHEN THE FORM SIZE IS VARIABLE
.*
.**********************************************************************
:h1 res=213.Help for Add Form
:i1 id=aform.add form
:p.Use the Add Form window to define a new form.  The printer
accepts forms of any size and any width within the printer's
physical limits.  The clip limits define the print
area on the form.
:p.To add a form&colon.
:ol compact.
:li.Select a form template.  This sets the units
(inches or millimeters) and the form type (paper or envelope).
:li.Type a form name.
:li.Change the paper width and height, if necessary.
:li.Change the clip limits, if necessary.
:li.Select :hp2.OK:ehp2..
:eol.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=248.Form&rbl.Name:elink.
:li.:link reftype=hd res=249.Paper&rbl.Width:elink.
:li.:link reftype=hd res=250.Paper&rbl.Height:elink.
:li.:link reftype=hd res=251.Left&rbl.Clip&rbl.Limit:elink.
:li.:link reftype=hd res=252.Right&rbl.Clip&rbl.Limit:elink.
:li.:link reftype=hd res=253.Bottom&rbl.Clip&rbl.Limit:elink.
:li.:link reftype=hd res=254.Top&rbl.Clip&rbl.Limit:elink.
:li.:link reftype=hd res=255.OK:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
.**********************************************************************
:h1 res=215.Help for Change Form
:i1 id=cform.change form
:p.Use the Change Form window to change the name, size, and print area
of a user-defined
form. :p.To change a form definition&colon.
:ol compact.
:li.Select a form template.  This sets the units
(inches or millimeters) and the form type (paper or envelope).
:li.Change the form name.
:li.Change the paper width and height.
:li.Change the clip limits.
:li.Select :hp2.OK:ehp2..
:eol.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=248.Form&rbl.Name:elink.
:li.:link reftype=hd res=249.Paper&rbl.Width:elink.
:li.:link reftype=hd res=250.Paper&rbl.Height:elink.
:li.:link reftype=hd res=251.Left&rbl.Clip&rbl.Limit:elink.
:li.:link reftype=hd res=252.Right&rbl.Clip&rbl.Limit:elink.
:li.:link reftype=hd res=253.Bottom&rbl.Clip&rbl.Limit:elink.
:li.:link reftype=hd res=254.Top&rbl.Clip Limit:elink.
:li.:link reftype=hd res=255.OK:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
.**********************************************************************

:h2 res=248.Help for Form Name
:i2 refid=aform.form name
:i2 refid=cform.form name
:p.
Form names must be unique and cannot contain
an asterisk (*), semi-colon (;), or equals sign (=).  Commas (,) also are
invalid unless used as the decimal point character in your country
settings.
.**********************************************************************

:h2 res=249.Help for Paper Width
:i2 refid=aform.paper width
:i2 refid=cform.paper width
:p.The :hp2.Width:ehp2. field shows the preselected value for
the horizontal measurement of the
form.  Change this value if your form has a different width.
:p.Related Information&colon.
:p.:link reftype=hd res=450.Job&rbl.Types:elink.
.**********************************************************************

:h2 res=250.Help for Paper Height
:i2 refid=aform.paper height
:i2 refid=cform.paper height
:p.The :hp2.Height:ehp2. field shows the preselected value for
the vertical measurement of the form.  Change
this value if your form has a different height.
:p.Related Information&colon.
:p.:link reftype=hd res=450.Job&rbl.Types:elink.
.**********************************************************************

:h2 res=251.Help for Left Clip Limit
:i2 refid=aform.left clip limit
:i2 refid=cform.left clip limit
:p.The :hp2.Left Clip Limit:ehp2. field shows the amount of
space that the printer skips at the left side of the page.
:p.Related Information&colon.
:p.:link reftype=hd res=450.Job&rbl.Types:elink.
.**********************************************************************

:h2 res=252.Help for Right Clip Limit
:i2 refid=aform.right clip limit
:i2 refid=cform.right clip limit
:p.The :hp2.Right Clip Limit:ehp2. field shows the point, measured from
the left edge of the paper, beyond which the printer does not print.
.*********** NOTE TO TRANSLATION *******************
.* SUBSTITUTE THE FOLLOWING FOR THE NEXT 3 PARAGRAPHS
.* IN COUNTRIES THAT USE METRIC MEASUREMENT UNITS
.* :p.The :link reftype=hd res=5022.IBM*:elink. 2380
.* :link reftype=hd res=5022.Personal Printer Series II*:elink.,
.* IBM 2390 Personal Printer Series II, IBM 2390 PS/1, IBM
.* :link reftype=hd res=5022.Proprinter*:elink., Proprinter II,
.* III, X24, and X24E have a maximum right clip limit of 204.8 millimeters.  Thus, a
.* form that is 217.6 by 281.6 millimeters has a print area of
.* 204.8 by 281.6 millimeters."
.* :p.The IBM 2381 Personal Printer Series II, IBM 2391 Personal Printer
.* Series II, IBM 4226 Model 302, IBM Proprinter XL, II&rbl.XL, III&rbl.XL, XL&rbl.24 and
.* XL&rbl.24E have a maximum right clip limit of 348.16 millimeters.  Thus, a form that is
.* 358.4 by 281.6 millimeters has a print area of 348.16 by 281.6 millimeters.
.*:p.The IBM 4224 printer (models 3C2, 301, 302, and 3E3) has a maximum right clip
.*limit of 337.92 millimeters.
.****************************************************
:p.The :link reftype=hd res=5022.IBM*:elink. 2380 Personal Printer Series II,
.* LEXMARK 5 change: add IBM 2390 PS/1
IBM 2390 Personal Printer Series II, IBM 2390 PS/1, IBM
:link reftype=hd res=5022.Proprinter*:elink., Proprinter II,
III, X24, and X24E have a maximum right clip limit of 8.0 inches.  Thus, a
form that is 8.5 by 11.0 inches has a print area of
8.0 by 11.0 inches.
:p.The IBM 2381 Personal Printer Series II, IBM 2391 Personal Printer
Series II, IBM 4226 Model 302, IBM Proprinter XL, II&rbl.XL, III&rbl.XL, XL24 and
XL24E have a maximum right clip limit of 13.6 inches.  Thus, a form that is
14.87 by 11.0 inches has a print area of 13.6 by 11.0 inches.
:p.The IBM 4224 printer (models 3C2, 301, 302, and 3E3) has a maximum right clip
limit of 13.2 inches.
:p.Related Information&colon.
:p.:link reftype=hd res=450.Job&rbl.Types:elink.
.**********************************************************************

:h2 res=253.Help for Bottom Clip Limit
:i2 refid=aform.bottom clip limit
:i2 refid=cform.bottom clip limit
:p.The :hp2.Bottom Clip Limit:ehp2. field shows the amount of
space that the printer leaves on the bottom of a page.
:p.Related Information&colon.
:p.:link reftype=hd res=450.Job&rbl.Types:elink.
.**********************************************************************

:h2 res=254.Help for Top Clip Limit
:i2 refid=aform.top clip limit
:i2 refid=cform.top clip limit
:p.The :hp2.Top Clip Limit:ehp2. field shows the point, measured
from the bottom edge of the paper, above which the printer does not print.
:p.The :link reftype=hd res=5022.IBM*:elink. 4224 Printer (Models 3C2, 301, 302, and 3E3)
enforces a nonprintable area at the
top of each form.  This margin varies according to the paper source
attached&colon.
.*********** NOTE TO TRANSLATION *******************
.* SUBSTITUTE THE FOLLOWING FOR THE :UL. LIST BELOW
.* IN COUNTRIES THAT USE METRIC MEASUREMENT UNITS
.*
.*:ul compact.
.*:li.The Continuous Forms Device has no top margin.
.*:li.The Document on Demand Device has a 15.87-millimeter top margin.
.*:li.Document Insertion Devices and Bins 1, 2, 3, and 4 have a
.*12.8-millimeter top margin.
.*:eul.
.******************************************************
:ul compact.
:li.The Continuous Forms Device has no top margin.
:li.The Document on Demand Device has a 0.62-inch top margin.
:li.Document Insertion Devices and Bins 1, 2, 3, and 4 have a 0.5-inch top margin.
:eul.
:p.Related Information&colon.
:p.:link reftype=hd res=450.Job&rbl.Types:elink.
.**********************************************************************
:h2 res=255.Help for OK
:i2 refid=aform.OK pushbutton
:i2 refid=cform.OK pushbutton
:p.Select :hp2.OK:ehp2. to add or change a form,
then close the window.  When you select :hp2.OK:ehp2., the
:link reftype=hd res=17169.printer&rbl.driver:elink. checks the values
specified to ensure they comply with the form name and clip-limit rules
for your printer.
:nt.You must select :hp2.OK:ehp2. when exiting the printer properties window
to send any changed information to the printer driver.
:ent.
.**********************************************************************
.*:h1 res=1091.Help for Cancel
.**********************************************************************
.*
.*  HELP FOR DOWNLOAD CODEPAGES
.*
.**********************************************************************
:h1 res=236.Help for Downloadable Code Pages (Proprinters)
:i1 id=downcps.downloadable code pages
:p.Use this window to select a
:link reftype=hd res=17062.code&rbl.page:elink. for a
print job.  The selected code page
is downloaded (copied to printer memory) when the first job
is printed and
remains downloaded for subsequent print jobs.  You use
the :link reftype=hd res=17240.pushbuttons:elink.
along the bottom of the window to add code pages to the list.
The remainder of the code pages, though not selected in this window,
are downloaded when requested by a print job.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=256.Number&rbl.and&rbl.Name:elink.
:li.:link reftype=hd res=1094.OK:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:li.:link reftype=hd res=257.Add:elink.
:li.:link reftype=hd res=258.Remove:elink.
:li.:link reftype=hd res=259.Reload:elink.
:eul.
:p.Related Information&colon.
:ul compact.
:li.:link reftype=hd res=17500.Memory,&rbl.code&rbl.page,&rbl.and&rbl.font&rbl.availability:elink.
:li.:link reftype=hd res=17501.Downloadable&rbl.code-page&rbl.files:elink.
:eul.
.**********************************************************************
:h2 res=17501.Downloadable Code-Page Files
:i2 refid=downcps.downloadable code-page files
:p.A file is needed to specify the downloadable
.* LEXMARK 5 change: added :elink.
:link reftype=hd res=17062.code&rbl.page.:elink.  The file for
.*
each downloadable code page is
.* LEXMARK 5 change: printer to Proprinter
supplied on the :link reftype=hd res=5022.Proprinter*:elink.
.*
NLS (National Language Support) diskettes.

.**********************************************************************
:h2 res=17500.Memory, Code page, and Font Availability
:i2 refid=downcps.memory, code page, and font availability
:ul compact.
:li.Proprinter&colon. Memory for downloading
is not available as an option in
the U.S. and Canada, but is standard in other countries.  Memory
is required to download code pages other than 437.
:li.Proprinter XL&colon. Memory is standard on all printers; and all
available code pages can be downloaded.
:li.Proprinter II, II&rbl.XL&colon.  Optional memory is required to download
the NLQ II font for code pages other than 437.  Optional memory is not
required to download any other fonts.
:li.Proprinter III, III&rbl.XL&colon.  Optional memory is required to download
the NLQ II and Courier Italic fonts for code pages other than 437.  Optional
memory is not required to download any other fonts.
:li.Proprinter X24, XL24&colon.  Optional memory
is required to download code pages other than 437.
:li.Proprinter X24E, XL24E&colon.  Optional memory
is required to download code pages other than
437 and 850.
:eul.
.**********************************************************************
:h2 res=256.Help for Number and Name
:i2 refid=downcps.number and name
:p.Use this field to select
:link reftype=hd res=17062.code&rbl.pages:elink. that your print job
uses most frequently.   This field lists the code pages
currently available
for use.  Each code page has an identifier in the :hp2.Number:ehp2. column and
is described in the :hp2.Name:ehp2. column.  You can scroll the
list to see more code pages.
.**********************************************************************
:h2 res=257.Help for Add
:i2 refid=downcps.add pushbutton
:p.Select :hp2.Add:ehp2. to add new downloadable
:link reftype=hd res=17062.code&rbl.pages:elink. to the list in the
of Downloadable Code Pages window.  The window appears that lists the
code pages you can add.  You need the
NLS (National Language Support) diskette containing the file for the
code page you want to add.
.**********************************************************************
.*:h1 res=1091.Help for Cancel
.**********************************************************************
:h2 res=258.Help for Remove
:i2 refid=downcps.remove pushbutton
:p.Select :hp2.Remove:ehp2. to remove downloadable
:link reftype=hd res=17062.code&rbl.pages:elink. from
the list in the Downloadable Code Pages window.  If you remove
a code-page number and name from the list, your print jobs can no longer
use that code page.
.**********************************************************************
:h2 res=259.Help for Reload
:i2 refid=downcps.reload pushbutton
:p.
If printer power is off, printer memory does not retain downloaded
:link reftype=hd res=17062.code-page:elink.
information.  Select :hp2.Reload:ehp2. to download (copy to printer
memory) the selected code page.
.**********************************************************************
:h1 res=237.Help for Add a Code Page
:i2 refid=downcps.add a code page
:p.Use this window to add a downloaded
:link reftype=hd res=17062.code&rbl.page:elink. supported for
your printer.
:ol compact.
:li.Select the code page you want from the list.
:li.Select the :hp2.Add:ehp2. pushbutton.
:li.Select :hp2.OK:ehp2. in the printer properties window
when exiting printer-driver setup.
:eol.
:p.For information about which printer models support different code pages, select
the "Related Information" topic listed below.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=260.Number&rbl.and&rbl.Name:elink.
:li.:link reftype=hd res=345.Add:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
:p.Related Information&colon.
:p.:link reftype=hd res=17500.Memory,&rbl.code&rbl.page,&rbl.and&rbl.font&rbl.availability:elink.
.**********************************************************************
:h2 res=260.Number and Name
.*Add a Code Page window
:p.Use this field to select a downloadable
:link reftype=hd res=17062.code&rbl.page:elink.
for your printer.  Each code page has an identifier in the :hp2.Number:ehp2. column and
is described in the :hp2.Name:ehp2. column.  You can scroll the list
to see more code pages.  Select the code page
you need, then select the :hp2.Add:ehp2. pushbutton.
For information about which printer models support different
code pages, select the "Related Information" topic listed below.
:p.Related Information&colon.
:p.:link reftype=hd res=17500.Memory,&rbl.code&rbl.page,&rbl.and&rbl.font&rbl.availability:elink.
.**********************************************************************
:h2 res=345.Help for Add
.*Add a Code Page window
:p.Select :hp2.Add:ehp2. to add new downloadable
:link reftype=hd res=17062.code&rbl.pages:elink..  A window
appears in which you specify the location of the downloadable code-page files.

.*:h1 res=1091.Help for Cancel
.**********************************************************************
:h1 res=238.Help for Code Page Source Path
:i2 refid=downcps.add code page source path
:p.The field in this window shows the
:link reftype=hd res=17034.default:elink.
:link reftype=hd res=17202.path:elink. where the downloadable
:link reftype=hd res=17062.code-page:elink. files are stored.
:ol compact.
:li.Insert the requested NLS diskette in drive A, or change the path
specified in this field.
:li.Select :hp2.Add:ehp2..
:eol.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=261.Source&rbl.Path:elink.
:li.:link reftype=hd res=346.Add:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
:p.Related Information&colon.
:p.
:link reftype=hd res=17501.Downloadable&rbl.code-page&rbl.files:elink.
.**********************************************************************
:h2 res=261.Help for Source Path
.*field in Add Code Page Source Path window
.*:i2 not needed
:p.This field shows the
:link reftype=hd res=17202.path:elink. where the downloadable
:link reftype=hd res=17062.code-page:elink. files are stored.  The
initial value is :hp1.A&colon.&bslash.:ehp1..  You can change this
value if the files are stored
somewhere else.
.**********************************************************************
:h2 res=346.Help for Add
:p.Select :hp2.Add:ehp2. to add new downloadable
:link reftype=hd res=17062.code&rbl.pages:elink..  A window
appears in which you can select the location where you want to
store the downloadable code-page file.
.**********************************************************************
.*:h2 res=1091.Help for Cancel
.**********************************************************************
:h1 res=239.Help for Code Page Target Path
:i2 refid=downcps.add code page target path
:p.
:p.Use this window to indicate the
:link reftype=hd res=17202.path:elink.
where you want to store the downloadable
:link reftype=hd res=17062.code-page:elink. files.
:ol compact.
:li.Change the path in the target-path field, if necessary.
:li.Select :hp2.Copy:ehp2..
:eol.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=347.Target&rbl.Path:elink.
:li.:link reftype=hd res=262.Copy:elink.
:li.:link reftype=hd res=263.Don't&rbl.Copy:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
:p.Related Information&colon.
:p.
:link reftype=hd res=17501.Downloadable code-page&rbl.files:elink.

:h2 res=347.Help for Target Path
.*field in Code Page Target Path window
.*:i2 not needed
:p.This field shows the
:link reftype=hd res=17034.default:elink.
:link reftype=hd res=17202.path:elink. where
downloadable code-page files will be stored.  If
you want to store the files somewhere
else, change the value in this field to the correct path.
:nt.If the path you select is on a diskette,
you must insert that diskette in
the diskette drive whenever you print a job.
:ent.

:h2 res=262.Help for Copy
.*Add Code Page Target Path window
.*:i2 not needed
:p.Select :hp2.Copy:ehp2.
to have the downloadable code-page files copied to the target
:link reftype=hd res=17202.path:elink.,
and to add the :link reftype=hd res=17062.code&rbl.page:elink. number
and name to the list in the Downloadable Code Pages window.

:h2 res=263.Help for Don't Copy
.*Add Code Page Target Path window
.*:i2 not needed
:p.Select :hp2.Don't Copy:ehp2.
to add the
:link reftype=hd res=17062.code&rbl.page:elink.
to the list in the Downloadable Code Pages
window without
copying downloadable code-page files to the target path.  Select
this only if the source :link reftype=hd res=17202.path:elink.
is a hard disk on your system.
.**********************************************************************
.*:h1 res=1091.Help for Cancel
.**********************************************************************
:h1 res=240.Help for Remove Code Pages
:i2 refid=downcps.remove code pages
:p.Use this window to delete from the list, all the downloadable
:link reftype=hd res=17062.code&rbl.pages:elink.
your print jobs do not use.
:ol compact.
:li.Select a code page you want to remove.
:li.Select :hp2.Remove:ehp2..
:li.Select
the :hp2.OK:ehp2. pushbutton when exiting the
printer-properties window to save the code page list revisions.
:eol.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=264.Remove&rbl.Code&rbl.Pages&rbl.List:elink.
:li.:link reftype=hd res=265.Remove:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
.**********************************************************************
:h2 res=264.Help for Remove Code Pages List
.*field in Remove Code Pages window
.*:i2 not needed
:p.This field shows all of the downloadable
:link reftype=hd res=17062.code&rbl.pages:elink. currently
available for use by print jobs.  You can scroll
the list to see others.  Select
the downloadable code pages you want to remove from the list.
.**********************************************************************
:h2 res=265.Help for Remove
.*pushbutton in Remove Code Pages window
.*:i2 not needed
:p.Select :hp2.Remove:ehp2. to remove the
selected downloadable
:link reftype=hd res=17062.code&rbl.page:elink. from the list in the
Downloadable Code Pages window.
.**********************************************************************
.*:h1 res=1091.Help for Cancel
.**********************************************************************
:h1 res=241.Help for Reload Code Page
:i2 refid=downcps.reload code page
:p.Use this window to reload a
:link reftype=hd res=17062.code&rbl.page:elink.
that was erased because
the printer power went off.
:ol compact.
:li.Select :hp2.Reload:ehp2. to have the
code page downloaded (copied) to printer memory
at the start of every print job.
:li.Select the :hp2.OK:ehp2. pushbutton when exiting
the printer properties window when you finish printer-driver setup.
:eol.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=348.Number&rbl.and&rbl.Name:elink.
:li.:link reftype=hd res=266.Per&rbl.Job&rbl.Download:elink.
:li.:link reftype=hd res=267.Reload:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.

:h2 res=348.Help for Number and Name
:p.This field shows the
:link reftype=hd res=17062.code&rbl.page:elink. to reload.  The code page
has an identifier in the :hp2.Number:ehp2. column and
is described in the :hp2.Name:ehp2. column.

:h2 res=266.Help for Per Job Download
:p.Use the :hp2.Per Job Download:ehp2.
:link reftype=hd res=17245.radio&rbl.buttons:elink. to indicate when the
:link reftype=hd res=17169.printer&rbl.driver:elink. is to download
the initial downloadable code page.  The code page is downloaded either&colon.
:ul compact.
:li.At the start of the first print job only, or
:li.At the start of every print job.
:eul.

:h2 res=267.Help for Reload
:p.Select :hp2.Reload:ehp2. to download the specified
:link reftype=hd res=17062.code&rbl.page:elink. into printer memory when
the next print job prints.
.*
.**********************************************************************
.*
.*  INCLUDE THE DEFAULT FONT HELP
.*
.**********************************************************************
:h1 res=222.Help for Available Default Fonts
:i1.default fonts
:i2 refid=soft_config.default fonts
:p.Use this window to can select the font to
use for a
:link reftype=hd res=450.graphics&rbl.data:elink. job that does not
already have
a font selected, and for
:link reftype=hd res=450.raw&rbl.data:elink. jobs.
:p.For a detailed explanation of each field, select from the list below&colon.
:ul compact.
:li.:link reftype=hd res=403.Default&rbl.Font:elink.
:li.:link reftype=hd res=1094.OK:elink.
:li.:link reftype=hd res=1091.Cancel:elink.
:eul.
:p.Related Information&colon.
:p.:link reftype=hd
res=15121.Printer,&rbl.queue,&rbl.and&rbl.program&rbl.job-properties&rbl.setup:elink.
.**********************************************************************

.*:h1 res=1090.Help for OK
.*:h1 res=1091.Help for Cancel

.************GLOSSARY & CONCEPTUAL HELPS ****************
.im prdgloss.ipf
.**********************************************************************
.*****************************************************************************
.* These are the common files to each driver help
.*****************************************************************************
.im prdcommn.ipf
.*****************************************************************************
:h1 res=15121 hide.Printer, Queue, and Program Job-Properties Setup
:p.Those properties, which give a print job such characteristics as
resolution, orientation, form, and font, can derive from three different
sources&colon.
:ul compact.
:li.If you submit a job (for example, from a DOS session) that does not
have program-specific characteristics, and does not
take on the job properties of its
:link reftype=hd res=17242.queue:elink.,
the job is printed with the job properties you specified in the
printer properties window during
:link reftype=hd res=17169.printer-driver:elink. setup.
:li.If you submit a job (for example, from a
:link reftype=hd res=5022.Presentation&rbl.Manager*:elink.
program) that does not specify print-job characteristics,
but does take on characteristics from its queue,
the job is printed with the job properties you specified
for that queue.
:li.If your program enables you to set up job properties
for a specific print file, the job is printed with those
characteristics.  Program-specified job properties
override defaults of either queue or printer properties.
:eul.
.***************************************************************************
:h1 res=15202 hide.Printer Messages
:p.For those model printers that support various paper sources and forms,
the system issues a :hp1.Forms Mismatch:ehp1. error message, and prevents a job from printing
if the form selected for the job is not also selected in the Form Connections
window.  Load the appropriate form for the job, then access the
:link reftype=hd res=17169.printer-driver:elink.
:hp2.Form Connections:ehp2. window, changing the selection there
to match the form required by the waiting job.
.****************************************************************************

:h1 res=15203 hide.Unattended Printer Operation
:p.To maintain unattended operation of your printer,
do not select manual paper or manual envelope paper
sources; otherwise, the :link reftype=hd res=17169.printer&rbl.driver:elink.
might issue a prompt for a form, and operator intervention will be required.

.**********************************************************************
:h1 res=15204 hide.Help Version
.* LEXMARK 5 change 1.211 to 1.217
:p.This is the DDK42XX help version 1.217.
.*

.**********************************************************************
:h1 res=15205 hide.Printer Settings
:p.To avoid printer errors, set up your printer as follows&colon.
:ul compact.
:li.If you have one of the :link reftype=hd res=5022.IBM*:elink.
4224 Printer models,
at the printer's operator
panel, set the
Characters-per-inch setting to 10 CPI,
and the Condensed Print Selection to 16.7 CPI.  Consult
the information that comes with your printer for
instructions in operating the panel.
:li.When using the sheet-feeder option with the IBM
:link reftype=hd res=5022.Proprinter*:elink. III, III&rbl.XL, X24,
XL24, X24E, and XL24E, set up your printer and sheet feeder as described
in the information supplied with your sheet feeder.
.* LEXMARK 5 change: move "or" to after 4226
:li.If you have an IBM 2380, 2381, 2390, 2391, 4226 or
.* LEXMARK 5 add
:link reftype=hd res=5022.ExecJet*:elink.
.*
Printer,
do :hp1.not:ehp1. lock the font or pitch
at the operator panel on the printer.
:li.If you have an IBM Proprinter X24, XL24, X24E, XL24E, or an IBM 2390
or 2391 Printer, turn :hp1.off:ehp1. the Alternate Graphics Mode on your
printer.  For a detailed explanation refer to the printer&apos.s operator
manual.
:eul.

:euserdoc.

