;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
.386p
INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

EXTRN   IDC_ENTRY:FAR                ; IDC Entry Point
;*********************************************
; Define the C calling macros
LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm
;*********************************************

MAIN            EQU     1             ; used in ssmdd.inc
.xlist
        include devsym.inc
        include basemaca.inc
        include basedef.inc
        include devhlp.inc
        include error.inc
        include infoseg.inc

;        include ptrace.inc              ; PTRACE macros
        include os2medef.inc
        include meerror.inc
        include ssm.inc
        include shdd.inc
        include vididc.inc
        include video.inc
.list



DATA   SEGMENT  DWORD USE16 PUBLIC 'DATA'      ; changed from code to data
;        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT

ALIGN 4
        EXTRN   device_hlp:DWORD
        EXTRN   CI_Buff:DWORD         ; Address of buffer to copy image into (real time capture)


D_STIME         dd   20000h    ; Dummy Stream Time
D_STIME_RECUR   dd   0         ; must be after D_STIME  (don't Move)
D_SETIME        dd   000003E8h ; Dummy Stream Event Notify Time
D_PTIME         dd   00000000h ; Dummy Stream tick_pause Time
D_PTIME_RECUR   dd   0         ; must be after D_PTIME  (don't Move)
D_ER            dd   00000000h ; Dummy Number of Event Reported
D_RIcount     dd   0         ; Dummy  Count Images Read
d_STATTIME    dd   0         ; Dummy  Time from Status
d_CurrTime    dd   0         ; Dummy  Time last image was read
CI_BUFF2      dd   0         ; Second Streaming Buffer (test Code Only)
CI_BUFF       dd   0         ; First  Streaming Buffer (test Code Only)

IDC     equ   es:[bx]                 ; Pointer to IDC Request packet
DATA   ENDS


_TEXT   SEGMENT  DWORD USE16 PUBLIC 'CODE'
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT



;***************************************************************************
;  Test routine for IDC calls
;
;***************************************************************************
Procedure TESTIDC,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        push  esi
        push  eax
        push  esp

        ; Create Global Fixed Buffer to copy image into at ring 0
        mov   ecx,640*480*2            ; Bytes in 640 * 480 image (max image size)
        mov     edi,-1
        ;           876543210
        mov     eax,000000010B ; Allocate in Global address space, fixed  storage
        mov     dl,DevHlp_VMAlloc
        call    device_hlp
        mov     [CI_Buff],eax           ; Save new buffers address

        sub   esp,size ddcmd_register_parm  ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].regi_ulFunction,DDCMD_REG_STREAM
        mov   ss:[esi].regi_hStream,012345678h
        mov   ss:[esi].regi_ulSysFileNum,087654321h
        mov   eax,offset TESTIDC_CB
        mov   ss:[esi].regi_pSHDEntryPoint,eax
        mov   ss:[esi].regi_pSHDEntryPoint+2,cs
        mov   ss:[esi].regi_ulStreamOperation,STREAM_OPERATION_PRODUCE
;        mov   ss:[esi].regi_spcbkey
        mov   ss:[esi].regi_ulBufSize,0
        mov   ss:[esi].regi_ulNumBufs,0
        mov   ss:[esi].regi_ulAddressType,0
        mov   ss:[esi].regi_ulBytesPerUnit,0
        mov   ss:[esi].regi_mmtimePerUnit,0
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_register_parm  ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e1
        int 3
no_e1:

        sub   esp,size ddcmd_setup_parm     ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].setu_ulFunction,DDCMD_SETUP
        mov   ss:[esi].setu_hStream,012345678h
        mov   eax,offset D_STIME
        mov   ss:[esi].setu_pSetupParm,eax
        mov   ss:[esi].setu_pSetupParm+2,ds
        mov   ss:[esi].setu_ulSetupParmSize,8
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_setup_parm     ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e2
        int 3
no_e2:

        sub   esp,size ddcmd_readwrite_parm ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].read_ulFunction,DDCMD_READ
        mov   ss:[esi].read_hStream,012345678h
        mov   eax,[CI_BUFF]
        mov   ss:[esi].read_pBuffer,eax
        mov   ss:[esi].read_ulBufferSize,640*480*2
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_readwrite_parm ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e3
        int 3
no_e3:

        ; Allocate and Initialize an IDC_SH  structure
        mov   ecx,640*480*2+(SIZE VIDEO_FRAME_HDR)*4 ; Room for 4 160*120 images with header
        mov   edi,-1
        ;         876543210
        mov   eax,000000010B   ; Allocate in Global address space, fixed  storage
        mov   dl,DevHlp_VMAlloc
        call  device_hlp

        jc    no_e4            ; Did we get the storage   Carry=1 is a failure (start with 1 buffer)

        mov   [CI_BUFF2],eax   ; Save Buffer Address

;   Don't add the same read buffer Twice!
        sub   esp,size ddcmd_readwrite_parm ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].read_ulFunction,DDCMD_READ
        mov   ss:[esi].read_hStream,012345678h
        mov   ss:[esi].read_pBuffer,eax
        mov   ss:[esi].read_ulBufferSize,640*480*2+(SIZE VIDEO_FRAME_HDR)*4
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_readwrite_parm ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e4
        int 3
no_e4:

        sub   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].cont_ulFunction,DDCMD_CONTROL
        mov   ss:[esi].cont_hStream,12345678h
        mov   ss:[esi].cont_hEvent,0
        mov   ss:[esi].cont_ulCmd,DDCMD_START
        mov   ss:[esi].cont_pParm,0
        mov   ss:[esi].cont_ulParmSize,0
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e5
        int 3
no_e5:

        sub   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].cont_ulFunction,DDCMD_CONTROL
        mov   ss:[esi].cont_hStream,12345678h
        mov   ss:[esi].cont_hEvent,88888888h
        mov   ss:[esi].cont_ulCmd,DDCMD_ENABLE_EVENT
        mov   eax,offset D_SETIME
        mov   ss:[esi].cont_pParm,eax
        mov   ss:[esi].cont_pParm+2,ds
        mov   ss:[esi].cont_ulParmSize,4
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e6
        int 3
no_e6:

        pop   esp
        pop   eax
        pop   esi
        ret

EndProc TESTIDC

;***************************************************************************
;  Test routine for IDC calls  (turn off interrupts and image copy)
;
;***************************************************************************
Procedure TESTIDC_DONE,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

   ;*********************************************
   ; Local Variables on stack

        push  esi
        push  eax
        push  esp

        sub   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].cont_ulFunction,DDCMD_CONTROL
        mov   ss:[esi].cont_hStream,12345678h
        mov   ss:[esi].cont_hEvent,88888888h
        mov   ss:[esi].cont_ulCmd,DDCMD_DISABLE_EVENT
        mov   ss:[esi].cont_pParm,0
        mov   ss:[esi].cont_ulParmSize,0
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e10
        int 3
no_e10:



        sub   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].cont_ulFunction,DDCMD_CONTROL
        mov   ss:[esi].cont_hStream,12345678h
        mov   ss:[esi].cont_hEvent,0
        mov   ss:[esi].cont_ulCmd,DDCMD_STOP
        mov   ss:[esi].cont_pParm,0
        mov   ss:[esi].cont_ulParmSize,0
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e11
        int 3
no_e11:

        sub   esp,size ddcmd_deregister_parm  ; Room for parm packet on stack
        lea   esi,[esp]                       ; Paramet Packet addr
        mov   ss:[esi].dere_ulFunction,DDCMD_DEREG_STREAM
        mov   ss:[esi].dere_hStream,012345678h
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_deregister_parm  ; Room for parm packet on stack
        or    ax,dx                           ; check RC = no error on call
        cmp   ax,0
        je    no_e12
        int 3
no_e12:

        mov     eax,[CI_Buff2]          ; Get Stream buffers # 2 address
        mov     [CI_Buff2],0            ; Zero Stream buffers # 2 address

        ; Free the IDC_SH  structure
        mov   dl,DevHlp_VMFree
        call  device_hlp


        pop   esp
        pop   eax
        pop   esi
        ret

EndProc TESTIDC_DONE

;***************************************************************************
;  Test routine for IDC callback
;
;***************************************************************************
Procedure TESTIDC_CB,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING



        lbegin  0

        pushad
        IDC_Parm_off equ word ptr [bp+8]   ; Parameter offset
        IDC_Parm_sel equ word ptr [bp+10]  ; Parameter selector



        ; Make ES:BX point to parameters on the stack
        mov     ax,IDC_Parm_sel         ; Selector for Parameter packet
        mov     es,ax                   ; Load ES with Parameter Packet Sleector
        mov     bx,IDC_Parm_off         ; Offset to IDC Parameter packet
        cmp     es:[bx].shdc_ulFunction,SHD_REPORT_INT
        je      Report_int
        cmp     es:[bx].shdc_ulFunction,SHD_REPORT_EVENT
        je      Report_Event

Report_int_error:
        int 3
        jmp     TestIDC_CB_Done

;.......................................................................................
Report_int:
        cmp     es:[bx].repi_ulFlag,SHD_READ_COMPLETE
        je      Read_complete
        cmp     es:[bx].repi_ulFlag,ERROR
        je      Report_int_Over_Under
     int 3
        jmp     TestIDC_CB_Done

Report_int_Over_Under:
        cmp     es:[bx].repi_ulStatus,ERROR_DEVICE_UNDERRUN
        je      TestIDC_CB_Done
        cmp     es:[bx].repi_ulStatus,ERROR_DEVICE_OverRUN
        je      TestIDC_CB_Done
     int 3
        jmp     TestIDC_CB_Done

Read_Complete:
        ; Save Time Read completed at
        mov     eax,es:[bx].repi_ulStreamTime ; Time Read occured at
        mov     d_CurrTime,eax

        mov     eax,es:[bx].repi_pBuffer; Return Buffer just received

        ; Give PDD another buffer to read into
        sub   esp,size ddcmd_readwrite_parm ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].read_ulFunction,DDCMD_READ
        mov   ss:[esi].read_hStream,012345678h
;        mov   eax,[CI_BUFF]
        mov   ss:[esi].read_pBuffer,eax
        mov   ss:[esi].read_ulBufferSize,640*480*2
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_readwrite_parm ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e25
        int 3
no_e25:
        inc   [D_RIcount]
        cmp   [D_RIcount],100
        jne   TestIDC_CB_Done

        ; Request Status
        mov   D_RIcount,0
        sub   esp,size ddcmd_Status_parm    ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].stat_ulFunction,DDCMD_STATUS
        mov   ss:[esi].stat_hStream,12345678h
        mov   eax,offset d_STATTIME
        mov   ss:[esi].stat_pStatus,eax
        mov   ss:[esi].stat_pStatus+2,ds
        mov   ss:[esi].stat_ulStatusSize, SIZE STATUS_PARM
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_Status_parm    ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        jne   yes_e28
        mov   eax,d_StatTime                ; Do time match on Last Read and Status
        cmp   d_CurrTime,eax
        je    no_e28
yes_e28:
        int 3
no_e28:

        ; Disable Events
        ; Enable  Events

        jmp   TestIDC_CB_Done

;.......................................................................................
Report_Event:
        cmp     es:[bx].repe_hStream,12345678H
        jne     Report_event_error
        cmp     es:[bx].repe_hEvent,88888888H
        jne     Report_event_error
        inc     D_ER
        cmp     D_ER,60
        jne     no_e21

        mov     D_ER,0
        ;Build Pause Command
        sub   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].cont_ulFunction,DDCMD_CONTROL
        mov   ss:[esi].cont_hStream,12345678h
        mov   ss:[esi].cont_hEvent,0
        mov   ss:[esi].cont_ulCmd,DDCMD_PAUSE
        mov   eax,offset d_PTIME
        mov   ss:[esi].cont_pParm,eax
        mov   ss:[esi].cont_pParm+2,ds
        mov   ss:[esi].cont_ulParmSize,8
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e22
        int 3
no_e22:
        ; Build Setup comman to make active
        sub   esp,size ddcmd_setup_parm     ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].setu_ulFunction,DDCMD_SETUP
        mov   ss:[esi].setu_hStream,012345678h
        mov   eax,offset D_PTIME
        mov   ss:[esi].setu_pSetupParm,eax
        mov   ss:[esi].setu_pSetupParm+2,ds
        mov   ss:[esi].setu_ulSetupParmSize,8
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_setup_parm     ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e23
        int 3
no_e23:

        ;Build Resume Command
        sub   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].cont_ulFunction,DDCMD_CONTROL
        mov   ss:[esi].cont_hStream,12345678h
        mov   ss:[esi].cont_hEvent,0
        mov   ss:[esi].cont_ulCmd,DDCMD_RESUME
        mov   eax,offset d_PTIME
        mov   ss:[esi].cont_pParm,eax
        mov   ss:[esi].cont_pParm+2,ds
        mov   ss:[esi].cont_ulParmSize,8
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        cmp   ax,0
        je    no_e24
        int 3
no_e24:
        jmp   TestIDC_CB_Done


Report_event_error:
        int 3
no_e21:



TestIDC_CB_Done:
        popad
        lend
        ret

EndProc TESTIDC_CB
_TEXT   ENDS
END
