;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;  VCA32.H   
VIDEO_IOCTL_CAT	EQU	140 
VCAERR_SUCCESS	EQU	0 
VCAERR_INVALID_BUFFER	EQU	1 
VCAERR_INVALID_RECT	EQU	2 
VCAERR_INVALID_PARM	EQU	3 
VCAERR_UNSUPPORTED_CMD	EQU	4 
VCAERR_HW_ERROR	EQU	5 
                                          ;  KLL New Tuner Functions - Start   
VCAERR_CHANNEL_TOO_LOW	EQU	6 
VCAERR_CHANNEL_TOO_HIGH	EQU	7 
VCAERR_CHANNEL_SKIP	EQU	8 
VCAERR_CHANNEL_NO_TUNER	EQU	9 
VCAERR_SIGNAL_LOCKED	EQU	10 
VCAERR_SIGNAL_NOT_LOCKED	EQU	11 
VCAERR_SIGNAL_INDETERMINATE	EQU	12 
                                          ;  KLL New Tuner Functions - End     
;  IOCTL Commands   
VCAI_INIINFO	EQU	60H 
VCAI_SAVE	EQU	61H 
VCAI_RESTORE	EQU	62H 
                                  ;  KLL New Image Restore Functions - Start   
VCAI_LOAD_MICROCODE	EQU	63H 
VCAI_RESTORE_FORMAT	EQU	64H 
VCAI_CAPTURE_FORMAT	EQU	65H 
VCAI_RESTORE_IMAGE	EQU	66H 
VCAI_PLAY	EQU	67H 
                                  ;  KLL New Image Restore Functions - End     
                                  ;  KLL New Tuner Functions - Start           
VCAI_QUERYVIDEOSIGNAL	EQU	68H 
VCAI_TUNERCHANNEL	EQU	69H 
                                  ;  KLL New Tuner Functions - End             
VCAI_VIDEOINPUT	EQU	6AH 
VCAI_SETCAPTRECT	EQU	6BH 
VCAI_GETIMAGESCALE	EQU	6CH 
VCAI_GETDEVINFO	EQU	6DH 
VCAI_VALIDRECT	EQU	6EH 
VCAI_UNFREEZE	EQU	72H 
VCAI_FREEZE	EQU	74H 
VCAI_VIDEOADJ	EQU	75H 
VCAI_SETFPS	EQU	76H 
VCAI_USER	EQU	79H 
VCAI_AUDIOINPUT	EQU	7AH 
VCAI_SETMONITOR	EQU	80H 
VCAI_EDCOLORKEY	EQU	81H 
VCAI_SETCOLORKEY	EQU	82H 
;  Common Cature Rectangle Define   

CRECT	STRUC
CR_X_Left	DD	?
CR_Y_Top	DD	?
CR_Y_Height	DD	?
CR_X_Width	DD	?
CRECT	ENDS
;  IOCTL category 140 code 6Ah - Set Video Input Source Connector       
;                              & Query Current Input Source Connector   

VCASETVIDEOINPUT	STRUC
VI_INPUT_CONNECTOR	DD	?  ;  -1 NO_Change Returns Current Setting   
VCASETVIDEOINPUT	ENDS
;  IOCTL category 140 code 6Bh - Set Source and Destination Capture Rectangles   

VCASETCAPTURERECT	STRUC
CR_Source_X_Left	DD	?
CR_Source_Y_Top	DD	?
CR_Source_Y_Height	DD	?
CR_Source_X_Width	DD	?
CR_Dest_X_Left	DD	?
CR_Dest_Y_Top	DD	?
CR_Dest_Y_Height	DD	?
CR_Dest_X_Width	DD	?
VCASETCAPTURERECT	ENDS
;  IOCTL category 140 code 6Ch - Get Image and Scale Into RAM Buffer   

VCAGETIMAGESCALE	STRUC
GIS_Capture_Buf_Len	DD	?
GIS_Capture_Buf_Ptr	DD	?
GIS_Source_X_Left	DD	?
GIS_Source_Y_Top	DD	?
GIS_Source_Y_Height	DD	?
GIS_Source_X_Width	DD	?
GIS_Dest_X_Left	DD	?
GIS_Dest_Y_Top	DD	?
GIS_Dest_Y_Height	DD	?
GIS_Dest_X_Width	DD	?
VCAGETIMAGESCALE	ENDS
;  IOCTL category 140 code 6Dh - Get Devinfo   

vcadevinfo	STRUC
DI_Length	DD	?
DI_ProdInfo	DB	30 DUP (?)
DI_ManInfo	DB	30 DUP (?)
DI_Version	DB	10 DUP (?)
DI_ImgFormat	DD	?        ;  Image Format Supported by the card              
DI_BitsPerPEL	DW	?       ;  Bit Per PEL in this image format                
DI_Overlay	DW	?          ;  Device has overlay support                      
DI_Brightness	DD	?       ;  Default Video Attributes for the card           
DI_hue	DD	?
DI_saturation	DD	?
DI_contrast	DD	?
DI_Sharpness	DD	?
DI_unused1	DD	?
DI_S_X_Left	DD	?         ;  Default Source Coordinates                      
DI_S_Y_Top	DD	?
DI_S_Y_Height	DD	?
DI_S_X_Width	DD	?
DI_D_X_Left	DD	?         ;  Default Destination Coordinates                 
DI_D_Y_Top	DD	?
DI_D_Y_Height	DD	?
DI_D_X_Width	DD	?
DI_D_ScaleFactor	DD	?    ;  Default Scale Factor on copy                    
DI_S_X_MAX	DD	?          ;  Maximum X size for the digitized Source         
DI_S_Y_MAX	DD	?          ;  Maximun Y size for the digitized Source         
DI_D_X_MAX	DD	?          ;  Maximun X size for the Destination              
DI_D_Y_MAX	DD	?          ;  Maximun Y size for the Destination              
DI_O_X_MAX	DD	?          ;  Maximun X size for the Overlay Destination      
DI_O_Y_MAX	DD	?          ;  Maximun Y size for the Overlay Destination      
DI_VideoInputs	DW	?      ;  Number of Software Switchable video Inputs      
DI_CanRestore	DW	?
DI_CanStretch	DW	?
DI_CanDistort	DW	?
DI_HasVolume	DW	?        ;  Has Volume  Control                             
DI_HasBalance	DW	?       ;  Has Balance Control                             
DI_CanScale	DW	?         ;  Can Scale Down on GetImage                      
DI_CanStream	DW	?        ;  Can do streaming of Images to Stream Handler    
DI_ulFileNum	DD	?        ;  System File Number used in Streaming            
   ; ////////// New Items after 1.0 release below //////////////////////////
DI_HasTuner	DB	?         ;  Card Has a Channel Tuner                        
DI_HasTeleTex	DB	?       ;  Card Has a TeleTex support                      
DI_Delay_Time	DD	?       ;  MS delay between connector change/query signal  
DI_HasAFC	DB	?           ;  Automatic Frequency Control/FineTune            
DI_HasPolarization	DB	?  ;  Support Video Frequency Polarization            
vcadevinfo	ENDS
DI_IMAGEFORMAT_RGB_565	EQU	1 ; ;  bits 0-4 =Red, 5-10 =Green, 11-15 Blue     
DI_IMAGEFORMAT_YUV_411	EQU	2 ; ;  4 bytes of Y, 1 Byte of U, 1 Byte of V     
DI_BITSPERPEL_16	EQU	16 ; ;  16 Bits Per PEL                            
DI_NotSupported	EQU	-1 ; ;  Not Supported                              
DI_Supported	EQU	1 ; ;  Supported                                  
;  IOCTL category 140 code 6Eh - Set Streaming Capture Image Size   

VCACAPISIZE	STRUC
CS_X_Left	DD	?
CS_Y_Top	DD	?
CS_Y_Height	DD	?
CS_X_Width	DD	?
CS_ScaleFactor	DD	?
VCACAPISIZE	ENDS
;  IOCTL category 140 code 6Fh - Get Image Into RAM Buffer   

VCAGETIMAGE	STRUC
GI_Capture_Buf_Len	DD	?
GI_Capture_Buf_Ptr	DD	?
VCAGETIMAGE	ENDS
;  IOCTL category 140 code 70h - get buffer addressing   

VCABUFFER	STRUC
BA_buf_addr	DD	?   ;  32 bit linear address                                   
BA_buf_len	DD	?    ;  buffer length in bytes                                  
BA_buf_banks	DD	?  ;  number of banks (1 if full aperature)                   
VCABUFFER	ENDS
;  IOCTL category 140 code 71h - set current VRAM bank number   

VCASELECTBANK	STRUC
SB_bank_num	DD	?   ;  number of bank to select (0-39)                         
VCASELECTBANK	ENDS
;  IOCTL category 140 code 75h - set/query video adjustments    

VCASETVIDEO	STRUC
SV_set_brightness	DD	?   ;  1=min, 255=max, 128=norm, -1=no change, -2=reset default     
SV_set_hue	DD	?          ;  1=min, 255=max, 128=neutral, -1=no change, -2=reset default  
SV_set_saturation	DD	?   ;  1=min, 255=max, 128=norm, -1=no change, -2=reset default     
SV_set_contrast	DD	?     ;  1=min, 255=max, 128=norm, -1=no change, -2=reset default     
SV_ret_brightness	DD	?   ;  1=min, 255=max   
SV_ret_hue	DD	?          ;  1=min, 255=max   
SV_ret_saturation	DD	?   ;  1=min, 255=max   
SV_ret_contrast	DD	?     ;  1=min, 255=max   
VCASETVIDEO	ENDS
;  IOCTL category 140 code 76h - set Frame Rate for Streaming   

VCASETFPS	STRUC
SF_set_FPS	DD	?          ;  Frames to Second to stream to the Stream Handler     
SF_ulFlags	DD	?          ;  Frames or MicroSeconds   
VCASETFPS	ENDS
;  Defines for ulFlags   
VCASF_FRAMES	EQU	0H 
VCASF_MICROSECONDS	EQU	1H 
;  IOCTL category 140 code 60h - Init Info from .INI file  Generic Format    

VCAINITG	STRUC
INI_ulBrightness	DD	?   ;  1=min, 255=max                      
INI_ulHue	DD	?          ;  1=min, 255=max  or Tint             
INI_ulSaturation	DD	?   ;  1=min, 255=max  or Color            
INI_ulContrast	DD	?     ;  1=min, 255=max                      
INI_bD_Info	DB	512 DUP (?)   ;  Device Specific Info                
VCAINITG	ENDS
;  IOCTL category 140 code 60h - Init Info from .INI file       

VCAINIT	STRUC
IN_ulBrightness	DD	?   ;  1=min, 255=max                      
IN_ulHue	DD	?          ;  1=min, 255=max  or Tint             
IN_ulSaturation	DD	?   ;  1=min, 255=max  or Color            
IN_ulContrast	DD	?     ;  1=min, 255=max                      
IN_bControl	DB	?      ;  see ulControl Defines               
IN_bCapPos	DB	?      ;  see ulCappos  Defines               
VCAINIT	ENDS
                               ;  KLL New Image Restore Functions - Start   
;*************************************************************************  
;  IOCTL category 140 code 63h - Query/Load/Unload MicroCode                

VCALOAD	STRUC
LOAD_ulflags	DD	?           ;  1=Query,2=Load,3=Unload                     
LOAD_ProdInfo	DB	256 DUP (?)     ;  Path and Name of MicroCode Load             
LOAD_ulLoadID	DD	?          ;  Load ID (returend on a load)                
LOAD_ulLength	DD	?          ;  Lenght of load data                         
LOAD_pLoadData	DD	?         ;  Pointer to MicroCode Load Data              
VCALOAD	ENDS
;   ulFlags for VCALOAD                                                  
VCALOAD_QUERY	EQU	01H 
VCALOAD_LOAD	EQU	02H 
VCALOAD_UNLOAD	EQU	03H 
;*************************************************************************  
;  IOCTL category 140 code 64h  - Query/Set Image Restore Format             

VCAIMAGERF	STRUC
IRF_ulFlags	DD	?        ;  0 = Query, 1 = Set                              
IRF_ulNumFormats	DD	?   ;  Number of supported format(s)                   
IRF_ulCurIndex	DD	?     ;  Current or Format to set to                     
IRF_FourCC	DD	64 DUP (?)     ;  Name for Format                                 
VCAIMAGERF	ENDS
;   ulFlags for VCAIMAGERF (Image Restore Format)                           
VCAIRF_Query	EQU	00H 
VCAIRF_Set	EQU	01H 
;*************************************************************************  
;  IOCTL category 140 code 65h - Query/Set Image Capture Format             

VCAIMAGECF	STRUC
ICF_ulFlags	DD	?        ;  0 = Query, 1 = Set                              
ICF_ulNumFormats	DD	?   ;  Number of supported format(s)                   
ICF_ulCurIndex	DD	?     ;  Current or Format to set to                     
ICF_FourCC	DD	64 DUP (?)     ;  Name for Format                                 
VCAIMAGECF	ENDS
;   ulFlags for VCAIMAGECF (Image Capture Format)                           
VCAICF_Query	EQU	00H 
VCAICF_Set	EQU	01H 
;*************************************************************************  
;  IOCTL category 140 code 66h - Restore Image data to the device           

VCAIMAGER	STRUC
IR_ulLength	DD	?       ;  Lenght of Image Data                            
IR_pImageData	DD	?     ;  Pointer to Image Data                           
VCAIMAGER	ENDS
;*************************************************************************  
;  IOCTL category 140 code 67h - Restore Image data to the device           

VCASTREAM	STRUC
STRM_ulLength	DD	?       ;  Lenght of Image Data                            
STRM_pImageData	DD	?     ;  Pointer to Image Data                           
STRM_ulFlags	DD	?        ;  Flag info                                       
STRM_ulSCR	DD	?          ;  Video Stream Clock                              
STRM_ulPTS	DD	?          ;  Presentation Time Stamp                         
STRM_ulAudioTime	DD	?    ;  Current Audio Stream Time                       
VCASTREAM	ENDS
;  ulFlag    Defines  for VCASTREAM   
VCA_PLAY_START	EQU	01H 
VCA_PLAY_DATA	EQU	02H 
VCA_PLAY_STOP	EQU	04H 
VCA_PLAY_FLUSH	EQU	08H 
VCA_PLAY_PAUSE	EQU	10H 
                               ;  KLL New Image Restore Functions - End     
;  ulControl Defines   
;   For More Info Refer to the Video Capture Adapter/A Reference manual    
;   Register 14 Control Register                                           
VCAC_YC_DECODE	EQU	80H 
VCAC_FORMAT_565	EQU	40H 
VCAC_CURSOR_ENABLE	EQU	20H 
VCAC_DISPLAY_ENABLE	EQU	10H 
VCAC_GEN_LOCK	EQU	08H 
VCAC_OUTOUT_SYNC_GREEN	EQU	04H 
VCAC_NTSC_or_YC	EQU	00H 
VCAC_PAL_or_YC	EQU	00H 
VCAC_RGB	EQU	01H 
;  ulCappos Defines   
;   NI = Non-Interlaced   
;   I  = Interlaced       
;   The First 3 bit determine what type of signal to decode                
;   The Last  5 bit determine synchronization lock position  0=rightmost   
;   For More Info Refer to the Video Capture Adapter/A Reference manual    
;   Register 12 Screen\Capture Position Controls                           
VCACP_NI262_field_1	EQU	80H 
VCACP_NI262_field_2	EQU	0A0H 
VCACP_NI263_field_1	EQU	0C0H 
VCACP_NI263_field_2	EQU	0E0H 
VCACP_I262_5_field_both	EQU	00H 
VCACP_I262_5_field_2	EQU	20H 
VCACP_I262_5_field_1	EQU	40H 
VCACP_I262_5_field_2B	EQU	60H 
VCACP_Default_Pos	EQU	0CH 
;*********************** ********************** ***************************  
;*********************** Overlay Card Functions ***************************  
;*********************** ********************** ***************************  
;  IOCTL category 140 code 80h - Enable/Disable Monitor         

VCASETMONITOR	STRUC
EDM_bMonitor	DD	?               ;  1=TRUE=ON, 0=FALSE=OFF      
VCASETMONITOR	ENDS
;  IOCTL category 140 code 81h - Enable/Disable Transparrent Color    

VCAEDCOLORKEY	STRUC
EDCK_bColorKeying	DD	?           ;  1=TRUE=ON, 0=FALSE=OFF            
VCAEDCOLORKEY	ENDS
;  IOCTL category 140 code 82h - Set Color Key / Transparrent Color   

VCASETCOLORKEY	STRUC
SCK_ulColorKey	DD	?             ;  Transparrent Color               
VCASETCOLORKEY	ENDS
                                          ;  KLL New Tuner Functions - Start   
;  IOCTL category 140 code 68h - Query Video Input Connector's Signal   
;  no structure it just Returns a status   
    ;  VCAERR_SIGNAL_LOCKED        10      
    ;  VCAERR_SIGNAL_NOT_LOCKED    11      
    ;  VCAERR_SIGNAL_INDETERMINATE 12      
;  IOCTL category 140 code 69h - Set/Query Tuner Channel       

VCATUNCHAN	STRUC
TUC_ulFlags	DD	?        ;  1=Set, 2=Query                        
TUC_ulOptions	DD	?      ;  Options                               
TUC_usResv01	DW	?       ;  Reserved                              
TUC_usResv02	DW	?       ;  Reserved                              
TUC_lFineTune	DD	?      ;  Fine Tune value                       
TUC_ulFrequency	DD	?    ;  Frequency                             
VCATUNCHAN	ENDS
;  Values for ulFlags on Set/Query Channel   
TUC_SET_CHANNEL	EQU	1 
TUC_QUERY_CHANNEL	EQU	2 
;  Values for ulOptions on Set/Query Channel   
;  Bit sensitive field                         
TUC_AFC_ON	EQU	4 
TUC_AFC_OFF	EQU	0 
TUC_FREQUENCY	EQU	8 
TUC_POLARIZATION_VERT	EQU	16 
TUC_POLARIZATION_HORI	EQU	32 
;  Specific Status Returned by Set/Query Channel   
    ;  VCAERR_CHANNEL_TOO_LOW       6      
    ;  VCAERR_CHANNEL_TOO_HIGH      7      
    ;  VCAERR_CHANNEL_SKIP          8      
    ;  VCAERR_CHANNEL_NO_TUNER      9      
                                       ;  KLL Volume Functions - Start   
;  IOCTL category 140 code 79h - Set/Query  Audio Functions, this is     
;                                a General Device Specific command       

VCADEVAUDIO	STRUC
DEVAUD_ulLENGTH	DD	?          ;  Length of this structure                 
DEVAUD_ulFUNCTION	DD	?        ;  Audio Input Channel                      
DEVAUD_ulFLAGS	DD	?           ;  Flags                                    
DEVAUD_ul_RESV01	DD	?         ;  Reserved and set to zero                 
DEVAUD_ulL_VOLUME	DD	?        ;  Left  Volume                             
DEVAUD_ulR_VOLUME	DD	?        ;  Right Volume                             
DEVAUD_ulL_BASS	DD	?          ;  Left  Volume                             
DEVAUD_ulR_BASS	DD	?          ;  Right Volume                             
DEVAUD_ulL_TREBLE	DD	?        ;  Left  Volume                             
DEVAUD_ulR_TREBLE	DD	?        ;  Right Volume                             
VCADEVAUDIO	ENDS
;  Defines for ulFunction on VCADEVAUDIO IOCTL   
;                            A U D 1
VCADEV_AUDIO_FUNC	EQU	41554431H 
;  Defines for ulFlags on VCADEVAUDIO IOCTL   
VCADEV_AUDIO_FLAG_MUTE	EQU	1 
VCADEV_AUDIO_FLAG_UNMUTE	EQU	0 
;  Defines for ulL_xxx and ulR_xxx on VCADEVAUDIO IOCTL           
;   -1=no change, -2=reset default, -1 on QUERY = not supported   
VCA_QUERY_CURRENT	EQU	0FFFFFFFFH 
VCA_SET_TO_DEFAULT	EQU	0FFFFFFFEH 
VCA_NOT_SUPPORTED	EQU	0FFFFFFFFH 
                                       ;  New Volume Functions - End     
