;*DDK*************************************************************************/
;
; COPYRIGHT (C) Chips and Technologies, Inc. 1991, 1992
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/


;Some of the material contained in this module was derivered from
;Chips and Technologies PCVideo Software Developers Kit.

.386p
INCL_DOSMISC    EQU     1
.xlist
include devsym.inc
include devhlp.inc
include basemaca.inc
.list

EXTRN   DOS32FLATDS:ABS              ; 32 bit r/w FLAT selector
EXTRN   PCV_SetVideoAddress:FAR      ; Address of Video Buffer
EXTRN   RD_I2C:FAR                   ; Read Data from I2C bus
EXTRN   config_wPortAddr:WORD
EXTRN   reg3_4680:byte               ; 4680 reg 3 White Level
EXTRN   bBoardNMG:byte               ; NMG SVW Board Type
EXTRN   Frame_info:byte       ; 
EXTRN   Tuner:byte                   ; Card has a built in Tuner
EXTRN   TypeTuner:word               ; Type of Tuner on the card
stdout          equ     1            ;Standard device handles
cr              equ     0dh          ; ASCII carriage return
lf              equ     0ah          ; ASCII linefeed
ADDR_EEPROM     equ     0A0H         ;Address of SupeVideo         EEPROM
ifdef TOOLKIT
        ; nothing to do for Video Blaster it is the default and Toolkit sample
else
        EXTRN   CheckCardType:FAR   ; Snoop/check for card type
endif


                extrn   DosWrite:far

;*************************************************************************************************************
INIT_DATA SEGMENT WORD PUBLIC 'INITDATA' USE16

temp    dd      0

INIT_DATA ENDS

;*************************************************************************************************************
DATA   SEGMENT  DWORD PUBLIC 'DATA' USE16
        EXTRN   FlatSel:WORD
        EXTRN   selector1:WORD        ; Segment address for Cards RAM
        EXTRN   named:BYTE
        EXTRN   BANK_REG:WORD
        EXTRN   HUE_REG:WORD
        EXTRN   SATURATION_REG:WORD
        EXTRN   device_hlp:DWORD
        EXTRN   Ginfo_Seg:WORD        ; Global Info Segment
        EXTRN   Ginfo_offset:WORD     ; Global Info Offset
        EXTRN   lsw_phys_add:WORD     ; Real 32 bit address LSW FROM SYSTEM
        EXTRN   msw_phys_add:WORD     ; Real 32 bit address MSW FROM SYSTEM
        EXTRN   device_id:WORD        ; Cards Device ID
        EXTRN   MC_MACHINE:BYTE       ; 1= MC bus Machine 0=ISA bus Machine
        EXTRN   NTSC_card:DWORD       ; Card is NTSC card if = 1 otherwise PAL
        EXTRN   Bank_Table:BYTE       ; scanline to bank number conversion table
        EXTRN   Offset_Table:WORD     ; scanline to bank offset conversion table
        EXTRN   baseIO:WORD           ; Base I/O address of card
        EXTRN   baseaddr:WORD         ; Base address of card
        EXTRN   Type_card:WORD        ; Type of PC Video Card
;-------------------------------------------------------------------------------
;Structure of an INIT request packet
;-------------------------------------------------------------------------------
IP       equ   es:[bx]          ;Request packet
INITpkt  struc
         db      ?
         db      ?
_Cmd     db      ?                      ; Command code
_Stat    dw      ?                      ; Status word
         dd      ?
         dd      ?
         db      ?
_DHptr   dd      ?                      ; dev help pointer
_I_parms dd      ?                      ; Parms on "DEVICE=" in config.sys
         db      ?
INITpkt  ends

not_available     equ     22h  ;-222    ; This capture device is not available

msg_1   db      cr,lf,lf
        db      'OS/2 2.1 PC Video device driver loaded.  Version 1.01'
msg_1_len equ   $-msg_1

msg_10  db      cr,lf
        db      'PC Video Base I/O                          = '
b_io    db      '                 '
        db      cr,lf
        db      'PC Video Base Memory Addr                  = '
b_mem   db      '                 '
        db      cr,lf
        db      'Card Type                                  = '
b_card  db      '                        '
        db      cr,lf
        db      'Tuner (Present - Type)                     = '
b_tun   db      '  - '
b_tun_t db      '                    '
msg_10_len equ   $-msg_10

msg_20  db      cr,lf
        db      'PC Video Initialization Successful  '
        db      cr,lf
msg_20_len equ   $-msg_20

msg_21  db      cr,lf
        db      'PC Video Initialization FAILED !!!!!'
        db      cr,lf
msg_21_len equ   $-msg_21

wlen    dw      ?
parm_es         dw   0       ; parameter packet Selector
parm_bx         dw   0       ; parameter packet Offset

PCV_ID          dw   0       ; Value Read From PC VIDEO BASE IO Addr
Card_addr       dd   0       ; Address of Video Capture Cards Memeory

; Possible base address for the card (Note: uppercase)
;                                    Note: this must match with table below
base_addr_list  equ $
;                1234567890
        db      ' /0F00000 '
        db      ' /0E00000 '
        db      ' /0D00000 '
        db      ' /0C00000 '
        db      ' /0B00000 '
        db      ' /0A00000 '
        db      ' /0900000 '
        db      ' /0800000 '
        db      ' /0700000 '
        db      ' /0600000 '
        db      ' /0500000 '
        db      ' /0400000 '
        db      ' /0300000 '
        db      ' /0200000 '
        db      ' /0100000 '

; Possible base address for the card  (selector:offset)
;                                    Note: this must match with above table
base_addr_list2 equ $
        dd      00F00000h
        dd      00E00000h
        dd      00D00000h
        dd      00C00000h
        dd      00B00000h
        dd      00A00000h
        dd      00900000h
        dd      00800000h
        dd      00700000h
        dd      00600000h
        dd      00500000h
        dd      00400000h
        dd      00300000h
        dd      00200000h
        dd      00100000h


; Possible Port address for PCV card (Note: uppercase)
Port_addr_list  equ $
;                12345678
        db      ' /P'


; Possible Names for the PDD
;
base_name_list  equ $
;                123456789
        db      ' /1'
        db      ' /2'
        db      ' /3'
        db      ' /4'
        db      ' /5'
        db      ' /6'
        db      ' /7'
        db      ' /8'
        db      ' /9'
        db      ' /1'          ; Default


; Possible Card type for the PDD   " /NTSC" or " /PAL"
base_type_list  equ $
        db      ' /PAL'
        db      ' /NTSC'       ; scan routine need names to be same length

Frame_info_list  equ $
;                123456789
        db      ' /FI'

Tuner_info_list  equ $
;                123456789
        db      ' /TUNER_M'
        db      ' /TUNERBG'
        db      ' /TUNER_I'

Card_list  equ $                        ; Card_Type
;                123456789
        db      ' /VIDVB'               ; 0
        db      ' /SUPVW'               ; 1
        db      ' /VIDMG'               ; 2
        db      ' /WINTV'               ; 3


        EXTRN   OI_LIST:DWORD         ; Open Instances List
        EXTRN   OI_CURR:DWORD         ; Current Open Instance
DATA   ENDS


;*************************************************************************************************************
_TEXT   SEGMENT WORD PUBLIC 'CODE' USE16
        EXTRN   END_OF_CODE:ABS
_TEXT   ENDS


;*************************************************************************************************************
INIT_TEXT SEGMENT WORD PUBLIC 'INITCODE' USE16
        ASSUME cs:INIT_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
subttl Initialization Code
page


;-------------------------------------------------------------------------------
; Initialization procedure is placed at the end of the code so it can go away
;  once initialization has been done.
;-------------------------------------------------------------------------------

Procedure INIT,FAR
        ASSUME cs:INIT_TEXT,ds:DATA,es:NOTHING,ss:NOTHING


;
; Save DevHlp entry point, end-of-segment offsets, and display message...
;
         mov   [parm_es],es             ; save pointer to parameter packet
         mov   [parm_bx],bx             ; save pointer to parameter packet

         mov   [OI_LIST],0h             ; No Open Instances
         mov   [OI_CURR],0h             ; No Current Open Instance
         mov   ax,word ptr IP._DHptr    ; get DevHlp entry point
         mov   word ptr device_hlp,ax   ; 
         mov   ax,word ptr IP._DHptr+2  ; 
         mov   word ptr device_hlp+2,ax ; 

         mov   ax,END_OF_CODE           ; Return end of resident code seg
         mov   word ptr IP._DHptr,ax    ; and data segments
         mov   ax,offset DATA:msg_1
         mov   word ptr IP._DHptr+2,ax  ; 

         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         push   ds                      ; address of message
         mov    ax,offset DATA:msg_1
         push   ax
         mov    ax,msg_1_len            ; length of message
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2

        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .


;**** Find Frame Info Requested for Device Driver **********
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si, offset Frame_info_list; table of FI
        mov   bx, 4                     ; Size of an entry in the table
        mov   cx, 1                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
                                        ; defaults to last name in table
                                        ;  of entries = '1'
        mov   frame_info,0              ; Assume Frame Info not wanted
        CMP   cx,0
        jne   skip_fi
        mov   frame_info,1
skip_fi:


        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .

;**** Find Port address of the Card **********
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si,offset port_addr_list  ; port Address start Char
        mov   bx, 3                     ; Size of an entry in the table
        mov   cx, 1                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
        cmp   cx, 1                     ; Was a match found
        jne   port_found                ; Port Address was found
        mov   baseio,0
        ; Why it failed ...
        mov    di,offset b_io
        mov    byte ptr ds:[di-1],'>'  ; put a '>' by failure in msg line
        jmp   T_INITX_F                 ; Exit with error

port_found:
        mov   si,di
        mov   di,offset baseio
        mov   cx,4
        call  TOHEX
        cmp   cx, 0                     ; did it convert
        je    port_ok                   ; Port Address was converted
        mov   baseio,0
        mov    di,offset b_io
        mov    byte ptr ds:[di-1],'>'  ; put a '>' by failure in msg line
        jmp   T_INITX_F                 ; Exit with error

port_ok:
        mov   ax,baseio
        mov   config_wPortAddr,ax


;**** Find Address of the Card **********
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si,offset base_addr_list  ; Table of possible addr for card
        mov   bx, 10                    ; Size of an entry in the table
        mov   cx, 16                    ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
        cmp   cx, 16                    ; Was a match found
        jne   addr_found                ; Valid Address was found

        ; Why it failed ...
        mov    di,offset b_mem
        mov    byte ptr ds:[di-1],'>'  ; put a '>' by failure in msg line
        jmp   T_INITX_F                 ; Exit with error

addr_found:
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .
        mov   si, offset base_addr_list2
        shl   cx,2
        add   si,cx
        mov   eax,ds:[si]
        mov   card_addr,eax
        shr   eax,20
        mov   baseaddr,ax
        mov   eax,ds:[si]
        mov   Dword ptr lsw_phys_add,eax ; save physical address high

        ; Check to make sure address is valid
        mov   ax,msw_phys_add
        mov   bx,lsw_phys_add
        mov   cx,0FFFFh                 ; Lenght of an Memory on the card
        mov   dh,1                      ; result in ES:DI
        mov   dl,DevHlp_PhysToVirt
        call  device_hlp
        jnc   check_if_our_Card         ; conversion OK
Not_our_Card:
        ; Why it failed ...
        mov    di,offset b_mem
        mov    byte ptr ds:[di-1],'*'   ; put a '*' by failure in msg line
        mov   ax,not_available          ; card address not valid
        jmp   T_INITX_F                 ; Exit with error

Check_if_our_card:
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .


;**** Find name for Device Driver **********
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si, offset base_name_list ; table of possible names for PDD
        mov   bx, 3                     ; Size of an entry in the table
        mov   cx, 9                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
                                        ; defaults to last name in table
                                        ;  of entries = '1'
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .

name_found:
        mov   si, offset base_name_list
        mov   ax,cx
        shl   ax,1
        add   cx,ax
        add   cx,2
        add   si,cx
        mov   al,ds:[si]
        mov   Byte ptr named+6,al       ; Change name of PDD on the fly

;**** Find " /NTSC" or " /PAL" Type of card from config.sys  **********
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si, offset base_type_list ; table of possible Card Types
        mov   bx, 5                     ; Size of an entry in the table
        mov   cx, 2                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
                                        ; defaults to last name in table
                                        ;  of entries = 'NTSC'
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .

        ; Which Type of Card  (PAL or NTSC)
        cmp   cx,0                      ; Is this a PAL card
        je    Type_PAL                  ; Its an PAL card

type_NTSC:                              ; NTSC is the default card type
        mov   dword ptr NTSC_card,1     ; Card is NTSC if = 1
        jmp   find_type_done

type_PAL:
        mov   dword ptr NTSC_card,0     ; Card is PAL  if = 0

Find_Type_done:

;**** Does the card a Tuner support from line in  config.sys  **********
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si, offset Tuner_info_list;table of Possible Tuners
        mov   bx, 9                     ; Size of an entry in the table
        mov   cx, 3                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
                                        ; defaults to last name in table
                                        ;  of entries = 'NTSC'
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .

        ; Which Type of Card  (PAL or NTSC)
        cmp    cx,3                     ; Was tuner support indicated
        je     no_tuner                 ; No Tuner support
        mov    tuner,1                  ; Tuner is supported
        mov    b_Tun,'1'                ; Tuner is supported
        mov    TypeTuner,cx
        push   ax
        mov    di,offset b_Tun_t
        mov    si,offset TypeTuner
        mov    cx,2
        call   tochar
        pop     ax

        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .

no_tuner:

        ; Check for PC Video Chip Present
        mov     dx,baseio               ;Set PC Video port address.
        mov     al,dl                   ;Note: You may noticed already, we are
        out     dx,al                   ;programming the PC Video chip without
                                        ;first enabling the chip and program its
                                        ;index register.
                                        ;This is because the very first I/O
                                        ;write to PC Video chips after reset
                                        ;goes directly to the I/O address
                                        ;register (index 00).

        mov     ax,03FFh
        out     dx,ax                   ;Enable PC Video.
        inc     dx
        in      al,dx                   ;Read chip version number.
        and     ax,0FFH
        mov     pcv_id,ax
        cmp     al,0FFh
        je      no_pcvideo
        shr     al,4
        xor     ah,ah
        push    ax
        mov     si,offset pcv_id
        mov     di,offset b_io + 7
        mov     cx,1
        call    TOCHAR
        mov     byte ptr ds:[b_io+6],'V'  ; put a '?' by failure in msg line
        pop     ax
        cmp     ax,2
        jbe     @F                      ;Valid PC Video version number ?

no_pcvideo:
        ; Why it failed ...
        mov     di,offset b_io
        mov     byte ptr ds:[di-1],'*'  ; put a '*' by failure in msg line
        mov     byte ptr ds:[di+6],'V'  ; put a '?' by failure in msg line
        mov     si,offset pcv_id
        mov     di,offset b_io + 7
        mov     cx,1
        call    TOCHAR
        jmp     T_INITX_F
@@:

        ; Check type of card (SVW, VB, VM, WINTV)
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .
;**** Does the card have the Card Type Coded in config.sys  **********
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si, offset card_list      ;table of Possible card Types
        mov   bx, 7                     ; Size of an entry in the table
        mov   cx, 4                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
                                        ; defaults to last name in table
                                        ;  of entries = 'NTSC'
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .

        ; Which Type of Card
        mov   type_card,0               ; Default to Video Blaster
        cmp    cx,4                     ; Not Specified in Config.sys line
        je     man_card_ID

        mov   type_card,cx              ; Save Card Type(Index)
        cmp   cx,1                      ; If Super Video Windows
        je    man_card_id
        jmp   Type_Card_done

man_card_id:

; Do manual card ID if not specified
ifdef TOOLKIT
        ; nothing to do for Video Blaster it is the default and Toolkit sample
else
        Call far ptr CheckCardType  ; Snoop around for card Type and Set it
endif

Type_Card_done:


;
; Allocate a GDT Selector

;
        mov     ax, ds                          ; es gets upper address
        mov     es, ax
        lea     di, Selector1                   ; Get the Selector Address
        mov     cx, 1                           ; One selector
        mov     dl, DevHlp_AllocGDTSelector
; int 3

        call  device_hlp
        mov     ax,not_available          ; Assume allocate GDT failed
        jnc     @F                        ; No Problem

        ; Why it failed ...
        mov    di,offset b_mem
        mov    byte ptr ds:[di-1],'*'  ; put a '*' by failure in msg line
        jmp     T_INITX_F                 ; Exit with error
@@:
;
; Get FLAT selector
;
        mov     ax,DOS32FLATDS                  ; Get r/w FLAT selector
        mov     FlatSel,ax                      ; Save for later
        mov     fs,ax                           ; setup flat Selector

;Map Physical Address to GDT selector for all can access (Interrupt and Task time)
        mov     ax,msw_phys_add              ; Physical Address to be mapped
        mov     bx,lsw_phys_add              ; Physical Address to be mapped
        mov     si, Selector1                ; Get the Selector Address
        mov     cx, 0FFFFh                   ; Lenght of area to be mapped
        mov     dl, DevHlp_PhystoGDTSelector
        call  device_hlp
        mov     ax,not_available             ; Assume allocate GDT failed
        jnc     @F                           ; No Problem

        ; Why it failed ...
        mov    di,offset b_mem
        mov    byte ptr ds:[di-1],'*'     ; put a '*' by failure in msg line
        jmp     T_INITX_F                 ; Exit with error
@@:



; !!! Need to perform tests on VRAM, etc.

;!!!!!!!!  Get Addess of DOS Varible (need time info)
        mov     al,1                ; Get Global Info Seg
        mov     dl,DevHlp_GetDOSVar ; Function = GetDOSVar
        call    device_hlp          ; Call DevHlp
        jc      T_INITX_F           ; If Error occured exit with error
        push    es
        mov     es,ax               ; Selector
        les     bx,es:[bx]          ; get pointer  to pointer
        mov     [Ginfo_Seg],bx      ; Global Info Segment
        mov     [Ginfo_offset],es   ; Global Info Offset
        pop     es
        jmp     T_INIT_OK

T_INITX_F:
        mov     ax,not_available      ; Could Not Initialize
        jmp     T_INITX

T_INIT_OK:
         sub   ax,ax                  ; indicate no error


T_INITX:
         push   ax
         cmp   frame_info,1              ; Assume Frame Info not wanted
         je    print_config
         cmp    ax,0
         je     init_ok_msg
print_config:
        ; Set up Info ... to display
         push   ax
         mov    di,offset b_io
         mov    si,offset baseio
         mov    cx,2
         call   tochar

         mov    di,offset b_mem
         mov    si,offset card_addr
         mov    cx,4
         call   tochar

         mov    di,offset b_card
         mov    si,offset type_card
         mov    cx,2
         call   tochar

         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         push   ds                      ; address of message
         mov    ax,offset DATA:msg_10
         push   ax
         mov    ax,msg_10_len           ; length of message
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2
         mov   bx,[parm_bx]          ; restore request packet pointer
         mov   es,[parm_es]          ; .
         mov   bx,[parm_bx]          ; restore request packet pointer
         mov   es,[parm_es]          ; .

         pop    ax
         cmp    ax,0
         je     init_ok_msg
         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         push   ds                      ; address of message
         mov    ax,offset DATA:msg_21
         push   ax
         mov    ax,msg_21_len           ; length of message
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2
         jmp    init_done

init_ok_msg:
         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         push   ds                      ; address of message
         mov    ax,offset DATA:msg_20
         push   ax
         mov    ax,msg_20_len           ; length of message
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2

init_done:
         ; Disable the PCVideo Card
         ; It was haging on CTRL-Alt-Delete??
         mov     dx,config_wPortAddr     ;Set PC Video port address.
         mov     al,dl                   ; 
         out     dx,al                   ; 
         mov     ax,00FFh
         out     dx,ax                   ;Disable PC Video.

         pop    ax
         ret
EndProc INIT
;INIT     ENDP

;---------------------------------------------------------------------------
; FDEVICE
;
; Find Parms on the Device= Statement from the Config.Sys
; from a list of items to search for
;
; INPUTS:
;
;   ES:DI = pointer to parms on the DEVICE= statement
;      SI = Pointer to list of Items to search for on the DEVICE=
;      BX = Size of an Entry in the Table SI points to
;      CL = Nuber of Entries in the Table SI points to
;
;
; OUTPUT:
;      CL = Number of the Entry where a match was found
;           (0        = first  entry)
;           (1        = Second entry)
;           (input CX = no match found)
;      DI = Byte after string found if string was found
;
;---------------------------------------------------------------------------
FDEVICE proc  near

         mov   dx,si
         mov   ah,cl
find_Item:
         mov   cx,0
         mov   cl,ah                    ; Entries in table
         mov   si,dx                    ; index for base addr table

next_Item:
         push  cx
         push  di
         mov   cx,bx                    ; size of each table entry

next_I_byte:
         mov   al,es:[di]
         cmp   al, 00h                  ; is it the end of data
         je    end_D_parms
         cmp   ds:[si],al
         jne   try_next_I
         inc   di
         inc   si
         loop  next_I_byte              ; Check next byte of Item
         mov   cx,di
         pop   di
         mov   di,cx                    ; di points to byte after found string
         pop   cx
         jmp   valid_Item               ; valid address was coded

try_next_I:
         add   si,cx                    ; Start of next table entry
         pop   di
         pop   cx
         loop  next_Item
         inc   di                       ; next byte in device= statement
         jmp   find_Item

end_D_parms:
         pop   di
         pop   cx
         mov   cx,0                     ; Item not found


valid_Item:

fdevice_exit:
         sub   ah, cl                   ; Entry where match was found
         mov   cl, ah
        ret
FDEVICE endp

;---------------------------------------------------------------------------
; TOCHAR
;
; Convert Hex String to Character for display
;
; INPUTS:
;
;   DS:SI = pointer to Hex String to Convert
;   DS:DI = Pointer to Place to put Char String
;      CX = Number of bytes in input hex string
;
;
; OUTPUT:
;
;---------------------------------------------------------------------------
TOCHAR proc  near

        push  bx
        add   si,cx
        sub   si,1
next_Char:
        MOV   al,ds:[SI]
        dec   si
        mov   bl,al
        shr   al,4
        and   al,0Fh
        cmp   al,9
        ja    char_A_F_1
                                  ; Convert for 0 to 9
        or    al,30h
        jmp   got_char_1

char_A_F_1:                       ; Convert for A to F
        sub   al,9
        or    al,40h

got_char_1:
        mov   ds:[di],al        ; Save Char Result
        inc   di                ; Next Char Postion to write

        ; ---- second digit in byte
        mov   al,bl
        and   al,0Fh
        cmp   al,9
        ja    char_A_F_2
                                  ; Convert for 0 to 9
        or    al,30h
        jmp   got_char_2

char_A_F_2:                       ; Convert for A to F
        sub   al,9
        or    al,40h

got_char_2:
        mov   ds:[di],al        ; Save Char Result
        inc   di                ; Next Char Postion to write

        loop  next_char

        pop   bx
        ret
TOCHAR endp

;---------------------------------------------------------------------------
; TOHEX
;
; Convert Char String to Hex number
;
; INPUTS:
;
;   ES:SI = pointer to Char String to Convert
;   DS:DI = Pointer to Place to put Hex String
;      CX = Number of bytes in input hex string (must be even 2,4,6,8,..)
;
;
; OUTPUT:
;      CX  = 0 success
;      CX != 0 Error
;---------------------------------------------------------------------------
TOHEX proc  near
        push  bx
        add   si,cx
        sub   si,2
next_hex:
        MOV   al,es:[SI]
        mov   ah,al
        and   ah,0F0h
        cmp   ah,40h         ; Upper case A-F
        je    hex_A_F
        cmp   ah,60h         ; Lower case a-f
        je    hex_A_F
        cmp   ah,30h         ; Number 0-9
        je    num_0_9
        jmp   to_hex_done
        ;Got a number  0-9

num_0_9:
        and    al,0Fh
        jmp    to_hex_write

hex_A_F:
        and    al,0Fh
        cmp    al,1
        jl     to_hex_done
        cmp    al,6h
        jg     to_hex_done
        add    al,9h
        jmp    to_hex_write

to_hex_write:
        mov    dl,al
        shl    dl,4

; odd Digit
        MOV   al,es:[SI+1]
        mov   ah,al
        and   ah,0F0h
        cmp   ah,40h         ; Upper case A-F
        je    hex_A_F_2
        cmp   ah,60h         ; Lower case a-f
        je    hex_A_F_2
        cmp   ah,30h         ; Number 0-9
        je    num_0_9_2
        jmp   to_hex_done
        ;Got a number  0-9

num_0_9_2:
        and    al,0Fh
        jmp    to_hex_write_2

hex_A_F_2:
        and    al,0Fh
        cmp    al,1
        jl     to_hex_done
        cmp    al,6h
        jg     to_hex_done
        add    al,9h
        jmp    to_hex_write_2

to_hex_write_2:
        or     al,dl
        mov    ds:[di],al
        sub    si,2
        inc    di
        sub    cx,2
        jne    next_hex

to_hex_done:
        pop   bx
        ret
TOHEX  endp

INIT_TEXT ENDS
END
