;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/


.386p
INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

EXTRN   TIMEINTRPT:FAR               ; Generic Timer Interrupt Handler
EXTRN   PCV_ReadVideoRect:FAR        ; Read Image From the H/W to a buffer
;*********************************************
; Define the C calling macros
LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm
;*********************************************

MAIN            EQU     1             ; used in ssmdd.inc
.xlist
        include devsym.inc
        include basemaca.inc
        include basedef.inc
        include devhlp.inc
        include error.inc
        include infoseg.inc

;        include ptrace.inc              ; PTRACE macros
        include os2medef.inc
        include meerror.inc
        include ssm.inc
        include shdd.inc
        include vididc.inc
        include video.inc
.list



DATA   SEGMENT  DWORD USE16 PUBLIC 'DATA'      ; changed from code to data
;        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT

ALIGN 4
        EXTRN   FlatSel:WORD
        EXTRN   device_hlp:DWORD
        EXTRN   Ginfo_Seg:WORD        ; Global Info Segment
        EXTRN   Ginfo_offset:WORD     ; Global Info Offset
        EXTRN   SI_CURR:DWORD         ; Current Stream handler Instances
        EXTRN   Bank_Table:BYTE       ; scanline to bank number conversion table
        EXTRN   Offset_Table:WORD     ; scanline to bank offset conversion table
        EXTRN   lin_addr:DWORD        ; 32 bit linear address  (GLOBAL) for H/W buffer
        EXTRN   usr_ScaleFactor:DWORD ; Scale image down by this factor
        EXTRN   usr_DX_Width:DWORD    ; Width of the Image
        EXTRN   usr_DY_Height:DWORD   ; Height of the Image


CONTROL_REG     equ  402h


IDC     equ   es:[bx]                 ; Pointer to IDC Request packet
DATA   ENDS


_TEXT   SEGMENT  DWORD USE16 PUBLIC 'CODE'
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT




;************************** I D C   S T A R T    S T R E A M I N G *************************
subttl IDC FUNC CONTROL START
page
;            Start the Timer Interrupts
;
Procedure IDC_START_S, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        ; Turn Interrupts on
        mov     ax,offset TimeIntrpt  ; EP for a timer interrupt
        mov     bx,1                  ; Number of timer units till interrupt
        mov     dl,DevHlp_TickCount   ; Turn ON the timer
        call    device_hlp            ; 


        mov     ax,0                    ; !!! Say Function worked

START_DONE:
        ret
ENDPROC IDC_START_S

;************************** I D C   S T O P    S T R E A M I N G ***************************
subttl IDC STOP STREAMING
page
Procedure IDC_STOP_S, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        ; Turn off interrupts
        mov     ax,offset TimeIntrpt  ; EP for a timer interrupt
        mov     dl,DevHlp_ResetTimer  ; Turn OFF the timer
        call    device_hlp            ; 

        mov     ax,0                    ; !!! Say Function worked

STOP_DONE:
        RET
ENDPROC IDC_STOP_S

;************************** I D C   P A U S E   S T R E A M I N G  *************************
subttl IDC PAUSE STREAMING
page
Procedure IDC_PAUSE_S, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        ; Turn off interrupts (well very slow any way)
        mov     ax,offset TimeIntrpt        ; EP for a timer interrupt
        mov     bx,0FFFFh                   ; Number of timer units till interrupt
        mov     dl,DevHlp_TickCount         ; Turn ON the timer
        call    device_hlp                  ; 

        mov     ax,0                    ; !!! Say Function worked

        RET
ENDPROC IDC_PAUSE_S

;************************** I D C   R E S U M E   S T R E A M I N G ***********************
subttl RESUME Streaming Capture
page
Procedure IDC_RESUME_S, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING


        ; Turn Interrupts back on
        mov     ax,offset TimeIntrpt        ; EP for a timer interrupt
        mov     bx,1                        ; Number of timer units till interrupt
        mov     dl,DevHlp_TickCount         ; Turn ON the timer
        call    device_hlp                  ; 

        mov     ax,0                        ; !!! Say Function worked

        RET
ENDPROC IDC_RESUME_S


;***************************************************************************
;  GetImage to Streaming Buffer
;
;
;***************************************************************************
Procedure IDC_GETIMAGE_S,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

       PUSHFD
;       CLI


       mov       eax,[SI_Curr]        ; Get Current Stream Instance buffers address

       ; Put Parameters on the stack for the Call to the Copy Image buffer routines
       mov       ecx,[Lin_addr]                ; Source Buffer
       push      ecx

       mov       ecx,fs:[eax].SI_pCur_Img_Free ; Destination Buffer
       ADD       ecx,size VIDEO_FRAME_HDR      ; allow room for header
       push      ecx

       mov       ecx,fs:[eax].SI_DY_Height     ; Y_Height
       push      cx

       mov       ecx,fs:[eax].SI_DX_Width      ; X_Width
       push      cx

       mov       ecx,0                          ; Y_Top
       push      cx

       mov       ecx,0                         ; X_Left
       push      cx

;***************************************************************************
;************* Copy the Buffer from the H/W ********************************
;************* Copy the Buffer from the H/W ********************************
;***************************************************************************
      call       PCV_ReadVideoRect       ; Read Image From the H/W to a buffer

copy_image_done:

       POPFD
       ret

EndProc IDC_GETIMAGE_S

;************************** I D C   A S Y N C    F R E E Z E   *************************
subttl IDC ASYNC FREEZE
page
;            Stop the H/W Image digitizer (it may take a frame before it stops)
;
Procedure IDC_ASYNC_FREEZE, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

       mov     eax,0                   ; Freeze is complete

       ret
ENDPROC IDC_ASYNC_FREEZE

;************************** I D C   A S Y N C    U N F R E E Z E   **********************
subttl IDC ASYNC UNFREEZE
page
;            Start the H/W Image digitizer (it may take a frame before it starts)
;
Procedure IDC_ASYNC_UNFREEZE, FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

       mov     ax,0                   ; !!! Say Function worked

       ret
ENDPROC IDC_ASYNC_UNFREEZE

_TEXT   ENDS
END
