;*DDK*************************************************************************/
;
; COPYRIGHT (C) Chips and Technologies, Inc. 1991, 1992
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/


;Some of the material contained in this module was derivered from
;Chips and Technologies PCVideo Software Developers Kit.

;*****************************************************************
; OS/2 2.0 PC Video device driver
;
;
;   Device driver functions
;   -----------------------
;   OPEN
;     Open the device when ready to use the adapter.
;
;   CLOSE
;     Close device when no longer being used.
;
;   IOCTL
;     Category 140
;
;       code 60h - Return system information
;
;             Init Device with Info from the devices .INI file.
;             The INI file is READ in by the VSD.
;
;       The following functions are for use by 32-bit OS/2
;       applications/subsystems:
;
;       code 6Eh - Validate Video Rectangle Size\Crop\Scale Info (Capture Image Size)
;
;       code 6Fh - Capture Image into a RAM buffercale Info (Capture Image Size)
;
;       code 70h - Return 32-bit flat address to video buffer and
;                  number of 16K banks.
;
;       code 71h - Select VRAM bank number 0-255 to map into memory
;                  address
;
;       code 72h - Select live/capture mode
;
;       code 73h - Select live mode (freeze)
;
;       code 74h - Single frame capture
;                  Enter live/capture mode, poll capture-in-progress
;                  until two fields are captured, the return to live mode.
;
;       code 75h - Set video adjustments
;                  Brightness, saturation, hue, contrast
;
;       code 76h - Set FPS (frames per second)
;
;
;*****************************************************************
title VBCL.ASM OS/2 2.0 Device driver for the Video Capture Adapter
page 55,132

.386p

;******************************************************************************
;  I N C L U D E S
;******************************************************************************
INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

.xlist
include devsym.inc
include devhlp.inc
include basemaca.inc
include basedef.inc
include VIDIN.inc
include vididc.inc         ;struc for IDC stream instance
include vidvci.inc         ; Struc of IOCTLS request packets
include os2medef.inc
include meerror.inc
include ssm.inc
include shdd.inc
include pcv2.inc           ; Struc of IOCTLS request packets
.list

EXTRN   DOS32FLATDS:ABS              ; 32 bit r/w FLAT selector
EXTRN   IDC_ENTRY:FAR                ; IDC Entry Point
EXTRN   TimeIntrpt:FAR               ; Timer Interrupt Routine
EXTRN   PCV_Initialize:FAR;          ; Initialize the card with parms
EXTRN   PCV_SetAcquisitionWindow:FAR ; Source video acquisition window
EXTRN   PCV_CreateWindow:FAR         ; Create a video window on the monitor
EXTRN   PCV_DisableColorKey:FAR      ; Disable Color KEy
EXTRN   PCV_SetColor:FAR             ; Adjust Video (Color, Brightness,...)
EXTRN   PCV_DisableVideo:FAR         ; Turn off Video Display on VGA Monitor
EXTRN   PCV_EnableVideo:FAR          ; Turn on  Video Display on VGA Monitor
EXTRN   PCV_DisableColorKey:FAR      ; Turn off Transparrent Color Key
EXTRN   PCV_EnableColorKey:FAR       ; Turn on  Transparrent Color Key
EXTRN   PCV_SetColorKey:FAR          ; Set Transparrent Color Key
EXTRN   PCV_ReadVideoRect:FAR        ; Read Image From the H/W to a buffer
EXTRN   PCV_SetVideoAddress:FAR      ; Address of Video Buffer
EXTRN   PCV_SetVideoSource:FAR       ; Select Video Input Connector
EXTRN   PCV_FreezeVideo:FAR          ; Freeze the Video
EXTRN   PCV_UnFreezeVideo:FAR        ; Unfreeze the Video
EXTRN   WR_I2C:FAR                   ; Write Data on I2C bus
EXTRN   RD_I2C:FAR                   ; Read  Data from I2C bus
;EXTRN   TestIDC:FAR                  ; Temp code to test IDC calls
;EXTRN   TestIDC_DONE:FAR             ; Temp code to test IDC calls
EXTRN   NUMTORGB4:FAR                ; Timer Interrupt Routine
ifdef TOOLKIT
;       nothing
else
EXTRN   _TunerInit:FAR               ; Init the Tuner
EXTRN   _SetTunerChannel:FAR         ; Change Tuner Channels
endif


INIT_TEXT   SEGMENT WORD PUBLIC 'INITCODE' USE16
        EXTRN   INIT:FAR
INIT_TEXT   ENDS

LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm


DATA     SEGMENT word public 'DATA' USE16; All code and data segments must be named

 PUBLIC FlatSel, GetI2RAM
 PUBLIC selector1, named, BANK_REG, HUE_REG, SATURATION_REG, device_hlp
 PUBLIC Ginfo_Seg, Ginfo_offset, lsw_phys_add, msw_phys_add, device_id, MC_MACHINE
 PUBLIC NTSC_card, Bank_Table, Offset_Table
 PUBLIC usr_Y_Height, usr_X_Width, usr_ScaleFactor, usr_FPS, usr_X_Left, usr_Y_Top
 PUBLIC usr_DY_Height, usr_DX_Width, usr_DX_Left, usr_DY_Top
 PUBLIC late_tic, lin_addr
 PUBLIC VB_opens
 PUBLIC config_data, config_wPortAddr, config_wVideoAddr, config_wCfgFlags
 PUBLIC config_wVideoSource, config_bColorSettings, config_PCVideoTable
 PUBLIC config_PhixelTable, config_aMode, config_wNTSCAcqWindow
 PUBLIC config_wPALAcqWindow, config_aReserved, config_wBoardType
 PUBLIC Config_bVolume
 PUBLIC config_ulfinetune, Config_wChannel, Config_bRFRegion
 PUBLIC overlay
 PUBLIC WarmStart
 PUBLIC usr_keyColor
 PUBLIC usr_FPSflags
 PUBLIC TYPE_CARD


ADDR_EEPROM        equ  0A0H         ;Address of SupeVideo         EEPROM

CAPTURE_DEVICE    equ  140          ;IOCTL User defined catagory for image capture device
devlev_1          equ  0000000010000000B ;Bits 7-9 - DOS 5.0
dev_char_dev      equ  1000000000000000B ;Bit 15-Device is a character device
dev_30            equ  0000100000000000B ;Bit 11-Accepts open/close
dev_IDC           equ  0100000000000000B ;Bit 14-Accepts IDC command

;------------------ DEVICE DRIVER HEADER ---------------------------------------
Dev_Header        equ  $
ptr_to_nxt_hdr    dd   -1           ;Indicates loadable device driver
device_attr       dw   devlev_1 + dev_char_dev + dev_30 + dev_IDC
offst             dw   _TEXT:strategy  ;OffQuery to the strategy routine
idc_offset        dw   _TEXT:IDC_entry ;Offset to IDC Entry Point routine
named             db   'VIDVBCx$'   ;Name of the device
reserved_words    dw   4 dup (0)    ;Reserved words
;------------------ END OF DEVICE DRIVER HEADER --------------------------------

;***************************************
;* IocTab - Table of Generic IOCTALs   *
;***************************************
        EVEN
        PUBLIC  IocTab
IocTab LABEL WORD
        DW     2FH                      ;--- Number of Entries in this Table
        DW     CODE_60H            ;60  ; Init Parms
        DW     CODE_61H            ;61  ; Save current Setup Info
        DW     CODE_62H            ;62  ; Restore Setup Info
        DW     CODE_unk            ;63  ; Unknow Function (command not supported)
        DW     CODE_unk            ;64  ; Unknow Function (command not supported)
        DW     CODE_unk            ;65  ; Unknow Function (command not supported)
        DW     CODE_unk            ;66  ; Unknow Function (command not supported)
        DW     CODE_unk            ;67  ; Unknow Function (command not supported)
        DW     CODE_68H            ;68  ; Query Video Input connector signal
        DW     CODE_69H            ;69  ; Set/Query Tuner Channel
        DW     CODE_6AH            ;6A  ; Set Input Video Source connector
        DW     CODE_6BH            ;6B  ; Set Source and Destination image info
        DW     CODE_6CH            ;6C  ; Capture Image and Scale to Ram Bufferd)
        DW     CODE_6DH            ;6D  ; Get Device Info
        DW     CODE_6EH            ;6E  ; Validate Capture Image Size
        DW     CODE_unk            ;6F  ; Capture image into RAM buffer
        DW     CODE_unk            ;70  ; (not supported) Get addressability to VRAM
        DW     CODE_71H            ;71  ; Select VRAM Bank Number
        DW     CODE_72H            ;72  ; Select Live capture mode
        DW     CODE_unk            ;73  ; Unknow Function (command not supported)
        DW     CODE_74H            ;74  ; Select Live Mode then Freeze
        DW     CODE_75H            ;75  ; Video Adjustments
        DW     CODE_76H            ;76  ; Set Time Based Capture
        DW     CODE_unk            ;77  ; Unknow Function (command not supported)
        DW     CODE_unk            ;78  ; Unknow Function (command not supported)
        DW     CODE_79H            ;79  ; Device Specific IOCTLs
        DW     CODE_unk            ;7A  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7B  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7C  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7D  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7E  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7F  ; Unknow Function (command not supported)
        DW     CODE_80H            ;80  ; Enable/Disable Monitor
        DW     CODE_81H            ;81  ; Enable/Diable Color Key
        DW     CODE_82H            ;82  ; Set Color Key
        DW     CODE_unk            ;83  ; Unknow Function (command not supported)
        DW     CODE_unk            ;84  ; Unknow Function (command not supported)
        DW     CODE_unk            ;85  ; Unknow Function (command not supported)
        DW     CODE_unk            ;86  ; Unknow Function (command not supported)
        DW     CODE_unk            ;87  ; Unknow Function (command not supported)
        DW     CODE_unk            ;88  ; Unknow Function (command not supported)
        DW     CODE_unk            ;89  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8A  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8B  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8C  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8D  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8E  ; Unknow Function (command not supported)


TDA4680_S      db     'TDA4680', 0
getI2RAM       dd      0
eye_catcher    db      '      PC VIDOE DEVICE DRIVER DATA AREA  '
count_74s      dd      0
               dw      0

MC_MACHINE     db      1    ; 1 = Micro Channel Machine,  0 = NON-Micro Channel Machine
;GDTsel         dw      0    ; GDT Selector
FlatSel        dw      0    ; Flat Selector

;------------------- DEVICE IDs OF SUPPORTED DEVICES --------------------------

done              equ   0100h           ; code for DONE
error_s           equ   8000h           ; status code for error
general_failure   equ   000ch           ; General failure error code
unknown_command   equ   0003h           ; Unknown command error code
Device_in_use     equ   0014h           ; Device Already in use error code
not_supported     equ     21h  ;-223    ; This capture device is not supported
not_available     equ     22h  ;-222    ; This capture device is not available
cat_not_supported equ     23h  ;-221    ; IOCTL catagory not supported
fun_not_supported equ     24h  ;-220    ; IOCTL function not supported

sys_time_Rate     equ     32            ; System Timer Ticks/Second

;-------------------------------------------------------------------------------
;Structure of an INIT request packet
;-------------------------------------------------------------------------------
IP       equ   es:[bx]          ;Request packet
INITpkt  struc
         db      ?
         db      ?
_Cmd     db      ?                      ; Command code
_Stat    dw      ?                      ; Status word
         dd      ?
         dd      ?
         db      ?
_DHptr   dd      ?                      ; dev help pointer
_I_parms dd      ?                      ; Parms on "DEVICE=" in config.sys
         db      ?
INITpkt  ends
;-------------------------------------------------------------------------------
;Structure of a General IOCTL request packet
;-------------------------------------------------------------------------------
GIO     equ   es:[bx]
GIOpkt  struc
         db      ?
         db      ?
         db      ?                      ; Command code
         dw      ?                      ; Status word
         dd      ?
         dd      ?
_cat     db      ?                      ; category
_code    db      ?                      ; function code
_Parm    dd      ?                      ; address of parms
_Data    dd      ?                      ; address of data (see VIDVCI.INC)
GIOpkt  ends

;-------------------------------------------------------------------------------
; General IOCTL output data structures
;-------------------------------------------------------------------------------
GIX     equ   es:[bx]
DAX     equ   ds:[si]

;-------------------------------------------------------------------------------
; Defaults for the Device   (must match info in VIDVCI.H/INC  ... don't change ... add to end only)
;-------------------------------------------------------------------------------
Defaults          equ $
D_Length          dd   Defaults_End - Defaults            ; Length of Structure/Data
                       ;123456789012345678901234567890
prod_info         db   'Video Blaster from CLI        '   ; Name of the device
Manufacture_info  db   'IBM                           '   ; Owner of The PDD
Version_info      db   '0.2       '                       ; Version Number
Img_format_info   dd   DI_IMAGEFORMAT_YUV_411             ; RGB
BitsPerPEL_info   dw   16                                 ; Bit Per PEL
Overlay           dw   1                                  ; Overlay Device
I_brightness      dd   d_brightness
I_hue             dd   d_hue
I_saturation      dd   d_saturation
I_contrast        dd   d_contrast
I_Sharpness       dd   -1                                ; Not Supported
unused1           dd   0                                 ; Unused
S_X_Left          dd   10h                               ; Default Source Info
S_Y_Top           dd   20h
S_Y_Height        dd   1ECh
S_X_Width         dd   2BCh
D_X_Left          dd   0                                 ; Default Destination
D_Y_Top           dd   0
D_Y_Height        dd   480/4
D_X_Width         dd   640/4
D_ScaleFactor     dd   4
S_X_MAX           dd   1024                              ; Max X for Source
S_Y_MAX           dd   768                               ; Max Y for Source
D_X_MAX           dd   1024                              ; Max X for Dest
D_Y_MAX           dd   768                               ; Max Y for Dest
O_X_MAX           dd   1024                              ; Max X for Overlay
O_Y_MAX           dd   768                               ; Max Y for Overlay
VideoInputs       dw    3                                ; 3 Input Connectors
CanRestore        dw    0                                ; Not supported
CanStretch        dw    1                                ; Strech
CanDistort        dw    1                                ; Distort in X & Y
HasVolume         dw    0                                ; Not supported
HasBalance        dw    0                                ; Not supported
CanScale          dw    1                                ; Can Scale Down
CanStream         dw    1                                ; Can Stream
Instance_ID       dd    0            ; Returned Instance ID for stream
Tuner             db    0                                ; 1= Tuner Installed
TeleTex           db    0                                ; 1= TeleTex Installed
Delay_Time        dd    500          ; MS Delay between Set and Query Connector
AFC               db    0            ; Automatic Frequency Control
Polarization      db    0            ; Video Frequency Polarization supported
Defaults_End     equ $
public  Tuner,Delay_Time
;-------------------------------------------------------------------------------
; Misc data area used by driver
;-------------------------------------------------------------------------------
device_hlp    dd   ?         ; Holds address of the DevHlp functions
VB_opens      dd   0         ; open count
buffer_phys   dd   0         ; physical address of buffer
lin_addr      dd   0         ; 32 bit linear address  (GLOBAL)
aper_size     dd   0         ; VRAM buffer aperature size in bytes
buffer_lin    dd   0         ; Linear address for the card
NTSC_card     dd   0         ; Card is NTSC card if = 1
Card_frame_rate dw   60      ; Frame Rate of Card
Timer_on        dw   0       ; Is time based capture turned on (1=True)
parm_es         dw   0       ; parameter packet Selector
parm_bx         dw   0       ; parameter packet Offset
Ginfo_Seg       dw   0       ; Global Info Segment
Ginfo_offset    dw   0       ; Global Info Offset
Late_tic        dd   0       ; Times timer tic was detected late
Card_Buff       dd   0       ; Address of Image buffer on Capture Card
Type_Card       dw   0       ; 0 = VB, 1=SVW, 2=VM

Bank_Table      db   290 dup(0) ; scanline to bank number conversion table
Offset_Table    dw   290 dup(0) ; scanline to bank offset conversion table

StackUsage      equ $                   ; pg 5-47 of os2 Device Drivers book
  SU_cbStruc    DW 14                   ; Size of structure
  SU_flags      DW ?                    ; Flags
  SU_iIRQ       DW ?                    ; IRQ being handled
  SU_cbStackCLI DW ?                    ; bytes used during CLI
  SU_cbStackSTI DW ?                    ; bytes used during STI
  SU_cbStackEOI DW ?                    ; bytes used during EOI
  SU_cNest      DW ?                    ; Nesting Levels
;StackUsage     ENDS



device_id  dw      0      ; Cards Device ID
                          ;/*Each microchannel slot is checked beginning at slot 1
                          ;until one of the two adapters are found or all
                          ;slots are checked.
lsw_phys_add dw    0      ;/*Real 32 bit address LSW FROM SYSTEM*/
msw_phys_add dw    0      ;/*Real 32 bit address MSW FROM SYSTEM*/
selector1  dw      0      ;/*Selector of real address FROM SYSTEM. (Same as segment address for DOS) */


; Video adjustment settings as seen by the user
;
usr_brightness  dd   150   ; 1=min,   255=max, 150=norm,    -1=no change, -2=default
usr_hue         dd   075   ; 1=green, 255=red, 075=neutral, -1=no change, -2=default
usr_saturation  dd   185   ; 1=min,   255=max, 185=norm,    -1=no change, -2=default
usr_contrast    dd   -1    ; Not Supported

public usrDevAudio
usrDevAudio db SIZE VCADEVAUDIO dup (0FFh)

; Image capture Info as set by the user thru IOCTL 6B "Set Capture Image Size"
;
usr_X_Left      dd   0          ; Offset in X from the left of the image
usr_Y_Top       dd   0          ; Offset in Y from the top of the image
usr_Y_Height    dd   480        ; Height of image
usr_X_Width     dd   640        ; Width  of image
usr_ScaleFactor dd   4          ; Scale image down by this factor
usr_DX_Left     dd   0          ; Offset in X from the left of Display
usr_DY_Top      dd   0          ; Offset in Y from the top of Display
usr_DY_Height   dd   480/4      ; Height of image
usr_DX_Width    dd   640/4      ; Width  of image

; Image capture Rate as set by the user thru IOCTL 67 "Set Capture Rate"
;
usr_FPS         dd   10         ; Frames Per Second or MicroSeconds per Frame
usr_FPSflags    dd    0         ; Default to Frames Per Second 1=MicoSeconds
usr_keycolor    dd   0h         ; Key Color

warmStart       db   0
baseio          dw   0          ; cards Base IO port address
baseaddr        dw   0Fh        ; cards Base IO port address
reg3_4680       db   0h         ; 4680 Reg 3 White level Reg
public    baseio, baseaddr, reg3_4680
;************** Config Data must Match CFGSTRUCT  **************** Start ****
config_data            equ $
config_wPortAddr       dw ?
config_wVideoAddr      dw ?
config_wCfgFlags       dw ?
config_wVideoSource    dw ?
config_bColorSettings  db NO_COLOR_SETTINGS dup (?)
config_PCVideoTable    db SIZE PCVIDEOTBL dup (?)
config_PhixelTable     db SIZE PHIXELTBL  dup (?)
config_aMode           db SIZE MODE * (NO_VIDEO_MODES+1) dup (?)
config_wPALAcqWindow   dw 4 dup (?)
config_wNTSCAcqWindow  dw 4 dup (?)
config_aReserved       db 44 dup (?)
config_wBoardType      dw 0; 
config_bVolume         db 0; 
config_bTunerType      db 0; 
config_bRFRegion       db 0; 
config_bUsed0          db 0; 
config_wChannel        dw 5
config_WUsed1          dw 0; 
config_ulFinetune      dd 0
config_dataEnd         equ $
;************** Config Data must Match CFGSTRUCT  **************** End ******
public  _AcquisitionWindow
public  _iVideoMode            ;Video mode number
public  _wVideoWidth           ;Width of acquired video
public  _wVideoHeight           ;Height of acquired video
public  _wVersion               ;Chip version number
public  _wBoardType

_AcquisitionWindow dw 00h, 1Ch, 2F8h, 21Ch, 00h, 1Ch, 278h, 1F4h
_iVideoMode        db SIZE MODE dup (0) ;Video mode number
_wVideoWidth       dw (0)               ;Width of acquired video
_wVideoHeight      dw (0)               ;Height of acquired video
_wVersion          dw (0)               ;Chip version number
_wBoardType        dw (0)               ; Type of board RGB16, RGB24, YUV411




;Default Setting
D_brightness        equ   240
D_hue               equ   128
D_saturation        equ   128
D_contrast          equ   128
D_Red               equ   128
D_Green             equ   128
D_Blue              equ   128

;INI file Default Setting
ID_brightness        dd   D_brightness
ID_hue               dd   D_hue
ID_saturation        dd   D_saturation
ID_contrast          dd   D_contrast
ID_Red               dd   D_Red
ID_Green             dd   D_Green
ID_Blue              dd   D_Blue


; These Registers have different offsets for MC vs ISA bus card (set during Init)
BANK_REG        dw  405h
HUE_REG         dw  406h
SATURATION_REG  dw  407h

  Public frame_info
Frame_info      db  0           ; List of Open Instance


  Public OI_LIST, OI_CURR
OI_LIST         dd  0           ; List of Open Instance
OI_CURR         dd  0           ; Current Open Instance


OC_FN_OFFSET  equ  13           ; Offset to File Handle in OPEN and Close IOCTL
GN_FN_OFFSET  equ  23           ; Offset to File Handle in Generic IOCTL

Public   bBoardNMG
bBoardNMG        db 0           ; New Media Graphic Board Type
; NMG Board types - stored in EEPROM
NMG_ISA     equ  0  ; old boards
NMG_SL      equ  1  ; SL - 1 input only
NMG_TVVW    equ  2  ; SL with Tuner
NMG_CM      equ  3  ; now ISA - has VBUS
NMG_TVVW2   equ  4  ; SL with new tuner
NMG_MC      equ  5  ; for Big Blue Bus

public  cur_FineTune, cur_Frequency, cur_options
cur_FineTune  dd 0   ; Channel fineTune value
cur_Frequency dd 0   ; Frequency
cur_options   dd 0   ; Options (Frequency vs  Channel)

Public typetuner
typetuner dw 0  ; Type of Tuner on the card

DATA ENDS
;*******************************************************************************

subttl Strategy Routine
page
_TEXT     SEGMENT  word public 'CODE' USE16  ;Define code segment
          assume cs:_TEXT,ds:DATA,es:NOTHING

;-------------------------------------------------------------------------------
; Far Procedure STRATEGY gets the request packet and based on its command code
; branches to the appropriate subroutine. Upon return from the subroutine,
; the request is signalled serviced with or without error.
;-------------------------------------------------------------------------------
STRATEGY PROC  FAR
         push  gs
         mov   gs,Selector1             ; Selector to the cards Memory

                                        ; IP (ES:BX) = request packet address
         and   IP._Stat,error_s + unknown_command
         mov   al,byte ptr IP._Cmd      ; Command code
         cmp   al,0                     ; Is it INIT call ?
         jne   strat13                  ; no,
         mov   IP._Stat,0
         call  INIT                     ; yes,
         cmp   ax,0                     ; Init's Return Code non-zero= failure
         jnz   stratGF                  ; Did init Fail?
         jmp   strat8                   ; go to common exit
strat13: cmp   al,13                    ; is it OPEN call ?
         jne   strat14                  ; no
         call  OPEN                     ; yes
         jmp   strat8                   ; go to common exit
strat14: cmp   al,14                    ; is it CLOSE call ?
         jne   strat16                  ; no
         call  CLOSE                    ; yes
         jmp   strat8                   ; go to common exit
strat16: cmp   al,16                    ; is it IOCTL call ?
         jne   strat7                   ; no, go to unknown command
         mov   IP._Stat,0
         call  IOCTL                    ; do IOCTL processing
         jmp   strat8                   ; 
stratGF: or    IP._Stat,error_s + general_failure
         jmp   strat8
strat7:  or    IP._Stat,error_s + unknown_command
strat8:  or    IP._Stat,done            ; set complete flag
         pop   gs
         ret
STRATEGY ENDP


subttl Strategy Routine
page
;-------------------------------------------------------------------------------
; Procedure for handling General IOCTLs for device
;-------------------------------------------------------------------------------
IOCTL    PROC  NEAR
;        int 3  ;<<----------------------<<<<<<<<<<<<<<<<
         push  es                       ; save request packet pointer
         push  bx                       ; 
         cmp   GIO._cat,CAPTURE_DEVICE  ; Check for category  (same as IP address)
         je    IOCTL_LOOKUP             ; 
;-------------------------------------------------
         mov   ax,cat_not_supported
         jmp   gout

;TABLE LOOKUP for IOCTL hander Routine
IOCTL_LOOKUP:
;        int 3  ;<<----------------------<<<<<<<<<<<<<<<
        mov     cx,[IocTab]             ; Get # of functions in table into CX
        xor     eax,eax
        mov     al,GIO._code            ; al =  function
        sub     al,60h                  ; Base Entry Which Entry in the table
        jb      chk_n                   ; function out of range (too small)
        cmp     al,cl                   ; Function in range? (too big)
        ja      chk_n                   ; function out of range

        shl     eax,1                   ; word offset for dispatch table
        call    IocTab[eax+2]           ; Call the function


        jmp     gout                    ; Ioctl done
;


chk_n:
         mov   ax,fun_not_supported
gout:
         pop   bx                       ; restore request packet pointer
         pop   es                       ; 
         cmp   ax,0                     ; Has any error occured?
         jz    goutok                   ; NO, then jump
         or    ax,error_s               ; YES, then turn on  error flag
         or    IP._Stat,ax              ; put in status field
goutok:
         RET
IOCTL    ENDP

CODE_unk PROC NEAR
;-------------------- Unknow Function ------------------------
         mov   ax,fun_not_supported
         ret
CODE_unk ENDP


CODE_60H PROC NEAR
;-------------------- .INI File Setup Info ------------------------
; int 3 ; <---------------<<<<<<<<<<<<<
        mov   ax,word ptr GIO._Data+2 ; get address of data area
        mov   bx,word ptr GIO._Data   ; 
        mov   es,ax                   ; es:bx-->data area
        xor   esi,esi
        mov   si,bx                   ; Source
        mov   di,offset config_data   ; Destination
        mov   ecx,offset config_dataEnd  ; End of Config Data
        sub   ecx,offset config_data     ; Minus Start = Lenghth
;//      mov   ecx,SIZE CFGSTRUCT + 1  ; Size of Config Data
        push  ds
        push  es
        push  es
        mov   ax,ds
        mov   es,ax
        pop   ds
        REP   MOVS byte ptr es:[di], byte ptr ds:[si] ; copy the Dafault Info
        pop   es
        pop   ds

        ; Set Values Read from Device= inc config.sys
        cmp   baseio,0
        je    IO_port_set              ; If not set by config.sys use ini file
        mov   ax,baseio
        mov   config_wPortAddr,ax
IO_port_set:
        mov   ax,baseaddr
        mov   config_wVideoAddr,ax

        mov   si,offset config_wPALAcqWindow  ;Source
        mov   di,offset _AcquisitionWindow    ;Destination
        mov   ecx,2*4                         ;Size NTSC&PAL acquisition window data
        push  es
        mov   ax,ds
        mov   es,ax
        REP   MOVS word ptr es:[di], word ptr ds:[si] ; copy the Dafault Info
        pop   es

        ; Load White Balance Level for SuperVideo Windows
;        cmp   type_card,1                    ; Is this SuperVideo         card
;        jne   TDA4680_done
        mov   dx,word ptr config_PhixelTable ; Number of chips
        mov   si,offset config_PhixelTable    ;String to search in
        add   si,size cPhixelChips
next_chip:
        mov   ecx,8
        push  es
        mov   ax,ds
        mov   es,ax
        mov   di,offset TDA4680_S             ;String to search for
        push  si
        REP   CMPSB                           ; search for string
        pop   si
        pop   es
        je    found_TDA4680
        add   si,SIZE PHIXELCHIP              ; Next Struc
        dec   dx
        jnz   next_chip
        jmp   TDA4680_done
found_TDA4680:
        add   si,size aChipId
        add   si,size wPhixelAddr
        mov   cx,ds:[si]               ; Read number of regs
        add   si,size cPhixelRegs
        ;Find Reg 3 and update
next_reg:
        cmp   byte ptr ds:[si],3
        je    found_reg3
        add   si,SIZE REGENTRY
        loop  next_reg
found_reg3:
;        mov   al,reg3_4680
;        mov   byte ptr ds:[si+1],al
        mov   al,byte ptr ds:[si+1]
        mov   reg3_4680, al
TDA4680_done:

        ; Save the Default Source Destination Rectangle
        mov   cx,config_wCfgFlags             ;Which input format (PAL/NTSC)?
        and   cx,CF_NTSC                      ;Input format is NTSC?
        jnz   NTSC_format                     ;NTSC Format

PAL_format:
        mov   si,offset config_wPALAcqWindow  ;Source
        mov   NTSC_card,0
        jmp   Copy_default_AcqWindow

NTSC_format:
        mov   si,offset config_wNTSCAcqWindow ;Source
        mov   NTSC_card,1

Copy_default_AcqWindow:
        xor   eax,eax
        mov   ax,ds:[si+0]
        mov   S_X_Left,eax
        mov   ax,ds:[si+2]
        mov   S_Y_Top,eax
        mov   ax,word ptr ds:[si+6]
        mov   S_Y_Height,eax
        mov   ax,ds:[si+4]
        mov   S_X_Width,eax

        ; Save the Defaults Color,Brightness,Hue, etc
        xor   eax,eax
        mov   si, offset config_bColorSettings ; Default Video Adjustments
        mov   al,ds:[si]+(BRIGHTNESS)  ; BRIGHTNESS
        shl   al,2
        mov   I_BRIGHTNESS,eax
        mov   ID_BRIGHTNESS,eax
        mov   al,ds:[si]+(SATURATION); SATURATION
        shl   al,2                     ; convert 0-63 to 0-255
        mov   I_SATURATION,eax
        mov   ID_SATURATION,eax
        mov   al,ds:[si]+(CONTRAST  )  ; CONTRAST
        shl   al,2                     ; convert 0-63 to 0-255
        mov   I_CONTRAST,eax
        mov   ID_CONTRAST,eax
        mov   al,ds:[si]+(HUE       )  ; HUE
        add   al,128                   ; conver -128-0-128 to 0-255
        mov   I_HUE,eax
        mov   ID_HUE,eax
        mov   al,ds:[si]+(RED       )  ; RED
        shl   al,2                     ; convert 0-63 to 0-255
        mov   ID_RED,eax
        mov   al,ds:[si]+(GREEN     )  ; GREEN
        shl   al,2                     ; convert 0-63 to 0-255
        mov   ID_GREEN,eax
        mov   al,ds:[si]+(BLUE      )  ; BLUE
        shl   al,2                     ; convert 0-63 to 0-255
        mov   ID_BLUE,eax

        call  PCV_Initialize

;       call  PCV_EnableColorKey

        ; Set up default Audio Info
        mov   si,offset usrdevAudio ; Current local Audio setting
        mov   dax.DEVAUD_ulFUNCTION,VCADEV_AUDIO_FUNC
        mov   dax.DEVAUD_ulLENGTH,SIZE VCADEVAUDIO
        mov   dax.DEVAUD_ul_RESV01,0
        cmp   type_card,0           ; Is this a Video Blaster
        je    no_BASS_TREBLE
        mov   dax.DEVAUD_ulL_BASS,156
        mov   dax.DEVAUD_ulR_BASS,VCA_NOT_SUPPORTED
        mov   dax.DEVAUD_ulL_TREBLE,156
        mov   dax.DEVAUD_ulR_TREBLE,VCA_NOT_SUPPORTED
no_BASS_TREBLE:

        xor   eax,eax
        mov   al,config_bvolume
        mov   DAX.DEVAUD_ulFLAGS,VCADEV_AUDIO_FLAG_MUTE  ; Mute Audio at start

do_audio:
        and   eax,03Fh
        shl   eax,2
        mov   DAX.DEVAUD_ulL_Volume,eax
        mov   DAX.DEVAUD_ulR_Volume,eax
        CMP   warmstart,1           ; Make all future Inits a warm start
        JZ    SKIP_VOL_SET
        push  es
        push  bx
        push  ds
        pop   es
        mov   bx,offset usrDevAudio
        CALL  far ptr DevSetAudio      ; Change Audio Levels & Mute
        pop   bx
        pop   es
SKIP_VOL_SET:
        CALL  far ptr Switch_Audio     ; Change Audio to new Connector

        mov   al,config_bvolume
        mov   DAX.DEVAUD_ulFLAGS,VCADEV_AUDIO_FLAG_UNMUTE  ; Assume no Mute
        ; High order bit of volume is Mute bit
        test  al,80h
        jz    Mute_set
        mov   DAX.DEVAUD_ulFLAGS,VCADEV_AUDIO_FLAG_MUTE    ; Mute Audio
Mute_set:

        mov   al,_IvideoMode        ; Get Mode of Video Card
        and   eax,0ffh
        mov   unused1,eax
        mov   warmstart,1           ; Make all future Inits a warm start

;;;;;; No Longer need to set Channel at Init MCD will set it to its default
;; Init The Tuner
;ifdef TOOLKIT
;       ; nothing
;else
;        pushad
;
;        call far ptr _TunerInit
;        ; Was the channel Information OK
;        cmp   ax,0
;        jne   Channel_Init_Done
;
;        ; Save Current Settings
;        push  eax
;        xor   eax,eax
;        mov   ax,Config_wChannel    ; Channel
;        mov   cur_Frequency,ax
;        mov   eax,config_ulfinetune ; Fine Tune
;        mov   cur_FineTune,eax
;        pop   eax
;
;Channel_Init_Done:
;        popad
;endif


         xor   ax,ax                  ; RC = Success
         ret
CODE_60H ENDP


CODE_61H PROC NEAR
;-------------------- Save Setup Info ------------------------

         ; Save all instance information
         PUSHFD
         CLI
         mov   cx,GIO.GN_FN_OFFSET     ; System File Number
         CALL  far ptr FIND_OI         ; Is it In the List?
         CMP   EAX,0                   ; Not in List
         JNE   Save_Fail               ; Error - not found in the list

         mov   OI_CURR,0               ; Mark as NO current Instance
         ;......... do save suff ......
         ;......... Save Current Setting
         xor   ax,ax                   ; RC = Success
         jmp   save_exit               ; all done

save_fail:
         mov   ax,-1

save_exit:
         POPFD
         RET
CODE_61H ENDP

CODE_62H PROC NEAR
;-------------------- Restore Setup Info ------------------------

         PUSHFD
         CLI
         ; Restore all instance information
         mov   cx,GIO.GN_FN_OFFSET     ; System File Number
         CALL  far ptr FIND_OI         ; Is it In the List?
         CMP   EAX,0                   ; Not in List
         JNE   Restore_Fail            ; Error - not found in the list

         mov   OI_CURR,eax             ; Mark as current Instance
         ;......... do restore suff ......
         ;......... Restore Setting ......
         xor   ax,ax                   ; RC = Success
         jmp   restore_exit            ; all done

restore_fail:
         mov   ax,-1

restore_exit:
         POPFD
         ret
CODE_62H ENDP


CODE_6DH PROC NEAR
;-------------------- Get Default Info (6DH) --------------------------

       ; Load up Default info for caller
       mov   dx,GIO.GN_FN_OFFSET     ; System File Number
       mov   ax,word ptr GIO._Data+2  ; get address of data area
       mov   bx,word ptr GIO._Data    ; 
       mov   es,ax                    ; es:bx-->data area

       mov   ecx,GIX.DI_Length
       cmp   ecx,0
       je    too_Small
       cmp   ecx,D_Length
       jb    setup_copy             ; Caller Buffer is smaller use caller size
       mov   ecx,D_length           ; else use our size
Setup_copy:
       mov   si,offset Defaults
       mov   di,bx

copy_defaults:
       REP  MOVS byte ptr es:[di], byte ptr ds:[si] ; copy the Dafault Info

       ; Find  Stream Instance
       mov   di,bx                    ; Start of Parm List
       mov   es:[di].DI_ulFileNum,-1; Assume Invalid Instance
       mov   fs,flatsel
       mov   cx,dx                    ; System File Number
       call  far ptr FIND_OI
       cmp   eax,0                    ; 0 = Invalid Stream Handle
       je    CODE_6DH_DONE            ; Instance is not active
       xor   ebx,ebx
       mov   bx,fs:[eax].OI_FILENUM   ; File Number for this OPEN
       mov   es:[di].DI_ulFileNum,EBX ; File Number for the Caller

       sub   ax,ax                    ; indicate no error
       jmp   CODE_6DH_DONE

Too_Small:
       mov   ax,1                                     ; !!! Too Small

CODE_6DH_DONE:
       ret
CODE_6DH ENDP

CODE_6EH PROC NEAR
;-------------------- VALIDATE CAPTURE IMAGE SIZE (6EH) --------------------------
      Scale             EQU     12h                  ; Scale Down Image by
      Update            EQU     16h                  ; Source updated

       LBegin 24h
       ; Address of Parms
       mov   ax,word ptr GIO._Data+2  ; get address of data area
       mov   bx,word ptr GIO._Data    ; 
       mov   es,ax                    ; es:bx-->data area
       mov   byte ptr[ebp-update],0   ; Assume source not updated

       ; X and Y source must be >= X and Y destinations
       mov   eax,GIX.CR_Source_Y_Height
       mov   ecx,GIX.CR_Dest_Y_Height
       cmp   eax,ecx
       jae   Check_width
       mov   GIX.CR_Source_Y_Height,ecx
       mov   byte ptr[ebp-update],1   ; source updated

Check_width:
       mov   eax,GIX.CR_Source_X_Width
       mov   ecx,GIX.CR_Dest_X_Width
       cmp   eax,ecx
       jae   Source_calc_done
       mov   GIX.CR_Source_X_Width,ecx
       mov   byte ptr[ebp-update],1   ; source updated

source_calc_done:
       cmp     byte ptr[ebp-update],0     ; Source was not updated
       je      valid_rectl_6E
       mov     ax,VCAERR_INVALID_PARM
       jmp     vrDone

valid_rectl_6E:                          ; Valid Rectangle
       ;Retrun Code = success
       sub   ax,ax                       ; indicate no error

vrDone:
       lend
       ret
CODE_6EH ENDP

CODE_68H PROC NEAR
;-------------------- QUERY Input Connector Signal ---------------------

       call far ptr _QuerySignal

CODE_68H_Done:
       ret
CODE_68H ENDP


CODE_69H PROC NEAR
;-------------------- SET/QUERY Tuner Channel -----------------------------

       mov   ax,word ptr GIO._Data+2  ; get address of data area
       mov   bx,word ptr GIO._Data    ; 
       mov   es,ax                    ; es:bx-->data area

       ; Does The card have a tuner
       mov   ax,VCAERR_CHANNEL_NO_TUNER      ; Assume no Tuner Installed
       cmp   Tuner,1                         ; Is tuner Installed
       jne   CODE_69H_Done

       ; Check if Options are supported by this Device
       mov   eax,GIX.TUC_ulOptions
       or    eax, TUC_FREQUENCY
       cmp   eax, TUC_FREQUENCY
       mov   ax,VCAERR_INVALID_PARM
       jne   CODE_69H_Done

       ; Set or Query Command
       mov   eax,GIX.TUC_ulFlags
       cmp   eax,TUC_SET_CHANNEL
       je    Set_Channel
query_channel:
       mov   GIX.TUC_usResv01,0
       mov   GIX.TUC_usresv02,0
       mov   eax,cur_FineTune
       mov   GIX.TUC_lFineTune,eax
       mov   eax,cur_Frequency
       mov   GIX.TUC_ulFrequency,eax
       mov   eax,cur_options
       mov   GIX.TUC_ulOptions,eax

       sub   ax,ax                    ; indicate no error
       jmp   CODE_69H_Done

Set_Channel:
ifdef TOOLKIT
       ; Tuner support not included
       mov  ax,VCAERR_CHANNEL_SKIP  ; Return Code
else
       push  ebx
       push  es
       mov   eax,GIX.TUC_ulFrequency
       push  eax
       mov   eax,GIX.TUC_lFineTune
       push  eax
       xor   eax,eax
       push  eax                    ; Reserved
       push  eax                    ; Reserved
       mov   eax,GIX.TUC_ulOptions
       push  eax
       call  far ptr _SetTunerChannel
       pop   es
       pop   ebx
endif

       ; Was the channel Information OK
       cmp   ax,0
       jne   CODE_69H_Done

       ; Save Current Settings
       push  ax
       mov   eax,GIX.TUC_lFineTune
       mov   cur_FineTune,eax
       mov   eax,GIX.TUC_ulFrequency
       mov   cur_Frequency,eax
       mov   eax,GIX.TUC_ulOptions
       mov   cur_options,eax
       pop   ax

CODE_69H_Done:
       ret
CODE_69H ENDP

CODE_6AH PROC NEAR
;-------------------- SET Input Video Source Connector      (6AH) ------------

       ; Save Parms away for use later by Image Capture Routines
       mov   ax,word ptr GIO._Data+2  ; get address of data area
       mov   bx,word ptr GIO._Data    ; 
       mov   es,ax                    ; es:bx-->data area

       ; Save Video Acquisition Source window Info
       mov   eax,GIX.VI_INPUT_CONNECTOR
       cmp   eax,-1
       jne   good_connector
       xor   eax,eax
       mov   ax,config_wVideoSource
       mov   GIX.VI_INPUT_CONNECTOR,eax
good_connector:
       cmp   ax,0
       jae   good_connector1
       mov   ax,VCAERR_INVALID_PARM
       jmp   code_6ah_done
good_connector1:
       mov   cx,Videoinputs
       cmp   cx,ax
       ja    good_connector2
       mov   ax,VCAERR_INVALID_PARM
       jmp   code_6ah_done
good_connector2:
       push  ax
       mov   config_wVideoSource,ax
       call  far ptr PCV_SetVideoSource
       CALL  far ptr Switch_Audio     ; Change Audio to new Connector

       sub   ax,ax                    ; indicate no error
CODE_6AH_Done:
       ret
CODE_6AH ENDP

CODE_6BH PROC NEAR
;-------------------- SET Source and Destination Image Info (6BH) ------------

       ; Save Parms away for use later by Image Capture Routines
       mov   ax,word ptr GIO._Data+2  ; get address of data area
       mov   bx,word ptr GIO._Data    ; 
       mov   es,ax                    ; es:bx-->data area

       ; Save Video Acquisition Source window Info
       mov   eax,GIX.CR_Source_X_Left
       mov   usr_X_Left,eax
       mov   eax,GIX.CR_Source_Y_Top
       mov   usr_Y_Top,eax
       mov   eax,GIX.CR_Source_Y_Height
       mov   usr_Y_Height,eax
       mov   eax,GIX.CR_Source_X_Width
       mov   usr_X_Width,eax

       ; Save Video Distination/Display window Info
       mov   eax,GIX.CR_Dest_X_Left
       mov   usr_DX_Left,eax
       mov   eax,GIX.CR_Dest_Y_Top
       mov   usr_DY_Top,eax
       mov   eax,GIX.CR_Dest_Y_Height
       mov   usr_DY_Height,eax
       mov   eax,GIX.CR_Dest_X_Width
       mov   usr_DX_Width,eax

       ; Set Acquisition window for Video Source
       mov   eax,usr_Y_Height
       push  ax
       mov   eax,usr_X_Width
       push  ax
       mov   eax,usr_Y_Top
       push  ax
       mov   eax,usr_X_Left
       push  ax
       call    far ptr PCV_SetAcquisitionWindow

       ; Set video window location and size on the monitor
       push  1                       ; Fit to window
       mov   eax,usr_DY_Height
       push  ax
       mov   eax,usr_DX_Width
       push  ax
       mov   eax,usr_DY_Top
       push  ax
       mov   eax,usr_DX_Left
       push  ax
       call  PCV_CreateWindow

       sub   ax,ax                    ; indicate no error
       ret
CODE_6BH ENDP

CODE_6CH PROC NEAR
;-------------------- CAPTURE IMAGE AND SCALE RAM BUFFER (6CH) ------------------
      Buf_Lock          EQU     12h                  ; Linear Buffer Lock Address
      G_Buff_Addr       EQU     16h                  ; Global Buffer Address
      Input_Parms       EQU     20h                  ; Input Parms Address

       inc  [GetI2RAM]                               ; Count Number of Calls

       LBegin 24h
       mov   ax,word ptr GIO._Data+2  ; get address of data area
       mov   bx,word ptr GIO._Data    ; 
       mov   es,ax                    ; es:bx-->data area
       mov   [ebp-Input_parms],bx     ; Save ptr to input parms

       ;Check to make sure Source and Destination Rectangles are valid
       ;Partial Check below just to get scale info
       ;**** caller of this function ->M U S T<- always make sure ****
       ;**** Source and Destination info are <= maxium size       ****
       ;**** Destination Height and Width / 8 is a Whole Number   ****
       mov     ecx,GIX.GIS_Dest_Y_Height  ; Y_Height for Dect   Rect
       cmp     ecx,0                      ; Must be non-Zero
       je      Invalid_rectl_6C           ; not supported
       mov     ecx,GIX.GIS_Dest_X_Width   ; X_Width for Dect   Rect
       cmp     ecx,0                      ; Must be non-Zero
       je      Invalid_rectl_6C           ; not supported
       xor     edx,edx                    ; Zero for Divide

       PUSHFD
;       CLI                               ; Block Interrupts

       ;Lock Down user buffer so ring 0 can access it to copy image into
       lea     esi,[ebp-Buf_Lock]                  ; esi:Lock Handle Location
       mov     ax,ss                               ; Stack Segment
       mov     ecx,GIX.GIS_Capture_Buf_Len         ; Lenght of image buffer
       mov     ebx,GIX.GIS_Capture_Buf_Ptr         ; Buffer to put image into
       call    LockMem
       jc      Invalid_Buff_6C                     ; Exit With Error

       mov     [ebp-G_Buff_addr],eax               ; Save Global Copy Buffer Address

       mov     ax,FlatSel               ; load up flat selector for VMAlloced memory
       mov     fs,ax

       ; Put Parameters on the stack for the Call to the Copy Image buffer routines
       push      es
       mov       bx,[ebp-Input_parms]        ; Get ptr to input parms
       mov       eax,[Lin_addr]              ; Source Buffer
       push      eax
       mov       eax,[ebp-G_Buff_addr]       ; Destination Buffer
       push      eax
       mov       eax,GIX.GIS_Dest_Y_Height   ; Y_Height for Dest   Rect
       push      ax
       mov       eax,GIX.GIS_Dest_X_Width    ; X_Width for Dest   Rect
       push      ax
       mov       eax,0                       ; Offset in Y from the top
       push      ax
       mov       eax,0                       ; Offset in X from the left
       push      ax

;***************************************************************************
;************* Copy the Buffer from the H/W ********************************
;************* Copy the Buffer from the H/W ********************************
;***************************************************************************
      call       PCV_ReadVideoRect       ; Read Image From the H/W to a buffer

       pop       es
CopyDone_6C:

       POPFD                              ; Enable Interrupts (back to old value)

       ; Write Frame Info on top of image
       cmp  frame_info,1
       jne  Frame_info_done

       ; Put Frame Info into the buffer
       mov     edi,[ebp-G_Buff_addr]    ; Destination Buffer
       mov     bx,[ebp-Input_parms]        ; Get ptr to input parms
       mov     eax,GIX.GIS_Dest_X_Width ; X_Width for Dect   Rect
       mov     cx,fs
       mov     es,cx
       call    ADD_SF_INFO              ; Add Frame Info (debug Info)
Frame_info_done:


       ;UnLock users image copy buffer
       lea     esi,[ebp-Buf_Lock]            ; esi:Lock Handle Location
       mov     ax,ss                         ; Stack Segment
       mov     ebx,[ebp-G_Buff_addr]         ; Get Global Copy Buffer Address
       call    UnLockMem
       jc      Invalid_Buff_6C               ; Exit With Error

       mov     ax,VCAERR_SUCCESS             ; indicate no error
       jmp     GetISDone

Invalid_Buff_6C:                             ; Invalid Buffer
       mov     ax,VCAERR_INVALID_BUFFER
       jmp     GetISDone

Invalid_rectl_6C:                               ; Invalid Rectangle
       mov     ax,VCAERR_INVALID_RECT
       jmp     GetISDone

GetISDone:
         lend
         ret
CODE_6CH ENDP

CODE_6FH PROC NEAR
;-------------------- CAPTURE IMAGE TO RAM BUFFER (6FH) --------------------------
      Buf_Lock          EQU     12h                  ; Linear Buffer Lock Address
      G_Buff_Addr       EQU     16h                  ; Global Buffer Address

       inc  [GetI2RAM]                               ; Count Number of Calls

       LBegin 20h
       mov   ax,word ptr GIO._Data+2  ; get address of data area
       mov   bx,word ptr GIO._Data    ; 
       mov   es,ax                    ; es:bx-->data area


       PUSHFD
;       CLI                               ; Block Interrupts

       ;Lock Down user buffer so ring 0 can access it to copy image into
       lea     esi,[ebp-Buf_Lock]                  ; esi:Lock Handle Location
       mov     ax,ss                               ; Stack Segment
       mov     ecx,GIX.GI_Capture_Buf_Len        ; Lenght of image buffer
       mov     ebx,GIX.GI_Capture_Buf_Ptr        ; Buffer to put image into
       call    LockMem
       jc      GetIDone                            ; Exit With Error in EAX  (invalid Buffer)

       mov     [ebp-G_Buff_addr],eax               ; Save Global Copy Buffer Address

       mov     ax,FlatSel               ; load up flat selector for VMAlloced memory
       mov     fs,ax

       ; Put Parameters on the stack for the Call to the Copy Image buffer routines
       mov       eax,offset offset_table ; Offset Table Address
       push      eax

       mov       eax,offset bank_table   ; Bank Table Address
       push      eax

       mov       eax,usr_ScaleFactor     ; Scale
       push      eax

       mov       eax,usr_Y_Height        ; Y_Height
       push      eax

       mov       eax,usr_X_Width         ; X_Width
       push      eax

       mov       eax,usr_Y_Top           ; Y_Top
       push      eax

       mov       eax,usr_X_Left          ; X_Left
       push      eax

       mov       eax,[ebp-G_Buff_addr]   ; Destination Buffer
       push      eax

       mov       eax,[Lin_addr]          ; Source Buffer
       push      eax


;***************************************************************************
;************* Copy the Buffer from the H/W ********************************
;************* Copy the Buffer from the H/W ********************************
;***************************************************************************


CopyDone:
       add       esp,4*9                 ; Remove the parameters from the stack

       POPFD                              ; Enable Interrupts (back to old value)

       ;UnLock users image copy buffer
       lea     esi,[ebp-Buf_Lock]            ; esi:Lock Handle Location
       mov     ax,ss                         ; Stack Segment
       mov     ebx,[ebp-G_Buff_addr]         ; Get Global Copy Buffer Address
       call    UnLockMem
       jc      GetIDone                      ; Exit With Error in EAX  (invalid Buffer)

       sub   ax,ax                    ; indicate no error

GetIDone:
         lend
         ret
CODE_6FH ENDP


;CODE_70H PROC NEAR
;-------------------- GET BUFFER ADDRESSING (70H) --------------------------
;         mov   ax,word ptr GIO._Data+2  ; get address of data area
;         mov   bx,word ptr GIO._Data    ;
;         mov   es,ax                    ; es:bx-->data area
;;         mov   eax,lin_addr_p           ; get linear address
;         mov   eax,P_lin_addr           ; get linear address of copy buffer (interrupt)
;         mov   GIX.BA_buf_addr,eax        ; .
;         mov   eax,aper_size            ; return the aperature size
;         mov   GIX.BA_buf_len,eax         ; .
;
;         mov   GIX.BA_buf_banks,256       ; return number of banks
;
;         sub   ax,ax                    ; indicate no error
;         ret
;CODE_70H ENDP

CODE_71H PROC NEAR
;-------------------- SELECT VRAM BANK NUMBER (71H) ------------------------
         mov   ax,word ptr GIO._Data+2  ; get address of data area
         mov   bx,word ptr GIO._Data    ; 
         mov   es,ax                    ; es:bx-->data area

         mov   eax,GIX.SB_bank_num     ; get bank number to select
         mov   di,[BANK_REG]           ; bank register offset
         mov   byte ptr gs:[di],al ; select bank

         ret
CODE_71H ENDP

CODE_72H PROC NEAR
;-------------------- CONTINOUS FRAME CAPTURE (72H) --------------------------
        push  ebx                    ; save Registers used
        push  es

        call PCV_unFreezeVideo

        sub   ax,ax                  ; indicate no error
        pop   es                     ; Restore registers used
        pop   ebx
        ret
CODE_72H ENDP

CODE_74H PROC NEAR
;-------------------- SINGLE FRAME CAPTURE (74H) --------------------------
        push  ebx                    ; save Registers used
        push  es

        inc   [Count_74s]            ; Number of times called

        call PCV_FreezeVideo

        xor   ax,ax                  ; Set RC to success
caperr:

        pop   es                     ; Restore registers used
        pop   ebx
        ret
CODE_74H ENDP

CODE_75H PROC NEAR
;-------------- SET/QUERY VIDEO ADJUSTMENTS (75H) --------------------------


        mov   ax,word ptr GIO._Data+2  ; get address of data area
        mov   bx,word ptr GIO._Data    ; 
        mov   es,ax                    ; es:bx-->data area

        mov   eax,GIX.SV_set_brightness ; get the brightness value to set
        cmp   eax,-1              ; check for no change
        jz    getbrt              ; no change, just return current setting

        cmp   eax,-2              ; check for reset
        jnz   setbrt              ; not reset, must be a value to set
        mov   eax,D_brightness    ; otherwise, we are resetting default
setbrt:
        mov   usr_brightness,eax  ; save current user value
        and   ax,00FFh            ; Max Brightness
        shr   ax,2                ; 0-3F Max brightbess to card
        push  BRIGHTNESS          ; Adjust Brightness
        push  ax                  ; Adust to this value
        call  PCV_SetColor        ; Set it
getbrt:
        mov   eax,usr_brightness  ; return the current user brightness value
        mov   GIX.SV_ret_brightness,eax

; now do the hue
        mov   eax,GIX.SV_set_hue  ; get the hue value to set
        cmp   eax,-1              ; check for no change
        jz    gethue              ; no change, just return current setting
        cmp   eax,-2              ; check for reset
        jnz   sethue              ; not reset, must be a value to set
        mov   eax,D_hue           ; red and green are inverted actually 255-75
sethue:
        mov   usr_hue,eax         ; save current user value
        and   ax,00FFh            ; Max
        sub   ax,128              ; 
        and   ax,00FFh            ; 
        push  HUE                 ; Adjust Hue
        push  ax                  ; Adust to this value
        call  PCV_SetColor        ; Set it

 ;       mov   di,[HUE_REG]        ; find HUE Register offset
 ;       mov   byte ptr gs:[di],al
gethue:
        mov   eax,usr_hue         ; return the current user hue value
        mov   GIX.SV_ret_hue,eax

; now do the saturation
        mov   eax,GIX.SV_set_saturation ; get the sat value from parms
        cmp   eax,-1              ; check for no change
        jz    getsat              ; no change, just return current setting
        cmp   eax,-2              ; check for reset
        jnz   setsat              ; not reset, must be a value to set
        mov   eax,D_saturation    ; otherwise, we are resetting default
setsat:
        mov   usr_saturation,eax  ; save current user value
        and   ax,00FFh            ; Max Brightness
        shr   ax,2                ; 0-3F Max brightbess to card
        push  SATURATION          ; Adjust Saturation
        push  ax                  ; Adust to this value
        call  PCV_SetColor        ; Set it
;        mov   di,[SATURATION_REG] ; find Saturation Register offset
;        mov   byte ptr gs:[di],al
getsat:
        mov   eax,usr_saturation  ; return the current user hue value
        mov   GIX.SV_ret_saturation,eax

; now do the contrast
        mov   eax,GIX.SV_set_contrast ; get the contrast value from parms
        cmp   eax,-1              ; check for no change
        jz    getcon              ; no change, just return current setting
        cmp   eax,-2              ; check for reset
        jnz   setcon              ; not reset, must be a value to set
        mov   eax,D_contrast      ; otherwise, we are resetting default
setcon:
        mov   usr_contrast,eax    ; save current user value
        and   ax,00FFh            ; Max Contrast
        shr   ax,2                ; 0-3F Max contrast for card
        push  CONTRAST            ; Adjust Contrast
        push  ax                  ; Adust to this value
        call  PCV_SetColor        ; Set it
getcon:
        mov   eax,usr_contrast    ; return the current user contrast value
        mov   GIX.SV_ret_contrast,eax

        sub   ax,ax               ; indicate no error
        ret
CODE_75H ENDP


CODE_76H PROC NEAR
;-------------------- SET FPS to stream Image (76H) --------------------------

        LBegin 4h
        push  es
        push  bx

        mov   ax,word ptr GIO._Data+2 ; get address of data area
        mov   bx,word ptr GIO._Data   ; 
        mov   es,ax                   ; es:bx-->data area


        mov   ecx,GIX.SF_Set_FPS      ; Frame Rate
        mov   [usr_FPS],ecx

        mov   ecx,GIX.SF_ulflags      ; FPS or MicroSeconds Per Frame (MPF) flag
        mov   [usr_FPSflags],ecx

        sub   ax,ax                   ; indicate no error

code_76h_done:
        pop   bx                ; restore request packet pointer
        pop   es
        lend
        ret
CODE_76H ENDP

public Device_ioctl
Device_IOCTL  equ  $
CODE_79H PROC NEAR
;-------------------- SET FPS to stream Image (76H) --------------------------

        LBegin 4h
        push  es
        push  bx

        mov   ax,word ptr GIO._Data+2 ; get address of data area
        mov   bx,word ptr GIO._Data   ; 
        mov   es,ax                   ; es:bx-->data area


        mov   ax,fun_not_supported
        mov   ecx,GIX.DEVAUD_ulFUNCTION ; Check IF Audio Ioctl
        cmp   ecx,VCADEV_AUDIO_FUNC
        jne   code_79h_done
        CALL  far ptr DevSetAudio       ; Change Audio Levels

        sub   ax,ax                     ; indicate no error

code_79h_done:
        pop   bx                ; restore request packet pointer
        pop   es
        lend
        ret
CODE_79H ENDP

CODE_80H PROC NEAR
;-------------------- Enable\Disable Display of Video on VGA Monitor (80H) ------------

        push  es
        push  bx

        mov   ax,word ptr GIO._Data+2 ; get address of data area
        mov   bx,word ptr GIO._Data   ; 
        mov   es,ax                   ; es:bx-->data area


        cmp   GIX.EDM_bMonitor,1        ; Monitor ON or OFF?
        je    code_80h_ON             ; Jmp if set to ON

        call  far ptr PCV_DisableVideo; Turn the Monitor OFF

        ; Turn off audio
        CALL  far ptr AudioOFF    ; Turn Audio off

        jmp   code_80h_done

code_80h_ON:
        call  far ptr PCV_EnableVideo ; Turn the Monitor ON

        ; Turn on audio to defaults
        push  es
        push  bx
        push  ds
        pop   es
        mov   bx,offset usrDevAudio
        CALL  far ptr DevSetAudio      ; Change Audio Levels & Mute
        pop   bx
        pop   es
;       CALL  far ptr AudioON_D    ; Turn Audio on to default Values

code_80h_done:
        pop   bx                      ; restore request packet pointer
        pop   es

        sub   ax,ax                   ; indicate no error
        ret
CODE_80H ENDP

CODE_81H PROC NEAR
;-------------------- Enable\Disable Color Key /Transparrent Color (81H) ------------

        push  es
        push  bx

        mov   ax,word ptr GIO._Data+2 ; get address of data area
        mov   bx,word ptr GIO._Data   ; 
        mov   es,ax                   ; es:bx-->data area


        cmp   GIX.EDCK_bColorKeying,1 ; Color Keying  ON or OFF?
        je    code_81h_ON             ; Jmp if set to ON

        call  far ptr PCV_DisableColorKey; Turn OFF
        jmp   code_81h_done

code_81h_ON:
        call  far ptr PCV_EnableColorKey ; Turn ON

code_81h_done:
        pop   bx                      ; restore request packet pointer
        pop   es

        sub   ax,ax                   ; indicate no error
        ret
CODE_81H ENDP

CODE_82H PROC NEAR
;-------------------- Set Color Key /Transparrent Color (81H) ------------

        push  es
        push  bx

        mov   ax,word ptr GIO._Data+2 ; get address of data area
        mov   bx,word ptr GIO._Data   ; 
        mov   es,ax                   ; es:bx-->data area


        mov   eax,GIX.SCK_ulColorKey  ; Color Key value
        cmp   eax,-1                  ; Is this a Query of the current value?
        je    return_CurColor         ; return Current Value
        and   eax,0FFh                ; make sure it's not too big
        push  ax
        mov   usr_keycolor,eax        ; Save Current Setting
        call  far ptr PCV_SetColorKey ; Set Color KEy ValueTurn OFF
return_CurColor:                      ; return Current Value
        xor   eax,eax
        mov   eax,usr_keycolor        ; Get Current Setting
        mov   GIX.SCK_ulColorKey,eax  ; Color Key value
        pop   bx                      ; restore request packet pointer
        pop   es

        sub   ax,ax                   ; indicate no error
        ret
CODE_82H ENDP


subttl OPEN Routine
page
;-------------------------------------------------------------------------------
; Procedure for handling OPEN for device
;-------------------------------------------------------------------------------
OPEN     PROC  NEAR
;     int   3   ; D E B U G <<<<<<<<<<<<<<<<<<----------<<<<<
        cmp   VB_opens,1               ; Is the device already open?
        mov   ax, Device_in_use        ;Device Already in use error code
        je    OPENt                    ; yes - block open

        mov   warmstart,0            ; Make all future Inits non warm start
        ; Allocate and Initialize an Open Instance structure
        mov   ecx,SIZE OPEN_INSTANCE ; Size of storage to allocate
        mov   edi,-1
        ;         876543210
        mov   eax,000000010B ; Allocate in Global address space, fixed  storage
        mov   dl,DevHlp_VMAlloc
        call  device_hlp
        jc    OPENx                     ; Did we get the storage   Carry=1 is a failure

        ; Add new Stream Instance
        PUSHFD
        CLI                              ; Turn Off Interrupt (Critical Section)
        mov   fs,flatsel
        MOV   ECX,OI_List                ; Find first OI in the List
        mov   fs:[eax].OI_pNext,ECX      ; New OI points to old  Head of the OI_LIST
        MOV   OI_List,EAX                ; Add New OI at the head of the OI_LIST
        MOV   fs:[eax].OI_SI,0           ; Stream Instance
        mov   fs:[eax].OI_hStream,0      ; 
        mov   dx,es:[bx+OC_FN_OFFSET]    ; System File Number
        MOV   fs:[eax].OI_FileNum,dx     ; Stream not active
        POPFD

         inc   VB_opens                 ; Count Opens
         cmp   VB_opens,1               ; Is this The First OPEN
         jne   OPEN_done                ; yes
         push  es                       ; save request packet pointer
         push  ebx

ring3addr:
;
;        Create a 16:16 selector address to the buffer for ring 3 code to use
;
;        The ring 3 selector will reference a buffer that is 16, 32, or 64K
;        depending on the aperature size configured.  Only the first 64K
;        of a 640K aperature-configured card will be addressable with 16:16
;        addressing.
;
        mov   cx,408h                  ; get size of RAM on card
        mov   ax,msw_phys_add          ; convert real address of VRAM to
        mov   bx,lsw_phys_add          ; convert real address of VRAM to
        mov   dh,1                     ; read/write area
        mov   dl,DevHlp_PhysToUVirt    ; get a selector
        call  device_hlp               ; 
;        mov   ax,es                    ; save the returned selector
;        mov   selector1,ax             ; save selector for VRAM window 1
;        mov   gs,ax                    ; GS is selector to card
;        mov   gs,Selector1             ; Selector to the cards Memory

;
;        mov   cx,400h                  ; get aperature size
;        mov   ax,msw_phys_add          ; convert real address of VRAM to
;        mov   bx,lsw_phys_add          ; convert real address of VRAM to
;        mov   dh,1                     ; read/write area
;        mov   dl,DevHlp_PhysToUVirt    ; get a selector
;        call  device_hlp               ;

;        Create a 32-bit linear address to the buffer for ring 3 code to use
;
        mov     edi, DWORD PTR lsw_phys_add ; get physical addr of buffer
;       mov     edi,0F00000h
        mov     buffer_phys, edi        ; save it
        mov     ax, ds
        mov     esi, offset buffer_phys ; this is the 32 bit offset (flat)
        mov     dl, DevHlp_VirttoPhys
        call    device_hlp

        mov     ax, ds
        mov     esi, offset buffer_phys ; this is the 32 bit offset (flat)
        mov     dl, DevHlp_VirttoLin
        call    device_hlp

        mov     edi, eax                 ; get pointer to physical address
        mov     ecx,100000h              ; size memory on the card
        mov     aper_size,ecx   ; save aperature size
;        mov     eax, 30h        ; bit 4 = phys addr, bit 5 = 1 Proccess addr
;        mov     dl,  DevHlp_VMAlloc
;        call    device_hlp      ; Process Address
;        mov     lin_addr_p, eax   ; store linear address of the cards memory

        mov     eax, 10h        ; bit 4 = phys addr, bit 5 = 0 Global addr
        mov     dl,  DevHlp_VMAlloc
        call    device_hlp      ; Get Global Address
        mov     lin_addr, eax   ; store linear address of the cards memory

        pop   ebx                     ; restore request packet pointer
        pop   es                      ; 

OPEN_done:
        xor    eax,eax                ; No Error
        jmp    open_end

OPENt:  or    IP._Stat,error_s        ; Log Error  code in status
        or    IP._Stat,ax
        jmp   open_end

OPENx:  or    IP._Stat,error_s + general_failure
open_end:

         RET
OPEN     ENDP

subttl CLOSE Routine
page
;-------------------------------------------------------------------------------
; Procedure for handling CLOSE for device
;-------------------------------------------------------------------------------
CLOSE    PROC  NEAR
         mov   warmstart,0             ; Make all future Inits non warm start
         ; Remove  Stream Instance
         mov   fs,flatsel
         mov   cx,es:[bx+OC_FN_OFFSET]  ; System File Number
         call  REMOVE_OI

         cmp   eax,0                    ; 0 = Invalid Stream Handle
         je    CLOSEx

         ; Stop and  stream for this instance
         mov   ecx,fs:[eax].OI_hStream
         cmp   ecx,0                    ; Is a stream Registered
         je    STREAM_GONE              ; No Stream registered
         call  far ptr STOP_STREAM
         call  far ptr DEREG_STREAM
STREAM_GONE:                            ; 



         ; Free the OI  structure
         mov   dl,DevHlp_VMFree
         call  device_hlp
         jc    CLOSEx                   ; Did we free the storage   Carry=1 is a failure

         dec   VB_opens                ; Count Current OPENs
         cmp   VB_opens,0              ; is This the Last OPEN
         jne   CLOSEx                  ; no

         call  far ptr PCV_DisableVideo; Turn the Monitor OFF
         call  far ptr AudioOff        ; Turn the Audio

         ; Disable the PCVideo Card
         mov     dx,config_wPortAddr     ;Set PC Video port address.
         mov     al,dl                   ; 
         out     dx,al                   ; 
         mov     ax,00FFh                ; 
         out     dx,ax                   ;Disable PC Video.

         ; Drop Addressability to the Cards Memory
         mov   eax,lin_addr             ; Free  address of the cards memory
         mov   lin_addr,0               ; Zero  address of the cards memory
         mov   dl,  DevHlp_VMFree
         call  device_hlp               ; Free Global Address of the cards memory
CLOSEx:
         RET
CLOSE    ENDP

subttl IOCTL Routines

IC              equ es:[bp]     ; pointer to structure (like GIX above)
IC_BUMP         equ es:[di]     ; pointer to structure for use with stosw


subttl LockMem
page

;********************** START OF SPECIFICATIONS ***************************
;*
;* SUBROUTINE NAME:  LockMem
;*
;* DESCRIPTIVE NAME:  Lock memory passed to PDD from process.
;*
;* FUNCTION: Lock the virtual linear addresses of a chunk of memory
;*            so that we can access them. It will also convert process
;*            memory to globale memory.
;*
;* ENTRY POINTS:   LockMemLong
;*
;* INPUT:
;*              AX:ESI = selector:offset of lock handle
;*              EBX = Linear address to lock
;*              ECX = Length to lock (will be rounded to next 4K boundary)
;*
;* EXIT-NORMAL: Carry Flag clear
;*              EAX = Global linear address of memory locked
;*
;* EXIT-ERROR:  Carry Flag Set
;*              EAX = error code
;*
;* SIDE EFFECTS:
;*              All registers are preserved, except for EAX
;*
;* MODIFICATION HISTORY:
;*     DATE      DEVELOPER     CHANGE DESCRIPTION
;*
;*********************** END OF SPECIFICATIONS ****************************
LockMem Proc NEAR
;        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
      LOCK_RW         EQU     0000000000001000B     ; R/W access
      LOCK_LONG       EQU     0000000000010000B     ; Lock for long duration

        push    edi
        push    ebx
        push    ecx
        push    edx
        push    esi

        mov     edi,LOCK_RW OR LOCK_LONG ; r/w access & lock Long
;
; Get linear address of hlock. Needed for VMLock call
;
        mov     dl,DevHlp_VirtToLin
        call    device_hlp              ; 
        jc      LockMem_err

;
; Lock the memory.
;
        mov     esi,eax                 ; lock handle
        mov     eax,edi                 ; flags:
        mov     edi,-1                  ; no page info returned
        mov     dl,DevHlp_VMLock
        call    device_hlp              ; 
        jc      LockMem_err

;
; Need to do VMProcessToGlobal
;
        mov     eax,01h                 ; flag: writable
        mov     dl,DevHlp_VMProcessToGlobal
        call    device_hlp              ; 
        jnc     LockMem_ret

LockMem_err:
;        mov     eax,1                  ; EAX has Error Code from DevHelp
LockMem_ret:
        pop     esi
        pop     edx
        pop     ecx
        pop     ebx
        pop     edi

        ret
LockMem endp

subttl UnLockMem
page

;********************** START OF SPECIFICATIONS ***************************
;*
;* SUBROUTINE NAME:  UnlockMem
;*
;* DESCRIPTIVE NAME:  Unlock memory
;*
;* FUNCTION: Unlock the virtual linear addresses of the memory we locked down.
;*
;* ENTRY POINTS:   UnlockMem
;*
;* INPUT:
;*              AX:ESI = selector:offset of lock handle
;*              EBX = offset of global linear to VMfree
;*
;* EXIT-NORMAL: Carry Flag clear
;*
;* EXIT-ERROR:  Carry Flag Set
;*              EAX = error code
;*
;* SIDE EFFECTS:
;*              All registers are preserved, except EAX
;*
;* MODIFICATION HISTORY:
;*     DATE      DEVELOPER     CHANGE DESCRIPTION
;*
;*********************** END OF SPECIFICATIONS ****************************
UnlockMem Proc NEAR
;        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

        push    edx
        push    esi

;
; Do a VMFree (to undo VMProcessToGlobal)
;
        xchg    eax,ebx                         ; eax = linear addr to lock
        mov     dl,DevHlp_VMFree
        call    device_hlp              ; 
        jc      UnlockMem_err

;
; Get linear address of hlock. Needed for VMLock call
;
        xchg    eax,ebx                         ; eax = selector of lock handle
        mov     dl,DevHlp_VirtToLin
        call    device_hlp              ; 
        jc      UnlockMem_err

;
; Unlock the memory.
;
        mov     esi,eax                 ; lock handle
        mov     dl,DevHlp_VMUnlock
        call    device_hlp              ; 
        jnc     UnlockMem_ret           ; 

UnlockMem_err:
;        mov     eax,1                  ; EAX has Error Code from DevHelp
UnlockMem_ret:
        pop     esi
        pop     edx

        ret
UnlockMem endp

;***************************************************************************
;* FUNCTION:    Remove a Open Instance (OI) from the OI_LIST
;*
;* INPUT:
;*              CX  = OPEN Handle of the (OI) to be removed
;*
;* EXIT-NORMAL:
;*              EAX  = Buffer Address for OI
;*
;* EXIT_ERROR:
;*              EAX = 0   (OI not Found)
;***************************************************************************
Procedure REMOVE_OI,NEAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

;       int 3
        PUSHFD
        PUSH  ECX
        PUSH  EDX
        CLI                                   ; Turn Off Interrupt (Critical Section)

        CALL  far ptr FIND_OI                 ; Is it In the List?
        CMP   EAX,0                           ; Is the List Empty
        JE   REMOVE_OI_Done                   ; Stream Handle - Not in List

REMOVE_OI_WALK:
        MOV   EAX,OI_LIST                     ; Get First OI in the OI_LIST
        MOV   EDX,0                           ; 0 = Delete from List Head
REMOVE_OI_NEXT:
        CMP   EAX,0                           ; Is the List Empty
        JE   REMOVE_OI_Done                   ; - Not in List

        cmp   fs:[eax].OI_FileNum,cx          ; Is this to correct OI
        je    REMOVE_OI_ITEM                  ; We Found the OI - Handle in List

        mov   edx,eax                         ; Remember Previous Element
        mov   eax,fs:[eax].OI_pNext           ; Try next OI
        jmp   REMOVE_OI_Next                  ; Loop until all OI(s) are checked

REMOVE_OI_ITEM:
        cmp   edx,0                           ; Is the Item at the List Head
        je    REMOVE_OI_HEAD                  ; Remove Element from the Head
        mov   ecx,fs:[eax].OI_pNext           ; Next Item after Item being Deleted
        mov   fs:[edx].OI_pNext,ecx           ; Previous points to new next
        Jmp   REMOVE_OI_Done                  ; All Done

REMOVE_OI_HEAD:
        mov   ecx,fs:[eax].OI_pNext           ; Next Item after Item being Deleted
        mov   OI_LIST,ECX                     ; Next point to new next Item
        Jmp   REMOVE_OI_Done                  ; All Done


REMOVE_OI_DONE:
        POP   EDX
        POP   ECX
        POPFD
        RET
EndProc REMOVE_OI

;***************************************************************************
;* FUNCTION:    Find a Open Instance (OI) in the OI_LIST
;*
;* INPUT:
;*              CX  = File Handle/Open Instance to Find
;*
;* EXIT-NORMAL: EAX  = pointer to OI
;*
;*
;* EXIT_ERROR:  EAX = 0 (not in the List)
;*
;***************************************************************************
Procedure FIND_OI,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        PUSHFD
        PUSH  ECX
        CLI                                   ; Turn Off Interrupt (Critical Section)

        MOV   EAX,OI_List                     ; Find first OI in the List
FIND_OI_Next:
        CMP   EAX,0                           ; Is list Empty?
        je    FIND_OI_NIL                     ; - Not in List

        cmp   fs:[eax].OI_FileNum,cx          ; Is this to correct OI
        je    FIND_OI_DONE                    ; We Found the OI

        mov   eax,fs:[eax].OI_pNext           ; Try next OI
        jmp   FIND_OI_Next                    ; Loop until all OI(s) are checked


FIND_OI_NIL:                                  ; Not in the List

FIND_OI_DONE:                                 ; We Found the OI


        POP   ECX
        POPFD
        RET
EndProc FIND_OI

;***************************************************************************
;* FUNCTION:    Stop a Stream
;*
;* INPUT:
;*              ECX  = hStream  handle of stream to stop
;*
;* EXIT-NORMAL: Carry flag is not set
;*
;*
;* EXIT_ERROR:  Carry flag is set
;*
;***************************************************************************
Procedure STOP_STREAM,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

;       int 3
        push  eax
        sub   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        lea   esi,[esp]                     ; Paramet Packet addr
        mov   ss:[esi].cont_ulFunction,DDCMD_CONTROL
        mov   ss:[esi].cont_hStream,ECX
        mov   ss:[esi].cont_hEvent,0
        mov   ss:[esi].cont_ulCmd,DDCMD_STOP
        mov   ss:[esi].cont_pParm,0
        mov   ss:[esi].cont_ulParmSize,0
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_control_parm   ; Room for parm packet on stack
        or    ax,dx                         ; check RC = no error on call
        clc                                 ; Assume no error
        cmp   ax,0
        je    stop_stream_exit              ; NO error
        stc                                 ; Opps an error occured
;       int 3
STOP_STREAM_EXIT:
        pop   eax
        RET
EndProc STOP_STREAM

;***************************************************************************
;* FUNCTION:    DEREGISTER a Stream
;*
;* INPUT:
;*              ECX  = hStream  handle of stream to Deregister
;*
;* EXIT-NORMAL: Carry flag is not set
;*
;*
;* EXIT_ERROR:  Carry flag is set
;*
;***************************************************************************
Procedure DEREG_STREAM,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

;       int 3
        push  eax
        sub   esp,size ddcmd_deregister_parm  ; Room for parm packet on stack
        lea   esi,[esp]                       ; Paramet Packet addr
        mov   ss:[esi].dere_ulFunction,DDCMD_DEREG_STREAM
        mov   ss:[esi].dere_hStream,ECX
        push  ss
        push  si
        call  IDC_ENTRY
        pop   si
        pop   ss
        add   esp,size ddcmd_deregister_parm  ; Room for parm packet on stack
        or    ax,dx                           ; check RC = no error on call
        cmp   ax,0
        je    DEREG_STREAM_EXIT
        stc                                   ; Opps an error occured
;       int 3
DEREG_STREAM_EXIT:
        pop   eax
        RET
EndProc DEREG_STREAM


;***************************************************************************
;* FUNCTION:    Audio On to Default
;*
;* INPUT:       none
;*
;* EXIT-NORMAL:
;*
;*
;* EXIT_ERROR:
;*
;***************************************************************************
Procedure AudioON_D,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

SBM_Index_reg     equ     80h           ; Index Reg for SBpro Mixer chip
SBM_Data_reg      equ     81h           ; Data  Reg for SBpro Mixer chip
SBM_reg_reset     equ     00h           ; Reset Reg for SBpro Mixer chip
SBM_reg_LVolume   equ     3Eh           ; Line   Volume Reg for SBpro Mixer chip
SBM_reg_MVolume   equ     22h           ; Master Volume Reg for SBpro Mixer chip
SBM_reg_FMVolume  equ     26h           ; FM Volume Reg for SBpro Mixer chip
SBM_reg_CDVolume  equ     28h           ; CD Volume Reg for SBpro Mixer chip
SBM_reg_VVolume   equ     04h           ; Voice Volume Reg for SBpro Mixer chip

ADR_P6300         equ     80h           ; Phillips 6300 address
ADR_P8425         equ     82h           ; Phillips TDA8425 address


        pushfd
        cli

        mov   dx,config_wPortAddr
        cmp   type_card,0           ; Is this a Video Blaster
        je    SBP_MIXER             ; Sound Blaster Pro Mixer
        cmp   type_card,2           ; Is this a Video Magic card
        je    P_TDA8425             ; Phillpes TDA8425 sound chip
        jmp   P_6300                ; IF not assume phillpes 6300 sound chip

SBP_Mixer:                          ; Sound Blaster Pro Mixer Chip
        ; Reset the Mixer to Defaults
        mov   dx,config_wPortAddr
        mov   al,SBM_Index_reg
        out   dx,al                 ; SBP_Mixer Index
        inc   dx
        mov   al,SBM_reg_reset      ; Reset Reg
        out   dx,al

        mov   dx,config_wPortAddr
        mov   al,SBM_Data_reg
        out   dx,al                 ; 80h is SBP_Mixer Index
        inc   dx
        mov   al,00h                ; Reset Reg
        out   dx,al

        ; Set the Line In Volume to Default from INI file
        mov   dx,config_wPortAddr
        mov   al,SBM_Index_reg
        out   dx,al                 ; SBP_Mixer Index
        inc   dx
        mov   al,SBM_reg_LVolume    ; Line Volume
        out   dx,al

        mov   dx,config_wPortAddr
        mov   al,SBM_Data_reg
        out   dx,al                 ; 
        inc   dx


        mov   al,config_bVolume
        shr   al,2                  ; convert 0-3f to 0-f
        mov   ah,al                 ; make al hig 4 bit = to low 4 bits
        shl   al,4
        or    al,ah
        out   dx,al
        jmp      AudioON_D_done

P_TDA8425:                         ; Phillpes TDA8425 sound chip
        ; Set Default Audio Level
        push  ADR_P8425             ;Address
        mov   ax,11011110B    ; Mute off, Spatial Stereo,Input Stereo,Channel 1
        push  ax                    ;Value
        push  8                     ;Index (Source)
        call  far ptr setAudio
        push  ADR_P8425             ;Address
        mov   ax,0F8h
        push  ax                    ;Value
        push  2                     ;Index (bass)
        call  far ptr setAudio
        push  ADR_P8425             ;Address
        mov   ax,0F8h
        push  ax                    ;Value
        push  3                     ;Index (treble)
        call  far ptr setAudio

        push  ADR_P8425            ;Address
        xor eax,eax
        mov al,config_bVolume
        or   al,0C0h
        push ax                    ;Value
        push 0                     ;Index (left volume)
        call far ptr setAudio
        push  ADR_P8425            ;Address
        xor eax,eax
        mov al,config_bVolume
        or   al,0C0h
        push ax                    ;Value
        push 1                     ;Index (right volume)
        call far ptr setAudio
        ;Let it do the SVW code also for some older SVW cards without EEPROM
;       jmp      AudioON_D_done

p_6300:
        ; Program Chip
        Call  far ptr Switch_Audio  ; Set to current Audio Source
        Call  far ptr Switch_Audio  ; Only works if set twice?
        push  ADR_P6300             ;Address
        mov   ax,7
        push  ax                    ;Value
        push  2                     ;Index (bass)
        call  far ptr setAudio
        push  ADR_P6300             ;Address
        mov   ax,7
        push  ax                    ;Value
        push  3                     ;Index (treble)
        call  far ptr setAudio
        push  ADR_P6300             ;Address
        mov   ax,0FFH
        push  ax                    ;Value
        push  4                     ;Index (fadder)
        call far ptr setAudio

        push  ADR_P6300            ;Address
        xor eax,eax
        mov al,config_bVolume
        push ax                    ;Value
        push 0                     ;Index (left volume)
        call far ptr setAudio
        push  ADR_P6300            ;Address
        xor eax,eax
        mov al,config_bVolume
        push ax                    ;Value
        push 1                     ;Index (right volume)
        call far ptr setAudio
        jmp      AudioON_D_done

AudioON_D_done:
        popfd
        RET
EndProc AudioON_D


;***************************************************************************
;* FUNCTION:    DevSetAudio
;*
;* INPUT:       es:bx points to DevAudio Ioctl 79h structure
;*
;* EXIT-NORMAL:
;*
;*
;* EXIT_ERROR:
;*
;***************************************************************************
Procedure DevSetAudio,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        pushfd
        cli
        mov   si,offset usrdevAudio ; Current local Audio setting

        mov   dx,config_wPortAddr
        cmp   type_card,0           ; Is this a Video Blaster
        je    SBP_MIXER_SET         ; Sound Blaster Pro Mixer
        cmp   type_card,2           ; Is this a Video Magic card
        je    P_TDA8425_SET         ; Phillpes TDA8425 sound chip
        jmp   P_6300_SET            ; IF not assume phillpes 6300 sound chip

SBP_Mixer_Set:                      ; Sound Blaster Pro Mixer Chip

        ;-------- Volume Left ------------------------------
        mov   eax,GIX.DEVAUD_ulL_VOLUME ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    sbp_volumel_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    sbp_volumel_default
        jmp   sbp_volumel_set

sbp_volumeL_default:
        xor   eax,eax
        mov   al,config_bVolume
        and   eax,3fh
        shl   eax,2
        mov   gix.DEVAUD_ulL_volume,eax
sbp_volumeL_set:
        and   eax,0FFh
        mov   eax,gix.DEVAUD_ulL_volume
        mov   dax.DEVAUD_ulL_volume,eax
sbp_volumeL_skip:

        ;-------- Volume  Right------------------------------
        mov   eax,GIX.DEVAUD_ulR_VOLUME ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    sbp_volumeR_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    sbp_volumeR_default
        jmp   sbp_volumeR_set

sbp_volumeR_default:
        xor   eax,eax
        mov   al,config_bVolume
        and   eax,3fh
        shl   eax,2
        mov   gix.DEVAUD_ulR_volume,eax
sbp_volumeR_set:
        and   eax,0FFh
        mov   eax,gix.DEVAUD_ulR_volume
        mov   dax.DEVAUD_ulR_volume,eax
sbp_volumeR_skip:
        ;-------- Mute  ----------------------------------------
        mov   eax,GIX.DEVAUD_ulFlags ; Get Value
        mov   DAX.DEVAUD_ulFlags,eax ; Save Value
        test  eax,VCADEV_AUDIO_FLAG_MUTE
        jz    sbp_NOMUTE

sbp_MUTE:
        ; Set the Line In Volume
        mov   dx,config_wPortAddr
        mov   al,SBM_Index_reg
        out   dx,al                 ; SBP_Mixer Index
        inc   dx
        mov   al,SBM_reg_LVolume    ; Line Volume
        out   dx,al
        mov   dx,config_wPortAddr
        mov   al,SBM_Data_reg
        out   dx,al                 ; 
        inc   dx
        mov   eax,0                 ; AL = 4 bit Left, 4 bit Right
        out   dx,al
        jmp   DevSetAudio_done
sbp_NOMUTE:

;        ; Reset the Mixer to Defaults
;        mov   dx,config_wPortAddr
;        mov   al,SBM_Index_reg
;        out   dx,al                 ; SBP_Mixer Index
;        inc   dx
;        mov   al,SBM_reg_reset      ; Reset Reg
;        out   dx,al
;
;        mov   dx,config_wPortAddr
;        mov   al,SBM_Data_reg
;        out   dx,al                 ; 80h is SBP_Mixer Index
;        inc   dx
;        mov   al,00h                ; Reset Reg
;        out   dx,al
;
        ; Set the Line In Volume
        mov   dx,config_wPortAddr
        mov   al,SBM_Index_reg
        out   dx,al                 ; SBP_Mixer Index
        inc   dx
        mov   al,SBM_reg_LVolume    ; Line Volume
        out   dx,al
        mov   dx,config_wPortAddr
        mov   al,SBM_Data_reg
        out   dx,al                 ; 
        inc   dx
        mov   eax,dax.DEVAUD_ulR_volume
        and   eax,0FFh
        shr   eax,4
        mov   ecx,dax.DEVAUD_ulL_volume
        and   ecx,0FFh
        shr   ecx,4
        shl   ecx,4
        or    eax,ecx                      ; AL = 4 bit Left, 4 bit Right
        out   dx,al

        jmp   DevSetAudio_done

P_TDA8425_SET:                     ; Phillpes TDA8425 sound chip
        ; Set Default Audio Level
        push  ADR_P8425             ;Address
        mov   ax,11011110B    ; Mute off, Spatial Stereo,Input Stereo,Channel 1
        push  ax                    ;Value
        push  8                     ;Index (Source)
        call  far ptr setAudio

        ;-------- Bass ------------------------------------------
        mov   eax,GIX.DEVAUD_ulL_BASS ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    p8425_bass_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    p8425_bass_default
        jmp   p8425_bass_set

p8425_bass_default:
        mov   eax,8
        shl   eax,4
        mov   gix.DEVAUD_ulL_BASS,eax
p8425_bass_set:
        mov   eax,gix.DEVAUD_ulL_BASS
        and   eax,0FFh
        mov   dax.DEVAUD_ulL_BASS,eax
        shr   ax,4
        push  ADR_P8425             ;Address
        or    ax,0F0h
        push  ax                    ;Value
        push  2                     ;Index (bass)
        call  far ptr setAudio
p8425_bass_skip:

        ;-------- Treble -------------------------------------------
        mov   eax,GIX.DEVAUD_ulL_TREBLE ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    p8425_treble_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    p8425_treble_default
        jmp   p8425_treble_set

p8425_treble_default:
        mov   eax,8
        shl   eax,4
        mov   gix.DEVAUD_ulL_TREBLE,eax
p8425_treble_set:
        mov   eax,gix.DEVAUD_ulL_TREBLE
        and   eax,0FFh
        mov   dax.DEVAUD_ulL_TREBLE,eax
        shr   ax,4
        push  ADR_P8425             ;Address
        or    ax,0F0h
        push  ax                    ;Value
        push  3                     ;Index (treble)
        call  far ptr setAudio
p8425_treble_skip:



        ;-------- Volume Left ----------------------------------------
        mov   eax,GIX.DEVAUD_ulL_VOLUME ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    p8425_volumel_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    p8425_volumel_default
        jmp   p8425_volumel_set

p8425_volumeL_default:
        xor   eax,eax
        mov   al,config_bVolume
        and   eax,3fh
        shl   eax,2
        mov   gix.DEVAUD_ulL_volume,eax
p8425_volumeL_set:
        mov   eax,gix.DEVAUD_ulL_volume
        and   eax,0FFh
        mov   dax.DEVAUD_ulL_volume,eax
        test  GIX.DEVAUD_ulFlags,VCADEV_AUDIO_FLAG_MUTE; Skip Volume if MUTE Value
        jnz   p8425_volumeL_skip
        shr   ax,2
        push  ADR_P8425            ;Address
        or    al,0C0h
        push  ax                   ;Value
        push 0                     ;Index (left volume)
        call far ptr setAudio
p8425_volumeL_skip:

        ;-------- Volume Right ----------------------------------------
        mov   eax,GIX.DEVAUD_ulR_VOLUME ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    p8425_volumeR_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    p8425_volumeR_default
        jmp   p8425_volumeR_set

p8425_volumeR_default:
        xor   eax,eax
        mov   al,config_bVolume
        and   eax,3fh
        shl   eax,2
        mov   gix.DEVAUD_ulR_volume,eax
p8425_volumeR_set:
        mov   eax,gix.DEVAUD_ulR_volume
        and   eax,0FFh
        mov   dax.DEVAUD_ulR_volume,eax
        shr   ax,2
        test  GIX.DEVAUD_ulFlags,VCADEV_AUDIO_FLAG_MUTE; Skip Volume if MUTE Value
        jnz   p8425_volumeR_skip
        push  ADR_P8425            ;Address
        or    al,0C0h
        push  ax                   ;Value
        push  1                    ;Index (right volume)
        call far ptr setAudio
p8425_volumeR_skip:

        ;-------- Mute  ----------------------------------------
        mov   eax,GIX.DEVAUD_ulFlags ; Get Value
        mov   DAX.DEVAUD_ulFlags,eax ; Save Value
        test  eax,VCADEV_AUDIO_FLAG_MUTE
        jz    p8425_NOMUTE

p8425_MUTE:
        push  ADR_P8425            ;Address
        mov   al,0C0h
        push  ax                   ;Value
        push  0                    ;Index (left volume)
        call far ptr setAudio
        push  ADR_P8425            ;Address
        mov   al,0C0h
        push  ax                   ;Value
        push  1                    ;Index (right volume)
        call far ptr setAudio
p8425_NOMUTE:


;        push  ADR_P8425            ;Address
;        xor eax,eax
;        mov al,config_bVolume
;        or   al,0C0h
;        push ax                    ;Value
;        push 1                     ;Index (right volume)
;        call far ptr setAudio
;        ;Let it do the SVW code also for some older SVW cards without EEPROM
;       jmp     DevSetAudio_done

p_6300_SET:
        ; Program Chip
        Call  far ptr Switch_Audio  ; Set to current Audio Source
        Call  far ptr Switch_Audio  ; Only works if set twice?
        ;-------- Bass ------------------------------------------
        mov   eax,GIX.DEVAUD_ulL_BASS ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    p6300_bass_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    p6300_bass_default
        jmp   p6300_bass_set

p6300_bass_default:
        mov   eax,7
        shl   eax,4
        mov   gix.DEVAUD_ulL_BASS,eax
p6300_bass_set:
        and   eax,0FFh
        mov   eax,gix.DEVAUD_ulL_BASS
        mov   dax.DEVAUD_ulL_BASS,eax
        shr   ax,4
        push  ADR_P6300             ;Address
        push  ax                    ;Value
        push  2                     ;Index (bass)
        call  far ptr setAudio
p6300_bass_skip:

        ;-------- Treble -------------------------------------------
        mov   eax,GIX.DEVAUD_ulL_TREBLE ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    p6300_treble_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    p6300_treble_default
        jmp   p6300_treble_set

p6300_treble_default:
        mov   eax,7
        shl   eax,4
        mov   gix.DEVAUD_ulL_TREBLE,eax
p6300_treble_set:
        and   eax,0FFh
        mov   eax,gix.DEVAUD_ulL_TREBLE
        mov   dax.DEVAUD_ulL_TREBLE,eax
        shr   ax,4
        push  ADR_P6300             ;Address
        push  ax                    ;Value
        push  3                     ;Index (Treble)
        call  far ptr setAudio
p6300_treble_skip:

        push  ADR_P6300             ;Address
        mov   ax,0FFH
        push  ax                    ;Value
        push  4                     ;Index (fadder)
        call far ptr setAudio


        ;-------- Volume Left ----------------------------------------
        mov   eax,GIX.DEVAUD_ulL_VOLUME ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    p6300_volumel_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    p6300_volumel_default
        jmp   p6300_volumel_set

p6300_volumeL_default:
        xor   eax,eax
        mov   al,config_bVolume
        and   eax,3fh
        shl   eax,2
        mov   gix.DEVAUD_ulL_volume,eax
p6300_volumeL_set:
        and   eax,0FFh
        mov   eax,gix.DEVAUD_ulL_volume
        mov   dax.DEVAUD_ulL_volume,eax
        shr   ax,2
        test  GIX.DEVAUD_ulFlags,VCADEV_AUDIO_FLAG_MUTE; Skip Volume if MUTE Value
        jnz   p6300_volumeL_skip
        push  ADR_P6300             ;Address
        push  ax                    ;Value
        push  0                     ;Index (Left volume)
        call  far ptr setAudio
p6300_volumeL_skip:

        ;-------- Volume Right ----------------------------------------
        mov   eax,GIX.DEVAUD_ulR_VOLUME ; Get Value
        cmp   eax,VCA_QUERY_CURRENT
        je    p6300_volumeR_skip
        cmp   eax,VCA_SET_TO_DEFAULT
        je    p6300_volumeR_default
        jmp   p6300_volumeR_set

p6300_volumeR_default:
        xor   eax,eax
        mov   al,config_bVolume
        and   eax,3fh
        shl   eax,2
        mov   gix.DEVAUD_ulR_volume,eax
p6300_volumeR_set:
        and   eax,0FFh
        mov   eax,gix.DEVAUD_ulR_volume
        mov   dax.DEVAUD_ulR_volume,eax
        shr   ax,2
        test  GIX.DEVAUD_ulFlags,VCADEV_AUDIO_FLAG_MUTE; Skip Volume if MUTE Value
        jnz   p6300_volumeR_skip
        push  ADR_P6300             ;Address
        push  ax                    ;Value
        push  1                     ;Index (Right volume)
        call  far ptr setAudio
p6300_volumeR_skip:

        ;-------- Mute  ----------------------------------------
        mov   eax,GIX.DEVAUD_ulFlags ; Get Value
        mov   DAX.DEVAUD_ulFlags,eax ; Save Value
        test  eax,VCADEV_AUDIO_FLAG_MUTE
        jz    p6300_NOMUTE

p6300_MUTE:
        push  ADR_P6300             ;Address
        mov   ax,0                  ; Low Volume/Mute
        push  ax                    ;Value
        push  0                     ;Index (Left volume)
        call  far ptr setAudio
        push  ADR_P6300             ;Address
        mov   ax,0                  ; Low Volume/Mute
        push  ax                    ;Value
        push  1                     ;Index (Right volume)
        call  far ptr setAudio
p6300_NOMUTE:

        jmp      DevSetAudio_done

DevSetAudio_done:
        mov   ecx,SIZE VCADEVAUDIO
        shr   ecx,2                ; Copy is 4 bytes at a time
        push  esi
        push  ebx
copy_curr_audio:
        mov   eax,DAX.DEVAUD_ulLength
        mov   GIX.DEVAUD_ulLength,eax
        add   ebx,4
        add   esi,4
        loop  copy_curr_audio
        pop   ebx
        pop   esi

        popfd
        RET
EndProc DevSetAudio


;***************************************************************************
;* FUNCTION:    Audio off / Mute
;*
;* INPUT:       none
;*
;* EXIT-NORMAL:
;*
;*
;* EXIT_ERROR:
;*
;***************************************************************************
Procedure AudioOFF,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        pushfd
        cli

        mov   dx,config_wPortAddr
        cmp   type_card,0           ; Is this a Video Blaster
        je    SBP_MIXER_off         ; Sound Blaster Pro Mixer
        cmp   type_card,2           ; Is this a Video Magic card
        je    P_TDA8425_off         ; Phillpes TDA8425 sound chip
        jmp   P_6300_off            ; IF not assume phillpes 6300 sound chip

SBP_Mixer_off:                      ; Sound Blaster Pro Mixer Chip
        ; Reset the Mixer to Defaults
        mov   dx,config_wPortAddr
        mov   al,SBM_Index_reg
        out   dx,al                 ; SBP_Mixer Index
        inc   dx
        mov   al,SBM_reg_reset      ; Reset Reg
        out   dx,al

        mov   dx,config_wPortAddr
        mov   al,SBM_Data_reg
        out   dx,al                 ; 80h is SBP_Mixer Index
        inc   dx
        mov   al,00h                ; Reset Reg
        out   dx,al
        jmp   AudioOff_done

P_TDA8425_off:
        ; Turn Audio off
        push  ADR_P8425             ;Address
        mov   ax,11111110b          ;Turn Mute on
        push  ax                    ;Value
        push  8                     ;Index (Source)
        call  far ptr setAudio
        push  ADR_P8425             ;Address
        push  11000000B             ;Value
        push  0                     ;Index (Left Volume)
        call  far ptr setAudio
        push  ADR_P8425             ;Address
        push  11000000B             ;Value
        push  1                     ;Index (Right Volume)
        call  far ptr setAudio
        ; Let it do the SVW code for the SVW cards  with no EEPROM
;       jmp   AudioOff_done


P_6300_off:
        ; Set Default Audio Level to OFF for current connector
        ;  Set AX = audio source 40h=Single connector models
        ;                        01h=Connector 0
        ;                        02h=Connector 1
        ;                        04h=Connector 2
        cmp   type_card,2           ; Is this a Video Magic card
        je    skip_oldSVW_off
        ; Find Current Video Source and match Audio
        mov   cx,config_wVideoSource
        mov   ax,1
        shl   al,cl
        jmp   got_source_off
skip_oldSVW_off:
        ; Old Single connector SVW cards
        mov   ax,40H

got_source_off:
        push  ADR_P6300             ;Address
        push  ax                    ;Value
        push  5                     ;Index (Source)
        call  far ptr setAudio
        push  ADR_P6300             ;Address
        push  0                     ;Value
        push  0                     ;Index (Left Volume)
        call  far ptr setAudio
        push  ADR_P6300             ;Address
        push  0                     ;Value
        push  1                     ;Index (Right Volume)
        call  far ptr setAudio
        jmp   AudioOff_done

AudioOff_done:
        popfd
        RET
EndProc AudioOFF


;***************************************************************************
;* FUNCTION:    Switch Audio Source
;*
;* INPUT:       none
;*
;* EXIT-NORMAL:
;*
;*
;* EXIT_ERROR:
;*
;***************************************************************************
Procedure Switch_Audio,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        pushfd
        cli

        mov   dx,config_wPortAddr
        cmp   type_card,0           ; Is this a Video Blaster
        je    SBP_MIXER_SA          ; Sound Blaster Pro Mixer
        cmp   type_card,2           ; Is this a Video Magic card
        je    P_TDA8425_SA          ; Phillpes TDA8425 sound chip
        jmp   P_6300_SA             ; IF not assume phillpes 6300 sound chip

SBP_Mixer_SA:                       ; Sound Blaster Pro Mixer Chip
        jmp   AudioSA_done

P_TDA8425_SA:
        ; Let it do the SVW code for the SVW cards  with no EEPROM
;       jmp   AudioSA_done


P_6300_SA:
        ; Set Default Audio Connector based on Video Input Connector
        ;  Set AX = audio source 40h=Single connector models
        ;                        01h=Connector 0
        ;                        02h=Connector 1
        ;                        04h=Connector 2
        cmp   bBoardNMG,NMG_SL   ; Is this a Single Input Card
        je    skip_oldSVW_SA
        ; Find Current Video Source and match Audio
        mov   cx,config_wVideoSource
        mov   ax,1
        shl   al,cl
        jmp   got_source_SA
skip_oldSVW_SA:
        ; Old Single connector SVW cards
        mov   ax,40H

got_source_SA:
        push  ADR_P6300             ;Address
        push  ax                    ;Value (Input Audio Source)
        push  5                     ;Index (Source)
        call  far ptr setAudio
        jmp   AudioSA_done

AudioSA_done:
        popfd
        RET
EndProc Switch_Audio


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 setAudio                                                             3
;3                                                                      3
;3 Set the Audio attribute                                              3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       index                                                   3
;3              Value                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure SetAudio, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   index           equ bp+6            ;Index Left/right Volume Bass, Treble ...
   value           equ bp+8            ;New Value to set
   Addr            equ bp+10           ;Address of I2C Device

   ;*********************************************
   ; Local Variables on stack
     enter       20,0


        mov    ax,[addr]
        push   ax
        mov    ax,[index]
        push   ax
        mov    ax,[value]
        push   ax
        call   far ptr wr_i2c
        leave
        ret     6
EndProc setAudio


;**************************************************************************
; Procedure Name  : QuerySignal
;
; Description     : Query to see if Vaid Input Signal is Present
;
; Input Parameters:  none
;
; Output Parameters:  AX =       ; Signal Present
;                        =       ; No Signal Present
;                        =       ; Indeterminate
;
;
; Restrictions:
;
; Note:
;
;**************************************************************************
ALIGN 4
Procedure _QuerySignal, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

pll_locked equ 01000000B

           lBegin 0h
     push   ecx
;; Need a delay to let/make sure current signal has settled in
;     mov    ecx,3FFFFh
;delay_some:
;
;     jmp $+2
;     nop
;     jmp $+2
;     nop
;     dec    ecx
;     jnz    delay_some

     mov    cx,0FFh
check_sync:
     push   cx
     mov    ax,0              ; Sub address of Tuner
     push   ax
     mov    ax,[adr9051]
     push   ax
     call   far ptr rd_i2c
     and    al,PLL_LOCKED
     jz     signal_present
     pop    cx
     loop   check_sync

     mov    al,VCAERR_SIGNAL_NOT_LOCKED ; No signal synced up
     jmp    signal_done

signal_present:
     mov    al,VCAERR_SIGNAL_LOCKED      ;signal synced up
     jmp    signal_done

signal_done:
     pop    ecx
     lEnd
     RET

EndProc _QuerySignal


;***************************************************************************
;* FUNCTION:    Add Still Frame Info to Image
;*
;* INPUT:       FS:EDI buffer to write into
;*              EAX    Dest Buff Width
;* EXIT-NORMAL:
;*
;* EXIT_ERROR:
;*
;***************************************************************************
Procedure ADD_SF_INFO,NEAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        PUSHFD
        PUSHAD
        CLI                                   ; Turn Off Interrupt (Critical Section)
       mov   ecx,eax                 ; Width
       shl   ecx,1                   ; Byte width
       mov   eax,[GetI2RAM]          ; Frame #

        ; Get System Time
        push    gs
        push    eax
        mov     ax,[Ginfo_seg]      ; Find Global Info segment
        mov     gs,ax               ; Load up global info Segment
        mov     bx ,[Ginfo_offset]  ; Global Info Offset
        mov     ebx,gs:[bx+4]       ; Read Global Info tenths of milliseconds
        pop     eax
        pop     gs

       ; Fill in System Time
       push  edi
       ADD   EDI,6*2*5               ; Size of Counter Digit
       mov   eax,ecx
       shl   eax,2
       add   edi,eax
       mov   eax,ebx                 ; System Time HIgh two bytes
       shr   eax,16                  ; High two bytes of stream time
       push  ecx
       call  far ptr numtoRGB4
       pop   edi

       ; Fill in System Time
       push edi
       ADD  EDI,6*2*10              ; Size of Counter Digit
       mov   eax,ecx
       shl   eax,2
       add   edi,eax
       mov  eax,ebx                 ; System Time HIgh two bytes
       push ecx
       call far ptr numtoRGB4
       pop  edi

       ; Fill out Counter for Frames
       push edi
       mov  eax,ecx                 ; X_Width
       shl  eax,4                   ; *16 to shipover last numbers
       add  EDI,eax
       ADD  EDI,6*2*5               ; Size of Counter Digit
       mov  eax,[GetI2RAM]          ;Frame #
       push ecx
       call far ptr numtoRGB4
       pop  edi

       ; Fill out 0
       push edi
       mov  eax,ecx                 ; X_Width
       shl  eax,4                   ; *16 to shipover last numbers
       add  EDI,eax
       ADD  EDI,6*2*10              ; Size of Counter Digit
       mov   eax,0
       push  ecx
       call far ptr numtoRGB4
       pop  edi


        POPAD
        POPFD
        RET
EndProc ADD_SF_INFO


_TEXT ENDS

;    End of CODE segment
;
;*******************************************************************************
        END

