;*DDK*************************************************************************/
;
; COPYRIGHT (C) Chips and Technologies, Inc. 1991, 1992
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/


;Some of the material contained in this module was derivered from
;Chips and Technologies PCVideo Software Developers Kit.

.386p
INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

;*********************************************
; Define the C calling macros
LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm
;*********************************************

include devsym.inc
include basemaca.inc
include basedef.inc
include pcv2.inc

;/EXTRN  SetColor:FAR
;/EXTRN  wr_i2c:FAR

DATA   SEGMENT  DWORD USE16 PUBLIC 'DATA'      ; changed from code to data
;       ASSUME   CS: FLAT, DS: DATA, SS: FLAT, ES: FLAT

        EXTRN   _AcquisitionWindow:WORD
        EXTRN   _iVideoMode:WORD        ;Video mode number
        EXTRN   _wVideoWidth:WORD       ;Width of acquired video
        EXTRN   _wVideoHeight:WORD      ;Height of acquired video
        EXTRN   _wVersion:WORD          ;Chip version number
        EXTRN   _wBoardType:WORD        ;Type of data caputed by the board
        EXTRN   WarmStart:BYTE         ; 1= Warm Start
        EXTRN   config_data:BYTE        ; Config Into form .INI file
        EXTRN   config_wPortAddr:WORD
        EXTRN   config_wVideoAddr:WORD
        EXTRN   config_wCfgFlags:WORD
        EXTRN   config_wVideoSource:WORD
        EXTRN   config_bColorSettings:BYTE
        EXTRN   config_PCVideoTable:BYTE
        EXTRN   config_PhixelTable:BYTE
        EXTRN   config_aMode:BYTE
        EXTRN   config_wNTSCAcqWindow:WORD
        EXTRN   config_wPALAcqWindow:WORD
        EXTRN   config_aReserved:BYTE
        EXTRN   Type_Card:WORD
        EXTRN   msw_phys_add:WORD
        EXTRN   usr_keyColor:DWORD
        EXTRN   reg3_4680:byte           ; 4680 reg 3 White Level
;        EXTRN   _fpfncXzoom:DWORD       ;Address for board specific Xzoom
;                                        ;routine

public  _fInit
public  FrameBufSel
public  NextSelIncr
public  NSelectors
public  _wCapBufWidth
public  _wCapBufHeight
public  _bHZoomFactor
public  _bVZoomFactor
public  _bHZoomAdjust
public  _bVZoomAdjust
public  _fFrozen
public  _fScaleVideo
public  _fHighRes
public  OutWinXOrg
public  OutWinYOrg
public  OutWinXExt
public  OutWinYExt


_fHighRes       dw      0               ;0=High res with PCVideo Pro\Low res
                                        ;1=High res mode with pcvideo chip
_fInit          dw      0               ;0=Not Initialize
OutWinXOrg      dw      0               ;Current display window origin x
OutWinYOrg      dw      0               ;Current display window origin y
OutWinXExt      dw      0               ;Current display window width
OutWinYExt      dw      0               ;Current display window height
xPan            dw      0               ;X,Y position in video buffer of
yPan            dw      0               ;the start of displayed video.
xCapture        dw      0               ;Address in the video buffer for
yCapture        dw      0               ;storing captured video.
_bHZoomFactor   db      0               ;Horizontal zoom factor.
_bVZoomFactor   db      0               ;Vertical zoom factor.
_bVZoomAdjust   db      0               ;Vertical zoom adjustment.
_bHZoomAdjust   db      0               ;Horizontal zoom adjustment.
_fScaleVideo    dw      0               ;0=Full size 1=Scaled to window size
_fFrozen        dw      0               ;0=Not frozen
FrameBufSel     dw      0               ;Invalidate selector
NextSelIncr     dw      8               ;Increment to next selector (default 8)
NSelectors      dw      16              ;Number of selectors need to access the memory
_wCapBufWidth   dw      1024    ;Dimensions of the video capture
_wCapBufHeight  dw      512     ;buffer

DATA   ENDS


_TEXT   SEGMENT  DWORD USE16 PUBLIC 'CODE'
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT

;************************************************************************
;* PCV_Initialize                                                       *
;*                                                                      *
;* This routine is called to initialize PC Video.  It loads the         *
;* configuration file, detects the video mode, and initializes          *
;* all the PC Video and Phixel registers.                               *
;*                                                                      *
;* Exported:    Yes                                                     *
;* Entry:       ESI - pointer to Config Parms                           *
;* Destroys:    AX,CX,DX,SI                                             *
;* Exit:        AX = 1 for success,  0 for failure                      *
;************************************************************************
Procedure PCV_Initialize, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

   ;*********************************************
   ; Local Variables on stack
       iAdjust equ bp-02
       wCount  equ bp-04
       wColor  equ bp-06

        LBegin 08h


        mov     dx,config_wPortAddr     ;Set PC Video port address.
        mov     al,dl                   ;Note: You may noticed already, we are
        out     dx,al                   ;programming the PC Video chip without
                                        ;first enabling the chip and program its
                                        ;index register.
                                        ;This is because the very first I/O
                                        ;write to PC Video chips after reset
                                        ;goes directly to the I/O address
                                        ;register (index 00).

        mov     ax,03FFh
        out     dx,ax                   ;Enable PC Video.
        inc     dx
        in      al,dx                   ;Read chip version number.
        shr     al,4
        xor     ah,ah
        mov     _wVersion,ax
        cmp     _wVersion,2
        jbe     @F                      ;Valid PC Video version number ?
        xor     ax,ax                   ;No, Ready to quit
        jmp     initialize_exit
@@:
        jb      get_mode_parameters
;KLL        mov     NSelectors,32           ;Need 32 selectors to access 2MB memory
;KLL        mov     _wCapBufHeight,1024

get_mode_parameters:
        call    far ptr GetVideoMode    ;Detect the VGA video mode.

        mov     ax, ((SIZE MODE) * NO_VIDEO_MODES)
        add     ax,offset config_aMode
        mov     di,ax

initialize_pcvideo:
        cmp     _wBoardType,BT_RGB16    ;RGB Board support high resolution mode.
        je      @F
        cmp     _wBoardType,BT_RGB24    ;RGB Board support high resolution mode.
        je      @F

        mov     ax,[di].VGAHeight
        cmp     ax,800H
        jnz     @F
        mov     ax,[di].VGAWidth
        cmp     ax,600H
        jnz     @F
init_800x600mode:
        cmp     _wVersion,2
        jae     @F
        mov     _fHighRes,1             ;High resolution flag


@@:
        lea     si,config_PCVideoTable.aPCVideoRegs
        mov     cx,config_PCVideoTable.cPCVideoRegs
        mov     dx,config_wPortAddr
        cmp     warmstart,1
        je      warm1
        rep     outsw

warm1:

        ; Save Key Color Setting ****************
        lea     si,config_PCVideoTable.aPCVideoRegs
        mov     cx,config_PCVideoTable.cPCVideoRegs
next_reg:
        mov     al,byte ptr ds:[si]     ; Register Number
        cmp     al,TRANS_COLOR
        je      found_TransColor_reg
        add     si,2
        dec     cx
        loop    next_reg
        mov     al,2Dh                  ; No Default TransColor found
        jmp     save_transColor
found_TransColor_reg:
        mov     al,byte ptr ds:[si+1]   ; Value to be programed
save_transColor:
        and     eax,0FFh
        cmp     eax,usr_keycolor
        je      KeyColor_set
        mov     usr_keyColor,eax
        mov     dx,config_wPortAddr
        push    ax
        call    far ptr PCV_SetColorKey ; Set Color KEy ValueTurn OFF
KeyColor_set:


        mov     dx,config_wPortAddr     ; Set Zoom factor to zero
        mov     al,DW_WINDOW_ZOOM
        out     dx,al
        inc     dx
        mov     al,0
        out     dx,al                   ; Set Zoom to Zero

        mov     dx,config_wPortAddr
        mov     ax,[di].ShiftClkStart
        mov     ah,SHIFT_CLK_START
        xchg    al,ah
        out     dx,ax                   ;Set the shift clock start position.

        mov     dx,config_wPortAddr
        mov     ax,[di].PaletteSkew
        shl     ax,6
        mov     ah,DW_MODE_CNTL
        xchg    al,ah
        out     dx,al
        inc     dx
        in      al,dx
        and     al,3fh
        or      al,ah
        or      al,20h                  ;Disable DispWinSkewX&Y
        out     dx,al                   ;Set the palette skew.

        test    config_wCfgFlags,CF_HASPLL
        jz      initialize_phixel_chips ;No need to initialize PLL.

initialize_PLL_divisor:
        mov     dx,config_wPortAddr
        mov     ax,PLL_DIVISOR_LO shl 8 + PLL_DIVISOR_INDEX
        out     dx,ax
        mov     bx,[di].PLLDivisor
        mov     ah,bl
        mov     al,PLL_DIVISOR_DATA
        out     dx,ax                   ;Low byte of PLL divisor

        mov     ax,PLL_DIVISOR_HI shl 8 + PLL_DIVISOR_INDEX
        out     dx,ax
        mov     ah,bh
        mov     al,PLL_DIVISOR_DATA
        out     dx,ax                   ;High byte of PLL divisor

initialize_phixel_chips:
        cmp     warmstart,1
        je      warm2
;       push    di
        call    far ptr SyncDetect      ;Check the VGA VSync
        mov     bx,config_PhixelTable.cPhixelChips
        mov     [wCount],bx
        lea     bx,config_PhixelTable.aPhixelChips

initialize_phixel_chip:
        mov     cx,[bx].cPhixelRegs
        jcxz    initialize_next_phixel_chip
        lea     si,[bx].aPhixelRegs

initialize_phixel_register:
        push    cx
        push    bx
        push    si

        push    [bx].wPhixelAddr
        xor     ax,ax
        mov     al,[si].rIndex
        push    ax
        mov     al,[si].rData
        push    ax
        call    far ptr wr_i2c

        pop     si
        add     si,SIZE REGENTRY
        pop     bx
        pop     cx
        loop    initialize_phixel_register

initialize_next_phixel_chip:
        dec     word ptr [wCount]
        jz      initialize_adjust_colors
        add     bx,SIZE PHIXELCHIP
        jmp     initialize_phixel_chip

warm2:
initialize_adjust_colors:
        mov     word ptr[wCount],NO_COLOR_CONTROLS
        mov     word ptr[wColor],BRIGHTNESS

initialize_color:
        mov     bx,[wColor]
        push    bx
        mov     bl,config_bColorSettings[bx]
        xor     bh,bh
        push    bx
        call    far ptr SetColor
        inc     word ptr[wColor]
        dec     word ptr[wCount]
        jnz     initialize_color

initialize_WhiteBalance:
        mov     bx,83h
        push    bx
        mov     bl,reg3_4680
        xor     bh,bh
        push    bx
        call    far ptr SetColor

initialize_set_video_Address:
        mov     ax,msw_phys_add
        shr     ax,4
        mov     config_wVideoAddr,ax
        push    config_wVideoAddr
        call    far ptr PCV_SetVideoAddress

initialize_set_video_source:
        push    config_wVideoSource
        call    far ptr SetVideoSource

initialize_set_video_standard:
        mov     ax,CF_NTSC
        or      ax,CF_SECAM
        and     ax,config_wCfgFlags
        push    ax
        call    far ptr SetInputFormat

initialize_set_interlace:
;       pop     di
        test    [di].fModeFlags,MF_INTERLACED
        jz      initialize_compute_width
        mov     dx,config_wPortAddr
        mov     al,INTERLACE_CNTL
        out     dx,al
        inc     dx
        in      al,dx
        or      al,INTERLACE_ON
        out     dx,al

initialize_compute_width:
        mov     dx,config_wPortAddr
        mov     al,AW_X_START_LO
        out     dx,al
        inc     dx
        in      al,dx
        mov     bl,al
        dec     dx
        mov     al,AW_X_START_HI
        out     dx,al
        inc     dx
        in      al,dx
        mov     bh,al
        and     bh,00000011b            ;BX = X Start
        dec     dx

        mov     al,AW_X_END_HI
        out     dx,al
        inc     dx
        in      al,dx
        mov     ah,al
        and     ah,00000011b
        dec     dx
        mov     al,AW_X_END_LO
        out     dx,al
        inc     dx
        in      al,dx                   ;AX = X End
        sub     ax,bx
        jz      initialize_exit         ;Invalid video width
        mov     _wVideoWidth,ax

initialize_compute_height:
        mov     dx,config_wPortAddr
        mov     al,AW_Y_START_LO
        out     dx,al
        inc     dx
        in      al,dx
        mov     bl,al
        dec     dx
        mov     al,AW_Y_START_HI
        out     dx,al
        inc     dx
        in      al,dx
        mov     bh,al
        and     bh,00000011b            ;BX = Y Start
        dec     dx

        mov     al,AW_Y_END_HI
        out     dx,al
        inc     dx
        in      al,dx
        mov     ah,al
        and     ah,00000011b
        dec     dx
        mov     al,AW_Y_END_LO
        out     dx,al
        inc     dx
        in      al,dx                   ;AX = Y End
        sub     ax,bx
        jz      initialize_exit         ;Invalid video height
        mov     _wVideoHeight,ax

; If this is a 82c457, turn on dithering.

        mov     dx,46e8h
        mov     al,1eh
        out     dx,al
        mov     dx,104h
        in      al,dx                   ;Read chip ID.
        mov     ah,al
        mov     dx,46e8h
        mov     al,0eh
        out     dx,al
        cmp     ah,0A5h                 ;Is this a C&T VGA?
        jne     initialize_success      ;No, no need to turn on dithering.

; This is a C&T VGA.  Check whether it is the 82C457.

        mov     dx,3D6h
        xor     al,al
        out     dx,al
        inc     dx
        in      al,dx                   ;Read chip version number.
        and     al,0F0h
        cmp     al,ID_457
        jne     initialize_success      ;Not a 82c457 VGA.

        mov     dx,03d6h                ;Turn on dithering.
        mov     al,6dh
        out     dx,al
        inc     dx
        in      al,dx
        or      al,80h
        out     dx,al

initialize_success:

;ifndef  DOSLIB
;       call    AllocNInitSelectors     ;Allocate selector to access video buffer.
;endif
;       ; call oem initialization routines if any.
;       call    PCV_OemInit

;        mov     _fInit,1
        mov     ax,1

initialize_exit:
        LEnd
        RET
EndProc PCV_Initialize


;************************************************************************
;* GetVideoMode                                                         *
;*                                                                      *
;* Routine to detect the video mode.                                    *
;*                                                                      *
;* Exported:    No                                                      *
;* Entry:       None                                                    *
;* Destroys:    AX,BX,CX,SI                                             *
;************************************************************************
Procedure GetVideoMode, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Local Variables on stack
     wHorzRes  equ bp-02
     wVertRes  equ bp-04
     wMode     equ bp-06

     LBegin 08h

get_video_mode:
        mov     dx,3D4H                 ;CRTC port address
        mov     al,1                    ;Horizontal Display Enable End
        out     dx,al
        inc     dx
        in      al,dx
        inc     al
        xor     ah,ah
        shl     ax,3                    ;Get horizontal resolution.
        mov     [wHorzRes],ax

        mov     dx,3D4H                 ;CRTC port address
        mov     al,12H                  ;Get vertical resolution.
        out     dx,al
        inc     dx
        in      al,dx
        mov     bl,al
        mov     dx,3D4H                 ;CRTC port address
        mov     al,07h
        out     dx,al
        inc     dx
        in      al,dx
        xor     bh,bh
        test    al,2
        jz      @F
        or      bh,1
@@:
        test    al,40h
        jz      @F
        or      bh,2
@@:
        inc     bx
        mov     [wVertRes],bx           ;Get vertical resolution.

        ;Check for packed pixel mode
        xor     bh,bh
        mov     bl,MF_PLANAR
        mov     dx,3C4H
        in      al,dx
        mov     cl,al                   ;Save index register contents
        mov     al,4
        out     dx,al
        in      ax,dx
        and     ah,0Eh                  ;Bit 0 is reserved.
        cmp     ah,0Eh                  ;Packed pixel mode?
                                        ;Packed pixel mode = 0x0Eh
                                        ;Planar mode = 0x06h

        mov     al,cl                   ;Restore index register contents
        out     dx,al
        jnz     @F                      ;Not packed pixel mode
        mov     bl,MF_PACKED

        ;Check for interlace mode
@@:     mov     dx,3D6H
        in      al,dx                   ;Save index register contents
        mov     cl,al
        xor     al,al                   ;Check if this is Chips 453 VGA
        out     dx,al
        in      ax,dx                   ;Chip ID is in AH.
        and     ah,0F0H
        cmp     ah,30H
        jnz     @F                      ;Not Chips 453 VGA controller
        mov     al,28H
        out     dx,al
        in      ax,dx
        test    ah,20H                  ;Interlace mode?
        jz      @F                      ;Not interlace mode
        or      bl,MF_INTERLACED
@@:
        mov     al,cl
        out     dx,al                   ;Restore index register contents

        mov     [wMode],bx
        lea     si,config_aMode
        mov     cx,(NO_VIDEO_MODES+1)   ;plus one to count for the extra entry
                                        ;reserved for current running mode

check_mode:
        mov     ax,[si].VGAWidth
        cmp     ax,[wHorzRes]
        jne     next_mode

compare_vert_res:
        mov     ax,[si].VGAHeight
        cmp     ax,[wVertRes]
        jne     next_mode

check_packed_pixel:
        mov     ax,[si].fModeFlags
        xor     ax,bx
        and     ax,MF_PACKED
        jz      have_mode

next_mode:
        add     si,SIZE MODE
        loop    check_mode

mode_not_supported:
        mov     _iVideoMode,NO_VIDEO_MODES
        mov     ax, ((SIZE MODE) * NO_VIDEO_MODES)
        add     ax,offset config_aMode
        mov     si,ax
        mov     ax,[wHorzRes]
        mov     [si].VGAWidth,ax
        mov     ax,[wVertRes]
        mov     [si].VGAHeight,ax
        mov     ax,[wMode]
        mov     [si].fModeFlags,ax
        jmp     Exit_GetMode

have_mode:
        mov     ax,(NO_VIDEO_MODES+1)   ;Plus one to count for entry reserved
                                        ;for current video mode
        sub     ax,cx
        mov     _iVideoMode,ax          ;Record the video mode number.
        cmp     ax,NO_VIDEO_MODES
        jz      Exit_GetMode

        mov     ax, ((SIZE MODE) * NO_VIDEO_MODES)
        add     ax,offset config_aMode
        mov     di,ax
        push    ds
        pop     es
        mov     cx,SIZE Mode
        rep     movsb                   ;Copy mode information.
Exit_GetMode:
        LEnd
        RET
EndProc GetVideoMode

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 SyncDetect                                                           3
;3                                                                      3
;3 Routine to detect the vga Hsync and Hsync polarity.                  3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Destroys:    AX,BX,CX,DX                                             3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure SyncDetect, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

   ;*********************************************
   ; Local Variables on stack
     PolarityHigh equ bp-02
     InvSyncP     equ bp-04
     LBegin 04h

        ; Adjust VGA Vertical Sync polarity
        mov     word ptr[PolarityHigh],0;Polarity High count
        mov     word ptr[InvSyncP],0
        xor     bx,bx                   ;BX=> Polarity low count
        mov     cx,256                  ;Loop an arbitary number of time.

Vsync_loop:
        mov     dx,config_wPortAddr    ;Set PC Video port address.
        mov     al,INTERRUPT_POLL
        out     dx,al
        inc     dx
        in      al,dx
        test    al,VGA_VSYNC
        jz      @F
        inc     word ptr[PolarityHigh]
        jmp     Vsync_done
@@:
        inc     bx
Vsync_done:
        loop    Vsync_loop

        cmp     bx,[PolarityHigh]
        jl      @F
        mov     word ptr[InvSyncP],1
@@:
        mov     dx,config_wPortAddr    ;PCVideo port address.
        mov     al,DW_WINDOW_ZOOM
        out     dx,al
        inc     dx
        in      al,dx
        mov     bx,[InvSyncP]
        shl     bl,5                    ;VGA VSync polarity bit
        xor     al,bl                   ;Programmed the Video Vsync bit.
        out     dx,al

        ; Adjust VGA Horizontal Sync polarity
        mov     word ptr[PolarityHigh],0;Polarity High count
        mov     word ptr[InvSyncP],0
        xor     bx,bx                   ;BX=> Polarity low count
        mov     cx,256                  ;Loop an arbitary number of time.

Hsync_loop:
        mov     dx,config_wPortAddr    ;Set PC Video port address.
        mov     al,INTERRUPT_POLL
        out     dx,al
        inc     dx
        in      al,dx
        test    al,VGA_HSYNC
        jz      @F
        inc     word ptr[PolarityHigh]
        jmp     Hsync_done
@@:
        inc     bx
Hsync_done:
        loop    Hsync_loop

        cmp     bx,[PolarityHigh]
        jl      @F
        mov     word ptr[InvSyncP],1
@@:
        mov     dx,config_wPortAddr    ;PCVideo port address.
        mov     al,DW_WINDOW_ZOOM
        out     dx,al
        inc     dx
        in      al,dx
        mov     bx,[InvSyncP]
        shl     bl,4                    ;VGA HSync polarity bit
        xor     al,bl                   ;Programmed the Video Hsync bit.
        out     dx,al
        LEnd
        ret
EndProc SyncDetect

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_Exit                                                             3
;3                                                                      3
;3 Routines to save the configuration file, disable the display video   3
;3 window at exit time.                                                 3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_Exit, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

;        cmp     _fInit, 1
;        je      @F
;        sub     _fInit, 1
;        jmp     pcvexit
;@@:
;        call    PCV_SaveConfiguration
;        mov     _fInit, 0
;        or      ax,ax
;        jnz     @F                      ;Success
;        call    far ptr TurnBorder
;@@:
        mov     dx,config_wPortAddr
        mov     al,DW_MODE_CNTL         ;Display window control
        out     dx,al
        inc     dx
        in      al,dx
        and     al,NOT 3                ;Disable display video window.
        out     dx,al

;ifndef DOSLIB
;        call    FreeSelectors
;
;; If this is a 82c457, turn off dithering.
;
;        mov     dx,46e8h
;        mov     al,1eh
;        out     dx,al
;        mov     dx,104h
;        in      al,dx                   ;Read chip ID.
;        mov     ah,al
;        mov     dx,46e8h
;        mov     al,0eh
;        out     dx,al
;        cmp     ah,0A5h                 ;Is this a C&T VGA?
;        jne     pcvexit                 ;No, no need to turn on dithering.
;
;; This is a C&T VGA.  Check whether it is the 82C457.
;
;        mov     dx,3D6h
;        xor     al,al
;        out     dx,al
;        inc     dx
;        in      al,dx                   ;Read chip version number.
;        and     al,0F0h
;        cmp     al,ID_457
;        jne     pcvexit                 ;Not a 82c457 VGA.
;
;        mov     dx,03d6h                ;Turn on dithering.
;        mov     al,6dh
;        out     dx,al
;        inc     dx
;        in      al,dx
;        and     al,7Eh                  ;Clear dither bit.
;        out     dx,al
;
;endif
pcvexit:
        ret
EndProc PCV_Exit


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_EnableVideo                                                      3
;3                                                                      3
;3 Enables display of video on VGA monitor.                             3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_EnableVideo, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        mov     dx,config_wPortAddr
        mov     al,DW_MODE_CNTL         ;Display window control
        out     dx,al
        inc     dx
        in      al,dx
        or      al,3                    ;Enable video acquisition.
        out     dx,al
        ret
EndProc PCV_EnableVideo
;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_DisableVideo                                                     3
;3                                                                      3
;3 Disables display of video on VGA monitor.                            3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_DisableVideo, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        mov     dx,config_wPortAddr
        mov     al,DW_MODE_CNTL         ;Display window control
        out     dx,al
        inc     dx
        in      al,dx
        and     al,NOT 3                ;Disable display video window.
        out     dx,al
        ret
EndProc PCV_DisableVideo

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_EnableColorKey                                                   3
;3                                                                      3
;3 Enables use of color keying for display of video on VGA monitor.     3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_EnableColorKey, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        mov     dx,config_wPortAddr
        mov     al,DW_MODE_CNTL         ;Display window control
        out     dx,al
        inc     dx
        in      al,dx
        and     al,NOT 8
        or      al,12h                  ;Enable use of color key.
        out     dx,al
        ret
EndProc PCV_EnableColorKey
;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_DisableColorKey                                                  3
;3                                                                      3
;3 Disables use of color keying for display of video on VGA monitor.    3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_DisableColorKey, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        mov     dx,config_wPortAddr
        mov     al,DW_MODE_CNTL         ;Display window control
        out     dx,al
        inc     dx
        in      al,dx
        and     al,NOT 12h              ;Disable use of color key.
        or      al,8
        out     dx,al
        ret
EndProc PCV_DisableColorKey

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_CreateWindow                                                     3
;3                                                                      3
;3 Creates a video Window at specified position.                        3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       xOrg, yOrg (absolute screen pixels),                    3
;3              xExt, yExt (pixels), fFitInWindow                       3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_CreateWindow, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;         ,<SI,DI>
   ;*********************************************
   ; Parameters passed in on the stack
   xOrg            equ bp+6           ;Top, left corner of window on the
   yOrg            equ bp+8           ;VGA display
   xExt            equ bp+10          ;Window height and width
   yExt            equ bp+12
   fFitInWindow    equ bp+14          ;1=Scale video to window
   Enter           0,0

        mov     ax,[xOrg]               ;Save window position.
        mov     OutWinXOrg,ax
        mov     ax,[yOrg]
        mov     OutWinYOrg,ax
        mov     ax,[xExt]               ;Save window size.
        mov     OutWinXExt,ax
        mov     ax,[yExt]
        mov     OutWinYExt,ax
        mov     ax,[fFitInWindow]
        test    _fHighRes,1
        jz      @F
        test    ax,1
        jnz     @F                      ;Fit video
        mov     ax,_wVideoWidth
        mov     OutWinXExt,ax
        mov     ax,_wVideoHeight
        mov     OutWinYExt,ax
        mov     ax,1                    ;Enable scaling
@@:
        mov     _fScaleVideo,ax
        call    far ptr UpdateVideoWindow
        leave
        ret     10
EndProc PCV_CreateWindow

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetWindowPosition                                                3
;3                                                                      3
;3 Moves the video Window to the specified position.                    3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       xOrg, yOrg (abs screen pixels)                          3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetWindowPosition, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<SI,DI>
   ;*********************************************
   ; Parameters passed in on the stack
   xOrg            equ bp+6           ;Top, left corner of window on the
   yOrg            equ bp+8           ;VGA display
       Enter           0,0

        mov     ax,[xOrg]               ;Save new position.
        mov     OutWinXOrg,ax
        mov     ax,[yOrg]
        mov     OutWinYOrg,ax
        call    far ptr UpdateVideoWindow
        leave
        ret     4
EndProc PCV_SetWindowPosition

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetWindowSize                                                    3
;3                                                                      3
;3 Changes the width and height of the video window.  Scaling can also  3
;3 be enabled or disable using this routine.                            3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       xsExt, ysOrg (pixels)                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetWindowSize, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<SI,DI>
   ;*********************************************
   ; Parameters passed in on the stack
   xsExt           equ bp+6
   ysExt           equ bp+8
   fFitInWindow    equ bp+10

        Enter   0,0
        mov     ax,[xsExt]              ;Save new width and height.
        mov     OutWinXExt,ax
        mov     ax,[ysExt]
        mov     OutWinYExt,ax
        mov     ax,[fFitInWindow]
        test    _fHighRes,1
        jz      @F
        test    ax,1
        jnz     @F                      ;Fit video
        mov     ax,_wVideoWidth
        mov     OutWinXExt,ax
        mov     ax,_wVideoHeight
        mov     OutWinYExt,ax
        mov     ax,1                    ;Enable scaling
@@:
        mov     _fScaleVideo,ax
        call    far ptr UpdateVideoWindow
        leave
        ret     6
EndProc PCV_SetWindowSize

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetVideoScaling                                                  3
;3                                                                      3
;3 Sets the video scaling and optionally enables/disables video scaling.3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       fFitInWindow                                            3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetVideoScaling, FAR,
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;<SI,DI>
   ;*********************************************
   ; Parameters passed in on the stack
   xSize           equ bp+6
   ySize           equ bp+8
   fFitInWindow    equ bp+10

        Enter   0,0
        cmp     _wVersion,1             ;Able to detect retrace?
        jge     sv_wait_for_retrace     ;Yes.
        cmp     _fFrozen,1              ;Is video already frozen?
        je      sv_continue             ;Yes, no need to freeze.
        call    far ptr FreezeVideo
        jmp     sv_continue

sv_wait_for_retrace:
        call    far ptr WaitVideoVerticalRetraceStart

sv_continue:
        mov     ax,[fFitInWindow]
        test    _fHighRes,1
        jz      @F
        test    ax,1
        jnz     @F                      ;Fit video
        mov     ax,_wVideoWidth
        mov     OutWinXExt,ax
        mov     ax,_wVideoHeight
        mov     OutWinYExt,ax
        mov     ax,1                    ;Enable scaling
@@:
        mov     _fScaleVideo,ax
        or      ax,ax
        jnz     sv_enable_scaling

sv_disable_scaling:
        mov     _bVZoomAdjust,0
        mov     ah,_bVZoomFactor
        call    far ptr VerticalZoom
        call    far ptr DisableScaling
        test    config_wCfgFlags,CF_REPLICATE
        jz      sv_wait
        call    far ptr EnableFieldReplicate
        jmp     sv_wait

sv_enable_scaling:
        test    _fHighRes,1
        jz      @F
        mov     _bHZoomAdjust,0
        mov     ah, _bHZoomFactor
        cmp     ah, 3                   ;Is zoom level at maximimum?
        je      @F
        mov     _bHZoomAdjust,1         ;Adjust horizental zoom up by 1
        inc     ah
        call    far ptr HorizontalZoom
@@:
        mov     _bVZoomAdjust,0
        mov     ah,_bVZoomFactor
        test    config_wCfgFlags,CF_REPLICATE
        jz      @F
        call    far ptr DisableFieldReplicate
        mov     ah,_bVZoomFactor
        cmp     ah,3                    ;Is zoom level at maximimum?
        je      @F                      ;Do not emulate replicate field.
        mov     bx,OutWinYExt
        add     bx,bx
        cmp     bx,_wVideoHeight        ;Is height greater than 1/2?
        jle     @F
        mov     _bVZoomAdjust,1         ;Adjust vertical zoom up by 1.
        inc     ah

@@:     call    far ptr VerticalZoom
        push    [xSize]
        push    [ySize]
        call    far ptr ScaleVideo

sv_wait:
        cmp     _wVersion,1             ;Able to check for retrace?
        jge     sv_acquire_field
        cmp     _fFrozen,1              ;Is video supposed to frozen?
        je      sv_exit                 ;Yes, do not unfreeze.
        call    far ptr UnFreezeVideo   ;No, unfreeze.
        jmp     sv_exit

sv_acquire_field:
        call    far ptr WaitToAcquireField;Wait for one field to be acquired.

sv_exit:
        leave
        ret     6
EndProc PCV_SetVideoScaling

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetCaptureAddress                                                3
;3                                                                      3
;3 Sets the address in the video buffer for captured video.             3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       X,Y coordinates in the capture buffer.                  3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetCaptureAddress, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<SI,DI>
   ;*********************************************
   ; Parameters passed in on the stack
   XX              equ bp+6
   YY              equ bp+8

        enter   0,0
        mov     ax,[XX]
        mov     xCapture,ax
        push    ax
        mov     ax,[YY]
        mov     yCapture,ax
        push    ax
        call    far ptr SetCaptureAddress
        leave
        ret     4
EndProc PCV_SetCaptureAddress


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetVideoAddress                                                  3
;3                                                                      3
;3 Sets the address in the video buffer for captured video.             3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       VIDEO_Address                                           3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetVideoAddress, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   V_ADDR          equ bp+6

        enter   0,0
        pushfd
        CLI
        push    bx
        mov     bx,[XX]
        and     bx,0Fh
        mov     dx,config_wPortAddr
        mov     al,06                  ; REG 6 = Video Buffer Address
        out     dx,al
        inc     dx
        in      al,dx
        and     al,0F0h
        or      al,bl
        out     dx,al                  ;New Frame Buffer Address
        popfd
        pop     bx
        leave
        ret     2
EndProc PCV_SetVideoAddress

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetDisplayWindow                                                 3
;3                                                                      3
;3 Sets the display window registers.                                   3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       X,Y,xExt,yExt of new display window.                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetDisplayWindow, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<SI,DI>
   ;*********************************************
   ; Parameters passed in on the stack
   XX              equ bp+6
   YY              equ bp+8
   xExt            equ bp+10
   yExt            equ bp+12

        enter   0,0
        mov     ax,[XX]                 ;Save window position.
        mov     OutWinXOrg,ax
        mov     ax,[YY]
        mov     OutWinYOrg,ax
        mov     ax,[xExt]               ;Save window size.
        mov     OutWinXExt,ax
        mov     ax,[yExt]
        mov     OutWinYExt,ax
        cmp     _wVersion,1             ;Able to check for retrace?
        jl      @F
        call    far ptr WaitVGAVerticalRetraceStart
@@:     push    [XX]
        push    [YY]
        push    [xExt]
        push    [yExt]
        call    far ptr SetDisplayWindow
        leave
        ret     8
EndProc PCV_SetDisplayWindow

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetColorKey                                                      3
;3                                                                      3
;3 Routine to set the color key used by PC Video to select between      3
;3 video and VGA output.   Pixels in the VGA display memory set to      3
;3 this color will display video.  This routine assumes that the        3
;3 internal palette is programmed to pass values through unchanged for  3
;3 packed pixel modes.  This is a safe assumption because in packed     3
;3 pixel modes each nibble passes through the internal palette before   3
;3 being assembled into the 8 bit values used to index into the         3
;3 external palette.  In planar modes the output of the internal        3
;3 palette is 6 bits.                                                   3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       iColor                                                  3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetColorKey, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   iColor          equ bp+6

        enter   0,0
        mov     ax,[iColor]
        mov     ah,al
; KLL 9/28/93 Removed next to set to PM Query Physical Pallet number
;       cmp     ah,0FH
;       ja      sck_set_color_register
        jmp     sck_set_color_register


sck_read_int_palette:
        mov     dx,3DAH                 ;Input status address
        in      al,dx                   ;Clear attribute flip-flop.
        mov     dl,0C0H                 ;DX = Attribute Address
        mov     al,ah                   ;Color
        out     dx,al                   ;Read color from internal palette.
        inc     dx
        in      al,dx                   ;Color to be programmed in PC video register
        mov     ah,al
        mov     dl,0DAH                 ;DX = Input status port
        in      al,dx
        mov     al,20H                  ;Enable video.
        mov     dl,0C0H                 ;DX = Attribute Address
        out     dx,al                   ;Video is on.

sck_set_color_register:
        mov     dx,config_wPortAddr
        mov     al,TRANS_COLOR
        out     dx,ax
        leave
        ret     2
EndProc PCV_SetColorKey

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 UpdateVideoWindow                                                    3
;3                                                                      3
;3 Internal routine to update video display window for changes in skew  3
;3 factors, output scaling, etc.                                        3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure UpdateVideoWindow, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        cmp     _fFrozen,0              ;Should video be frozen?
        jne     uvw_continue            ;Yes, do not freeze again.
        cmp     _wVersion,1             ;Able to check for retrace?
        jl      uvw_freeze
        call    far ptr WaitVGAVerticalRetraceStart
        jmp     uvw_continue

uvw_freeze:
        call    far ptr FreezeVideo     ;Stop input acquisition.

uvw_continue:
        cmp     _fScaleVideo,0
        je      update_unscaled_video

        test    _fHighRes,1
        jz      @F
        mov     _bHZoomAdjust,0
        mov     ah, _bHZoomFactor
        cmp     ah, 3                   ;Is zoom level at maximimum?
        je      @F
        mov     _bHZoomAdjust,1         ;Adjust horizental zoom up by 1
        inc     ah
        call    far ptr HorizontalZoom
@@:

        test    config_wCfgFlags,CF_REPLICATE
        jz      update_scaled_video     ;Replicate is not on.
        call    far ptr DisableFieldReplicate
        cmp     _bVZoomFactor,3         ;Is zoom level at maximimum?
        je      update_scaled_video     ;Do not emulate replicate field.

uvw_field_mode:
        mov     dx,config_wPortAddr    ;Acquire one field only.
        mov     al,AV_MODE_CNTL
        out     dx,al
        inc     dx
        in      al,dx
        or      al,4                    ;Turn on field acquistion.
        out     dx,al

uvw_vertical_zoom:
        mov     bl,_bVZoomFactor
        xor     bh,bh                   ;Vertical zoom adjustment
        mov     ax,OutWinYExt
        shl     ax,1
        cmp     ax,_wVideoHeight        ;Scaling Y down by more than 2?
        jle     uvw_set_zoom_level      ;Yes, do not zoom up more.
        inc     bh                      ;Increment vertical zoom factor by 1.

uvw_set_zoom_level:
        mov     _bVZoomAdjust,bh
        add     bl,bh                   ;Vertical zoom factor
        mov     ah,bl
        call    far ptr VerticalZoom

update_scaled_video:
        call    far ptr FitVideo        ;Fit video to window.
        jmp     uvw_wait

update_unscaled_video:
        mov     _bVZoomAdjust,0
        mov     ah,_bVZoomFactor
        call    far ptr VerticalZoom
        call    far ptr UnScaleVideo    ;Do not scale video.
        test    config_wCfgFlags,CF_REPLICATE
        jz      uvw_wait
        call    far ptr EnableFieldReplicate

uvw_wait:
        cmp     _fFrozen,0              ;Should video be frozen?
        jne     uvw_exit                ;Yes, do not unfreeze.
        call    far ptr UnFreezeVideo
        cmp     _wVersion,1             ;Able to check for retrace?
        jl      uvw_exit
        call    far ptr WaitToAcquireField;Wait for one field to be acquired.

uvw_exit:
        ret
EndProc UpdateVideoWindow

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_PanWindow                                                        3
;3                                                                      3
;3 Changes the portion of the video buffer shown in the display window. 3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       XX Coordinate in video buffer of left side of picture   3
;3              YX Coordinate of bottom of picture                      3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_PanWindow, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<SI,DI>
   ;*********************************************
   ; Parameters passed in on the stack
   XX              equ bp+6
   YY              equ bp+8

        enter 0,0
        cmp     _wVersion,1             ;Able to check for retrace?
        jl      @F
        call    far ptr WaitVGAVerticalRetraceStart
@@:     mov     ax,[XX]
        mov     xPan,ax
        mov     ax,[YY]
        mov     yPan,ax

        mov     ax,xPan
        neg     ax
        add     ax,OutWinXOrg
        push    ax

        mov     ax,yPan
        neg     ax
        add     ax,OutWinYOrg
        push    ax
        call    far ptr SetDisplayPosition ;Reset the display position.

pw_exit:
        leave
        ret     6
EndProc PCV_PanWindow

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_HorizontalZoom                                                   3
;3                                                                      3
;3 Routine to set the horizontal zoom factor.                           3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       iZoomFactor = 0 (1x), 1 (2x), 2(4x), or 3(8x)           3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_HorizontalZoom, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   iZoomFactor     equ bp+6
        enter   0,0
        mov     ax,[iZoomFactor]
        mov     ah,al
        mov     _bHZoomFactor,ah
        add     ah, _bHZoomAdjust
        call    far ptr HorizontalZoom
        call    far ptr UpdateVideoWindow
        leave
        ret     2
EndProc PCV_HorizontalZoom

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_VerticalZoom                                                     3
;3                                                                      3
;3 Routine to set the vertical zoom factor.                             3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       iZoomFactor = 0 (1x), 1 (2x), 2(4x), or 3(8x)           3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_VerticalZoom, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   iZoomFactor     equ bp+6

        enter   0,0
        mov     ax,[iZoomFactor]
        mov     ah,al
        mov     _bVZoomFactor,ah
        add     ah,_bVZoomAdjust
        call    far ptr VerticalZoom
        call    far ptr UpdateVideoWindow
        leave
        ret     2
EndProc PCV_VerticalZoom

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_EnableFieldReplication                                           3
;3                                                                      3
;3 Routine to enable field replication to prevent motion artifacts.     3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_EnableFieldReplication, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        or      config_wCfgFlags,CF_REPLICATE
        cmp     _fScaleVideo,0
        jne     @F
        call    far ptr EnableFieldReplicate
@@:     call    far ptr UpdateVideoWindow
        ret
EndProc PCV_EnableFieldReplication

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 EnableFieldReplicate                                                 3
;3                                                                      3
;3 Internal routine to enable field replication.                        3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure EnableFieldReplicate, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        mov     dx,config_wPortAddr
        mov     al,INTERLACE_CNTL
        out     dx,al
        inc     dx
        in      al,dx
        or      al,8
        out     dx,al                   ;Turn on replicate field feature.
        dec     dx
        mov     al,AV_MODE_CNTL
        out     dx,al
        inc     dx
        in      al,dx
        or      al,00000100b            ;Turn on field acquistion.

        cmp     _wVersion,2             ;PCVIDEO II?
        jl      @F
        and     al,NOT 00000001b        ;Clear video acquisition status
        cmp     _fFrozen,1              ;Is image supposed to be frozen?
        jz      @F
        or      al,00000001b            ;Turn video acquistion bit on

@@:     out     dx,al
        ret
EndProc EnableFieldReplicate

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_DisableFieldReplication                                          3
;3                                                                      3
;3 Routine to disable field replication.                                3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_DisableFieldReplication, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        and     config_wCfgFlags,NOT CF_REPLICATE
        cmp     _fScaleVideo,0
        jne     @F
        call    far ptr DisableFieldReplicate
@@:     mov     _bVZoomAdjust,0         ;Clear zoom adjust.
        mov     ah,_bVZoomFactor
        call    far ptr VerticalZoom
        call    far ptr UpdateVideoWindow
        ret
EndProc PCV_DisableFieldReplication

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 DisableFieldReplicate                                                3
;3                                                                      3
;3 Internal routine to disable field replication.                       3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure DisableFieldReplicate, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        mov     dx,config_wPortAddr
        mov     al,INTERLACE_CNTL
        out     dx,al
        inc     dx
        in      al,dx
        and     al,NOT 8
        out     dx,al                   ;Turn off replicate field feature.
        dec     dx
        mov     al,AV_MODE_CNTL
        out     dx,al
        inc     dx
        in      al,dx
        and     al,NOT 00000100b        ;Turn off field acquistion.

        cmp     _wVersion,2             ;PCVIDEO II?
        jl      @F
        and     al,NOT 00000001b        ;Clear video acquisition status
        cmp     _fFrozen,1              ;Is image supposed to be frozen?
        jz      @F
        or      al,00000001b            ;Turn video acquistion bit on

@@:     out     dx,al
        ret
EndProc DisableFieldReplicate

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_FreezeVideo                                                      3
;3                                                                      3
;3 Routines to disable acquisition of video.                            3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_FreezeVideo, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        mov     dx,config_wPortAddr
        mov     al,AV_MODE_CNTL         ;Acquisition Mode Control Register
        out     dx,al
        inc     dx
        in      al,dx                   ;Read current value.
        call    far ptr FreezeVideo
        mov     _fFrozen,1              ;Record that video is frozen.
        ret
EndProc PCV_FreezeVideo

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_UnFreezeVideo                                                    3
;3                                                                      3
;3 Enable video acquisition.                                            3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_UnFreezeVideo, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        call    far ptr UnFreezeVideo
        mov     _fFrozen,0              ;Record that video is not frozen.
        ret
EndProc PCV_UnFreezeVideo

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_ClearVideoRect                                                   3
;3                                                                      3
;3 Clears the specified rectangular area of the video buffer.           3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       XX,YY           Top left of the rectangular area        3
;3              xExt,yExt       Size of the rectangular area            3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_ClearVideoRect, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<SI,DI,ES>
   ;*********************************************
   ; Parameters passed in on the stack
   XX              equ bp+6            ;X position in video buffer
   YY              equ bp+8            ;Y position in video buffer
   xExt            equ bp+10           ;Width of the image
   yExt            equ bp+12           ;Height of the image

   ;*********************************************
   ; Local Variables on stack
     cScans      equ bp-02
     NumScans    equ bp-04
     ShiftCnt    equ bp-06
     ModMask     equ bp-08
     yPosition   equ bp-10
     cScansInSeg equ bp-12
     wSegIndex   equ bp-14
     enter       20,0

;ifdef DOSLIB
;        localW  yPosition
;else
;        localW  cScansInSeg
;        localW  wSegIndex
;endif

        test    _fHighRes, 1
        jz      @F
        mov     ax,[XX]
        shr     ax, 1
        mov     [XX], ax
        mov     ax,[xExt]
        shr     ax, 1
        mov     [xExt], ax
@@:
        cmp     _wBoardType,BT_RGB24    ;RGB 24 bit Board.
        je      @F
        mov     ax,1fh                  ;Mask for MOD 32 operation
        mov     [ModMask],ax
        mov     ax,20h                  ;Each segment has 32 scan lines
        mov     [NumScans],ax
        mov     ax,5                    ;Shift count for number of scan lines
        mov     [ShiftCnt],ax
        jmp     clear_video_init_done
@@:
        mov     ax,0fh                  ;Mask for MOD 16 operation
        mov     [ModMask],ax
        mov     ax,10h                  ;Each segment has 16 scan lines
        mov     [NumScans],ax
        mov     ax,4                    ;Shift count for number of scan lines
        mov     [ShiftCnt],ax

clear_video_init_done:

        cmp     _fFrozen,1
        je      @F
        call    far ptr FreezeVideo     ;Input acquisition must be off to access buffer.

@@:     mov     ax,_wCapBufWidth
        cmp     [xExt],ax
        jle     @F
        mov     [xExt],ax
@@:     mov     ax,_wCapBufHeight
        cmp     [yExt],ax
        jle     cvb_clear_rect
        mov     [yExt],ax

cvb_clear_rect:
        push    [XX]
        push    [YY]
        call    far ptr ComputeVideoAddress;AX:DX <- video buffer address
        mov     es,ax
        mov     di,dx
        mov     ax,[yExt]
        mov     [cScans],ax
        push    [xExt]
        call    far ptr ComputeLoopParameters   ;BX=scan increment, AX=inner loop count
        mov     ax,[YY]
        mov     cx,[ShiftCnt]
        shr     ax,cl
        mov     [wSegIndex],ax          ;Starting segment number.
        mov     ax,[YY]
        mov     cx,[ModMask]
        and     ax,cx                   ;Y modulo number of scan lines
        mov     cx,[NumScans]
        sub     ax,cx
        neg     ax
        sub     [cScans],ax
        jge     @F
        mov     ax,[yExt]
        mov     word ptr[cScans],0
@@:     mov     [cScansInSeg],ax
        xor     ax,ax

cvb_clear_scan:
        mov     cx,[xExt]               ;Number of words to clear/scan
        cmp     _wBoardType,BT_RGB24    ;RGB 24 bit Board.
        jne     @F
        shl     cx,1                    ;For RGB 24 bit board, each pixel
                                        ;takes 4 bytes.
@@:
        rep     stosw                   ;Clear on scan.
        add     di,bx                   ;Next scan in video buffer
        dec     word ptr[cScansInSeg]   ;Decrement count of scans in segment.
        jnz     cvb_clear_scan

        cmp     word ptr[cScans],0      ;Have all scans been cleared?
        jle     cvb_exit                ;Yes, exit.

cvb_next_segment:
        mov     ax,[NumScans]
        sub     [cScans],ax
        jge     @F
        mov     ax,[cScans]             ;Must clear fewer than number of scans
                                        ;in the last segment.
        add     ax,[NumScans]
@@:     mov     [cScansInSeg],ax
        inc     word ptr[wSegIndex]
        mov     ax,[wSegIndex]
        cmp     NSelectors,ax           ;Are we exceeding our addressable range?
        jle     cvb_exit
        mul     NextSelIncr
        add     ax,FrameBufSel          ;Selector
        mov     es,ax
        xor     ax,ax
        jmp     cvb_clear_scan

cvb_exit:
        cmp     _fFrozen, 1
        je      @F
        call    far ptr UnFreezeVideo
@@:     mov     ax,1                    ;Return success.
        leave
        ret     8
EndProc PCV_ClearVideoRect

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_GetInputFormat                                                   3
;3                                                                      3
;3 Returns the video input format ( NTSC, PAL or SECAM).                3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;3 Returns:     AX=CF_NTSC ,CF_PAL or CF_SECAM                          3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_GetInputFormat, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        mov     ax,config_wCfgFlags
        mov     bx,CF_NTSC
        or      bx,CF_SECAM             ; (CF_NTSC | CF_SECAM)
        and     ax,bx
        .errnz  (CF_NTSC-1)
        .errnz  CF_PAL
        ret
EndProc PCV_GetInputFormat

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetInputFormat                                                   3
;3                                                                      3
;3 Set the video input format through the multistandard decoder for     3
;3 either NTSC or PAL format.                                           3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       fNTSC = CF_NSTC or CF_PAL                               3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetInputFormat, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   fInputFormat    equ bp+6
        enter   0,0
        push    [fInputFormat]
        call    far ptr SetInputFormat
        leave
        ret     2
EndProc PCV_SetInputFormat

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 SetInputFormat                                                       3
;3                                                                      3
;3 Inpternal routine to set the video input format through the decoder  3
;3 for either NTSC or PAL format.                                       3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       fNTSC = CF_NSTC, CF_PAL or CF_SECAM                     3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure SetInputFormat, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   fInputFormat    equ bp+6

        enter   0,0
        cmp     word ptr[fInputFormat],CF_NTSC
        je      NTSC_format

        cmp     word ptr[fInputFormat],CF_SECAM
        je      SECAM_format

PAL_format:
        and     config_wCfgFlags,(NOT CF_NTSC)
        and     config_wCfgFlags,(NOT CF_SECAM)
        cmp     _wBoardType,BT_YUV411
        je      yuv_pal

        push    ADRDMSD                 ;Digital multistandard decoder
        push    0dh                     ;index
        push    80h                     ;data
        call    far ptr wr_i2c
        mov     bx,PAL_SECAM
        shl     bx,3                    ;get the correspondent index
        jmp     sif_set_acquisition_window

yuv_pal:
        push    ADRDMSD                 ;Digital multistandard decoder
        push    6h                      ;index
        push    32h                     ;data
        call    far ptr wr_i2c

        push    ADRDMSD                 ;Digital multistandard decoder
        push    8h                      ;index
        push    38h                     ;data
        call    far ptr wr_i2c
        mov     bx,PAL_SECAM
        shl     bx,3                    ;get the correspondent index
        jmp     sif_set_acquisition_window

SECAM_format:
        cmp     _wBoardType,BT_YUV411
        je      sif_exit                ;YUV board don't support SECAM

        or      config_wCfgFlags,CF_SECAM
        push    ADRDMSD                 ;Digital multistandard decoder
        push    0dh                     ;index
        push    81h                     ;data
        call    far ptr wr_i2c
        mov     bx,PAL_SECAM
        shl     bx,3                    ;get the correspondent index
        jmp     sif_set_acquisition_window

NTSC_format:
        or      config_wCfgFlags,CF_NTSC
        cmp     _wBoardType,BT_YUV411
        je      yuv_ntsc

        push    ADRDMSD                 ;Digital multistandard decoder
        push    0dh                     ;index
        push    80h                     ;data
        call    far ptr wr_i2c
        mov     bx,NTSC
        shl     bx,3                    ;get the correspondent index
        jmp     sif_set_acquisition_window

yuv_ntsc:
        push    ADRDMSD                 ;Digital multistandard decoder
        push    6                       ;index
        push    22h                     ;data
        call    far ptr wr_i2c

        push    ADRDMSD                 ;Digital multistandard decoder
        push    8                       ;index
        push    77h                     ;data
        call    far ptr wr_i2c
        mov     bx,NTSC                 ;get the correspondent index
        shl     bx,3

sif_set_acquisition_window:
        push    _AcquisitionWindow[bx].aX1
        push    _AcquisitionWindow[bx].aY1
        push    _AcquisitionWindow[bx].aX2
        push    _AcquisitionWindow[bx].aY2
        call    far ptr SetAcquisitionWindow

sif_exit:
        leave
        ret    2
EndProc SetInputFormat

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_GetVideoSource                                                   3
;3                                                                      3
;3 Get the video input source setting.                                  3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;3 Exit:        AX = Input source setting (0-3)                         3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_GetVideoSource, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        mov     ax,config_wVideoSource
        and     ax,3
        ret
EndProc PCV_GetVideoSource

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetVideoSource                                                   3
;3                                                                      3
;3 Set the video input source on digital multistandard decoder.         3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       wSourceSelect                                           3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetVideoSource, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   wInputSource    equ bp+6

        enter   0,0
        push    [wInputSource]
        call    far ptr SetVideoSource
        leave
        ret     2
EndProc PCV_SetVideoSource

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 SetVideoSource                                                       3
;3                                                                      3
;3 Internal routine to set the video input source on the decoder.       3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       wSourceSelect                                           3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure SetVideoSource, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   wInputSource    equ bp+6

        enter   0,0
        mov     ax,[wInputSource]
        and     ax,3
        mov     config_wVideoSource,ax
        cmp     _wBoardType,BT_RGB16
        je      svs_rgb_board
        cmp     _wBoardType,BT_RGB24
        je      svs_rgb_board
        cmp     Type_Card,3
        je      yuv_wintv

svs_yuv_board:
        shl     al,3
        or      al,42h
        push    ADR9051                 ;9051 digital multistandard decoder
        push    0Ah                     ;Index
        push    ax                      ;Data
        call    far ptr wr_i2c
        jmp     svs_exit

yuv_wintv:
        or      al,0E0h
        push    ADR9051                 ;9051 digital multistandard decoder
        push    09h                     ;Index
        push    ax                      ;Data
        call    far ptr wr_i2c
        jmp     svs_exit

svs_rgb_board:
        mov     bl,78h
        cmp     config_wVideoSource,1  ;Input 2 is for an SVHS source.
        jne     @F
        mov     bl,7Dh
@@:     or      al,bl
        push    ADR7191                 ;7191 digital multistandard decoder
        push    0Eh                     ;Index
        push    ax                      ;Data
        call    far ptr wr_i2c

svs_exit:
        mov     ax,1                    ;Return success.
        leave
        ret     2
EndProc SetVideoSource

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 TurnBorder                                                           3
;3                                                                      3
;3 Debugging routine to set the border color.                           3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       wColor = overscan color                                 3
;3 Modifies:    AX,DX                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_TurnBorder, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<AX,DX>
   ;*********************************************
   ; Parameters passed in on the stack
   wColor          equ bp+6

        enter   0,0
        mov     dx,3DAH                 ;Input status address
        in      al,dx                   ;Clear attribute flip-flop.
        mov     dl,0C0H                 ;DX = Attribute Address
        mov     al,31H                  ;Turn on border.
        out     dx,al
        mov     ax,[wColor]
        out     dx,al
        leave
        ret     2
EndProc PCV_TurnBorder

Procedure  TurnBorder, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<AX,DX>
   ;*********************************************
   ; Parameters passed in on the stack
   wColor          equ bp+6

        enter   0,0
        mov     dx,3DAH                 ;Input status address
        in      al,dx                   ;Clear attribute flip-flop.
        mov     dl,0C0H                 ;DX = Attribute Address
        mov     al,31H                  ;Turn on border.
        out     dx,al
        mov     ax,[wColor]
        out     dx,al
        leave
        ret     2
EndProc TurnBorder

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 FitVideo                                                             3
;3                                                                      3
;3 Displays a video window on the screen with video scaled to fit the   3
;3 the window.                                                          3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       OutWinXOrg, OutWinYOrg, OutWinXExt, OutWinYExt          3
;3              InVideoXExt, InVideoYExt                                3
;3 Modifies:    AX,BX,CX,DX,FLAGS                                       3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure FitVideo, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        push    OutWinXExt
        push    OutWinYExt
        call    far ptr ScaleVideo      ;Set scaling registers.
        push    xCapture
        push    yCapture
        call    far ptr SetCaptureAddress;Set capture address.
        push    OutWinXOrg              ;Set the address in capture buffer
        push    OutWinYOrg              ;to begin displaying video data.
        call    far ptr SetDisplayPosition
        push    OutWinXOrg              ;X,Y position on VGA of the
        push    OutWinYOrg              ;video display window.
        push    OutWinXExt              ;Width and height of display window.
        push    OutWinYExt
        call    far ptr SetDisplayWindow;Program display window registers.
        ret
EndProc FitVideo

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 ScaleVideo                                                           3
;3                                                                      3
;3   Routine to set the vertical and horizontal scaling terms and       3
;3 enable scaling as needed.                                            3
;3   Video is scaled on input by dropping pixels and scans using a DDA  3
;3 algorithm (digital differential analysis).  When scaling is enabled, 3
;3 an error term is maintained for the corresponding axis.  Each time   3
;3 a pixel (or scan) is acquired, an increment is added to the error    3
;3 term and when this overflows, the pixel (or scan) is stored in the   3
;3 video buffer.  Otherwise, it is discarded.  This routine computes    3
;3 the values of the X and Y increments and enables scaling in each     3
;3 direction as necessary.  If the scaling in the Y direction reduces   3
;3 the height by a factor of 2 or more, field acquistion is enabled so  3
;3 that only one field is acquired rather than some scans from both     3
;3 fields.  This reduces flicker.                                       3
;3   The scaling terms are 6 bit fractions less than 1 and are computed 3
;3 as follows:                                                          3
;3                                                                      3
;3  xIncrement = 64*xSize/_wVideoWidth                                  3
;3  yIncrement = 64*ySize/_wVideoHeight                                 3
;3                                                                      3
;3 The fractions are multiplied by 64 because they are less than 1.     3
;3 Note that these numbers must be rounded up.                          3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,BX,CX,DX                                             3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure ScaleVideo, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   xSize           equ bp+8
   ySize           equ bp+6
   enter           0,0


sv_compute_x_scale_factor:
        mov     ax,[xSize]
        shl     ax,6                    ;64*xSize

        test    _fHighRes,1             ;In high resolution mode with PCVideo 69001/69002
        jz      @F
        mov     dh, _bHZoomFactor       ;Is zoom level at maximimum?
        cmp     dh, 3
        je      @F
        shr     ax, 1                   ;Scaled down by factor of 2
@@:
        xor     dx,dx
        mov     bx,_wVideoWidth
        div     bx                      ;64*xSize/_wVideoWidth
        or      dx,dx
        je      @F
        inc     ax
@@:     mov     cx,ax

sv_compute_y_scale_factor:
        mov     ax,[ySize]
        shl     ax,6                    ;64*ySize
        test    config_wCfgFlags,CF_REPLICATE
        jz      @F                      ;Field replication not enabled.
        mov     bx,_wVideoHeight        ;Check if scaling Y by 2 or more.
        shr     bx,1                    ;Video height divided by 2
        cmp     [ySize],bx
        jle     @F                      ;Scaling down by at least 2.
        shr     ax,1                    ;32*ySize
@@:     xor     dx,dx
        mov     bx,_wVideoHeight
        div     bx                      ;64*ySize/_wVideoHeight
        or      dx,dx
        je      @F
        inc     ax
@@:     mov     bx,ax                   ;CX = Scale X   BX = Scale Y

sv_set_scale_factors:
        mov     dx,config_wPortAddr
        mov     al,AW_MODE_CNTL         ;Acquisition Mode Control Register
        out     dx,al
        inc     dx
        in      al,dx                   ;Read current value.
        and     al,11110010b            ;Acquire input video frame & even field
        or      al,1                    ;Crop video enable

        cmp     cx,40h                  ;Is X scale factor >= 1?
        jge     @F                      ;Yes, do not enable X scaling.
        or      al,00000100b            ;Enable X scaling.
@@:     cmp     bx,40h                  ;Is Y scale factor >= 1?
        jge     @F                      ;Yes, do not enable Y scaling.
        or      al,00001000b            ;Enable Y scaling
@@:     out     dx,al
        dec     dx

        mov     al,AV_MODE_CNTL         ;Program field acquisition bit.
        out     dx,al                   ;Acquisition Mode Control Register
        inc     dx
        in      al,dx
        and     al,NOT 00000100b        ;Clear field acquisition bit

        cmp     _wVersion,2             ;PCVIDEO II?
        jl      @F
        and     al,NOT 00000001b        ;Clear video acquisition status
        cmp     _fFrozen,1              ;Is image supposed to be frozen?
        jz      @F
        or      al,00000001b            ;Turn video acquistion bit on

@@:
        cmp     bl,20H                  ;Acquire only one field?
        jg      @F                      ;No, we are all set.
        or      al,00000100b            ;Turn on field acquisition mode.
@@:     out     dx,al
        dec     dx


        cmp     cx,40h
        jge     no_x_scale              ;Scale factor is zero for X.
        mov     al,AW_X_SCALING
        mov     ah,cl
        out     dx,ax

no_x_scale:
        cmp     bx,40h
        jge     no_y_scale
        mov     al,AW_Y_SCALING
        mov     ah,bl
        out     dx,ax
        inc     al                      ;Program scaling field adjust register
        .errnz  (AW_Y_SCALING_ODD - AW_Y_SCALING -1)
        out     dx,ax                   ;Program the same value.

no_y_scale:
        leave
        ret     4
EndProc ScaleVideo

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 UnScaleVideo                                                         3
;3                                                                      3
;3 Sets the PC Video register values to display video at full size.     3
;3 Since the display window may be smaller than the image in the        3
;3 video buffer, only part of the image may be displayed.               3
;3                                                                      3
;3 For full size video, horizontal and vertical scaling is disabled.    3
;3 The display address and the display window control registers are     3
;3 set depending on the position of the window on the screen.  The      3
;3 capture address is always set to zero, though it could be set to     3
;3 another location.  Video is frozen while the PC Video registers are  3
;3 being set.                                                           3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       OutWinXOrg, OutWinYOrg, OutWinXExt, OutWinYExt          3
;3              InVideoXExt, InVideoYExt, xPan, yPan are set.           3
;3 Modifies:    AX,BX,CX,DX,FLAGS                                       3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure UnScaleVideo, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

        call    far ptr DisableScaling  ;Turn off X and Y scaling of video.
        push    xCapture                ;X,Y position in video buffer to
        push    yCapture                ;begin storing captured video data.
        call    far ptr SetCaptureAddress;Set capture address in video buffer.
        push    OutWinXOrg              ;X,Y position on VGA of the
        push    OutWinYOrg              ;video display window.
        push    OutWinXExt              ;Width and height of display window.
        push    OutWinYExt
        call    far ptr SetDisplayWindow;Program display window registers.

        mov     ax,xPan
        neg     ax
        add     ax,OutWinXOrg
        push    ax

        mov     ax,yPan
        neg     ax
        add     ax,OutWinYOrg
        push    ax
        call    far ptr SetDisplayPosition
        ret
EndProc UnScaleVideo

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 WaitToAcquireField                                                   3
;3                                                                      3
;3 Loops until one whole field has been acquired.                       3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,CX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure WaitToAcquireField, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        mov     dx,config_wPortAddr
        mov     al,INTERRUPT_POLL
        out     dx,al
        inc     dx
        mov     cx,0ffffh               ;Time out if it takes too long.
@@:     in      al,dx                   ;Loop if not in vertical retrace.
        test    al,VIDEO_VSYNC
        jne     @F                      ;If 1, drop out.
        loop    @B
@@:     call    far ptr WaitVideoVerticalRetraceStart
        ret
EndProc WaitToAcquireField

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 WaitVideoVerticalRetraceStart                                        3
;3                                                                      3
;3 Wait until the start of video vertical retrace.                      3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,CX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure WaitVideoVerticalRetraceStart, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        mov     dx,config_wPortAddr
        mov     al,INTERRUPT_POLL
        out     dx,al
        inc     dx
        mov     cx,0ffffh
@@:     in      al,dx                   ;Wait until out of vertical sync.
        test    al,VIDEO_VSYNC
        loopz   @B                      ;If 1, drop out.
        mov     cx,0ffffh
@@:     in      al,dx                   ;Wait for start of vertical sync.
        test    al,VIDEO_VSYNC
        loopnz  @B                      ;If 0, drop out.
        ret
EndProc WaitVideoVerticalRetraceStart

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 WaitVGAHorizontalRetraceEnd                                          3
;3                                                                      3
;3 Wait until the end of VGA horizontal retrace.                        3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,CX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure WaitVGAHorizontalRetraceEnd, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        mov     dx,config_wPortAddr
        mov     al,INTERRUPT_POLL
        out     dx,al
        inc     dx
        mov     cx,0ffffh               ;Time out if it takes too long.
@@:     in      al,dx                   ;Wait until out of vertical sync.
        test    al,VGA_HSYNC
        loopz   @B                      ;If 1, drop out.
        mov     cx,0ffffh               ;Time out if it takes too long.
@@:     in      al,dx                   ;Wait for start of vertical sync.
        test    al,VGA_HSYNC
        loopnz  @B                      ;If 0, drop out.
        ret
EndProc WaitVGAHorizontalRetraceEnd

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_WaitVGARetrace                                                   3
;3                                                                      3
;3 Wait until the start of VGA vertical retrace.                        3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;3 Modifies:    AX,DX                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_WaitVGARetrace, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<DX>

        cmp     _wVersion,1
        jl      wait_exit               ;No can do.
        call    far ptr WaitVGAVerticalRetraceStart

wait_exit:
        ret
EndProc PCV_WaitVGARetrace

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 WaitVGAVerticalRetraceStart                                          3
;3                                                                      3
;3 Wait until the start of VGA vertical retrace.                        3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,CX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure WaitVGAVerticalRetraceStart, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        mov     dx,config_wPortAddr
        mov     al,INTERRUPT_POLL
        out     dx,al
        inc     dx
        mov     cx,0ffffh               ;Time out if it takes too long.
@@:     in      al,dx                   ;Wait until out of vertical sync.
        test    al,VGA_VSYNC
        loopnz  @B                      ;If 0, drop out.
        mov     cx,0ffffh               ;Time out if it takes too long.
@@:     in      al,dx                   ;Wait for start of vertical sync.
        test    al,VGA_VSYNC
        loopz   @B                      ;If 1, drop out.
        ret
EndProc WaitVGAVerticalRetraceStart

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 DisableScaling                                                       3
;3                                                                      3
;3 Disable vertical and horizontal scaling of video data.               3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,DX                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure DisableScaling, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        mov     dx,config_wPortAddr
        mov     al,AW_MODE_CNTL         ;Acquisition Mode Control Register
        out     dx,al
        inc     dx
        in      al,dx                   ;Read current value.
        and     al,11110011b            ;Disable X and Y scaling.
        out     dx,al
        dec     dx

        mov     al,AV_MODE_CNTL         ;Acquisition Video Mode Register.
        out     dx,al
        inc     dx
        in      al,dx
        and     al,11111011b            ;Turn off field acquistion mode.

        cmp     _wVersion,2             ;PCVIDEO II?
        jl      @F
        and     al,NOT 00000001b        ;Clear video acquisition status
        cmp     _fFrozen,1              ;Is image supposed to be frozen?
        jz      @F
        or      al,00000001b            ;Turn video acquistion bit on

@@:     out     dx,al
        ret
EndProc DisableScaling

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 SetDisplayWindow                                                     3
;3                                                                      3
;3 Set registers controlling the position and size of the video display 3
;3 window.                                                              3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,BX,CX,DX                                             3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure SetDisplayWindow, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   XX              equ bp+12
   YY              equ bp+10
   xSize           equ bp+8
   ySize           equ bp+6
   Enter           0,0


        mov     ax, ((SIZE MODE) * NO_VIDEO_MODES)
        add     ax,offset config_aMode
        mov     si,ax

        mov     bx,[XX]
        or      bx,bx
        jge     @F
        xor     bx,bx                   ;Clip negative number to 0.
@@:     add     bx,[si].DispWinSkewX    ;Compensate for error offset.

        mov     cx,[YY]
        or      cx,cx
        jge     @F
        xor     cx,cx                   ;Clip negative number to 0.
@@:     add     cx,[si].DispWinSkewY    ;Compensate for error offset.

        mov     dx,config_wPortAddr
        mov     al,DW_X_START_LO        ;Display X Start Low Register
        mov     ah,bl
        out     dx,ax

        inc     al                      ;Display X Start High Register
        .errnz  (DW_X_START_HI - DW_X_START_LO -1)
        mov     ah,bh
        out     dx,ax

        inc     al                      ;Display Y Start Low Register
        .errnz  (DW_Y_START_LO - DW_X_START_HI -1)
        mov     ah,cl
        out     dx,ax

        inc     al                      ;Display Y Start High Register
        .errnz  (DW_Y_START_HI - DW_Y_START_LO -1)
        mov     ah,ch
        out     dx,ax

        mov     bx,[XX]
        add     bx,[xSize]              ;Display X End position
        dec     bx
        add     bx,[si].DispWinSkewX    ;Compensate for error offset.

        mov     cx,[YY]
        add     cx,[ySize]              ;Display Y End position
        dec     cx
        add     cx,[si].DispWinSkewY    ;Compensate for error offset.

        inc     al                      ;Display X End Low Register
        .errnz  (DW_X_END_LO - DW_Y_START_HI -1)
        mov     ah,bl
        out     dx,ax

        inc     al                      ;Display X End High Register
        .errnz  (DW_X_END_HI - DW_X_END_LO -1)
        mov     ah,bh
        out     dx,ax

        inc     al                      ;Display Y End Low Register
        .errnz  (DW_Y_END_LO - DW_X_END_HI -1)
        mov     ah,cl
        out     dx,ax

        inc     al                      ;Display Y End High Register
        .errnz  (DW_Y_END_HI - DW_Y_END_LO -1)
        mov     ah,ch
        out     dx,ax
        leave
        ret     8
EndProc SetDisplayWindow

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 SetDisplayPosition                                                   3
;3                                                                      3
;3 Set the start position in the capture buffer to begin reading video  3
;3 data.                                                                3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,BX,DX                                                3
;3                                                                      3
;3 Video data is read starting at the postion specified here after the  3
;3 X or Y blanking signal becomes inactive.  Video is not displayed     3
;3 though, until some number of pixel clocks has passed.  This number   3
;3 is determined by the values programmed into the display window       3
;3 registers.  For example, in order to begin displaying at X=100 video 3
;3 captured at X=0, the display position X value should be made -100.   3
;3 After 100 pixel clocks the X address counter will wrap around to X=0 3
;3 in the capture buffer and video will be displayed for data at this   3
;3 X location.                                                          3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure SetDisplayPosition, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   XX              equ bp+8
   YY              equ bp+6
   Enter           0,0

        mov     ax, ((SIZE MODE) * NO_VIDEO_MODES)
        add     ax,offset config_aMode
        mov     si,ax

        mov     ax,[XX]
        neg     ax
        mov     cl,_bHZoomFactor
        add     cl,_bHZoomAdjust
        mov     bl,cl
        xor     bh,bh
        add     bx,bx
        inc     cl                      ;Two bytes per pixel
        sar     ax,cl                   ;Adjust for horizontal zoom.
        sub     ax,[si].DispAddrSkewX[bx]
        cmp     _wBoardType,BT_RGB16
        je      @F
        cmp     _wBoardType,BT_RGB24
        je      @F
        and     ax,01feh                ;Make value even and mask unused bits.
@@:     mov     bl,ah
        mov     ah,al
        and     bl,1                    ;Save high bit of X.
        mov     dx,config_wPortAddr
        mov     al,DW_X_PANNING_LO      ;Display X Panning Low Register
        out     dx,ax
        mov     dl,bl

        mov     ax,[YY]
        neg     ax
        mov     cl,_bVZoomFactor
        add     cl,_bVZoomAdjust
        mov     bl,cl
        xor     bh,bh
        add     bx,bx
        sar     ax,cl                   ;Adjust for vertical zoom.
        sub     ax,[si].DispAddrSkewY[bx]
        xchg    ah,al
        shl     al,4                    ;2 MSBs of Y.
        and     al,30h
        mov     bl,dl
        or      bl,al                   ;2 MSBs of Y is D4, MSB of X is D0
        mov     dx,config_wPortAddr
        mov     al,DW_Y_PANNING_LO      ;Display Y Panning Low Register
        out     dx,ax

        mov     ah,bl
        mov     dx,config_wPortAddr
        mov     al,DW_PANNING_HI        ;Display Panning High Register
        out     dx,ax
        leave
        ret     4
EndProc SetDisplayPosition

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 SetCaptureAddress                                                    3
;3                                                                      3
;3 Set the start address in the video buffer to store captured video.   3
;3 This is also called the acquistion buffer start address.             3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,BX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure SetCaptureAddress, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   XX              equ bp+8
   YY              equ bp+6
   Enter           0,0


        mov     ax,[XX]
        shl     ax,1                    ;Multiply X by 2. (2 bytes/pixel)
        cmp     _wBoardType,BT_RGB24
        je      @F
        shl     ax,1                    ;Multiply X by 2 again. (4 bytes/pixel)

@@:     mov     bx,ax
        xchg    ah,al
        and     ah,0f8h                 ;Address must be on 4 pixel boundary.
        mov     dx,config_wPortAddr
        mov     al,AB_ADDR_LO           ;Program low byte of capture address.
        out     dx,ax

        inc     al                      ;Program middle byte.
        .errnz  (AB_ADDR_MI-AB_ADDR_LO-1)

        mov     ah,bh                   ;D11-D9 of X
        and     ah,07h                  ;Mask high bits.
        mov     bx,[YY]
        shl     bx,2                    ;Shift Y to start at bit 3.
        or      ah,bl                   ;Or in Y bits D4-D0.
        out     dx,ax

        inc     al                      ;Program high byte.
        .errnz  (AB_ADDR_HI-AB_ADDR_MI-1)
        mov     ah,bh                   ;Bits D9-D5
        out     dx,ax
        leave
        ret     4
EndProc SetCaptureAddress

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetAcquisitionWindow                                             3
;3                                                                      3
;3 External entry point to set the acquisition window.                  3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       None                                                    3
;3 Modifies:    AX,BX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetAcquisitionWindow, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
;;,<AX,BX,DX>
   ;*********************************************
   ; Parameters passed in on the stack
   X1              equ bp+6
   Y1              equ bp+8
   X2              equ bp+10
   Y2              equ bp+12
   Enter           0,0


        push    [X1]
        push    [Y1]
        push    [X2]
        push    [Y2]
        call    far ptr SetAcquisitionWindow
        leave
        ret     8
EndProc PCV_SetAcquisitionWindow

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 SetAcquisitionWindow                                                 3
;3                                                                      3
;3 Set the acquisition window.                                          3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,BX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure   SetAcquisitionWindow, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   X1              equ bp+12
   Y1              equ bp+10
   X2              equ bp+8
   Y2              equ bp+6
   Enter           0,0

        ; OPPS Y2,X2 and end points not width and Height
        mov     bx,[X1]
        add     [X2],bx
        mov     bx,[Y1]
        add     [Y2],bx

        mov     dx,config_wPortAddr
        mov     bx,[X1]
        and     bx,0FFFCh
        mov     al,AW_X_START_LO
        mov     ah,bl
        out     dx,ax                   ;X start low byte
        inc     al
        .errnz  (AW_X_START_HI-AW_X_START_LO-1)
        mov     ah,bh
        out     dx,ax                   ;X start high byte

        mov     bx,[Y1]
        mov     al,AW_Y_START_LO
        mov     ah,bl
        out     dx,ax                   ;Y start low byte
        inc     al
        .errnz  (AW_Y_START_HI-AW_Y_START_LO-1)
        mov     ah,bh
        out     dx,ax                   ;Y start high byte

        mov     bx,[X2]
        mov     al,AW_X_END_LO
        mov     ah,bl
        out     dx,ax                   ;X end low byte
        inc     al
        .errnz  (AW_X_END_HI-AW_X_END_LO-1)
        mov     ah,bh
        out     dx,ax                   ;X end high byte

        mov     bx,[Y2]
        mov     al,AW_Y_END_LO
        mov     ah,bl
        out     dx,ax                   ;Y end low byte
        inc     al
        .errnz  (AW_Y_END_HI-AW_Y_END_LO-1)
        mov     ah,bh
        out     dx,ax                   ;Y end high byte

saw_set_video_xy:
        mov     ax,[X2]
        sub     ax,[X1]
        inc     ax
        mov     _wVideoWidth,ax

        mov     ax,[Y2]
        sub     ax,[Y1]
        inc     ax
        mov     _wVideoHeight,ax
        leave
        ret     8
EndProc SetAcquisitionWindow

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 FreezeVideo                                                          3
;3                                                                      3
;3 Disable video acquisition.  Wait until video is frozen before        3
;3 returning.  Synchronize to video retrace signal if available.        3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,DX                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure FreezeVideo, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        cmp     _wVersion,1             ;Able to detect retrace?
        jl      @F                      ;No, go on.
        call    far ptr WaitVideoVerticalRetraceStart
        call    far ptr WaitToAcquireField ;Wait for one field to be acquired.
@@:     call    far ptr FreezeVideoUnsynchronized
        ret
EndProc FreezeVideo
;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 FreezeVideoUnsynchronized                                            3
;3                                                                      3
;3 Disable video acquisition.  Wait until video is frozen before        3
;3 returning.                                                           3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,DX                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure FreezeVideoUnsynchronized, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        push    cx                      ;Save CX.
        xor     cx,cx                   ;Limit number of tries.

fvideo_wait:
        mov     dx,config_wPortAddr
        mov     al,AV_MODE_CNTL         ;Acquisition Mode Control Register
        out     dx,al
        inc     dx
        in      al,dx                   ;Is video frozen?
        mov     ah,al                   ;Save what we read.
        and     al,NOT 1                ;Clear lower bit.
        out     dx,al
        test    ah,1
        loopnz  fvideo_wait             ;Wait until video is frozen

        ;For PCVIDEO II the status bit may not reflect the truth
        ;but if we delay frame buffer access for 3 fields time the
        ;acquistion should have been stopped by then.
        cmp     _wVersion,2             ;PCVIDEO II?
        jl      fvideo_exit             ;No, go on.
        mov     cx,3
@@:     push    cx
        call    far ptr WaitVideoVerticalRetraceStart
        call    far ptr WaitToAcquireField ;Wait for one field to be acquired.
        pop     cx
        loop    @B

fvideo_exit:
        pop     cx                      ;Restore CX.
        ret
EndProc FreezeVideoUnsynchronized

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 UnFreezeVideo                                                        3
;3                                                                      3
;3 Enable video acquisition.                                            3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    AX,DX                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure UnFreezeVideo, FAR
        mov     dx,config_wPortAddr
        mov     al,AV_MODE_CNTL         ;Acquisition Mode Control Register
        out     dx,al
        inc     dx
        in      al,dx
        or      al,1                    ;Set low bit.
        out     dx,al
        ret
EndProc UnFreezeVideo

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 HorizontalZoom                                                       3
;3                                                                      3
;3 Set horizontal zoom factor.                                          3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       AH = Zoom factor (0=1x, 1=2x, 2=4x, 3=8x)               3
;3 Modifies:    AX,BX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure HorizontalZoom, FAR
        mov     dx,config_wPortAddr
        mov     al,DW_WINDOW_ZOOM
        out     dx,al
        inc     dx
        in      al,dx
        and     al,0FCh
        or      al,ah
        out     dx,al                   ;Set horizontal zoom factor.

;        mov     bx,word ptr _fpfncXzoom
;        or      bx,word ptr _fpfncXzoom+2 ;Do we need to run platform dependent
;                                        ;xzoom routine?
;        jz      @F                      ;No
;        push    ax
;        call    dword ptr _fpfncXzoom

@@:
        mov     bx, ((SIZE MODE) * NO_VIDEO_MODES)
        add     bx,offset config_aMode
        mov     si,bx
        mov     dx,config_wPortAddr
        mov     bl,ah
        xor     bh,bh
        add     bx,bx
        mov     ax,[si].ShiftClkStart[bx]
        mov     ah,SHIFT_CLK_START
        xchg    al,ah
        out     dx,ax                   ;Set the shift clock start position.
        ret
EndProc HorizontalZoom


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 VerticalZoom                                                         3
;3                                                                      3
;3 Set vertical zoom factor.                                            3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       AH = Zoom factor (0=1x, 1=2x, 2=4x, 3=8x)               3
;3 Modifies:    AX,DX                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure VerticalZoom, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
        mov     dx,config_wPortAddr
        mov     al,DW_WINDOW_ZOOM
        out     dx,al
        inc     dx
        in      al,dx
        and     al,0F3h
        shl     ah,2
        or      al,ah
        out     dx,al                   ;Set vertical zoom factor.
        ret
EndProc VerticalZoom


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 ComputeVideoAddress                                                  3
;3                                                                      3
;3 Computes the physical address of the image.                          3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       YY = Y start                                            3
;3              XX = X Start                                            3
;3 Modifies:    AX, FLAGS                                               3
;3 Exit:        EAX = Offset to start of Video in Video Buffer          3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure ComputeVideoAddress, FAR
        XX         equ bp+8
        YY         equ bp+6

        enter   0,0
        push    ebx
        movzx   eax,[YY]
        movzx   ebx,[XX]
        shl     eax,12                  ; 2048 bytes per Y for YUV and RGB16
        shl     ebx,1                   ; 2 bytes Per X    for YUV and RGB16
        cmp     _wBoardType,BT_RGB24    ;RGB 24 bit Board.
        jne     @F
        shl     ebx,1                   ; 4 bytes per X for RGB 24
        shl     eax,1                   ;4096 bytes per Y for RGB24
@@:
        add     eax,ebx
        pop     ebx
        Leave
        ret     4
EndProc ComputeVideoAddress


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 ComputeLoopParameters                                                3
;3                                                                      3
;3 Computes the scan increment and loop count.                          3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       Xext  = Width of the image or X Extent                  3
;3 Modifies:    AX,BX,FLAGS                                             3
;3 Exit:        EAX = Loop count                                        3
;3              EBX = Scan Increment                                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure ComputeLoopParameters, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   rectWidth       equ bp+6

        enter   0,0

        movzx   ebx,word ptr [rectWidth]
        mov     eax,ebx
        shr     ax,2                    ;Inner loop count = width/4
        cmp     _wBoardType,BT_RGB24    ;RGB Board support high resolution mode.
        je      @F

        shl     bx,1                    ;BX = 2 * width
                                        ;2 bytes per pixel
        neg     bx
        add     bx,FRAME_BUF_WIDTH*2    ;Scan increment = 2048-(2*width)
                                        ;Scan line is 1024 pixels and
                                        ;each pixel takes 2 bytes
        jmp     clpaddr_exit

@@:
        shl     bx,2                    ;BX = 4 * width
                                        ;4 bytes per pixel
        neg     bx
        add     bx,FRAME_BUF_WIDTH*4    ;Scan increment = 4096-(4*width)
                                        ;Scan line is 1024 pixels and
                                        ;each pixel takes 4 bytes
clpaddr_exit:
        leave
        ret     2
EndProc ComputeLoopParameters


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_SetColor                                                         3
;3                                                                      3
;3 Set the colors adjustments for the cards (Brightness, Hue, Contrast..3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:                                                                3
;3 Note:        RGB board support is NOT implemented!!!                 3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_SetColor, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   wColorValue     equ bp+6
   iColor          equ bp+8
   Enter           0,0

        push    [icolor]                ;Thing to adjust
        push    [WcolorValue]           ;Value to adjust to
        call    far ptr SetColor
        leave
        ret     4
EndProc PCV_SetColor


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 SetColor                                                             3
;3                                                                      3
;3 Set the Color Key value or transparent Color                         3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:                                                                3
;3 Note:        RGB board support not implemented!!!                    3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure SetColor, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   wColorValue     equ bp+6
   iColor          equ bp+8
   Enter           0,0

        cmp     _wBoardType,BT_RGB16    ;RGB Board support high resolution mode.
        je      setcolor_exit
        cmp     _wBoardType,BT_RGB24    ;RGB Board support high resolution mode.
        je      setcolor_exit

        cmp    word ptr[iColor],HUE
        jne    Not_Hue
        push    ADRDMSD                 ;Digital multistandard decoder
        push    HUE_CONTROL             ;index
        push    [wColorValue]           ;data
        call    far ptr wr_i2c
        jmp     setcolor_exit

Not_Hue:
        and    word ptr[iColor],7Fh     ; MSB off for White Balance
        push    ADR4680                 ; 
        push    [iColor]                ;index
        push    [wColorValue]           ;data
        call    far ptr wr_i2c

setcolor_exit:
        leave
        ret     4
EndProc SetColor

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 RegWrit                                                              3
;3                                                                      3
;* Select the Phillips chips for write                                  *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:                                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure RegWrit, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   id              equ bp+6
   value           equ bp+8
   enter 0,0

   push   ax
   push   bx
   push   dx

   ; Which id is it
   cmp    word ptr [id],I2C_SCL
   je     rw_I2C_SCL
   cmp    word ptr [id],I2C_SDA
   je     rw_I2C_SDA
   jmp    regwrit_exit

rw_I2C_SCL:
   mov    dx,config_wPortAddr     ;Set PC Video port address.
   mov    al,18h
   out    dx,al                   ;Address to read
   inc    dx
   in     al,dx                   ;Read
   and    al,0FEh
   mov    bx,[value]
   and    bx,1
   or     al,bl
   out    dx,al                   ; Set
   jmp    regwrit_exit

rw_I2C_SDA:
   mov    dx,config_wPortAddr     ;Set PC Video port address.
   mov    al,18h
   out    dx,al                   ;Address to read
   inc    dx
   in     al,dx                   ;Read
   and    al,0FDh
   mov    bx,[value]
   and    bx,1
   shl    bx,1
   or     al,bl
   out    dx,al                   ; Set
   jmp    regwrit_exit

regwrit_exit:
   pop    dx
   pop    bx
   pop    ax
   leave
   ret    4
EndProc RegWrit

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 RegRead                                                              3
;3                                                                      3
;* Select the Phillips chips for Read                                   *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:        AL = Value Read                                         3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure RegRead, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   id              equ bp+6
   enter  0,0

   push   dx

   ; Which id is it
   cmp    word ptr [id],I2C_SCL
   je     rr_I2C_SCL
   cmp    word ptr [id],I2C_SDA
   je     rr_I2C_SDA
   jmp    regread_exit

rr_I2C_SCL:
   mov    dx,config_wPortAddr     ;Set PC Video port address.
   mov    al,18h
   out    dx,al                   ;Address to read
   inc    dx
   in     al,dx                   ;Read
   and    al,1

rr_I2C_SDA:
   mov    dx,config_wPortAddr     ;Set PC Video port address.
   mov    al,18h
   out    dx,al                   ;Address to read
   inc    dx
   in     al,dx                   ;Read
   shr    al,2
   and    al,1
   jmp    regread_exit

regread_exit:
   pop    dx
   leave
   ret    2
EndProc RegRead

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 REVERSE                                                              3
;3                                                                      3
;* Reverse the bit order so that bits are sent MSB first                *
;* Returns: Reversed bits                                               *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS, AX                                               3
;3 Exit:        AX = Reversed Value                                     3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure Reverse, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   value            equ bp+6
   Enter  0,0

   push   bx
   push   cx
   push   dx

   mov    cx,16
   mov    dx,[value]
   mov    ax,0

reverse_next_bit:
   mov    bx,dx
   and    bx,1
   or     ax,bx
   shl    eax,1
   shr    dx,1
   loop   reverse_next_bit
   shr    eax,1

reverse_exit:
   pop    dx
   pop    cx
   pop    bx
   leave
   ret    2
EndProc Reverse

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 I2C_ACK                                                              3
;3                                                                      3
;*  Get an acknowledge back from a slave device                         *
;*  Returns: value of ack bit                                           *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS,  AX                                              3
;3 Exit:         AL  = Ack Bit                                          3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure I2C_ACK, FAR


   push   1
   push   I2C_SDA
   call   far ptr RegWrit


   push   HICLK
   push   I2C_SCL
   call   far ptr RegWrit

   push   I2C_SDA    ; **** changed from SCL  8/17/93 ...MR. YOU
   call   far ptr RegRead     ;Returns ax = Ack Bit

   push   LOCLK
   push   I2C_SCL
   call   far ptr RegWrit

i2c_ack_exit:
   ret
EndProc I2C_ACK

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 I2C_START                                                            3
;3                                                                      3
;*  Send a start protocol out to the slaves                             *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:                                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure I2C_START,FAR

   push   1
   push   I2C_SDA
   call   far ptr RegWrit

   push   HICLK
   push   I2C_SCL
   call   far ptr RegWrit

   push   0
   push   I2C_SDA
   call   far ptr RegWrit

   push   LOCLK
   push   I2C_SCL
   call   far ptr RegWrit

i2c_start_exit:
   ret
EndProc I2C_START

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 I2C_STOP                                                             3
;3                                                                      3
;*  Send stop protocol out to i2c slave. Stop protocol ==               *
;3  positive going transition of data line while clock line high        3
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:                                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure I2C_STOP,FAR

   push   0
   push   I2C_SDA
   call   far ptr RegWrit

   push   HICLK
   push   I2C_SCL
   call   far ptr RegWrit

   push   1
   push   I2C_SDA
   call   far ptr RegWrit

i2c_stop_exit:
   ret
EndProc I2C_STOP

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 I2C_WDATA                                                            3
;3                                                                      3
;* I2C Data Write                                                       *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:                                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure I2C_WDATA, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   value           equ bp+8
   id              equ bp+6
   enter  0,0

   push   ax
   push   bx
   push   cx

   mov    ax,[value]
   push   ax
   call   far ptr Reverse             ; Return Data reversed in AX
   shr    ax,8                        ; MSB goes out first
   mov    bx,ax

   cmp    word ptr[id],I2C_ADR
   jne    i2c_wdata_send
   call   far ptr i2c_start             ; send start protocol

i2c_wdata_send:                         ; Send out data Stream
   mov    cx,8                          ; Bit to send out

i2c_wdata_send_loop:                    ; Send out bit in the Stream
   push   bx                            ; Data
   push   I2C_SDA
   call   far ptr regwrit

   push   HICLK
   push   I2C_SCL
   call   far ptr regwrit

   push   LOCLK
   push   I2C_SCL
   call   far ptr regwrit

   shr    bx,1                         ; Shift to next bit in data
   loop   i2c_wdata_send_loop

   call   far ptr i2c_ack               ;wait for acknowledge
                                        ;ACks don't work
                                        ;so throw data away
i2c_wdata_exit:
   pop    cx
   pop    bx
   pop    ax
   leave
   ret    4
EndProc I2C_WDATA


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 I2C_RDATA                                                            3
;3                                                                      3
;* I2C Data Read                                                        *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:        AL = Value Read                                         3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure I2C_RDATA, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   enter  0,0

   push   bx
   push   cx
   push   dx

                                        ; Read in data 1 bit at a time
   mov    cx,8                          ; Bits to read in
   mov    dx,0                          ; Bits read

i2c_rdata_loop:                         ; Send out bit in the Stream

   push   HICLK
   push   I2C_SCL
   call   far ptr regwrit

   push   I2C_SDA
   call   far ptr regread
   shl    dl,1
   or     dl,al                        ; Build up byte of bits read

   push   LOCLK
   push   I2C_SCL
   call   far ptr regwrit

   loop   i2c_rdata_loop
   call   far ptr i2c_ack               ;wait for acknowledge
                                        ;ACks don't work
                                        ;so throw data away

   mov    al,dl                         ; Byte of Bits read

   pop    dx
   pop    cx
   pop    bx
   leave
   ret
EndProc I2C_RDATA



;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 rd_I2C                                                               3
;3                                                                      3
;*  read data from I2C                                                  *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       Address to read                                         3
;3 Modifies:    FLAGS                                                   3
;3 Exit:        AL = Data read                                          3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure rd_I2C, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   Addr            equ bp+6
   SubAddr         equ bp+8
   enter  0,0

   mov    ax,[Addr]
   push   ax
   push   I2C_ADR
   call   far ptr i2c_wdata     ; Write Address for device

   mov    ax,[SubAddr]
   push   ax
   push   I2C_SUBADR
   call   far ptr i2c_wdata     ; Write Subadddress for device

   mov    ax,[Addr]
   or     ax,1
   push   ax
   push   I2C_ADR
   call   far ptr i2c_wdata     ; Write Address agian

   call   far ptr i2c_rdata     ; Read in Data value

   push   ax                    ; Save Data Value read
;  call   far ptr i2c_Ack

   call   far ptr i2c_stop

   pop    ax                    ; Resotre I2C value Read

rd_i2c_exit:
   leave
   ret    4
EndProc rd_I2C

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 wr_I2C                                                               3
;3                                                                      3
;*  Write data to I2Cl                                                  *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:                                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure wr_I2C, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   value           equ bp+6
   subaddr         equ bp+8
   addr            equ bp+10
   enter  0,0

   mov    ax,[addr]
   push   ax
   push   I2C_ADR
   call   far ptr i2c_wdata

   mov    ax,[subaddr]
   push   ax
   push   I2C_SUBADR
   call   far ptr i2c_wdata

   mov    ax,[value]
   push   ax
   push   I2C_DAT
   call   far ptr i2c_wdata

   call   far ptr i2c_stop

wr_i2c_exit:
   leave
   ret    6
EndProc wr_I2C


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 wr_I2C_t                                                             3
;3                                                                      3
;*  Write data to I2C in Telegram fashion                               *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       None                                                    3
;3 Modifies:    FLAGS                                                   3
;3 Exit:                                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure wr_I2C_t, FAR
   ;*********************************************
   ; Parameters passed in on the stack
   data_Sel        equ bp+6
   data_off        equ bp+8
   number          equ bp+10
   subaddr         equ bp+12
   addr            equ bp+14
   enter  0,0

   mov    ax,[addr]
   push   ax
   push   I2C_ADR
   call   far ptr i2c_wdata

   mov    ax,[subaddr]
   push   ax
   push   I2C_SUBADR
   call   far ptr i2c_wdata

   mov    cx,[number]
   push   es
   push   si
   mov    es,[data_sel]
   mov    si,[data_off]
   mov    cx,[number]
next_t_data:

   push   cx
   push   es
   push   si

   mov    al,es:[si]
   mov    ah,0
   push   ax
   push   I2C_DAT
   call   far ptr i2c_wdata

;   call   far ptr i2c_ack               ;wait for acknowledge
                                         ; Done in i2c_wdata
   pop    si
   pop    es
   pop    cx
   inc    si
   loop   next_t_data

   pop    si
   pop    es

   call   far ptr i2c_stop

wr_i2c_t_exit:
   leave
   ret    10
EndProc wr_I2C_t


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 rd_I2C_t                                                             3
;3                                                                      3
;*  read data from I2C in telegram format                               *
;3                                                                      3
;3 Exported:    No                                                      3
;3 Entry:       Address to read                                         3
;3 Modifies:    FLAGS                                                   3
;3 Exit:        AL = Data read                                          3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure rd_I2C_t,FAR
   ;*********************************************
   ; Parameters passed in on the stack
   Addr            equ bp+6
   SubAddr         equ bp+8
   enter  0,0

   mov    ax,[Addr]
   push   ax
   push   I2C_ADR
   call   far ptr i2c_wdata     ; Write Address for device

   mov    ax,[Addr]
   or     ax,1
   push   ax
   push   I2C_ADR
   call   far ptr i2c_wdata     ; Write Address agian

   call   far ptr i2c_rdata     ; Read in Data value

   push   ax                    ; Save Data Value read
;  call   far ptr i2c_Ack

   call   far ptr i2c_stop

   pop    ax                    ; Resotre I2C value Read

rd_i2c_t_exit:
   leave
   ret    4
EndProc rd_I2C_t

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 PCV_ReadVideoRect                                                    3
;3                                                                      3
;3 Clears the specified rectangular area of the video buffer.           3
;3                                                                      3
;3 Exported:    Yes                                                     3
;3 Entry:       XX,YY           Top left of the rectangular area        3
;3              xExt,yExt       Size of the rectangular area            3
;3              DestBuffer      Destination Buffer (linear address)     3
;3 Note:        xExt            must be a multiple of 4                 3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
Procedure PCV_ReadVideoRect, FAR
         ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters passed in on the stack
   XX              equ bp+6            ;X position in video buffer
   YY              equ bp+8            ;Y position in video buffer
   xExt            equ bp+10           ;Width of the image
   yExt            equ bp+12           ;Height of the image
   Dest            equ bp+14           ;Destination Buffer for the image
   Source          equ bp+18           ;Source Buffer for the image

   ;*********************************************
   ; Local Variables on stack
     c4bcopy     equ bp-02
     enter       20,0

        test    _fHighRes, 1
        jz      @F
        mov     ax,[XX]
        shr     ax, 1
        mov     [XX], ax
        mov     ax,[xExt]
        shr     ax, 1
        mov     [xExt], ax
@@:
        cmp     _fFrozen,1
        je      @F
        call    far ptr FreezeVideo     ;Input acquisition must be off to access buffer.

@@:     mov     ax,_wCapBufWidth
        cmp     [xExt],ax
        jle     @F
        mov     [xExt],ax
@@:     mov     ax,_wCapBufHeight
        cmp     [yExt],ax
        jle     @F
        mov     [yExt],ax

@@:
        push    [XX]
        push    [YY]
        call    far ptr ComputeVideoAddress; eax <- video buffer offset
        add     eax,[SOURCE]
        mov     esi,eax

        push    [xExt]
        call    far ptr ComputeLoopParameters   ;BX=scan increment, AX=inner loop count

        shl     ax,1                    ;Groups of 4 PELs to copies * 2 =
        mov     [c4bcopy],ax            ;Number of 4 Bytes copies
        push    fs                      ;Load ES with FS
        pop     es                      ;Load ES with FS
        mov     dx,[yExt]               ;Number of scanlines
        mov     edi,[DEST]
        xor     ecx,ecx

rvb_read_scan:
        mov     cx,[c4bcopy]            ;Number of dwords to read
        REP     MOVS dword ptr es:[edi],dword ptr fs:[esi] ; copy the scanline (4 bytes at a time)
        add     esi,ebx                 ;Next scan in video buffer
        dec     dx                      ;Decrement count of scan lines
        jnz     rvb_read_scan


rvb_exit:
        cmp     _fFrozen, 1             ;Should Video be Frozen
        je     @F
        call    far ptr UnFreezeVideo
@@:     mov     ax,1                    ;Return success.
        leave
        ret     16
EndProc PCV_ReadVideoRect


_TEXT   ENDS
END

