;*DDK*************************************************************************/
;
; COPYRIGHT (C) Chips and Technologies, Inc. 1991, 1992
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; PCV2.INC
;************************************************************************
;* Program:      PCVIDEO.DLL                                            *
;* Module:       PCVIDEO.INC                                            *
;* Description:  Constant and structure definitions for PC Video        *
;*               hardware interface routines.                           *
;* Version:      1.7                                                    *
;************************************************************************


; System metrics
SM_VIDEOWIDTH   equ     0
SM_VIDEOHEIGHT  equ     1
SM_BOARDTYPE    equ     2
SM_VERSION      equ     3
SM_INTERLACE    equ     4
SM_REPLICATE    equ     5
SM_IMAGEWIDTH   equ     6
SM_IMAGEHEIGHT  equ     7
SM_IMAGETYPE    equ     8

; Mode flags
MF_PACKED       equ     40h
MF_PLANAR       equ     00h
MF_INTERLACED   equ     02h
MF_PLUSPOLARITY equ     08h

; Video board types
BT_YUV411       equ     0
BT_RGB16        equ     1
BT_RGB24        equ     2
BT_YUV211       equ     3
BT_YUV422       equ     4

; Bitmap types
BM_DIB24        equ     0               ;Windows DIB 24 bpp true color
BM_DIB8P        equ     1               ;Windows DIB 8 bpp palettized
BM_DIB8G        equ     2               ;Windows DIB 8 bpp gray-scale
BM_DIB4D        equ     3               ;Windows DIB 4 bpp dithered
BM_TRG32        equ     4               ;Targa 32 bpp true color
BM_TRG24        equ     5               ;Targa 24 bpp true color
BM_TRG16        equ     6               ;Targa 16 bpp true color
BM_YUV411       equ     7               ;IBM MMotion format YUV
BM_TIFF8P       equ     8               ;TIFF 8 bit palettized
BM_TIFF8G       equ     9               ;TIFF 8 bit gray-scale
BM_TIFF4D       equ     10              ;TIFF 4 bit dithered
BM_PCX8P        equ     11              ;PCX 8 bit palettized
BM_PCX8G        equ     12              ;PCX 8 bit gray-scale
BM_PCX4D        equ     13              ;PCX 4 bit dithered
BM_GIF8P        equ     14              ;GIF 8 bit palettized
BM_GIF8G        equ     15              ;GIF 8 bit gray-scale
BM_JPEG         equ     16              ;JPEG compressed 4:2:2 YUV

LOCLK           equ     0
HICLK           equ     1
ADR9051         equ     8AH             ;Digital multistandard decoder
ADR4680         equ     88H             ;Video control combination
ADR7192         equ     0E0H            ;Digital color space converter
ADR7191         equ     8AH             ;Square pixel digital multistandard
                                        ;decoder
ADR7186         equ     0B8H            ;Digital Video data scaler with
                                        ;embedded line memory.
ADRDMSD         equ     8AH             ;Digital multistandard decoder
HUE_CONTROL     equ     7
I2C_ADR         equ     0
I2C_SUBADR      equ     1
I2C_DAT         equ     2
I2C_SCL         equ     0
I2C_SDA         equ     1

; Color adjustments
BRIGHTNESS     equ   0
SATURATION     equ   1
CONTRAST       equ   2
HUE            equ   3
RED            equ   4
GREEN          equ   5
BLUE           equ   6

NO_COLOR_SETTINGS equ   8               ;Available color controls
NO_COLOR_CONTROLS equ   7               ;Actual number of color controls
NO_SKEW_FACTORS equ     7               ;Number of skew factors
NO_VIDEO_MODES  equ     16              ;Number of supported video modes
NO_PHIXEL_CHIPS equ     4               ;Number of Phixel chips supported

LUMA_BITMASK    equ     07H             ;Luminance Bitmask Register
CROMA_BITMASK   equ     08H             ;Chrominance Bitmask Register
INTERRUPT_POLL  equ     09H
VIDEO_VSYNC     equ     04H
VGA_VSYNC       equ     10H
VGA_HSYNC       equ     20H
PLL_DIVISOR_INDEX equ   13H
PLL_DIVISOR_DATA  equ   12H
PLL_DIVISOR_LO  equ     0
PLL_DIVISOR_HI  equ     1
I2C_BUS_CONTROL equ     18H
AV_MODE_CNTL    equ     20H             ;Acquisition video mode control reg
AW_MODE_CNTL    equ     21H             ;Acquisition window mode control reg
AW_X_START_LO   equ     22H
AW_X_START_HI   equ     23H
AW_Y_START_LO   equ     24H
AW_Y_START_HI   equ     25H
AW_X_END_LO     equ     26H
AW_X_END_HI     equ     27H
AW_Y_END_LO     equ     28H
AW_Y_END_HI     equ     29H
AB_ADDR_LO      equ     2AH             ;Acquisition write address in frame buffer (low)
AB_ADDR_MI      equ     2BH             ;Acquisition write address in frame buffer (middle)
AB_ADDR_HI      equ     2CH             ;Acquisition write address in frame buffer (high)
AW_X_SCALING    equ     2DH             ;Input horizontal compression
AW_Y_SCALING    equ     2EH             ;Input vertical compression
AW_Y_SCALING_ODD equ    2FH             ;Input vertical compression for odd lines
SCALE_CONTROL   equ     38H             ;Scale Control register
DW_MODE_CNTL    equ     40H             ;Display window mode control reg
DW_X_START_LO   equ     41H             ;Display window X-Start low reg
DW_X_START_HI   equ     42H
DW_Y_START_LO   equ     43H
DW_Y_START_HI   equ     44H
DW_X_END_LO     equ     45H             ;Display window X-End low reg
DW_X_END_HI     equ     46H
DW_Y_END_LO     equ     47H
DW_Y_END_HI     equ     48H
DW_X_PANNING_LO equ     49H             ;Panning registers
DW_Y_PANNING_LO equ     4AH
DW_PANNING_HI   equ     4BH
SHIFT_CLK_START equ     4CH             ;Shift Clock Start Position
DW_WINDOW_ZOOM  equ     4DH             ;Display window zoom register
TRANS_COLOR     equ     4EH             ;Transparency color register
INTERLACE_CNTL  equ     50H             ;Display interlace control
INTERLACE_ON    equ     01H             ;Enable interlaced output
REPLICATE_ON    equ     08H             ;Field replication enabled.
NON_MULTIPLEXED equ     10H             ;Input is not multiplexed.

FRAME_BUF_WIDTH equ     1024            ;Acquisition buffer width is 1K pixels.
                                        ;Note: to get scan line size in bytes,
                                        ;for RGB 16 bit and YUV 411 board times
                                        ;this number by 2 (2 bytes per pixel);
                                        ;for RGB 24 bit board, times this number
                                        ;by 4 (4 bytes per pixel).
ID_457          equ     60h             ;Chip ID for 82C457.

; Configuration flags
CF_PAL          equ     0               ;Input format is PAL
CF_NTSC         equ     1               ;Input format is NTSC
CF_SECAM        equ     2               ;Input format is SECAM
CF_HASPLL       equ     4               ;Board has a phase-locked loop.
CF_REPLICATE    equ     REPLICATE_ON    ;Replicate feature is enabled.

;Acquisition Flags
PAL_SECAM       equ     0
NTSC            equ     1

;****************** this was causing MASM to TRAP
;LONG    struc
;lo      dw      ?
;hi      dw      ?
;LONG    ends

;FARPOINTER      struc
;off     dw      ?
;sel     dw      ?
;FARPOINTER      ends

REGENTRY struc
rIndex          db ?                    ;Register index
rData           db ?                    ;Register data
REGENTRY ends

PCVIDEOTBL struc
cPCVideoRegs    dw ?                    ;Count of registers
aPCVideoRegs    db 64 * SIZE REGENTRY dup (?)   ;Register index and data
PCVIDEOTBL ends

PHIXELCHIP struc
aChipId         db 10 dup(?)            ;I2C chip ID
wPhixelAddr     dw ?                    ;I2C address of chip
cPhixelRegs     dw ?                    ;Count of registers
aPhixelRegs     db 32 * SIZE REGENTRY dup (?)   ;Register index and data
PHIXELCHIP ends

PHIXELTBL struc
cPhixelChips    dw ?
aPhixelChips    db NO_PHIXEL_CHIPS * SIZE PHIXELCHIP dup (?)
PHIXELTBL ends

MODE            struc
DispWinSkewX    dw ?                    ;Offset to add to display window registers
DispWinSkewY    dw ?
DispAddrSkewX   dw 4 dup (?)            ;Offset to be added to display address
DispAddrSkewY   dw 4 dup (?)
ShiftClkStart   dw 4 dup (?)            ;Shift clock start position
PaletteSkew     dw ?                    ;2 MSBs of Display Window Control Reg.
VGAWidth        dw ?                    ;VGA resolution
VGAHeight       dw ?
PLLDivisor      dw ?                    ;Divisor for the PLL
fModeFlags      dw ?                    ;Miscellaneous flags
MODE            ends

CFGSTRUCT       struc
wPortAddr       dw ?
wVideoAddr      dw ?
wCfgFlags       dw ?
wVideoSource    dw ?
bColorSettings  db NO_COLOR_SETTINGS dup (?)
PCVideoTable    db SIZE PCVIDEOTBL dup (?)
PhixelTable     db SIZE PHIXELTBL  dup (?)
aMode           db SIZE MODE * (NO_VIDEO_MODES+1) dup (?)
wPALAcqWindow   dw 4 dup (?)
wNTSCAcqWindow  dw 4 dup (?)
aReserved       db 44 dup (?)
wBoardType      db ?
bVolume         db ?
bTunerType      db ?
bRFRegion       db ?
wChannel        dw ?
ulFinetune      dd ?
CFGSTRUCT       ends

ACQUISITIONRECT struc
aX1     dw      ?
aY1     dw      ?
aX2     dw      ?
aY2     dw      ?
ACQUISITIONRECT ends

;?PLM=1                                  ;Use Pascal calling convention
;
;ifdef DOSLIB
; ?WIN=0                                 ;No         epilogue/prologue
;else
; ?WIN=1                                 ;Use         epilogue/prologue
;endif
;
;ifdef DOSLIB
;GDTEntry struc                          ;Required to access extended memory.
;GDTEntry_Size   dw ?                    ;Segment size
;GDTEntry_Address db 3 dup (?)           ;24 bit start address
;GDTEntry_Access db ?                    ;Access flags
;GDTEntry_Reserved dw ?
;GDTEntry ends
;
;GDT     struc
;GDT_Dummy0      db 16 dup (?)
;GDT_Entry1      db SIZE GDTEntry dup (?)
;GDT_Entry2      db SIZE GDTEntry dup (?)
;GDT_Dummy1      db 16 dup (?)
;GDT     ends
;endif

; Macro for defining exported procedures.  DOS procedures are defined as
; FAR.         exported procedures are defined as FAR.

;ExportProc macro name, regs
;if ?WIN
;cProc name, <FAR,PUBLIC>, <regs>
;else
;cProc name, <FAR,PUBLIC>, <regs>
;endif
;endm

;externEP  macro procname
;if ?WIN
;externFP procname
;else
;externFP procname
;endif
;endm
