;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/


.386p

INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

;*********************************************
; Define the C calling macros
LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm
;*********************************************


include devsym.inc
include basemaca.inc
include basedef.inc
include pcv2.inc
include vidvci.inc

EXTRN   RD_I2C:FAR                   ; Read Data from I2C bus
EXTRN   reg3_4680:byte               ; 4680 reg 3 White Level
EXTRN   bBoardNMG:byte               ; NMG SVW Board Type
ADDR_EEPROM     equ     0A0H         ;Address of SupeVideo         EEPROM

DATA   SEGMENT  DWORD USE16 PUBLIC 'DATA'      ; changed from code to data
;       ASSUME   CS: FLAT, DS: DATA, SS: FLAT, ES: FLAT
        EXTRN   FlatSel:WORD
        EXTRN   selector1:WORD        ; Segment address for Cards RAM
        EXTRN   baseIO:WORD           ; Base I/O address of card
        EXTRN   Type_card:WORD        ; Type of PC Video Card

DATA   ENDS


_TEXT   SEGMENT  DWORD USE16 PUBLIC 'CODE'
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT




;-------------------------------------------------------------------------------
; Snoop around an try to detect which type of card is installed
;-------------------------------------------------------------------------------

Procedure CheckCardType,FAR
        ASSUME cs:_TEXT,ds:DATA,es:NOTHING,ss:NOTHING

       pushad

        ; If card Address is 2Axx it's a Video Blaster
        mov   dx,baseio
        cmp   dh,2Ah                ; Is this a Video Blaster
        je    VB_Card

        push  1dh                   ; Device Subaddress
        push  ADDR_EEPROM           ; Device Address (for EEPROM)
        call  far ptr rd_I2C

        cmp   al,52h                ; SuperVideo         card ID from EEPROM
        jne   VM_CARD

SVW_CARD:
        mov   type_card,1           ; card is a Super Video Windows

        ; Read Reference Brightness from the card
        push  1Ch                   ; Device Subaddress
        push  ADDR_EEPROM           ; Device Address (for EEPROM)
        call  far ptr rd_I2C
        mov   reg3_4680,al

        ; Read Board Type
        push  1h                  ; Device Subaddress
        push  ADDR_EEPROM         ; Device Address (for EEPROM)
        call  far ptr rd_I2C
        mov   bBoardNMG,al        ; Save Board Type

        ; Read Version
        push  2h                   ; Device Subaddress
        push  ADDR_EEPROM          ; Device Address (for EEPROM)
        call  far ptr rd_I2C

        ; Read Revsion
        push  3h                   ; Device Subaddress
        push  ADDR_EEPROM          ; Device Address (for EEPROM)
        call  far ptr rd_I2C

        ; Read Model
        push  4h                   ; Device Subaddress
        push  ADDR_EEPROM           ; Device Address (for EEPROM)
        call  far ptr rd_I2C

        ; Read Bus 1= MC or ISA
        push  5h                    ; Device Subaddress
        push  ADDR_EEPROM           ; Device Address (for EEPROM)
        call  far ptr rd_I2C
        cmp   ax,1                  ; 1 = MC
        jne   not_MC
        mov   bBoardNMG,5           ; Save Board Type = Micro Channel
not_MC:

        jmp   Type_Card_done

VM_CARD:
        mov   type_card,2           ; card is a Video Magic
        jmp   Type_Card_done
VB_Card:
        mov   type_card,0           ; card is a VideoBlaster
        jmp   Type_Card_done

Type_Card_done:

         popad
         ret
EndProc CheckCardType


_TEXT   ENDS
END
