/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Voyetra Technologies, 1990-1993                             */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*     Voyetra Technologies
*     5 Odell Plaza
*     Yonkers, NY 10701
*     Tel: 914-966-0600
*******************************************************************************
*
* vapi.h
*
******************************************************************************/

/******************** FUNCTION ERROR CODES *******************/

#define         V1E_NOPN        (-100)  /* VAPI not opened  */
#define         V1E_OPN         (-101)  /* VAPI already opened  */
#define         V1E_RXN         (-103)  /* Illegal Rx# */
#define         V1E_TXN         (-104)  /* Illegal Tx# */
#define         V1E_RXNOPN      (-105)  /* Rx not opened */
#define         V1E_TXNOPN      (-106)  /* Tx not opened */
#define         V1E_RXOPN       (-107)  /* Rx already opened */
#define         V1E_TXOPN       (-108)  /* Tx already opened */
#define         V1E_MIDI        (-109)  /* MIDI error */
#define         V1E_MFIFOEM     (-110)  /* MIDI fifo empty */
#define         V1E_MFIFOFL     (-111)  /* MIDI fifo full */
#define         V1E_TMNOPN      (-112)  /* Timer not opened */
#define         V1E_TMOPN       (-113)  /* Timer already opened */
#define         V1E_RESOL       (-114)  /* Illegal resolution */
#define         V1E_TMNSTRT     (-115)  /* Timer not started */
#define         V1E_TMSTRT      (-116)  /* Timer already started */
#define         V1E_IRQN        (-117)  /* Illegal IRQ# */
#define         V1E_TRAPN       (-118)  /* Illegal trap# */
#define         V1E_PROCNOPN    (-119)  /* IRQ procedure not opened */
#define         V1E_PTAOPN      (-120)  /* portA already opened (obsolete) */
#define         V1E_PTANOPN     (-121)  /* portA not opened (obsolete) */
#define         V1E_PTBOPN      (-128)  /* portB already opened */
#define         V1E_PTBNOPN     (-129)  /* portB not opened */
#define         V1E_PORTB       (-122)  /* portB error */
#define         V1E_PBFIFOEM    (-123)  /* portB fifo empty */
#define         V1E_SCBUSY      (-124)  /* SubCPU busy (obsolete) */
#define         V1E_SLDN        (-125)  /* illegal slider# (obsolete) */
#define         V1E_USBN        (-126)  /* illegal user bit group# (obsolete) */
#define         V1E_SCNACK      (-127)  /* SubCPU do not ack cmnd - obsolete */


/******************** MISC FLAGS AND CONSTANTS ******************/


        /* Low level irq event defines (used by v1_trap) */
#define         VN_Tx0          0x00
#define         VN_Tx1          0x01
#define         VN_Tx2          0x02
#define         VN_Tx3          0x03
#define         VN_Tx4          0x04
#define         VN_Tx5          0x05
#define         VN_Tx6          0x06
#define         VN_Tx7          0x07
#define         VN_Rx0          0x08
#define         VN_Rx1          0x09
#define         VN_TIMERA       0x0A
#define         VN_TIMERB       0x0B
#define         VN_PORTA_I      0x0C
#define         VN_PORTA_O      0x0D
#define         VN_PORTB        0x0E
#define         VN_MAX          VN_PORTB

        /* Status word bits (used with v1_status) */
#define         VS_Tx0          0x0001
#define         VS_Tx1          0x0002
#define         VS_Tx2          0x0004
#define         VS_Tx3          0x0008
#define         VS_Tx4          0x0010
#define         VS_Tx5          0x0020
#define         VS_Tx6          0x0040
#define         VS_Tx7          0x0080
#define         VS_Rx0          0x0100
#define         VS_Rx1          0x0200
#define         VS_TIMERA       0x0400
#define         VS_TIMERB       0x0800
#define         VS_PORTA_I      0x1000
#define         VS_PORTA_O      0x2000
#define         VS_PORTA_IO     0x3000
#define         VS_PORTB        0x4000
#define         VS_OPEN         0x8000

        /* Error defines (used with  v1_status) */
#define         VE_FATAL        0x8000
#define         VE_PORTB        VF_PORTB
#define         VE_PORTA_O      VF_PORTA_O
#define         VE_PORTA_I      VF_PORTA_I
#define         VE_PORTA_IO     VF_PORTA_IO
#define         VE_TIMERB       VF_TIMERB
#define         VE_TIMERA       VF_TIMERA
#define         VE_Rx1          VF_Rx1
#define         VE_Rx0          VF_Rx0
#define         VE_Tx7          VF_Tx7
#define         VE_Tx6          VF_Tx6
#define         VE_Tx5          VF_Tx5
#define         VE_Tx4          VF_Tx4
#define         VE_Tx3          VF_Tx3
#define         VE_Tx2          VF_Tx2
#define         VE_Tx1          VF_Tx1
#define         VE_Tx0          VF_Tx0
#define         VE_RxALL        VF_RxALL
#define         VE_TxALL        VF_TxALL
#define         VE_MIDIALL      VF_MIDIALL



/**************** STRUCTURE AND CONSTANT DEFINITIONS *******************/

typedef struct vxpi1
    {
    char driver_string[33];             /* A null terminated string that identifies the author and revision of the driver */
    char hardware_string[33];           /* A string that tells what hardware the driver is running on */
    signed char outputs;                /* Number of functioning independent output ports */
    signed char inputs;                 /* Number of separately addressable input ports */
    unsigned int interrupts;            /* Bit field to tell if we are using any of the 16 interrupts */
    unsigned int io_addr_min;           /* base address of the card */
    unsigned int io_addr_max;           /* Last address in the card */
    signed char timera;                 /* tells if timer A implemented */
    signed char timerb;                 /* tells if timer B implemented */
    signed char smpte_included;         /* Is there a SMPTE reader generator? */
    signed char smpte_generator_rates;  /* bit<0> = 24, 1=25, 2=df, 3=30, 4 = 29.97 */
    signed char smpte_freewheel_select; /* Do you have a choice of drop out intervals? */
    signed char smpte_stall_algorithm;  /* If 0: never stops on non-advancing time code (VITC in pause) */
                                        /* If 1: Any repeated frame will cause the reader to drop out */
                                        /* if 2: choice of 0 or 1 */
    signed char smpte_auto_detect;      /* if 1: you must tell reader what frame rate to expect */
                                        /* if 0: the reader always figures out the incoming frame rate */
                                        /* if 2: you may choose */
    signed char click_detector;         /* Is there an audio click detector */
    signed char mpu_type;               /* Is this like an mpu? */
    signed char simul_inout;            /* do the ins and outs work at the same time? */
    signed char mtc_output;             /* does echo mtc (while synching) work? */
    unsigned char card;                 /* Code for which hardware platform we are on */
    unsigned char rev_major;            /* vapi revison */
    unsigned char rev_minor;            /* right side of the decimal place */
    unsigned char simul_gensync;        /* can read and write smpte at same time */
    signed char reserved[33];           /* reserved for future features */
    } VXPI_STATS, far * LPVXPI_STATS;

struct vcwords
    {
    unsigned int ax;
    unsigned int cx;
    unsigned int dx;
    unsigned int es;
    unsigned int si;
    unsigned int who;                                   /* regular vapi or extended vapi function */
    unsigned char fn;                                   /* the function number */
    };

struct vcbytes
    {
    unsigned char al, ah;
    unsigned char cl, ch;
    unsigned char dl, dh;
    };
typedef union vapicstruc
    {
    struct vcwords      x;
    struct vcbytes      h;
    } VAPIDLLSTRUC, far * LPVAPIDLLSTRUC;


/************* constants to identify different hardware platforms *******/

#define CARD_C1         0
#define CARD_MPU        3               /* MPU-401 and compatibles */
#define CARD_V24S       4               /* Voyetra V-24s */
#define CARD_MQX32      5               /* Music Quest MQX-32 */
#define CARD_SB         6               /* Creative Labs Sound Blaster */
#define CARD_NUL        7               /* just the system clock */
#define CARD_MFC        9               /* IBM music feature */
#define CARD_V22        10              /* Voyetra V-22 card */
#define CARD_MQX16      12              /* Music Quest 16-s card */
#define CARD_PS1        13              /* IBM PS1 music board */
#define CARD_SPEC       14              /* Media vision Pros AudioSpectrum */
#define CARD_ATI        15              /* ATI VGAudio and compatibles */
#define CARD_SM2        17              /* Covox Sound Master II */
#define CARD_CUA        19              /* CompuAdd MultiMedia Card */
#define CARD_TEC        20              /* Tecmar Level One Audio Card */
#define CARD_ASC        22              /* ASC MediaMaster synth card */
#define CARD_SPEC2      30              /* Media Vision ProAudioSpectrum2 */


/**************** Constants defines for sapi mixer control *******/
/* these values must lie within MIN_OUR_CTRL1 and MAX_OUR_CTRL1 */
/* and get mapped to 0 - 18 in param.c                          */
/* which are card specific and used by Sapi - currently defined in MV.H */
/* these are all undefined controllers "Bx nn vv" */

#define SAPICTRL_MVOL_L         102     // Master volume L
#define SAPICTRL_MVOL_R         103     // Master volume R
#define SAPICTRL_MBASS_L        104     // Master volume L
#define SAPICTRL_MBASS_R        105     // Master volume R
#define SAPICTRL_MTREBLE_L      106     // Master volume L
#define SAPICTRL_MTREBLE_R      107     // Master volume R

#define SAPICTRL_LEVFM_L        108     //FM   output level L
#define SAPICTRL_LEVFM_R        109     //FM   output level R
#define SAPICTRL_LEVAUX1_L      110     //AUX1 output level L
#define SAPICTRL_LEVAUX1_R      111     //AUX1 output level R
#define SAPICTRL_LEVAUX2_L      112     //AUX2 output level L
#define SAPICTRL_LEVAUX2_R      113     //AUX2 output level R
#define SAPICTRL_LEVAUX3_L      114     //AUX3 output level L
#define SAPICTRL_LEVAUX3_R      115     //AUX3 output level R
#define SAPICTRL_LEVMIC_L       116     //MIC  output level L
#define SAPICTRL_LEVMIC_R       117     //MIC  output level R
/* following only useable if sapi is implementing aapi's mixer, then also see aapi.h */
#define SAPICTRL_FILTER         118     //cutoff freq of pcm anti-alias  filter (units are 200 hz per step)
#define SAPICTRL_PCMMODE        119     //stereo/mono
#define SAPICTRL_RECPLY         120     //switch mixer modes

#define SAPICTRL_DRUMCHAN       0       //change the drum channel

/* Define VAPI function numbers (used whe calling DLL or int7f directly */

#define         __v1_open               60
#define         __v1_close              61
#define         __v1_rxopen             62
#define         __v1_rxclose            63
#define         __v1_txopen             64
#define         __v1_txclose            65
#define         __v1_rxclear            66
#define         __v1_txclear            67
#define         __v1_get                68
#define         __v1_put                69

#define         __v1_peek               70
#define         __v1_putw               71
#define         __v1_2putw              72
#define         __v1_3putw              73
#define         __v1_nputw              74
#define         __v1_rxrest             75
#define         __v1_txrest             76
#define         __v1_txwait             77
#define         __v1_tmaopen            78
#define         __v1_tmaclose           79

#define         __v1_tmbopen            80
#define         __v1_tmbclose           81
#define         __v1_tmastart           82
#define         __v1_tmastop            83
#define         __v1_tmbstart           84
#define         __v1_tmbstop            85
#define         __v1_tmarate            86
#define         __v1_tmbrate            87
#define         __v1_msk                88
#define         __v1_getmsk             89

#define         __v1_status             90
#define         __v1_trap               91
#define         __v1_portb_open         121
#define         __v1_portb_close        122
#define         __v1_portb_get          96
#define         __v1_tcgen_set          99

#define         __v1_tcgen_start        100
#define         __v1_tcgen_stop         101
#define         __v1_tcread_start       102
#define         __v1_tcread_stop        103


/*      define VXPI functions           */
#define         __vx_id                 0                       /* get vapi id string */
#define         __vx_psp                1                       /* return the psp of the current vapi */
#define         __vx_restore            2                       /* restore old int vectors */
#define         __vx_prerr              3                       /* for debugging, print errors */
#define         __vx_toggle_vbit        4                       /* toggles a bit in the port */
#define         __vx_midi_loop          5                       /* connects midi in and out (for test) */
#define         __vx_showq              6                       /* dumps the contents of a q */
#define         __vx_uart_error         8
#define         __vx_set_vbit           9

#define         __vx_clr_vbit           10
#define         __vx_read_iport         11
#define         __vx_get_fast_addr      12                      /* get the address of the fast vapi function */
#define         __vx_set_freewheel      13                      /* set the freewheel dropout tolerence */
#define         __vx_stats              14                      /* get driver information stats */
#define         __vx_output_enable      15                      /* enable/disable the midi output! (cml) */
#define         __vx_sound_enquire      16                      /* is there a driver?  return ptr in es:si if driver installed */
#define         __vx_genmtc             17                      /* generate mtc while generate smpte */
#define         __vx_stalldetect        18                      /* set smpte stall detect */
#define         __vx_autolock           19                      /* set smpte fram detect  */

#define         __vx_echomtc            20                      /* echo mtc from smpte to port 4 */
#define         __vx_convert_clicks     21                      /* enable the click converter */
#define         __vx_portbmtc           22                      /* send straight mtc to the portb fns */
#define         __vx_sys_timer          23

#define         __vx_byte_buffers       24                      /* double midi q density */

#define         __vx_sapi_ctrl          25                      /* route continuous controllers to sapi global ctrl */
#define         __vx_sapi_rtrn          26                      /* get back current values of controlled params */
#define         __vx_poll               27                      /* second level of multi tasking */

#define         VAPI_FN                 0x4331                  /* 'C1' */
#define         VXPI_FN                 0x5658                  /* 'VX' */


/******************** FUNCTION PROTOTYPES *************/


extern int far pascal VapiDllFn (LPVAPIDLLSTRUC);
extern int far pascal SapiDllFn (LPVAPIDLLSTRUC);
