;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; std.inc
;
;******************************************************************************

;=============================
;                            =
;       M A C R O S          =
;                            =
;=============================
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  STANDARD  MACROS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
IF1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on zero flag #1
;
bne     MACRO   label
        LOCAL   branch
        je      branch
        jmp     label
branch:
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on zero flag =1
;
be      MACRO   label
        LOCAL   branch
        jne     branch
        jmp     label
branch:
        ENDM

bz      MACRO   label
        LOCAL   branch
        jne     branch
        jmp     label
branch:
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on below (unsigned)
;
bb      MACRO   label
        LOCAL   branch
        jae     branch
        jmp     label
branch:
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on above (unsigned)
;
ba      MACRO   label
        LOCAL   branch
        jbe     branch
        jmp     label
branch:
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on below or equal (unsigned)
;
bbe     MACRO   label
        LOCAL   branch
        ja      branch
        jmp     label
branch:
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on above or equal (unsigned)
;
bae     MACRO   label
        LOCAL   branch
        jb      branch
        jmp     label
branch:
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on above or equal (unsigned)
;
bc      MACRO   label
        LOCAL   branch
        jnc     branch
        jmp     label
branch:
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on above or equal (unsigned)
;
bnc     MACRO   label
        LOCAL   branch
        jc      branch
        jmp     label
branch:
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; macro to long branch on above or equal (unsigned)
;
bs      MACRO   label
        LOCAL   branch
        jns     branch
        jmp     label
branch:
        ENDM
;============================================
;
;       macro to beep the speaker

beep    macro                   ;beep the speaker
        push    ax
        push    dx
        mov     dl,7
        mov     ah,2
        int     21h
        pop     dx
        pop     ax
        endm

;================================================================
;
;       macro to get a key without echo

getkey  macro                   ;get a key without echo

        mov     ah,8
        int     21h
        or      al,00100000b
        endm

;================================================================
; macros.i: macro include file.
;
pushall macro
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        endm

popall  macro
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        endm

nops    macro   count
        rept    count
        nop
        endm
        endm

ECALL   MACRO   PARM
        EXTRN   PARM:NEAR
        CALL    PARM
        ENDM


; Multiple shift macros

rorm            macro   regmem,count
                .errb   <count>
                .errnz  count GT 16
                rept    count
                ror     regmem,1
                endm
                endm

rolm            macro   regmem,count
                .errb   <count>
                .errnz  count GT 16
                rept    count
                rol     regmem,1
                endm
                endm

rcrm            macro   regmem,count
                .errb   <count>
                .errnz  count GT 16
                rept    count
                rcr     regmem,1
                endm
                endm

rclm            macro   regmem,count
                .errb   <count>
                .errnz  count GT 16
                rept    count
                rcl     regmem,1
                endm
                endm

shrm             macro   regmem,count
                .errb   <count>
                .errnz  count GT 16
                rept    count
                shr     regmem,1
                endm
                endm

shlm             macro   regmem,count
                .errb   <count>
                .errnz  count GT 16
                rept    count
                shl     regmem,1
                endm
                endm

sarm             macro   regmem,count
                .errb   <count>
                .errnz  count GT 16
                rept    count
                sar     regmem,1
                endm
                endm

salm             macro   regmem,count
                .errb   <count>
                .errnz  count GT 16
                rept    count
                sal     regmem,1
                endm
                endm

; INC and DEC macros

inc2            macro   regmem
                inc     regmem
                inc     regmem
                endm

dec2            macro   regmem,count
                dec     regmem
                dec     regmem
                endm


PUSHEM  MACRO   parm1,parm2,parm3,parm4,parm5,parm6,parm7,parm8,parm9
        IFNB    <parm1>
        push    parm1
        ENDIF
        IFNB    <parm2>
        push    parm2
        ENDIF
        IFNB    <parm3>
        push    parm3
        ENDIF
        IFNB    <parm4>
        push    parm4
        ENDIF
        IFNB    <parm5>
        push    parm5
        ENDIF
        IFNB    <parm6>
        push    parm6
        ENDIF
        IFNB    <parm7>
        push    parm7
        ENDIF
        IFNB    <parm8>
        push    parm8
        ENDIF
        IFNB    <parm9>
        push    parm9
        ENDIF
        ENDM


POPEM   MACRO   parm1,parm2,parm3,parm4,parm5,parm6,parm7,parm8,parm9
        IFNB    <parm9>
        pop     parm9
        ENDIF
        IFNB    <parm8>
        pop     parm8
        ENDIF
        IFNB    <parm7>
        pop     parm7
        ENDIF
        IFNB    <parm6>
        pop     parm6
        ENDIF
        IFNB    <parm5>
        pop     parm5
        ENDIF
        IFNB    <parm4>
        pop     parm4
        ENDIF
        IFNB    <parm3>
        pop     parm3
        ENDIF
        IFNB    <parm2>
        pop     parm2
        ENDIF
        IFNB    <parm1>
        pop     parm1
        ENDIF
        ENDM
ENDIF

