;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; startup.asm - Audio device driver PDD 'ASM' startup module for 'C'.
;
; Provides the user's "main" routine with the address of
; the request packet.
; Satisfies the C EXTRN for __acrtused, which prevents the startup
; logic from being included from the standard C library.
;
; This code provides interfaces to C routines for strategy and IDC
; entry points.   The code is based on IBM toolkit source and is not
; dependent on a PAS-16 audio adapter.
;******************************************************************************

        PAGE    80,132

        TITLE  Audio OS/2 Device Driver
        .seq                                    ; Use segments in order listed
        .286p                                   ; Allow priviledged instruct

;******************************************************************************
;                            S E G M E N T S
;******************************************************************************

_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_ENDDATA   SEGMENT WORD PUBLIC 'ENDDATA'
_ENDDATA   ENDS

RMCode  SEGMENT WORD PUBLIC 'CODE'
RMCode  ENDS

_TEXT   SEGMENT WORD PUBLIC 'CODE'
        EXTRN  _Strategy_c:NEAR
        EXTRN  _DDCmdInternalEntryPoint:far
        EXTRN  _PDDInternalEntryPoint:NEAR
        PUBLIC  __acrtused
        PUBLIC _Strategy
        PUBLIC _DDCMDEntryPoint
        PUBLIC _PDDEntryPoint
_TEXT   ENDS

_ENDTEXT SEGMENT WORD PUBLIC 'ENDCODE'
_ENDTEXT   ENDS


DGROUP  GROUP   CONST, _BSS, _DATA, _ENDDATA
CGRP    GROUP   RMCode, _TEXT, _ENDTEXT

;******************************************************************************
;  C O D E   S E G M E N T
;******************************************************************************
_TEXT   SEGMENT WORD PUBLIC 'CODE'
;;        ASSUME cs:_TEXT, ds:DGROUP, es:NOTHING, ss:NOTHING
        ASSUME ds:DGROUP, es:NOTHING, ss:NOTHING        ; MASM 6.00



;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: Strategy
;*
;* DESCRIPTIVE NAME: Audio PDD Strategy Routine
;*
;* ENTRY POINTS:  Strategy
;*
;* INPUT:  DS    = DD Data Segment
;*         ES:BX -> Pointer to the Request Packet
;*
;*            The Request Packet:
;*            ------------------
;*            HEADER:                 ; Request Header
;*              BYTE    .PktLen       ;   length of request packet
;*              BYTE                  ;   Block Device unit code (unused)
;*              BYTE    .PktCmd       ;   command code
;*              WORD    .PktStatus    ;   return status
;*              DWORD   .PktDevLink   ;   ReqPkt queue linkage
;*                                    ;
;*            DATA:                   ;
;*              ????                  ; Depends on function requested
;*
;* EXIT-NORMAL: .PktStatus  = 0100h ( No Error              )
;*                            0300h ( Device Busy, No Error )
;*
;* EXIT-ERROR:  .PktStatus  = 8101h ( Unknown Unit          )
;*                            8102h ( Device Not Ready      )
;*                            8103h ( Unknown command       )
;*                            810Ch ( General Failure       )
;*                            8111h ( Char_Call_Interrupted )
;*                            8112h ( No Monitor Support    )
;*                            8113h ( Invalid Parameter     )
;*
;*********************** END OF SPECIFICATIONS **********************
_Strategy proc far
__acrtused label byte                           ; Label for linker, eliminates
                                                ; inclusion of C runtime startup
        push    es                              ; Push address of request
        push    bx                              ; packet (parm to C routine)
        call    _Strategy_c
        pop     bx                              ; Restore stack frame and
        pop     es                              ; restore pointer to request
                                                ; packet.
        mov     WORD PTR es:[bx+3],ax           ; plug in status word
        ret                                     ; Return to kernel
_Strategy endp


;***************************************
; DDCMDEntryPoint - Enables Audio stream
; handler to communicate with Audio PDD
;***************************************

_DDCMDEntryPoint proc far

        push   bp                               ; Save stack pointer
        mov    bp, sp

        push   ds                               ; Create own data segment
        mov    ax, DGROUP
        mov    ds, ax


        push   [bp+8]                           ; high address
        push   [bp+6]                           ; low address
                                                ; +4[bp] has old CS register

        call   _DDCmdInternalEntryPoint         ; C routine to process DDCMDs

        add    sp, 4                            ; toss calling address

        pop    ds                               ; restore registers ds, bp
        pop    bp
        ret

_DDCMDEntryPoint endp

;********************************************
; PDDEntryPoint - IDC entry point for calls from
; Virtual Device Driver and DOS session manager.
;
; ULONG PDDInternalEntryPoint(ULONG ulFunc, ULONG ul1, ULONG ul2)
;
; PASCAL calling conventions all regsiters preserved
; Return value in ax.
;
; This routine routes the VDD call to a C routine that
; does the actual work of the call.
; This assembler code maps the Pascal calling conventions
; to C conventions and preserves/restores the VDD's
; registers.
;
;***********************************************


ulFunc  EQU DWORD PTR [bp+18]   ; Pascal conventions push left most byte first.
ul1     EQU DWORD PTR [bp+14]   ; Bottom 10 Bytes are saved bp (2 btyes)
ul2     EQU DWORD PTR [bp+10]   ; and 16:32 return address (8 bytes)

_PDDEntryPoint  PROC  FAR                       ; 16:16 entry
        .386p                                   ; Allow 32-bit instructions
        push    bp                              ; Save stack pointer
        mov     bp, sp                          ; Establish stack frame

        push    ds                              ; Save callers registers
        push    es
        push    bx
        push    cx
        push    dx
        push    si
        push    di

        mov     ax, DGROUP                      ; Establish C code's data seg
        mov     ds, ax

        push    ul2                             ; Push parms using C convention
        push    ul1
        push    ulFunc
        call    _PDDInternalEntryPoint          ; C routine to process VDD call
        add     sp, 12                          ; clear parms from stack

        shl     edx, 16                         ; C code returns ULONG as
        mov     dx, ax                          ; dx ax pair.  Expand to eax
        mov     eax, edx                        ; for 32-bit return value

        pop     di                              ; Restore callers regs
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     es
        pop     ds

        pop     bp                              ; Restore callers stack frame

        db      66h                             ; Force next instruction 32-bit
        ret     12                              ; 16:32 far return
        .286p                                   ; Restore 16-bit restrictions
_PDDEntryPoint  ENDP

; Call VDD IDC entry point.
; This function receives control from 16:16 C code,
; massages the parameters from C conventions to Pascal
; conventions and then calls the VDD 16:32 routine.

fwPtr   EQU FWORD PTR [bp+04]
ulOfs   EQU DWORD PTR [bp+04]
usSel   EQU  WORD PTR [bp+08]   ; Parms from C routine
ulFunc  EQU DWORD PTR [bp+10]
ul1     EQU DWORD PTR [bp+14]
ul2     EQU DWORD PTR [bp+18]

_CallVDD PROC  NEAR                             ; 16:16 entry
        .386p                                   ; Allow 32-bit instructions
        push    bp                              ; Save stack pointer
        mov     bp, sp                          ; Establish stack frame

        push    ulFunc                          ; Push left to right (Pascal)
        push    ul1
        push    ul2
        db      66h
        call    fwPtr

        mov     edx, eax                        ; dx:ax = eax
        shr     edx, 16                         ; ULONG return value

        pop     bp                              ; Restore callers stack frame
        ret                                     ; Caller pops (C conventions)
        .286p                                   ; Restore 16-bit restrictions
_CallVDD ENDP
_TEXT   ENDS
        END
