/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  RMHELP.H
 *
 * DESCRIPTIVE NAME =  Header file for rmhelp.c
 *
 *
 *
 * VERSION = V0.1
 *
 * DATE  09/02/94
 *
 * DESCRIPTION : (see above)
 *
 * Purpose: (see above)
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
*/

#ifndef  __RMHELP_H__
#define  __RMHELP_H__

#include <rmcalls.h>

/*--------------------------------------------------------*/
/* # D E F I N E S                                        */
/*--------------------------------------------------------*/
#define DECODE_WIDTH          16

#define MAX_PORT_HANDLES      50  // !!! COUNT RMHELP_Allocs to set this
#define MAX_RES_HANDLES       (2 + MAX_PORT_HANDLES)

#define MAX_RES_BUF_SIZE sizeof(AHRESOURCE) +                    \
                         MAX_RES_HANDLES * sizeof(HRESOURCE)

#define RMHELP_ERR_RESOURCECLAIMED      0xFFFF
#define RMHELP_ERR_TOOMANYRESPORTS      0xFFFE

/*--------------------------------------------------------*/
/* P R T O T Y P E S                                      */
/*--------------------------------------------------------*/
USHORT RMHELP_CreateDriver( PSZ DrvrName);
VOID   RMHELP_DestroyDriver( VOID);
USHORT RMHELP_CreateAdapter( VOID);
USHORT RMHELP_GrabPort( USHORT p);
USHORT RMHELP_AllocPorts( USHORT baseport, USHORT nPorts, USHORT ShareType);
VOID   RMHELP_DeAllocLastPort( VOID);
VOID   RMHELP_SetPortsMarker( VOID);
VOID   RMHELP_DeAllocPortsToMarker( VOID);
USHORT RMHELP_AllocIRQ( USHORT IRQlevel);
USHORT RMHELP_AllocDMA( USHORT DMAChannel);
VOID   RMHELP_DeAllocIRQ( VOID);
VOID   RMHELP_DeAllocDMA( VOID);
VOID   RMHELP_PostRMError( USHORT restype, USHORT resval, USHORT rc);
VOID   RMHELP_DumpRMErrors( VOID);
VOID   RMHELP_PutMessage( PSZ pszResource,
                          USHORT value,
                          USHORT fieldwidth,
                          USHORT rc);

#endif /* __RMHELP_H__ */
