/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* proto.h - prototypes for functions throughout driver
*
******************************************************************************/

// audintr.c
VOID NEAR PCMInterrupt(void);
PSTREAM near GetActiveMIDIStream(void);
VOID NEAR MIDITimerInterrupt(PSTREAM pStream);
//VOID NEAR MIDIInputInterrupt(void);
void DisposeOfPlayedBuffer(PSTREAM pStream);
void DisposeOfFilledBuffer(PSTREAM pStream);

// audsubs.c
void LoadBuffer(char far * hpData,char far *lpBuf, DWORD dwCnt);
void StartMIDIInterrupts(PSTREAM pStream);
void StopMIDIInterrupts(void);
void RationalRateApproximation (DWORD dwFactor, DWORD dwRate,
     WORD FAR *pwDividendBest, WORD FAR *pwDivisorBest);
void MIDI_All_Notes_Off(void);
long max ( long l1, long l2);
long min ( long l1, long l2);
int BoardInstalled(void);
DWORD LRVolumeFromVolumeBalance( DWORD dwVolume, DWORD dwBalance );
void ToggleMIDIIntEnable(void);
void TogglePCMIntEnable(void);
void calcSampleRate(DWORD samplespersec, WORD wNumChannels, WORD wBitsSample);

// outchip.c
BYTE near PASX_IN( WORD port );
void near PASX_OUT( WORD port, char data);
void near SndOutput1( WORD addr, WORD data);
void near SndOpl3_2_1( WORD addr, WORD data);
unsigned int IN_STAT(void);

// initc.c
int InitHardware(void);
int GetLocationRequests(pPROFILE lpPf);

// mixinitc.c
void InitMixer(void);
int lstrlen (LPSTR lpStr);
BOOL lstrcat (LPSTR lpDest, LPSTR lpSrc);
BOOL lstrcpy(LPSTR lpDest,LPSTR lpSrc);
USHORT lstrcmp(LPSTR lpDest,LPSTR lpSrc);

// in mvsound.asm

extern void loadTimer0( WORD wSampleRate);
extern void loadTimer1( WORD wBufferCount);
extern void loadPrescale( WORD wPrescale);
extern int      InitPCM (void);
extern int      Init16( DWORD dwCaps );
extern void MVOut( int, int );
extern int  PCMPlay(void );
extern int  PCMRecord( void );
extern void StopPCM(void);
extern void RemovePCM(void);
extern void PausePCM(void);
extern void ResumePCM(void );
extern int      SelectDMA( int );
extern int      SelectIRQ( int );
extern int      SetCrossChannel( int, int, int, int );
extern void SetFilter( WORD );
extern void SetInputMixer( int, int );
extern void SetOutputMixer( int, int );
extern void SetVolume( int, int );
extern void UserFunc    ( long (*)(), int );
extern void DetectPasVersion(void);
extern void resetdmaptrs(void);
extern WORD ReadDMA(void);


// in mixinitc.c
DWORD   Scale100ToFFFF(WORD wVal);
int DoReset(void);

// in inita.asm
extern unsigned Disable  (void);
extern unsigned Init508 (void);
extern void Configure (void);

// in midia.asm
void near Enable_MIDI_IO(void);
void near Disable_MIDI_IO(void);
void near MIDI_Output_Start(void);
void near MIDI_Output_Stop(void);
void near MIDI_Output_Byte(BYTE);

// in mixsubs.c
WORD updateInput(LPMIXERSTATE lpProposedMixer,WORD wLine);
WORD updateOutput(LPMIXERSTATE lpProposedMixer,WORD wLine);
WORD patchInput(LPMIXERSTATE lpProposedMixer, WORD wLine, LPPATCHINFO lpInfo);
WORD patchOutput(LPMIXERSTATE lpProposedMixer, WORD wLine, LPPATCHINFO lpInfo);
void SetEqMode(WORD P_loudness, WORD P_enhance);

void SetInput(WORD wInput, WORD vol, WORD channelLR, WORD wXover, WORD wOutput);
void SetOutput(WORD wOutput, WORD vol, WORD channelLR);
void SetEQ(WORD wOutput,WORD bass_treb, WORD vol);
void SetMode(WORD loudness, WORD enhounce);

void TimedFadeInterrupt(void);
void CopyMixerState(LPMIXERSTATE lpDestinationMixer,LPMIXERSTATE lpSourceMixer);
WORD FadeMixerState(LPMIXERSTATE lpMixerState,DWORD dwTime,DWORD dwCallback);
void StartInterrupt(void);
void Tick(HANDLE h, WORD msg, DWORD dwUser, DWORD dw1, DWORD dw2);

// in mvmixer.c
WORD  GetDevCaps(WORD wDeviceID,LPMIXERCAPS lpCaps,WORD wSize);
WORD  Open(WORD wDeviceID,DWORD dwFlags);
WORD  Close(WORD wDeviceID);
WORD  Reset(WORD wDeviceID);
WORD  Mute(WORD wDeviceID);
WORD  GetState(WORD wDeviceID,LPMIXERSTATE lpMixerState, WORD wSize);
WORD  SetState(WORD wDeviceID,LPMIXERSTATE lpMixerState, WORD wSize,DWORD dwTime,DWORD dwFlags, DWORD dwCallback);
WORD  GetLineConnections (WORD wDeviceID,WORD wLine, DWORD FAR *lpdwConnections);
WORD  SetLineConnections (WORD wDeviceID,WORD wLine, DWORD dwConnections);
WORD  GetDeviceLines(WORD wDeviceID,LPDEVICELINES lpDeviceLines);
WORD  GetDeviceConnections(WORD wDeviceID,LPDEVICECONNECT lpDeviceConnect);
WORD  SetDeviceConnections(WORD wDeviceID,LPDEVICECONNECT lpDeviceConnect);
WORD  GetLineInfo(WORD wDeviceID, WORD wLine, LPMIXERLINEINFO lpInfo,WORD wSize);
WORD  GetLineControl(WORD wDeviceID, WORD wLine, DWORD dwControl, DWORD FAR *lpdwSetting);
WORD  SetLineControl(WORD wDeviceID, WORD wLine, DWORD dwControl, DWORD dwSetting);
WORD  GetPatchInfo(WORD wDeviceID,WORD wPatchNum,LPPATCHINFO lpInfo,WORD wSize);
WORD  GetLinePatch(WORD wDeviceID,WORD wLine ,LPWORD lpwPatchNum);
WORD  SetLinePatch(WORD wDeviceID,WORD wLine,WORD wPatchNum,PATCHINFO FAR *lpPatch);
WORD  GetFadeStatus(WORD wDeviceID,LPDWORD lpdwTime);


USHORT FillDMABuffer( PSTREAM pStream,USHORT usBuffer);

// in audsubs.c
BOOL DevOpen            (void);
void DevClose           (void);
//#if 0
//void DevIOCTL           (void);
//void DevStart           (void);
//void DevStop            (void);
//void DevPause           (void);
//void DevResume          (void);
//#endif

void DevChange          (LPMCI_AUDIO_CHANGE );  // Change device type
//#if 0
//void DevAudioBuffer     (void);
//void DevIOCTLload       (void);
//void DevIOCTLwait       (void);
//void DevIOCTLhpi        (void);
//#endif

void DevIOCTLstatus     (LPMCI_AUDIO_STATUS );
//void ProcessBuffer (void);


/*
** Updates stream position to account for completion
** of present operation and returns a pointer to
** present position (counter).
*/
PULONG GetStreamTime (PSTREAM pStream);
VOID SetStreamTime (PSTREAM pStream, ULONG ulSetPos);
void DestroyStreams (void);
UINT ReadDataFromCard (PSTREAM );
UINT WriteDataToCard (PSTREAM );
void InitialBufferLoad (PSTREAM );

/*
** Routines for communication with OS/2 kernel
*/
void EOI                (void);         // Issue End-Of-Interrupt to 8259

void ReadStatus (void);

void WriteStatus (void);

void FlushInputBuffers (void);

void FlushOutputBuffers (void);

ULONG Enqueue_Event (HEVENT hEvent, ULONG ulCuePoint);

ULONG Dequeue_Event (HEVENT hEvent);

/*\
|*|----====< 3812.ASM >====----
\*/

void _out3812     ( int, int, int );
void _out3812idx  ( int );
void _out3812data ( int );


/*\
|*|----====< MAIN.C >====----
\*/

void DisplayChip       ( );             /* left/right chip draw */
void doexit            ( int );         /* exit the program     */
int  DefaultHandler    ( );             /* default event handler*/
int  GetNewKey         ( );             /* flush & read keybrd  */
void GiveHelps         ( char ** );     /* Help screen output   */
int  IceButtonAction   ( );             /* line hex action      */
int  InsButtonAction   ( );             /* Instrument load      */
int  LineIdxAction     ( );             /* line index action    */
int  LineBinAction     ( );             /* line binary action   */
int  LineHexAction     ( );             /* line hex action      */
int  Setup             ( );             /* initial setup        */
int  TextButtonAction  ( );             /* Text string input    */
int  VoiceButtonAction ( );             /* line hex action      */
BOOL  FMInit(void );

extern void  SetVoicePan_and_FB(int slot, char pan);
extern void  set_a_param_in_a_slot(unsigned slot,  char * cParam);
extern void  shut_off_drum_voices(void);
extern void  SetOplMode(int mode);
extern void  SoundColdInit(void);
extern int   SoundWarmInit(void);
extern int   Set3812(int);
extern int   SetPitchRange(unsigned);
extern int   SetGParam(int, int, int);
extern void  squash_voice(int vx);
extern void  SetVoiceVolume(int, unsigned);
extern int   SetVoicePitch(unsigned, unsigned);
extern void  NoteOn(unsigned voice, int pitch);
extern void  NoteOff(unsigned voice, int pitch);
extern int   SetCharSlotParam(unsigned, char *);
extern void  ShutOffDrums(void);
extern void  set_pitch_range(unsigned p_range);

// fmmain.c
extern BOOL sapiEnable(void);
extern BOOL sapiDisable(void);

extern void  reset_deal(void);

void init_chan_etc(void);

BOOL  midi_deal(BYTE c);
void  do_reset(int first);
int   pitch_to_drum(int pitch);
int   remove_target(int p, int  chan, int * op);
void  near add_q(int, int, int *);

/* parse.c */

int  get_midi_type(BYTE code);
void dispatch(void);
void reset_all(void);
void reset_close(void);

/* assign2.c */
void shut_off_all(void);
