/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* pasdef.h
*
******************************************************************************/

#define MAXCARDS                5


//
// THESE DEFINITIONS FOR CAPABILITIES FIELD
//


#define DEFAULT_BASE                    0x388           // default base I/O address of Pro AudioSpectrum

//// THESE ARE BASE REGISTER EQUATES (prior to relocation)

#define FM_BASE                         0x0388  // base address of FM chip
#define OPL3_BASE                       0x038A  // base address of FM chip
#define ALTERNATE_FM                    0x0788  // Alternate FM registers
#define MIXER_508_REG                   0x078b  // Mixer 508
#define SERIAL_MIXER                    0x0b88  // for Pas 1 and Pas 8
#define FEATURE_ENABLE                  0x0b88  // for Pas 16 boards only
#define INTERRUPT_STATUS                0x0b89  //
#define FILTER_REGISTER                 0x0b8a  //
#define INTERRUPT_ENABLE                0x0b8b  //
#define INTERRUPT_CTRL_REG              0x0b8b  //
#define PCM_CONTROL                     0x0f8a  //

#define SAMPLE_RATE                     0x1388  // (t0) Sample Rate Timer Register
#define SAMPLE_COUNT                    0x1389  // (t1) Sample Count Register
#define SPEAKER_TIMER                   0x138A  // (t2) Local Speaker Timer Address
#define TIMER_CONTROLLER                0x138B  // Local Timer Control Register

// original PAS MIDI equates
#define  MDIRQVECT      0x1788          /* MIDI IRQ Vector Register     */
#define  MDSYSCTLR      0x1789          /* MIDI System Control Register */
#define  MDSYSSTAT      0x178A          /* MIDI IRQ Status Register     */
#define  MDIRQCLR       0x178B          /* MIDI IRQ Clear Register      */
#define  MDGROUP1       0x1B88          /* MIDI Group #1 Register       */
#define  MDGROUP2       0x1B89          /* MIDI Group #2 Register       */
#define  MDGROUP3       0x1B8A          /* MIDI Group #3 Register       */
#define  MDGROUP4       0x1B8B          /* MIDI Group #4 Register       */

// MV 101 MIDI equates
#define MIDI_PRESCALE                   0x1788  //
#define MIDI_TIMER                      0x1789  // READ ONLY
#define MIDI_DATA                       0x178A  //
#define MIDI_CONTROL                    0x178B  //
#define MIDI_STATUS                     0x1B88  //
#define MIDI_FIFO_STATUS                0x1B89  //
#define MIDI_COMPARE_TIME               0x1B8A  //

#define TIMEOUT_COUNTER                 0x4388  //
#define TIMEOUT_STATUS                  0x4389  //
#define ENHANCED_SCSI_DETECT_REG        0x7f89  //
#define SYSTEM_CONFIG_1                 0x8388  //
#define SYSTEM_CONFIG_2                 0x8389  //
#define SYSTEM_CONFIG_3                 0x838a  //
#define SYSTEM_CONFIG_4                 0x838b  //
#define PAS_2_WAKE_UP_REG               0x9a01  // aka Master Address Pointer
#define WAIT_STATE                      0xbf88  //
#define PRESCALE_DIVIDER                0xbf8A  //
#define MIDI_TEST_REGISTER              0xbf8B  //
#define SLAVE_MODE_READ                 0xef8b  // bits D0-D1
#define IO_PORT_CONFIG_1                0xf388  //
#define IO_PORT_CONFIG_2                0xf389  //
#define IO_PORT_CONFIG_3                0xf38a  //
#define COMPATIBLE_REGISTER_ENABLE      0xf788  // SB and MPU emulation
#define EMULATION_ADDRESS_POINTER       0xf789  // D0-D3 is SB; D4-D7 is MPU
#define EMULATION_INTERRUPT_POINTER     0xfb8a  // MPU and SB IRQ and SB DMA settings
#define CHIP_REV                        0xff88  // MV101 chip revision number
#define MASTER_MODE_READ                0xff8b  // aka Master Address Pointer


#define READ_PAS(pGDI, port) \
        READ_PORT_UCHAR((PUCHAR)((port) ^ (pGDI->TranslateCode)))

#define WRITE_PAS(pGDI, port, data) \
        WRITE_PORT_UCHAR((PUCHAR)((port) ^ (pGDI->TranslateCode)), (UCHAR)(data))


// useful bit definitions
#define D0      (1<<0)
#define D1      (1<<1)
#define D2      (1<<2)
#define D3      (1<<3)
#define D4      (1<<4)
#define D5      (1<<5)
#define D6      (1<<6)
#define D7      (1<<7)


//// BIT FIELDS FOR COMPATIBLE_REGISTER_ENABLE
#define MPU_ENABLE_BIT                  D0
#define SB_ENABLE_BIT_REV_D             D1
#define SB_IRQ_ENABLE_BIT               D2              // read only

//// BIT FIELDS FOR FEATURE_ENABLE (0xb88)
#define         PCM_FEATURE_ENABLE     D0
#define FM_FEATURE_ENABLE              D1
#define MIXER_FEATURE_ENABLE           D2
#define SB_FEATURE_ENABLE_REV_C        D4
#define STUDIO_FEATURE_DISABLE         D4

/// BIT FIELDS FOR PCM CONTROL
#define  PCM_STEREO                    D0+D3
#define  PCM_DAC                       D4
#define  PCM_MONO                      D5
#define  PCM_ENGINE                    D6
#define  PCM_DRQ                       D7

/// BIT FIELDS FOR SYSTEM CONFIG 1
#define  C1_PC_SPKR_ENABLE             D0
#define  C1_ACCURATE_TIMING            D1    // original PAS and PAS Plus don't support
#define  C1_ALTERNATE_OSCILLATOR       D2    // T:1, OPTI CHIPSET FIX FOR OPL-3
#define  C1_PC_SPKR_SIM_STEREO   D4
#define  C1_PC_SPKR_INTEGRATOR   D5    // smooths PC speaker digital audio
#define  C1_CHIP_RESET           D7    // cause MV101 to reset, may not work!
                                       // try enabling warm boot reset and
                                       // writing to refresh timer


/// BIT FIELDS FOR SYSTEM CONFIG 3
#define  C3_ENHANCED_TIMER              D0
#define  C3_SB_CLOCK_EMUL               D1  // don't set!
#define  C3_VCO_INVERT                  D2
#define  C3_INVERT_BCLK                 D3
#define  C3_SYNC_PULSE                  D4
#define  C3_PSEUDO_PCM_STEREO           D5

/// BIT FIELDS FOR INTERRUPT ENABLE
#define INT_LEFT_FM                     D0
#define INT_RIGHT_FM                    D1
#define INT_SB                          D1
#define INT_SAMPLE_RATE                 D2
#define INT_SAMPLE_BUFFER               D3
#define INT_MIDI                        D4

/// BIT FIELDS FOR INTERRUPT STATUS

#define INT_LEFT_FM_OCCURRED            D0
#define INT_RIGHT_FM_OCCURRED           D1
#define INT_SB_OCCURRED                 D1
#define INT_SAMPLE_RATE_OCCURRED        D2
#define INT_SAMPLE_BUFFER_OCCURRED      D3
#define INT_MIDI_OCCURRED               D4
#define STEREO_PHASE_LEFT               D5
#define PAS_STILL_RESETTING             D6
#define PCM_INPUT_CLIPPED               D7

/// BIT FIELDS FOR COMPATIBLE REGISTER ENABLE
#define COMPAT_MPU                      D0
#define COMPAT_SB                       D1


/// IRQ POINTER VALUES FOR EMULATION INTERRUPT POINTER
#define EMUL_IRQ_NONE                   0
#define EMUL_IRQ_2                      1
#define EMUL_IRQ_3                      2
#define EMUL_IRQ_5                      3
#define EMUL_IRQ_7                      4
#define EMUL_IRQ_10                     5
#define EMUL_IRQ_11                     6
#define EMUL_IRQ_12                     7

/// DMA POINTER VALUES FOR EMULATION DMA POINTER
#define EMUL_DMA_NONE                   0
#define EMUL_DMA_1                      1
#define EMUL_DMA_2                      2
#define EMUL_DMA_3                      3


/// BIT VALUES FOR FILTER REGISTER
#define FILTER_NOMUTE                   D5

/// BIT FIELDS FOR MIDI_CONTROL REGISTER
#define ENABLE_TIME_STAMP_INT           D0
#define ENABLE_COMPARE_TIME_INT         D1
#define ENABLE_IN_FIFO_INT              D2
#define ENABLE_OUT_FIFO_INT             D3
#define ENABLE_OUT_FIFO_HALF_INT        D4
#define RESET_IN_FIFO                   D5
#define RESET_OUT_FIFO                  D6
#define MIDI_PASS_THRU                  D7

/// BIT FIELDS FOR MIDI_STATUS REGISTER
#define INT_TIME_STAMP_OCCURRED   D0
#define INT_COMPARE_TIME_OCCURRED D1
#define MIDI_IN_FIFO_DATA         D2
#define MIDI_IN_NOW_EMPTY         D3
#define OUT_FIFO_HALF_EMPTY       D4
#define IN_FIFO_OVERRUN           D5
#define OUT_FIFO_OVERRUN          D6
#define FRAME_ERROR               D7

#ifndef MIXCROSSCAPS_NORMAL_STEREO
#define MIXCROSSCAPS_NORMAL_STEREO      0    // Left->Left, Right->Right
#define MIXCROSSCAPS_RIGHT_TO_BOTH      1    // Right->Left, Right->Right
#define MIXCROSSCAPS_LEFT_TO_BOTH       2    // Left->Left, Left->Right
#define MIXCROSSCAPS_REVERSE_STEREO     4    // Left->Right, Right->Left
#define MIXCROSSCAPS_RIGHT_TO_LEFT      8    // Right->Left, Right->Right
#define MIXCROSSCAPS_LEFT_TO_RIGHT      0x10 // Left->Left, Left->Right
#endif

#define  STUDIO_FEATURE_MONITOR_CODEC   D0
#define  STUDIO_FEATURE_HI_GAIN_AUX     D1
#define  STUDIO_FEATURE_HI_GAIN_CD      D2
#define  STUDIO_FEATURE_MONITOR_RECORD  D3   // UNCOMPRESSED

#define OUT_AMPLIFIER           0
#define OUT_PCM                 1

#define _LEFT                   1
#define _RIGHT                  2

#define _BASS                   0
#define _TREBLE                 1


#define MV_508_ADDRESS  D7
#define MV_508_INPUT    D4
#define MV_508_SWAP     D6
#define MV_508_BASS     (D0+D1)
#define MV_508_TREBLE   (D2)
#define MV_508_EQMODE   (D2+D0)

#define MV_508_LOUDNESS D2
#define MV_508_ENHANCE  (D1+D0)

/// DEFINES FOR SERIAL MIXER
#define NATIONAL_SELECTMUTE_REG 0x40
#define NATIONAL_LOUD_ENH_REG   0x41
#define NATIONAL_BASS_REG       0x42
#define NATIONAL_TREB_REG       0x43
#define NATIONAL_LEFT_VOL_REG   0x44
#define NATIONAL_RIGHT_VOL_REG  0x45
#define NATIONAL_MODESELECT_REG 0x46

#define NATIONAL_COMMAND        D7
#define NATIONAL_LOUDNESS       D0
#define NATIONAL_ENHANCE        D1

#define SERIAL_MIX_LEVEL        D0
#define SERIAL_MIX_CLOCK        D1
#define SERIAL_MIX_STROBE       D2
#define SERIAL_MIX_MASTER       D4
#define SERIAL_MIX_REALSOUND    D6
#define SERIAL_MIX_DUALFM       D7


// FILTER_REGISTER
#define fFIdatabits            0x1f          //      00011111B  filter select and decode field bits
#define fFImutebits            D5            // filter mute field bit
#define fFIpcmbits             (D7+D6)       // 11000000B  filter sample rate field bits
#define bFImute                D5            // filter mute bit
#define bFIsrate               D6            // filter sample rate timer mask
#define bFIsbuff               D7            // filter sample buffer counter mask

#define FILTERMAX              6             // six possible settings

#define FILTER_MUTE             0            // mute - goes to PC speaker
#define FILTER_LEVEL_1          1            // 20hz to  2.9khz
#define FILTER_LEVEL_2          2            // 20hz to  5.9khz
#define FILTER_LEVEL_3          3            // 20hz to  8.9khz
#define FILTER_LEVEL_4          4            // 20hz to 11.9khz
#define FILTER_LEVEL_5          5            // 20hz to 15.9khz
#define FILTER_LEVEL_6          6            // 20hz to 17.8khz


/// SLAVE_MODE_READ BITS
#define SLAVE_MODE_OPL3         D2
#define SLAVE_MODE_16           D3

// DEFINES FOR IO_CONFIG_1
#define JOYSTICK_ENABLE    D6
#define WARM_BOOT_RESET    D7
