/******************************************************************************
* (c) Copyright Voyetra Technologies 1990-1993.  All rights reserved
*     Voyetra Technologies
*     5 Odell Plaza
*     Yonkers, NY 10701
*     Tel: 914-966-0600
******************************************************************************/

#define SAPI_OPL3               9
#define BASE_FM_ADDRESS         0x388
#define OTHER_HALF_OFF          2
#define SAPI_REV                'GM-1.40'
#define SAPI_REV_NUM            140
#define SAPI_DATE               '7/30/92'
#define NUMBER_OF_BUILT_IN_VOICES       128
#define DEF_PERCUSSION_CHANNEL  (16-1)
#define PERCUSSION_CHANNEL      percussion_channel
#define DEF_PERC_MODE           1
#define MIN_PGM_FOR_CTRL        126

/***************** DEFINES FOR POSSIBLE STATES OF SYSEX PARSER ********/

#define SYSEX_IDLE              0
#define NOT_SURE                1
#define WAIT_OPCODE             2
#define WAIT_PGM                3
#define ACCEPT_DATA             4
#define XMIT_HEADER             5
#define XMIT_PATCH              6
#define XMIT_EOX                7

#define WAIT_TIMING_LONG        20
#define WAIT_COMMAND            22

/******************** DEFINES FOR SYSEX RECIPIENT *********************/

#define RX_NOBODY               0
#define RX_VOYETRA              1
#define RX_IBM                  2
#define RX_MEDIA_VISION         3

/******************** DEFINES FOR DIFFERNT TYPES OF MIDI EVENTS *******/

#define MTYPE_NOTE_OFF                  0       /* 80 */
#define MTYPE_NOTE_ON                   1       /* 90 */
#define MTYPE_POLY_PRESS                2       /* A0 */
#define MTYPE_CONTROL                   3       /* B0 */
#define MTYPE_PROGRAM                   4       /* C0 */
#define MTYPE_CHAN_PRESS                5       /* D0 */
#define MTYPE_PITCH_WHEEL               6       /* E0 */

#define MTYPE_SYSEX                     7       /* F0 */
#define MTYPE_MTC                       8       /* F1 */
#define MTYPE_SONG_POS                  9       /* F2 */
#define MTYPE_SONG_SELECT               10      /* F3 */
#define MTYPE_UNDEF_F4                  11      /* F4 */
#define MTYPE_UNDEF_F5                  12      /* F5 */
#define MTYPE_TUNE_REQ                  13      /* F6 */
#define MTYPE_EOX                       14      /* F7 */

#define MTYPE_CLOCK                     15      /* F8 */
#define MTYPE_UNDEF_F9                  16      /* F9 */
#define MTYPE_START                     17      /* FA */
#define MTYPE_CONTINUE                  18      /* FB */
#define MTYPE_STOP                      19      /* FC */
#define MTYPE_UNDEF_FD                  20      /* FD */
#define MTYPE_ACTIVE_SENSE              21      /* FE */
#define MTYPE_RESET                     22      /* FF */

/*****************************************************/

#define NUMBER_OF_CHANNELS              16

/*********** CHANNEL_ENTRY STRUCTURE *******************/
/*********** USED TO KEEP TRACK OF A MIDI CHANNEL ******/

typedef struct
    {
    char        program;        // Last MIDI program change received on this channel
                                // Tells what timbre to use with next notes played on this channel
    char        volume;         // Last MIDI volume message.
    unsigned    bender;         // Last pitch bend message.  Used to determine note pitches
    char pan;                   // Last MIDI pan message value
    char sus_pedal;             // Current state of the Damper (sustenuto) pedal
    } CHANNEL_ENTRY;

/********* VOICE_STATUS_ENTRY STRUCTURE *******************/
/* NOTE: in this case, a voice is:
 *      a 4 op combination in the 2 op driver
 */
typedef struct
    {
    BYTE        cur_pitch;      // pitch, in midi note number, of this voice
    BYTE        cur_chan;       // midi channel that triggered this voice.
                                //  this is used often, especially by for_all_ops_on_channel,
                                //  when you need to do something on a channel basis.
    } VOICE_STATUS_ENTRY;


/**************** MISC DEFINED FOR FM CHIPS *****************/
#define MY_BEST_BD_PITCH                CHIP_MID_C

        /* SYSEX message defines */

#define PATCH_NAME_LEN                  16
#define PATCH_PAD_LEN                   4
#define EXTRA_DATA_LENGTH               0
#define PATCH_LENGTH                    (4 * nbLocParam + EXTRA_DATA_LENGTH)
#define OLD_PATCH_LENGTH                (4 * OLD_LOC_PARAM + PATCH_NAME_LEN + PATCH_PAD_LEN)

/*************** some defined for FM sysex parsing ***************/

#define SX_HEADER_SIZE                  6
                                /* subscrips into SX_HEADER */
#define SX_RECIPIENT1                   1
#define SX_RECIPIENT2                   2
#define SX_RECIPIENT3                   3
#define SX_OPCODE                       4
#define SX_PGM_NUM                      5

#define SX_TIMING_SHORT                 SX_OPCODE
#define SX_TIMING_LONG_LSB              5
#define SX_TIMING_LONG_MSB              6
#define SX_COMMAND                      5


#define SX_CMD_TIMING                   1
#define SX_CMD_TEMPO                    2
#define SX_CMD_SOUND_SELECT             3
#define SX_CMD_VOLUME                   7
#define SX_CMD_BALANCE                  8
#define SX_CMD_MASTER_VOLUME            9

                                /* masks for types of opcodes */
#define SX_DUMP                         1
#define SX_COMPRESSED                   2

#define THIS_FORMAT                     4       // msgs 4..7 are for opl 3

#define OP_IBM_TIMING_COMPRESSION_LONG  1
#define OP_IBM_SOUND_GENERATOR_COMMANDS 2
#define OP_IBM_DEVICE_DRIVER_CONTROL    3
#define OP_IBM_DEVICE_DRIVER_QUERY      4
#define OP_IBM_DEVICE_DRIVER_RESPONSE   5
#define OP_IBM_TIMBRE_PARAMETER         6
#define OP_IBM_TIMING_COMPRESSION_SHORT 7       // or greater

/********* STRUCTURE DEFINES FOR VOICE ALLOCATION FUNCTIONS **********/

/* OFF_ENTRY STRUCTURE
 *
 * used to make pseudo linked lists from arrays
 * these pseudo lists are character arrays where the character is
 * the next array position in the list.  There is no data stored
 * in the list, as the array position is the data.
 */
typedef struct
    {
    signed char next;
    }  OFF_ENTRY;

typedef struct
    {
    int freelist;
    int usedlist;
    int usedcount;
    int lastused;
    OFF_ENTRY * data;
    VOICE_STATUS_ENTRY * op_stats;
    } ALLOC_Q, near * NPALLOC_Q;

/***************** DERIVE DEFINE FROM DRUM_PATCH_LEN *************/

#define DRUM_PATCH_LEN  (2 * nbLocParam)
