/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* parse.c - Parse config.sys command line arguments
*
* DESCRIPTION:
* This code will be discarded from the device driver after it is
* invoked.  Parameters switches may be upper or lower case.
* The '-' character is not supported.
*
* MVPRODD.SYS Parameters:
*    /S:X,XXX,X  // SoundBlaster { enable,base addr,IRQ }
*    /N:<name>   // allows naming of driver /N:MVIS
*    /T:X        // /T:1 = use on-board oscillator for OPL-3 (default /T:0)
*    /D:X        // sets the DMA channel
*    /Q:X        // sets the IRQ channel
*    /I:X        // also sets the IRQ channel
*    /B:XXX      // HEX Base board I/O location ((DEFAULT: /B:388)
*    /W:X        // If /W:1 enables warm boot reset (DEFAULT /W:0)
*    /M:X        // MPU {enabled,base addr,IRQ}
*    /F:X        // FM Synth /F:1 enabled by default
*    /J:X        // /J:1 cause Joystick to be enabled, J:0 is default
*    /V          // Sets driver Verbose option
*
*/

ULONG ParseArgs (PUCHAR args)
{
   extern DEVHDR MMDevHdr;
   USHORT  i, usPort;
   PGLOBAL pGlobal;                     // ptr to global struct

   pGlobal = &GlobalTable;

   while (*(args)++ != ' ')             // skip driver file name
      ; // NULL statement

   while (*args != 0)
      {
      while (*(args)++ != '/')          // skip non slash
         if (*args == 0)
            break;                      // No more parms

      switch (*args)
         {
         /*
         ** GET UNIQUE NAME OF DEV HDR
         */
         case 'N':      // unique names /N:MVIS
         case 'n':
            args++;             // skip over 'N'
            if (*args == ':')   // skip over colon
               args++;
            for (i=0; i<sizeof(DevHdr[1].DHname-1); i++)  // clear default name
               DevHdr[1].DHname[i] = ' ';
            for (i=0; i<sizeof(DevHdr[1].DHname-1); i++)
               {
               if ((*args == 0) || *args == 0x0d || (*args == 0x0a))
               break;
               DevHdr[1].DHname[i] = *(args)++; // get 1st digit
               }
            usNumHeaders = 2;     // so we know how many hdrs to register
            break;

         case 'T':      //T:1 means use auxillary oscillator
         case 't':
            args++;     // skip over 'T'
            if (*args == ':')   // skip over colon
               args++;
            if (*args == '1')
               fAlternateOscillator=TRUE;
            break;

         case 'F':      //F:0 means disable FM synth chips
         case 'f':
            args++;     // skip over 'F'
            if (*args == ':')           // skip over colon
               args++;
            if (*args == '0')
               {
               fDisableFMSynth=TRUE;
               #ifdef INIT_MONITOR
               StringOut("ParseArgs: Disabling FM synth registers");
               #endif
               }
            break;

         case 'J':      //J:0 means disable joystick
         case 'j':
            args++;     // skip over 'J'
            if (*args == ':')   // skip over colon
               args++;
            if (*args == '0')
               {
               fDisableJoystick=TRUE;
               #ifdef INIT_MONITOR
               StringOut("ParseArgs: Disabling Joystick");
               #endif
               }
            break;

         case 'W':   // W:1 means enable warm boot reset
         case 'w':
            args++;     // skip over 'W'
            if (*args == ':')   // skip over colon
               args++;
            if (*args == '1')
               {
               #ifdef INIT_MONITOR
               fWarmBootReset=TRUE;
               StringOut("ParseArgs: Warm Boot Reset enabled.");
               #endif
               }
            break;

         case 'D':              // DMA channel
         case 'd':
            args++;     // skip over 'D'
            if (*args == ':')   // skip over colon
               args++;
            AdapterInfo.usDMALevel =*(args)++ & 0x000f; // DMA limit is 7
            #ifdef INIT_MONITOR
            PrintfOut("ParseArgs: DMA selected =%d",AdapterInfo.usDMALevel);
            #endif
            break;

         case 'B':      // Board I/O location
         case 'b':
            args++;     // skip over 'B'
            if (*args == ':')   // skip over colon
               args++;
            AdapterInfo.range[0].ulPort=0;

            usPort=0;
            while ((*args != ' ') && (*args) && (*args != '/'))
               {
               usPort<<=4;
               usPort+=(*args & 0x000f);        // move in a digit
               if (*args >'A')
                  usPort+=9;                    // converts A-F to 10 -15
               args++;
               }
            AdapterInfo.range[0].ulPort=usPort;
            #ifdef INIT_MONITOR
            PrintfOut ("ParseArgs: I/O base requested =%lx",
                       AdapterInfo.range[0].ulPort);
            #endif

            if (VerifyLegalAddress((WORD) AdapterInfo.range[0].ulPort))
               fUserRequestPASLocation=TRUE;  // User has requested a location
            else
               {
               #ifdef DEBUG_CHK
               StringOut ("Requested Port Address out of range.  Resetting.");
               #endif
               AdapterInfo.range[0].ulPort=0x388;
               }

            #ifdef INIT_MONITOR
            PrintfOut ("ParseArgs: I/O base selected =%lx",
                       AdapterInfo.range[0].ulPort);
            #endif
            break;

         case 'S':      // SoundBlaster configuration
         case 's':
            args++;     // skip over 'S'
            if (*args == ':')   // skip over colon
               args++;

            // Get SB enable, disable
            fSBEnabled = *(args)++;     // get 1st digit
            fSBEnabled -= '0';          // make it a 0 or non zero

            if (!fSBEnabled)
               {
               SBAdapterInfo.range[0].ulPort=0;
               SBAdapterInfo.usIRQLevel=0;
               break;
               }

            while (*args == ',')        // skip comma delimiter
               args++;

            usPort=0;
            while ((*args != ' ') && (*args) && (*args != '/'))
               {
               usPort<<=4;
               usPort+= (*args & 0x000f);       // move in a digit
               if (*args >'A')
                  usPort+=9;                    // converts A-F to 10 -15
               args++;
               }
            SBAdapterInfo.range[0].ulPort=usPort;

            if ((SBAdapterInfo.range[0].ulPort< 0x200) ||
                (AdapterInfo.range[0].ulPort> 0x300)   ||
                (SBAdapterInfo.range[0].ulPort & 0xf))
               {
               #ifdef DEBUG_CHK
               StringOut("Requested SB Port Address out of range.  Resetting.");
               #endif
               SBAdapterInfo.range[0].ulPort=0x220;
               }

            #ifdef INIT_MONITOR
            PrintfOut ("ParseArgs: SB I/O base selected =%lx",
                       SBAdapterInfo.range[0].ulPort);
            #endif
            break;

            /*
            ** This would be a good place to
            ** initialize Sound Blaster DMA and IRQ regs.
            */

         case 'Q':      // Interrupt  (DOS driver uses this letter)
         case 'q':
         case 'I':      // Interrupt level
         case 'i':
            AdapterInfo.usIRQLevel=0;
            args++;     // skip over 'I'
            if (*args == ':')   // skip over colon
               args++;
            if (*args == '0')
               args++;
            else
               if (*args == '1')
                  {
                  args++;
                  AdapterInfo.usIRQLevel =10;
                  }
                  AdapterInfo.usIRQLevel += (*(args)++ & 0x0007);
                  AdapterInfo.usIRQLevel &= 0x0f;

            switch (AdapterInfo.usIRQLevel)
               {
               case 2:              // suppported IRQ's
               case 3:
               case 4:
               case 5:
               case 6:
               case 7:
               case 10:
               case 11:
               case 12:
               case 14:
               case 15:
                  break;

               default:
                  AdapterInfo.usIRQLevel = -1;
               }
            break;

         } // end switch
      }; // end while
   return (NO_ERROR);
}
