/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* outchip.c - FM service routine to write to FM chip.
*
* DESCRIPTION:
* Provides lowest level routines in MIDI FM operation.
* The routines herein used to be part of outchip.asm.
* Outchip.asm did not allow for I/O relocation on PAS 16
* so these routines are put here.
*
*/

#define INCL_DOSINFOSEG
#define INCL_BASE
#include <os2.h>

#include        <os2medef.h>
#include        <audio.h>
#include        <ssm.h>
#define         DRV_16
#include        "os2mixer.h"
#include        "mvprodd.h"
//#include      "cdevhlp.h"
#include        "pasdef.h"
#include        "findpas.h"     // hardware detection
#include        "globals.h"
//#include      "patch.h"
#include        "proto.h"       // Function declarations
//#include      "debug.h"
//#include      "commdbg.h"

                                        //--------------------------- PASX_IN -
BYTE near PASX_IN (WORD port)
{
   BYTE bRetval;

   port ^= pf.ProCard[gwBoardIndex].wTranslateCode;     // I/O translation

   _asm {
        mov     dx,port
        in      al,dx
        mov     bRetval,al
        }
   return bRetval;
}

                                        //-------------------------- PASX_OUT -
void near PASX_OUT (WORD port, char data)
{
   port ^= pf.ProCard[gwBoardIndex].wTranslateCode;      // I/O translation

   _asm {
        mov     dx,port
        mov     al,data
        out     dx,al
        }
}

/*                                      -------------------------- SndOutput1 -
** Set the register at address 'addr' to the value 'data'.
** Also perform 'data register-to-data register' write delay.
*/
void near SndOutput1 (WORD addr, WORD data)
{
   WORD wXlate=pf.ProCard[gwBoardIndex].wTranslateCode;      // I/O translation

   if (fDisableFMSynth)
      return;

   _asm {
        mov     dx, FM_BASE             // 0x388
        xor     dx, wXlate              // translate address
        mov     ax, addr                // get FM chip internal address
        out     dx, al
        in      al, dx                  // delay
        in      al, dx                  // delay
        in      al, dx                  // delay
        inc     dx                      // get data reg. of sound chip
        mov     ax, data                // get data to store
        out     dx, al
        dec dx
        in         al, dx               // delay
        in         al, dx               // delay
        }
}

/*                                      ------------------------- SndOpl3_2_1 -
** Set the register at address 'addr' to the value 'data'.
** Also perform 'data register-to-data register' write delay.
** This function set the other half of the OPL-3 chip
*/
void near SndOpl3_2_1 ( WORD addr, WORD data)
{
   if (fDisableFMSynth)
      return;

   PASX_OUT (OPL3_BASE,(BYTE) addr);
   PASX_IN  (OPL3_BASE);  // delay
   PASX_IN  (OPL3_BASE);  // delay
   PASX_IN  (OPL3_BASE);  // delay

   PASX_OUT (OPL3_BASE+1, (BYTE)data);
   PASX_IN  (OPL3_BASE);  // delay
   PASX_IN  (OPL3_BASE);  // delay
}
                                        //--------------------------- IN_STAT -
unsigned int IN_STAT (void)
{
   return ((WORD) PASX_IN(FM_BASE));
}
