/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* os2mixer.h - Multimedia Mixer Software Development Kit Include File
*
******************************************************************************/

/*
** OS/2 ADDITIONS
*/

#ifndef  HIWORD
#define  HIWORD(x)              HIUSHORT(x)
#define  LOWORD(x)              LOUSHORT(x)
#endif

#ifdef  DRV_16
typedef WORD FAR *LPWORD;
#else
typedef WORD *LPWORD;
#endif

#ifdef  DRV_16
typedef DWORD FAR *LPDWORD;
#else
typedef DWORD *LPDWORD;
#endif


#define MIXER_CATEGORY          0x81    // Arbitrary mixer category value
#define MixOpen_FUNCTION        0x0     // driver's MIXOPEN function


typedef struct
   {
   DWORD wParam1;
   DWORD dwParam1;
   DWORD dwParam2;
   DWORD dwParam3;
   DWORD dwParam4;
   DWORD dwRetVal;
   } MIXPARM;
typedef MIXPARM FAR *LPMIXPARM;

#ifndef NIL
#define NIL     0
#endif


/*
** This structure maintains current state of mixer
*/
#define MAXPNAMELEN     0x40
#define MIXSTATEVER     0x101
#define MAX_INPUTS      8               // Version 1 maximum inputs
#define MAX_OUTPUTS     2               // Version 1 maximum outputs

typedef struct linestatus_tag
   {
   WORD  wNumber;             // This line's ordinal number in the mixer
   WORD  wNumSoftPatches;     // number of software patches available
   WORD  wPatchNumber;        // the number of the patch currently in use
   WORD  wNumChannels;        // number of channels (1=mono, 2=stereo)
   WORD  wDeviceNumber;       // range (0-xxxGetNumDevs()) if appropriate
   WORD  wReserved;
   DWORD dwDeviceType;        // type of device patched to the input
   DWORD dwConnections;       // show lines connected
   DWORD dwSupport;           // supported functionality (MIXLINEINFO)
   DWORD dwAssociation;       // HIWORD=type, LOWORD=device

   DWORD dwVolume;            // volume control
   DWORD dwAutoLevel;         // Auto Level Control
   DWORD dwBMT;               // B-M-T equalization
   DWORD dwCrossover;         // crossover
   DWORD dwLoudness;          // loudness equalization
   DWORD dwMute;              // silence switch
   DWORD dwReverb;            // reverb
   DWORD dwStereoEnhance;     // stereo enhance
   DWORD dwCustom1;           // custom effect #1
   DWORD dwCustom2;           // custom effect #2
   DWORD dwCustom3;           // custom effect #3
   DWORD dwConnectionsPossible;
   DWORD dwReserved2;

   char  szIOname[MAXPNAMELEN]; // line name
   char  szPname[MAXPNAMELEN];  // patch name
        } LINESTATUS;

#ifdef  DRV_16
typedef LINESTATUS FAR *LPLINESTATUS;
#else
typedef LINESTATUS *LPLINESTATUS;
#endif


/*
** The MIXERSTATE structure is subject to change.
** Drivers should detect version number changes and
** act accordingly.
*/
typedef struct MVmixer_tag
   {
   WORD wSize;
   WORD wVersion;
   WORD wMid;           // manufacturer id
   WORD wPid;           // product id
   WORD wMixerNumber;
   WORD wNumInputs;                                                                       // define's array sizes
   WORD wNumOutputs;

   LINESTATUS LineInStatus[MAX_INPUTS];
   LINESTATUS LineOutStatus[MAX_OUTPUTS];

   } MIXERSTATE;


#ifdef  DRV_16
typedef MIXERSTATE FAR *LPMIXERSTATE;
#else
typedef MIXERSTATE *LPMIXERSTATE;
#endif

/*
** With version 1.01, the manufacturer and produce ID numbers
** are included for identifying the creator of the mixer state
** when stored in a file.  These did not exist in version 1.00
*/


typedef WORD    HMIXER;
typedef WORD    VERSION;
#ifdef  DRV_16
typedef HMIXER FAR *LPHMIXER;
#else
typedef HMIXER *LPHMIXER;
#endif


#define BMTBASS(dwValue)        (LOBYTE(HIWORD(dwValue)))
#define BMTMIDR(dwValue)        (HIBYTE(LOWORD(dwValue)))
#define BMTTREB(dwValue)        (LOBYTE(LOWORD(dwValue)))

typedef struct mixercaps_tag
   {
   WORD    wMid;                 // manufacturer id
   WORD    wPid;                 // product id
   VERSION vDriverVersion;       // version of the driver
   char    szPname[MAXPNAMELEN]; // product name (NULL terminated string)
   WORD    wInputs;              // number of inputs  supported.
   WORD    wOutputs;             // number of outputs supported.
   WORD    wNumInputPatches;     // number of input patches supported.
   WORD    wNumOutputPatches;    // number of output patches supported.
   DWORD   dwSupport;            // supported functionality
   DWORD   dwReserved;
   } MIXERCAPS;


#ifdef DRV_16
typedef MIXERCAPS FAR *LPMIXERCAPS;
#else
typedef MIXERCAPS *LPMIXERCAPS;
#endif
#define MIXERCAP_SOFTPATCHSWITCH                0x0001  // supports some software patching
#define MIXERCAP_MANUALPATCHSWITCH      0x0002  // supports some manual   patching

typedef struct mixerlineinfo_tag
   {
   WORD    wNumber;               // This line's ordinal number in the mixer
   DWORD   dwDeviceType;          // type of device patched to the input
   WORD    wNumSoftPatches;       // number of software patches available
   WORD    wPatchNumber;          // number of device currently patched
   WORD    wNumChannels;          // number of channels on input
                                  // (1=mono, 2=stereo)
   DWORD   dwSupport;             // supported functionality (MIXLINEINFO)
   DWORD       dwAssociation;     // HIWORD=type, LOWORD=device
   DWORD   dwConnectionsPossible; // lines connectable to
   char    szIOname[MAXPNAMELEN]; // input name (eg "Aux Connector"
   char    szPname[MAXPNAMELEN];  // patch name (eg "Casio Synthesizer")
   } MIXERLINEINFO;


#ifdef DRV_16
typedef MIXERLINEINFO FAR *LPMIXERLINEINFO;
#else
typedef MIXERLINEINFO *LPMIXERLINEINFO;
#endif

typedef struct patchinfo_tag
   {
   WORD   wPatchNumber;         // This patch's ordinal number in the mixer
   DWORD  dwDeviceType;         // type of device
   DWORD  dwLineNumbers;        // bit-field, lines connectable to
   char   szPname[MAXPNAMELEN]; // patch name (NULL terminated string)
   DWORD  dwAssociation;        // HIWORD=type, LOWORD=device
   DWORD  dwReserved1;          // reserved for future use
   } PATCHINFO;


#ifdef DRV_16
typedef PATCHINFO FAR *LPPATCHINFO;
#else
typedef PATCHINFO *LPPATCHINFO;
#endif
typedef struct
   {
   DWORD dwInputDeviceType;
   DWORD dwOutputDeviceType;
   DWORD dwInputAssociation;
   DWORD dwOutputAssociation;
   } DEVICECONNECT;


#ifdef DRV_16
typedef DEVICECONNECT FAR *LPDEVICECONNECT;
#else
typedef DEVICECONNECT *LPDEVICECONNECT;
#endif

typedef struct
   {
   DWORD   dwDeviceType;                        // aka technology
   WORD    wNumDevices;                         // return value: # lines with device found
   DWORD   dwLines;                             // return value: line map
   DWORD   dwAssociation;                       // for exclusive search
   } DEVICELINES;



#ifdef DRV_16
typedef DEVICELINES FAR *LPDEVICELINES;
#else
typedef DEVICELINES *LPDEVICELINES;
#endif

/*
** For         development only:
** We should register these Window messages:
**         WM_MIX_PATCHCHANGED
**         WM_MIX_CONNECTIONCHANGED
**         WM_MIX_CONTROLCHANGED
**         WM_MIX_MUTESTATUSCHANGED
** Register the functions using
** wmPatchChanged=RegisterWindowMessage("WM_MIX_PATCHCHANGED");
** wmConnectionChanged=RegisterWindowMessage("WM_MIX_CONNECTIONCHANGED");
** wmControlChanged=RegisterWindowMessage("WM_MIX_CONTROLCHANGED");
** wmMixStatusChanged=RegisterWindowMessage("WM_MIX_MUTESTATUSCHANGED");
*/

// flags for MIXERLINEINFO dwSupport field
#define MIX_SUPPORT_VOLUME        0x00000001   // supports volume control
#define MIX_SUPPORT_LRVOLUME      0x00000002   // separate left-right volume control
#define MIX_SUPPORT_ALC           0x00000004   // supports Auto Level Control
#define MIX_SUPPORT_BMT           0x00000008   // supports B-M-T equalization
#define MIX_SUPPORT_CROSSOVER     0x00000010   // supports crossover change
#define MIX_SUPPORT_LOUDNESS      0x00000020   // supports loudness equalization
#define MIX_SUPPORT_MUTE          0x00000040   // supports channel mute
#define MIX_SUPPORT_REVERB        0x00000080   // supports reverb
#define MIX_SUPPORT_STEREOENHANCE 0x00000100   // supports stereo enhance
#define MIX_SUPPORT_CUSTOM1       0x00000200   // supports custom effect #1
#define MIX_SUPPORT_CUSTOM2       0x00000400   // supports custom effect #2
#define MIX_SUPPORT_CUSTOM3       0x00000800   // supports custom effect #3
#define MIX_SUPPORT_SOFTPATCH     0x40000000   // supports software patching
#define MIX_SUPPORT_MANUALPATCH   0x80000000   // supports manual patching

// PATCH TYPES for MIXERLINEINFO, PATCHINFO

#define MIX_NO_CONNECT            0x00000000
#define MIX_CD_AUDIO              0x00000001  // match MMWIN AUXCAPS_XXX defines
#define MIX_AUXILLARY             0x00000002  // for AUXCAPS wTechnology field
#define MIX_MICROPHONE            0x00000004
#define MIX_VIDEOTAPE             0x00000008
#define MIX_VIDEODISK             0x00000010
#define MIX_INSTRUMENT            0x00000020
#define MIX_WAVE                  0x00000040
#define MIX_TV_TUNER              0x00000080
#define MIX_RADIO_TUNER           0x00000100
#define MIX_PHONOGRAPH            0x00000200
#define MIX_PC_INT_SPKR           0x00000400
#define MIX_ANALOG_AUDIO_TAPE     0x00000800
#define MIX_DIGITAL_AUDIO_TAPE    0x00001000
#define MIX_TELEPHONE             0x00002000
#define MIX_MIXER                 0x00004000
#define MIX_EQUALIZER             0x00008000
#define MIX_AMPLIFIER             0x00010000
#define MIX_OTHER                 0x08000000
#define MIX_HARD_WIRED            0x20000000    // hard-wired to one line
#define MIX_USER_CONNECTED        0x40000000    // requires user to hook it up
#define MIX_LISTENER              0x80000000    // audio devices that accept input
                                                                                                                        // (ie amp, pcm record, etc)

// ERROR MESSAGES

#define MIXERR_BASE             512

#define MIXERR_NOERR            0
#define MIXERR_INVALHANDLE      MIXERR_BASE+0
#define MIXERR_INVALINPUT       MIXERR_BASE+1 // contiguous
#define MIXERR_INVALOUTPUT      MIXERR_BASE+2 // contiguous
#define MIXERR_INVALIDSTATE     MIXERR_BASE+3
#define MIXERR_INVALPATCH       MIXERR_BASE+4 // out of range or disabled
#define MIXERR_PATCHMISMATCH    MIXERR_BASE+5
#define MIXERR_PATCHINUSE       MIXERR_BASE+6
#define MIXERR_NOTSUPPORTED     MIXERR_BASE+7
#define MIXERR_FADEINPROGRESS   MIXERR_BASE+8
#define MIXERR_INVALCONNECTION  MIXERR_BASE+10
#define MIXERR_INVALSTRUCTPTR   MIXERR_BASE+11
#define MIXERR_BADMIXERPTR      MIXERR_BASE+12
#define MIXERR_ILLEGALSIZE      MIXERR_BASE+13

// Association Types
// The association types defined below are base values.  Add 0x0 thru 0xf
// to these base values to indicate the device number that is associated.
// New candidates for association types must fulfill the following criteria:
//
//              1) The device must produce audio output.
//
//              2) The device must be software controllable.
//
//              3) The device must either have a         low-level driver
//              or an MCI driver.
//
#define AT_NO_INFO      0x0000  // No association info available
// low-level drivers
#define AT_waveOut      0x0010  // internal pcm hardware
#define AT_midiOut      0x0020  // internal MIDI device
// MCI drivers
#define AT_mciCD        0x1010  // internal and external CD devices
#define AT_mciVDP       0x1020  // external VideoDisk Player
#define AT_mciSEQ       0x1030  // external MIDI device
#define AT_mciWAVE      0x1040  // external WAVE  device
#define AT_mciDAT       0x1050  // external Digital Audio Tape device (it could happen)
#define AT_mciVCR       0x1060  // Panasonic AG-1960 for example
#define AT_mciTV        0x1070  //      TV tuner
#define AT_mciTUNER     0x1080  // AM/FM tuner
#define AT_mciPHONO     0x1090  // we may never live to see such an animal
#define AT_mciAAT       0x10A0  // external Analog Audio Tape device (it has happened)
#define AT_mciMIX       0x10B0  // possibility of mixer chaining!
#define AT_mciEQU       0x10C0  // equalizer controllable by software
#define MIX_mciAMP      0x10D0  // they exist, only a driver is needed

// general mixer macros
#define BOTH    (MIX_SUPPORT_VOLUME|MIX_SUPPORT_LRVOLUME)
#define MONO    1
#define STEREO  2

#define MIX_DEVICESHORTNAME     6
#define MIX_FADE_OVERRIDE       1

// MIX Messages
#define MM_STATE_FADE_COMPLETED 1

#define MAX_MIX_MESSAGES       64       // queue size of mixer change messages


// Add to HIBYTE of wLineNum parameters
// and to the wPatchNum parm of mixGetPatchInfo
#define MIX_INPUT       0
#define MIX_OUTPUT      1

// GENERAL FUNCTIONS

WORD APIENTRY mixGetNumDevs(void);
WORD APIENTRY mixGetDevCaps(WORD wDeviceID,LPMIXERCAPS lpCaps,WORD wSize);
WORD APIENTRY mixOpen(LPHMIXER lphMixer,WORD wDeviceID,DWORD dwFlags);
WORD APIENTRY mixClose(HMIXER hMixer);
WORD APIENTRY mixGetErrorText(WORD wError,LPSTR lpText,WORD wSize);

// MIXER PRESET FUNCTIONS
WORD APIENTRY mixMute(WORD wFlags);
WORD APIENTRY mixReset(HMIXER hMixer);
WORD APIENTRY mixGetState(HMIXER hMixer,LPMIXERSTATE lpMixer, WORD wSize);
WORD APIENTRY mixSetState(HMIXER hMixer,LPMIXERSTATE lpMixer, WORD wSize,DWORD dwTime,DWORD dwFlags, DWORD dwCallback);
WORD APIENTRY mixGetFadeStatus(HMIXER hMixer,DWORD * lpdwTime);

// INPUT-TO-OUTPUT CONNECTION FUNCTIONS
WORD APIENTRY mixGetConnections(HMIXER hMixer,WORD wLine, LPDWORD lpdwConnections);
WORD APIENTRY mixSetConnections(HMIXER hMixer,WORD wLine, DWORD dwConnections);

// LINE FUNCTIONS
WORD APIENTRY mixGetControl(HMIXER hMixer, WORD wLineNum, DWORD dwControl, LPDWORD lpdwSetting);
WORD APIENTRY mixSetControl(HMIXER hMixer, WORD wLineNum, DWORD dwControl, DWORD dwSetting);
WORD APIENTRY mixGetLineInfo(HMIXER hMixer, WORD wLineNum, LPMIXERLINEINFO lpInfo,WORD wSize);

// PATCH FUNCTIONS
WORD APIENTRY mixGetPatch(HMIXER hMixer,WORD wLineNum, LPWORD lpwPatchNum);
WORD APIENTRY mixSetPatch(HMIXER hMixer,WORD wLine,WORD wPatchNum,LPPATCHINFO lpPatch,WORD wSize);
WORD APIENTRY mixGetPatchInfo(HMIXER hMixer,WORD wPatchNum,LPPATCHINFO lpInfo,WORD wSize);

// DEVICE-TYPE ORIENTED FUNCTIONS
WORD APIENTRY mixGetDeviceName(DWORD dwDeviceType, LPSTR lpDeviceName,WORD wSize);
WORD APIENTRY mixGetDeviceLines(HMIXER hMixer,LPDEVICELINES lpDeviceLines);
WORD APIENTRY mixSetDeviceConnections(HMIXER hMixer,LPDEVICECONNECT lpDeviceConnect);
WORD APIENTRY mixGetDeviceConnections(HMIXER hMixer,LPDEVICECONNECT lpDeviceConnect);

// TEMPORARY DEVICE LOAD ENTRY
void APIENTRY mixWakeUp(void);

// flags for wCrossoverCaps
#ifndef MIXCROSSCAPS_NORMAL_STEREO
#define MIXCROSSCAPS_NORMAL_STEREO   0x0000   // Left->Left, Right->Right
#define MIXCROSSCAPS_RIGHT_TO_BOTH   0x0001   // Right->Left, Right->Right
#define MIXCROSSCAPS_LEFT_TO_BOTH    0x0002   // Left->Left, Left->Right
#define MIXCROSSCAPS_REVERSE_STEREO  0x0004   // Left->Right, Right->Left
#define MIXCROSSCAPS_RIGHT_TO_LEFT   0x0008   // Right->Left
#define MIXCROSSCAPS_LEFT_TO_RIGHT   0x0010   // Left->Right
#endif


// destined for MMDDK:

#define MAXMIXDRIVERS 4         // max number of mixer device drivers we load


#define MIXDM_BASE             0x800
#define MIXDM_GETNUMDEVS       MIXDM_BASE+0
#define MIXDM_GETDEVCAPS       MIXDM_BASE+1
#define MIXDM_OPEN             MIXDM_BASE+2
#define MIXDM_CLOSE            MIXDM_BASE+3
#define MIXDM_RESET            MIXDM_BASE+4
#define MIXDM_GETSTATE         MIXDM_BASE+5
#define MIXDM_SETSTATE         MIXDM_BASE+6
#define MIXDM_GETCONNECTIONS   MIXDM_BASE+7
#define MIXDM_SETCONNECTIONS   MIXDM_BASE+8
#define MIXDM_GETDEVLINES      MIXDM_BASE+9
#define MIXDM_GETDEVCONNECTS   MIXDM_BASE+10
#define MIXDM_SETDEVCONNECTS   MIXDM_BASE+11
#define MIXDM_GETLINEINFO      MIXDM_BASE+12
#define MIXDM_GETCONTROL       MIXDM_BASE+13
#define MIXDM_SETCONTROL       MIXDM_BASE+14
#define MIXDM_GETPATCHINFO     MIXDM_BASE+15
#define MIXDM_GETPATCH         MIXDM_BASE+16
#define MIXDM_SETPATCH         MIXDM_BASE+17
#define MIXDM_SHUTDOWN         MIXDM_BASE+18
#define MIXDM_GETFADESTATUS    MIXDM_BASE+19
#define MIXDM_MUTE             MIXDM_BASE+20

#define MIXMUTE_TOGGLE         NULL
#define MIXMUTE_STATUS         1

#define MIXMUTESTATUS_MUTE     TRUE
#define MIXMUTESTATUS_NOMUTE   FALSE


#ifndef MMSYSERR_BASE                                   // added for OS/2
#define MMSYSERR_BASE          0
///#define MCIERR_BASE   256                            // note OS/2 and         use differnt constants


/****************************************************************************
                        General error return values
****************************************************************************/

/* general error return values */
#define MMSYSERR_NOERROR      0                    /* no error */
#define MMSYSERR_ERROR        (MMSYSERR_BASE + 1)  /* unspecified error */
#define MMSYSERR_BADDEVICEID  (MMSYSERR_BASE + 2)  /* device ID out of range */
#define MMSYSERR_NOTENABLED   (MMSYSERR_BASE + 3)  /* driver failed enable */
#define MMSYSERR_ALLOCATED    (MMSYSERR_BASE + 4)  /* device already allocated */
#define MMSYSERR_INVALHANDLE  (MMSYSERR_BASE + 5)  /* device handle is invalid */
#define MMSYSERR_NODRIVER     (MMSYSERR_BASE + 6)  /* no device driver present */
#define MMSYSERR_NOMEM        (MMSYSERR_BASE + 7)  /* memory allocation error */
#define MMSYSERR_NOTSUPPORTED (MMSYSERR_BASE + 8)  /* function isn't supported */
#define MMSYSERR_BADERRNUM    (MMSYSERR_BASE + 9)  /* error value out of range */
#define MMSYSERR_INVALFLAG    (MMSYSERR_BASE + 10) /* invalid flag passed */
#define MMSYSERR_INVALPARAM   (MMSYSERR_BASE + 11) /* invalid parameter passed */
#define MMSYSERR_LASTERROR    (MMSYSERR_BASE + 11) /* last error in range */


//////#define MCIERR_CUSTOM_DRIVER_BASE  (MCIERR_BASE+256)
#endif

#define MCIERR_MIX_NO_SUCH_DEVICE        MCIERR_CUSTOM_DRIVER_BASE+768
