/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Voyetra Technologies, 1990-1993                             */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*     Voyetra Technologies
*     5 Odell Plaza
*     Yonkers, NY 10701
*     Tel: 914-966-0600
*******************************************************************************
*
* namer.c - patch conversion routines
*
*/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include <meerror.h>
#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "parse.cdf"
#include "adlib.h"
#include "parse.ext"
#include "findpas.h"
#include "pasdef.h"
#include "proto.h"

#include "vapi.h"
#include "namedat.c"     /* output of dumpins.exe, along with patch.c */

/* an array big enough for the entire patch, name, and pad */
unsigned char expand_buf[OLD_PATCH_LENGTH] = { 0 };

/* the index into these arrays is the uncompressed value index */
/* in which byte of the compressed data is this value */
unsigned char cpres_index[OLD_LOC_PARAM] =
    {                           // Modulator, Carrier is index + 14
    1,       //KSL
    0,       //FREQ MUL
    4,       //FB
    2,       //ATT
    3,       //SUS LEV
    0,       //SSU SOUND
    2,       //DCY
    3,       //REL
    1,       //OUT LEV
    0,       //AM
    0,       //VIB
    0,       //KSR
    4,       //FM
    4 };     //Wave form

/* at which bit position is this val in the byte of compressed data */
unsigned char cpres_bits[OLD_LOC_PARAM] =
    {
    6,       //KSL
    0,       //FREQ MUL
    1,       //FB
    4,       //ATT
    4,       //SUS LEV
    5,       //SSU SOUND
    0,       //DCY
    0,       //REL
    0,       //OUT LEV
    7,       //AM
    6,       //VIB
    4,       //KSR
    0,       //FM usually set
    5,       //WAVE
    };

/* the bit masks used to extract each compressed value (2^n -1) */
unsigned char cpres_size[OLD_LOC_PARAM] =
    {
    3,       //KSL
    15,      //FREQ MUL
    7,       //FB
    15,      //ATT
    15,      //SUS LEV
    1,       //SSU SOUND
    15,      //DCY
    15,      //REL
    63,      //OUT LEV
    1,       //AM
    1,       //VIB
    1,       //KSR
    1,       //FM usually set
    7,       //WAVE
    };

#ifdef VOYETRA_SYSEX
void compress_patch(int patch)
{
register int i, index, shift, mask;
unsigned char * result = internal_patches[patch];

#pragma message("I must match compress in dump2.c")
for (i=0; i < PATCH_LENGTH; i++)
    result[i] = 0;

for (i=0; i < OLD_LOC_PARAM; i++)
    {
    index = cpres_index[i];
    shift = cpres_bits[i];
    mask = cpres_size[i];
    result[index + 0]                   |= (expand_buf[i +  0] & mask) << shift;
    result[index + nbLocParam]          |= (expand_buf[i + OLD_LOC_PARAM] & mask) << shift;
    result[index + 2*nbLocParam]        |= (expand_buf[i + 2*OLD_LOC_PARAM] & mask) << shift;
    result[index + 3*nbLocParam]        |= (expand_buf[i + 3*OLD_LOC_PARAM] & mask) << shift;
    }
   for (i=0; i < PATCH_NAME_LEN; i++)                           // copy name
      internal_names[patch][i] = expand_buf[4 * OLD_LOC_PARAM + i];
}

void expand_patch( int patch )
{
register int i, size, shift, index;
unsigned char * source = internal_patches[ patch ];

for (i=0; i < OLD_LOC_PARAM; i++)
    {
    size = cpres_size[i];
    index = cpres_index[i];
    shift = cpres_bits[i];
    expand_buf[i + 0]            = (char)
                        ((source[index + 0] >> shift) & size);
    expand_buf[i +OLD_LOC_PARAM] = (char)
                        ((source[index + nbLocParam] >> shift) & size);
    expand_buf[i + 2*OLD_LOC_PARAM] = (char)
                        ((source[index + 2*nbLocParam] >> shift) & size);
    expand_buf[i + 3*OLD_LOC_PARAM] = (char)
                        ((source[index + 3*nbLocParam] >> shift) & size);
    }
for (i=0; i < PATCH_NAME_LEN; i++)                              // copy name
    expand_buf[4 * OLD_LOC_PARAM + i] = internal_names[patch][i];
}
#endif
