;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; mvsound.inc
;
;******************************************************************************

FALSE           equ     0
TRUE            equ     1

PIC_EOI_MASTER  equ     20h             ; where to send master EOI
PIC_EOI_SLAVE   equ     0A0h            ; where to send slave EOI

PIC_IMR_MASTER  equ     21h
PIC_IMR_SLAVE   equ     0A1h


NwParm1         equ     [bp+2+2+00h]
NwParm2         equ     [bp+2+2+02h]
NwParm3         equ     [bp+2+2+04h]
NwParm4         equ     [bp+2+2+06h]
NwParm5         equ     [bp+2+2+08h]

NdParm1         equ     [bp+2+2+00h]
NdParm2         equ     [bp+2+2+04h]
NdParm3         equ     [bp+2+2+08h]
NdParm4         equ     [bp+2+2+0ch]


;;; Use these macros for FAR procedures
FwParm1         equ     [bp+2+4+00h]
FwParm2         equ     [bp+2+4+02h]
FwParm3         equ     [bp+2+4+04h]
FwParm4         equ     [bp+2+4+06h]
FwParm5         equ     [bp+2+4+08h]

FdParm1         equ     [bp+2+4+00h]
FdParm2         equ     [bp+2+4+04h]
FdParm3         equ     [bp+2+4+08h]
FdParm4         equ     [bp+2+4+0ch]

PCMCODEVERSION  equ     0003h           ; version 00.03

@dtasize=1      ; our version of Masm 5.1 internal
@cdesize=1      ; our version of Masm 5.1 internal

DEF_DMA         equ     1               ; default DMA address
SYSEX_ERROR     equ     00FFh           ; internal error code for sysexes on input

;   who is using the interrupt

INT_FREE        equ     0
INT_WAVEOUT     equ     1
INT_WAVEIN      equ     2
INT_MIDIOUT     equ     4
INT_MIDIIN      equ     8


; DMA buffer allocation

P_SIZE          equ 1000H               ; Page Size

; DSP function errors

DSP_BADRESET    equ 0001H       ; DSP reset failed
DSP_BADSAMPLE   equ 0002H       ; sample rate out of range

; DMA function errors

DMA_NOMEMORY    equ 0003H       ; out of memory
DMA_TOOSTUPID   equ 0004H       ; allocation algorithm too simple

; PIC data

INTCON  equ 21H                 ; interrupt controller port

; addresses of DMA channel 1 registers (we can only use DMA 1 on this card)


DMA     equ 00H                 ; base address of controller
DMAADR  equ DMA+2               ; address register for channel
DMACNT  equ DMA+3               ; count register for channel
DMASMR  equ DMA+10              ; single mask register
DMAMOD  equ DMA+11              ; mode register
DMACLR  equ DMA+12              ; byte pointer latch reset
DMAPREG equ 83H                 ; channel page register
ENCH1   equ 00000001B           ; enable channel 1 command for smr
DSCH1   equ 00000101B           ; disable channel 1 command for smr

; DMA command codes for channel 1

DMARD   equ 01000101B           ; single mode port -> memory (DSP read)
DMAWR   equ 01001001B           ; single mode memory -> port (DSP write)
DMARDA  equ 01010101B           ; auto init DSP read
DMAWRA  equ 01011001B           ; auto init DSP write
DMAAUTO equ 00010000B           ; auto init mask


;   /*\
;---|*| structures
;   \*/

;   per allocation structure for midi
;;;
;;;     typedef struct portalloc_tag {
;;;         DWORD           dwCallback;  // client's callback
;;;         DWORD           dwInstance;  // client's instance data
;;;         HMIDIOUT        hMidi;       // handle for stream
;;;         DWORD           dwFlags;     // allocation flags
;;;     } PORTALLOC;
;;;
;;;     typedef PORTALLOC *PPORTALLOC;
;;;
;   per allocation structure for wave
;;;
;;;     typedef struct wavealloc_tag {
;;;         DWORD           dwCallback;  // client's callback
;;;         DWORD           dwInstance;  // client's instance data
;;;         HANDLE          hWave;       // handle for stream
;;;         DWORD           dwFlags;     // allocation flags
;;;         DWORD           dwByteCount; // byte count since last reset
;;;         NPPCMWAVEFORMAT npPCMFmt;    // format of wave data
;;;     } WAVEALLOC;
;;;
;;;     typedef WAVEALLOC *PWAVEALLOC;


;   /*\
;---|*| macros
;   \*/
;       Macro to set the DMA controller transfer mode (auto-initialized or
;       non-auto initialized). If the VADMAD VxD is NOT present, then
;       ADMA_Entry just points to a retf.
;
; Entry : AX = DMA MODE BYTE
;
SetDMAMode macro
    push    dx
    xor     dx, dx              ; DX = 0 tells VADMAD that mode..
    call    ADMA_Entry          ; ..is being programmed
;;;;;;    and     al, _DMA_autoinit_mask
    pop     dx
    out     dx, al          ; set up the DMA mode
endm

; Macro to have VADMAD virtualize a channel
;
; Entry : AX = Channel
; Exit  : AX = 0 if NOT virtualized

SetDMAChannel macro
    push    dx
    mov     dx, 1               ; DX = 1 tells VADMAD that channel
    call    ADMA_Entry          ; ..is being virtualized
    pop     dx
endm
;   /*\
;---|*|----====< debug support >====----
;   \*/

IFDEF DEBUG
    extrn OutputDebugString:far
    extrn OutputDebugStr:far
    extrn OurOutputDebugStr:far
ENDIF

DOUT1   macro   text
        local   outa_here
        local   string_buffer

IFDEF DEBUG
        pusha
        lea     ax,string_buffer
        cCall   OurOutputDebugStr,<cs,ax>
        jmp     short outa_here

string_buffer:
        db      "&text&",0
outa_here:
        popa
ENDIF
        endm

DOUT3   macro   text
        local   outa_here3
        local   string_buffer3

IFDEF SQUIRTYOUTS
        pusha
        lea     ax,string_buffer3
        cCall   OutputDebugStr,<cs,ax>
        jmp     short outa_here3

string_buffer3:
        db      "&text&",0
outa_here3:
        popa
ENDIF
        endm

DbgWord macro val
IFDEF DEBUG
    push ax
    push si
    mov si, offset dgroup:msgWord
    mov ax, val
    call dbgWordToMsg
    mov ax, offset dgroup:msgWord
    cCall OutputDebugStr <ds, ax>
    pop si
    pop ax
ENDIF
endm


;  /*\
;  |*| The following are defined as part of the Microsoft         environment
;  |*| settings.
;  \*/

;
; DMA buffer allocation
;
DMADEFAULTBUFSIZE       equ 1000H               ; DMA buffer size: 4k bytes


;  /*\
;  |*| This section contains the Media Vision hardware definition equates,
;  |*| and the PC hardware environment.
;  \*/

;
; Product Definition
;
PROAS                   equ     1       ; 1st board - Pro Audio Spectrum

;
; Hardware associated with the product
;

if PROAS                        ; Media Vision Pro Audio Spectrum
DUALFM          EQU     1               ; Dual FM chips
DUALMIXER       EQU     1               ; Dual mixers
FILTER          EQU     1               ; Has filter after input mixer
VOLUME          EQU     1               ; Has total volume control
;

endif ; PROAS

;----------------------------====< PC HARDWARE >====---------------------------
;

; Interrupt Controller #1 Port Addresses and Interrupt Masks

IRQ1MASKREG     EQU     021h            ; 8259 mask register
IRQ1ACKREG      EQU     020h            ; 8259 INT acknowledge register

INT0MSK         EQU     00000001B       ; interrupt 0 mask
INT1MSK         EQU     00000010B       ; interrupt 1 mask
INT2MSK         EQU     00000100B       ; interrupt 2 mask
INT3MSK         EQU     00001000B       ; interrupt 3 mask
INT4MSK         EQU     00010000B       ; interrupt 4 mask
INT5MSK         EQU     00100000B       ; interrupt 5 mask
INT6MSK         EQU     01000000B       ; interrupt 6 mask
INT7MSK         EQU     10000000B       ; interrupt 7 mask

; Interrupt Controller #2 Port Addresses and Interrupt Masks

IRQ2MASKREG     EQU     0A1h            ; 8259 mask register
IRQ2ACKREG      EQU     0A0h            ; 8259 INT acknowledge register

INT8MSK         EQU     00000001B       ; interrupt 8 mask
INT9MSK         EQU     00000010B       ; interrupt 9 mask
INTAMSK         EQU     00000100B       ; interrupt A mask
INTBMSK         EQU     00001000B       ; interrupt B mask
INTCMSK         EQU     00010000B       ; interrupt C mask
INTDMSK         EQU     00100000B       ; interrupt D mask
INTEMSK         EQU     01000000B       ; interrupt E mask
INTFMSK         EQU     10000000B       ; interrupt F mask

EOI             EQU     020h            ; non specific end of interrupt

;
; dma controller #1 port addresses
;

DMAC0ADDR       EQU     000h            ; DMA channel 0 Base & Current Address
DMAC0COUNT      EQU     001h            ; DMA channel 0 Base & Current Count
DMAC1ADDR       EQU     002h            ; DMA channel 1 Base & Current Address
DMAC1COUNT      EQU     003h            ; DMA channel 1 Base & Current Count
DMAC2ADDR       EQU     004h            ; DMA channel 2 Base & Current Address
DMAC2COUNT      EQU     005h            ; DMA channel 2 Base & Current Count
DMAC3ADDR       EQU     006h            ; DMA channel 3 Base & Current Address
DMAC3COUNT      EQU     007h            ; DMA channel 3 Base & Current Count

DMARDSTAT       EQU     008h            ; DMA read status
DMAWRCNTRL      EQU     008h            ; DMA write command register
DMAWREQ         EQU     009h            ; DMA write request register
DMAWRSMR        EQU     00Ah            ; DMA write single mask register
DMAWRMODE       EQU     00Bh            ; DMA write mode register
DMACLEAR        EQU     00Ch            ; DMA clear low/high flip-flop
DMARDTEMP       EQU     00Dh            ; DMA read temp register
DMAWRCLR        EQU     00Dh            ; DMA write master clear
DMACLRMSK       EQU     00Eh            ; DMA clear mask register
DMAWRALL        EQU     00Fh            ; DMA write all mask register bits

CH0PAGEREG      EQU     087h            ; Channel 0 Page Register
CH1PAGEREG      EQU     083h            ; Channel 1 Page Register
CH2PAGEREG      EQU     081h            ; Channel 2 Page Register
CH3PAGEREG      EQU     082h            ; Channel 3 Page Register

;
;---------------------------====< MASM Assembly >====--------------------------
;
; miscellaneous equates & macros
;

bptr            equ     byte ptr
wptr            equ     word ptr
dptr            equ     dword ptr

pause           equ     <jmp $+2>

;
; end of mvsound.inc
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   sndblst.inc
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   equates and structure definitions
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

TRUE  equ 1
FALSE equ 0

NONSPEC_EOI   equ 20H       ; non-specific EOI
MSTR_EOIPORT  equ 20H       ; where to send master EOI
SLAVE_EOIPORT equ 0A0H      ; where to send slave EOI

; System config BIOS function

GetSystemConfig equ 0c0h

; DMA buffer allocation


; DSP function errors

DSP_BADRESET    equ 0001H       ; DSP reset failed
DSP_BADSAMPLE   equ 0002H       ; sample rate out of range

; DMA function errors

DMA_NOMEMORY    equ 0003H       ; out of memory
DMA_TOOSTUPID   equ 0004H       ; allocation algorithm too simple

; addresses of DMA channel 1 registers (we can only use DMA 1 on this card)

DMA     equ 00H                 ; base address of controller
DMAADR  equ DMA+2               ; address register for channel
DMACNT  equ DMA+3               ; count register for channel
DMASMR  equ DMA+10              ; single mask register
DMAMOD  equ DMA+11              ; mode register
DMACLR  equ DMA+12              ; byte pointer latch reset
DMAPREG equ 83H                 ; channel page register
ENCH1   equ 00000001B           ; enable channel 1 command for smr
DSCH1   equ 00000101B           ; disable channel 1 command for smr

; DMA command codes for channel 1

DMARD   equ 01000101B           ; single mode port -> memory (DSP read)
DMAWR   equ 01001001B           ; single mode memory -> port (DSP write)
DMARDA  equ 01010101B           ; auto init DSP read
DMAWRA  equ 01011001B           ; auto init DSP write
DMAAUTO equ 00010000B           ; auto init mask

; DSP commands

MIDIRD      equ 31h               ; interrupt-driven midi input
MIDIRD2     equ 35h               ; interrupt-driven midi input
MIDIRDTS    equ 37h               ; interrupt-driven midi input (time-stamped)
MIDIWR      equ 38h               ; midi output
WAVEWR      equ 14h               ; interrupt-driven 8 bit linear wave output
WAVEWRA     equ 1Ch               ; auto mode 8 bit out
WAVERD      equ 24h               ; interrupt-driven 8 bit linear wave input
WAVERDA     equ 2Ch               ; auto mode 8 bit in
HIGHSPEED   equ 90h               ; high speed mode
SETSAMPRATE equ 40h               ; set sample rate
SETBLCKSIZE equ 48h               ; set block size
SPKRON      equ 0D1h              ; speaker on
SPKROFF     equ 0D3h              ; speaker on
HALTDMA     equ 0D0h              ; halt DMA
CONTDMA     equ 0D4h              ; continue DMA
STOPAUTO    equ 0DAh              ; stop DMA autoinit mode
GETDSPVER   equ 0E1h              ; get dsp version

; offsets of mixer ports

MIXADDRPORT   equ    4H
MIXDATAPORT   equ    5H
WARMSTARTPORT equ    6H

; mixer registers

DATARESETREG  equ   00H
MSTRVOLREG    equ   02H
VOICEVOLREG   equ   04H
FMVOLREG      equ   06H
CDVOLREG      equ   08H
MICVOLREG     equ   0AH
ADCINPREG     equ   0CH
VTSCREG       equ   0EH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   macros
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;---------------------------------Macro---------------------------------;
;
; EnterCrit
;
;   saves the current state of the interupt flag on the stack then
;   disables interupts.
;
; Registers Destroyed:
;       BX, FLAGS
;
;------------------------------------------------------------------------;

EnterCrit macro
    local   no_cli
    pushf
    pushf
    pop     bx
    test    bh,2            ; if interupts are already off, dont blow
    jz      no_cli          ; ... ~300 clocks doing the cli
    cli
no_cli:
endm

;---------------------------------Macro---------------------------------;
;
; LeaveCrit
;
;   restore the interupt state saved by EnterCrit
;
; Registers Destroyed:
;       BX, FLAGS
;
;------------------------------------------------------------------------;

LeaveCrit macro
    local   no_sti
    pop     bx
    test    bh, 2
    jz      no_sti
    sti
no_sti:
endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   debug support
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ifdef DEBUG
    extrn OurOutputDebugStr:far          ; mmsystem
    extrn _wDebugLevel:word           ; initc.c
endif

;;;;;;;
;MMQ 6/12
;;;;;;;
if 0

D1 macro text
    DOUT 1, < ",32,32,"MVWAVE: &text&>
    ;;;DOUT 1, < ",13,10,"MVWAVE: &text&>
    endm
D2 macro text
    DOUT 2, < &text&>
    endm
D3 macro text
    DOUT 3, < &text&>
    endm
D4 macro text
    DOUT 4, < &text&>
    endm


DOUT macro level, text
    local   string_buffer
    local   wrong_level

ifdef DEBUG

_DATA segment
string_buffer label byte
    db      "&text&",0
_DATA ends

;;    cmp     [_wDebugLevel], level
;;    jl      wrong_level
    push    ds
    push    DataOFFSET string_buffer
    call    OurOutputDebugStr
wrong_level:
endif
    endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   assert macros
;
;   AssertF byte        -- fail iff byte==0
;   AssertT byte        -- fail iff byte!=0
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AssertF     macro exp
    local   assert_ok
ifdef DEBUG
    push    ax

    mov     al,exp
    or      al,al
    jnz     assert_ok

    D1      <AssertF fail (&exp&)>
    int     3

assert_ok:
    pop     ax
endif
    endm

AssertT     macro exp
    local   assert_ok
ifdef DEBUG
    push    ax

    mov     al,exp
    or      al,al
    jz      assert_ok

    D1      <AssertT fail (&exp&)>
    int     3

assert_ok:
    pop     ax
endif
    endm

;;;;;;;
;MMQ 6/12
;;;;;;;
endif
