;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; mvsound.asm - Pro AudioSpectrum Sound Support Code
;
; Media Vision PAS-16 specific support code
;******************************************************************************
        page    64,131
        Title   MVSOUND  --  Pro AudioSpectrum Sound Support Code
        .286p
        .xlist
        include common.inc
        include mvsound.inc
        include findpas.inc
        include std.inc
        include devhlp.inc

        .list

;
;----------------------------====< segmentation >====--------------------------
;

IFNDEF SEGNAME
    SEGNAME equ <_TEXT>
ENDIF

;*********************** END OF SPECIFICATIONS **********************
;******************************************************************************
;                       I N C L U D E S
;******************************************************************************

DGROUP  GROUP    _DATA

_DATA   SEGMENT WORD PUBLIC USE16 'DATA'


;******************************************************************************
;                       E X T E R N S
;******************************************************************************
; These variables are DMA/Buffer control variables
;
        public  _DMARunning     ; running=1, off=0

        public  _TheDMAChannel
        public  _TheIRQChannel
        public  _OldIRQMask
        public  _TheDMAStatusBit
        public  _TheIRQMask
        public  _TheDMAMode
        public  _fStereoMode
        public  _bBitsSample
        public  PCMDirection
        public  PCMUserRoutine
        public  MIDIUserRoutine
        public  _audiomixr
        public  _DMA_autoinit_mask
        public  _samplerate

        public  _EmptyBufferCount
_EmptyBufferCount label WORD
        dw      0


        public  _wDMASelector
        public  _DMABufferPointer

        public  _wDMAOffset

        public  _InternalBufferCount    ; # of DMA buffer halves loaded



        public  _NextDMAPtr

;
ES_SAVE dw      0

        extrn   _dwDMAPhysAddr:DWORD
        extrn   _wDMABuffLength:WORD
        extrn   _dwDMAUnitSize:DWORD      ; size of DMA buffer divisions (2k-64k)       adjusted for sample rate
        extrn   _gwTranslateCode:WORD

_InternalBufferCount db 0       ; # of DMA buffer halves loaded
_wDMAoffset     dw      0
_wDMAselector   dw      0
_NextDMAPtr     dd      0       ; our pointer to the DMA's buffer
_DMABufferPointer dd    0
_DMARunning     dw      0

_DMA_autoinit_mask      db      NOT DMAAUTO
_TheDMAChannel  db      6h              ; defaults to channel 5 (was 3)
_TheIRQChannel  db      7       ; defaults to IRQ 7
_TheIRQMask     db      INT7MSK         ; 8259 interrupt mask
_OldIRQMask     db      0               ; saved

_TheDMAMode     db      00h             ; 55h for input, 59h for output
_fStereoMode    db      0               ; Nonzero means stereo
PCMDirection    db      0               ; bit mask for the DMA controller
_bBitsSample    db      8               ; number of bits/sample

PCMUserRoutine  dd      0               ; PCM I/O User Code
MIDIUserRoutine dd      0               ; MIDI I/O User Code

ifdef CDPC_FRONT_PANEL
AUXUserRoutine  dd      0               ; AUX I/O User Code 05/08/92 mmq
endif

_TheDMAStatusBit db     INT1MSK         ; defaults to channel 1 status bit

        public OldIRQRoutine
OldIRQRoutine   dd      0               ; holds the original routine

polledmask      equ     bICsamprate+bICsampbuff ; polled mask
dmamask         equ     bICsampbuff             ; dma mask

DMAOUTPUT       equ     0+dmamask       ; DMA is used to drive the output
POLLEDOUTPUT    equ     0+polledmask    ; Polling routine drives output
DMAINPUT        equ     1+dmamask       ; DMA is used to read input
POLLEDINPUT     equ     1+polledmask    ; Polling routine reads input
TypeOfSetup     db      0               ; polled/dma input or output

        public  NumberOfInterrupts
NumberOfInterrupts      dw      0       ; number of interrupts that have occured
;
; These variables direct our code to the proper DMA channel
;
OurDMAPageReg   dw      CH1PAGEREG      ; default to DMA channel 1 page reg
OurDMAddress    dw      DMAC1ADDR       ; default to DMA channel 1 address reg
OurDMACount     dw      DMAC1COUNT      ; default to DMA channel 1 count reg

;
; These variables mirror the hardware state
;
_sysspkrtmr     db      0               ;   42 System Speaker Timer Address
_systmrctlr     db      0               ;   43 System Timer Control Register
_sysspkrreg     db      0               ;   61 System Speaker Register
_joystick       db      0               ;  201 Joystick Register
_lfmaddr        db      0               ;  388 Left  FM Synthesizer Address Register
_lfmdata        db      0               ;  389 Left  FM Synthesizer Data Register
_rfmaddr        db      0               ;  38A Right FM Synthesizer Address Register
_rfmdata        db      0               ;  38B Right FM Synthesizer Data Register
_dfmaddr        db      0               ;  788 Dual  FM Synthesizer Address Register
_dfmdata        db      0               ;  789 Dual  FM Synthesizer Data Register
                db      0               ;      reserved for future use
                db      0               ;      reserved for future use
_audiomixr      db      bMIclock+bMImonofm     ;  B88 Audio Mixer Control Register
_intrctlrst     db      0               ;  B89 Interrupt Status Register write
_audiofilt      db      21h  ; 39h      ;  B8A Audio Filter Control Register
_intrctlr       db      0               ;  B8B Interrupt Control Register write
_pcmdata        db      0               ;  F88 PCM data I/O register
                db      0               ;  F89 reserved for future use
_crosschannel   db      bCCr2r+bCCl2l+bCCdac ;  F8A Cross Channel
                db      0               ;  F8B reserved for future use
_samplerate     dw      0               ; 1388 Sample Rate Timer Register
_samplecnt      dw      0               ; 1389 Sample Count Register
_spkrtmr        dw      0               ; 138A Local Speaker Timer Address
_mdirqvect      db      0               ; 1788 MIDI IRQ Vector Register
_mdsysctlr      db      0               ; 1789 MIDI System Control Register
_mdsysstat      db      0               ; 178A MIDI IRQ Status Register
_mdirqclr       db      0               ; 178B MIDI IRQ Clear Register
_mdgroup1       db      0               ; 1B88 MIDI Group #1 Register
_mdgroup2       db      0               ; 1B89 MIDI Group #2 Register
_mdgroup3       db      0               ; 1B8A MIDI Group #3 Register
_mdgroup4       db      0               ; 1B8B MIDI Group #4 Register

        public  _TimerRunning
_TimerRunning   db      bICsamprate     ; MV101 can keep Timer running
        public  _PCMrunning
_PCMrunning     db      bCCenapcm+bCCdrq        ; MV101 can keep PCM running
;;;;_PCMrunning db      bCCenapcm       ; MV101 can keep PCM running

        public  DMA1AddrTable
DMA1AddrTable   label   byte
        db      DEFAULTDMA      ; DMA channel selected
        db      DMARDSTAT       ; DMA read status
        db      DMAWRCNTRL      ; DMA write command register
        db      DMAWREQ         ; DMA write request register
        db      DMAWRSMR        ; DMA write single mask register
        db      DMAWRMODE       ; DMA write mode register
        db      DMACLEAR        ; DMA clear low/high flip-flop
        db      DMARDTEMP       ; DMA read temp register
        db      DMAWRCLR        ; DMA write master clear
        db      DMACLRMSK       ; DMA clear mask register
        db      DMAWRALL        ; DMA write all mask register bits
;
; table of address pointers to the various DMA 2 addresses
;
        public  DMA2AddrTable
DMA2AddrTable   label   byte
        db      DEFAULTDMA      ; DMA channel selected
        db      DMA2RDSTAT      ; DMA read status
        db      DMA2WRCNTRL     ; DMA write command register
        db      DMA2WREQ        ; DMA write request register
        db      DMA2WRSMR       ; DMA write single mask register
        db      DMA2WRMODE      ; DMA write mode register
        db      DMA2CLEAR       ; DMA clear low/high flip-flop
        db      DMA2RDTEMP      ; DMA read temp register
        db      DMA2WRCLR       ; DMA write master clear
        db      DMA2CLRMSK      ; DMA clear mask register
        db      DMA2WRALL       ; DMA write all mask register bits

        public  DMAPointer
DMAPointer      dw      offset DMA1AddrTable    ; default to channel 1 table


dmaaddr struc
_dmach          db      ?       ; DMA channel selected
_dmardstat      db      ?       ; DMA read status
_dmawrcntrl     db      ?       ; DMA write command register
_dmawreq        db      ?       ; DMA write request register
_dmawrsmr       db      ?       ; DMA write single mask register
_dmawrmode      db      ?       ; DMA write mode register
_dmaclear       db      ?       ; DMA clear low/high flip-flop
_dmardtemp      db      ?       ; DMA read temp register
_dmawrclr       db      ?       ; DMA write master clear
_dmaclrmsk      db      ?       ; DMA clear mask register
_dmawrall       db      ?       ; DMA write all mask register bits
dmaaddr ends

O_DMACH         EQU     0
O_DMARDSTAT             EQU     1
O_DMAWRCNTRL    EQU     2
O_DMAWREQ               EQU     3
O_DMAWRSMR      EQU     4
O_DMAWRMODE     EQU     5
O_DMACLEAR      EQU     6
O_DMARDTEMP     EQU     7
O_DMAWRCLR      EQU     8
O_DMACLRMSK     EQU     9
O_DMAWRALL      EQU    10



;
; dma channels, etc
;
dmatable        label   word
        dw      (CH0PAGEREG SHL 8) + DMAC0ADDR
        dw      (CH1PAGEREG SHL 8) + DMAC1ADDR
        dw      (CH2PAGEREG SHL 8) + DMAC2ADDR
        dw      (CH3PAGEREG SHL 8) + DMAC3ADDR
        dw      0
        dw      (CH5PAGEREG SHL 8) + DMA2C5ADDR
        dw      (CH6PAGEREG SHL 8) + DMA2C6ADDR
        dw      (CH7PAGEREG SHL 8) + DMA2C7ADDR

;
_DATA   ENDS

;******************************************************************************
;                           C O D E
;******************************************************************************

_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

;   /*\
;---|*|
;---|*|---------------====< Prototypes >====---------------
;---|*|
;---|*|
;---|*| int InitPCM()
;---|*|
;---|*|     Initializes the PCM code.
;---|*|
;---|*| void MVOut( int, int )
;---|*|
;---|*|     output data to the hardware
;---|*|
;   |*| void PausePCM()
;   |*|
;   |*|     Temporarily stops the PCM I/O by disabling the timers
;   |*|
;   |*| int PCMInfo( long ,int )
;   |*|
;   |*|     Sets up the transfer rate & stereo/mono
;   |*|
;   |*| int PCMPlay()
;   |*|
;   |*|     Starts the DMA feeding the DAC
;   |*|
;   |*| int PCMRecord()
;   |*|
;   |*|     Starts the DMA reading the ADC
;   |*|
;   |*| void ResumePCM()
;   |*|
;   |*|     Restarts the PCM I/O by enabling the timers
;   |*|
;   |*| int SelectDMA( int )
;   |*|
;   |*|     Selects the DMA channel 1, or 3
;   |*|
;   |*| int SelectIRQ( int )
;   |*|
;   |*|     Selects the IRQ line for DMA control
;   |*|
;   |*| void UserFunc((*long)(),int)
;   |*|
;   |*|     Call back routine when Half way buffer is full/empty.
;   |*|
;   \*/
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   /*\
;---|*|---------------====< InitPCM() >====---------------
;---|*|
;---|*| Initializes the PCM code
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     AX =  Version of this Code
;---|*|
;   \*/

        public  _InitPCM
_InitPCM        proc    near
        PUSHEM  bx,es

        mov     [TypeOfSetup],bICsamprate+bICsampbuff ; flushes both interrupts

        mov     al,_TheDMAChannel               ; setup default DMA
        cbw
        push    ax

        call    _SelectDMA
        pop     ax

        call    near ptr _StopPCM               ; kill the Audio Spectrum board
        call    near ptr KillDMA                        ; kill the PC system board

        sub     ax,ax

        mov     wptr [PCMUserRoutine+0],ax
        mov     wptr [PCMUserRoutine+0],ax

        mov     wptr [MIDIUserRoutine+0],ax
        mov     wptr [MIDIUserRoutine+2],ax

ifdef CDPC_FRONT_PANEL
        mov     wptr [AUXUserRoutine+0],ax      ; 05/08/92 mmq
        mov     wptr [AUXUserRoutine+2],ax
endif

        mov     wptr [_dwDMAPhysAddr+0],ax
        mov     wptr [_dwDMAPhysAddr+2],ax

        mov     wptr [_wDMABuffLength],ax

        mov     [_fStereoMode],al               ; init as Mono mode

;;      mov     dx,TMRCTLR              ;; this makes the PCM hardware quiet!
;;      xor     dx,_gwTranslateCode
;;      mov     al,00110110b            ; 36h Timer 0 & square wave
;;      out     dx,al                   ; makes it quieter

        POPEM   bx,es
        ret
_InitPCM endp





;   /*\
;---|*|---------------====< Init16() >====---------------
;---|*|
;---|*| Initializes the 16-bit hardware
;---|*|
;---|*| Entry Conditions:
;---|*|     NdParm1 =   dwCaps for this device
;---|*|
;---|*| Exit Conditions:
;---|*|     AX =  Version of this Code
;---|*|
;   \*/
        public  _Init16
_Init16 proc    near
        push    bp
        mov     bp,sp

        PUSHEM  bx,es

        mov     bx,_gwTranslateCode     ; get Translate code

        mov     dx,INTERRUPT_CTRL_REG   ; 
        xor     dx,bx                   ; relocate I/O
        xor     al,al
        out     dx,al                   ; no interrupts, please!

        mov     dx,SYSTEM_CONFIG_1
        xor     dx,bx                   ; relocate I/O
        in      al,dx
        or      al,00000010b            ;; disable original PAS emulation
        out     dx, al                  ; set sys config1

        pause

        mov     dx,SYSTEM_CONFIG_2
        xor     dx,bx                   ; relocate I/O
        mov     al,00000000b
        out     dx,al                   ; sys config2

        mov     dx,SYSTEM_CONFIG_3
        xor     dx,bx                   ; relocate I/O
        xor     al,al                   ; clear AL

        test    WORD PTR NwParm1,CDPC   ; are we a CDPC? - 06/04/92 mmq
        jnz     SetConfig3              ; yes - set config3 to zero

        mov     al,00011001b            ; no - set config3 to this
;
SetConfig3:
        out     dx,al                   ; set sys config3

        mov     dx,FEATURE_ENABLE
        xor     dx,bx                   ; relocate I/O
        in      al,dx
        or      al,1h                   ; enable PCM
        and     al,01111111b            ; disable
        out     dx,al

        POPEM   bx,es
        pop     bp

        ret
_Init16 endp

;
;
;   /*\
;---|*|---------------====< PausePCM >====---------------
;---|*|
;---|*| Turn off the h/w timer enables to effectively stop pcm temporarily.
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     Nothing
;---|*|
;   \*/
;
        public  _PausePCM
_PausePCM       proc near
;
; Setup the audio filter sample bits
;
;;;     EnterCrit   ;; destroys bx

        mov     bx,_gwTranslateCode     ; get Translate code

        mov     dx,AUDIOFILT
        xor     dx,bx                   ;; xlated I/O addr
        mov     al,[_audiofilt]
        and     al,not (bFIsrate)       ; flush the enable bit
        or      al,20h
        mov     [_audiofilt],al
        out     dx,al

;;;;    LeaveCrit   ;; destroys bx

        ret

_PausePCM       endp

;   /*\
;---|*|---------------====< ResumePCM >====---------------
;---|*|
;---|*| Turn on the h/w from making interrupt and DMA requests. This assumes
;---|*| the hardware has already been setup and is ready to go...
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     Nothing
;---|*|
;   \*/
;
        public  _ResumePCM
_ResumePCM      proc    near
;
; Setup the audio filter sample bits
;
;;;;    EnterCrit   ;; destroys bx      ;       disableINT

        mov     bx,_gwTranslateCode     ; get Translate code

        mov     dx,AUDIOFILT
        xor     dx,bx                   ;; xlated I/O addr
        mov     al,[_audiofilt]
        or      al,(bFIsrate)           ; enable sample rate and buffer timers
        or      al,20h
        mov     [_audiofilt],al
        out     dx,al

;;;;    LeaveCrit   ;; destroys bx ;    enableINT

        ret

_ResumePCM       Endp

;   /*\
;---|*|---------------====< KillDMA >====---------------
;---|*|
;---|*| Turn off the DMA chip
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     Nothing
;---|*|
;   \*/
        public  KillDMA
KillDMA proc  near
;
; mask out the DMA to stop it
;
        push    si
        mov     si,[DMAPointer]         ; get the DMA pointer

;;;;    EnterCrit            ;; destroys bx ;disableINT

        mov     al,[si+O_DMACH]         ; get the adjusted dma channel #
        or      al,0100b                ; disable the DMA
        mov     dl,[si+O_DMAWRSMR]
        xor     dh,dh
        out     dx,al

;
; also, remove the auto-init state
;
;;      xor     al,44h                  ; need AL from above
;;        SetDMAmode

        mov     al,[_crosschannel]      ; get the current cross channel
        and     al,not (bCCdrq)         ;clear the PCM/DRQ/DAC bit
        or      al,_PCMrunning          ; if MV101, keep PCM running
        and     al,not (bCCmono)        ;always leave it in stereo mode

        mov     dx,CROSSCHANNEL
        xor     dx,_gwTranslateCode     ; get Translate code
        out     dx,al                   ; send to the hardware
        mov     [_crosschannel],al

;;;;    LeaveCrit  ;; destroys bx       ;enableINT
        mov     _DMARunning,0            ; set the global status word
        pop     si
        ret
KillDMA endp
;   /*\
;---|*|---------------====< StopPCM >====---------------
;---|*|
;---|*| Turn off the h/w from making interrupt and DMA requests
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     Nothing
;---|*|
;---|*| Warning: Enables interrupts!
;   \*/
;
        public  _StopPCM
_StopPCM        proc    near
;
; clear the audio filter sample timer enable bits
;
;;;;    EnterCrit   ;; destroys bx      ;disableINT

        mov     bx,_gwTranslateCode     ; get Translate code

        mov     dx,AUDIOFILT
        xor     dx,bx                   ;; xlated I/O addr

        in      al,dx                   ;; get current filter setting
        cmp     al,00h                  ;; if muted
        jz      stoppcm1                ;; do not change

        mov     al,[_audiofilt]
        and     al,not (bFIsrate+bFIsbuff) ; flush the sample timer bits
        or      al,20h
        mov     _audiofilt,al

        out     dx,al
;
; clear the Interrupt Control Register
;
stoppcm1:
        mov     ah,TypeOfSetup
        and     ah,bICsamprate+bICsampbuff
        not     ah
        or      ah,_TimerRunning        ;; if MV101, leave samp rate running
        mov     dx,INTRCTLR
        xor     dx,bx                   ;; xlated I/O addr
        in      al,dx
        and     al,ah                   ; kill sample timer interrupts
        out     dx,al
        mov     _intrctlr,al


;;;     mov     dx,TMRCTLR              ;; this makes the PCM hardware quiet!
;;;     xor     dx,_gwTranslateCode
;;;     mov     al,00110110b            ; 36h Timer 0 & square wave
;;;     out     dx,al                   ; makes it quieter


;
; clear the PCM enable bit
;
        mov     al,[_crosschannel]      ; get the current cross channel
        and     al,not (bCCenapcm)      ; 

        or      al,bCCdac               ; to make CDPC handshake work

        test    WORD PTR NwParm1,CDPC   ; are we a CDPC?
        jnz     NoVU                    ; yes - can't permit VU

        and     al,NOT bCCdac           ; set to record mode so VU's will work
NoVU:
        mov     dx,CROSSCHANNEL
        xor     dx,bx                   ;; xlated I/O addr
        out     dx,al                   ; send to the hardware
        mov     [_crosschannel],al

        mov     _DMARunning,0            ; clear the global status word

;;;;    LeaveCrit   ;; destroys bx      ; enableINT  ; drop dead...

        ret
_StopPCM endp


;   /*\
;---|*|---------------====< PCMPlay() >====---------------
;---|*|
;---|*| Starts the DMA feeding the DAC
;---|*|
;---|*| Entry Conditions:
;---|*|
;---|*| Exit Conditions:
;---|*|     AX =  0 good start
;---|*|     AX = -1 not started, problem occured
;   \*/

        public  _PCMPlay
_PCMPlay        proc    near

        mov     [TypeOfSetup],DMAOUTPUT
        mov     [PCMDirection],bCCdac
;
; Select the DMA mode for playing
;
        mov     _TheDMAMode,58h         ; sets the PLAY direction
;
; Program the DMA, then our board circuitry to start the interrupts
;
        call    LoadDMA                 ; setup the DMA controller
        call    SetupPCMDMAIO           ; Setup the MV Hardware

        mov     ax,0
        ret

_PCMPlay endp


;   /*\
;---|*|---------------====< PCMRecord() >====---------------
;---|*|
;---|*| Starts the DMA reading the ADC
;---|*|
;---|*| Entry Conditions:
;---|*|     wParm1 indicates stereo (1) or mono (0)
;---|*|
;---|*| Exit Conditions:
;---|*|     AX =  0 recording has started
;---|*|     AX = -1 recording did not start
;---|*|
;   \*/

        public  _PCMRecord
_PCMRecord      proc    near
        push    es

        call    StartRecording            ; go for it...
        mov     ax,0

        pop     es
        ret

_PCMRecord       endp

;
;
;   /*\
;---|*|---------------====< SelectDMA( int ) >====---------------
;---|*|
;---|*| Selects the DMA channel 0 - 7, excluding 4
;---|*|
;---|*| Entry Conditions:
;---|*|     wParm1 determines DMA number (0, 1, 2, 3, 5, 6, 7 )
;---|*|
;---|*| Exit Conditions:
;---|*|     AX =  0, good buffer, all okay
;---|*|     AX = -1, good buffer, all okay
;---|*|
;   \*/

        public  _SelectDMA
_SelectDMA proc near
        push    bp
        mov     bp,sp


        mov     ax,NwParm1              ; get the DMA #

;;;     All PAS-1 cards must be safeguarded here...
        and     ax,0111b        ; 0011b ; save the channels

        mov     bx,ax                   ; get some of the I/O addreses
        shl     bx,1                    ; into DX
        jnz     seldma_02               ; not channel 0, go use it...
        push    sp                      ; 8088/86 class machine?
        pop     cx
        cmp     cx,sp
        jnz     seldma_bad              ; yes, can't do channel 0 dma
;
    seldma_02:
        mov     dx,[dmatable+bx]
        or      dx,dx                   ; valid entry?
        jz      seldma_bad              ; no, bomb out...

        mov     _TheDMAChannel,al        ; select the channel.
        mov     bptr OurDMAPageReg,dh   ; ...the page register,
        mov     bptr OurDMAddress,dl    ; ...the address register,

        lea     bx,DMA1AddrTable        ; get the DMA channel addresses
        cmp     al,4
        jl      seldma_05
        lea     bx,DMA2AddrTable        ; get the DMA channel addresses
        sub     al,4                    ; make it zero based
;
    seldma_05:
        mov     [bx+O_DMACH],al         ; save the adjusted dma channel #
        mov     [DMAPointer],bx         ; save the pointer to all DMA addrs
        sub     ax,ax
        pop     bp
        ret
;
seldma_bad:
        mov     ax,-1
        pop     bp
        ret
_SelectDMA       endp

;   /*\
;---|*|---------------====< UserFunc((*long)()) >====---------------
;---|*|
;---|*| Call back routine when Half way buffer is full/empty.
;---|*|
;---|*| Entry Conditions:
;---|*|     dParm1 points to the user routine
;---|*|     wParm3 indicates which vector is set:
;---|*|         0 = PCM
;---|*|         1 = MIDI
;---|*|         2 = LEFT FM
;---|*|         3 = RIGHT FM
;---|*|
;---|*| Exit Conditions:
;---|*|     Nothing
;---|*|
;   \*/


        public  _UserFunc
_UserFunc       proc    near
        push    bp
        mov     bp,sp


        mov     dx,Nwparm2              ; get the routine
        mov     ax,Nwparm1              ; get the routine

        mov     bx,dx
        or      bx,ax
        jz      usfu_bad
        mov     cx,Nwparm3              ; get the index

ifdef CDPC_FRONT_PANEL
        cmp     cl,3                    ; #3 - AUX (CDPC) 05/08/92 mmq
        ja      usfu_bad
        lea     bx,AUXUserRoutine
        je      usfu_found
endif;CDPC_FRONT_PANEL

        cmp     cl,1
        ja      usfu_bad
        lea     bx,MIDIUserRoutine      ; #1 - MIDI fm chip
        je      usfu_found              ; that is, equal to one
        lea     bx,PCMUserRoutine       ; #0 - PCM fm chip
;
usfu_found:
        mov     wptr [bx+0],ax
        mov     wptr [bx+2],dx
;
usfu_bad:
        pop     bp
        ret

_UserFunc endp
;
;
;
;----------------------------========================--------------------------
;----------------------------========================--------------------------
;----------------------------========================--------------------------
;
;
;                       PPPPPPPP      CCCCCC   MMM       MMM
;                       PPPPPPPP     CCCCCCC   MMMM     MMMM
;                       PPP   PPP   CCC        MMMMM   MMMMM
;                       PPP   PPP   CCC        MMMMMM MMMMMM
;                       PPPPPPPP    CCC        MMM MMMMM MMM
;                       PPPPPPPP    CCC        MMM  MMM  MMM
;                       PPP         CCC        MMM   M   MMM
;                       PPP         CCC        MMM       MMM
;                       PPP          CCCCCCC   MMM       MMM
;                       PPP           CCCCCC   MMM       MMM
;
;        rrrrr    oooo   uu  uu  tttttt  iiiiii  nn  nn   eeeee   sssss
;        rr  rr  oo  oo  uu  uu    tt      ii    nnn nn  ee      ss
;        rrrrrr  oo  oo  uu  uu    tt      ii    nnnnnn  eeeeee   ssss
;        rr rr   oo  oo  uu  uu    tt      ii    nn nnn  ee          ss
;        rr  rr   oooo    uuuuuu   tt    iiiiii  nn  nn   eeeee  sssss
;
;
;
;----------------------------========================--------------------------
;----------------------------========================--------------------------
;----------------------------========================--------------------------
;
;----------------------------====< _loadtimer0 >====-------------------------
;;
;;
;;
;;
;
;;;RATE =       Nwparm1

        public  _loadtimer0
_loadtimer0 proc near
        push    bp
        mov     bp,sp

        PUSHEM  bx,dx

        mov     dx,TMRCTLR
        xor     dx,_gwTranslateCode

;;;;    EnterCrit                       ; disableINT
        mov     al,00110110b            ; 36h Timer 0 & square wave
        out     dx,al

        mov     dx,SAMPLERATE
        xor     dx,_gwTranslateCode     ; get Translate code

        mov     ax,Nwparm1               ; get intended sample rate
        mov     _samplerate,ax          ; we save this value in global reg

        out     dx,al
        pause
        xchg    ah,al
        out     dx,al

;;;;    LeaveCrit
        POPEM   bx,dx

        pop     bp
        ret
_loadtimer0 endp

;
;----------------------------====< _loadtimer1 >====-------------------------
;;
;;
;;
;DRQcount =     Nwparm1

        public  _loadtimer1
_loadtimer1 proc near
        push    bp
        mov     bp,sp
        PUSHEM  bx,dx

;;;
;;;  This clears Timer 1 if it is stuck waiting for a data.
;;;  The StopPCM function sends a command to the Timer controller
;;;  (36h) which prepares the timer to be programmed.  When the
;;;  Timer is in this state, it makes the PAS 16 quieter.
;;;
;;        mov     dx,SAMPLECNT
;;      xor     dx,_gwTranslateCode     ; get Translate code
;;      out     dx,al
;;        pause
;;        pause
;;        xchg    ah,al
;;;     out     dx,al
;;;
;;;
;;;



        mov     dx,TMRCTLR
        xor     dx,_gwTranslateCode

;;;     EnterCrit                       ; disableINT
        mov     al,01110100b            ; 74h Timer 1 & rate generator
        out     dx,al
        mov     ax,Nwparm1              ; DRQcount

        mov     dx,SAMPLECNT
        xor     dx,_gwTranslateCode     ; get Translate code
        mov     _samplecnt,ax

        out     dx,al
        pause
        pause
        xchg    ah,al
        out     dx,al

;;;;    LeaveCrit
        POPEM   bx,dx
        pop     bp
        ret
_loadtimer1 endp

;----------------------------====< loadPrescale >====-------------------------

;;
;;
;;
;;
;prescale = Nwparm1

        public _loadPrescale
_loadPrescale proc near
        push    bp

        mov     bp,sp
        push    dx
        mov     dx,PRESCALE_DIVIDER
        xor     dx,_gwTranslateCode
        mov     ax,Nwparm1      ;prescale
        out     dx,al
        pop     dx

        pop     bp
        ret
_loadPrescale endp


;
;
;
;
;------------------------------====< LoadDMA >====-----------------------------
;
; LoadDMA  -- Load the DMA controller to read/write data to the MV board
;
; Entry Conditions:
;
;
LoadDMA proc    near
        push    si

        mov     si,[DMAPointer]         ; point to the DMA controller table
        sub     dx,dx                   ; clear out the high byte

;
; kill the dma until all programming is done
;
        mov     al,[si+O_DMACH]         ; get the adjusted dma channel #
        or      al,0100b                ; causes all DMA to be suspended
        mov     dl,[si+O_DMAWRSMR]
        xor     dh,dh
        out     dx,al

        pause
;
; program the mode
;
        mov     al,[_TheDMAMode]        ; get the app's desired mode
        or      al,[si+O_DMACH]         ; get the adjusted dma channel #
        mov     dl,[si+O_DMAWRMODE]
        out     dx,al                   ; dma write mode register
;
; adjust the address for a 16 bit channel
;
        mov     ax,wptr [_dwDMAPhysAddr+2]      ; get the page #
;
; setup the page register
;
        mov     dx, [OurDMAPageReg]     ; DMA controller: page register
        out     dx,al
        mov     bl,al
;
; reset the flip-flop, then output the address, then count
;
        mov     dl,[si+O_DMACLEAR]      ; dh is still clear...
        out     dx,al                   ; flush...

        mov     ax,wptr [_dwDMAPhysAddr+0]      ; get the low 16 bits
        cmp     si,offset DMA1AddrTable ; 1st DMA controller?
        jz      @F                      ; yes, continue on...
        shr     bl,1                    ; no, divide the buffer in half
        rcr     ax,1                    ; by shifting 17 bits
    ; 
    @@:
        mov     dx,[OurDMAddress]       ; DMA controller: Address register
        out     dx,al
        pause
        xchg    ah,al
        out     dx,al

        mov     ax,[_wDMABuffLength]
        cmp     si,offset DMA1AddrTable ; is this the 2nd dma controller?
        jz      lodma03                 ; no, use the full length
        shr     ax,1
        inc     dx                      ; move to next port address
    ; 
    lodma03:
        inc     dx                      ; move to next port address
        out     dx,al
        pause
        xchg    ah,al
        out     dx,al
;
; before we enable the DMA, let's make sure the DRQ is controlled, not floating
;

        mov     al,[_crosschannel]      ; grab all but PCM/DRQ/MONO/DIRECTION
        mov     dx,CROSSCHANNEL
        xor     dx,_gwTranslateCode     ; get Translate code

        or      al,bCCdrq               ; set the DRQ bit to control it
        out     dx,al
        mov     [_crosschannel],al      ; and save the new state
;
; re-enable the dma now that all programming is done
;
        mov     al,[si+O_DMACH]         ; get the adjusted dma channel #
        sub     dx,dx                   ; clear dh
        mov     dl,[si+O_DMAWRSMR]
        out     dx,al                   ; & let'er loose (not moving though...)
;
; all done, return home...
;

        pop     si
        ret
LoadDMA endp


;
;
;
;
;------------------------------====< ReadDMA >====-----------------------------
;
; ReadDMA  -- Read the DMA controller to determine its current position
;
; Entry Conditions:
;
;
        public  _ReadDMA
_ReadDMA proc   near
        push    si

        mov     dx,[OurDMAddress]       ; DMA controller: Address register
        in      al,dx                   ; get lo
        pause
        xchg    ah,al
        in      al,dx                   ; get hi
        xchg    ah,al                   ; reverse order, of course

        mov     si,[DMAPointer]         ; point to the DMA controller table
        cmp     si,offset DMA1AddrTable ; 1st DMA controller?
        je      @F                      ; yes, continue on...
        shl     ax,1                    ; double to get 16-bit DMA addr
    @@:
        pop     si
        ret
_ReadDMA endp


IF 0
;
;
;---------------------------====< OurIntVector >====---------------------------
;
; OurIntVector  -- process MIDI and DMA interrupts
;
; This routine receives interrupts from the Media Vision hardware. This
; routine is used as a general purpose
;
        public  OurIntVector            ;; publicized for debugging
OurIntVector    proc    near
        pusha
        PUSHEM  ds,es
        cld                                     ; don't forget this...

        mov     ax,_DATA
        mov     ds,ax

        xor     bx, bx                          ; CLEAR FOUND OUR INTERRUPT FLAG

oiv_Start:
        mov     dx,INTRCTLRST                   ; clear the interrupt
        xor     dx,_gwTranslateCode             ; get Translate code
        in      al,dx                           ; by reading our register

ifdef CDPC_FRONT_PANEL
;
; attempt to process an AUX (CDPC front-panel) button interrupt
; 05/08/92 mmq
;
oiv_TestAUX:
        test    al,bISaux                       ; CDPC front panel int?
        jz      oiv_TestPCM                     ; no - check for PCM int

        dec     bx                              ; set 'found-interrupt' flag

        cmp     wptr [AUXUserRoutine+2],0       ; call the user function?
        jz      oiv_TestPCM                     ; no - check for PCM int

        ; no pushing necessary - AUXUser does a PUSHA

        call    dword ptr [AUXUserRoutine]      ; call the CDPC int handler
endif
;
; attempt to process a PCM interrupt
;
oiv_TestPCM:
        test    al,bISsampbuff                  ; our interrupt?
        jz      oiv_TestMIDI                    ; no - check for MIDI int

        DOUT1   <* PCM *>

        out     dx,al                           ; yes, flush it...
        dec     bx                              ; set 'found-interrupt' flag

        cmp     wptr [PCMUserRoutine+2],0       ; call the user function?
        jz      oiv_TestMIDI                    ; no - check for MIDI int

        push    ds
        call    dword ptr [PCMUserRoutine]      ; call the PCM int handler
        pop     ds
;
; attempt to process a MIDI interrupt
;
oiv_TestMIDI:
        test    al,bISmidi                      ; MIDI interrupt active?
        jz      oiv_CheckPending                ; no - check pending ints

        DOUT1   <* MIDI *>

        dec     bx                              ; set 'found-interrupt' flag

        cmp     wptr [MIDIUserRoutine+2],0      ; call the user function?
        jz      oiv_CheckPending                ; no - check pending ints

        push    ds
        call    dword ptr [MIDIUserRoutine]     ; call MIDI int handler
        pop     ds
;
; read in the interrupt register again, to make sure no other interrupts
; ocurred since we entered here.  05/12/92 mmq
;
oiv_CheckPending:

if 0
        mov     dx,INTRCTLR                     ; clear the interrupt
        xor     dx,_gwTranslateCode             ; get Translate code
        in      al,dx
        mov     ah,al                           ; get enabled lines
        xor     al,al
        out     dx,al                           ; disable ints
#endif

        mov     dx,INTRCTLRST                   ; clear the interrupt
        xor     dx,_gwTranslateCode             ; get Translate code
        in      al,dx
        and     al,bISsampbuff+bISmidi ; +bISaux ; any that we care about?
        jz      oiv_CheckAck                    ; no - do an ack check

#if 0
        mov     dx,INTRCTLR                     ; clear the interrupt
        xor     dx,_gwTranslateCode             ; get Translate code
        mov     al,ah                           ; get enabled lines
        out     dx,al                           ; restore ints
#endif

        DOUT1   < ** recursing ** >
        jmp     oiv_Start                       ; yes - handle pending ints

oiv_CheckAck:
#if 0
        mov     dx,INTRCTLR                     ; clear the interrupt
        xor     dx,_gwTranslateCode             ; get Translate code
        mov     al,ah                           ; get enabled lines
        out     dx,al                           ; restore ints
endif;0

        or      bx,bx                           ; did we service an interrupt?
        jnz     oiv_Ack                         ; yes - acknowledge it

        DOUT1   < ******** NO ACK INTERRUPT! ******** >
        jmp     oiv_Exit                        ; no - exit out

oiv_Ack:
;;;;    cmp     _fMIDIDeviceOpened,0            ; are we expecting MIDI?
;;;;    je      oiv_Exit
;;;;    call    ToggleMIDIIntEnable             ; if data in queue, cause int
oiv_Exit:
        POPEM   ds,es
        popa

OurIntVector    endp
ENDIF
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;

;
;
;---------------------------====< SetupPCMDMAIO >====--------------------------
;
; SetupPCMDMAIO  --  Setup to output to the DAC
;
SetupPCMDMAIO   proc    near
;
; setup the interrupt vector
;
;
; Load the PCM data register with silence
;
        mov     bx,_gwTranslateCode     ; get Translate code

        mov     dx,PCMDATA
        xor     dx,bx                   ;; xlate I/O addr

        xor     al,al                   ;; 16-bit silence value
        cmp     byte ptr _bBitsSample,8
        jne     bits16

        mov     al,80h                  ; PCM silence
bits16:
        out     dx,al
;
;
; Setup the Sample Buffer Counter Timer (T1 & rate generator)
;  the buffer timer interrupt is based on DRQs, not bytes
;

        mov     ax,[word ptr _dwDMAUnitSize+0]

        cmp     byte ptr _TheDMAChannel,5       ; 16bit DMA?
        jb      DMA8bit
        shr     ax,1                    ;; on 16-bit bus DRQ's happen less often
DMA8bit:
        push    ax
        call    _loadTimer1             ; expects bx not to be trashed
        add     sp,2                    ; remove parameter from stack
;
; Setup the Interrupt Control Register (On "out", it's a GO!)
;
        mov     dx,INTRCTLRST           ; flush any pending interrupts
        xor     dx,bx                   ;; xlate I/O addr
        in      al,dx                   ; of the PCM circuitry
        pause
        out     dx,al                   ;; future version!!!

        mov     dx,INTRCTLR
        xor     dx,bx                   ;; xlate I/O addr
        in      al,dx                   ; get the real mask
        or      al,bICsampbuff          ; interrupt on sample buffer count
        out     dx,al                   ; send it..
        mov     _intrctlr,al            ; save it..
;
; setup the direction, stereo/mono and DMA enable bits
;
        xor     al,al
        cmp     _fStereoMode,0          ; if stereo mode, don't set mono bit
        jne     @F
        mov     al,bCCmono              ; get the stereo/mono mask bit
@@:
        or      al, [PCMDirection]      ; get the direction bit mask
        or      al,bCCenapcm+bCCdrq     ; enable the PCM bit & DRQ
        mov     dx,CROSSCHANNEL
        xor     dx,bx                   ;; xlate I/O addr
        mov     ah,0fh                  ; get a mask to load non PCM bits
        and     ah,[_crosschannel]      ; grab all but PCM/DRQ/MONO/DIRECTION
        or      al,ah                   ; merge the two states

        xor     al,bCCenapcm            ; disable the PCM bit
        out     dx,al                   ; send to the hardware
        xor     al,bCCenapcm            ; enable the PCM bit
        out     dx,al                   ; send to the hardware
        mov     [_crosschannel],al      ; and save the new state

                                        ;; toggling enapcm sets L-R orienation
;
; Setup the audio filter sample bits
;
        mov     al,_audiofilt
        or      al,(bFIsrate+bFIsbuff)  ; enable the sample count/buff counters
        or      al,20h
        mov     dx,AUDIOFILT
        xor     dx,bx                   ;; xlate I/O addr
        out     dx,al
        mov     _audiofilt,al

        mov     NumberOfInterrupts,0
        mov     _DMARunning,1           ; set the global status word


        ;;;LeaveCrit a                  ; enableINT  ; Fly, baby Fly!!!
        sti

        ret

SetupPCMDMAIO   endp
;
;
;
;---------------------------====< StartRecording >====-------------------------
;
StartRecording  proc near
;
; save the type of setup for when we go to dismantle this code
;
        mov     [TypeOfSetup],DMAINPUT
        mov     [PCMDirection],00h      ; bit d6 of interrupt control register
;
; Select the DMA mode for recording
;
        mov     _TheDMAMode,54h         ; sets the RECORD direction
;
; Program the DMA, then our board circuitry to start the interrupts
;
        call    LoadDMA                 ; setup the DMA controller
        call    SetupPCMDMAIO           ; Setup the MV Hardware

        ret

StartRecording  endp
;---------------------====< NullRetfar >====---------------
;
        public  NullRetf
NullRetf        proc    far
        retf

NullRetf        endp

;
;   /*\
;---|*|
;---|*|------------====< _resetdmaptrs >====----------------
;---|*|
;---|*| Reset the DMA starting point
;---|*|
;---|*| Entry Conditions:
;---|*|     DS points to the default data segment
;---|*|
;---|*| Exit Conditions:
;---|*|     None
;---|*|
;   \*/

        public  _resetdmaptrs
_resetdmaptrs   proc    near
;
; reset the DMA buffer offset
;
        mov     ax,[_wDMAoffset]
        mov     wptr [_NextDMAPtr+0],ax
        mov     wptr _DMABufferPointer+0,ax
        mov     ax,[_wDMAselector]
        mov     wptr [_NextDMAPtr+2],ax
        mov     wptr _DMABufferPointer+2,ax
;
; reset the DMA auto-init-by-software-control flag
;

        ret

_resetdmaptrs   endp


;   /*\
;---|*| end of MVSOUND.ASM
;   \*/

_TEXT   ENDS
        end
