/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* mvprodd.h
*
* Media Vision modified version of audiodd.h from earlier toolkit.
* Contains Audio device driver function prototypes and externs of global data.
******************************************************************************/

/****************************************************************************/
/*                       T Y P E  D E F S                                   */
/****************************************************************************/
typedef USHORT             OFFSET;              // Used for segment offsets
typedef void near *        NPVOID;
typedef void far *         FPVOID;
typedef int (far    *FPFUNCTION) ();
typedef ULONG (FAR *PVDDFN) (ULONG, ULONG, ULONG);    // 'C' far call ptr to VDD entry point

/****************************************************************************/
/*                       D E F I N E S                                      */
/****************************************************************************/
#define LBUFFLEN        200

#define DEFAULTSTREAMS  15
#define MAXIOBUFFS       3

#define N16PROTOCOLS     17
#define N8PROTOCOLS      9
#define NUM_TRACKS       2

////#define DMA_BUFFER_MAX                      2048
#define DMA_BUFFER_MAX                  32768


#define  NUMGDTS 2L
#define GDT_PSTREAM     0
#define GDT_DMABUFF     1
#define PDD_VERISON     0x0501  // Version check constant.
                                // 05 - means the highest ulfunc this
                                // PDD can accept from VDD.  01 is the highest
                                // this PDD will send.

#define DEF_DMA_PAS     1       // default DMA address
#define DEF_INT_PAS     7       // default IRQ interrupt

#define DEF_DMA_16      5       // default DMA address
#define DEF_INT_16      7       // default IRQ interrupt

#define DEF_DMA_PLUS    1       // default DMA address
#define DEF_INT_PLUS    5       // default IRQ interrupt

#define DEF_DMA_CDPC    3       // default DMA address
#define DEF_INT_CDPC    7       // default IRQ interrupt

#define SYSEX_ERROR     0xFF    // internal error code for sysexes on input

#define SOUNDBLASTER_INT    5   // factory default
#define SOUNDBLASTER_EMUL_IRQ   EMUL_IRQ_5 // EMUL_IRQ must match SB INT!!
                                                                                                          // note: the SoundBlaster hardware
#define SOUNDBLASTER_EMUL_DMA   EMUL_DMA_1 // EMUL_DMA must match SB DMA!!
#define MPU_ADDR                                 0x330

#define MPU_IRQ         2
#define MPU_EMUL_IRQ    EMUL_IRQ_2

#define  SB_BASE_PORT   0x220



// who is using the interrupt

#define INT_FREE      0
#define INT_WAVEOUT   1
#define INT_WAVEIN    2
#define INT_MIDIIN    3

enum {
     STOP,
     PAUSE,
     PLAY
     };

/*---------------------====< MISCELLANEOUS DEFINES >====--------------------*/

#define MKLONG(i) (((long)i) & 0xffff)  // casts int into long & clears high word

//#define TRUE  1
//#define FALSE 0



/****************************************************************************/
/*                  D A T A   S T R U C T U R E S                           */
/****************************************************************************/

typedef struct _stream
   {
   HSTREAM         hStream;            // Unique stream handle
   ULONG           ulSysFileNum;       // id from kernel
                                       // PDDs have associated
                                       // file handle.
   ULONG           ulOperation;        // eg OPERATION_PLAY
   ULONG           ulFlags;            // State flags for this stream
   ULONG           ulCumTime;          // Current real-time stream position
   ULONG           ulCumTimeX10;       // For MIDI accuracy, stream time in .1 ms units
   ULONG           ulMaxPosition;      // total number of bytes in stream
   ULONG           ulDMABufferSize;    // retains PCM DMA buffer Size
   ULONG           ulTempo;            // MIDI Tempo
   ULONG           ulInterruptPeriod;  // Time between MIDI ints (.1 ms units)
   ULONG           ulPartPeriod;       // Time between each part of quarter note
   ULONG           ulMIDIStreamTimeX10;  // For MIDI accuracy, stream time in .1 ms units
   ULONG           ulDMABuffSize;      // PCM vs MIDI vs SYNTH vs SB
   ULONG           ulPCMBufferCount;      // PCM vs MIDI vs SYNTH vs SB
   USHORT          usPPQN;             // MIDI parts per quarter note
   USHORT          usDoneIOBuffIndex;  // index into iobuff struct that's finished playing
   USHORT          usCurrIOBuffIndex;  // index into current iobuff struct
   USHORT          usNextIOBuffIndex;  // index into next iobuff struct
   USHORT          usMode;             // PCM vs MIDI vs SYNTH vs SB
   PVOID           ADSHEntry;          // IDC entrypoint into stream handler
   MCI_AUDIO_IOBUFFER IOBuff[ MAXIOBUFFS ] ;
   ULONG           current_time;
   } STREAM ;

typedef STREAM far *PSTREAM;

/************************
 *   STREAM ulFlags     *
 ************************/
#define     STREAM_STREAMING             0x0002L
#define     STREAM_PAUSED                0x0004L
#define     STREAM_STOPPED               0x0008L
#define     STREAM_REGISTERED            0x0010L

/***************************************
 *   IOBuff usRunFlags
 * These are for the IOBuff defined in
 * Audio.h. (MMPM/2 Toolkit header file)
 ***************************************/
#define     IOB_STOPPED             0x0002L
#define     IOB_PAUSED              0x0004L
#define     IOB_STARTED             0x0008L
#define     IOB_RUNNING             0x0010L
#define     IOB_OVERRUN             0x0020L
#define     IOB_UNDERRUN            0x0040L
#define     IOB_CHAIN_BUFFERS       0x0080L
#define     IOB_PAUSECORRUPTED      0x0100L

typedef struct _global
   {
   PSTREAM     paStream;        // array ptr of stream structs
   PVOID       pDMABuffer;      // Virtual DMA buffer ptr
   BOOL        fInited;
   USHORT      usMaxNumStreams; // max # of streams from argument line
   ULONG       ulPDDHandle;     // PDD handle for VDD communication
   ULONG       VDDIDCOffset;    // 32 bit offset of VDD entry point ptr
   USHORT      VDDIDCSel;       // 16 bit selector of 48bit VDD entry point ptr
   } GLOBAL;

typedef GLOBAL *PGLOBAL;        // Pointer to dynamically allocated global
                                // table.  Pointer stored here in static memory


typedef struct  _protocol_table
   {
   ULONG   ulDataType;          // Characteristics of
   ULONG   ulDataSubType;       // stream types that this
   ULONG   ulBufSize;           // PDD supports.
   ULONG   ulNumBufs;
   ULONG   ulSampleRate;
   USHORT  usChannels;
   USHORT  usBitsPerSample;
   } PROTOCOLTABLE;

#define NUM_PORT_RANGES 11L
/*************************************************************************/
/* VDM support for AudioPDD communication to VDD                         */
/*************************************************************************/
typedef struct
   {
   ULONG ulPort;
   ULONG ulRange;
   } IORANGE;

typedef struct _adapterdata
   {
   USHORT  usIRQLevel;              // IRQ level of card
   USHORT  usDMALevel;             // DMA level of card
   ULONG   ulNumPorts;             // number of port ranges
   IORANGE range[NUM_PORT_RANGES];
} ADAPTERDATA;

typedef ADAPTERDATA  *PADAPTERINFO;

#define AVAILABLE       0                       // PDD available
#define NOT_AVAILABLE   2                       // PDD not available for use by VDM
#define VDM             4                       // PDD in use by VDM

#define VDM_INTR        0                       // PDD calls VDD at interrupt
#define VDM_CLOSE       1                       // PDD calls VDD at close time



typedef struct
   {
   ULONG pcm;           // PAS native DAC/ADC device
   ULONG sb;            // SB compat DAC/ADC device
   } PCMDEVICES;

typedef struct
   {
   ULONG pcm;           // PAS native DAC/ADC device
   ULONG midi;          // PAS MIDI interface
   ULONG synth;         // PAS OPL-2 or OPL3- synth
   ULONG sb;            // SB compat DAC/ADC device
   } DEVICES;

/*************************************************************************/
/* Device driver structures follow.                                      */
/*************************************************************************/

/*  Request Packet status bit values */
#define RPERR    0x8000 /*  error occurred, error code in RPstatuserr   */
#define RPDEV    0x4000 /*  also set ERR; error code defined by DD      */
#define RPBUSY   0x0200 /*  device is busy                              */
#define RPDONE   0x0100 /*  DD all done with request packet             */
#define RPBADCMD 0x0003 /*  DD recieved a     command                   */

#define AUDIO_ATTRIB    0xC880           //DEV_CHAR_DEV | DEV_IOCTL | DEV_SHARE | DEV_30 | DEVLEV_2 | DEV_GIOCTL

typedef struct  DeviceHdr
   {
   struct  DeviceHdr far * DHnext;         // link
   USHORT  DHattrib;                       // attribute
   NPVOID  DHstrategy;                     // &Strategy routine
   NPVOID  DHidc;                          // &IDC routine
   UCHAR   DHname[8];                      // DD name
   UCHAR   DHreserved[8];                  // reserved
   } DEVHDR;

/*  AttachDD Inter-device driver communication data area */

typedef struct AttachArea
   {
   USHORT  realOFF;        /* real-mode offset of idc entry point  */
   USHORT  realCS;         /* real-mode CS of IDC entry point      */
   USHORT  realDS;         /* real-mode DS of IDC DD               */
   USHORT  protOFF;        /* protect-mode offset of entry point   */
   USHORT  protCS;         /* protect-mode CS of entry point       */
   USHORT  protDS;         /* protect-mode DS of other DD          */
   } ATTACHAREA;


/*  The Request Packet */

typedef struct ReqPacket
   {
   UCHAR   RPlength;       /* request packet length                */
   UCHAR   RPunit;         /* unit code for block DD only          */
   UCHAR   RPcommand;      /* command code                         */
   USHORT  RPstatus;       /* status word                          */
   UCHAR   RPreserved[4];  /* reserved bytes                       */
   ULONG   RPqlink;        /* queue linkage                        */
   union
      {                   /* command-specific data                */
      UCHAR   avail[19];  /* available space, in 32-byte packet   */

      struct {    /*  INIT Packet (one for entry, one for exit)   */
             UCHAR      units;            /* number of units      */
             FPFUNCTION DevHlp;           /* &DevHlp              */
             char far  *args;             /* &args                */
             UCHAR      drive;            /* drive #              */
             } Init;                      /* available: 9 bytes   */

      struct {
             UCHAR      units;            /* same as input        */
             OFFSET     finalCS;          /* final code offset    */
             OFFSET     finalDS;          /* final data offset    */
             FPVOID BPBarray;             /* &BPB                 */
             } InitExit;

      struct {    /*  READ, WRITE, WRITE_VERIFY                   */
             UCHAR      media;            /* media descriptor     */
             ULONG      buffer;           /* transfer address     */
             USHORT     count;            /* bytes/sectors        */
             ULONG      startsector;      /* starting sector#     */
             USHORT     reserved;
             } ReadWrite;                 /* available: 6 bytes   */

      struct {    /*  IOCTL                                       */
             UCHAR      category;         /* category code        */
             UCHAR      function;         /* function code        */
             FPVOID               parameters;       /* &parameters          */
             FPVOID               buffer;           /* &buffer              */
             USHORT               sysfilenum;       /* see 16-16;unique num */
             } IOCtl;                     /* available: 9 bytes   */

      struct {    /*  READ_NO_WAIT                                */
             UCHAR      char_returned;    /* char to return       */
             } ReadNoWait;                /* available: 18 bytes  */

      struct {    /*  MEDIA_CHECK                                 */
             UCHAR      media;            /* media descriptor     */
             UCHAR      return_code;      /* see #defines         */
             FPVOID prev_volume;          /* &previous volume ID  */
             } MediaCheck;                /* available: 13 bytes  */

      struct {    /*  BUILD_BPB                                   */
             UCHAR      media;            /* media descriptor     */
             FPVOID buffer;               /* 1-sector buffer FAT  */
             FPVOID BPBarray;             /* &BPB array           */
             UCHAR      drive;            /* drive #              */
             } BuildBPB;                  /* available: 9 bytes   */

      struct {    /*  query PARTITIONABLE fixed disks             */
             UCHAR      count;            /* 1-based # disks      */
             ULONG      reserved;
             } Partitionable;             /* available: 14 bytes  */

      struct {    /*  Get Fixed Disk/Logical Unit Map             */
             ULONG      units;            /* units supported      */
             ULONG      reserved;
             } GetFixedMap;               /* available: 11 bytes  */

      } s;     /* command-Specific information */
   } REQPACKET;


typedef DEVHDR     near    *PDEVHDR;            // Ptr to device driver header
typedef ATTACHAREA near    *PATTACHAREA;        // Ptr to attachDD area
typedef REQPACKET  far     *PREQPACKET;         // ptr to request packet
typedef PREQPACKET far     *PPREQPACKET;
typedef PREQPACKET         QHEAD;               // Queue Head is &ReqPacket
typedef QHEAD      near    *PQHEAD;

/****************************************************************************/
/*              A B I O S    S U P P O R T                                  */
/****************************************************************************/

/* ABIOS Request Block */

typedef struct _ABIOSRB
   {
   USHORT RBLen;
   USHORT LID;
   USHORT Unit;
   USHORT Func;
   USHORT Resv1;
   USHORT Resv2;
   USHORT RetCode;
   USHORT TimeOut;
   } ABIOSRB;

/* Bus Type definitions */
#define ISA_BUS    0
#define MCA_BUS    1
#define EISA_BUS   2

/* Adapter Slot */
#define MAX_POS_SLOTS 8
#define MAX_EISA_SLOTS 16

#define CARD_ID 0x5103  /* your card id         */
#define LOGICAL_POS_ID  0x10

/*
** ABIOS Request Block for obtaining LID parameters.
** uses this to obtain RB length for Reading POS).
*/
typedef struct _POSLENRB
   {
   ABIOSRB     rb;
   UCHAR       HWIntLevel;                   /* 0x10 */
   UCHAR       ArbitrationLevel;             /* 0x11 */
   USHORT      DeviceID;                     /* 0x12 */
   USHORT      NumberOfUnits;                /* 0x14 */
   USHORT      Flags;                        /* 0x16 */
   USHORT      RBLen;                        /* 0x18 */
   UCHAR       Rsv1;                         /* 0x1a */
   UCHAR       RevisionLevel;                /* 0x1b */
   USHORT      Rsv2;                         /* 0x1c */
   USHORT      Rsv3;                         /* 0x1e */
   } POSLENRB;

/* ABIOS Request Block for Reading POS Data*/
#define POSRB_PAD_LENGTH 0x20

// The length of this structure is machine dependent.  We have
// seen total lengths of 0x20 and 0x21.  Padding this out with
// 0x20 bytes is probably safe for the future.
typedef struct _POSRB
   {
   ABIOSRB     rb;
   UCHAR       Slot;                         /* 0x10 */
   UCHAR       Rsv1;                         /* 0x11 */
   USHORT      AdapterID;                    /* 0x12 */
   USHORT      Rsv2;                         /* 0x14 */
   ULONG       DataBuf;                      /* 0x16 */
   USHORT      Rsv3;                         /* 0x1a */
   USHORT      Rsv4;                         /* 0x1c */
   UCHAR       dummy[POSRB_PAD_LENGTH];      /* 0x1e */
   } POSRB;

/****************************************************************************/
/*              F U N C T I O N   P R O T O T Y P E S                       */
/****************************************************************************/

//**************************************************
//      ABIOS Routines (Device Auto-scan)
//**************************************************
USHORT  Init_POS (void);

//**************************************************
//      VDM Support routines
//**************************************************
ULONG   PDDInternalEntryPoint(ULONG ulFunc, ULONG ul1, ULONG ul2);
ULONG   CallVDD (ULONG  ulOfs,
                 USHORT usSel,
                 ULONG  ulFunc,
                 ULONG  ul1,
                 ULONG  ul2);

VOID    VDMInterruptTime(void);
VOID    VDMClose(void);
//**************************************************
//      Data Moving routines
//**************************************************
VOID    SetupPointers    (void);
UINT    WriteDataToCard  (PSTREAM);
UINT    ReadDataFromCard (PSTREAM);         // Device dependent
VOID    RestorePointers  (void);
VOID    EOI              (void);
VOID    FAR InterruptHandler(void);

//**************************************************
//      IOCTL  routines
//**************************************************
ULONG  Strategy_c                (PREQPACKET rp);
ULONG  IOCTL_Init                (PREQPACKET rp);
ULONG  IOCTL_Read                (PREQPACKET rp);
ULONG  IOCTL_NondestructiveRead  (PREQPACKET rp);
ULONG  IOCTL_ReadStatus          (PREQPACKET rp);
ULONG  IOCTL_FlushInput          (PREQPACKET rp);
ULONG  IOCTL_Write               (PREQPACKET rp);
ULONG  IOCTL_WriteStatus         (PREQPACKET rp);
ULONG  IOCTL_FlushOutput         (PREQPACKET rp);
ULONG  IOCTL_Open                (PREQPACKET rp);
ULONG  IOCTL_Close               (PREQPACKET rp);
ULONG  IOCTL_Input               (PREQPACKET rp);
ULONG  IOCTL_Invalid             (PREQPACKET rp);
ULONG  IOCTL_Output              (PREQPACKET rp);
ULONG  IOCTL_GenIoctl            (PREQPACKET rp);

//**************************************************
//      STANDARD AUDIO IOCTL  routines
//**************************************************
ULONG   Audio_IOCTL_Init         (PVOID pParm);
ULONG   Audio_IOCTL_Status       (PVOID pParm);
ULONG   Audio_IOCTL_Control      (PVOID pParm);
ULONG   Audio_IOCTL_Buffer       (PVOID pParm);
ULONG   Audio_IOCTL_Load         (PVOID pParm);
ULONG   Audio_IOCTL_Wait         (PVOID pParm);
ULONG   Audio_IOCTL_Hpi          (PVOID pParm);

ULONG   InitStreams              (VOID);
ULONG   ParseArgs                (PUCHAR args);
USHORT  AllocDMABuffer           (VOID);
