/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* mvprodd.c - Audio device driver strategy and IOCTL routines
*
* DESCRIPTION:
* This audio device driver is an OS/2 16-bit  Physical Device driver
* designed to demonstrate audio device communication with the
* MMPM/2 stream handler.
* Information on OS/2 Physical Device Drivers architecture and
* programming is in the "OS/2 2.0 Physical Device Driver reference"
*
* MMPM/2 streaming architecture is outlined in "MMPM/2 Programmers Workbook"
* - Data Streaming & synchronization chapter
* Specifix information on interdevice communication is in the
* same document in the "Stream Handler" Chapter in the section on
* "Interdevice-driver-communication
*
*/

#define  INCL_DOSINFOSEG
#include <os2.h>

#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include <meerror.h>
#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "cdevhlp.h"
#include "findpas.h"
#include "proto.h"
#include "globals.h"
#include "debug.h"
#include "commdbg.h"

#include "parse.cdf"
#include "adlib.h"
#include "parse.ext"
#include "rmhelp.h"


extern PDDEntryPoint();                // located in startup.asm

extern ULONG      (*IOCTLFuncs[])(PREQPACKET rp);
extern MaxIOCTLFuncs;
extern ULONG      (*AudioIOCTLFuncs[])(PVOID pParm);
extern MaxAudioIOCTLFuncs;
extern FPVOID     DevHlp;
extern USHORT     EndOfCode;            // in endsegs.asm
extern USHORT     EndOfData;
extern ATTACHAREA AttachArea;
extern SZ         szDevName[9];
extern POSLENRB   POSLenRB;
extern POSRB      ABIOSrb;
extern POSCardID[];
extern DEVHDR     DevHdr[];
extern USHORT     usPauseDMAAddr;

extern WORD mixMessage (WORD  id,
                        WORD  msg,
                        WORD  wParam1,
                        DWORD dwParam1,
                        DWORD dwParam2,
                        DWORD dwParam3,
                        DWORD dwParam4);

USHORT  usGDT[NUMGDTS];
USHORT  usNumOS2Opens = 0;
USHORT  usNumHeaders  = 1;


FPVOID   Device_help;         // FOR RESOURCE MANAGER DEV HELP CALL

/*                                      -------------------------- Strategy_c -
** DD strategy control after entry from assembler Strategy routine.
*/
ULONG Strategy_c (PREQPACKET rp)
{
   if (rp->RPcommand > (UCHAR)MaxIOCTLFuncs) // check for valid function
      return (RPDONE | RPERR | RPBADCMD);

   return(IOCTLFuncs[rp->RPcommand](rp));  // call request function
                                           // then return its rc
}


                                        //-------------------  IOCTL_Invalid -
ULONG IOCTL_Invalid (PREQPACKET rp)
{
   return (RPDONE | RPERR | RPBADCMD);
}

/*
** Hardware communication routines
** Implementation of these functions is dependant on interfaces and physical
** characteristics of the card.
** IOCTLs listed below are OS/2 defined IOCTLs.  Additional IOCTLs arrive
** from applications and MMPM/2 through the OS/2 generic IOCTL.
*/

/*                                      -------------------------- IOCTL_Read -
** Stub, read from device.  Implemention dependant on hardware architecture.
*/
ULONG IOCTL_Read (PREQPACKET rp)
{
   #ifdef PROGRESS_MONITOR
   StringOut( "IOCTL_Read");
   #endif
   // ReadDataFromCard();     // Stub routine
   return (RPDONE);
}

/*
** Stub, routine performing nondestructive read operation.
** This read operation reads data from a buffer without removing that data.
*/
ULONG IOCTL_NondestructiveRead (PREQPACKET rp)
{
   return (RPDONE);
}

ULONG   IOCTL_ReadStatus (PREQPACKET rp)
{
   ReadStatus();
   return (RPDONE);
}

ULONG IOCTL_FlushInput (PREQPACKET rp)
{
   FlushInputBuffers();
   return (RPDONE);
}

ULONG IOCTL_Write (PREQPACKET rp)
{
   #ifdef PROGRESS_MONITOR
   StringOut( "IOCTL_Write");
   #endif
   // WriteDataToCard ();
   return(RPDONE);
}

ULONG IOCTL_WriteStatus (PREQPACKET rp)
{
   #ifdef PROGRESS_MONITOR
   StringOut( "IOCTL_Status");
   #endif
   WriteStatus();
   return (RPDONE);
}

ULONG IOCTL_FlushOutput (PREQPACKET rp)
{
   #ifdef PROGRESS_MONITOR
   StringOut( "IOCTL_Flush");
   #endif
   FlushOutputBuffers();
   return (RPDONE);
}

/*                                      -------------------------- IOCTL_Open -
** Prepare device for operations.
*/
ULONG IOCTL_Open (PREQPACKET rp)
{
   /*
   ** Open device, hook interrupts
   **
   ** AUDINTR.C contains a sample
   ** interrupt handler demonstrating
   ** communication with the MMPM/2 stream handler.
   */

   #ifdef PROGRESS_MONITOR
   StringOut ("IOCTL_Open");
   #endif

   if (usInUse & VDM)                 // Is device being used by a VDM?
      return (RPDONE|RPERR);          // yes, return error

   if (DevOpen())
      {                               // set inuse flag so that a VDM can't use us
      usNumOS2Opens++;
      return (RPDONE);
      }
   else
      return (RPDONE|RPERR);
}

/*                                      ------------------------- IOCTL_Close -
** Opposite of open.  Clean up system resources.  If any activity is in
** process, it needs to be ended.
*/
ULONG IOCTL_Close (PREQPACKET rp)
{
   /*
   ** Destroy streams, turn off
   ** any hung notes, close device
   */
   #ifdef PROGRESS_MONITOR
   StringOut ("IOCTL_Close");
   #endif

   usNumOS2Opens--;
   //DevClose();
   if (usNumOS2Opens == 0)      // Only call VDD when
      {                         // all OS2 processes are closed
      DevClose();
      VDMClose();
      }
   return(RPDONE);
}

ULONG IOCTL_Input (PREQPACKET rp)
{
   return(RPDONE);
}

ULONG IOCTL_Output (PREQPACKET rp)
{
   return(RPDONE);
}

/*                                      //------------------- IOCTL_GenIOCTL -
** Valid category : 0x80
** Valid functions: 0x40 - 0x5f
*/
ULONG IOCTL_GenIOCTL (PREQPACKET rp)
{
   LPMIXPARM lpP=rp->s.IOCtl.parameters;

   if (rp->s.IOCtl.category == 0x80)         // must be proper category
      {
      // Defect 12237 - IOCTL out of range causes trap
      // The check should be >= as jump table is zero based.
      // New IOCTL is being defined for capabilities.
      // JHN 29-Mar-94
      if ((rp->s.IOCtl.function < (UCHAR)0x40) ||
          (rp->s.IOCtl.function >= ((UCHAR)0x40+(UCHAR)MaxAudioIOCTLFuncs)))
         return(RPDONE | RPERR | RPBADCMD);

      AudioIOCTLFuncs[rp->s.IOCtl.function-0x40](rp);  // call request function
      }

   else
      {
      //PrintfOut( "Unknown General IOCTL CATEGORY:%x   FUNCTION:%x",
      //              rp->s.IOCtl.category,
      //              rp->s.IOCtl.function);
      if (rp->s.IOCtl.category == MIXER_CATEGORY)  // must be proper category
         {
         WORD msg=rp->s.IOCtl.function-0x40;
         msg += MIXDM_BASE;

         #ifdef MIX_MONITOR
         PrintfOut ("Mixer IOCTL FUNCTION:%x  Message=%x",
                    rp->s.IOCtl.function,
                    msg);
         #endif

         lpP->dwRetVal=mixMessage(0, msg,(WORD) lpP->wParam1,lpP->dwParam1,lpP->dwParam2,lpP->dwParam3,lpP->dwParam4);
         }
      } // end else
   return (RPDONE);
}


/******************************************************************************
*********** THE FOLLOWING ROUTINES ARE CALLED FROM THE GENERAL IOCTL **********
***********  ROUTINE ABOVE.  THESE AUDIO IOCTLS ARE DEFINED BY MMPM  **********
******************************************************************************/

BOOL Rewind1Buffer (PSTREAM pStream)
{
   USHORT usCurr;

   usCurr=pStream->usCurrIOBuffIndex;
   if (usCurr==pStream->usDoneIOBuffIndex)
      {
      #ifdef DEBUG_CHK
      StringOut("ERROR: Tried to rewind beyond extant stream");
      #endif
      return(FALSE);         // backed up all the way!
      }

   if (usCurr)
      usCurr--;
   else
      usCurr=MAXIOBUFFS-1;

   pStream->usCurrIOBuffIndex=usCurr;

   pStream->IOBuff[usCurr].pHead=
      pStream->IOBuff[usCurr].pBuffer;

   pStream->IOBuff[usCurr].lCount=
      pStream->IOBuff[usCurr].pTail-
      pStream->IOBuff[usCurr].pHead;

   return (TRUE);         // backed up all the way!
}


                                        //------------------ Audio_IOCTL_Init -
ULONG Audio_IOCTL_Init (PREQPACKET pParm)
{
   BOOL               fFoundStream = FALSE;
   WORD               wSampleBits;
   ULONG              ulFlags = 0;
   MCI_AUDIO_INIT FAR *pInit  = (MCI_AUDIO_INIT FAR *)pParm->s.IOCtl.buffer;
   USHORT             i, j;
   PSTREAM            pStream;
   ULONG              ulCurBufDelta;
   ULONG              ulCurPosition;
   ULONG              ulRewindAmount;
   USHORT             usPauseDelta;
   USHORT             Current;
   USHORT             usPrev;


   // retrieving system file number from request packet
   // and stuffing it into audio_init struct

   pInit->pvReserved  = (VOID FAR *)((PREQPACKET) pParm)->s.IOCtl.sysfilenum;
   pInit->sReturnCode = 0;

   // make sure we can handle the format

   switch (pInit->sMode)
      {
      case PCM:  /* Pulse Coded Modulation */
         #ifdef PROGRESS_MONITOR
         StringOut ("Audio_IOCTL_Init  ***INIT PCM ***");
         #endif
         ulActiveSysFileNum.pcm=(ULONG) pInit->pvReserved;
         ulActiveSysFileNum.sb =(ULONG) pInit->pvReserved;

         iNextBuffer = 0;
         iEmptyPCMBuffers = 2;
         break;

      case MIDI:  /* MIDI data */
         #ifdef PROGRESS_MONITOR
         StringOut ("Audio_IOCTL_Init  ***INIT MIDI ***");
         #endif
         ulActiveSysFileNum.midi  = (ULONG) pInit->pvReserved;
         ulActiveSysFileNum.synth = (ULONG) pInit->pvReserved;
         break;

      case IDLE:
         #ifdef PROGRESS_MONITOR
         StringOut ("Audio_IOCTL_Init  *** DE-INIT (IDLE)***");
         #endif
         // set stream to be stopped   (handled by PAUSE which would precede)
         // set IO bufs to be stopped  (handled by MMDDCMD.C DDCMD_PAUSE)
         iNextBuffer = 0;
         iEmptyPCMBuffers = 2;

         pStream = GlobalTable.paStream;
         for (i=0; i<GlobalTable.usMaxNumStreams; i++, pStream++)
            if ((pStream->hStream != -1) &&
                (pStream->ulSysFileNum == (ULONG) pInit->pvReserved))
               {
               if ((pStream->ulFlags & STREAM_PAUSED)==0)
                  {
                  #ifdef DEBUG_CHK
                  StringOut("DE-INIT (IDLE)called, stream not in paused state");
                  #endif
                  ;
                  }
               else
                  fFoundStream=TRUE;
               break;
               }

         if (!fFoundStream)
            {
            #ifdef DEBUG_CHK
            StringOut ("Error DE-INIT couldn't find stream");
            #endif
            return (RPDONE);
            }

         if (pStream->usMode==PCM)
            {
            for ( j=0; j < MAXIOBUFFS; j++ )
               pStream->IOBuff[j].usRunFlags |= IOB_PAUSECORRUPTED;
            #ifdef PROGRESS_MONITOR
            StringOut ("Marking paused buffer corrupt.");
            #endif

            // retains PCM DMA buffer Size
            pStream->ulDMABufferSize = gdCurrentDMABufferSize;

            /*
            ** To Determine the current Stream Position,
            ** the following questions must be asked:
            **
            ** Which Buffer was it paused in?
            ** How far from start of DMA buffer? (ReadDMA)
            ** What is stream Position of DMA Semi buffer start?
            ** What is current position of stream (not yet copied to DMA buf)
            **  Psuedocode:
            **     PausePos=Position of DMA SemiBuffer + (ReadDMA-BufferStart)
            **     RewindAmount = (CurrPos - PausePos);
            */

            // offset from start of buffer
            usPauseDelta = usPauseDMAAddr - LOUSHORT(dwDMAPhysAddr);

            // SemiBuffer A
            if ((DWORD)usPauseDelta < (gdCurrentDMABufferSize/2))
               {
               if (ulPCM_PosSemiBufA == (ULONG) - 1L)
                  {
                  usPrev=pStream->usCurrIOBuffIndex;    // index to final buf
                  if (usPrev)
                     usPrev--;
                  else
                     usPrev=MAXIOBUFFS-1;

                  ulStreamPosition.pcm =
                     pStream->IOBuff[usPrev].ulPosition +
                     (pStream->IOBuff[usPrev].pTail-pStream->
                        IOBuff[usPrev].pBuffer);
                  }
               else
                  ulStreamPosition.pcm=ulPCM_PosSemiBufA+(ULONG)usPauseDelta;
               }
            else
               {
               usPauseDelta-=(USHORT) (gdCurrentDMABufferSize/2);
               {
               if (ulPCM_PosSemiBufB == (ULONG)-1L)  // past stream end?
                  {
                  usPrev=pStream->usCurrIOBuffIndex; // index to final buffer
                  if (usPrev)
                     usPrev--;
                  else
                     usPrev=MAXIOBUFFS-1;

                  ulStreamPosition.pcm =
                     pStream->IOBuff[usPrev].ulPosition +
                     (pStream->IOBuff[usPrev].pTail-pStream->
                        IOBuff[usPrev].pBuffer);
                  }
               else
                  ulStreamPosition.pcm=ulPCM_PosSemiBufB+(ULONG)usPauseDelta;
               }
            }

            #ifdef BUF_MONITOR
            PrintfOut ("Paused at Stream Position %0ld (bytes)",
                       ulStreamPosition);
            #endif

            Current = pStream->usCurrIOBuffIndex;
            ulCurPosition=pStream->IOBuff[Current].ulPosition +
                                      (pStream->IOBuff[Current].pHead -
                                       pStream->IOBuff[Current].pBuffer);

            if ((ulStreamPosition.pcm < ulCurPosition) ||
                (pStream->usCurrIOBuffIndex==pStream->usNextIOBuffIndex))
               {
               if (!Rewind1Buffer(pStream))
                  {
                  #ifdef BUF_MONITOR
                  StringOut ("Warning: Unable to rewind");
                  #endif
                  ulRewindAmount=0;
                  }
               else
                  ulRewindAmount=ulCurPosition - ulStreamPosition.pcm;
               }

            while (ulRewindAmount)
               {
               ulCurBufDelta= pStream->IOBuff[Current].pHead -
                              pStream->IOBuff[Current].pBuffer;

               if (ulRewindAmount < ulCurBufDelta)
                  {
                  pStream->IOBuff[Current].pHead-=ulRewindAmount;
                  pStream->IOBuff[Current].lCount+=ulRewindAmount;
                  ulRewindAmount = 0;
                  #ifdef DEBUG_CHK
                  if (pStream->IOBuff[Current].lCount >
                       (pStream->IOBuff[Current].pTail -
                        pStream->IOBuff[Current].pHead))
                     {
                     pStream->IOBuff[Current].lCount =
                        pStream->IOBuff[Current].pTail -
                        pStream->IOBuff[Current].pHead;
                     StringOut
                        ("ERROR: buffer math out of bounds.  Corrected.");
                     }
                  #endif
                  }
               else
                  {
                  pStream->IOBuff[Current].pHead =
                     pStream->IOBuff[Current].pBuffer;
                  pStream->IOBuff[Current].lCount+=ulCurBufDelta;
                  ulRewindAmount-=ulCurBufDelta;

                  #ifdef DEBUG_CHK
                  if (pStream->IOBuff[Current].lCount > (
                                          pStream->IOBuff[Current].pTail-
                                          pStream->IOBuff[Current].pHead))
                     {
                     pStream->IOBuff[Current].lCount =
                        pStream->IOBuff[Current].pTail -
                        pStream->IOBuff[Current].pHead;
                     StringOut
                        ("ERROR: buffer math out of bounds.  Corrected.");
                     }
                  #endif

                  if (!Rewind1Buffer(pStream))
                     {
                     #ifdef BUF_MONITOR
                     StringOut ("Warning: Unable to rewind!");
                     #endif
                     ulRewindAmount = 0;
                     }
                  else
                     Current = pStream->usCurrIOBuffIndex;
                  }
               }
            }  // end if PStream->usMode==PCM

         else
            {   // PStream->usMode==MIDI
            #ifdef PROGRESS_MONITOR
            StringOut ("IDLE acknowledged for MIDI stream");
            #endif
            ;
            }
         return (RPDONE);

         // #if 0
         // case CLAIM_HDWR:                     /* Serialize access to hardware  */
         // case SOURCE_MIX:                      /* External audio source  */
         // case ADPCM:                           /* AVC type ADPCM         */
         // case MU_LAW:                          /* mu-law                 */
         // case A_LAW:                           /* a-law                  */
         // case SPV2:                            /* Speech Viewer/2        */
         // case ADPCMXA:                         /* XA CD ROM              */
         // case SPV2BCPCM:                       /* Speech Viewer/2        */
         // case SPV2PCM:
         // case SPV2NONE:
         // #endif

      default:
         #ifdef DEBUG_CHK
         StringOut ("Audio_IOCTL_Init  ***MODE NOT SUPPORTED***");
         #endif
         pInit->sReturnCode = NO_RECORD_AND_PLAY;
         return (RPDONE|RPERR);
      } // end switch

   if (pInit->ulOperation == PLAY_AND_RECORD)
      return(RPDONE|RPERR|NO_RECORD_AND_PLAY);

   if ((pInit->ulOperation != OPERATION_PLAY ) &&
       (pInit->ulOperation != OPERATION_RECORD ))
       return(RPDONE|RPERR|INVALID_REQUEST );

   if (pInit->sMode==PCM)
      {
      if (pInit->sChannels < 1)
         {
         pInit->sChannels = 1;
         ulFlags |= BESTFIT_PROVIDED;
         }
      else
         if (pInit->sChannels > 2)
            {
            pInit->sChannels = 2;
            ulFlags |= BESTFIT_PROVIDED;
            }

      if (pInit->lSRate < 2000)
         {
         pInit->lSRate=2000;
         ulFlags |= BESTFIT_PROVIDED;
         }
      else if (pInit->lSRate > 48000)
         {
         pInit->lSRate=48000;
         ulFlags |= BESTFIT_PROVIDED;
         }

      wSampleBits=(WORD) pInit->lBitsPerSRate;

      #ifdef DEBUG_CHK
      PrintfOut ("Audio Init bits per sample=%d", wSampleBits);
      #endif

      if (pf.ProCard[gwBoardIndex].Caps.CapsBits.DAC16)
         {
         if ((wSampleBits != 8 ) &&
             (wSampleBits != 16))
            {
            pInit->lBitsPerSRate=16;
            ulFlags |= BESTFIT_PROVIDED;
            }
         }
      else
         {
         if (wSampleBits != 8)
            {
            pInit->lBitsPerSRate=8;
            ulFlags |= BESTFIT_PROVIDED;
            }
         }

      bBitsSample=LOBYTE(wSampleBits);

      resetdmaptrs ();          // for PAS PCM

      #ifdef DEBUG_CHK
      PrintfOut ("Audio Init number of channels=%d",(WORD) pInit->sChannels);
      #endif

      calcSampleRate ((DWORD) pInit->lSRate,
                      (WORD) pInit->sChannels,
                      (WORD) bBitsSample);

      ulFlags |= FIXED;                 // Fixed length data
      ulFlags |= LEFT_ALIGNED;          // Left align bits on byte bndry
      if (pInit->lBitsPerSRate == 8)
         ulFlags|= TWOS_COMPLEMENT;     // 2's complement data
      } // end if (pInit->sMode==PCM)


   ulFlags |= INPUT;            /* Input select is supported     */
   ulFlags |= OUTPUT;           /* Output select is supported    */
   ulFlags |= MONITOR;          /* Monitor is supported          */
   ulFlags |= VOLUME;           /* Volume control is supported   */
   ulFlags |= VOLUME_DELAY;     /* Volume delay is supported     */
   ulFlags |= BALANCE;          /* Balance control is supported  */
   ulFlags |= BALANCE_DELAY;    /* Balance delay is supported    */
   ulFlags |= TREBLE;                                                            /* Treble control is supported   */
   //ulFlags|= BASS;              /* Bass control supported        */

   pInit->ulFlags=ulFlags;

   /*
   ** Copy parameters to our global variables
   ** in case any of them have changed.
   */
   switch (pInit->sMode)
      {
      case PCM:
         operation.pcm = pInit->ulOperation;
         operation.sb  = pInit->ulOperation;
         flags.pcm     = pInit->ulFlags;
         flags.sb      = pInit->ulFlags;
         break;

      case MIDI:
         operation.midi  = pInit->ulOperation;
         operation.synth = pInit->ulOperation;
         flags.midi      = pInit->ulFlags;
         flags.synth     = pInit->ulFlags;
         break;
      }

   srate.pcm           = pInit->lSRate;
   bits_per_sample.pcm = pInit->lBitsPerSRate;
   bsize.pcm           = pInit->lBsize;
   channels.pcm        = pInit->sChannels;

   pInit->sDeviceID=PAS16;              // 4d01, 5601  V+card type
   pInit->sSlotNumber=-1;
   pInit->lResolution=10;

   return(RPDONE);
}


/*                                      ------------------ Audio_IOCTL_Status -
** Query status of audio device in accordance with stream handler spec.
*/
ULONG Audio_IOCTL_Status (PREQPACKET rp)
{
   #ifdef PROGRESS_MONITOR
   StringOut ("================Audio_IOCTL_Status=======================");
   #endif

   DevIOCTLstatus ((LPMCI_AUDIO_STATUS) rp);
   return (RPDONE);
}


                                        //--------------- Audio_IOCTL_Control -
ULONG Audio_IOCTL_Control (PREQPACKET rp)
{

   LPMCI_AUDIO_CONTROL pControl = (LPMCI_AUDIO_CONTROL) rp->s.IOCtl.buffer;

   #ifdef PROGRESS_MONITOR
   StringOut ("AUDIO_IOCTL_CONTROL");
   #endif

   gulFocusSysFileNum = rp->s.IOCtl.sysfilenum;

   switch (pControl->usIOCtlRequest)
      {
      case AUDIO_CHANGE:
         #ifdef PROGRESS_MONITOR
         StringOut
            ("================Audio_IOCTL_Change=======================");
         #endif
         DevChange ((LPMCI_AUDIO_CHANGE) pControl->pbRequestInfo);
         break;

      case AUDIO_START:
         #ifdef PROGRESS_MONITOR
         StringOut ("========================Audio_IOCTL_Start");
         #endif
         //DevStart();
         break;

      case AUDIO_STOP:                          // Stop current operation
         #ifdef PROGRESS_MONITOR
         StringOut ("========================Audio_IOCTL_Stop");
         #endif
         //DevStop();
         break;

      case AUDIO_PAUSE:                         // suspend current operation
         #ifdef DEBUG_CHK
         StringOut ("========================Audio_IOCTL_Paws");
         #endif
         //DevPause();
         break;

      case AUDIO_RESUME:                        // resume a suspended operation
         #ifdef DEBUG_CHK
         StringOut ("========================Audio_IOCTL_Resume");
         #endif
         //DevResume();
         break;

      default:                                  // Unknown control
         #ifdef DEBUG_CHK
         PrintfOut( "Unknown Audio_IOCTL_Control Message=%d",rp->RPcommand);
         #endif
        return (-1);                                    /* return an error */
         break;
                }
        return(RPDONE);
}

                                        //---------------- Audio_IOCTL_Buffer -
ULONG Audio_IOCTL_Buffer (PREQPACKET rp)
{
   //VOID   pParm;

   #ifdef PROGRESS_MONITOR
        StringOut( "Audio_IOCTL_Buffer");
   #endif

   //pParm = rp->s.IOCtl.parameters;
   //DevAudioBuffer();
   return(RPDONE);
}


                                        //------------------ Audio_IOCTL_Load -
ULONG Audio_IOCTL_Load (PREQPACKET rp)
{
  // PVOID   pParm;

   #ifdef PROGRESS_MONITOR
   StringOut( "Audio_IOCTL_Load");
   #endif
   //pParm = rp->s.IOCtl.parameters;
   //DevIOCTLload();                    // We don't have to load a DSP!
   return(RPDONE);
}


                                        //------------------ Audio_IOCTL_Wait -
ULONG Audio_IOCTL_Wait (PREQPACKET rp)
{
   //PVOID   pParm;
   #ifdef PROGRESS_MONITOR
   StringOut( "Audio_IOCTL_Wait");
   #endif
   //pParm = rp->s.IOCtl.parameters;
   //DevIOCTLwait();
   return(RPDONE);
}



                                        //------------------- Audio_IOCTL_Hpi -
ULONG Audio_IOCTL_Hpi (PREQPACKET rp)
{
   //PVOID   pParm;

   #ifdef PROGRESS_MONITOR
   StringOut( "Audio_IOCTL_HPI");
   #endif
   //pParm = rp->s.IOCtl.parameters;

   //DevIOCTLhpi ();
   return(RPDONE);      // PAS-16 driver doesn't not support HPI
}


/*****************************************************************************/
/*                      PDD INITIALIZATION CODE                              */
/*****************************************************************************/

/*                                      -------------------------- IOCTL_Init -
** PDD initialization code - called from strategy routine.
*/
ULONG IOCTL_Init (PREQPACKET rp)
{
   USHORT   rc, i;
   PSZ      szNum;
   char far * s1;
   char far * s2;

   //_asm int 3

   operation.pcm   = OPERATION_PLAY;
   operation.midi  = OPERATION_PLAY;
   operation.synth = OPERATION_PLAY;
   operation.sb    = OPERATION_PLAY;

   ulActiveSysFileNum.pcm   = 0;
   ulActiveSysFileNum.midi  = 0;
   ulActiveSysFileNum.synth = 0;
   ulActiveSysFileNum.sb    = 0;

   ulStreamPosition.pcm   = 0;
   ulStreamPosition.midi  = 0;
   ulStreamPosition.synth = 0;
   ulStreamPosition.sb    = 0;

   flags.pcm   = 0;
   flags.midi  = 0;
   flags.synth = 0;
   flags.sb    = 0;

   /*
   ** Set variable in data segement to point to the
   ** OS/2 DevHlp entry point.  The address of this
   ** routine is in the DevHdr data structure.
   ** This address will be referenced device driver calls
   ** to the kernel provided device helpers
   ** Note, this must be done before setting final segment sizes
   ** as the fields overlay each other in the request packet.
   */
   Device_help = DevHlp = (char far *) rp->s.Init.DevHlp;

   /*
   ** Assume we won't be truncating the code and data segments
   ** Truncation is done only on the final init call
   */
   rp->s.InitExit.finalCS = (OFFSET)&EndOfCode;
   rp->s.InitExit.finalDS = (OFFSET)&EndOfData;

   if (!GlobalTable.fInited)            // don't init both headers
      GlobalTable.fInited = TRUE;       // This is the first init
   else
      {
      /*
      ** We've already inited.  This is the last (second) init call.
      ** Tell the kernel where our initialization code and data start.
      ** The kernel will truncate the segments upon our return.
      */
      rp->s.InitExit.finalCS = (OFFSET)&IOCTL_Init; // Toss init code
      rp->s.InitExit.finalDS = (OFFSET)&EndOfData;  // Don't truncate data
      return (RPDONE);
      }

   /*
   ** Execution only makes it to this point on the first init call.
   */
   usNumOS2Opens = 0;

   ParseArgs(rp->s.Init.args);         // Get CONFIG.SYS command line

   if (usNumHeaders == 1)            // config.sys did not have 2nd hdr name
      DevHdr[0].DHnext = (PVOID)0xffffffff;

   /******************************************************************/
   /* Search device header chain to find next available audio header */
   /******************************************************************/
   if (! (DevHlp_AttachDD(DevHdr[0].DHname, &AttachArea)))
      {
      szNum = &DevHdr[0].DHname[5];
      for (i=2; i<=9; i++)
         {
         *szNum = (char)('0'+i);
         if (DevHlp_AttachDD(DevHdr[0].DHname, &AttachArea))
            break;
         }  /* end of for */
      }  /* end of if */

   // must Init Hardware before PDD link: address location must be known
   // not to mention the fact that we don't need the vdd if the device
   // driver can't load

   if (RMHELP_CreateDriver("MVPRODD.SYS") != RMRC_SUCCESS)
   {
       return( RPERR | RPDONE);
   }

   if (!InitHardware())                    // returns number of cards found
   {
      RMHELP_DumpRMErrors();
      RMHELP_DestroyDriver();
      return(RPERR | RPDONE);
   }

   if (RMHELP_CreateAdapter() != RMRC_SUCCESS )
   {
      RMHELP_DestroyDriver();
      return(RPERR | RPDONE);
   }

   #ifdef PROGRESS_MONITOR
   StringOut ("MVPRODD: Establishing PDD link");
   #endif

   /**********************************************************/
   /* Establish Vdd-Pdd link                                 */
   /* ONLY register the header from MMPM/2 installation      */
   /* Do NOT register the AUDIOn$, because the MMPM/2 VDD    */
   /* is only hooking the header from the config.sys /n:     */
   /**********************************************************/

   // translate VDD I/O locations
   for (i=0; i< NUM_PORT_RANGES; i++)
      AdapterInfo.range[i].ulPort ^= (ULONG) gwTranslateCode;

   if (usNumHeaders == 2)
      {
      s1=(char far *)szDevName;
      s2=(char far *)DevHdr[1].DHname;    // use 2nd header

      for (i=0; i<8 ; i++)
         *s1++=*s2++;

      if (DevHlp_RegisterPDD(szDevName, (PVOID)PDDEntryPoint))
         {
         #ifdef DEBUG_CHK
         StringOut( "MVPRODD: Failure establishing PDD link");
         #endif

         /*fails - deinstall driver */
         return (RPDONE | RPERR | RPBADCMD);
         }
      }  // end if

   /************************************/
   /* Autoscan for device and settings */
   /************************************/
   InitPCM();      // must be after InitHardware

   /*
   ** Call routine to get streaming initialized with MMPM/2
   ** and then return to the kernel via our assembler code.
   */
   if (InitStreams() & RPERR)
      {
      RMHELP_DestroyDriver();
      return(RPERR | RPDONE);
      }

   if (rc=AllocDMABuffer())
      {
      #ifdef DEBUG_CHK
      StringOut ("MVPRODD: Init failed on DMA memory allocation");
      #endif
      RMHELP_DestroyDriver();
      return (rc|RPDONE|RPERR);
   }

   /*
   ** Initialization data and code are truncated after
   ** device driver initialization.  The device driver
   ** is inited twice.  This is the first time.
   ** Don't truncate the segments until final init call.
   */
   #ifdef PROGRESS_MONITOR
   StringOut ("MVPRODD: Audio Init Ok");
   #endif
   return (RPDONE);
}



/*                                      ---------------------------- Init_POS -
** Init POS ID data structure
** This routine initializes the POS ID data.
** Data is retrieved from  ABIOS calls.
**
** PseudoCode
**    Get LID Entry for ABIOS POS
**    Return if not successful. (ISA_BUS)
**    Get Required Length of Request Block.
**    if successful and if sufficent storage
**      for each slot
**        get POS ID from ABIOS
**        if ABIOS call successful
**          assign POS ID
**        else
**          POS ID equals zero
**    Free LID Entry
**    Return(MCA_BUS)
**
** ENTRY POINTS:
**    LINKAGE:  Near from IOCTL_Init()
**    PREQPACKET rp - pointer to Device driver request packet
**
** INTERNAL REFERENCES: none
**
** EXTERNAL REFERENCES: DevHlps
*/

USHORT Init_POS (void)
{
   USHORT i,rc;            /* index and return code    */
   USHORT usLID;           /* Logical ID               */
   ULONG  ulPCM_PosData;       /* POS data value (102-105) */

   /* Get LID Entry for POS */
   if (rc = DevHlp_GetLIDEntry(LOGICAL_POS_ID, 0, 1, &usLID))
           return(ISA_BUS);

   /* Get length of RB to use for reading POS data. */
   POSLenRB.rb.RBLen = sizeof(POSLENRB);
   POSLenRB.rb.Func  = 0x01;
   POSLenRB.rb.LID   = usLID;
   POSLenRB.rb.Unit  = 0;
   POSLenRB.rb.Resv1 = 0;
   POSLenRB.rb.Resv2 = 0;
   POSLenRB.Rsv1     = 0;
   POSLenRB.Rsv2     = 0;
   POSLenRB.Rsv3     = 0;
   rc = DevHlp_ABIOSCall( usLID, &POSLenRB, 0);

   if ((rc==0) && (sizeof(POSRB) >= POSLenRB.RBLen))
      {
      /* Initialize request block for reading POS data. */
      ABIOSrb.rb.RBLen = POSLenRB.RBLen;       /* request block length        */
      ABIOSrb.rb.Func  = 0x0b;                   /* read stored POS data to mem */
      ABIOSrb.rb.LID   = usLID;                  /* Logical ID                  */
      ABIOSrb.rb.Unit  = 0;
      ABIOSrb.DataBuf  = (ULONG)(PVOID)&ulPCM_PosData;

      /* for each slot, get POS ID */
      for(i=0;i<=MAX_POS_SLOTS;i++)
         {
         ABIOSrb.Slot = (UCHAR)i;
         rc = DevHlp_ABIOSCall(usLID, &ABIOSrb, 0);
         if((rc==0)&&(ABIOSrb.rb.RetCode==0))
            POSCardID[i] = ABIOSrb.AdapterID;
         else
            POSCardID[i] = 0;
         } // end for
      } // end then

   /* Release LID Entry */
   DevHlp_FreeLIDEntry(usLID);
   return(MCA_BUS);
}



/*                                      ------------------------- InitStreams -
** Initializes the stream table at device init time.
**
** This routine is removed from the code segment after boot time.
**
** ENTRY POINTS:
**     LINKAGE:  Near from IOCTL_Init()
** INPUT:
** EXIT-NORMAL:  NO_ERROR
** EXIT_ERROR:
** EFFECTS:
** INTERNAL REFERENCES: none
** EXTERNAL REFERENCES: DevHlps
*/

#define ALLOC_HI        0
#define ALLOC_LO        1

ULONG InitStreams (VOID)
{
USHORT  i, j, BlkSize;
PVOID   PhysAddress;
ULONG   rc;
BOOL    bErrFlg = FALSE;
PSTREAM pStream;

   /**********************************/
   /* alloc memory for stream table, */
   /**********************************/

   BlkSize = sizeof(STREAM) * GlobalTable.usMaxNumStreams;

   // Allocate in high memory first.  If it fails allocate in low mem

   if ( DevHlp_AllocPhys(BlkSize, ALLOC_HI, &PhysAddress) ) // Allocate high
      {
      // If that fails, allocate low
      rc = DevHlp_AllocPhys(BlkSize, ALLOC_LO, &PhysAddress);
      // If that fails, installation fails
      if (rc)
         return(RPDONE | RPERR);
      }

   /*********************************************************/
   /* allocate GDTs                                                                                                                */
   /* The GDT addresses are copied from the local variable  */
   /* into the GlobalTable so they can be used when running */
   /* at ring 0 (after initialization)                                                     */
   /*********************************************************/
   rc = DevHlp_AllocGDTSelector(NUMGDTS, &usGDT[GDT_PSTREAM]);

   /*********************************************************/
   /* Set up a temporary virtual address.                                                  */
   /* Note, cannot use GDT at init time as init is ring 3.  */
   /* The GDT is allocated during init, but cannot be used  */
   /* until executing at ring 0.                                                                   */
   /*********************************************************/
   rc = DevHlp_PhysToVirt(PhysAddress,
                          BlkSize,
                          &GlobalTable.paStream);
   if (rc)
      return (RPDONE | RPERR);

   //*********************
   // Initialize stream table
   //*********************
   pStream = GlobalTable.paStream;
   for (i=0; i<GlobalTable.usMaxNumStreams; i++)
      {
      pStream->hStream = -1;
      pStream->ulFlags = 0;
      for (j=0; j<MAXIOBUFFS; j++)
         {
         pStream->IOBuff[j].usRunFlags = 0;
         pStream->IOBuff[j].lCount  = 1;
         pStream->IOBuff[j].pBuffer = NULL;
         }
      pStream++;
      }

   //***********************************************
   // Map to GDT selector to address of stream table
   //***********************************************
   if (rc = DevHlp_PhysToGDTSelector(PhysAddress,BlkSize, usGDT[GDT_PSTREAM]))
      bErrFlg = TRUE;
   else
      GlobalTable.paStream = MAKEP(usGDT[GDT_PSTREAM],0);  // set to virtual GDT pointer

   if (bErrFlg)
      return (RPERR | RPDONE);
   else
      return (RPDONE);
}


                                        //-------------------- AllocDMABuffer -
USHORT AllocDMABuffer (VOID)
{
   USHORT  BlkSize, BlkSizeX2;
   USHORT  rc;
   DWORD   dwAlign;
   DWORD   dwAlignmentOffset;
   DWORD   dwAlignedSpace;

   /*
   ** alloc memory for DMA Buffer
   ** Allow DMA buffer to be any 2^X < 64K  && > 2K
   */

   BlkSize = DMA_BUFFER_MAX;

   if (BlkSize==32768)
      BlkSizeX2=65534;        //to get around     in PhysToGDT selector
   else
      BlkSizeX2=BlkSize<<1;

   rc=DevHlp_AllocPhys(((ULONG)BlkSize)*2, ALLOC_LO, &dwDMAPhysAddr);
   if (!rc)
      rc = DevHlp_PhysToGDTSelector ((PVOID) dwDMAPhysAddr,
                                     (USHORT)BlkSizeX2,
                                     usGDT[GDT_DMABUFF]);
   else
      {
      #ifdef DEBUG_CHK
      StringOut("AllocPhys  failed");
      #endif
      }

   if (rc)
      {
      #ifdef DEBUG_CHK
      StringOut("PhysToGDTSelector failed");
      #endif
      }

   switch (TheDMAChannel)
      {
      case 0:
      case 1:
      case 2:
      case 3:
         dwAlign=0x10000L;       // 64K limit on 8-bit DMA
         break;

      case 5:
      case 6:
      case 7:
         dwAlign=0x20000L;       // 128K limit on 16-bit DMA
         break;

      default:
      case -1:
         #ifdef DEBUG_CHK
         StringOut("Erroneous DMA Channel Value, unable to determine BlkSize");
         #endif
         ;
      } // end switch


   dwAlignmentOffset= dwDMAPhysAddr & (dwAlign-1);
   dwAlignedSpace   = dwAlign-dwAlignmentOffset;

   #ifdef DEBUG_CHK
   PrintfOut("Block Size (total DMA buffer) = %0x",BlkSize);
   PrintfOut("Pre-aligned DMA Physical Address = %0lx",dwDMAPhysAddr);
   PrintfOut("Alignment offset = %0lx",dwAlignmentOffset);
   PrintfOut("Aligned space = %0lx",dwAlignedSpace);
   #endif

   if (dwAlignedSpace< (DWORD) BlkSize)
      {
      #ifdef DEBUG_CHK
      StringOut("Forced to re-align");
      #endif
      //dwDMAPhysAddr+=dwAlignmentOffset;
      dwDMAPhysAddr+=dwAlignedSpace;
      rc = DevHlp_PhysToGDTSelector ((PVOID) dwDMAPhysAddr,
                                     BlkSize,
                                     usGDT[GDT_DMABUFF]);
      if (rc)
         return(rc);
      }

   lpDMAVirtual = MAKEP(usGDT[GDT_DMABUFF],0);  // set to virtual GDT pointer

   if (!rc)
      {
      wDMABuffLength=(WORD) BlkSize-1;
      dwDMAUnitSize=BlkSize>>1;

      //wDMASemiBuf1=(WORD) ((dwDMAPhysAddr) & 0xFFFF);
      //wDMASemiBuf2=wDMASemiBuf1+(BlkSize/2);
      }

   #ifdef DEBUG_CHK
   PrintfOut("Aligned DMA Physical Address = %0lx",dwDMAPhysAddr);
   #endif

   return(rc);
}

#include "parse.c"
