;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; mvmixer.inc
;
;******************************************************************************

NwParm1         equ     [bp+2+2+00h]
NwParm2         equ     [bp+2+2+02h]
NwParm3         equ     [bp+2+2+04h]
NwParm4         equ     [bp+2+2+06h]
NwParm5         equ     [bp+2+2+08h]

NdParm1         equ     [bp+2+2+00h]
NdParm2         equ     [bp+2+2+04h]
NdParm3         equ     [bp+2+2+08h]
NdParm4         equ     [bp+2+2+0ch]


;;; Use these macros for FAR procedures
FwParm1         equ     [bp+2+4+00h]
FwParm2         equ     [bp+2+4+02h]
FwParm3         equ     [bp+2+4+04h]
FwParm4         equ     [bp+2+4+06h]
FwParm5         equ     [bp+2+4+08h]

FdParm1         equ     [bp+2+4+00h]
FdParm2         equ     [bp+2+4+04h]
FdParm3         equ     [bp+2+4+08h]
FdParm4         equ     [bp+2+4+0ch]

PCMCODEVERSION  equ     0003h           ; version 00.03

@dtasize=1      ; our version of Masm 5.1 internal
@cdesize=1      ; our version of Masm 5.1 internal

SYSEX_ERROR     equ     00FFh           ; internal error code for sysexes on input

;   who is using the interrupt

INT_FREE        equ     0
INT_WAVEOUT     equ     1
INT_WAVEIN      equ     2
;;; INT_MIDIIN      equ     3

PROAS                   equ     1       ; 1st board - Pro Audio Spectrum

;
; Hardware associated with the product
;

if PROAS                        ; Media Vision Pro Audio Spectrum
DUALFM          EQU     1               ; Dual FM chips
DUALMIXER       EQU     1               ; Dual mixers
FILTER          EQU     1               ; Has filter after input mixer
VOLUME          EQU     1               ; Has total volume control
;

endif ; PROAS

MIXCROSSCAPS_NORMAL_STEREO  equ 0        ;;// Left->Left, Right->Right
MIXCROSSCAPS_RIGHT_TO_BOTH  equ 1        ;;// Right->Left, Right->Right
MIXCROSSCAPS_LEFT_TO_BOTH   equ 2        ;;// Left->Left, Left->Right
MIXCROSSCAPS_REVERSE_STEREO equ 4        ;;// Left->Right, Right->Left
MIXCROSSCAPS_RIGHT_TO_LEFT  equ 8        ;;// Right->Left, Right->Right
MIXCROSSCAPS_LEFT_TO_RIGHT  equ 10h      ;;// Left->Left, Left->Right

OUT_AMPLIFIER   equ 0
OUT_PCM         equ 1

_LEFT equ 1
_RIGHT equ 2

_BASS    equ 0
_TREBLE  equ 1


;   /*\
;---|*|----====< debug support >====----
;   \*/

IFDEF DEBUG
    extrn OutputDebugString:far
    extrn OutputDebugStr:far
ENDIF

DOUT1   macro   text
        local   outa_here
        local   string_buffer

IFDEF DEBUG
        pusha
        lea     ax,string_buffer
        cCall   OutputDebugStr,<cs,ax>
        jmp     short outa_here

string_buffer:
        db      "&text&",0
outa_here:
        popa
ENDIF
        endm

DOUT3   macro   text
        local   outa_here3
        local   string_buffer3

IFDEF SQUIRTYOUTS
        pusha
        lea     ax,string_buffer3
        cCall   OutputDebugStr,<cs,ax>
        jmp     short outa_here3

string_buffer3:
        db      "&text&",0
outa_here3:
        popa
ENDIF
        endm

DbgWord macro val
IFDEF DEBUG
    push ax
    push si
    mov si, offset dgroup:msgWord
    mov ax, val
    call dbgWordToMsg
    mov ax, offset dgroup:msgWord
    cCall OutputDebugStr <ds, ax>
    pop si
    pop ax
ENDIF
endm

;  /*\
;  |*| This section contains the Media Vision hardware definition equates,
;  |*| and the PC hardware environment.
;  \*/

;---------------------------------Macro---------------------------------;
;
; EnterCrit
;
;   saves the current state of the interupt flag on the stack then
;   disables interupts.
;
; Registers Destroyed:
;       BX, FLAGS
;
;------------------------------------------------------------------------;

EnterCrit macro
    local   no_cli
    pushf
    pushf
    pop     bx
    test    bh,2            ; if interupts are already off, dont blow
    jz      no_cli          ; ... ~300 clocks doing the cli
    cli
no_cli:
endm

;---------------------------------Macro---------------------------------;
;
; LeaveCrit
;
;   restore the interupt state saved by EnterCrit
;
; Registers Destroyed:
;       BX, FLAGS
;
;------------------------------------------------------------------------;

LeaveCrit macro
    local   no_sti
    pop     bx
    test    bh, 2
    jz      no_sti
    sti
no_sti:
endm

;
;---------------------------====< MASM Assembly >====--------------------------
;
; miscellaneous equates & macros
;

bptr            equ     byte ptr
wptr            equ     word ptr
dptr            equ     dword ptr

pause           equ     <jmp $+2>

;
; end of mvsound.inc
;
