/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* mvmixer.h
*
* This file contains the Media Vision hardware definition equates, and.
* the PC hardware environment.  Equates include constants for programming
* the PC DMA controller.
******************************************************************************/

#define DRIVER_VERSION  0x101

#define SYSEX_ERROR     0xFF    // internal error code for sysexes on input

#define PATCH_PLAY      4
#define PATCH_RECORD    8

#define _LEFT           1
#define _RIGHT          2

#define _BASS           0
#define _TREBLE 1

#define MIX_XXX_LEFT    0       // NO CONNECTION
#define MIX_SYN_LEFT    1
#define MIX_MIX_LEFT    2
#define MIX_EXT_LEFT    3
#define MIX_INT_LEFT    4
#define MIX_MIC_LEFT    5
#define MIX_PCM_LEFT    6
#define MIX_SPK_LEFT    7
#define MIX_SYN_RIGHT   8
#define MIX_MIX_RIGHT   9
#define MIX_EXT_RIGHT  10
#define MIX_INT_RIGHT  11
#define MIX_MIC_RIGHT  12
#define MIX_PCM_RIGHT  13
#define MIX_SPK_RIGHT  14
#define MIX_XXX_RIGHT  15


#define MIX_NC_RIGHT   15


/* Product Definition                                           */

//#define PROAS1        1               /* 1st rev of Pro Audio Spectrum        */
//#define PROAS2        0               /* 2nd rev of Pro Audio Spectrum        */

/* Hardware associated with the product                         */
#if 0
#if PROAS1                      /* Media Vision Pro Audio Spectrum      */
#define DUALFM          1               /* Dual FM chips
#define DUALMIXER       1               /* Dual mixers
#define FILTER          1               /* Has filter after input mixer
#define VOLUME          1               /* Has total volume control

#define SYSSPKRTMR      0x0042          /* System Speaker Timer Address */
#define SYSTMRCTLR      0x0043          /* System Timer Control Register*/
#define SYSSPKRREG      0x0061          /* System Speaker Register      */
#define JOYSTICK        0x0201          /* Joystick Register            */
#define LFMADDR         0x0388          /* Left  FM Address Register    */
#define LFMDATA         0x0389          /* Left  FM Data Register       */
#define RFMADDR         0x038A          /* Right FM Address Register    */
#define RFMDATA         0x038B          /* Right FM Data Register       */
#define DFMADDR         0x0788          /* Dual  FM Address Register    */
#define DFMDATA         0x0789          /* Dual  FM Data Register       */
#define AUDIOMIXR       0x0B88          /* Audio Mixer Control Register */
#define INTRCTLR        0x0B89          /* Interrupt Control Register   */
#define AUDIOFILT       0x0B8A          /* Audio Filter Control Register*/
#define PCMDATA         0x0F88          /* PCM data I/O register        */
#define SAMPLERATE      0x1388          /* Sample Rate Timer Register   */
#define SAMPLECNT       0x1389          /* Sample Count Register        */
#define SPKRTMR         0x138A          /* Local Speaker Timer Address  */
#define TMRCTLR         0x138B          /* Local Timer Control Register */
#define MDIRQVECT       0x1788          /* MIDI IRQ Vector Register     */
#define MDSYSCTLR       0x1789          /* MIDI System Control Register */
#define MDSYSSTAT       0x178A          /* MIDI IRQ Status Register     */
#define MDIRQCLR        0x178B          /* MIDI IRQ Clear Register      */
#define MDGROUP1        0x1B88          /* MIDI Group #1 Register       */
#define MDGROUP2        0x1B89          /* MIDI Group #2 Register       */
#define MDGROUP3        0x1B8A          /* MIDI Group #3 Register       */
#define MDGROUP4        0x1B8B          /* MIDI Group #4 Register       */

#endif
#endif

/*---------------------====< PC HARDWARE >====--------------------*/

/* dma controller #1 port addresses                                     */


#define DMAC0ADDR       0x00            /* DMA channel 0 Base & Address */
#define DMAC0COUNT      0x01            /* DMA channel 0 Base & Count   */
#define DMAC1ADDR       0x02            /* DMA channel 1 Base & Address */
#define DMAC1COUNT      0x03            /* DMA channel 1 Base & Count   */
#define DMAC2ADDR       0x04            /* DMA channel 2 Base & Address */
#define DMAC2COUNT      0x05            /* DMA channel 2 Base & Count   */
#define DMAC3ADDR       0x06            /* DMA channel 3 Base & Address */
#define DMAC3COUNT      0x07            /* DMA channel 3 Base & Count   */

#define DMARDSTAT       0x08            /* DMA read status              */
#define DMAWRCNTRL      0x08            /* DMA write command register   */
#define DMAWREQ         0x09            /* DMA write request register   */
#define DMAWRSMR        0x0A            /* DMA write single mask reg.   */
#define DMAWRMODE       0x0B            /* DMA write mode register      */
#define DMACLEAR        0x0C            /* DMA clear low/high flip-flop */
#define DMARDTEMP       0x0D            /* DMA read temp register       */
#define DMAWRCLR        0x0D            /* DMA write master clear       */
#define DMACLRMSK       0x0E            /* DMA clear mask register      */
#define DMAWRALL        0x0F            /* DMA write all mask reg. bits */

#define CH0PAGEREG      0x87            /* Channel 0 Page Register      */
#define CH1PAGEREG      0x83            /* Channel 1 Page Register      */
#define CH2PAGEREG      0x81            /* Channel 2 Page Register      */
#define CH3PAGEREG      0x82            /* Channel 3 Page Register      */

/*---------------------====< MISCELLANEOUS DEFINES >====--------------------*/

#define MKLONG(i) (((long)i) & 0xffff)  // casts int into long & clears high word
