/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* mvmixer.c
*
* DESCRIPTION:
* Theory of operation:
* The caller maintains his own copy of the state of the mixer
* and is sent a message whenver the driver's copy of the mixer
* state is changed.  Callers can update their copy of the mixer
* via the mixGetState function.  Users can maintain multiple states
* and cause them to be realized using the mixSetState function.
*
* In general, the functions in this DLL will take these steps:
*
*             1) Get a copy of the current mixer state (hCurrentMixer)
*
*             2) Perform changes requested by the user on the new
*                copy of the mixer state.
*
*             3) Make incremental changes to hCurrentMixer while updating
*                the hardware.
*
*             4) Send a message indicating the change
*
*
* The API will handle mixers with up to 32 inputs with 32 outputs.  Should
* hardware ever go beyond this capability, multiple mixer devices can
* be implemented.
******************************************************************************/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>

#define DRV_16
#include "os2mixer.h"

#include "mvsystem.h"
//#include "pasdef.h"
#include "findpas.h"
#include "mvmixer.h"
#include "mvprodd.h"
#include "proto.h"
#include "patch.h"
#include "globals.h"
#include "debug.h"
#include "commdbg.h"
#include "cdevhlp.h"


///PVOID ChangedLine[MAX_MIX_MESSAGES];
///PVOID ChangedMixerPointer[MAX_MIX_MESSAGES];




/*                                      -------------------------- mixMessage -
** This function conforms to the standard Mixer driver message proc
** (mixMessage), which is documented in mixddk.h
*/
WORD mixMessage
        (WORD  id, WORD  msg, WORD  wParam1,
         DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4)
{
   // check if whole PROAS1 card enabled

   //if (!wEnabled)
   //      {
   //   DOUTX("\r\nMVMIXER: mixMessage called while disabled");
   //   return (MMSYSERR_NOTENABLED);
   //      }

   // this driver only supports one mixer device

   if (id != 0)
      {
      StringOut("\r\nMVMIXER: invalid mixer device id");
      return (-1);
      }

   // handle one of the applications messages.

   switch (msg)
      {
      case MIXDM_GETNUMDEVS:
         return (1);

      case MIXDM_GETDEVCAPS:
         //
         // MMMIXER.DLL's call looks like this:
         //
         // MixMessage(HIWORD(lIndexID), not passed in
         //            LOWORD(lIndexID),   id
         //            MIXDM_GETDEVCAPS,   msg
         //            wSize,              wParam1
         //            (DWORD) lpCaps,     dwParam1
         //            NULL,               dwParam2
         //            NULL,               dwParam3
         //            NULL );             dwParam4
         //
         return(GetDevCaps(id,(LPMIXERCAPS) dwParam1,wParam1));
         break;

      case MIXDM_OPEN:
         // DOUTX(" MIXDM_OPEN\n");
         //
         // MixMessage (HIBYTE(wIndexID),       not passed in
         //             LOBYTE(wIndexID),       id
         //             MIXDM_OPEN,             msg
         //             NULL,                   wParam1
         //             dwFlags,                dwParam1
         //             NULL,                   dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(Open(id, dwParam1));

      case MIXDM_CLOSE:
         //DOUTX(" MIXDM_CLOSE\n");
         //
         // MixMessage (HIBYTE(hMixer),         not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_CLOSE,            msg
         //             NULL,                   wParam1
         //             NULL,                   dwParam1
         //             NULL,                   dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4

         return(Close(id));

      case MIXDM_MUTE:
         //
         // MixMessage(HIBYTE(hMixer),                  not passed in
         //                        LOBYTE(hMixer),      id
         //                        MIXDM_RESET,         msg
         //                        NULL,                                         wParam1
         //                        NULL,                                         dwParam1
         //                        NULL,                                         dwParam2
         //                        NULL,                                         dwParam3
         //                        NULL);                                        dwParam4
         //
         return(Mute(id));
         break;

      case MIXDM_RESET:
         //
         // MixMessage(HIBYTE(hMixer),                  not passed in
         //                        LOBYTE(hMixer),      id
         //                        MIXDM_RESET,         msg
         //                        NULL,                                         wParam1
         //                        NULL,                                         dwParam1
         //                        NULL,                                         dwParam2
         //                        NULL,                                         dwParam3
         //                        NULL);                                        dwParam4
         //
         return(Reset(id));
         break;

      case MIXDM_GETSTATE:
         //
         // MixMessage(HIBYTE(hMixer),                  driver, not passed in
         //                        LOBYTE(hMixer),      id
         //                        MIXDM_GETSTATE,      msg
         //                        wSize,               wParam1
         //                        (DWORD) lpMixer,     dwParam1
         //                        NULL,                dwParam2
         //                        NULL,                dwParam3
         //                        NULL);               dwParam4
         //
         return(GetState(id,(LPMIXERSTATE) dwParam1, wParam1));
         break;

      case MIXDM_SETSTATE:
         //
         // MixMessage(HIBYTE(hMixer),                  driver, not passed in
         //                        LOBYTE(hMixer),      id
         //                        MIXDM_SETSTATE,      msg
         //                        wSize,               wParam1
         //                        (DWORD) lpMixer,     dwParam1
         //                        dwTime,              dwParam2
         //                        dwFlags,             dwParam3
         //                        dwCallback);         dwParam4
         //
         return(SetState(id,(LPMIXERSTATE) dwParam1, wParam1,dwParam2,dwParam3,dwParam4));
         break;

      case MIXDM_GETFADESTATUS:
         // MixMessage (HIBYTE(hMixer),        driver, not passed in
         //             LOBYTE(hMixer),        id
         //             MIXDM_GETFADESTATUS,   msg
         //             NULL,                  wParam1
         //             (DWORD) lpdwTime,      dwParam1
         //             NULL,                  dwParam2
         //             NULL,                  dwParam3
         //             NULL);
         //
         //
         return(GetFadeStatus(id,(LPDWORD) dwParam1));
         break;


      case MIXDM_GETCONNECTIONS:
         //
         // MixMessage (HIBYTE(hMixer),             driver, not passed in
         //             LOBYTE(hMixer),             id
         //             MIXDM_GETCONNECTIONS,       msg
         //             wLine,                      wParam1
         //             (DWORD)lpdwConnections,     dwParam1
         //             NULL,                       dwParam2
         //             NULL,                       dwParam3
         //             NULL);                      dwParam4
         //
         return(GetLineConnections(id,wParam1,(LPDWORD) dwParam1));
         break;

      case MIXDM_SETCONNECTIONS:
         //
         // MixMessage (HIBYTE(hMixer),         driver, not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_SETCONNECTIONS,   msg
         //             wLine,                  wParam1
         //             dwConnections,          dwParam1
         //             NULL,                   dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(SetLineConnections(id,wParam1,dwParam1));
         break;

      case MIXDM_GETDEVLINES:
         //
         // MixMessage (HIBYTE(hMixer),         driver, not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_GETDEVLINES,      msg
         //             NULL,                   wParam1
         //             (DWORD)lpDeviceLines,   dwParam1
         //             NULL,                   dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(GetDeviceLines(id,(LPDEVICELINES) dwParam1));
         break;

      case MIXDM_GETDEVCONNECTS:
         //
         // MixMessage (HIBYTE(hMixer),           driver, not passed in
         //             LOBYTE(hMixer),           id
         //             MIXDM_GETDEVCONNECTS,     msg
         //             NULL,                     wParam1
         //             (DWORD) lpDeviceConnect,  dwParam1
         //             NULL,                     dwParam2
         //             NULL,                     dwParam3
         //             NULL);                    dwParam4
         //
         return(GetDeviceConnections(id,(LPDEVICECONNECT) dwParam1));
         break;

      case MIXDM_SETDEVCONNECTS:
         //
         // MixMessage (HIBYTE(hMixer),           driver, not passed in
         //             LOBYTE(hMixer),           id
         //             MIXDM_SETDEVCONNECTS,     msg
         //             NULL,                     wParam1
         //             (DWORD) lpDeviceConnect,  dwParam1
         //             NULL,                     dwParam2
         //             NULL,                     dwParam3
         //             NULL);                    dwParam4
         //
         return(SetDeviceConnections(id,(LPDEVICECONNECT) dwParam1));
         break;

      case MIXDM_GETLINEINFO:
         //
         // MixMessage (HIBYTE(hMixer),         driver, not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_GETLINEINFO,      msg
         //             wLine,                  wParam1
         //             (DWORD) lpInfo,         dwParam1
         //             wInfoSize,              dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(GetLineInfo(id, wParam1,(LPMIXERLINEINFO) dwParam1,LOWORD(dwParam2)));
         break;

      case MIXDM_GETCONTROL:
         //
         // MixMessage (HIBYTE(hMixer),         driver, not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_GETCONTROL,       msg
         //             wLine,                  wParam1
         //             dwControl,              dwParam1
         //             (DWORD) lpdwSetting,    dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(GetLineControl(id,wParam1, dwParam1, (LPDWORD) dwParam2));
         break;

      case MIXDM_SETCONTROL:
         //
         // MixMessage (HIBYTE(hMixer),         driver, not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_SETCONTROL,       msg
         //             wLine,                  wParam1
         //             dwControl,              dwParam1
         //             dwSetting,              dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(SetLineControl(id, wParam1, dwParam1, dwParam2));
         break;

      case MIXDM_GETPATCHINFO:
         //
         // MixMessage (HIBYTE(hMixer),         driver, not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_GETPATCHINFO,     msg
         //             wPatchNum,              wParam1
         //             (DWORD) lpInfo,         dwParam1
         //             wSize,                  dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(GetPatchInfo(id,wParam1,(LPPATCHINFO) dwParam1,LOWORD(dwParam2)));
         break;

      case MIXDM_GETPATCH:
         //
         // MixMessage (HIBYTE(hMixer),         driver, not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_GETPATCH,         msg
         //             wLine,                  wParam1
         //             (DWORD) lpwPatchNum,    dwParam1
         //             NULL,                   dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(GetLinePatch(id,wParam1 ,(LPWORD) ((DWORD)dwParam1)));
         break;

      case MIXDM_SETPATCH:
         //
         // MixMessage (HIBYTE(hMixer),         driver, not passed in
         //             LOBYTE(hMixer),         id
         //             MIXDM_SETPATCH,         msg
         //             wLine,                  wParam1
         //             wPatchNum,              dwParam1
         //             (DWORD) lpPatch,        dwParam2
         //             NULL,                   dwParam3
         //             NULL);                  dwParam4
         //
         return(SetLinePatch(id,wParam1,LOWORD(dwParam1),(LPPATCHINFO) dwParam2));
         break;

      case MIXDM_SHUTDOWN:
         StringOut(" MIXDM_SHUTDOWN\n");
         return (-1);
         break;

      //// case MIXDM_QUERYCHANGE:
      ////    StringOut(" MIXDM_QUERYCHANGE\n");
      ////    while (!wMessagesPending)
      ////       {
      ////       Block(-1);
      ////       }
      ////    dwParam1=ChangedLine[0];
      ////    dwParam2=ChangedMixer[0];
      ////    return(0);
         break; // bonus break

      default:
         return (-1);
      } /* switch */

   return -1L;  // shouldn't get here
}

/*                                      -------------------------- GetDevCaps -
*/
WORD NEAR GetDevCaps (WORD wDeviceID,LPMIXERCAPS lpCaps,WORD wSize)
{
   if (wDeviceID!=0)
      return(-1);

   if (wSize > sizeof(MIXERCAPS))
      wSize=sizeof(MIXERCAPS);

   if (wSize != sizeof(MIXERCAPS))
      return(MIXERR_ILLEGALSIZE);

   lpCaps->wMid=MM_MEDIAVISION;                 // manufacturer id
   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC)
      lpCaps->wPid=MM_CDPC_MIXER;
   else if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      lpCaps->wPid=MM_PROAUD_16_MIXER;
   else if (pf.ProCard[gwBoardIndex].Caps.CapsBits.OPL_3)
      lpCaps->wPid=MM_PROAUD_PLUS_MIXER;
   else
      lpCaps->wPid=MM_PROAUD_MIXER;             // product id

   lpCaps->vDriverVersion=DRIVER_VERSION;       // version of the driver
   lstrcpy((LPSTR)lpCaps->szPname,(LPSTR)szProductName);
   lpCaps->wInputs=bNumInputs;                  // number of inputs  supported.
   lpCaps->wOutputs=bNumOutputs;                // number of outputs supported.
   lpCaps->wNumInputPatches=NUM_IN_PATCHES;     // number of input patches supported.
   lpCaps->wNumOutputPatches=NUM_OUT_PATCHES;   // number of output patches supported.
   lpCaps->dwSupport=MIXERCAP_MANUALPATCHSWITCH; // supported functionality
   lpCaps->dwReserved=(DWORD) NULL;

   return(0);
}

/*                                      -------------------------------- Open -
** FUNCTION mixOpen
*/
WORD NEAR Open (WORD wDeviceID,DWORD dwFlags)
{
   ///DOUTX("\r\nMVMIXER: Open");
   return(0);
}

/*                                      ------------------------------- Close -
** FUNCTION mixClose
*/
WORD NEAR Close (WORD wDeviceID)
{
   ///DOUTX("\r\nMVMIXER: Close");
   return(MIXERR_NOERR);
}

/*                                      ------------------------------- Reset -
** FUNCTION mixReset
*/
WORD NEAR Reset(WORD wDeviceID)
{
   WORD wErr;

   StringOut ("\r\nMVMIXER: Reset");

   CopyMixerState(lpTempMixer,lpResetMixer);
   wErr=FadeMixerState(lpTempMixer,0,0);        // quick fade

   return(wErr);
}

/*                                      -------------------------------- Mute -
** FUNCTION mixMute
*/
WORD NEAR Mute (WORD wDeviceID)
{
   StringOut("\r\nMVMIXER: Mute");

   fMuting=~fMuting;
   ///PostMessage(0xFFFF, wmMuteStatusChanged,
   ///     fMuting ? MIXMUTESTATUS_MUTE : MIXMUTESTATUS_NOMUTE,
   ///     fMuting ? MIXMUTESTATUS_MUTE : MIXMUTESTATUS_NOMUTE);

   CopyMixerState(lpTempMixer,lpCurrentMixer);             // get a copy
   bForceInit=TRUE;
   updateOutput(lpTempMixer,OUT_AMPLIFIER);
   bForceInit=FALSE;

   return (0);
}


/*                                      ---------------------------- GetState -
** FUNCTION mixGetState
*/
WORD NEAR GetState (WORD wDeviceID,LPMIXERSTATE lpMixerState, WORD wSize)
{
   int i=wSize;
   char far *hpSource=(char far *) lpCurrentMixer;
   char far *hpDestination=(char far *)lpMixerState;

   while (i)
      {
      *hpDestination++=*hpSource++;
      i--;
      }
   return (0);
}


/*                                      ---------------------------- SetState -
** FUNCTION mixSetState
*/
WORD SetState (WORD wDeviceID,LPMIXERSTATE lpMixerState, WORD wSize,DWORD dwTime,DWORD dwFlags, DWORD dwCallback)
{
   if (fMixFadeActive && !(dwFlags & MIX_FADE_OVERRIDE))
      return(MIXERR_FADEINPROGRESS);    // mixer state fade in progress
   else
      FadeMixerState(lpMixerState,dwTime,dwCallback);

   return(MIXERR_NOERR);
}

/*                                      ----------------------- GetFadeStatus -
** FUNCTION mixGetFadeStatus
*/
WORD NEAR GetFadeStatus (WORD wDeviceID,LPDWORD lpdwTime)
{
   DWORD   dwDelay,dwFade;

   if (!fMixFadeActive)
      *lpdwTime=0;
   else
      {
      if (dwMixFadeTotalElapsed <= dwMixDelayTime)
         dwDelay=LOWORD(dwMixDelayTime-dwMixFadeTotalElapsed);
      else
         dwDelay=0;

      if (dwMixFadeElapsed <= dwMixFadeTime)
         dwFade=LOWORD(dwMixFadeTime-dwMixFadeElapsed);
      else
         dwFade=0;

      *lpdwTime=(dwDelay<<16)+dwFade;
      }
   return(MIXERR_NOERR);
}

/*                                      ------------------ GetLineConnections -
** This routine will return connection information for any input line or
** output line.  The wLine parameter is the line to find connections for.
** For input wLines, *lpdwConnections will contain the outputs it's now
** connected to and vice versa.
*/
WORD NEAR GetLineConnections (WORD wDeviceID,WORD wLine, LPDWORD lpdwConnections)
{
   register WORD wInputOutput=HIBYTE(wLine);
   register WORD Line=LOBYTE(wLine);

   if (Line >= numLines[wInputOutput])
      return(MIXERR_INVALINPUT+wInputOutput);

   switch (wInputOutput)
      {
      case MIX_INPUT:
         *lpdwConnections=lpCurrentMixer->LineInStatus[Line].dwConnections;
         break;

      case MIX_OUTPUT:
         *lpdwConnections=lpCurrentMixer->LineOutStatus[Line].dwConnections;
         break;

      default:
         return(MIXERR_INVALOUTPUT);
      }

   return(0);
}


/*                                      ------------------ SetLineConnections -
** This routine allows the caller to select the input to output routing.
** Media Vision hardware allows inputs to be selected to either the
** amplifier or the pcm record circuitry but not both.  This exclusivity
** is not a limitation of the API, however.  This function will either
** establish the connection or report to the caller that a connection
** could not be made.  In the case of an error, the caller must make
** calls to mixSetLineConnect (q.v.) to determine the degree to which
** the connection failed.  This function updates the user's copy of
** the mixer state.
*/
WORD NEAR SetLineConnections (WORD wDeviceID, WORD wLine, DWORD dwConnections)
{
   register WORD wInputOutput=HIBYTE(wLine);
   register WORD Line=LOBYTE(wLine);
   BOOL     fOk;

   CopyMixerState(lpTempMixer,lpCurrentMixer);             // get a copy

   if (Line >= numLines[wInputOutput])
      {
      fOk=MIXERR_INVALINPUT+wInputOutput;
      goto leave;
      }

   switch (wInputOutput)
      {
      case MIX_INPUT:
         #if 1
         // CDPC - don't let them throw the MIC to PLAY
         if (pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC &&
            ( (Line & 0xff) == IN_MICROPHONE) &&
            ( (dwConnections & (1 << OUT_AMPLIFIER))))
            break;
         #endif
         // We set the user's copy to the connections that he wants.
         // The updateInput function will make/break connections in
         // the hCurrentMixer state as much as the hardware allows.
         // The user's copy will then be updated to reflect current settings.
         lpTempMixer->LineInStatus[Line].dwConnections=dwConnections;
         fOk=updateInput(lpTempMixer,Line);
         break;

      case MIX_OUTPUT:
         lpTempMixer->LineOutStatus[Line].dwConnections=dwConnections;
         fOk=updateOutput(lpTempMixer,Line);
         break;

      default:
         return(MIXERR_INVALOUTPUT);
      } // end switch

   leave:
   return (fOk);
}


/*                                      ---------------------- GetDeviceLines -
** Given a device type, this function will report the lines that the given
** device is connected to.  If the association is not NULL, only
** lines with the same association will be reported.  Otherwise, all
** devices of the given type are reported on.  This function updates the
** users copy to the current state of the mixer.
*/
WORD NEAR GetDeviceLines (WORD wDeviceID,LPDEVICELINES lpDeviceLines)
{
   USHORT i;
   BOOL   fExclusive=(BOOL)lpDeviceLines->dwAssociation; // only association type specified

   lpDeviceLines->wNumDevices=0;
   lpDeviceLines->dwLines=0;

   if (!(lpDeviceLines->dwDeviceType & MIX_LISTENER))
      for (i=0; i<bNumInputs; i++)
         {
         if ((lpCurrentMixer->LineInStatus[i].dwDeviceType&0x0FFFFFFFL)==(lpDeviceLines->dwDeviceType&0x0FFFFFFFL))
            {
            if (fExclusive && (lpCurrentMixer->LineInStatus[i].dwAssociation!=lpDeviceLines->dwAssociation))
               continue;
            lpDeviceLines->wNumDevices++;                   // found one!
            lpDeviceLines->dwLines |= 1<<i;
            }
         }

   else
      for (i=0; i<bNumOutputs; i++)
         {
         if ((lpCurrentMixer->LineOutStatus[i].dwDeviceType&0x0FFFFFFFL)==(lpDeviceLines->dwDeviceType&0x0FFFFFFFL))
            {
            if (fExclusive && (lpCurrentMixer->LineOutStatus[i].dwAssociation!=lpDeviceLines->dwAssociation))
               continue;
            lpDeviceLines->wNumDevices++;                   // found one!
            lpDeviceLines->dwLines |= 1<<i;
            }
         } // end for

   return(0);
}



/*                                      ---------------- GetDeviceConnections -
** Given a device type, this function will return device types that the
** given device type is connected to.  Input device types will yield
** reporting of output device types connected and vice versa.  If the
** associationType is given, only devices with the same association
** will be reported.  Otherwise, all devices of the given type are
** reported on.
*/
WORD NEAR GetDeviceConnections
             (WORD wDeviceID, LPDEVICECONNECT lpDeviceConnect)
{
   USHORT i,j;

   if (lpDeviceConnect->dwInputDeviceType!=(DWORD) NULL)
      {
      for (i=0; i<bNumInputs; i++)
         {
         if (lpCurrentMixer->LineInStatus[i].dwDeviceType!=lpDeviceConnect->dwInputDeviceType)
            continue;

         if (lpDeviceConnect->dwInputAssociation)
            {
            if (lpCurrentMixer->LineInStatus[i].dwAssociation != lpDeviceConnect->dwInputAssociation)
               continue;
            }

         for (j=0; j < bNumOutputs; j++)
            {
            if ((lpCurrentMixer->LineInStatus[i].dwConnections>>j)& 1)      // connected to this output?
               {
               if (lpDeviceConnect->dwOutputAssociation)
                  if (lpCurrentMixer->LineOutStatus[j].dwAssociation != lpDeviceConnect->dwOutputAssociation)
                     continue;
               lpDeviceConnect->dwOutputDeviceType |= lpCurrentMixer->LineOutStatus[j].dwDeviceType;
               }
            } // end for
         } // end for
      } // end then

   else         // search for input devices hooked to this output type
      {
      for (i=0; i<bNumOutputs; i++)
         {
         if (lpCurrentMixer->LineOutStatus[i].dwDeviceType!=lpDeviceConnect->dwOutputDeviceType)
            continue;

         if (lpDeviceConnect->dwOutputAssociation)
            {
            if (lpCurrentMixer->LineOutStatus[i].dwAssociation != lpDeviceConnect->dwOutputAssociation)
               continue;
            }

         for (j=0; j < bNumInputs; j++)
            {
            if ((lpCurrentMixer->LineOutStatus[i].dwConnections>>j)& 1)     // connected to this output?
               {
               if (lpDeviceConnect->dwInputAssociation)
                  if (lpCurrentMixer->LineInStatus[j].dwAssociation != lpDeviceConnect->dwInputAssociation)
                     continue;
               lpDeviceConnect->dwInputDeviceType |= lpCurrentMixer->LineInStatus[j].dwDeviceType;
               }
            } // end for
         } // end for
      } // end else

   return(0);
}



/*                                      ---------------- SetDeviceConnections -
** Given two device types, input and output, this function will attempt
** to connect the two types.  If the  associationType and associationValue
** fields are not NULL, only devices with the same association will be
** connected.
*/
WORD NEAR SetDeviceConnections (WORD wDeviceID,LPDEVICECONNECT lpDeviceConnect)
{
   USHORT i,j;

   CopyMixerState(lpTempMixer,lpCurrentMixer);             // get a copy

   if (lpDeviceConnect->dwInputDeviceType!=(DWORD) NULL)
      {
      for (i=0; i<bNumInputs; i++)
         {       // matching input type?
         if (lpTempMixer->LineInStatus[i].dwDeviceType!=lpDeviceConnect->dwInputDeviceType)
            continue;

         if (lpDeviceConnect->dwInputAssociation)
            {
            if (lpTempMixer->LineInStatus[i].dwAssociation != lpDeviceConnect->dwInputAssociation)
               continue;
            }

         for (j=0; j < bNumOutputs; j++)
            {       // matching output type?
            if (lpTempMixer->LineOutStatus[j].dwDeviceType==lpDeviceConnect->dwOutputDeviceType)
               {
               if (lpDeviceConnect->dwOutputAssociation)
                  if (lpTempMixer->LineOutStatus[j].dwAssociation != lpDeviceConnect->dwOutputAssociation)
                     continue;
               lpTempMixer->LineInStatus[i].dwConnections|=1<<j;
               updateInput(lpTempMixer,i);
               }
            }
         }
      }

   else    // search for input devices hooked to this output type
      {
      for (i=0; i<bNumOutputs; i++)
         {
         if (lpTempMixer->LineOutStatus[i].dwDeviceType!=lpDeviceConnect->dwOutputDeviceType)
            continue;

         if (lpDeviceConnect->dwOutputAssociation)
            if (lpTempMixer->LineOutStatus[i].dwAssociation !=lpDeviceConnect->dwOutputAssociation)
               continue;               // exclusive association didn't match.

         for (j=0; j < bNumInputs; j++)
            {
            if ((lpTempMixer->LineOutStatus[i].dwConnections>>j)& 1)        // connected to this output?
               {
               if (lpDeviceConnect->dwInputAssociation)
                  if (lpTempMixer->LineInStatus[j].dwAssociation!=lpDeviceConnect->dwInputAssociation)
                     continue;               // exclusive association didn't match.
               lpTempMixer->LineInStatus[j].dwConnections|=1<<i;
               updateInput(lpTempMixer,j);
               }
            }
         }
      }
   return(0);
}



                                        //----------------------- GetLineInfo -
WORD NEAR GetLineInfo (WORD wDeviceID, WORD wLine, LPMIXERLINEINFO lpInfo,WORD wSize)
{
   WORD wInputOutput=HIBYTE(wLine);
   LPLINESTATUS lpStatus;

   wLine=LOBYTE(wLine);

   switch (wInputOutput)
      {
      case MIX_INPUT:
         if (wLine >= bNumInputs)
            return(MIXERR_INVALINPUT);
         lpStatus=(LPLINESTATUS) &lpCurrentMixer->LineInStatus[wLine];
         break;

      case MIX_OUTPUT:
         if (wLine >= bNumOutputs)
            return(MIXERR_INVALOUTPUT);
         lpStatus=(LPLINESTATUS )&lpCurrentMixer->LineOutStatus[wLine];
         break;

      default:
         return(MIXERR_INVALOUTPUT);
      }

   lpInfo->wNumber = wInputOutput;
   lpInfo->dwDeviceType = lpStatus->dwDeviceType;
   lpInfo->wNumSoftPatches = lpStatus->wNumSoftPatches;
   lpInfo->wPatchNumber = lpStatus->wPatchNumber;
   lpInfo->wNumChannels = lpStatus->wNumChannels;
   lpInfo->dwSupport = lpStatus->dwSupport;
   lpInfo->dwAssociation=lpStatus->dwAssociation;
   lpInfo->dwConnectionsPossible=lpStatus->dwConnectionsPossible;
   lstrcpy((LPSTR) lpInfo->szIOname,(LPSTR)lpStatus->szIOname);
   lstrcpy((LPSTR)lpInfo->szPname,(LPSTR)lpStatus->szPname);

   return(0);
}

                                        //-------------------- GetLineControl -
WORD NEAR GetLineControl
             (WORD wDeviceID, WORD wLine, DWORD dwControl, LPDWORD lpdwSetting)
{
   WORD wInputOutput=HIBYTE(wLine);
   LPLINESTATUS lpStatus;

   wLine=LOBYTE(wLine);

   switch (wInputOutput)
      {
      case MIX_INPUT:
         if (wLine >= bNumInputs)
            return(MIXERR_INVALINPUT);
         lpStatus=(LPLINESTATUS )&lpCurrentMixer->LineInStatus[wLine];
         break;

      case MIX_OUTPUT:
         if (wLine >= bNumOutputs)
            return(MIXERR_INVALOUTPUT);
         lpStatus=(LPLINESTATUS )&lpCurrentMixer->LineOutStatus[wLine];
         break;

      default:
         return(MIXERR_INVALOUTPUT);
      }  // end switch

   switch (dwControl)
      {
      case MIX_SUPPORT_VOLUME:
      case MIX_SUPPORT_LRVOLUME:
         *lpdwSetting= (DWORD)lpStatus->dwVolume;
         break;

      ///case MIX_SUPPORT_ALC:
      ///     *lpdwSetting=lpStatus->dwAutoLevel;
      ///     break;

      case MIX_SUPPORT_BMT:
         *lpdwSetting=lpStatus->dwBMT;
         break;

      case MIX_SUPPORT_CROSSOVER:
         *lpdwSetting=lpStatus->dwCrossover;
         break;

      case MIX_SUPPORT_LOUDNESS:
         *lpdwSetting=lpStatus->dwLoudness;
         break;

      ///case MIX_SUPPORT_MUTE:
      ///     break;

      ///case MIX_SUPPORT_REVERB:
      ///     break;

      case MIX_SUPPORT_STEREOENHANCE:
              *lpdwSetting=lpStatus->dwStereoEnhance;
              break;

      ///case MIX_SUPPORT_CUSTOM1:
      ///     break;

      ///case MIX_SUPPORT_CUSTOM2:
      ///     break;

      ///case MIX_SUPPORT_CUSTOM3:
      ///     break;

      default:
         *lpdwSetting=lpStatus->dwVolume;       /// testy
         return(MIXERR_NOTSUPPORTED);
         break;
      }

   return(0);
}


                                        //-------------------- SetLineControl -
WORD NEAR SetLineControl
             (WORD wDeviceID, WORD wLine, DWORD dwControl, DWORD dwSetting)
{
   WORD wInputOutput=HIBYTE(wLine);
   LPLINESTATUS lpStatus=NULL;
   #ifdef MIX_MONITOR
   StringOut("SetLineControl");
   #endif

   CopyMixerState(lpTempMixer,lpCurrentMixer);             // get a copy

   wLine=LOBYTE(wLine);

   switch (wInputOutput)
      {
      case MIX_INPUT:
         if (wLine >= bNumInputs)
            return(MIXERR_INVALINPUT);
         lpStatus=(LPLINESTATUS)&lpTempMixer->LineInStatus[wLine];
         break;

      case MIX_OUTPUT:
         if (wLine >= bNumOutputs)
            return(MIXERR_INVALOUTPUT);
         lpStatus=(LPLINESTATUS)&lpTempMixer->LineOutStatus[wLine];
         break;

      default:
         #ifdef MIX_MONITOR
         StringOut ("ERROR bad line type in SetLineControl");
         #endif
         return(MIXERR_INVALOUTPUT);
      }

   if (!lpStatus)
      {
      #ifdef MIX_MONITOR
      StringOut("ERROR bad line type in SetLineControl");
      #endif
      return(-1);
      }


   if (!(lpStatus->dwSupport & dwControl))
      return (MIXERR_NOTSUPPORTED);

   switch (dwControl)
      {
      case MIX_SUPPORT_VOLUME:
      case MIX_SUPPORT_LRVOLUME:
         lpStatus->dwVolume=dwSetting;
         break;

      ///case MIX_SUPPORT_ALC:
      ///     lpStatus->dwALC=dwSetting;
      ///     break;

      case MIX_SUPPORT_BMT:
         lpStatus->dwBMT=dwSetting;
         break;

      case MIX_SUPPORT_CROSSOVER:
         lpStatus->dwCrossover=dwSetting;
         break;

      case MIX_SUPPORT_LOUDNESS:
         lpStatus->dwLoudness=dwSetting;
         break;

      ///case MIX_SUPPORT_MUTE:
      ///     break;

      ///case MIX_SUPPORT_REVERB:
      ///     break;

      case MIX_SUPPORT_STEREOENHANCE:
              lpStatus->dwStereoEnhance=dwSetting;
              break;

      ///case MIX_SUPPORT_CUSTOM1:
      ///     break;

      ///case MIX_SUPPORT_CUSTOM2:
      ///     break;

      ///case MIX_SUPPORT_CUSTOM3:
      ///     break;

      default:
         return(MIXERR_NOTSUPPORTED);
         break;
      } // end switch


   switch (wInputOutput)
      {
      case MIX_INPUT:
         updateInput(lpTempMixer,wLine);
         break;

      case MIX_OUTPUT:
         updateOutput(lpTempMixer,wLine);
      }

   return(0);
}



                                        //---------------------- GetPatchInfo -
WORD GetPatchInfo (WORD wDeviceID,WORD wPatchNum,LPPATCHINFO lpInfo,WORD wSize)
{
   WORD wInputOutput=HIBYTE(wPatchNum);
   LPPATCHINFO lpPatch;
   int i;
   char far *hpSource;
   char far *hpDestination;

   if (wPatchNum == -1)
      return(MIXERR_INVALPATCH);

   wPatchNum=LOBYTE(wPatchNum);

   switch (wInputOutput)
      {
      case MIX_INPUT:
         if (wPatchNum >= NUM_IN_PATCHES)
            return(MIXERR_INVALPATCH);
         lpPatch=&INpatch[wPatchNum];
         break;

      case MIX_OUTPUT:
         if (wPatchNum >= NUM_OUT_PATCHES)
            return(MIXERR_INVALPATCH);
         lpPatch=&OUTpatch[wPatchNum];
         break;

      default:
         return(MIXERR_INVALOUTPUT);
      }

   i=wSize;
   hpSource=(char far *)lpPatch;
   hpDestination=(char far *)lpInfo;
   while (i)
      {
      *hpDestination++=*hpSource++;
      i--;
      }

   return(0);
}

                                        //---------------------- GetLinePatch -
WORD NEAR GetLinePatch (WORD wDeviceID,WORD wLine ,LPWORD lpwPatchNum)
{
   WORD wInputOutput=HIBYTE(wLine);
   LPLINESTATUS lpStatus;

   wLine=LOBYTE(wLine);

   switch (wInputOutput)
      {
      case MIX_INPUT:
         if (wLine >= bNumInputs)
            return(MIXERR_INVALINPUT);
         lpStatus=(LPLINESTATUS)&lpCurrentMixer->LineInStatus[wLine];
         break;

      case MIX_OUTPUT:
         if (wLine >= bNumOutputs)
            return(MIXERR_INVALOUTPUT);
         lpStatus=(LPLINESTATUS)&lpCurrentMixer->LineOutStatus[wLine];
         break;
         }

   *lpwPatchNum=lpStatus->wPatchNumber;
   return(0);
}


                                        //---------------------- SetLinePatch -
WORD NEAR SetLinePatch (WORD wDeviceID,WORD wLine,WORD wPatchNum,LPPATCHINFO lpPatch)
{
   WORD wInputOutput=HIBYTE(wLine);

   wLine=LOBYTE(wLine);
   CopyMixerState(lpTempMixer,lpCurrentMixer);                     // snapshot

   switch (wInputOutput)
      {
      case MIX_INPUT:
         if (wLine >= bNumInputs)
            return(MIXERR_INVALINPUT);
         if (lpPatch==NULL)
            lpPatch=(LPPATCHINFO)(DWORD) wPatchNum;
         patchInput(NULL,wLine,lpPatch);
         break;

      case MIX_OUTPUT:
         if (wLine >= bNumOutputs)
            return(MIXERR_INVALOUTPUT);
         if (lpPatch==NULL)
            lpPatch=(LPPATCHINFO) (DWORD) wPatchNum;
         patchOutput(lpTempMixer,wLine,lpPatch);
         break;

      } // end switch

   return(0);
}
