;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;; Routines in this file are implemented in mvmix.c

;; ;******************************************************************************
;; ;                 Pro AudioSpectrum16 Physical Device Driver
;; ;                     Production code and toolkit sample
;; ;
;; ;
;; ; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
;; ; sample code created by IBM Corporation and Media Vision Corporation.
;; ; It is provided to you solely for the purpose of assisting you in the
;; ; development of your applications.
;; ; The code is provided "AS IS", without warranty of any kind.
;; ; IBM and Media Vision shall not be liable for any damages arising out of
;; ; your use of the sample code, even if they have been advised of the
;; ; possibility of such damages.
;; ;
;; ;******************************************************************************
;; ;
;; ; mvmixa.asm - Pro AudioSpectrum Mixer Support Code
;; ;
;; ; Pro AudioSpectrum Mixer Support Code
;; ;******************************************************************************
;;
;;         page    64,131
;;         .286p
;;         .xlist
;;         include common.inc
;;         include mvmixer.inc
;;         include findpas.inc
;;         include mvsound.inc
;;         include std.mac
;;
;;         .list
;;
;;
;; ;
;; ;----------------------------====< segmentation >====--------------------------
;; ;
;;
;; IFNDEF SEGNAME
;;     SEGNAME equ <_TEXT>
;; ENDIF
;;
;;
;; ;
;; ;---------------------------====< DATA SECTION >====---------------------------
;; ;
;;
;; _DATA   SEGMENT WORD PUBLIC USE16 'DATA'
;;
;;         extrn   _gwTranslateCode:WORD
;;         extrn   _dwCaps:DWORD
;;
;; ;
;; ; a linear table of filter values - from mute to high
;; ;
;; tableof label   byte
;;         db     000000b                  ; mute - goes to PC speaker
;;         db     100100b                  ; 20hz to  2.9khz
;;         db     111001b                  ; 20hz to  5.9khz
;;         db     110001b                  ; 20hz to  8.9khz
;;         db     101001b                  ; 20hz to 11.9khz
;;         db     100010b                  ; 20hz to 15.9khz
;;         db     100001b                  ; 20hz to 17.8khz
;; ;
;; ; Mixer settings (0 - 12)
;; ;
;; mixersettings   label   byte
;;         db      0                       ; level 0
;;         db      20H                     ; level 1
;;         db      10H                     ; level 2
;;         db      08H                     ; level 3
;;         db      04H                     ; level 4
;;         db      02H                     ; level 5
;;         db      12H                     ; level 6
;;         db      2AH                     ; level 7
;;         db      16H                     ; level 8
;;         db      01H                     ; level 9
;;         db      29H                     ; level A
;;         db      1DH                     ; level B
;;         db      2FH                     ; level C
;;
;; ;
;; ; Volume settings (0 - 12)
;; ;
;; volsettings        label   byte
;;         db      0                       ; level 0
;;         db      60H                     ; level 1
;;         db      50H                     ; level 2
;;         db      48H                     ; level 3
;;         db      44H                     ; level 4
;;         db      42H                     ; level 5
;;         db      52H                     ; level 6
;;         db      6AH                     ; level 7
;;         db      56H                     ; level 8
;;         db      41H                     ; level 9
;;         db      69H                     ; level A
;;         db      5DH                     ; level B
;;         db      6FH                     ; level C
;;
;; ;
;; ; Xlat table   lookup= 0-31
;; ;              result= 0-12
;; ;
;;
;; Scale32To12     label   BYTE
;;         db      0 , 1, 1, 2, 2, 3, 3, 3         ; 0- 7
;;         db      4 , 4, 4, 5, 5, 5, 6, 6         ; 8-15
;;         db      6 , 7, 7, 7, 8, 8, 8, 9         ;16-23
;;         db      9 , 9,10,10,11,11,12,12         ;24-31
;;
;;
;; Scale64To40     label   BYTE
;;         db      0 , 1, 2, 3, 4, 5, 6, 7         ; 0- 7
;;         db      8 , 8, 9,10,10,11,12,12         ; 8-15
;;         db      13,14,14,15,16,16,17,18         ;16-23
;;         db      18,19,20,20,21,22,22,23         ;24-31
;;         db      24,24,25,26,26,27,28,28         ;32-39
;;         db      29,29,30,30,31,31,32,32         ;40-47
;;         db      32,33,33,34,34,35,35,35         ;48-55
;;         db      36,36,37,37,38,38,39,40         ;56-63
;;
;; BassTreb32to13  label   BYTE
;;         db      0 , 1, 1, 2, 2, 3, 3, 3         ; 0- 7
;;         db      4 , 4, 4, 5, 5, 5, 6, 6         ; 8-15
;;         db      6 , 7, 7, 7, 8, 8, 8, 9         ;16-23
;;         db      9 , 9,10,10,11,11,12,12         ;24-31
;;
;;
;; ;
;; ;---------------------------========================---------------------------
;; ;---------------------------====< DATA SECTION >====---------------------------
;; ;---------------------------========================---------------------------
;; ;
;; ;
;; ; These variables are DMA/Buffer control variables
;; ;
;;
;;         extrn   _fMuting:word           ; BOOLEAN, if on, set mixer output to 0
;; ;;;;;   public  _audiomixr
;;         extrn   _audiomixr:BYTE
;;         public  _audiofilt
;;
;; ;
;; ; These variables mirror the hardware state
;; ;
;; _sysspkrtmr     db      0               ;   42 System Speaker Timer Address
;; _systmrctlr     db      0               ;   43 System Timer Control Register
;; _sysspkrreg     db      0               ;   61 System Speaker Register
;; _joystick       db      0               ;  201 Joystick Register
;; ;;;;;;;_audiomixr      db      bMIclock+bMImonofm
;;                                         ;  B88 Audio Mixer Control Register
;; _intrctlrst     db      0               ;  B89 Interrupt Status Register write
;; _audiofilt      db      0               ;  B8A Audio Filter Control Register
;; _intrctlr       db      0               ;  B8B Interrupt Control Register write
;; _pcmdata        db      0               ;  F88 PCM data I/O register
;;                 db      0               ;  F89 reserved for future use
;; _crosschannel   db      bCCr2r+bCCl2l   ;  F8A Cross Channel
;;                 db      0               ;  F8B reserved for future use
;; _samplerate     dw      0               ; 1388 Sample Rate Timer Register
;; _samplecnt      dw      0               ; 1389 Sample Count Register
;; _spkrtmr        dw      0               ; 138A Local Speaker Timer Address
;; _tmrctlr        db      0               ; 138B Local Timer Control Register
;;
;; ;
;; ; a linear table of filter values - from mute to high
;; ;
;; _DATA   ENDS
;;
;; _TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
;;         ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
;; ;
;; ;   /*\
;; ;---|*|-=< void SetInput ( int input, int vol,channelLR, xover,output  ) >====---------
;; ;---|*|
;; ;---|*|       Set the selected channel within the Input Mixer
;; ;---|*|
;; ;---|*| Entry Conditions:
;; ;---|*|       wParm1 = Input  # (0-6 for serial mixer, 0-7 for 508)
;; ;---|*|       wParm2 = volume level (0-31)
;; ;---|*|       wParm3 = LEFT, RIGHT or BOTH
;; ;---|*|       wParm4 = Crossover Info (required onlby for 508)
;; ;---|*|       wParm5 = Output # (0-1 for either mixer)
;; ;---|*|
;; ;---|*| Exit Conditions:
;; ;---|*|       None
;; ;---|*|
;; ;   \*/
;;
;; P_input_num     equ    byte ptr NwParm1
;; P_volume_lvl    equ    byte ptr NwParm2
;; P_channel       equ    byte ptr NwParm3
;; P_crossover     equ    byte ptr NwParm4
;; P_output_num    equ    byte ptr NwParm5
;;
;;         public  _SetInput
;; _SetInput proc  near
;;
;;         push    bp
;;         mov     bp,sp
;;
;;         test    word ptr _dwCaps,MIXER_508
;;         jz      SI_serial
;;
;;         mov     dx,MIXER_508_REG
;;         xor     dx,_gwTranslateCode
;;         mov     al,P_input_num          ; Channel #
;;         mov     ah,P_channel            ; get left/right
;;         SHLM    ah,5                    ; move into A5, A6
;;         or      al,ah                   ;
;;         or      al,10010000b            ; D7 means address, D4 means input line
;;
;;         out     dx,al                   ; this sets the mixer address
;;
;;         mov     al,P_volume_lvl         ; get volume level (0-31 range)
;;
;;         mov     bl,P_crossover          ; get CROSSOVER
;;         cmp     bl,MIXCROSSCAPS_NORMAL_STEREO
;;         je      SI_CrossoverDone
;;
;;         test    bl,MIXCROSSCAPS_REVERSE_STEREO
;;         je      @F
;;         or      al,01000000b            ; both channels swapped
;;         jmp     short SI_CrossoverDone
;;
;; @@:
;;         cmp     P_channel,_LEFT
;;         jne     SI_right
;;
;;         test    bl,MIXCROSSCAPS_LEFT_TO_RIGHT
;;         jz      SI_CrossoverDone        ; doesn't apply to me
;;
;;         or      al,01000000b            ; this channel's swapped
;;         jmp     short SI_CrossoverDone
;; ;
;; SI_right:
;;         test    bl,MIXCROSSCAPS_RIGHT_TO_LEFT
;;         jz      SI_CrossoverDone        ; doesn't apply to me
;;
;;         or      al,01000000b            ; this channel's swapped
;; ;;;;;   jmp     short SI_CrossoverDone
;;
;; SI_CrossoverDone:
;;         mov     ah,P_output_num         ; get output #
;;         SHLM    ah,5
;;         or      al,ah
;; ;;;     out     dx,al                   ;;; rev D fix
;;         dec     dx                      ;; out to 78A instead of 78B
;;         mov     ah,al                   ;; make it a word value
;;         out     dx,ax                   ;; store word
;;
;;         pop     bp
;;         ret
;;
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; SI_serial:
;; ;
;; ; send out the mixer channel #
;; ;
;;
;;         mov     ah,P_input_num          ; Channel #
;;         inc     ah                      ; channel 0 was XXX
;;         cmp     P_channel,_LEFT
;;         je      @F                      ; no adjust for left channel
;;         add     ah,7                    ; adjust channel index for right channel
;; @@:
;;         or      ah,080h                 ; OR 80h makes this channel, not data
;;         call    lmix                    ;  (lmix looks for 80h)
;;
;; ; select the correct mixer
;;         mov     cl,P_output_num         ; get output number
;;         SHLM    cl,6                    ;; was mov cl,INPUTMIXER
;; ;
;; ; send out the mixer data
;; ;
;;         xor     ah,ah
;;         mov     al,P_volume_lvl         ; volume Level (range 0-31)
;;         call    FetchLevel              ; remap 0-31 into 0-12
;;         or      ah,cl                   ; select the target mixer
;;         call    lmix
;; ;
;; ; load dummy register to make device point off into never-never land
;; ;
;;         pop     bp
;;         ret
;;
;; _SetInput endp
;;
;; ;
;; ;   /*\
;; ;---|*|--------====< void SetOutput (line, level, channel ) >====--------
;; ;---|*|
;; ;---|*|       This routine outputs a new setting for a volume channel.
;; ;---|*|
;; ;---|*| Entry Conditions:
;; ;---|*|       WParm1 is a value from 0 - 1
;; ;---|*|       WParm2 is a value to be written to the control (0-63)
;; ;---|*|       WParm3 signifies left or right
;; ;---|*|
;; ;---|*| Exit Conditions:
;; ;---|*|       None
;; ;---|*|
;; ;   \*/
;;
;; P_output_num    equ    byte ptr NwParm1
;; P_volume_lvl    equ    byte ptr NwParm2
;; P_channel       equ    byte ptr NwParm3
;;
;;         public  _SetOutput
;; _SetOutput      proc    near
;;
;;         push    bp
;;         mov     bp,sp
;;
;;         test    word ptr _dwCaps,MIXER_508
;;         jz      SO_serial
;;
;;
;;         mov     dx,MIXER_508_REG
;;         xor     dx,_gwTranslateCode
;;
;;         mov     al,P_output_num         ; Output #
;;         inc     al                      ; Output number need to be 1 based
;;
;;         mov     ah,P_channel            ; get left/right
;;         SHLM    ah,5                    ; move into A5, A6
;;         or      al,ah                   ;
;;         or      al,10000000b            ; D7 means address,
;;
;;         EnterCrit                       ; BX hosed
;;         out     dx,al                   ; this sets the mixer address
;;
;;         mov     al,P_volume_lvl         ; get volume level (0-63 range)
;;         cmp     P_output_num,OUT_AMPLIFIER
;;         je      @F
;;         SHRM    al,2                    ; OUT_PCM output has 4 bit volume
;;         jmp     nomute
;; @@:
;;         test    _fMuting,-1             ; are we muting
;;         jz      nomute
;;
;;         xor     ax,ax                   ; if muting, always set vol to 0
;; nomute:
;; ;;;     out     dx,al                   ;; fix for rev 'D' hardware
;;         dec     dx                      ;; out to 78A instead of 78B
;;         mov     ah,al                   ;; make it a word value
;;         out     dx,ax                   ;; store word
;;
;;         LeaveCrit
;;
;;         pop     bp
;;         ret
;;
;; SO_serial:
;; ;
;; ; send it out!
;; ;
;;         cmp     P_output_num,0          ; serial device has volume on output 0 only
;;         jne     SO_exit
;;
;;         xor     ah,ah
;;         mov     al,P_volume_lvl         ; data
;;         test    _fMuting,-1             ; are we muting
;;         jz      nomute1
;;         xor     al,al                   ; if muting, always write 0
;; nomute1:
;;         lea     bx,Scale64to40
;;         xlat                            ; convert 64 levels to 0-40
;;         mov     ah,al
;;
;;         mov     bl,P_channel            ; users register select is 0 - 7
;;         and     bl,1                    ; we'll process anything...
;;         add     bl,44h                  ; see Pas-1 spec p.15 (LEFT VOLUME CONTROL)
;;
;;         call    lvol
;;
;; SO_exit:
;;         pop     bp
;;         ret
;;
;; _SetOutput endp
;;
;;
;; ;
;; ;   /*\
;; ;---|*|--------====< void SetEQ (line, EQ, level ) >====--------
;; ;---|*|
;; ;---|*|       This routine outputs a new setting for a volume channel.
;; ;---|*|
;; ;---|*| Entry Conditions:
;; ;---|*|       WParm1 is line number (range 0 - 1; 1 is don't care)
;; ;---|*|       WParm2 is EQ type (ie. Loudness, Stereo Enhance, BMT)
;; ;---|*|       WParm3 is level (range 0-31)
;; ;---|*|
;; ;---|*| Exit Conditions:
;; ;---|*|       None
;; ;---|*|
;; ;   \*/
;;
;; P_output  equ   byte ptr NwParm1
;; P_EQtype  equ   byte ptr NwParm2
;; P_level   equ   byte ptr NwParm3
;;
;;         public  _SetEQ
;; _SetEQ  proc    near
;;         push    bp
;;         mov     bp,sp
;;
;;         test    word ptr _dwCaps,MIXER_508
;;         jz      SEQ_serial
;;
;;         mov     dx,MIXER_508_REG
;;         xor     dx,_gwTranslateCode
;;
;;         xor     ah,ah
;;         mov     al,P_EQtype
;;         cmp     ax,_BASS
;;         jne     notBass
;;
;;         mov     al,10000011b            ;; signifies BASS
;;         out     dx,al
;;         mov     al, P_level
;;         lea     bx,BassTreb32to13
;;         xlat
;;         out     dx,al
;;         jmp     short SEQ_done
;;
;; notBass:
;;         cmp     ax,_TREBLE
;;         jne     SEQ_done
;;
;;         mov     al,10000100b            ;; signifies TREBLE
;;         out     dx,al
;;         mov     al, P_level
;;         lea     bx,BassTreb32to13
;;         xlat
;;         out     dx,al
;;
;; SEQ_done:
;;         pop     bp
;;         ret
;;
;; SEQ_serial:
;; ;
;; ; send it out!
;; ;
;;         cmp     P_output,0              ; serial device has volume on output 0 only
;;         jne     SEQ_exit
;;
;;         xor     ah,ah
;;         mov     al,P_level              ; data
;;         lea     bx,Scale32To12
;;         xlat                            ; convert 32 levels to 0-12
;;         mov     ah,al
;;
;;         mov     bl,P_EQtype             ; users register select is 0 - 7
;;         and     bl,1                    ; we'll process anything...
;;         add     bl,42h                  ; see Pas-1 spec p.15 (LEFT VOLUME CONTROL)
;;
;;         call    lvol
;; SEQ_exit:
;;         pop     bp
;;         ret
;;
;; _SetEQ  endp
;;
;; ;
;; ;   /*\
;; ;---|*|--------====< void SetMode (Loudness, Enhance ) >====--------
;; ;---|*|
;; ;---|*|       This routine sets loundess and stereo enhance modes
;; ;---|*|
;; ;---|*| Entry Conditions:
;; ;---|*|       WParm1 is loudness  (Z vs NZ)
;; ;---|*|       WParm2 is Stereo Enhance (range 0-3)
;; ;---|*|
;; ;---|*| Exit Conditions:
;; ;---|*|       None
;; ;---|*|
;; ;---|*|
;; ;---|*|
;; ;---|*| This should not be called SetMode.  On the National chip
;; ;---|*| (original PAS), mode refers to left mono, stereo and right mono modes.
;; ;---|*|
;; ;   \*/
;;
;; P_loudness equ  byte ptr NwParm1
;; P_enhance  equ  byte ptr NwParm2
;;
;;         public  _SetEqMode
;;         public  _SetMode
;; _SetEqMode label near
;; _SetMode proc   near
;;         push    bp
;;         mov     bp,sp
;;
;;         test    word ptr _dwCaps,MIXER_508
;;         jz      SM_serial
;;
;;         mov     dx,MIXER_508_REG
;;         xor     dx,_gwTranslateCode
;;
;;         mov     al,10000101b            ;; signifies BASS
;;         out     dx,al
;;
;;         mov     al,P_loudness
;;         or      al,al
;;         jz      @F
;;
;;         mov     al,100b                 ;; Loudness bit
;; @@:
;;         mov     ah,P_enhance
;;         and     ah,11b
;;         or      al,ah                   ;; combine loudness and stereo enhance bits
;;         out     dx,al
;;
;;         pop     bp
;;         ret
;;
;; SM_serial:
;; ;
;; ; send it out!
;; ;
;;         mov     al,P_loudness
;;         or      al,al
;;         jz      @F
;;
;;         mov     al,1b                   ;; Loudness bit
;; @@:
;;         mov     ah,P_enhance
;;         or      ah,ah
;;         jz      @F
;;         or      al,10b                  ;; stereo enhance bit
;; @@:
;;         mov     bl,41h                  ; see Pas-1 spec p.15 (LEFT VOLUME CONTROL)
;;
;;         mov     ah,al                   ; lvol wants it in ah
;;         call    lvol
;; SM_exit:
;;         pop     bp
;;         ret
;;
;; _SetMode endp
;;
;;
;; ;-------------------------------====< lmix >====-------------------------------
;; ;
;; ; lmix -- Load The Mixer
;; ;
;; ; Entry Conditions
;; ;       ah = index/data
;; ;
;; ; Exit Conditions:
;; ;       AX,BX,CX,DX modified
;; ;
;;         public  lmix
;; lmix    proc    near
;;
;;         EnterCrit               ;; destroys BX
;; ;
;; ; all clocks and ; strobes should be 1
;; ;
;;         mov     al,_audiomixr           ; save the realsound & dual fm bits
;;         and     al,bMIspkrint+bMImonofm
;;         or      al,not (bMIspkrint+bMImonofm)
;;
;;         mov     cx,8                    ; load bit count
;;         mov     dx,AUDIOMIXR            ; load mixer port
;;         xor     dx,_gwTranslateCode
;;         out     dx,al                   ; set initial clocks
;;
;; d1:     xor     al,bMIclock             ; toggle output mixer clock
;;         pause
;;         out     dx,al                   ; output clock is zero
;;         ror     al,1                    ; make room for data
;;         ror     ah,1                    ; get bit of data
;;         rcl     al,1                    ; shift into register
;;         out     dx,al                   ; send data to mixer
;;         xor     al,bMIclock             ; toggle clock again
;;         pause
;;         out     dx,al                   ; clock sould be 1 now
;;         loop    d1                      ; do all 8 bits this way
;;
;;         xor     al,bMImistrb            ; toggle strobe low
;;         out     dx,al                   ; which loads data into mixer
;;         pause
;;         xor     al,bMImistrb            ; toggle strobe high
;;         out     dx,al                   ; loading complete
;;
;;         mov     _audiomixr,al           ; save the last state
;;
;;         LeaveCrit               ;; Destroys BX
;;
;;         ret
;;
;; lmix    endp
;; ;
;; ;
;; ;
;; ;
;; ;-------------------------------====< lvol >====-------------------------------
;; ;
;; ; lvol  -- Load Volume control Register
;; ;
;; ; Entry Conditions:
;; ;       bl = parameter register (volume control channel 0-7)
;; ;       ah = data to transfer   (new channel setting)
;; ;
;; ; Exit Conditions:
;; ;       AX,BX,CX,DX modified
;; ;
;; lvol    proc    near
;; ;
;; ; pass everything, but left/right volume directly to the device
;; ;
;;         cmp     bl,44h                  ; left & right volume are presented
;;         jz      @F                      ; to the logical level as 0 - 40,
;;         cmp     bl,45h                  ; where 0 is the lowest, and 40 is
;;         jnz     lvolout                 ; the highest. In reality, this
;; @@:     sub     ah,40                   ; is backwards, that is, 40 is the
;;         neg     ah                      ; lowest, and 0 is the highest. We will
;; ;                                       ; correct the value here...
;; ; Perform the volume control output
;; ;
;; lvolout label   near
;;         mov     dx,AUDIOMIXR            ; load mixer port
;;         xor     dx,_gwTranslateCode
;; ;
;; ; all 1s but volume enable and clock
;; ;
;;         mov     al,_audiomixr           ; save the realsound & dual fm bits
;;         and     al,bMIspkrint+bMImonofm
;;         or      al,not (bMIspkrint+bMImonofm+bMIvol+bMIclock)
;;
;;         pushf                   ;; STOLEN FROM ENTERCRIT, can't kill bx
;;         pushf
;;         pop     cx
;;         test    ch,2            ; if interupts are already off, dont blow
;;         jz      @F          ; ... ~300 clocks doing the cli
;;         cli
;; @@:
;;
;;         out     dx,al                   ; set initial clocks
;;
;;         mov     cx,8                    ; load bit count for address
;; lv1:    xor     al,bMIclock             ; toggle volume control clock
;;         ror     al,1                    ; make room for data
;;         ror     bl,1                    ; get bit of data
;;         rcl     al,1                    ; shift into register
;;         out     dx,al                   ; send data to volume control
;;         pause
;;         xor     al,bMIclock             ; toggle the clock again
;;         out     dx,al                   ; clock should be 1 now
;;         loop    lv1                     ; do all 8 bits this way...
;;
;;         xor     al,bMIvol               ; toggle volume control enable
;;         pause
;;         out     dx,al                   ; which starts data loading
;;
;;         mov     cl,8                    ; load bit count for data
;; d2:     xor     al,bMIclock             ; toggle volume control clock
;;         ror     al,1                    ; make room for data
;;         ror     ah,1                    ; get bit of data
;;         rcl     al,1                    ; shift into register
;;         out     dx,al                   ; send data to volume control
;;         pause
;;         xor     al,bMIclock             ; toggle clock again
;;         out     dx,al                   ; clock should be 1 now
;;         loop    d2                      ; doall a 8 bits this way...
;;
;;         pause
;;         mov     cl,12                   ; load bit count for data
;; d3:     out     dx,al                   ; need to stall for 6 microseconds
;;         pause
;;         loop    d3                      ; waiting...
;;
;;         xor     al,bMIvol               ; toggle volume control enable
;;         out     dx,al                   ; to prepare
;;         pause
;;         out     dx,al                   ; need to stall
;;         pause
;;         out     dx,al
;;         pause
;;         out     dx,al
;;         pause
;;         xor     al,bMIvol               ; toggle volume control enable
;;         out     dx,al                   ; which loads data
;;
;;         mov     _audiomixr,al           ; save the last state
;;
;;         LeaveCrit               ;; Destroys BX
;;
;;         ret
;;
;; lvol    endp
;; ;
;; ;   /*\
;; ;---|*|--------------====< void SetFilter (int setting ) >===---------------
;; ;---|*|
;; ;---|*|       This routine selects a filter setting from mute to high freq filter.
;; ;---|*|
;; ;---|*| Entry Conditions:
;; ;---|*|       WParm1 is a value from 0 - 6
;; ;---|*|
;; ;---|*| Exit Conditions:
;; ;---|*|       None
;; ;---|*|
;; ;---|*|
;; ;   \*/
;;
;;         public  _SetFilter
;; _SetFilter      proc    near
;;         push    bp
;;         mov     bp,sp
;;
;;         mov     bx,NwParm1
;;         cmp     bx,FILTERMAX            ; validate the user index
;;         ja      badval
;;
;;         mov     al,tableof[bx]          ; grab an appropriate value
;;         mov     dx,AUDIOFILT            ; and toss it out...
;;         xor     dx,_gwTranslateCode
;;
;;         EnterCrit               ;; destroys BX
;;         mov     ah,_audiofilt           ; shadow it too...
;;
;;         and     ah,not (fFIdatabits+fFImutebits) ; save everthing but
;;         or      al,ah                   ; the filter and mute bits
;;
;;         out     dx,al
;;         mov     _audiofilt,al           ; shadow it too...
;;         LeaveCrit               ;; Destroys BX
;;
;; badval:
;;         pop     bp
;;         ret
;;
;; _SetFilter       endp
;;
;;
;; ;------------------------------====< FetchLevel >====---------------------------
;; ;
;; ; FetchLevel  --  remap mixer level from 0-63 into number of steps
;; ;
;; ; Entry Conditions:
;; ;       AX holds the mixer level
;; ;
;; ; Exit Condtions:
;; ;       AH holds the converted value
;; ;
;; FetchLevel      proc near
;; ;
;; ; remap 0-31 into 0-12
;; ;
;;         and     ax,001Fh                ; clear ah, save only 5 bits
;;
;;         lea     bx,Scale32To12
;;         xlat    byte ptr Scale32To12
;;
;;         lea     bx,mixersettings
;;         xlat    byte ptr mixersettings
;;         mov     ah,al
;;
;;         ret
;;
;; FetchLevel endp
;; _TEXT   ENDS
;;
;;         end
