/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* mvmix.c
*
* This module contains code for controlling the Media Vision Mixer
*      hardware.  Media Vision has used only two software-controllable
*      mixer chips so far.  The MV 508 is used on the PAS 16 only.  All
*      other chips use the National part XXXX.  Programming the
*      Nationial mixer chip is VOODOO BLACK MAGIC and will be very slow
*      under NT.
*
*      Note: As of 11/11/92, I have determined that the C routines that
*      handle the National chip are flawed.  Have reverted to ASM routines
*      in order to get it working.  It would be best to replace ASM with
*      C slowly, one routine at a time.
*
*/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include <meerror.h>
#define DRV_16
#include "os2mixer.h"

#include "types.h"
#include "findpas.h"
#include "pasdef.h"
#include "mvprodd.h"
#include "mvmixer.h"
#include "proto.h"
#include "debug.h"
#include "commdbg.h"
extern PROFILE pf;

void SetInput (WORD P_input_num, WORD P_volume_lvl,WORD P_channel,WORD P_crossover,WORD P_output_num );
void SetOutput (WORD P_output_num,WORD P_volume_lvl,WORD P_channel );
void SetEq(WORD P_output, WORD P_EQtype,WORD  P_level);
void NationalMix(WORD wData);
void NationalVolume(WORD wVolume,WORD wVolumeRegister);
DWORD Scale100ToFFFF(WORD wVal);
BYTE ScaleFFFFTo100(WORD wVal);

//
//-------------------------========================---------------------------
//------------------------====< DATA SECTION >====---------------------------
//-------------------------========================---------------------------
//
//
// These variables are DMA/Buffer control variables
//

BOOL    fMuting;                // BOOLEAN, if on, set mixer output to 0

//
// These variables mirror the hardware state
//
BYTE    _sysspkrtmr;            // 42 System Speaker Timer Address
BYTE    _systmrctlr;            // 43 System Timer Control Register
BYTE    _sysspkrreg;            // 61 System Speaker Register
BYTE    _joystick;              // 201 Joystick Register

BYTE    _audiomixr= SERIAL_MIX_CLOCK+SERIAL_MIX_DUALFM ;


BYTE    _intrctlrst;            // B89 Interrupt Status Register write
BYTE    _audiofilt;             // B8A Audio Filter Control Register
BYTE    _intrctlr;              // B8B Interrupt Control Register write
BYTE    _pcmdata;               // F88 PCM data I/O register
BYTE    _crosschannel=PCM_STEREO; //  F8A Cross Channel
BYTE    _samplerate;            // 1388 Sample Rate Timer Register
BYTE    _samplecnt;             // 1389 Sample Count Register
BYTE    _spkrtmr;               // 138A Local Speaker Timer Address
BYTE    _tmrctlr;               // 138B Local Timer Control Register

WORD    _wTranslateCode;
DWORD   _dwCaps;


//
// a linear table of filter values - from mute to high
//
BYTE    FilterTable[]=
        {
        0x00,           // 000000b    mute - goes to PC speaker
        0x24,           // 100100b    20hz to  2.9khz
        0x39,           // 111001b    20hz to  5.9khz
        0x31,           // 110001b    20hz to  8.9khz
        0x29,           // 101001b    20hz to 11.9khz
        0x22,           // 100010b    20hz to 15.9khz
        0x21,           // 100001b    20hz to 17.8khz
        };

//
// Mixer settings (0 - 12)
//
BYTE    mixersettings[]=
        {
        0x00,           // level 0
        0x20,           // level 1
        0x10,           // level 2
        0x08,           // level 3
        0x04,           // level 4
        0x02,           // level 5
        0x12,           // level 6
        0x2A,           // level 7
        0x16,           // level 8
        0x01,           // level 9
        0x29,           // level A
        0x1D,           // level B
        0x2F            // level C
        };


//
// Volume settings (0 - 12)
//

BYTE volsettings[]=
        {
        0x00,           // level 0
        0x60,           // level 1
        0x50,           // level 2
        0x48,           // level 3
        0x44,           // level 4
        0x42,           // level 5
        0x52,           // level 6
        0x6A,           // level 7
        0x56,           // level 8
        0x41,           // level 9
        0x69,           // level A
        0x5D,           // level B
        0x6F            // level C
        };

//
// Xlat table   lookup= 0-31
//             result= 0-12
//

BYTE Scale32To12[]=
        {
        0 , 1, 1, 2, 2, 3, 3, 3,        //  0- 7
        4 , 4, 4, 5, 5, 5, 6, 6,        //  8-15
        6 , 7, 7, 7, 8, 8, 8, 9,        // 16-23
        9 , 9,10,10,11,11,12,12         // 24-31
        };


BYTE    Scale64To40[]=
        {
        0 , 1, 2, 3, 4, 5, 6, 7,   //  0- 7
        8 , 8, 9,10,10,11,12,12,   //  8-15
        13,14,14,15,16,16,17,18,   // 16-23
        18,19,20,20,21,22,22,23,   // 24-31
        24,24,25,26,26,27,28,28,   // 32-39
        29,29,30,30,31,31,32,32,   // 40-47
        32,33,33,34,34,35,35,35,   // 48-55
        36,36,37,37,38,38,39,40    // 56-63
        };

BYTE    BassTreb32to13[]=
        {
        0 , 1, 1, 2, 2, 3, 3, 3,   //  0- 7
        4 , 4, 4, 5, 5, 5, 6, 6,   //  8-15
        6 , 7, 7, 7, 8, 8, 8, 9,   // 16-23
        9 , 9,10,10,11,11,12,12    // 24-31
        };

//
// This table scales the Mixer Volume settings better!
//
UCHAR   Scale508MixerVolume[] =
    {
    0 , 8,12,14,16,17,18,18,   //  0- 7
    19,19,20,20,21,21,22,22,   //  8-15
    22,23,23,23,24,24,24,25,   // 16-23
    25,25,26,26,27,27,29,31    // 24-31
    };

//
// MV508B scale for Volume settings
// WYT: added support for 508B mixer.
//
// for Attenuation
//      0  = full attenuation
//      31 = 0dB attenuation
//
// for Gain
// 31 = +2dB gain
//      22 = +20db gain
// 0  = Max gain
//

UCHAR   Scale508BMixerVolume[8][32] =    // 8 lines; 32 levels
{
//
// Line 0 - FM ==> +26dB of gain; Max Gain on this input line
//
        {
        0 , 8,13,16,17,18,19,20,        // 0- 7
        21,22,23,24,25,26,27,28,        // 8-15
        29,30,31,31,30,29,28,27,        // 16-23
        26,25,24,23,22,21,20,19         // 24-31
        },

//
// Line 1 - Mix input ==> NO Gain!!
//
        {
        0 , 8,12,14,16,17,18,18,        // 0- 7
        19,19,20,20,21,21,22,22,        // 8-15
        22,23,23,23,24,24,24,25,        // 16-23
        25,26,26,27,28,29,30,31         // 24-31
        },

//
// Line 2 - Line In ==> +20db of gain; -6dB of Gain compared to FM
//
        {
        0 , 8,12,13,14,15,16,17,        // 0- 7
        18,19,20,21,22,23,24,25,        // 8-15
        26,27,28,29,30,31,31,30,        // 16-23
        29,28,27,26,25,24,23,22         // 24-31
        },

//
// Line 3 - CD-ROM ==> +20db of gain; -6dB of Gain compared to FM
//
        {
        0 , 8,12,13,14,15,16,17,        // 0- 7
        18,19,20,21,22,23,24,25,        // 8-15
        26,27,28,29,30,31,31,30,        // 16-23
        29,28,27,26,25,24,23,22         // 24-31
        },

//
// Line 4 - MIC ==> +20db of gain; -6dB of Gain compared to FM
//
        {
        0 , 8,12,13,14,15,16,17,        // 0- 7
        18,19,20,21,22,23,24,25,        // 8-15
        26,27,28,29,30,31,31,30,        // 16-23
        29,28,27,26,25,24,23,22         // 24-31
        },

//
// Line 5 - Wave Out ==> +20db of gain; -6dB of Gain compared to FM
//
        {
        0 , 8,12,13,14,15,16,17,        // 0- 7
        18,19,20,21,22,23,24,25,        // 8-15
        26,27,28,29,30,31,31,30,        // 16-23
        29,28,27,26,25,24,23,22         // 24-31
        },

//
// Line 6 - PC Speaker ==> +20db of gain; -6dB of Gain compared to FM
//
        {
        0 , 8,12,13,14,15,16,17,        // 0- 7
        18,19,20,21,22,23,24,25,        // 8-15
        26,27,28,29,30,31,31,30,        // 16-23
        29,28,27,26,25,24,23,22         // 24-31
        },

//
// Line 7 - SoundBlaster ==> +20db of gain; -6dB of Gain compared to FM
//
        {
        0 , 8,12,13,14,15,16,17,        // 0- 7
        18,19,20,21,22,23,24,25,        // 8-15
        26,27,28,29,30,31,31,30,        // 16-23
        29,28,27,26,25,24,23,22         // 24-31
        }
};

//
// This is the table for bit D6
// 0 = attenuation
// 1 = gain
UCHAR   Scale508BMixerVolumeD6[8][32] =
{
//
// Line 0 - FM
//
        {
        0 , 0, 0, 0, 0, 0, 0, 0,        // 0- 7
        0 , 0, 0, 0, 0, 0, 0, 0,        // 8-15
        0 , 0, 0, 1, 1, 1, 1, 1,        // 16-23
        1 , 1, 1, 1, 1, 1, 1, 1         // 24-31
        },

//
// Line 1 - Mix
//
        {
        0 , 0, 0, 0, 0, 0, 0, 0,        // 0- 7
        0 , 0, 0, 0, 0, 0, 0, 0,        // 8-15
        0 , 0, 0, 0, 0, 0, 0, 0,        // 16-23
        0 , 0, 0, 0, 0, 0, 0, 0         // 24-31
        },

//
// Line 2 - Line In
//
        {
        0 , 0, 0, 0, 0, 0, 0, 0,        // 0- 7
        0 , 0, 0, 0, 0, 0, 0, 0,        // 8-15
        0 , 0, 0, 0, 0, 0, 1, 1,        // 16-23
        1 , 1, 1, 1, 1, 1, 1, 1         // 24-31
        },

//
// Line 3 - CD-ROM
//
        {
        0 , 0, 0, 0, 0, 0, 0, 0,        // 0- 7
        0 , 0, 0, 0, 0, 0, 0, 0,        // 8-15
        0 , 0, 0, 0, 0, 0, 1, 1,        // 16-23
        1 , 1, 1, 1, 1, 1, 1, 1         // 24-31
        },

//
// Line 4 - Mic
//
        {
        0 , 0, 0, 0, 0, 0, 0, 0,        // 0- 7
        0 , 0, 0, 0, 0, 0, 0, 0,        // 8-15
        0 , 0, 0, 0, 0, 0, 1, 1,        // 16-23
        1 , 1, 1, 1, 1, 1, 1, 1         // 24-31
        },

//
// Line 5 - Wave Out
//
        {
        0 , 0, 0, 0, 0, 0, 0, 0,        // 0- 7
        0 , 0, 0, 0, 0, 0, 0, 0,        // 8-15
        0 , 0, 0, 0, 0, 0, 1, 1,        // 16-23
        1 , 1, 1, 1, 1, 1, 1, 1         // 24-31
        },

//
// Line 6 - PC Speaker
//
        {
        0 , 0, 0, 0, 0, 0, 0, 0,        // 0- 7
        0 , 0, 0, 0, 0, 0, 0, 0,        // 8-15
        0 , 0, 0, 0, 0, 0, 1, 1,        // 16-23
        1 , 1, 1, 1, 1, 1, 1, 1         // 24-31
        },

//
// Line 7 - SoundBlaster
//
        {
        0 , 0, 0, 0, 0, 0, 0, 0,        // 0- 7
        0 , 0, 0, 0, 0, 0, 0, 0,        // 8-15
        0 , 0, 0, 0, 0, 0, 1, 1,        // 16-23
        1 , 1, 1, 1, 1, 1, 1, 1         // 24-31
        }
};

#ifdef MIX_MONITOR

char far *InputTable[8]=
                {
                "SYNTH","MIXER","AUX","CD","MIC","WAVE","PCSPKR","SNDBLST"
                };
char far *OutputTable[2]=
                {
                "AMP","RECORD"
                };

char far *LeftRightTable[3]=
                {
                "BOTH","LEFT","RIGHT"
                };

#endif

/*                                      ---------------------------- SetInput -
** Set the selected channel within the Input Mixer
**
** Entry Conditions:
**    P_input_num  = Input  # (0-6 for serial mixer, 0-7 for 508)
**    P_volume_lvl = volume level (0-FFFF)
**    P_channel    = LEFT, RIGHT or BOTH
**    P_crossover  = Crossover Info (required onlby for 508)
**    P_output_num = Output #   (0-1 for either mixer)
**
** Exit Conditions:
**    None
*/
void SetInput (WORD P_input_num, WORD P_volume_lvl,WORD P_channel,
               WORD P_crossover,WORD P_output_num )
{
   BYTE  bTemp,bTemp1;
   BYTE  bLevel508B, bLevelSetting508B, bBitD6508B;

   if (pf.ProCard[0].Caps.CapsBits.Mixer_508)
      {
      bTemp=(BYTE) P_input_num;                       // Channel #

      bTemp|=(P_channel<<5);                          // get left/right
      bTemp|=MV_508_ADDRESS;                          // 508 ADDRESS BIT
      bTemp|=MV_508_INPUT;                            // 508 INPUT BIT

      PASX_OUT(MIXER_508_REG,bTemp);                  // set reg addr

                //
                // Do we have a 508-B Mixer?
                //
                if ( (pf.ProCard[0].wBoardRev == PAS_CDPC_LC) ||
           (pf.ProCard[0].wBoardRev == PAS_BASIC) )
                        {
                        // ***********
                        // 508-B Mixer
                        // ***********

                        // Scale the input level
                        bLevel508B = Scale508BMixerVolume[P_input_num][P_volume_lvl];

                        // Get the Gain/Attenuation bit - D6
                        bBitD6508B = Scale508BMixerVolumeD6[P_input_num][P_volume_lvl];

                        // Move it into bit D6
                        bBitD6508B = (BYTE)(bBitD6508B << 6);

                        // Get the total level
                        bLevelSetting508B = bLevel508B | bBitD6508B;

         #ifdef MIX_MONITOR
         PrintfOut ("508B line %d >> %s Input %s: Vol=%d, Scaled = 0x%x",
              P_input_num,
              InputTable[P_input_num],
              LeftRightTable[P_channel],
              P_volume_lvl,
              bLevelSetting508B);
         #endif

                        PASX_OUT(MIXER_508_REG, bLevelSetting508B);  // set 508B input vol
                        }                       // end if(508B Mixer)
                else
                        {
                        // *********
                        // 508 Mixer
                        // *********

         // scale the input level
         bTemp = Scale508MixerVolume[P_volume_lvl];

         // swap the channel if necessary
         switch (P_crossover)
            {
            case MIXCROSSCAPS_REVERSE_STEREO:
                                case MIXCROSSCAPS_LEFT_TO_RIGHT:
                                case MIXCROSSCAPS_RIGHT_TO_LEFT:
               bTemp |= MV_508_SWAP;            // this channel's swapped
            }

         bTemp |= ((P_output_num & 1) << 5);    // select output number

         #ifdef MIX_MONITOR
         PrintfOut ("508 >> %s Input %s:  Volume=%d",
              InputTable[P_input_num],
              LeftRightTable[P_channel],
              bTemp);
         #endif

         PASX_OUT(MIXER_508_REG, bTemp);        // set 508 input vol
         }  // end else(!508B mixer)
      }     // end if(508 mixer)
   else
      {
                //*************************************
                // National (serially programmed) mixer
                //*************************************

      //
      // send out the mixer channel #
      //

      bTemp = (BYTE) P_input_num;               // Channel #
      bTemp++;                                  // channel 0 was XXX

      if (P_channel==_RIGHT)
         bTemp+=7;    // this magic number is the offset to right channel

      bTemp|=NATIONAL_COMMAND;
      NationalMix(bTemp);

      // select the correct mixer
      bTemp1=(BYTE) (P_output_num<<6);          // get output number

      //
      // send out the mixer data
      //

      bTemp=(BYTE)(P_volume_lvl &= 0x1F);       // limit to 31
      bTemp=Scale32To12[bTemp];
      bTemp=mixersettings[bTemp];
      bTemp|=bTemp1;

      NationalMix(bTemp);
      }
}



/*                                      --------------------------- SetOutput -
** This routine outputs a new setting for a volume channel.
**
** Entry Conditions:
**       WParm1 is a value from 0 - 1
**       WParm2 is a value to be written to the control (0-63)
**       WParm3 signifies left or right
**
** Exit Conditions:
**       None
*/
void SetOutput (WORD P_output_num,WORD P_volume_lvl,WORD P_channel )
{
   BYTE    bTemp;

   #ifdef MIX_MONITOR
   PrintfOut (">> %s Output %s:  Volume=%d",
              OutputTable[P_output_num],
              LeftRightTable[P_channel],
              P_volume_lvl);
   #endif

   if (pf.ProCard[0].Caps.CapsBits.Mixer_508)
      {
      //EnterCrit                     /// don't interrupt me!

      // investigate keSynchronizeExecution

      bTemp=(BYTE) P_output_num;
      bTemp++;                          // Output number need to be 1 based

      bTemp|=(P_channel<<5);  // get left/right
      bTemp|=MV_508_ADDRESS;

      PASX_OUT(MIXER_508_REG,bTemp);

      if (fMuting)
         {
         bTemp=0;
         }
      else
         {
         bTemp=(BYTE) P_volume_lvl;         // get volume level (0-63 range)

         if (P_output_num!=OUT_AMPLIFIER)
            bTemp>>=2;                      // output B of MV508 has 0-15 range
         }
      PASX_OUT(MIXER_508_REG,bTemp);
      }

   else    // NATIONAL (SERIAL PROGRAMMED) MIXER
      {
      if (P_output_num==0)    // serial device has volume on output 0 only
         {
         if (fMuting)
            {
            bTemp=0;
            }
         else
            {
            bTemp=Scale64To40[P_volume_lvl];
            }
         NationalVolume((WORD)bTemp,(WORD)(P_channel&1)+NATIONAL_LEFT_VOL_REG); // see Pas-1 spec p.15 (LEFT VOLUME CONTROL)
         }
      }
}



/*                                      ------------------------------- SetEq -
** This routine outputs a new setting for a volume channel.
**
** Entry Conditions:
**       WParm1 is line number (range 0 - 1; 1 is don't care)
**       WParm2 is EQ type (ie. Loudness, Stereo Enhance, BMT)
**       WParm3 is level (range 0-31)
**
** Exit Conditions:
**       None
*/
void SetEq (WORD P_output, WORD P_EQtype, WORD P_level)
{
   BYTE bTemp;

   if (P_output!=0)
      return;

   if (pf.ProCard[0].Caps.CapsBits.Mixer_508)
      {
      switch (P_EQtype)
         {
         case _BASS:
            PASX_OUT(MIXER_508_REG, (BYTE)(MV_508_ADDRESS + MV_508_BASS));
            PASX_OUT(MIXER_508_REG, BassTreb32to13[P_level]);
            break;

         case _TREBLE:
            PASX_OUT(MIXER_508_REG, (BYTE)(MV_508_ADDRESS + MV_508_TREBLE));
            PASX_OUT(MIXER_508_REG, BassTreb32to13[P_level]);
            break;
         }
      }

   else    // NATIONAL (SERIAL PROGRAMMED) MIXER
      {
      bTemp=Scale32To12[P_level];
      // see Pas-1 spec p.15 (LEFT VOLUME CONTROL)
      NationalVolume((WORD)bTemp,(P_EQtype&1)+NATIONAL_BASS_REG );
      }
}



/*                                      --------------------------- SetEqMode -
** This routine sets loundess and stereo enhance modes
**
** Entry Conditions:
**       loudness  (Z vs NZ)
**       Stereo Enhance (range 0-3)
**
** Exit Conditions:
**       None
*/
void SetEqMode (WORD P_loudness, WORD P_enhance)
{
   BYTE    bTemp=0;

   if (pf.ProCard[0].Caps.CapsBits.Mixer_508)
      {
//      PASX_OUT(MIXER_508_REG, (BYTE)(MV_508_ADDRESS + MV_508_EQMODE));
      PASX_OUT(MIXER_508_REG, (MV_508_ADDRESS + MV_508_EQMODE));
      if (P_loudness)
         bTemp+=MV_508_LOUDNESS;

      bTemp+=P_enhance & MV_508_ENHANCE;
      PASX_OUT(MIXER_508_REG,bTemp);
      }
   else
      {
      if (P_loudness)
         bTemp=NATIONAL_LOUDNESS;                // Loudness bit

      if (P_enhance)
         bTemp|=NATIONAL_ENHANCE;                // stereo enhance bit

      // see Pas-1 spec p.15 (LEFT VOLUME CONTROL)
      NationalVolume(bTemp,NATIONAL_LOUD_ENH_REG);
      }
}

/*                                      ------------------------- NationalMix -
** NationalMix -- Load The National Mixer                                          |
**                                                                                                                                                 |
** Entry Conditions                                                                                                        |
** wData = index/data                                                                                              |
*/
void NationalMix (WORD wData)
{
   BYTE  bTemp=0;
   WORD  i;

   // EnterCrit

   bTemp =_audiomixr;                           // get current hardware state
   bTemp &= SERIAL_MIX_REALSOUND+SERIAL_MIX_DUALFM;  // save state, only these bits
   bTemp|=~(SERIAL_MIX_REALSOUND+SERIAL_MIX_DUALFM); // turn on all other bits
                                                                                                         // all clocks and strobes should be 1
   PASX_OUT(SERIAL_MIXER,bTemp);

   for (i=0; i<8; i++)
      {
      // output clock is 0
      bTemp ^= SERIAL_MIX_CLOCK;        // clock off
      PASX_OUT(SERIAL_MIXER,bTemp);

      bTemp&=(~D0);                     // mask off D0
      bTemp |= ((wData>>i)&1);
      PASX_OUT(SERIAL_MIXER,bTemp);

      bTemp ^= SERIAL_MIX_CLOCK;        // clock on
      PASX_OUT(SERIAL_MIXER,bTemp);     // send data, clock is 1
      }

   bTemp ^= SERIAL_MIX_STROBE;
   PASX_OUT(SERIAL_MIXER,bTemp);        // strobe it in

   bTemp ^= SERIAL_MIX_STROBE;
   PASX_OUT(SERIAL_MIXER,bTemp);        // strobe it in

   _audiomixr=(BYTE) bTemp;             // save the last state
}


/*                                      ---------------------- NationalVolume -
** NationalVolume -- Load Volume control Register
**
** Entry Conditions:
**        bl = parameter register (volume control channel 0-7)
**        ah = data to transfer   (new channel setting)
*/

void NationalVolume (WORD wVolume,WORD wVolumeChannel)
{
   //
   // pass everything, but left/right volume directly to the device
   //
   // left & right volume are presented
   // to the logical level as 0 - 40,
   // where 0 is the lowest, and 40 is
   // the highest. In reality, this
   // is backwards, that is, 40 is the
   // lowest, and 0 is the highest. We will
   // correct the value here...

   BYTE    bTemp;
   WORD    i;
   short   sVolume=wVolume;

   // Perform the volume control output

   if (( wVolumeChannel==NATIONAL_LEFT_VOL_REG) ||
        (wVolumeChannel==NATIONAL_RIGHT_VOL_REG ))
      sVolume =40-sVolume;            // invert range

   //
   // all 1s but volume enable and clock
   //
   bTemp=_audiomixr;           // save the realsound & dual fm bits
   bTemp &= SERIAL_MIX_REALSOUND+SERIAL_MIX_DUALFM;
   bTemp |= ~ (SERIAL_MIX_REALSOUND+SERIAL_MIX_DUALFM+SERIAL_MIX_MASTER+SERIAL_MIX_CLOCK);

   // EnterCrit
   PASX_OUT(SERIAL_MIXER,bTemp);        // note: clock is off

   for (i=0; i<8; i++)
      {
      bTemp ^= SERIAL_MIX_CLOCK;                                                        // clock's off
      bTemp&=(~D0);                     // mask off D0
      bTemp=(BYTE)((wVolumeChannel >> i) & D0);
      PASX_OUT(SERIAL_MIXER,(bTemp));
      bTemp ^= SERIAL_MIX_CLOCK;
      PASX_OUT(SERIAL_MIXER,(bTemp));                                           // clock's on
      }

   // write with volume control enable
   // which starts data loading

   bTemp ^= SERIAL_MIX_MASTER;
   PASX_OUT(SERIAL_MIXER,bTemp);

   for (i=0; i<8; i++)
      {
      bTemp ^= SERIAL_MIX_CLOCK;                                                        // clock's off
      bTemp&=(~D0);                                           // mask off D0
      bTemp |= ((sVolume>>i) & D0);           // move current bit into D0
      PASX_OUT(SERIAL_MIXER,bTemp);
      bTemp ^= SERIAL_MIX_CLOCK;                                                        // clock's off
      PASX_OUT(SERIAL_MIXER,bTemp);
      }

   for (i=0; i<12; i++)
      PASX_OUT(SERIAL_MIXER,bTemp);           // need to stall for 6 microseconds

   // toggle volume control enable

   bTemp ^= SERIAL_MIX_MASTER;
   PASX_OUT(SERIAL_MIXER,bTemp);
   PASX_OUT(SERIAL_MIXER,bTemp);
   PASX_OUT(SERIAL_MIXER,bTemp);
   PASX_OUT(SERIAL_MIXER,bTemp);
   bTemp ^= SERIAL_MIX_MASTER;
   PASX_OUT(SERIAL_MIXER,bTemp);

   _audiomixr=(BYTE) bTemp;                     // save the last state
}



/*                                      --------------------------- SetFilter -
** This routine selects a filter setting from mute to high freq filter.
**
** Entry Conditions:
**       WParm1 is a value from 0 - 6
**
** Exit Conditions:
**       None
*/
void SetFilter (WORD wSetting)
{
   WORD    wTemp;

   if (wSetting <= FILTERMAX)
      {
      wSetting=FilterTable[wSetting];

      wTemp = _audiofilt;                     // get current bits
      wTemp &= ~(fFIdatabits+fFImutebits);    // save everthing but

      wSetting|=wTemp;

      //      EnterCrit
      PASX_OUT(FILTER_REGISTER,(BYTE)wSetting);
      //KeStallExecutionProcessor(6);           // wait 6 us

      _audiofilt=(BYTE)wSetting;                // set current bits
      }
}


//#if 0
//DWORD
//Scale100ToFFFF(WORD wVal)
//{
//        DWORD dwScaled;
//
//        dwScaled=((DWORD)wVal) * (0xFFFFL/100L);
//        dwScaled=(dwScaled & 0xff00L)+ (dwScaled >>8);
//
//        return(dwScaled);
//}
//
//BYTE
//ScaleFFFFTo100(WORD wVal)
//{
//        BYTE bScaled;
//
//        bScaled=((wVal>>8)*100)/255;
//
//        return(bScaled);
//}
//#endif
