;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; mvmidi.inc
;
;******************************************************************************


IF 0
;   /*\
;---|*|----====< debug support >====----
;   \*/

DOUT1   macro   text
        local   execution

IFDEF DEBUG
        pusha
        push    cs              ;; push string pointer
        call    execution       ;; ..onto stack

        db      "&text&",0dh,0ah,0

execution:
        extrn   OutputDebugStr:far
        cCall   OutputDebugStr
        popa
ENDIF
        endm


DbgWord macro val
IFDEF DEBUG
    push ax
    push si
    mov si, offset dgroup:msgWord
    mov ax, val
    call dbgWordToMsg
    mov ax, offset dgroup:msgWord
    extrn OutputDebugStr:far
    cCall OutputDebugStr <ds, ax>
    pop si
    pop ax
ENDIF
endm
ENDIF

DUALFM          EQU     1               ; Dual FM chips
DUALMIXER       EQU     1               ; Dual mixers
FILTER          EQU     1               ; Has filter after input mixer
VOLUME          EQU     1               ; Has total volume control
;
SYSSPKRTMR      EQU     00042h          ; System Speaker Timer Address
SYSTMRCTLR      EQU     00043h          ; System Timer Control Register
SYSSPKRREG      EQU     00061h          ; System Speaker Register
JOYSTICK        EQU     00201h          ; Joystick Register
LFMADDR         EQU     00388h          ; Left  FM Synthesizer Address Register
LFMDATA         EQU     00389h          ; Left  FM Synthesizer Data Register
RFMADDR         EQU     0038Ah          ; Right FM Synthesizer Address Register
RFMDATA         EQU     0038Bh          ; Right FM Synthesizer Data Register
DFMADDR         EQU     00788h          ; Dual  FM Synthesizer Address Register
DFMDATA         EQU     00789h          ; Dual  FM Synthesizer Data Register
AUDIOMIXR       EQU     00B88h          ; Audio Mixer Control Register
;!!
INTRCTLRST      equ     00b89h
INTRCTLR        EQU     00b8bh          ; Interrupt Control Register
;INTRCTLR       EQU     00B89h          ; Interrupt Control Register
AUDIOFILT       EQU     00B8Ah          ; Audio Filter Control Register
PCMDATA         EQU     00F88h          ; PCM data I/O register
SAMPLERATE      EQU     01388h          ; Sample Rate Timer Register
SAMPLECNT       EQU     01389h          ; Sample Count Register
SPKRTMR         EQU     0138Ah          ; Local Speaker Timer Address
TMRCTLR         EQU     0138Bh          ; Local Timer Control Register
MDIRQVECT       EQU     01788H          ; MIDI r00 - IRQ Vector Register
MDSYSCTLR       EQU     01789H          ; MIDI r01 - System Control Register
MDSYSSTAT       EQU     0178AH          ; MIDI r02 - IRQ Status Register
MDIRQCLR        EQU     0178BH          ; MIDI r03 - IRQ Clear Register
MDGroup4        EQU     01B88H          ; MIDI r*4 Register Group
MDGroup5        EQU     01B89H          ; MIDI r*5 Register Group
MDGroup6        EQU     01B8AH          ; MIDI r*6 Register Group
MDGroup7        EQU     01B8BH          ; MIDI r*7 Register Group

;pas2 midi definitions
PAS2_MIDI_DAT   EQU     0178ah
PAS2_MIDI_CTRL  EQU     0178bh
PAS2_MIDI_STAT  EQU     01b88h
PAS2_FIFO_PTRS  EQU     01b89h


;
; C convention stack parameters
;
wParm1          equ     [bp+2+@ret+00h]
wParm2          equ     [bp+2+@ret+02h]
wParm3          equ     [bp+2+@ret+04h]
wParm4          equ     [bp+2+@ret+06h]
wParm5          equ     [bp+2+@ret+08h]

dParm1          equ     [bp+2+@ret+00h]
dParm2          equ     [bp+2+@ret+04h]
dParm3          equ     [bp+2+@ret+08h]
dParm4          equ     [bp+2+@ret+0ch]

;
; miscellaneous equates & macros
;

bptr            equ     byte ptr
wptr            equ     word ptr
dptr            equ     dword ptr

_lp             struc
 off            dw      ?
 sel            dw      ?
_lp             ends

pause           equ     <jmp $+2>
disableINT      equ     cli
enableINT       equ     sti

;
; end of mvmidi.inc
;
