/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* mixsubs.c - PAS-16 Mixer subroutines
*
******************************************************************************/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#define DRV_16
#include "os2mixer.h"
///#include <stdlib.h>
#include <ctype.h>

#include "mvsystem.h"
//#include "pasdef.h"
#include "findpas.h"
#include "mvprodd.h"
#include "mvmixer.h"
#include "proto.h"
#include "globals.h"
#include "patch.h"
#include "debug.h"
#include "commdbg.h"

WORD    wTimer=0xFFFF;

//BOOL  fPostMessages;          // when TRUE, mixer changes cause post message

//extern PVOID ChangedLine[];
//extern PVOID ChangedMixerPointer[];


#define DELTA(a,b)      ((a >= b) ? (a-b) : (b-a))

#define LVOL(dwX)       ( HIWORD(dwX) >>(16-5) )
#define RVOL(dwX)       ( LOWORD(dwX) >>(16-5) )


                                        //--------------------------- volStep -
WORD volStep (DWORD dw1 ,DWORD dw2)
{
   WORD wLeftDelta,wRightDelta;

   if (dw1==dw2)
      return (0);

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      {
      // 0..64 range
      // wLeftDelta=abs (( (HIWORD(dw1)>>8) - (HIWORD(dw2)>>8) )) >>2;
      // wRightDelta=abs (( (LOWORD(dw1)>>8) - (LOWORD(dw2)>>8) )) >>2;
      }
   else
      {
      // 0..32 range
      // wLeftDelta=abs (( (HIWORD(dw1)>>8) - (HIWORD(dw2)>>8) )) >>3;
      // wRightDelta=abs (( (LOWORD(dw1)>>8) - (LOWORD(dw2)>>8) )) >>3;
      }

   if (wRightDelta>wLeftDelta)             // return biggest delta
      wLeftDelta=wRightDelta;

   return(wLeftDelta);
}

/*                                      ---------------------- FadeMixerState -
** This does a smooth, optionally timed, fade between the mixer
**      hardware's current state and the desired state.
**
** dwTime is  XXXXYYYY  where XXXX is delay in tenths of a seconds
**                      and   YYYY is fade duration in tenths of a second
*/
WORD FadeMixerState (LPMIXERSTATE lpMixer, DWORD dwTime, DWORD dwCallback)
{
   USHORT i;
   WORD   wMaxDelta=0;
   WORD   temp;

   CopyMixerState (lpFadeFromMixer,lpCurrentMixer);
   CopyMixerState (lpFadeToMixer,lpMixer);

   /*
   ** DETERMINE MAX DELTA STEPS
   */
   for (i=0; i<bNumInputs; i++)
      {
      temp=volStep(lpFadeToMixer->LineInStatus[i].dwVolume,lpCurrentMixer->LineInStatus[i].dwVolume);
      if (temp > wMaxDelta)
         wMaxDelta=temp;
      if (!wMaxDelta)
         if (lpFadeToMixer->LineInStatus[i].dwConnections !=
             lpCurrentMixer->LineInStatus[i].dwConnections)
            wMaxDelta++;

       if (!wMaxDelta)
          if (lpFadeToMixer->LineInStatus[i].wPatchNumber !=
              lpCurrentMixer->LineInStatus[i].wPatchNumber)
             wMaxDelta++;
      } // end for

   temp = volStep (lpFadeToMixer->LineOutStatus[0].dwVolume,
                   lpCurrentMixer->LineOutStatus[0].dwVolume);
   if (temp > wMaxDelta)
      wMaxDelta=temp;

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      {
      temp = volStep (lpFadeToMixer->LineOutStatus[1].dwVolume,
                      lpCurrentMixer->LineOutStatus[1].dwVolume);
      if (temp > wMaxDelta)
         wMaxDelta=temp;
      }

   if (!wMaxDelta)
      if (lpFadeToMixer->LineOutStatus[0].dwStereoEnhance !=
          lpCurrentMixer->LineOutStatus[0].dwStereoEnhance)
         wMaxDelta++;

   // temp=abs(BMTBASS(lpFadeToMixer->LineOutStatus[0].dwBMT)-BMTBASS(lpCurrentMixer->LineOutStatus[0].dwBMT) );
   // link err
   if (temp > wMaxDelta)
      wMaxDelta=temp;

   //    temp=abs(BMTTREB(lpFadeToMixer->LineOutStatus[0].dwBMT)-BMTTREB(lpCurrentMixer->LineOutStatus[0].dwBMT) );
   // link err
   if (temp > wMaxDelta)
      wMaxDelta=temp;

   if (wMaxDelta==0)
      return(MIXERR_NOERR);                   // nothing to change!

   if (dwTime==0)
      {
      wMaxDelta=0;
      dwMixDelayTime=0;
      dwMixFadeTime=0;
      dwMixFirstDelay=0;
      dwMixFadeDelay=0;
      dwMixFadeDelaySeed=0;
      dwMixFadeTotalElapsed=9000;    // pretend mucho time has elapsed
      dwMixFadeElapsed=9000;         // pretend mucho time has elapsed
      TimedFadeInterrupt();
      return(MIXERR_NOERR);
      }

   dwMixDelayTime = HIWORD (dwTime); // user requested delay in secs/10
   dwMixFadeTime  = LOWORD (dwTime); // user requested fade time in secs/10

   dwMixFirstDelay = dwMixDelayTime; // delay before first change
   if (wMaxDelta==1)
      {
      dwMixFirstDelay+=dwMixFadeTime; // if only one step, it occurs at end.
      dwMixFadeDelaySeed=0;
      }
   else
      {
      dwMixFadeDelaySeed=dwMixFadeTime;
      //dwMixFadeDelaySeed=dwMixFadeTime/wMaxDelta; // delay between changes
      //link errors
      }

   dwMixFadeDelay=dwMixFadeDelaySeed;

   StartInterrupt();
}

                                        //-------------------- StartInterrupt -
void StartInterrupt (void)
{
   //TIMECAPS tc;
   char far *lp1;
   char far *lp2;
   int i;

   i=sizeof(MIXERSTATE);

   lp1=(char far *) lpFadeMixer;
   lp2=(char far *) lpCurrentMixer;
   while (i)
      {
      *lp1++=*lp2++;
      i--;
      }

   //timeGetDevCaps(&tc, sizeof(TIMECAPS));

   //timeBeginPeriod(50);               // 50ms
   //wTimer=timeSetEvent(100,10,Tick,NULL,TIME_PERIODIC);
   dwMixFadeTotalElapsed=0;             // reset elapsed time
   dwMixFadeElapsed=0;                  // reset elapsed time
   fMixFadeActive=TRUE;
}

                                        //--------------------- StopInterrupt -
void StopInterrupt ()
{
   //timeEndPeriod(50);                 // 50ms
   dwMixFadeTotalElapsed=9000;
   dwMixFadeElapsed=9000;
   fMixFadeActive=FALSE;
}

                                        //------------------------------ Tick -
void Tick (HANDLE h, WORD msg, DWORD dwUser, DWORD dw1, DWORD dw2)
{
   if (fMixFadeActive)
      {
      dwMixFadeElapsed++;
      dwMixFadeTotalElapsed++;
      if (dwMixFirstDelay)
         {
         dwMixFirstDelay--;
         if (dwMixFirstDelay==0)
            dwMixFadeElapsed=0; // reset elapsed time when delay is done
         return;
         }
      if (dwMixFadeDelay)
         {
         dwMixFadeDelay--;
         return;
         }
      TimedFadeInterrupt();
      } // end if

   else                                                                            // shut down timer!
      {
      if (wTimer!=0xFFFF)
         {
         //timeKillEvent(wTimer);
         wTimer=0xFFFF;
         }
      }
   return;
}

                                        //---------------- TimedFadeInterrupt -
void TimedFadeInterrupt (void)
{
   USHORT   i;
   WORD     wSteps;
   DWORD    dwDiff,dwTemp;
   // DWORD dwPercentDone;
   DWORD    lVol,rVol;
   long     lDiff,rDiff;
   DWORD    dwFadeToVol,dwFromVol;

   if (dwMixFadeElapsed >= dwMixFadeTime)       // waited too long?
      goto FinalUpdate;

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      wSteps=6;
   else
      wSteps=5;

   dwDiff=dwMixFadeTime-dwMixFadeElapsed;
   if (dwDiff> dwMixFadeDelaySeed)
      dwMixFadeDelay=dwMixFadeDelaySeed;        // Delay 'til next step
   else
      dwMixFadeDelay=dwDiff;                    // Last Delay is shorter

   // get rough percentage of time elapsed

   // dwPercentDone=(dwMixFadeElapsed<<wSteps)/(dwMixFadeTime);
   // link errors

   for (i=0; i<bNumInputs; i++)
      {
      dwFromVol   = lpFadeFromMixer->LineInStatus[i].dwVolume;
      dwFadeToVol = lpFadeToMixer  ->LineInStatus[i].dwVolume;
      if (dwFadeToVol==dwFromVol)
         continue;

      lDiff= ((long)HIWORD(dwFadeToVol))-((long)HIWORD(dwFromVol));
      rDiff= ((long)LOWORD(dwFadeToVol))-((long)LOWORD(dwFromVol));

      lVol=HIWORD(dwFromVol);
      rVol=LOWORD(dwFromVol);
      // lVol+= (lDiff*dwPercentDone)>>wSteps;
      // rVol+= (rDiff*dwPercentDone)>>wSteps;
      // link errors

      lpFadeMixer->LineInStatus[i].dwVolume=(lVol<<16)+LOWORD(rVol);
      updateInput(lpFadeMixer,i);
      } // end for

   for (i=0; i<bNumOutputs; i++)
      {
      dwFromVol   = lpFadeFromMixer->LineOutStatus[i].dwVolume;
      dwFadeToVol = lpFadeToMixer  ->LineOutStatus[i].dwVolume;
      if (dwFadeToVol==dwFromVol)
         continue;

      lDiff= ((long)HIWORD(dwFadeToVol))-((long)HIWORD(dwFromVol));
      rDiff= ((long)LOWORD(dwFadeToVol))-((long)LOWORD(dwFromVol));

      lVol=HIWORD(dwFromVol);
      rVol=LOWORD(dwFromVol);
      // lVol+= (lDiff*dwPercentDone)>>wSteps;
      // rVol+= (rDiff*dwPercentDone)>>wSteps;
      // link errors

      lpFadeMixer->LineOutStatus[i].dwVolume=(lVol<<16)+LOWORD(rVol);
      updateOutput(lpFadeMixer,i);
      } // end for


   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      {
      dwFromVol   =
         lpFadeFromMixer->LineOutStatus[OUT_AMPLIFIER].dwStereoEnhance;
      dwFadeToVol =
         lpFadeToMixer  ->LineOutStatus[OUT_AMPLIFIER].dwStereoEnhance;
      if (dwFadeToVol!=dwFromVol)
         {
         lDiff= ((long)HIWORD(dwFadeToVol))-((long)HIWORD(dwFromVol));

         lVol=HIWORD(dwFromVol);
         // lVol+= (lDiff*dwPercentDone)>>wSteps;
         // link errors

         lpFadeMixer->LineOutStatus[OUT_AMPLIFIER].
                         dwVolume=(lVol<<16)+LOWORD(lVol);
         updateOutput(lpFadeMixer,OUT_AMPLIFIER);
         }
      } // end if

   dwDiff = BMTBASS (lpFadeToMixer->LineOutStatus[0].dwBMT) -
            BMTBASS (lpFadeMixer->LineOutStatus[0].dwBMT);
   dwTemp = BMTTREB (lpFadeToMixer->LineOutStatus[0].dwBMT) -
            BMTTREB (lpFadeMixer->LineOutStatus[0].dwBMT);

   if (dwDiff)
      {
      // dwDiff= (dwDiff>>wSteps)*dwPercentDone;
      // dwTemp= (dwDiff>>wSteps)*dwPercentDone;
      // link errors

      lpFadeMixer->LineOutStatus[0].dwBMT+=dwDiff;
      updateOutput(lpFadeMixer,0);
      }

   // All non-scalar controls and patches are done at end of fade!
   return;

   /*
   ** Yea haa! A label
   */
   FinalUpdate:

   for (i=0; i < bNumInputs; i++)
      {
      updateInput(lpFadeToMixer,i);
      patchInput(lpFadeToMixer,i,NULL);
      }

   for (i=0; i < bNumOutputs; i++)
      {
      updateOutput(lpFadeToMixer,i);
      patchOutput(lpFadeToMixer,i,NULL);
      }

   fMixFadeActive=FALSE;

   dwMixFadeDelaySeed=dwMixFadeDelay=dwMixFadeTime=0;

   return;
}

/*                                      -------------------------- patchInput -
**
** wLine must always be valid
**
** 1st choice: use lpProposedMixer info if it is not NULL
** 2nd choice: use lpPatch (user defined) and set patch number to -1;
** 3rd choice: use a pre-defined patch as specified by the low word of
**             lpPatch.  If LOWORD(lpPatch) is too big, the default patch
**             is used (ie. line number plus 1).
*/
WORD patchInput (LPMIXERSTATE lpProposedMixer, WORD wLine, LPPATCHINFO lpPatch)
{

   wLine=LOBYTE(wLine);

   if (lpProposedMixer) // an entire mixer patch is being copied
      {
      // if ((lpPatch->dwDeviceType & MIX_HARD_WIRED)
      // && !(lpPatch->dwLineNumbers & (1<<wLine)))
      //    return(MIXERR_PATCHMISMATCH);

      lpCurrentMixer->LineInStatus[wLine].wPatchNumber =
         lpProposedMixer->LineInStatus[wLine].wPatchNumber;
      lpCurrentMixer->LineInStatus[wLine].dwDeviceType=
         lpProposedMixer->LineInStatus[wLine].dwDeviceType;
      lpCurrentMixer->LineInStatus[wLine].dwAssociation=
         lpProposedMixer->LineInStatus[wLine].dwAssociation;
      lpCurrentMixer->LineInStatus[wLine].dwConnectionsPossible=
         lpProposedMixer->LineInStatus[wLine].dwConnectionsPossible;
      lstrcpy ((LPSTR)lpCurrentMixer->LineInStatus[wLine].szPname,
               (LPSTR)lpProposedMixer->LineInStatus[wLine].szPname);
      return TRUE;
      }

   if (HIWORD((DWORD)lpPatch)==0)
      {
      if (LOWORD((DWORD)lpPatch) >= NUM_IN_PATCHES)
         lpPatch=(LPPATCHINFO) ((DWORD) (LOBYTE(wLine)+1));
      lpPatch=&INpatch[LOWORD((DWORD)lpPatch)];
      lpCurrentMixer->LineInStatus[wLine].wPatchNumber=lpPatch->wPatchNumber;
      }
   else
      lpCurrentMixer->LineInStatus[wLine].wPatchNumber = -1;

   lpCurrentMixer->LineInStatus[wLine].dwDeviceType=lpPatch->dwDeviceType;
   lpCurrentMixer->LineInStatus[wLine].dwAssociation=lpPatch->dwAssociation;
   lstrcpy ((LPSTR)lpCurrentMixer->LineInStatus[wLine].szPname,
            (LPSTR)lpPatch->szPname);  // patch name

   return TRUE;
}

                                        //----------------------- patchOutput -
WORD patchOutput (LPMIXERSTATE lpProposedMixer,
                  WORD         wLine,
                  LPPATCHINFO  lpPatch)
{
   wLine=LOBYTE(wLine);         // in case it has INPUT/OUTPUT in hibyte

   if (lpProposedMixer)         // an entire mixer patch is being copied
      {
      // if ((lpPatch->dwDeviceType & MIX_HARD_WIRED)
      //     && (!(lpPatch->dwLineNumbers & 1<<wLine)))
      //    return(MIXERR_PATCHMISMATCH);

      if (lpProposedMixer->LineOutStatus[wLine].wNumSoftPatches==0)
         return (MIXERR_INVALINPUT);

      lpCurrentMixer->LineOutStatus[wLine].wPatchNumber=
         lpProposedMixer->LineOutStatus[wLine].wPatchNumber;
      lpCurrentMixer->LineOutStatus[wLine].dwDeviceType=
         lpProposedMixer->LineOutStatus[wLine].dwDeviceType;
      lpCurrentMixer->LineOutStatus[wLine].dwAssociation=
         lpProposedMixer->LineOutStatus[wLine].dwAssociation;
      lpCurrentMixer->LineOutStatus[wLine].dwConnectionsPossible=
         lpProposedMixer->LineOutStatus[wLine].dwConnectionsPossible;
      lstrcpy((LPSTR)lpCurrentMixer->LineOutStatus[wLine].szPname,
         (LPSTR)lpProposedMixer->LineOutStatus[wLine].szPname);
      return TRUE;
      } // end if

   if (HIWORD((DWORD)lpPatch)==0)
      {
      if (LOWORD((DWORD)lpPatch) >= NUM_OUT_PATCHES)
         lpPatch=(LPPATCHINFO) ((DWORD) (LOBYTE(wLine)+1));
      lpPatch=(LPPATCHINFO) &OUTpatch[LOWORD((DWORD)lpPatch)];
      lpCurrentMixer->LineOutStatus[wLine].wPatchNumber=lpPatch->wPatchNumber;
      }
   else
      lpCurrentMixer->LineOutStatus[wLine].wPatchNumber=-1;

   lpCurrentMixer->LineOutStatus[wLine].dwDeviceType=lpPatch->dwDeviceType;
   lpCurrentMixer->LineOutStatus[wLine].dwAssociation=lpPatch->dwAssociation;
   lstrcpy ((LPSTR)lpCurrentMixer->LineOutStatus[wLine].szPname,
            (LPSTR)lpPatch->szPname);
}

/*                                      ------------------------- updateInput -
** updateInput
** attempts to update the line of the current mixer and the hardware
** associated to the Proposed state specified by the lpProposedMixer parm.
** Operational procedure:
**    1) updates connection information
**    2) updates control information
**
** WARNING: called at interrupt time, make no         calls!
**
** returns MMSYS error codes.
*/
WORD updateInput (LPMIXERSTATE lpProposedMixer, WORD wLine)
{
   BOOL fNuked;
   WORD retval;
   WORD wXover,wOutput;

   retval=MIXERR_NOERR;

   // VOLUME
   dwCurrentValue=lpCurrentMixer->LineInStatus[wLine].dwVolume;
   dwProposedValue=lpProposedMixer->LineInStatus[wLine].dwVolume;

   dwCurrentConnections  =
      lpCurrentMixer->LineInStatus[wLine].dwConnections & 3;
   dwProposedConnections =
      lpProposedMixer->LineInStatus[wLine].dwConnections & 3;

   if (!bForceInit)
      {
      if ((dwCurrentValue==dwProposedValue) &&
          (dwCurrentConnections==dwProposedConnections))
         return (retval);
      }

   // switch connections using current volume levels to avoid
   // any popping.

   if ((dwCurrentConnections != dwProposedConnections) || (bForceInit))
      {
      wXover=LOWORD(lpCurrentMixer->LineInStatus[wLine].dwCrossover);
      if ( dwProposedConnections & (1<<OUT_AMPLIFIER) )
         wOutput=OUT_AMPLIFIER;
      else
         wOutput=OUT_PCM;

      // CDPC - force MIC to RECORD.
      if (pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC &&
         (wLine == IN_MICROPHONE))
         {
         wOutput = OUT_PCM;
         dwCurrentValue = 0L;
         #ifdef MIX_MONITOR
         StringOut("MIXSUBS: Microphone value nuked.");
         #endif
         }

      SetInput (wLine, LVOL(dwCurrentValue), _LEFT,  wXover, wOutput);
      SetInput (wLine, RVOL(dwCurrentValue), _RIGHT, wXover, wOutput);

      if (wOutput==OUT_AMPLIFIER)
         {
         //if (wLine == IN_MICROPHONE)
         //      DOUTX("\r\nMVMIXER: Setting AMP routing");
         lpCurrentMixer->LineInStatus[wLine].dwConnections |=  1<<OUT_AMPLIFIER;
         lpCurrentMixer->LineInStatus[wLine].dwConnections &=~(1<<OUT_PCM);
         lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwConnections |=
            (1<<wLine);
         lpCurrentMixer->LineOutStatus[OUT_PCM      ].dwConnections &=
            ~(1<<wLine);
         }

      else // OUT_PCM
         {
         //if (wLine == IN_MICROPHONE)
         //      DOUTX("\r\nMVMIXER: Setting PCM  routing");
         lpCurrentMixer->LineInStatus[wLine].dwConnections |= 1<<OUT_PCM;

         lpCurrentMixer->LineInStatus[wLine].dwConnections &=
            ~(1<<OUT_AMPLIFIER);

         lpCurrentMixer->LineOutStatus[OUT_PCM      ].dwConnections |=
            (1<<wLine);

         lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwConnections &=
            ~(1<<wLine);
         } // end else

      dwCurrentConnections=lpCurrentMixer->LineInStatus[wLine].dwConnections;
      if (fMixerInitializing==FALSE)
         {
         // if (fPostMessages)
         //    PostMessage(0xFFFF, wmConnectionChanged,(MIX_INPUT<<8)+wLine,(DWORD)
         //                lpProposedMixer);
         }
      } // end if

      // change volumes to Proposed volumes incrementally.

      if ((dwCurrentValue != dwProposedValue) || (bForceInit))
         {
         fNuked = FALSE;

         if (pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC)
            {
            /* Don't let MIC volume go non-zero if MIXER volume is non-zero. */
            if (wLine == IN_MICROPHONE)
               {
               if (lpCurrentMixer->LineInStatus [IN_MIXER].dwVolume)
                  {
                  if (lpCurrentMixer->LineInStatus [IN_MICROPHONE].dwVolume ||
                      bForceInit)
                     {
                     #ifdef MIX_MONITOR
                     StringOut ("MIXSUBS: Forcing MIC to zero.");
                     #endif
                     dwProposedValue = 0L;
                     fNuked = TRUE;
                     }
                  else
                     {
                     #ifdef MIX_MONITOR
                     StringOut ("MIXSUBS: Whew! returning safely.");
                     #endif
                     return retval;
                     }
                  }
               }

            /* Nuke MIC volume on MIXER volume increase. */
            if ( (wLine == IN_MIXER) && dwProposedValue)
               if (lpCurrentMixer->LineInStatus [IN_MICROPHONE].dwVolume)
                  {
                  fNuked = TRUE;
                  }

            if (fNuked)
               {
               #ifdef MIX_MONITOR
               StringOut ("\r\n!!! OH MY GOD THE WORLD IS ENDING !!!");
               #endif
               lpCurrentMixer->LineInStatus [IN_MICROPHONE].dwVolume = 0L;
               wXover = LOWORD
                  (lpCurrentMixer->LineInStatus [IN_MICROPHONE].dwCrossover);
               SetInput (IN_MICROPHONE, 0, _LEFT, wXover, OUT_PCM);
               SetInput (IN_MICROPHONE, 0, _RIGHT, wXover, OUT_PCM);
               #ifdef MIX_MONITOR
               StringOut ("\r\n!!! THE EARTH JUST EXPLODED !!!");
               #endif
               }
            }

         wXover=LOWORD(lpCurrentMixer->LineInStatus[wLine].dwCrossover);

         wCurrentLeft   = LVOL(dwCurrentValue); // convert to 6 bits (64 steps)
         wCurrentRight  = RVOL(dwCurrentValue);

         wProposedLeft  = LVOL(dwProposedValue);
         wProposedRight = RVOL(dwProposedValue);

         if (dwCurrentConnections & (1<<OUT_AMPLIFIER))
            wOutput=OUT_AMPLIFIER;
         else
            wOutput=OUT_PCM;

         if (pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC &&
             (wLine == IN_MICROPHONE))
            {
            #ifdef MIX_MONITOR
            PrintfOut ("\r\nMIXSUBS: MIC-Current  L,R = %d,%d",
                       wCurrentLeft, wCurrentRight);
            PrintfOut ("\r\nMIXSUBS: MIC-Proposed L,R = %d,%d",
                       wProposedLeft, wProposedRight);
            #endif
            wOutput = OUT_PCM;
            }

         if (bForceInit)
            {
            wCurrentLeft = wProposedLeft;
            wCurrentRight = wProposedRight;
            }

         do {
            if (wCurrentLeft > wProposedLeft)
               wCurrentLeft--;
            else if (wCurrentLeft < wProposedLeft)
               wCurrentLeft++;
            SetInput (wLine, wCurrentLeft, _LEFT, wXover, wOutput);
            } while (wCurrentLeft != wProposedLeft);

         do {
            if (wCurrentRight > wProposedRight)
               wCurrentRight--;
            else if (wCurrentRight < wProposedRight)
               wCurrentRight++;
            SetInput (wLine, wCurrentRight, _RIGHT, wXover, wOutput);
            } while (wCurrentRight != wProposedRight);

         lpCurrentMixer->LineInStatus[wLine].dwVolume = dwProposedValue;
         //if (fMixerInitializing==FALSE)
         //   if (fPostMessages)
         //      {
         //      if (fNuked)
         //      PostMessage(0xFFFF, wmControlChanged,(MIX_INPUT<<8)+IN_MICROPHONE, (DWORD)lpProposedMixer);
         //      PostMessage(0xFFFF, wmControlChanged,(MIX_INPUT<<8)+wLine, (DWORD)lpProposedMixer);
         //      }
         } // end if


      #ifdef DEBUG
      //if (wLine == IN_MICROPHONE)
      //      DOUTX ("\r\nMVMIXER: Done.");
      #endif
      return (retval);
}

WORD updateOutput (LPMIXERSTATE lpProposedMixer, WORD wLine)
{
   USHORT i;
   WORD   retval, wXover;
   DWORD  loud, enh;

   retval = MIXERR_NOERR;

   // VOLUME
   dwCurrentConnections=lpCurrentMixer->LineOutStatus[wLine].dwConnections & 0x7f;
   dwProposedConnections=lpProposedMixer->LineOutStatus[wLine].dwConnections & 0x7f;

   // wMixLine is the physical hardware line (used by the SetPlaybackMixer
   // function) as distinguished from the logical mixer input.


   // switch connections using current volume levels to avoid
   // any popping.

   if ((dwCurrentConnections != dwProposedConnections) ||
       (bForceInit))
      {
      #ifdef MIX_MONITOR
      if (wLine==OUT_AMPLIFIER )
         StringOut(" UPDATING AMPLIFIER CONNECTIONS");
      else
         StringOut(" UPDATING PCM CONNECTIONS");

      PrintfOut("nCurrent : %0lx", dwCurrentConnections);
      PrintfOut("nProposed: %0lx", dwProposedConnections);
      #endif

      for (i=0; i< bNumInputs; i++)
         {
         if (!bForceInit)
            if ((dwProposedConnections & 1<<i)==(dwCurrentConnections & 1<<i))
               continue;

         dwCurrentValue=lpCurrentMixer->LineInStatus[i].dwVolume;

         wXover=LOWORD(lpCurrentMixer->LineInStatus[i].dwCrossover);
         if (wLine==OUT_AMPLIFIER )
            {
            if ((dwProposedConnections & (1<<i))==0)  // not connected so...
               goto setPCM;

            setAMP:
            #ifdef MIX_MONITOR
            StringOut(" ... patched to AMP");
            #endif
            SetInput(i,LVOL(dwCurrentValue),_LEFT ,wXover,OUT_AMPLIFIER);
            SetInput(i,RVOL(dwCurrentValue),_RIGHT,wXover,OUT_AMPLIFIER);

            lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwConnections |=
               (1<<i);
            lpCurrentMixer->LineOutStatus[OUT_PCM      ].dwConnections &=
               ~(1<<i);
            lpCurrentMixer->LineInStatus[i].dwConnections |=
               (1<<OUT_AMPLIFIER);
            lpCurrentMixer->LineInStatus[i].dwConnections &=
               ~(1<<OUT_PCM      );
            }

         else  // OUT_PCM
            {
            if ((dwProposedConnections & (1<<i))==0)  // not connected so...
               goto setAMP;

            setPCM:
            #ifdef MIX_MONITOR
            StringOut("\r\nMVMIXER: ... patched to PCM");
            #endif
            SetInput(i,LVOL(dwCurrentValue),_LEFT ,wXover,OUT_PCM);
            SetInput(i,RVOL(dwCurrentValue),_RIGHT,wXover,OUT_PCM);
            lpCurrentMixer->LineOutStatus[OUT_PCM      ].dwConnections |=
               (1<<i);
            lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwConnections &=
               ~(1<<i);
            lpCurrentMixer->LineInStatus[i].dwConnections |=
               (1<<OUT_PCM      );
            lpCurrentMixer->LineInStatus[i].dwConnections &=
               ~(1<<OUT_AMPLIFIER);
            } // end else

         //if (fMixerInitializing==FALSE)
         //      if (fPostMessages)
         //              PostMessage(0xFFFF, wmConnectionChanged,(MIX_INPUT<<8)+i,(DWORD) lpProposedMixer);

         } // end for

      dwCurrentConnections=dwProposedConnections;
      } // end if

   // change volumes to Proposed volumes incrementally.

   dwCurrentValue  = lpCurrentMixer ->LineOutStatus[wLine].dwVolume;
   dwProposedValue = lpProposedMixer->LineOutStatus[wLine].dwVolume;

   wCurrentLeft   = HIWORD(dwCurrentValue ) >>10;  // scale 2**16 to
   wCurrentRight  = LOWORD(dwCurrentValue ) >>10;  // 2**6 (0-3f)
   wProposedLeft  = HIWORD(dwProposedValue) >>10;
   wProposedRight = LOWORD(dwProposedValue) >>10;

   // FIRST UPDATE MASTER VOLUMES

   if ((dwCurrentValue != dwProposedValue) || bForceInit)
      {
      if (bForceInit)
         {
         wCurrentLeft=wProposedLeft-1;
         wCurrentRight=wProposedRight-1;
         }

      while (wCurrentLeft != wProposedLeft)
         {
         if (wCurrentLeft > wProposedLeft)
            wCurrentLeft--;
         else
            wCurrentLeft++;
         if (bForceInit)
            wCurrentLeft=wProposedLeft;
         SetOutput(wLine,wCurrentLeft,_LEFT);
         }

      while (wCurrentRight != wProposedRight)
         {
         if (wCurrentRight > wProposedRight)
            wCurrentRight--;
         else
            wCurrentRight++;

         if (bForceInit)
            wCurrentRight=wProposedRight;
         SetOutput(wLine,wCurrentRight,_RIGHT);
         } // end while

      lpCurrentMixer->LineOutStatus[wLine].dwVolume =
         lpProposedMixer->LineOutStatus[wLine].dwVolume;

      //if (fMixerInitializing==FALSE)
      //   if (fPostMessages)
      //      PostMessage (0xFFFF, wmControlChanged,
      //                  (MIX_OUTPUT<<8)+wLine,(DWORD) lpProposedMixer);

      } // end if


   if (wLine==OUT_AMPLIFIER)
      {
      // NEXT UPDATE BMT BASS, MIDRANGE AND TREBLE

      dwCurrentValue=lpCurrentMixer->LineOutStatus[wLine].dwBMT;
      dwProposedValue=lpProposedMixer->LineOutStatus[wLine].dwBMT;

      if ((dwCurrentValue != dwProposedValue) || bForceInit)
         {
         wCurrentBass=   BMTBASS(dwCurrentValue )>>3;    // scale 2**8 to 2**5
         wCurrentTreble= BMTTREB(dwCurrentValue )>>3;
         wProposedBass=  BMTBASS(dwProposedValue)>>3;
         wProposedTreble=BMTTREB(dwProposedValue)>>3;

         if (bForceInit)
            {
            SetEQ(OUT_AMPLIFIER,_BASS  ,wProposedBass);
            SetEQ(OUT_AMPLIFIER,_TREBLE,wProposedTreble);
            }
         else
            {
            while (wCurrentBass != wProposedBass)
               {
               if (wCurrentBass > wProposedBass)
                  wCurrentBass--;
               else
                  wCurrentBass++;

               SetEQ(OUT_AMPLIFIER,_BASS,wCurrentBass);
               } // end while

            while (wCurrentTreble != wProposedTreble)
               {
               if (wCurrentTreble > wProposedTreble)
                  wCurrentTreble--;
               else
                  wCurrentTreble++;

               SetEQ(OUT_AMPLIFIER,_TREBLE,wCurrentTreble);
               } // end while
            } // end else

         lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwBMT=
            lpProposedMixer->LineOutStatus[OUT_AMPLIFIER].dwBMT;
         //if (fMixerInitializing==FALSE)
         //   if (fPostMessages)
         //      PostMessage(0xFFFF, wmControlChanged,(MIX_OUTPUT<<8)+wLine,
         //                 (DWORD) lpProposedMixer);

         } // end if

      // NEXT UPDATE LOUDNESS and STEREOENHANCE

      if ((lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwStereoEnhance !=
          lpProposedMixer->LineOutStatus[OUT_AMPLIFIER].dwStereoEnhance) ||
          (lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwLoudness !=
          lpProposedMixer->LineOutStatus[OUT_AMPLIFIER].dwLoudness) ||
          (bForceInit))
         {
         // yes, this is an assingnment:
         loud = lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwLoudness =
            lpProposedMixer->LineOutStatus[OUT_AMPLIFIER].dwLoudness;

         // likewise:
         lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwStereoEnhance =
            lpProposedMixer->LineOutStatus[OUT_AMPLIFIER].dwStereoEnhance;

         // LOWORD is value for right, but we're mono so we don't care.

         enh = LOWORD (lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].
                          dwStereoEnhance);

         // 0x0000-> 0x3FFF  == OFF
         // 0x4000-> 0x7FFF  == OFF
         // 0x8000-> 0xBFFF  == OFF
         // 0xC000-> 0xFFFF  == OFF

         SetEqMode((loud!=0),HIBYTE(enh)>>(8-2));     // send topmost two bits

         //if (fMixerInitializing==FALSE)
         //   if (fPostMessages)
         //      PostMessage (0xFFFF, wmControlChanged,(MIX_OUTPUT<<8)+wLine,
         //                  (DWORD) lpProposedMixer);

         } // end then
      } // end if (wLine==OUT_AMPLIFIER)

   else  // PCM OUTPUT
      {
      if ((dwCurrentValue != dwProposedValue) || bForceInit)
         {
         if (bForceInit)
            {
            wCurrentLeft=wProposedLeft-1;
            wCurrentRight=wProposedRight-1;
            }
         while (wCurrentLeft != wProposedLeft)
            {
            if (wCurrentLeft > wProposedLeft)
               wCurrentLeft--;
            else
               wCurrentLeft++;
            if (bForceInit)
               wCurrentLeft=wProposedLeft;
            //SetVolume(4,wCurrentLeft);
            SetOutput(OUT_AMPLIFIER,wCurrentRight,_LEFT);
            } // end while

         while (wCurrentRight != wProposedRight)
            {
            if (wCurrentRight > wProposedRight)
               wCurrentRight--;
            else
               wCurrentRight++;

            if (bForceInit)
               wCurrentRight=wProposedRight;
            //SetVolume(5,wCurrentRight);
            SetOutput(OUT_AMPLIFIER,wCurrentRight,_RIGHT);
            } // end while

         lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwVolume =
            lpProposedMixer->LineOutStatus[OUT_AMPLIFIER].dwVolume;

         // if (fMixerInitializing==FALSE)
         //    if (fPostMessages)
         //       PostMessage (0xFFFF, wmControlChanged,(MIX_OUTPUT<<8)+wLine,
         //                   (DWORD) lpProposedMixer);

         } // end if
      } // end else

   return (retval);
}


/*                                      ---------------------- CopyMixerState -
** This procedure copies one mixer state to another
*/
void CopyMixerState (LPMIXERSTATE lpDestinationMixer,
                     LPMIXERSTATE lpSourceMixer)
{
   char far *lpD;
   char far *lpS;

   int i=sizeof(MIXERSTATE);

   if (!lpSourceMixer)
      return;
   if (!lpDestinationMixer)
      return;

   lpD = (char far *)lpDestinationMixer;
   lpS = (char far *)lpSourceMixer;

   while (i--)
      *lpD++=*lpS++;
}

//#if 0
//PostMessage(WORD wDummy1, WORD wDummy2, WORD wParam1,PVOID lpMixer)
//{
//   ChangedLine[0];
//   ChangedMixer[0];
//}
//#endif
