/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* mixinitc.c - PAS-16 Mixer control
*
******************************************************************************/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>

#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "cdevhlp.h"
#include "pasdef.h"
#include "findpas.h"
#include "proto.h"
#include "patch.h"
#include "globals.h"
#include "mvmixer.h"
#include "mvsystem.h"
#include "debug.h"
#include "commdbg.h"


#define  MIXVER                 2
#define  NUM_MIXER_DEVICES      1
#define  PLAYBACK_MIXER_DEVICE  0
#define  whitespace(c)          ((c==' ') || (c==9))

extern BOOL fPostMessages;   // when TRUE, mixer changes cause post message
extern BYTE audiofilt;

void NEAR InitSilentMixer(void);

                                        //------------------------- InitMixer -
void InitMixer(void)
{
   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      {
      Init508();
      bNumInputs=8;
      }
   else
      bNumInputs=7;

   bNumOutputs=2;

   numLines[0]=bNumInputs;
   numLines[1]=bNumOutputs;

   DoReset();
}

                                        //--------------------------- lstrlen -
int lstrlen (LPSTR lpStr)
{
   int cnt = 0;


   while( *lpStr++)
   {
      ++cnt;
   }

   return( cnt);
}

                                        //--------------------------- lstrcpy -
BOOL lstrcat (LPSTR lpDest, LPSTR lpSrc)
{
   while( *lpDest++);

   lstrcpy( lpDest, lpSrc);

   return(TRUE);
}

                                        //--------------------------- lstrcpy -
BOOL lstrcpy (LPSTR lpDest,LPSTR lpSrc)
{
   char far *lp1=(char far *)lpDest;
   char far *lp2=(char far *)lpSrc;

   while (*lp1++=*lp2++)
     ; // Null statement
   return(TRUE);
}

                                        //--------------------------- lstrcmp -
USHORT lstrcmp (LPSTR lpDest,LPSTR lpSrc)
{
   char far *lp1=(char far *)lpDest;
   char far *lp2=(char far *)lpSrc;
   do
      {
      if (*lp1++!=*lp2++)
         return(1);
      }
   while (*lp2);

   return(0);
}


    /*\
    |*|----====< int NEAR DoReset(void ) >====----
    |*|
    |*|  Do Reset
    |*|
    |*|  Returns 0 if all ok, otherwise error code.
    |*|
    \*/

/*                                      ----------------------------- DoReset -
** Do Reset
** Returns 0 if all ok, otherwise error code.
*/
int DoReset (void)
{
   BOOL   fOk=FALSE;
   USHORT i;
   LPSTR  lpnm;
   DWORD  dwTime;

   if (!pf.wNumFound)
      return (-1);      // FAILURE: hardware not present

   dwAmpConnections=0;
   dwPCMConnections=0;
   lpwPatch=(LPWORD) &wPatch;
   lpdwVolume=(LPDWORD) &dwVolume;

   #ifdef MIX_MONITOR
   StringOut( "MIXINITC: Resetting Mixer...");
   #endif

   // get these pointers once, they're used in timed interrupt
   lpCurrentMixer  = (LPMIXERSTATE) &CurrentMixer;
   lpFadeFromMixer = (LPMIXERSTATE) &FadeFromMixer;
   lpFadeToMixer   = (LPMIXERSTATE) &FadeToMixer;
   lpFadeMixer     = (LPMIXERSTATE) &FadeMixer;
   lpTempMixer     = (LPMIXERSTATE) &TempMixer;
   lpResetMixer    = (LPMIXERSTATE) &ResetMixer;

   // Now, build the reset mixer state

   lpResetMixer->wSize=sizeof(MIXERSTATE);
   lpResetMixer->wVersion=MIXSTATEVER;
   lpResetMixer->wMid=MM_MEDIAVISION;   // manufacturer id

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC)
      lpResetMixer->wPid=MM_CDPC_MIXER;

   else if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      lpResetMixer->wPid=MM_PROAUD_16_MIXER;
   else if (pf.ProCard[gwBoardIndex].Caps.CapsBits.OPL_3)
      lpResetMixer->wPid=MM_PROAUD_PLUS_MIXER;
   else
      lpResetMixer->wPid=MM_PROAUD_MIXER;   // product id

   lpResetMixer->wMixerNumber=PLAYBACK_MIXER_DEVICE;
   lpResetMixer->wNumInputs=bNumInputs;
   lpResetMixer->wNumOutputs=bNumOutputs;

   #ifdef MIX_MONITOR
   StringOut( "MIXINITC: Init Silent Mixer...");
   #endif
   InitSilentMixer();   // Set the Mixer Patches for silence.
                        // Trying to avoid startup >POP<

   #ifdef MIX_MONITOR
   StringOut("MIXINITC: Silent Mixer Initialized");
   #endif

   /*       ---------- LINE IN -------------- */
   for (i=0; i<bNumInputs; i++)
      {
      //fOk=FALSE;
      //wsprintf( szProfile, "LineIn%d",i+1);
      //fOk=GetLineProfileString(szProfile,(LPSTR) buf, lpwPatch,
      //                         lpdwVolume,&dwDeviceType,&dwAssociation);
      //if (!fOk)

      if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
         dwVolume=0xFFFFFFFF;
      else
         dwVolume=0xBBBBBBBB;

      if ( (i == IN_MICROPHONE) && pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC)
         {
         dwVolume=0;
         #ifdef MIX_MONITOR
         StringOut( "MIXINITC: MICROPHONE MIXER ZEROED");
         #endif
         }

      if ( (i == IN_PCM) && pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC)
         {
         dwVolume=0x55555555;
         }

      lpResetMixer->LineInStatus[i].dwVolume=dwVolume;
      lpResetMixer->LineInStatus[i].dwConnectionsPossible=
         (1<<OUT_AMPLIFIER) | (1<<      OUT_PCM );
      } // end for

   #ifdef PROGRESS_MONITOR
   StringOut("\r\nMIXINITC: Line In settings OK");
   #endif


   lpResetMixer->LineInStatus[IN_MIXER].dwConnectionsPossible=1<<OUT_AMPLIFIER;

   /*
   ** ---------- LINE OUT --------------
   */
   //fOk=GetLineProfileString("LineOut1",buf, lpwPatch, lpdwVolume,
   //                         &dwDeviceType,&dwAssociation);
   if (!fOk)
      dwVolume=0x88888888;

   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwVolume=dwVolume;

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      {
      //fOk=GetLineProfileString("LineOut2",buf, lpwPatch,
      //                         lpdwVolume, &dwDeviceType,&dwAssociation);
      if (!fOk)
         dwVolume=0x88888888;
         lpResetMixer->LineOutStatus[OUT_PCM].dwVolume=dwVolume;
      }

   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwConnectionsPossible=
      (1 << IN_SYNTHESIZER) |
      (1 << IN_MIXER)       |
      (1 << IN_EXTERNAL)    |
      (1 << IN_INTERNAL)    |
      (1 << IN_MICROPHONE)  |
      (1 << IN_PCM)         |
      (1 << IN_PC_SPEAKER)  |
      (1 << IN_SNDBLASTER);

   lpResetMixer->LineOutStatus[OUT_PCM].dwConnectionsPossible=
      (1 << IN_SYNTHESIZER) |
      (1 << IN_EXTERNAL)    |
      (1 << IN_INTERNAL)    |
      (1 << IN_MICROPHONE)  |
      (1 << IN_PCM)         |
      (1 << IN_PC_SPEAKER)  |
      (1 << IN_SNDBLASTER);



   /*
   ** ------- STEREO ENHANCE -----------
   */
   lpnm=(LPSTR)"StereoEnhance";
   //k=GetProfileString(szDriverName, lpnm, "OFF", buf, LBUFFLEN);
   if (fOk && buf[1]!='F')         // if ON
      {
      dwVolume=0xFFFFFFFF;
      //#if 0
      //if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      //   {
      //   //dwVolume=GetProfileInt(szDriverName, szProfile, 50);
      //   dwVolume=(dwVolume* 255)/100;
      //   dwVolume=(dwVolume<<16) + dwVolume;
      //   }
      //#endif
      }
   else
      dwVolume=0;

   lpResetMixer->LineOutStatus[0].dwStereoEnhance=dwVolume;


   /*
   ** --------- LOUDNESS -----------
   */
   lpnm=(LPSTR)"Loudness";
   //fOk=GetProfileString(szDriverName, lpnm, "OFF", buf, LBUFFLEN);
   if (fOk && buf[1]=='N')
      dwVolume=0xFFFFFFFF;
   else
      dwVolume=0;

   lpResetMixer->LineOutStatus[0].dwLoudness=dwVolume;

   /*
   ** --------- BASS -----------
   */
   lpnm=(LPSTR)"Bass";
   //bass=GetProfileInt(szDriverName, lpnm, 50);
   //if (bass > 100)
   //   bass = 100;
   bass= (bass * 255)/100;

   /*
   ** --------- TREBLE -----------
   */
   lpnm=(LPSTR)"Treble";
   //treb=GetProfileInt(szDriverName, lpnm, 50);
   //if (treb > 100)
   //   treb = 100;

   treb= (treb * 255)/100;

   // dwVolume =bass * 0x01010000L;
   lpwVolume=(LPWORD)&dwVolume;
   lpwVolume++;
   *lpwVolume=bass;
   lpwVolume--;
   *lpwVolume=treb;

   dwVolume+=treb*0x101;
   lpResetMixer->LineOutStatus[0].dwBMT=dwVolume;


   /*
   ** Well, I've finally decided to figure out how to wake up the
   ** hardware without going <<<POP>>>  At this point, the mixer
   ** is awake and all of its volumes are 0.  Now, instead of
   ** making the hardware jump to a new state, use our fade routines
   ** to make a gentle transition to the startup values.
   */
   #ifdef PROGRESS_MONITOR
   StringOut("\r\nMIXINITC: Before bForceInit setting");
   #endif
   bForceInit=FALSE;

   #ifdef PROGRESS_MONITOR
   StringOut("\r\nMIXINITC: Before CopyMixerState");
   #endif

   CopyMixerState(lpTempMixer,lpResetMixer);

   #ifdef PROGRESS_MONITOR
   StringOut("\r\nMIXINITC: CopyMixerState OK");
   #endif

   // dwTime is  XXXXYYYY  where XXXX is delay in 10ths of a second
   //                      and   YYYY is fade duration in 10ths of a second
   dwTime=0<<16;           // delay
   dwTime+=0;              // duration

   #ifdef MIX_MONITOR
   StringOut("MIXINITC: About to FadeMixerState");
   #endif

   dwVolume= lpResetMixer->LineOutStatus[0].dwVolume;
   lpTempMixer->LineOutStatus[0].dwVolume=0;
   FadeMixerState(lpTempMixer,dwTime,(DWORD)NULL);

   for (i=16; i>=1; i--)
      {
      ///char sz [50];

      lpTempMixer->LineOutStatus[0].dwVolume=
         ((((DWORD)HIWORD(dwVolume))/i)<<16)+
         (((DWORD)LOWORD(dwVolume))/i);

      //wsprintf (sz, "\r\nVolume L,R = %u,%u", HIWORD(lpTempMixer->LineOutStatus[0].dwVolume), LOWORD(lpTempMixer->LineOutStatus[0].dwVolume));
      //DOUTX (sz);

      FadeMixerState(lpTempMixer,dwTime,(DWORD)NULL);
      } // end for


   #ifdef PROGRESS_MONITOR
   StringOut("\r\nMIXINITC: FadeMixerState OK");
   #endif

   //CopyMixerState(lpCurrentMixer,lpResetMixer);
   for (i=0; i<bNumOutputs; i++)
      {
      updateOutput(lpResetMixer,i);
      patchOutput(lpResetMixer,i,(LPPATCHINFO) ((DWORD)NUM_OUT_PATCHES+1));
      }
   for (i=0; i<bNumInputs; i++)
      {
      updateInput(lpResetMixer,i);
      //patchInput(lpResetMixer,i,(LPPATCHINFO) ((DWORD)NUM_OUT_PATCHES+1));
      }

//   SetFilter(1);   // minimize startup click ----------- removed in 14670

   return 0;
}

//#if 0
//    /*\
//    |*|----====< int NEAR LibUnload() >====----
//    |*|
//    |*|  Library termination code.
//    |*|
//    \*/
//
//static char name[MAXPNAMELEN],mode[7];
//
//int
//LibUnload(void)
//{
//        WORD    ass;
//        USHORT  i;
//
//        lpMixer=lpCurrentMixer;
//
//   //DOUTX("\r\nMIXINITC: LibUnload");
//        //if (fSaveSettingsOnWindowsExit==FALSE)
//                goto quickexit;
//
//        lpName=(LPSTR) name;
//        lpMode=(LPSTR) mode;
//
//        for (i=0; i<bNumInputs; i++)
//                {
//                lstrcpy(lpName,(LPSTR) lpMixer->LineInStatus[i].szPname);
//
//                if (lpMixer->LineInStatus[i].dwConnections & (1<<OUT_AMPLIFIER))
//                        lstrcpy(lpMode,(LPSTR) " PLAY   ");
//                else
//                        lstrcpy(lpMode,(LPSTR) " RECORD ");
//                lvol=HIWORD(lpMixer->LineInStatus[i].dwVolume)>>8;
//                lvol++;
//                lvol*=100;
//                lvol/=256;
//
//                rvol=LOWORD(lpMixer->LineInStatus[i].dwVolume)>>8;
//                rvol++;
//                rvol*=100;
//                rvol/=256;
//
//                ass=LOWORD(lpMixer->LineInStatus[i].dwAssociation);
//
//                //wsprintf( szProfile,(LPSTR) "LineIn%d",i+1);
//                ///mixGetDeviceName(lpMixer->LineInStatus[i].dwDeviceType,(LPSTR) initbuf2,MIX_DEVICESHORTNAME);
//                //wsprintf( (LPSTR)buf,"%-8.8s  %-4.4s %-8.8s  L=%3d%% R=%3d%%  @=%04x",lpName,(LPSTR) initbuf2,lpMode,lvol,rvol,ass);
//                //WriteProfileString(szDriverName,szProfile,buf);
//                }
//
//        lstrcpy(lpName,(LPSTR) lpMixer->LineOutStatus[0].szPname);
//
//
//
//        lvol=HIWORD(lpMixer->LineOutStatus[OUT_AMPLIFIER].dwVolume)>>8;
//        lvol++;
//        lvol*=100;
//        lvol>>=8;
//
//        rvol=LOWORD(lpMixer->LineOutStatus[OUT_AMPLIFIER].dwVolume)>>8;
//        rvol++;
//        rvol*=100;
//        rvol>>=8;
//
//        lstrcpy(lpName,(LPSTR) lpMixer->LineOutStatus[OUT_AMPLIFIER].szPname);
//        lpMode=(LPSTR) mode;
//        lstrcpy(lpMode,(LPSTR) " PLAY   ");
//
//        ///mixGetDeviceName(lpMixer->LineOutStatus[OUT_AMPLIFIER].dwDeviceType,(LPSTR) initbuf2,MIX_DEVICESHORTNAME);
//        //wsprintf((LPSTR)  buf,"%-8.8s %-4.4s %-8.8s  L=%3d%% R=%3d%%  @=%04x",lpName,(LPSTR) initbuf2,lpMode,lvol,rvol,ass);
//        //WriteProfileString(szDriverName,"LineOut1",buf);
//
//        if      (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
//                {
//                lvol=HIWORD(lpMixer->LineOutStatus[OUT_PCM].dwVolume)>>8;
//                lvol++;
//                lvol*=100;
//                lvol>>=8;
//
//                rvol=LOWORD(lpMixer->LineOutStatus[OUT_PCM].dwVolume)>>8;
//                rvol++;
//                rvol*=100;
//                rvol>>=8;
//
//                lstrcpy(lpName,(LPSTR) lpMixer->LineOutStatus[OUT_PCM].szPname);
//                lpMode=(LPSTR) mode;
//                lstrcpy(lpMode,(LPSTR) " RECORD ");
//
//                //^mixGetDeviceName(lpMixer->LineOutStatus[OUT_PCM].dwDeviceType,(LPSTR) initbuf2,MIX_DEVICESHORTNAME);
//                //wsprintf((LPSTR)  buf,"%-8.8s %-4.4s %-8.8s  L=%3d%% R=%3d%%  @=%04x",lpName,(LPSTR) initbuf2,lpMode,lvol,rvol,ass);
//                //WriteProfileString(szDriverName,"LineOut2",buf);
//                }
//
//        if (lpMixer->LineOutStatus[0].dwStereoEnhance)
//                lstrcpy((LPSTR) buf,(LPSTR) "ON");
//        else
//                lstrcpy((LPSTR) buf,(LPSTR) "OFF");
//        //WriteProfileString(szDriverName,"StereoEnhance",buf);
//
//        if (lpMixer->LineOutStatus[0].dwLoudness)
//                lstrcpy((LPSTR) buf,(LPSTR) "ON");
//        else
//                lstrcpy((LPSTR) buf,(LPSTR) "OFF");
//        //WriteProfileString(szDriverName,"Loudness",buf);
//
//        bass=BMTBASS(lpMixer->LineOutStatus[OUT_AMPLIFIER].dwBMT);
//        bass++;
//        bass*=100;
//        bass >>=8;
//        //wsprintf((LPSTR) buf,(LPSTR) "%3d",bass);
//        //WriteProfileString((LPSTR) szDriverName,(LPSTR) "Bass",(LPSTR) buf);
//
//        treb=BMTTREB(lpMixer->LineOutStatus[OUT_AMPLIFIER].dwBMT);
//        treb++;
//        treb*=100;
//        treb >>=8;
//        ///wsprintf((LPSTR) buf,(LPSTR) "%3d",treb);
//        ///WriteProfileString((LPSTR) szDriverName,(LPSTR) "Treble",(LPSTR) buf);
//
//        if (fSaveSettingsOnWindowsExit)
//                lstrcpy((LPSTR) buf,(LPSTR) "YES");
//        else
//                lstrcpy((LPSTR) buf,(LPSTR) "NO");
//        //WriteProfileString((LPSTR) szDriverName,(LPSTR) "SaveSettingsOnWindowsExit",(LPSTR) buf);
//
//        quickexit:
//                ;
//   //DOUTX("\r\nMIXINITC: freeing memory");
//        return(0);
//}
//#endif

                                        //-------------------- DeviceFromName -
DWORD DeviceFromName (LPSTR lpName)
{
   int   i;
   DWORD dwRet=0;

   if (*(lpName+3)=='|')
      dwRet=MIX_USER_CONNECTED;

   *(lpName+3)=0;       // make 3-char string

   //wsprintf(initbuf2,"\r\nDeviceTypeName=%s",lpName);
   //DOUTX(initbuf2);

   for (i=0; i< (32-4) ; i++)
      {
      //mixGetDeviceName((DWORD)1<<i,(LPSTR)devName,4); // 3 letters + term
      //wsprintf(initbuf2,"\r\n  Comparing %s",(LPSTR)devName);
      //DOUTX(initbuf2);

      if (lstrcmp((LPSTR)lpName,(LPSTR)devName)==0)     // exact match?
         {
         dwRet|=1<<i;  // found the device type
         break;
         }
      } // end for

      return(dwRet);
}

//#if 0
//DWORD NEAR
//GetProfileHex(LPSTR p)
//{
//WORD n = 0;
//char  c;
//
//   // convert the hexadecimal text into binary
//
//        while (isxdigit(*p))
//                {
//            c =(char) *p++;
//            if (c > 'Z') c -= 'a' - 'A';
//            c = c - (char)'0';
//            if (c > 9) c -= 7;
//            n = n * 16 + c;
//                }
//        return (n);
//}
//
///*
//------------------------------------------------------------------------------
//FUNCTION        ||      GetLineProfileString
//------------------------------------------------------------------------------
//*/
//
//BOOL
//GetLineProfileString(LPSTR lpKeyName,LPSTR lpLineName, LPWORD lpwPatch, LPDWORD lpdwVolume, LPDWORD lpdwDeviceType,LPDWORD lpdwAssociation)
//{
//        int c,n;
//        int retval;
//
//        cp1=(LPSTR) &initbuf[0];
//        cp2=lpLineName;
//
//        //retval=GetProfileString(szDriverName, lpKeyName, "",cp1, LBUFFLEN);
//        if (!retval)
//                return (FALSE);         // didn't find it!
//
//        *cp2=0;                                                                         // default values
//        *lpwPatch=PATCH_PLAY;
//        *lpdwVolume=0x8080;
//
//        // first get the line name
//        while (whitespace(*cp1))
//                cp1++;                                                                  // skip leading blanks
//        if (!*cp1)
//                return(FALSE);                                                  // no valid info yet
//
//        while (*cp1 && (!whitespace(*cp1)) && ((cp2-lpLineName)< MAXPNAMELEN-1) )
//                *cp2++=*cp1++;                                                  // copy the line name
//        *cp2++=0;
//
//        while (whitespace(*cp1))                                                //      skip blanks
//                cp1++;
//
//        *lpdwDeviceType=DeviceFromName(cp1);
//
//        cp1+=4;
//        while (whitespace(*cp1))                                                //      skip blanks
//                cp1++;
//
//        switch (*cp1++)
//                {
//                case 0:
//                        return(TRUE);                                           // got some valid info
//
//                case 'R':
//                case 'r':
//                        *lpwPatch=PATCH_RECORD;
//                        break;
//
//                case 'P':
//                case 'p':
//                default:
//                        *lpwPatch=PLAY;
//                        break;
//                }
//
//        while (*cp1 && (*cp1 != '='))                   //      skip until blanks
//                cp1++;
//
//        if (*cp1)
//                cp1++;                                                                  // skip '='
//        while (whitespace(*cp1))                                //      skip blanks
//                cp1++;
//
//        if (!*cp1)
//                return(TRUE);                                                   // got some valid info
//
//        //  now get the left & right volume levels
//
//        c=n=0;
//        while (isdigit(*cp1))
//                {
//           c = *cp1++;
//           c = c - '0';
//           n = (n * 10) + c;
//                }
//        left=Scale100ToFFFF(n);
//
//        while (*cp1 && (*cp1 != '='))                   //      skip until blanks
//                cp1++;
//
//        if (*cp1)
//                cp1++;                                                                  // skip '='
//        while (whitespace(*cp1))                                //      skip blanks
//                cp1++;
//
//        if (!*cp1)
//                {
//                *lpdwVolume=(left<<16)+left;
//                return(TRUE);                                                   // got some valid info
//                }
//
//        c=n=0;
//        while (isdigit(*cp1))
//                {
//           c = *cp1++;
//           c = c - '0';
//           n = (n * 10) + c;
//                }
//        right=Scale100ToFFFF(n);
//
//        *lpdwVolume=(left<<16)+right;
//
//        while (whitespace(*cp1))                        //      skip blanks
//                cp1++;
//        while (*cp1 && (*cp1 != '@'))           //      find association
//                cp1++;
//        cp1+=2;                                                                 // skip "@="
//
//        /////dwAss=GetProfileHex(cp1);
//        dwAss+=dwAss<<16;
//        *lpdwAssociation=dwAss;
//
//        cp1=(LPSTR) &initbuf[0];
//        ///mixGetDeviceName(*lpdwDeviceType,cp1,MIX_DEVICESHORTNAME);
//
//        return(TRUE);                                                   // got some valid info
//
//}
//#endif


void NEAR InitSilentMixer()
{
   BOOL   fOk=FALSE;
   USHORT i;
   LPSTR  lpnm;

   dwAmpConnections=0;
   dwPCMConnections=0;
   lpwPatch=(LPWORD) &wPatch;
   lpdwVolume=&dwVolume;

   #ifdef MIX_MONITOR
   StringOut("MIXINITC: Silent Mixer...");
   #endif

   // Now, build the silent mixer state

   for (i=0; i<bNumInputs; i++)
      {
      lpResetMixer->LineInStatus[i].wNumber=i;            // Adlib FM
      lpResetMixer->LineInStatus[i].wNumSoftPatches=1;
      lpResetMixer->LineInStatus[i].wNumChannels=STEREO;  // number of channels
      lpResetMixer->LineInStatus[i].dwSupport=
         MIX_SUPPORT_VOLUME | MIX_SUPPORT_LRVOLUME;

      if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
         lpResetMixer->LineInStatus[i].dwSupport|= MIX_SUPPORT_CROSSOVER;

      //wsprintf( szProfile, "LineIn%d",i+1);
      //fOk=GetLineProfileString(szProfile,(LPSTR) buf, lpwPatch, lpdwVolume,&dwDeviceType,&dwAssociation);
      if (!fOk)
         dwVolume=0x88888888;

      lpResetMixer->LineInStatus[i].dwVolume=0L;
      lpResetMixer->LineInStatus[i].dwAutoLevel=0L;
      lpResetMixer->LineInStatus[i].dwBMT=0L;
      lpResetMixer->LineInStatus[i].dwCrossover=MIXCROSSCAPS_NORMAL_STEREO;
      lpResetMixer->LineInStatus[i].dwLoudness=0;
      lpResetMixer->LineInStatus[i].dwMute=0;
      lpResetMixer->LineInStatus[i].dwReverb=0;
      lpResetMixer->LineInStatus[i].dwStereoEnhance=0;
      lpResetMixer->LineInStatus[i].dwCustom1=0;
      lpResetMixer->LineInStatus[i].dwCustom2=0;
      lpResetMixer->LineInStatus[i].dwCustom3=0;
      lpResetMixer->LineInStatus[i].dwReserved2=0;
      lpResetMixer->LineInStatus[i].dwAssociation=0;
      lpResetMixer->LineInStatus[i].dwConnections=0;

      // users may override name, device type, and association
      if (fOk)
         {
         lpResetMixer->LineInStatus[i].wPatchNumber=-1;                          // -1 specifies user override patch
         lpResetMixer->LineInStatus[i].dwDeviceType=dwDeviceType;
         lstrcpy((LPSTR)lpResetMixer->LineInStatus[i].szPname,(LPSTR)buf);
         lpResetMixer->LineInStatus[i].dwAssociation=dwAssociation;
         patchInput(lpResetMixer, i, NULL);              // use default patch
         }
      else
         {
         // init use of default patch and get results
         patchInput((LPMIXERSTATE)NULL, i, (LPPATCHINFO) NUM_IN_PATCHES+10);

         lpResetMixer->LineInStatus[i].wPatchNumber=
         lpCurrentMixer->LineInStatus[i].wPatchNumber;
         lpResetMixer->LineInStatus[i].dwDeviceType=
         lpCurrentMixer->LineInStatus[i].dwDeviceType;
         lstrcpy((LPSTR)lpResetMixer->LineInStatus[i].szPname,
         (LPSTR)lpCurrentMixer->LineInStatus[i].szPname);
         lpResetMixer->LineInStatus[i].dwAssociation=
         lpCurrentMixer->LineInStatus[i].dwAssociation;
         } // end else

      // CDPC
      // Always keep the MIC on RECORD
      if ( (i == IN_MICROPHONE) && pf.ProCard[gwBoardIndex].Caps.CapsBits.CDPC)
         wPatch = PATCH_RECORD;

      if (wPatch==PATCH_RECORD)
         {
         lpResetMixer->LineInStatus[i].dwConnections=1<<OUT_PCM; //output 1
         dwPCMConnections|=1<<i;
         }
      else
         {
         lpResetMixer->LineInStatus[i].dwConnections=1<<OUT_AMPLIFIER; //output 0
         dwAmpConnections|=1<<i;
         }
      } // end for

   lstrcpy ((LPSTR)lpResetMixer->LineInStatus[0].szIOname,
            (LPSTR)"synthesizer input");

   if (!pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      lstrcpy((LPSTR)lpResetMixer->LineInStatus[1].szIOname,
              (LPSTR)"record monitor");
   else
      {
      lstrcpy ((LPSTR)lpResetMixer->LineInStatus[1].szIOname,
               (LPSTR)"Internal input #1");
      lpResetMixer->LineInStatus[1].dwSupport |= MIX_SUPPORT_MANUALPATCH;
      }

   lpResetMixer->LineInStatus[2].dwSupport |= MIX_SUPPORT_MANUALPATCH;
   lstrcpy((LPSTR)lpResetMixer->LineInStatus[2].szIOname,(LPSTR)"Auxillary input jack");
   lpResetMixer->LineInStatus[3].dwSupport |= MIX_SUPPORT_MANUALPATCH;
   if (!pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      lstrcpy((LPSTR)lpResetMixer->LineInStatus[3].szIOname,(LPSTR)"Internal input header");
   else
      {
      lstrcpy((LPSTR)lpResetMixer->LineInStatus[3].szIOname,
              (LPSTR)"Internal input #2");
      lpResetMixer->LineInStatus[3].dwSupport |= MIX_SUPPORT_MANUALPATCH;
      }

   lpResetMixer->LineInStatus[4].wNumChannels=MONO;
   lpResetMixer->LineInStatus[4].dwSupport |= MIX_SUPPORT_MANUALPATCH;
   lstrcpy((LPSTR)lpResetMixer->LineInStatus[4].szIOname,
           (LPSTR)"Microphone jack");

   lstrcpy((LPSTR)lpResetMixer->LineInStatus[5].szIOname,
           (LPSTR)"digital audio input");

   lpResetMixer->LineInStatus[6].wNumChannels=MONO;
   lstrcpy((LPSTR)lpResetMixer->LineInStatus[6].szIOname,
           (LPSTR)"PC-spkr input header");

   if (!pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      {
      lstrcpy((LPSTR)lpResetMixer->LineInStatus[7].szIOname,
              (LPSTR)"Snd Blaster audio input");
      lpResetMixer->LineInStatus[7].wNumChannels=MONO;
      }

   lpResetMixer->LineOutStatus[0].wNumber=OUT_AMPLIFIER;
   lpResetMixer->LineOutStatus[0].wNumSoftPatches=1;
   lpResetMixer->LineOutStatus[0].wNumChannels=STEREO;
   lpResetMixer->LineOutStatus[0].dwSupport=
      MIX_SUPPORT_VOLUME        |
      MIX_SUPPORT_LRVOLUME      |
      MIX_SUPPORT_BMT           |
      MIX_SUPPORT_LOUDNESS      |
      MIX_SUPPORT_STEREOENHANCE |
      MIX_SUPPORT_MANUALPATCH;

   lstrcpy((LPSTR)lpResetMixer->LineOutStatus[OUT_AMPLIFIER].szIOname,
           (LPSTR)"Pro Audio Line Out"); // line name
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].wPatchNumber =1;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwConnections=dwAmpConnections;

   lpResetMixer->LineOutStatus[1].wNumber=OUT_PCM;      // Record
   lpResetMixer->LineOutStatus[1].wNumSoftPatches=1;
   lpResetMixer->LineOutStatus[1].wNumChannels=STEREO;  // number of channels

   if (!pf.ProCard[gwBoardIndex].Caps.CapsBits.Mixer_508)
      {
      lpResetMixer->LineOutStatus[1].dwSupport=MIX_SUPPORT_CROSSOVER;
      }
   else
      {
      lpResetMixer->LineOutStatus[1].dwSupport=
         MIX_SUPPORT_VOLUME|MIX_SUPPORT_LRVOLUME;
      }

   lpResetMixer->LineOutStatus[1].dwConnections=dwPCMConnections; //output 0
   lstrcpy((LPSTR)lpResetMixer->LineOutStatus[1].szIOname,
           (LPSTR)"Digital Audio Input");  // line name

   lpResetMixer->LineOutStatus[1].wPatchNumber =2;

   //fOk=GetLineProfileString("LineOut1",buf, lpwPatch, lpdwVolume,
   //                         &dwDeviceType,&dwAssociation);
   if (!fOk)
      dwVolume=0x88888888;

   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwVolume      = 0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwAutoLevel   = 0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwCrossover   =
      MIXCROSSCAPS_NORMAL_STEREO;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwMute        = 0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwReverb      = 0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwCustom1     = 0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwCustom2     = 0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwCustom3     = 0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwReserved2   = 0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwAssociation = 0;

   patchOutput((LPMIXERSTATE)NULL,
               0,
               (LPPATCHINFO)NUM_OUT_PATCHES+10);  // force default

   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].wPatchNumber=
      lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].wPatchNumber;

   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwDeviceType=
      lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].dwDeviceType;

   lstrcpy((LPSTR)lpResetMixer->LineOutStatus[OUT_AMPLIFIER].szPname,
           (LPSTR)lpCurrentMixer->LineOutStatus[OUT_AMPLIFIER].szPname);

   patchOutput((LPMIXERSTATE)NULL,
               1,
               (LPPATCHINFO)NUM_OUT_PATCHES+10);  // force default
   lpResetMixer->LineOutStatus[OUT_PCM].wPatchNumber=
           lpCurrentMixer->LineOutStatus[OUT_PCM].wPatchNumber;
   lpResetMixer->LineOutStatus[OUT_PCM].dwDeviceType=
           lpCurrentMixer->LineOutStatus[OUT_PCM].dwDeviceType;
   lstrcpy((LPSTR)lpResetMixer->LineOutStatus[OUT_PCM].szPname,
           (LPSTR)lpCurrentMixer->LineOutStatus[OUT_PCM].szPname);

   dwVolume=0;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwStereoEnhance=dwVolume;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwLoudness=dwVolume;
   lpResetMixer->LineOutStatus[OUT_AMPLIFIER].dwBMT=dwVolume;

   lpnm=(LPSTR)"SaveSettingsOnWindowsExit";
   //GetProfileString(szDriverName,lpnm, "YES", buf, LBUFFLEN);
   //if (buf[0]=='N')
   //      fSaveSettingsOnWindowsExit=FALSE;

   // Now do a fast hardware update that hopefully will avoid
   // causing the speakers to pop.

   SetFilter(0);           // mute the device
   CopyMixerState(lpCurrentMixer,lpResetMixer);

   bForceInit=TRUE;
   for (i=0; i<bNumOutputs; i++)
      {
      updateOutput(lpResetMixer,i);
      patchOutput(lpResetMixer,i,NULL);
      }

   for (i=0; i<bNumInputs; i++)
      {
      updateInput(lpResetMixer,i);
      //patchInput(lpResetMixer,i,NULL);
      }

   bForceInit=FALSE;
   fMixerInitializing=FALSE;
}


                                        //-------------------- Scale100ToFFFF -
DWORD Scale100ToFFFF (WORD wVal)
{
   DWORD dwScaled;

   dwScaled = ((DWORD)wVal) * (0xFFFFL/100L);
   dwScaled = (dwScaled & 0xff00L)+ (dwScaled >>8);

   return(dwScaled);
}
