;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; midia.asm - Media Vision Hardware Dependent Module
;
; General Description:
;    Contains hardware dependant MIDI support routines
;
;******************************************************************************
        .286
        .xlist
        include mvmidi.inc
        include findpas.def
        include std.mac
        include basemaca.inc
;;;     include common.inc
        .list


;---------------------------====< Data Segment >====---------------------------
;
_DATA   SEGMENT WORD PUBLIC  USE16 'DATA'

;
; Private Data Definitions
;

datum   db      0

MDctrl  db      0               ;MDSYSCTLR shadow
ISRenab db      0               ;R06 shadow

; r02/r03/r06 bit definitions
TxIRQ   equ     01000000b       ; Tx FIFO interrupt
RxIRQ   equ     00100000b       ; Rx FIFO interrupt

; r34 bit definitions
RxRDY   equ     10000000b       ; Rx FIFO non-empty

; r54 bit definitions
TxEMP   equ     10000000b       ; Tx FIFO empty
TxRDY   equ     01000000b       ; Tx FIFO non-full

ISRbusy db      0               ;ISR semaphore

;pas2 definitions
rx2IRQ  equ     4

        public  _PasVersion
_PasVersion dw 0

        extrn _gwTranslateCode:WORD
_DATA   ENDS

;
;------------------------====< code segment(s) >====---------------------------
;

_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

;
;------------------------===================================-------------------
;------------------------====< MIDI Interrupt Service > ====-------------------
;------------------------===================================-------------------
;
;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME:  _Init_MIDI_IO(void)
;*
;* PROTOTYPE:        void near Init_MIDI_IO(void)
;*
;*
;* PROTOTYPE:        void near Enable_MIDI_IO(void)
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION:         Initialize MIDI I/O on PAS hardware.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _Init_MIDI_IO
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: none
;*
;* EXIT-NORMAL:
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: none
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _Enable_MIDI_IO
;;;;;   DOUT1   <mxdEnable>


        mov     ax,_PasVersion          ;; Derived in initc.c
        and     al,BOARD_REV_MASK
        cmp     al,VERSION_PAS_1        ;; is it a pas 1 ?
        je      Pas1Enable

; assuming that if it isn't a VERSION_PAS_1 its VERSION_PAS_2
; we do the PAS2 init

        mov     bx,_gwTranslateCode     ; get Translate code

        mov     bx, 0                   ;; fake out xlate for now

        mov     dx,PAS2_MIDI_CTRL
        xor     dx,bx                   ;; translated I/O addr
        mov     al,060h                 ;; why 60h?  Because the programmer didn't like equates, the jerk
        out     dx,al           ;reset fifo pointers
        sub     al,al
        out     dx,al           ;this is necessary

        mov     dx,PAS2_MIDI_STAT
        xor     dx,bx                   ;; translated I/O addr
        mov     al,0
        out     dx,al

        jmp     douser

Pas1Enable:
        sub     al, al
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 0x

        mov     dx, MDGroup6            ; 06 = IER
        out     dx, al                  ; clear all interrupt enables
        mov     [ISRenab], al

        mov     al, 80h                 ; master clear
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al

        mov     cx, 1000
@@:     in      al, dx                  ; wait 32 TCLK
        loop    @b

        mov     al, 6
        mov     [MDctrl], al
;;;;    mov     dx, MDSYSCTLR
;;;;    xor     dx, bx                  ;; xlated I/O addr
        out     dx, al                  ; 6x
        mov     dx, MDGroup6            ; 66 = Click counter control
        mov     al, 00000010b           ; Clock=1.0MHz, no click pulse
        out     dx, al

        mov     al, 4
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 4x
        mov     dx, MDGroup4            ; 44 = Tx communication rate
        mov     al, 00001000b           ; CLKM/32 = 31,250 bps
        out     dx, al

        mov     al, 2
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 2x
        mov     dx, MDGroup4            ; 24 = Rx communication rate
        mov     al, 00001000b           ; CLKM/32 = 31,250 bps
        out     dx, al

        mov     al, 3
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 3x
        mov     dx, MDGroup5            ; 35 = FIFO-Rx control
        mov     al, 00000001b           ; RxE
        out     dx, al

        mov     al, 5
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 5x
        mov     dx, MDGroup5            ; 55 = FIFO-Tx control
        mov     al, 00000001b           ; TxE
        out     dx, al

TIMER1  equ     2173
        mov     al, 8
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 8x
        mov     dx, MDGroup4            ; 84 = General Timer LSB
        mov     ax, TIMER1
        out     dx, al
        mov     dx, MDGroup5            ; 85 = General Timer MSB
        xchg    ah, al
        out     dx, al

        mov     al, 0
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 0x
        mov     dx, MDGroup5            ; 05 = IRQ mode control
        mov     al, 0011b               ; VE+VM
        out     dx, al

douser:
        ret
EndProc _Enable_MIDI_IO


;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME:  _Disable_MIDI_IO
;*
;* PROTOTYPE:        void near Disable_MIDI_IO(void)
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION:         Disable MIDI I/O on PAS 16.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _Disable_MIDI_IO
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: none
;*
;* EXIT-NORMAL:
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: none
;*
;*********************** END OF SPECIFICATIONS **********************
Procedure _Disable_MIDI_IO

        mov     bx,_gwTranslateCode     ; get Translate code
        mov     bx, 0                   ; fake out xlate code

        mov     ax,_PasVersion          ;; Derived in initc.c
        and     al,BOARD_REV_MASK
        cmp     al,VERSION_PAS_1        ;; is it a pas 1 ?
        je      Pas1Dis

        sub     al,al
        mov     dx,PAS2_MIDI_CTRL
        xor     dx,bx                   ;; translated I/O addr
        out     dx,al           ;kill fifo irq;
        jmp     Disable_done

; end of pas 2 patch
Pas1Dis:
        mov     al, 0
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 0x
        mov     dx, MDGroup5            ; 05 = IRQ mode control
        xor     dx,bx                   ;; translated I/O addr
;       mov     al, 0000b               ;
        out     dx, al
Disable_done:
        ret
EndProc _Disable_MIDI_IO

;------------------------================================----------------------
;------------------------====< MIDI Output Routines >====----------------------
;------------------------================================----------------------
;

Procedure _MIDI_Output_Start

        mov     bx,_gwTranslateCode     ; get Translate code
        mov     bx, 0                   ; fake out xlate

        sub     al, al
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        xor     dx, bx                  ;; xlated I/O addr
        out     dx, al                  ; 0x
        mov     dx, MDGroup6            ; 06 = IRQ enable request
        xor     dx, bx                  ;; xlated I/O addr
        mov     al, [ISRenab]
        or      al, TxIRQ               ; bit 6 = FIFO-Tx empty
        out     dx, al
        mov     [ISRenab], al

        ; clear the FIFO-Tx

        mov     al, 5                   ; 5x
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        xor     dx, bx                  ;; xlated I/O addr
        out     dx, al

        mov     dx, MDGroup5            ; 55 = TCR: FIFO-Tx control
        xor     dx, bx                  ;; xlated I/O addr
        mov     al, 10000101b           ; bit 7 = clear FIFO-Tx
                                        ; bit 3 = enable send break
                                        ; bit 2 = clear Tx idle flag
                                        ; bit 0 = enable Transmitter
        out     dx, al

;;;;    mov     _bmodStarted, 1
        ret
EndProc _MIDI_Output_Start



Procedure _MIDI_Output_Stop
        mov     bx,_gwTranslateCode     ; get Translate code
        mov     bx, 0                   ; fake out xlate

        sub     al, al
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        xor     dx, bx                  ;; xlated I/O addr
        out     dx, al                  ; 0x
        mov     dx, MDGroup6            ; 06 = IRQ enable request
        xor     dx, bx                  ;; xlated I/O addr
        mov     al, [ISRenab]
        and     al, not TxIRQ           ; bit 6 = FIFO-Tx ready
        out     dx, al
        mov     [ISRenab], al

;;;     mov     _bmodStarted, 0
        ret
EndProc _MIDI_Output_Stop


Procedure _MIDI_Output_Byte

        mov     datum,al

        mov     ax,_PasVersion          ;; Derived in initc.c
        and     al,BOARD_REV_MASK
        cmp     al,VERSION_PAS_1        ;; is it a pas 1 ?
        je      Pas1out


        mov     bx,_gwTranslateCode     ; get Translate code
        mov     bx,0                    ;; fake out translate code

        mov     dx,PAS2_FIFO_PTRS
        xor     dx, bx                  ;; xlated I/O addr
        mov     cx, 1000
@@:     in      al,dx
        and     al,0f0h
        cmp     al,010h
        jnz     @F
        loop    @b
        jmp     oops

@@:     mov     dx,PAS2_MIDI_DAT
        xor     dx, bx                  ;; xlated I/O addr
        mov     al, datum
        out     dx, al                  ; ship datum
        jmp     oops


Pas1out:                                ;; support for original PAS
        mov     al, 5                   ; 5x
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR                                           ;[i]
        out     dx, al

        mov     cx, 1000                ; max loop val
        mov     dx, MDGroup4            ; 54 = FIFO-Tx status           ;[i]
@@:     in      al, dx
        test    al, TxRDY               ; TxRDY bit?
        jnz     @F                      ; ..jump if FIFO full
        loop    @B
        jmp     short oops
@@:
        mov     dx, MDGroup6            ; 56 = FIFO-Tx data
        mov     al, datum
        out     dx, al                  ; ship datum
oops:
        ret
EndProc _MIDI_Output_Byte


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;  The code below is for MIDI record and is being saved til needed  ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
IF 0
;
;------------------------===============================-----------------------
;------------------------====< MIDI Input Routines >====-----------------------
;------------------------===============================-----------------------
;

Procedure _MIDI_Record_Start

        mov     ax,_PasVersion          ;; Derived in initc.c
        and     al,BOARD_REV_MASK
        cmp     al,VERSION_PAS_1        ;; is it a pas 1 ?
        je      Pas1Start

        mov     bx,_gwTranslateCode     ; get Translate code
        mov     bx, 0                   ; fake out xlate

        mov     dx,PAS2_MIDI_CTRL
        xor     dx,bx                   ;; translated I/O addr
        mov     al,060h
        out     dx,al           ;reset fifo pointers
;;;;    sub     al,al           ; don't enable these 'til interrupts are go!
;;;;    out     dx,al           ;this is necessary

        mov     dx,PAS2_MIDI_STAT
        xor     dx,bx                   ;; translated I/O addr
        mov     al,0
;;;     not     al
        out     dx,al

        mov     dx,PAS2_MIDI_CTRL
        xor     dx,bx                   ;; translated I/O addr
        mov     al,rx2IRQ
        out     dx,al            ;enable input fifo interrupt

        jmp     comstart

;----end of pas2 patch
Pas1Start:
        sub     al, al
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 0x
        mov     dx, MDGroup6            ; 06 = IRQ enable request
        mov     al, [ISRenab]
        or      al, RxIRQ               ; bit 5 = FIFO-Rx ready
        out     dx, al
        mov     [ISRenab], al

        ; clear the FIFO-Rx

        mov     al, 3                   ; 3x
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al

        mov     dx, MDGroup5            ; 35 = RCR: FIFO-Rx control
        mov     al, 11001101b           ; bit 7 = clear FIFO-Rx
                                        ; bit 6 = clear RxOV flag
                                        ; bit 4 = enable MIDI-clock filter
                                        ; bit 3 = clear BRK flag
                                        ; bit 2 = clear RxOL flag
                                        ; bit 1 = enable Address-hunter
                                        ; bit 0 = enable Receiver
        out     dx, al
        xor     bx,bx                   ;; no relocation for Pas version 1

comstart:
        ret
EndProc _MIDI_Record_Start

;-------------------------------

Procedure _MIDI_Record_Stop

        mov     ax,_PasVersion          ;; BUG: THIS SHOULD USE PROFILE
        and     al,BOARD_REV_MASK
        cmp     al,VERSION_PAS_1        ;; is it a pas 1 ?
        je      Pas1Stop

        mov     bx,_gwTranslateCode     ; get Translate code
        mov     bx, 0                   ; fake out xlate

        sub     al,al
        mov     dx,PAS2_MIDI_CTRL
        xor     dx,bx                   ;; xlated I/O addr
        out     dx,al                   ;kill Irq
        jmp     commStop

Pas1Stop:
        sub     al, al
        mov     [MDctrl], al
        mov     dx, MDSYSCTLR
        out     dx, al                  ; 0x
        mov     dx, MDGroup6            ; 06 = IRQ enable request
        mov     al, [ISRenab]
        and     al, not RxIRQ           ; bit 5 = FIFO-Rx ready
        out     dx, al
        mov     [ISRenab], al
        xor     bx,bx                   ;; no xlate for PAS 1
commStop:
        ret
EndProc _MIDI_Record_Stop

        extrn   midByteRec:far
;   /*\
;---|*|----====< proc MIDI2_ISR >====----
;   |*|
;---|*|  ISR service routine  for pas2
;---|*|
;   \*/
        public MIDI2_ISR
MIDI2_ISR       proc    far
        pusha
        push    es

        mov     al, 1                   ; (non-zero AL)
        xchg    al, ISRbusy             ; test/set busy
        or      al, al                  ; test if already entered
        jz      rx2ISR                  ; if not continue
        jmp     woops2                  ; ..if so, just exit

rx2ISR:
        mov     bx,_gwTranslateCode     ; get Translate code

        mov     dx,PAS2_MIDI_STAT
        xor     dx,bx                   ; xlated I/O addr
        in      al,dx

        test    al,10100000b            ; frame error or input fifo overload?
        jz      NoErrs                  ; nope

        test    al,10000000b            ; frame error or input fifo overload?
        jz      @F

        DOUT1   < frame >

@@:     test    al,00100000b            ; frame error or input fifo overload?
        jz      @F                      ; nope

        DOUT1   < over >

@@:     and     al,10100000b
        out     dx,al                   ;; clear frame error

        mov     dx,PAS2_MIDI_CTRL
        xor     dx,bx                   ;; translated I/O addr

        in      al,dx
        or      al,00100000b            ;; reset FIFO in ptr
        out     dx,al
        and     al,11011111b            ;; release FIFO in ptr
        out     dx,al
        jmp     short checktrans

NoErrs:
        test    al,rx2IRQ               ; any data in input FIFO?
        jz      checktrans

        mov     dx,PAS2_FIFO_PTRS
        xor     dx,bx
        in      al,dx
        mov     cl,al
        and     cx,0fh                  ; get # of bytes in FIFO
;;;;    jnz     cnt_lt_16

;;;;    mov     cx,16                   ; in this case 0 means 16

cnt_lt_16:
        mov     dx,PAS2_MIDI_DAT
        xor     dx,bx                   ; xlated I/O addr
rxloop:
        in      al,dx
;### eliminate some overhead
;### MIDI spec requires transmitter send something every 300 msec
;    Active Sense (FE) is the standard "nothing for you" byte
        cmp     al, 0FEh                ; Active Sense?
        je      rxCont                  ; ..ignore it
;###
        xor     ah, ah
        PUSHEM  cx,dx
        DOUT1   <i>

        cCall   midByteRec,<ax>         ;; ordinary C routine, trashes regs
        POPEM   cx,dx
rxCont:
        loop    rxloop
        jmp     rx2ISR                  ;; make sure FIFO is empty


checktrans:
; if one were to deal with transmit irqs it would be here
;
        xor     al, al
        mov     ISRbusy, al             ; allow another interrupt
woops2:
        pop     es
        popa
        retf

MIDI2_ISR       endp

;   /*\
;---|*|----====< proc MIDI_ISR >====----
;   |*|
;---|*| MIDI_ISR - ISR service routine
;   |*|
;---|*| ISR for original, non-relocatable hardware
;   \*/

        public  MIDI_ISR
MIDI_ISR        proc    far
        push    ax
        push    bx
        push    dx

        mov     al, 1                   ; (non-zero AL)
        xchg    al, ISRbusy             ; test/set busy
        or      al, al                  ; test if already entered
        bne     WOOPS                   ; ..if so, just exit


; *** Check for Tx IRQ
;     (means FIFO-Tx went empty)
;     refill the FIFO if there's an active buffer

txISR:  mov     dx, MDSYSSTAT           ; IRQ Status
        in      al, dx
        test    al, TxIRQ               ; FIFO-Tx became empty?
        jz      rxISR1                  ; ..jump if not

;---< Tx ISR code goes here >---

        mov     dx, MDIRQCLR
        mov     al, TxIRQ
        out     dx, al                  ; clear TxIRQ

; *** Check for Rx IRQ
;     (means FIFO-Rx went non-empty)
;     empty the FIFO

rxISR:  mov     dx, MDSYSSTAT           ; IRQ Status
rxISR1: in      al, dx
        test    al, RxIRQ               ; FIFO-RX non-empty?
        jz      exISR                   ; ..jump if not

        pusha

;---< Rx ISR - empty buffer >---

@@:     mov     al, 3                   ; 3x
        mov     dx, MDSYSCTLR
        out     dx, al

        mov     dx, MDGroup4            ; 34 = FIFO-Rx status
        in      al, dx
        test    al, RxRDY               ; RxRDY bit?
        jz      @f                      ; ..jump if FIFO empty

        mov     dx, MDGroup6            ; 36 = FIFO-Rx data
        in      al, dx                  ; fetch datum

;### eliminate some overhead
;### MIDI spec requires transmitter send something every 300 msec
;    Active Sense (FE) is the standard "nothing for you" byte
        cmp     al, 0FEh                ; Active Sense?
        je      @b                      ; ..ignore it
;###
        xor     ah, ah
        cCall   midByteRec,<ax>

        jmp     @b

@@:     popa



exISR:  mov     al, [MDctrl]
        mov     dx, MDSYSCTLR
        out     dx, al                  ; restore incoming state

        xor     al, al
        mov     ISRbusy, al             ; allow another interrupt

        pop     dx
        pop     bx
        pop     ax

        retf

woops:                                  ;; failure exit
        DOUT1   <IRQ BUSY!!!>
        pop     dx
        pop     bx
        pop     ax

        retf

MIDI_ISR        endp

sEnd CodeSeg
;;;;;sEnd MidiSeg                                                               ;[a]


ENDIF
_TEXT   ENDS

        end
