/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* initc.c
*
******************************************************************************/

#include <os2.h>
#include <os2medef.h>

#include <meerror.h>
#include <ssm.h>         // Sync Stream Manager
#include <shdd.h>        // IDC interface
#include <audio.h>
#define DRV_16
#include "os2mixer.h"
#include "mvprodd.h"
#include "pasdef.h"
#include "findpas.h"
#include "proto.h"
#include "patch.h"
#include "midi.h"
#include "debug.h"
#include "commdbg.h"
#include "globals.h"
#include "cdevhlp.h"
#include "rmhelp.h"

int InitProHardware(void);         // not a globally accessed function


/*--------------------------------------------------------*/
/* E X T E R N S                                          */
/*--------------------------------------------------------*/
extern WORD FPwTranslateCode; // findpas.c global that gets xlate code


BYTE SB_MPU_EMUL_TABLE[0x10]=           // Interrupt is provided, xlated
   {
   SOUNDBLASTER_EMUL_IRQ,               // to 3-bit irq value for $FB8A
   SOUNDBLASTER_EMUL_IRQ,
   EMUL_IRQ_2,
   EMUL_IRQ_3,
   SOUNDBLASTER_EMUL_IRQ,               // no IRQ 4, override with default
   EMUL_IRQ_5,
   SOUNDBLASTER_EMUL_IRQ,               // no IRQ 6, override with default
   EMUL_IRQ_7,
   SOUNDBLASTER_EMUL_IRQ,               // no IRQ 8, override with default
   SOUNDBLASTER_EMUL_IRQ,               // no IRQ 9, override with default
   EMUL_IRQ_10,
   EMUL_IRQ_11,
   EMUL_IRQ_12,
   SOUNDBLASTER_EMUL_IRQ,               // no IRQ 13, override with default
   SOUNDBLASTER_EMUL_IRQ,               // no IRQ 14, override with default
   SOUNDBLASTER_EMUL_IRQ                // no IRQ 15, override with default
   };

BYTE SB_MPU_IRQ_TABLE[8]=               // IRQ EMUL pointer value from $fB8a
   {
   0,                                   // is translated to IRQ value
   2,
   3,
   5,
   7,
   10,
   11,
   12
   };

/*
** Microchannel POS function variables.
** Not used by PAS-16 driver (ISA only)
*/
ATTACHAREA AttachArea;
SZ         szDevName[9];                // null terminated
USHORT     POSCardID[MAX_POS_SLOTS+1];  // planar id plus 8 adapters
POSRB      ABIOSrb;                     // ABIOS request block
POSLENRB   POSLenRB;                    // Another ABIOS request block.
                                        // Must go to ABIOS to obtain the
                                        // length of RB to use with function
                                        // 0xB (read POS data).

/*                                      ------------------------ InitHardware -
** Hardware initialization code for MV101-based hardware
** Returns number of cards found
** If user has not specified a /B on command line, AdapterInfo.ulPort
** defaults to 0x388.  Otherwise, a legal I/O port location will be
** provided.
**
** New Hardware Init function for multiple boards:
** User will indicate preferred board location with /B parameter.
** If user does not specify a preferred location, default will be 0x388.
** FindPas will first find all boards already initialized (by SCSI for example)
** FindPas will then attempt to wake up boards at preferred locations.
** FindPas will finally attempt to wake up any remaining boards at default locations
** Driver will only load if
**       a) user preferred location matches location of one of the boards
**       b) user did not specify a location and a board is at 0x388
**       c) user did not specify a location and only one board was found
**          at a location other than 0x388
*/
int NEAR InitHardware(void)
{
   USHORT i;

   #ifdef INIT_MONITOR
   StringOut("Calling GetProTable");
   #endif


   pf.wNumFound=0;    // GetLocationRequests(&pf);
   pf.ProCard[pf.wNumFound].ProPort=(WORD) AdapterInfo.range[0].ulPort;
   pf.wNumFound++;    // tell findpas that there is a requested location

   GetProTable( (pPROFILE) &pf );
   if (!pf.wNumFound)
      {
      #ifdef DEBUG_CHK
      StringOut( "MVPROAUD: Can't find a Pro AudioSpectrum or CDPC!");
      #endif
      return(0);
      }

   gwBoardIndex=-1;
   for (i=0; i<pf.wNumFound;i++)
      {
      if (pf.ProCard[i].ProPort==(USHORT) AdapterInfo.range[0].ulPort)
         {
         gwBoardIndex=i;
         #ifdef INIT_MONITOR
         PrintfOut("The requested board location, %0x, was found at index %d",
                   (USHORT) AdapterInfo.range[0].ulPort,i);
         #endif
         break;
         }
      }

   #ifdef INIT_MONITOR
   if (gwBoardIndex==-1)
      PrintfOut("Unable to locate a board at requested location %0x",
                (USHORT) AdapterInfo.range[0].ulPort);
   #endif

   if ((gwBoardIndex==-1) && (pf.wNumFound==1) && !fUserRequestPASLocation)
      {
      gwBoardIndex=0;
      AdapterInfo.range[0].ulPort=pf.ProCard[0].ProPort;
      #ifdef INIT_MONITOR
      PrintfOut
         ("Requested location failed, fall back to only location found: %0x",
          (USHORT) AdapterInfo.range[0].ulPort);
      #endif
      }

   if (gwBoardIndex==-1)
      {
      #ifdef INIT_MONITOR
      if (fUserRequestPASLocation)
         {
         if (pf.wNumFound >1)
            StringOut( "Multiple PAS boards.  None at Requested Location.");
         else
            StringOut( "Single PAS board.    Not at Requested Location.");
         }
      else
         {
         if (pf.wNumFound >1)
            StringOut( "Multiple PAS boards.  None at default location.");
         }
      #endif
      return(0);
      }

   #ifdef INIT_MONITOR
   PrintfOut("Found %d Pro Audio Spectrum cards",pf.wNumFound);
   PrintfOut("This driver using board number %d at base address %x ",
             gwBoardIndex ,pf.ProCard[gwBoardIndex].ProPort );
   #endif

   gwTranslateCode=(pf.ProCard[gwBoardIndex].ProPort^0x388);
   PasVersion=pf.ProCard[gwBoardIndex].wBoardRev;
   FPwTranslateCode = pf.ProCard[gwBoardIndex].wTranslateCode; // RM NEEDS THIS SET

   RMHELP_SetPortsMarker();

   if ( !fDisableFMSynth)
   {
      if ( (RMHELP_GrabPort( FM_BASE) != RMRC_SUCCESS)
                              ||
           (RMHELP_GrabPort( OPL3_BASE) != RMRC_SUCCESS)
                              ||
           (RMHELP_GrabPort( OPL3_BASE+1) != RMRC_SUCCESS) )
      {
         #ifdef PROGRESS_MONITOR
         StringOut("RM ALLOC FM_BASE & OPL3_BASE REG FAILED");
         #endif
         return( 0);
      }
   }

   if ( InitProHardware())    /// ANTHING BUT RETURN 0 IS AN ERROR
   {
      RMHELP_DeAllocPortsToMarker();
      return( 0);       // NO AVAILABLE CARDS FOUND
   }

   dwCaps=pf.ProCard[gwBoardIndex].Caps.dwCaps; // copy for mvmixa.asm

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.DAC16)
      Init16(dwCaps);

   if (( pf.ProCard[gwBoardIndex].wBoardRev == PAS_VERSION_1 )
       || ( pf.ProCard[gwBoardIndex].wBoardRev == PAS_CDPC  ) )
      {
      TimerRunning=0;
      PCMRunning=0;
      }

   // GRAB THESE PORTS FOR THE MIXER
   if ( (RMHELP_GrabPort( MIXER_508_REG) != RMRC_SUCCESS)
                           ||
        (RMHELP_GrabPort( SERIAL_MIXER) != RMRC_SUCCESS)    )
   {
      #ifdef PROGRESS_MONITOR
      StringOut("RM ALLOC MIXER_508_REG & SERIAL_MIXER REG FAILED");
      #endif
      RMHELP_DeAllocPortsToMarker();
      return( 0);
   }

   InitMixer();   // Init Mixer Hardware

   // IF CONFIG.SYS args don't specify DMA, use default

   if (AdapterInfo.usDMALevel==-1)
      {
      switch (pf.ProCard[gwBoardIndex].wBoardRev)
         {
         case PAS_VERSION_1:
            TheDMAChannel = DEF_DMA_PAS;
            break;

         //case PAS_PLUS:
         case PAS_SIXTEEN:
            if (pf.ProCard[gwBoardIndex].Caps.CapsBits.DAC16)
               TheDMAChannel = DEF_DMA_16;
            else
               TheDMAChannel = DEF_DMA_PLUS;
            break;

         case PAS_STUDIO:
            TheDMAChannel = DEF_DMA_16;
            break;

         case PAS_CDPC:
            TheDMAChannel = DEF_DMA_CDPC;
            break;

         default:
            TheDMAChannel = DEF_DMA_16;
            break;
         } // end switch
      AdapterInfo.usDMALevel=TheDMAChannel;
      }

   else
      TheDMAChannel=(CHAR)AdapterInfo.usDMALevel;

   #ifdef INIT_MONITOR
   PrintfOut("Using DMA Channel %d",TheDMAChannel);
   #endif

   if (AdapterInfo.usIRQLevel==-1)
      switch (pf.ProCard[gwBoardIndex].wBoardRev)
         {
         case PAS_VERSION_1:
            TheIRQChannel = DEF_INT_PAS;
            break;

         //case PAS_PLUS:
         case PAS_SIXTEEN:
            if (pf.ProCard[gwBoardIndex].Caps.CapsBits.DAC16)
               TheIRQChannel = DEF_INT_16;
            else
               TheIRQChannel = DEF_INT_PLUS;
            break;

         case PAS_STUDIO:
            TheIRQChannel = DEF_INT_16;
            break;

         case PAS_CDPC:
            TheIRQChannel = DEF_INT_CDPC;
            break;

         default:
            TheIRQChannel = DEF_INT_16;
            break;
            AdapterInfo.usIRQLevel=TheIRQChannel;
         }
   else
      TheIRQChannel=(CHAR)AdapterInfo.usIRQLevel;

   #ifdef INIT_MONITOR
   PrintfOut("Using IRQ Channel %d",TheIRQChannel);
   #endif

   if ( (RMHELP_AllocIRQ( TheIRQChannel) != RMRC_SUCCESS)
                           ||
        (RMHELP_AllocDMA( TheDMAChannel) != RMRC_SUCCESS)   )
   {
      #ifdef PROGRESS_MONITOR
      StringOut( "RM ALLOC IRQ OR DMA FAILED");
      #endif
      RMHELP_DeAllocPortsToMarker();
      RMHELP_DeAllocIRQ();
      RMHELP_DeAllocDMA();
      return( 0);
   }

   Configure(); // sets IRQ and DMA registers
   return(1);
}

                                        //------------------- InitProHardware -
int InitProHardware()
{
   BYTE    bInput, bTemp;
   ULONG   func_offset;

   // Only Initialize the board this driver cares about

   if ( (RMHELP_GrabPort( MIDI_CONTROL) != RMRC_SUCCESS)
                        ||
        (RMHELP_GrabPort( MIDI_STATUS) != RMRC_SUCCESS)
                        ||
        (RMHELP_GrabPort( MIDI_COMPARE_TIME) != RMRC_SUCCESS)
                        ||
        (RMHELP_GrabPort( MIDI_CONTROL) != RMRC_SUCCESS)
                        ||
        (RMHELP_GrabPort( INTERRUPT_ENABLE) != RMRC_SUCCESS)
                        ||
        (RMHELP_GrabPort( INTERRUPT_STATUS) != RMRC_SUCCESS)   )
   {
      #ifdef INIT_MONITOR
      StringOut("RM ALLOC MIDI_CONTROL FAILED");
      #endif
      return( -1);
   }

   switch (pf.ProCard[gwBoardIndex].wBoardRev)
      {
      case PAS_VERSION_1:
         #ifdef INIT_MONITOR
         StringOut("FOUND ORIGINAL PAS");
         #endif
         break;

      //case PAS_PLUS:    // same boardrev as PAS_SIXTEEN
      case PAS_BASIC:
      case PAS_SIXTEEN:
      case PAS_STUDIO:

         bTemp=MIDI_PASS_THRU | RESET_IN_FIFO;

         if ( (RMHELP_GrabPort( INTERRUPT_CTRL_REG) != RMRC_SUCCESS) )
         {
            #ifdef INIT_MONITOR
            StringOut("RM ALLOC INTERRUPT_ENABLE & INTTERUPT CTRL REG FAILED");
            #endif
            return( -1);
         }

         if ( (RMHELP_GrabPort( FEATURE_ENABLE) != RMRC_SUCCESS) )
         {
            #ifdef INIT_MONITOR
            StringOut("RM ALLOC FEATURE_ENABLE FAILED");
            #endif
            return( -1);
         }

         if ( (RMHELP_GrabPort( PCM_CONTROL) != RMRC_SUCCESS) )
         {
            #ifdef INIT_MONITOR
            StringOut("RM ALLOC PCM_CONTROL FAILED");
            #endif
            return( -1);
         }

         if ( (RMHELP_GrabPort( SYSTEM_CONFIG_1) != RMRC_SUCCESS)
                                 ||
              (RMHELP_GrabPort( SYSTEM_CONFIG_2) != RMRC_SUCCESS)
                                 ||
              (RMHELP_GrabPort( SYSTEM_CONFIG_3) != RMRC_SUCCESS)
                                 ||
              (RMHELP_GrabPort( FILTER_REGISTER) != RMRC_SUCCESS) )
         {
            #ifdef INIT_MONITOR
            StringOut("RM ALLOC SYSTEM_CONFIG (1-3) OR FILTER_REG FAILED");
            #endif
            return( -1);
         }

         PASX_OUT( MIDI_CONTROL, bTemp );

         if (pf.ProCard[gwBoardIndex].Caps.CapsBits.DAC16)
            {
            #ifdef INIT_MONITOR
            StringOut("FOUND PAS 16");
            #endif

            // no interrupts, please!
            PASX_OUT( INTERRUPT_ENABLE, 0 );
            PASX_OUT( INTERRUPT_CTRL_REG, 0 );

            bTemp= PCM_FEATURE_ENABLE | MIXER_FEATURE_ENABLE;

            if (!fDisableFMSynth)
               bTemp |= FM_FEATURE_ENABLE;

            // Pre Rev-D uses D4 of $B88 for SB enable
            // Rev D and later uses D1 of $F788

            if (pf.ProCard[gwBoardIndex].wChipRev < CHIP_REV_D)
               {
               if  (fSBEnabled)
                  bTemp |= SB_FEATURE_ENABLE_REV_C;      // enable SB on Pre-Rev D.

               PASX_OUT(FEATURE_ENABLE,bTemp);
               }
            else // rev D chip
               { // enable compatibility mode
               if (pf.ProCard[gwBoardIndex].wBoardRev >= PAS_STUDIO)
                  bTemp|=STUDIO_FEATURE_DISABLE;           // compatibility mode

               PASX_OUT(FEATURE_ENABLE,bTemp);

               bTemp=0;
               if (fSBEnabled)
                  bTemp|=SB_ENABLE_BIT_REV_D;
               if (fMPUEnabled)
                  bTemp|=MPU_ENABLE_BIT;

               if ( (RMHELP_GrabPort( COMPATIBLE_REGISTER_ENABLE) != RMRC_SUCCESS) )
               {
                  #ifdef INIT_MONITOR
                  StringOut("RM ALLOCCOMPATIBLE_REGISTER_ENABLE FAILED");
                  #endif
                  return( -1);
               }
               PASX_OUT( COMPATIBLE_REGISTER_ENABLE,bTemp);
               } // else

            PASX_OUT(PCM_CONTROL,PCM_STEREO|PCM_ENGINE);

            // disable original PAS emulation
            bInput = (BYTE)PASX_IN( SYSTEM_CONFIG_1 );
            bInput = bInput | (BYTE) C1_ACCURATE_TIMING;                             //     or      al,00000010b

            PASX_OUT( SYSTEM_CONFIG_1, bInput ); // set sys config 1
            PASX_OUT( SYSTEM_CONFIG_2, 0 );      // set sys config 2

            PASX_OUT (SYSTEM_CONFIG_3,           // set sys config 3
                      C3_ENHANCED_TIMER | C3_INVERT_BCLK  | C3_SYNC_PULSE);

//            PASX_OUT( FILTER_REGISTER, FILTER_NOMUTE );    removed in 14670

            if (pf.ProCard[gwBoardIndex].wChipRev >= CHIP_REV_D)
               {

               if ( (RMHELP_GrabPort( EMULATION_ADDRESS_POINTER) != RMRC_SUCCESS) )
               {
                  #ifdef INIT_MONITOR
                  StringOut("RM ALLOC EMULATION_ADDRESS_POINTER FAILED");
                  #endif
                  return( -1);
               }
               PASX_OUT (EMULATION_ADDRESS_POINTER,
                         (MPU_ADDR&0x0f0)+((SB_BASE_PORT &0x0f0)>>4) );
               pf.ProCard[gwBoardIndex].MPUPort=MPU_ADDR;

               bTemp=0;
               if (fSBEnabled)
                  {
                  pf.ProCard[gwBoardIndex].SBPort=
                     (USHORT) SBAdapterInfo.range[0].ulPort;

                  if (SBAdapterInfo.usDMALevel > 3)
                     SBAdapterInfo.usDMALevel=SOUNDBLASTER_EMUL_DMA;

                  pf.ProCard[gwBoardIndex].SBDMA=(BYTE)SBAdapterInfo.usDMALevel;
                  bTemp=(BYTE) (SBAdapterInfo.usDMALevel<<6);

                  SBAdapterInfo.usIRQLevel &= 0xf;
                  SBAdapterInfo.usIRQLevel=
                     SB_MPU_EMUL_TABLE[SBAdapterInfo.usIRQLevel];
                  pf.ProCard[gwBoardIndex].SBIRQ=
                     SB_MPU_EMUL_TABLE[SBAdapterInfo.usIRQLevel];
                  bTemp+=SBAdapterInfo.usIRQLevel<<3;
                  }

               if (fMPUEnabled)
                  {
                  MPUAdapterInfo.usIRQLevel &= 0xf;
                  MPUAdapterInfo.usIRQLevel=
                     SB_MPU_EMUL_TABLE[MPUAdapterInfo.usIRQLevel];
                  pf.ProCard[gwBoardIndex].MPUIRQ=
                     SB_MPU_EMUL_TABLE[MPUAdapterInfo.usIRQLevel];
                  bTemp+=MPUAdapterInfo.usIRQLevel;
                  }

               if ( (RMHELP_GrabPort( EMULATION_INTERRUPT_POINTER) != RMRC_SUCCESS) )
               {
                  #ifdef INIT_MONITOR
                  StringOut("RM ALLOC EMULATION_INTERRUPT_POINTER FAILED");
                  #endif
                  return( -1);
               }
               PASX_OUT( EMULATION_INTERRUPT_POINTER, bTemp);

               } // end if
            } // end if

         else // PAS PLUS
            {
            #ifdef INIT_MONITOR
            StringOut("FOUND PAS PLUS");
            #endif

            // no interrupts, please!
            PASX_OUT( INTERRUPT_ENABLE, 0 );
            PASX_OUT( INTERRUPT_CTRL_REG, 0 );

            PASX_OUT (FEATURE_ENABLE,
                      PCM_FEATURE_ENABLE | SB_FEATURE_ENABLE_REV_C);

            if (!fDisableFMSynth)
               bTemp |= FM_FEATURE_ENABLE;

            PASX_OUT(PCM_CONTROL,PCM_STEREO|PCM_ENGINE);

            // disable original PAS emulation

            bInput = (BYTE)PASX_IN( (BYTE) SYSTEM_CONFIG_1 );
            bInput &=(BYTE)~C1_ACCURATE_TIMING;

            PASX_OUT( SYSTEM_CONFIG_1, bInput ); // set sys config 1

            PASX_OUT( SYSTEM_CONFIG_2, 0 ); // set sys config 2

//            PASX_OUT( FILTER_REGISTER, FILTER_NOMUTE );   removed in 14670
            }
         break;

      case PAS_CDPC:
         // Power-up high-pitched whine on CDPC XL - Timer0 needs init.
         calcSampleRate(5000L,1,8);

         // no interrupts, please!
         #ifdef INIT_MONITOR
         StringOut("FOUND CDPC");
         #endif

         if ( (RMHELP_GrabPort( INTERRUPT_ENABLE) != RMRC_SUCCESS)
                                 ||
              (RMHELP_GrabPort( INTERRUPT_CTRL_REG) != RMRC_SUCCESS) )
         {
            #ifdef INIT_MONITOR
            StringOut("RM ALLOC INTERRUPT_ENABLE & INTTERUPT CTRL REG FAILED");
            #endif
            return( -1);
         }

         if ( (RMHELP_GrabPort( FEATURE_ENABLE) != RMRC_SUCCESS) )
         {
            #ifdef INIT_MONITOR
            StringOut("RM ALLOC FEATURE_ENABLE FAILED");
            #endif
            return( -1);
         }

         if ( (RMHELP_GrabPort( PCM_CONTROL) != RMRC_SUCCESS) )
         {
            #ifdef INIT_MONITOR
            StringOut("RM ALLOC PCM_CONTROL FAILED");
            #endif
            return( -1);
         }


         if ( (RMHELP_GrabPort( SYSTEM_CONFIG_1) != RMRC_SUCCESS)
                                 ||
              (RMHELP_GrabPort( SYSTEM_CONFIG_2) != RMRC_SUCCESS)
                                 ||
              (RMHELP_GrabPort( SYSTEM_CONFIG_3) != RMRC_SUCCESS)
                                 ||
              (RMHELP_GrabPort( FILTER_REGISTER) != RMRC_SUCCESS) )
         {
            #ifdef INIT_MONITOR
            StringOut("RM ALLOC SYSTEM_CONFIG (1-3) OR FILTER_REG FAILED");
            #endif
            return( -1);
         }

         PASX_OUT( INTERRUPT_ENABLE, 0 );
         PASX_OUT( INTERRUPT_CTRL_REG, 0 );

         bTemp= PCM_FEATURE_ENABLE |FM_FEATURE_ENABLE | MIXER_FEATURE_ENABLE;

         // Pre Rev-D uses D4 of $B88 for SB enable
         // Rev D and later uses D1 of $F788

         if ((pf.ProCard[gwBoardIndex].wChipRev < CHIP_REV_D) & (fSBEnabled))
            bTemp |= SB_FEATURE_ENABLE_REV_C;      // enable SB on Pre-Rev D.

         PASX_OUT(FEATURE_ENABLE,bTemp);

         if (pf.ProCard[gwBoardIndex].wChipRev >= CHIP_REV_D)
            {
            bTemp=0;
            if (fSBEnabled)
               bTemp|=SB_ENABLE_BIT_REV_D;
            if (fMPUEnabled)
               bTemp|=MPU_ENABLE_BIT;

            if ( (RMHELP_GrabPort( COMPATIBLE_REGISTER_ENABLE) != RMRC_SUCCESS) )
            {
               #ifdef INIT_MONITOR
               StringOut("RM ALLOC COMPATIBLE_REGISTER_ENABLE FAILED");
               #endif
               return( -1);
            }
            PASX_OUT( COMPATIBLE_REGISTER_ENABLE,bTemp);
            }

         PASX_OUT(PCM_CONTROL,PCM_STEREO|PCM_ENGINE|PCM_DAC);

         // disable original PAS emulation
         bInput = (BYTE) PASX_IN( (BYTE) SYSTEM_CONFIG_1 );
         bInput = bInput | (BYTE) C1_ACCURATE_TIMING; // or  al,00000010b
         PASX_OUT( SYSTEM_CONFIG_1, bInput );         // set sys config 1

         PASX_OUT( SYSTEM_CONFIG_2, 0 ); // set sys config 2

         PASX_OUT(SYSTEM_CONFIG_3,0);

         if (pf.ProCard[gwBoardIndex].wChipRev >= CHIP_REV_D)
            {
            if ( (RMHELP_GrabPort( EMULATION_ADDRESS_POINTER) != RMRC_SUCCESS) )
            {
               #ifdef INIT_MONITOR
               StringOut("RM ALLOC EMULATION_ADDRESS_POINTER FAILED");
               #endif
               return( -1);
            }
            PASX_OUT(EMULATION_ADDRESS_POINTER,
                     (MPU_ADDR&0x0f0)+((SB_BASE_PORT &0x0f0)>>4) );
            pf.ProCard[gwBoardIndex].MPUPort=MPU_ADDR;

            bTemp=0;
            if (fSBEnabled)
               {
               pf.ProCard[gwBoardIndex].SBPort=
                  (USHORT) SBAdapterInfo.range[0].ulPort;

               if (SBAdapterInfo.usDMALevel > 3)
                  SBAdapterInfo.usDMALevel=SOUNDBLASTER_EMUL_DMA;

               pf.ProCard[gwBoardIndex].SBDMA=(BYTE)SBAdapterInfo.usDMALevel;
               bTemp=(BYTE) (SBAdapterInfo.usDMALevel<<6);

               SBAdapterInfo.usIRQLevel &= 0xf;
               SBAdapterInfo.usIRQLevel=
                  SB_MPU_EMUL_TABLE[SBAdapterInfo.usIRQLevel];
               pf.ProCard[gwBoardIndex].SBIRQ=
                  SB_MPU_EMUL_TABLE[SBAdapterInfo.usIRQLevel];
               bTemp+=SBAdapterInfo.usIRQLevel<<3;
               }

            if (fMPUEnabled)
               {
               MPUAdapterInfo.usIRQLevel &= 0xf;
               MPUAdapterInfo.usIRQLevel=
                  SB_MPU_EMUL_TABLE[MPUAdapterInfo.usIRQLevel];
               pf.ProCard[gwBoardIndex].MPUIRQ=
                  SB_MPU_EMUL_TABLE[MPUAdapterInfo.usIRQLevel];
               bTemp+=MPUAdapterInfo.usIRQLevel;
               }

            if ( (RMHELP_GrabPort( EMULATION_INTERRUPT_POINTER) != RMRC_SUCCESS) )
            {
               #ifdef INIT_MONITOR
               StringOut("RM ALLOC EMULATION_INTERRUPT_POINTER FAILED");
               #endif
               return( -1);
            }
            PASX_OUT( EMULATION_INTERRUPT_POINTER, bTemp);
            } // end if

//         PASX_OUT( FILTER_REGISTER, FILTER_NOMUTE );     removed in 14670
         break;
      }  // end switch (wBoardRev);

   StringOut("Initting FM");
   if (FMInit())         /// what about original PAS?
      {
      #ifdef INIT_MONITOR
      StringOut("FM INIT OK");
      #endif
      ;
      }
   else
      {
      #ifdef INIT_MONITOR
      StringOut("FM INIT FAILED!");
      #endif
      ;
      }

   first_installed++;

   if ( (RMHELP_GrabPort( IO_PORT_CONFIG_1) != RMRC_SUCCESS) )
   {
      #ifdef INIT_MONITOR
      StringOut("RM ALLOC IO_PORT_CONFIG_1 FAILED");
      #endif
      return( -1);
   }
   bTemp= PASX_IN(IO_PORT_CONFIG_1);

   if (fWarmBootReset)
      bTemp|=WARM_BOOT_RESET;
   else
      bTemp &=(~WARM_BOOT_RESET);

   if (fDisableJoystick)
      bTemp &= (~JOYSTICK_ENABLE);
   else
      bTemp |= JOYSTICK_ENABLE;

   PASX_OUT( IO_PORT_CONFIG_1, bTemp);

         // install on the system timer
   func_offset = (ULONG) update_stream_times;
   if (set_sys_timer((USHORT) func_offset) != 0) {
     #ifdef RESMGR
        RMHELP_DestroyDriver();
     #endif

     return(-1);
   }

   return( 0);
}
