;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; inita.asm - Initialize the Media Vision Sound DLL
;
; This file contains routines to initialize the Media Vision Sound DLL
; including command line parse and setup.
;
; MODIFICATION HISTORY:
; DATE      CHANGE DESCRIPTION
; 10/09/91  created
; 07/29/92  OS/2 adaptation
; 01/23/93  added T:1 support to configure()
; 07/28/93  Add headers for toolkit
; 09/21/93  More header modifications
;******************************************************************************

        page 60,132
        Title INITA.ASM  Initialize the Media Vision Sound DLL


        .286
        .xlist
        include common.inc
        include mvmixer.inc
        include findpas.inc
        include mvsound.inc
        include std.mac

        .list


;
;---------------------------====< segmentation >====---------------------------
;

IFNDEF SEGNAME
    SEGNAME equ <_TEXT>
ENDIF


;
;---------------------------====< data segment >====--------------------------
;

_DATA   SEGMENT WORD PUBLIC USE16 'DATA'

        extrn   _gwTranslateCode:WORD
        extrn   _OldIRQMask:BYTE
        extrn   _TheDMAChannel:BYTE
        extrn   _TheIRQChannel:BYTE
        extrn   _fAlternateOscillator:WORD; 


DMAxlate label byte             ; this translate table converts
        db      4               ; desired DMA channel to the pointer value
        db      1               ; required by IO_PORT_CONFIG_2 ($F389)
        db      2               ; 
        db      3
        db      0
        db      5
        db      6
        db      7
_DATA   ENDS
;
;---------------------------====< code segment >====--------------------------
;

_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

        public  _Init508
_Init508 proc   near


        push    dx
        mov     dx,FEATURE_ENABLE
        xor     dx,_gwTranslateCode     ; convert to xlated address

        in      al,dx
        or      al,MIXER_FEATURE_ENABLE
        out     dx,al

        pop     dx
        ret
_Init508 endp





;   /*\
;---|*|----====< cProc Configure <NEAR, PUBLIC> >====----
;---|*|
;---|*| Configure -- This function sets up for DMA based
;---|*|     on the DMA channel chosen by the user
;---|*|
;   \*/
        public  _Configure
_Configure proc near

        PUSHEM  si,di,es

enable0:
        lea     bx, DMAxlate
        xor     ah,ah
        mov     al, _TheDMAChannel
        xlat    DMAxlate
        mov     dx, IO_PORT_CONFIG_2    ; Sound DMA Pointer 8-bit Channel 1

        mov     bx,_gwTranslateCode     ; get Translate code
        xor     dx, bx                  ;; Translated I/O addr
        out     dx, al                  ;; set DMA channel for hardware to use
        pause

        mov     al, _TheIRQChannel      ; Select IRQ
        cmp     al,7
        jg      gtr_7
        dec     al
        jmp     short set_irq
gtr_7:
        cmp     al,12
        jg      gtr_12
        sub     al,3
        jmp     short set_irq
gtr_12:
        sub     al,4
set_irq:
        mov     dx, IO_PORT_CONFIG_3    ; Sound Interrupt pointer - IRQ 7
        xor     dx,bx                   ;; Translated I/O addr

        mov     cl,al                   ;; AL=CL=sound int  aka push
        in      al,dx                   ;; AL=two nibbles of int value  get current IRQ settings
        mov     ah,al                   ;; AH=AL=two nibbles save a copy of current settings
        mov     al,cl                   ;; AL=sound int aka pop

        and     ah,0f0h                 ;; AH= former nibble (CD int) in high nibble this nibble contains CD IRQ irq
        and     al,00fh                 ;; this nibble contains PCM IRQ ptr
        or      al,ah                   ;; combine the two

        out     dx, al                  ;; set the hardware.  (has no effect on PAS-1
                                        ;;  so this is a bug!)
        pause

        xor     al,al                   ;; mov  al, 0
        mov     dx, SYSTEM_CONFIG_2     ;; 1x oversample,8bit,normal
        xor     dx,bx                   ;; Translated I/O addr
        out     dx, al

;
enab9:
        xor     ax,ax
        push    ax
        mov     al,_TheIRQChannel
        push    ax
        call    InitSetIntMask          ;; this call destroys BX
        add     sp,4

        mov     _OldIRQMask,al

        ; Some Motherboards with an OPTI chipset have a system clock whose
        ; duty cycle is out of spec.  This causes the Yamaha OPL-3 to emit
        ; strange sounds even when not in use.  If the user specifies the
        ; T:1 switch on the command line, we derive a similar clock frequency
        ; from the audio card.  This clock has a 2% error and causes some
        ; pitch inaccuracy.

        mov     bx,_gwTranslateCode     ;; reload destroyed Translate code

        mov     dx,SYSTEM_CONFIG_1      ; 08388h
        xor     dx,bx                   ;; Translated I/O addr
        in      al,dx
        mov     cx,_fAlternateOscillator ;; T:1 set?
        or      cx,cx                   ; set flags
        jz      NoT1
        or      al, SC1_ALTERNATE_CLOCK
        jmp     conf88
NoT1:
        and     al, NOT (SC1_ALTERNATE_CLOCK)
conf88:
        out     dx,al                   ; write bit status

        mov     ax, 0                   ; signifies no error
        POPEM   si,di,es

        ret
_Configure endp


;---------------------------------------------------------------------------;
;
;   BOOL NEAR PASCAL InitSetIntMask( bIRQ, bMask )
;
;   DESCRIPTION:
;       This function sets or unsets interrupt vector mask.
;
;   ENTRY:
;       NwParm1   bIRQ        :   The IRQ (0 - 15) to mask/unmask
;       NwParm2   bMask       :   The mask
;
;   EXIT:
;       AX    :   The return value is the previous interrupt mask.
;
;---------------------------------------------------------------------------;

InitSetIntMask proc near
;        NwParm1   bIRQ
;        NwParm2   bMask
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   see if we need to talk to the slave or master PIC
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;

        push    bp
        mov     bp,sp

        mov     cl, byte ptr NwParm1     ;; get IRQ to mask/unmask
        mov     dx, PIC_IMR_MASTER
        cmp     cl, 8
        jb      SetIntMask_Master
        and     cl, 07h
        mov     dx, PIC_IMR_SLAVE
SetIntMask_Master:

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   compute the interrupt mask.
;       DX = slave or master mask register
;       CL = 0-7 bit to set/clear
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        mov     ch, 1                   ; CH = 1
        shl     ch, cl                  ; CH = int mask

        mov     cl, byte ptr NwParm2    ; get mask
        or      cl, cl
        jz      SetIntMask_UnMask
        mov     cl,ch
SetIntMask_UnMask:

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   CH  = PIC mask         (1 << (bInt&7))
;   CL  = wanted mask      bMask ? ch : 0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        not     ch                      ; we need inverse of mask

        EnterCrit                       ; !!! Trashes BX !!!
        in      al, dx                  ; grab current mask
        mov     ah, al                  ; save it
        and     al, ch                  ; clear bit
        or      al, cl                  ; clear or set based on bMask
        cmp     al, ah                  ; don't set the same state again!
        je      SetIntMask_Same
        pause
        out     dx, al                  ; enable/disable ints...
SetIntMask_Same:
        LeaveCrit                       ; !!! Trashes BX !!!

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   we have set/cleared the PIC, now return the old state.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        not     ch                      ; return previous mask state
        mov     al, ah
        and     al, ch
        xor     ah, ah                  ;; return is 0

        pop     bp
        ret
InitSetIntMask endp


_TEXT   ENDS
        end
