/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* globals.h - CARD INFO GLOBAL VARIABLES
*
******************************************************************************/

extern BOOL  fAlternateOscillator;
extern BOOL  fWarmBootReset;
extern BOOL  fSBEnabled;      // default to SB enabled
extern BOOL  fMPUEnabled;     // default to MPU disabled
extern BOOL   fIRQHasBeenSet;
extern BOOL  fDisableFMSynth;
extern BOOL  fDisableJoystick;

extern USHORT usInUse ;      // device ready flag
extern WORD  gwBoardIndex;    // index to be used for ProTable & I/O xlate

extern DWORD dwCaps;

extern PROFILE pf;                           // Profile Pro AudioSpectrum Hardware
extern LPMIXERSTATE lpCurrentMixer;
extern LPMIXERSTATE lpFadeFromMixer;
extern LPMIXERSTATE lpFadeToMixer;
extern LPMIXERSTATE lpResetMixer;
extern LPMIXERSTATE lpFadeMixer;
extern LPMIXERSTATE lpTempMixer;

extern char     szProfile[];
extern char     buf[];
///extern char buf2[];


/////////////////////////////////////////////////////
///////// PCM GLOBAL VARIABLES //////////////////////
/////////////////////////////////////////////////////

extern int   iEmptyPCMBuffers;
extern SHORT iNextBuffer;                                              // next buffer to be filled

extern WORD  wDMASemiBuf1,wDMASemiBuf2;
extern WORD  wDMABuffLength;

extern DWORD dwDMAUnitSize;      // size of DMA buffer divisions (2k-64k)
extern DWORD gdwSampleRate;
extern DWORD gdCurrentDMABufferSize;       // DMABufferSize
extern ULONG dwDMAPhysAddr,dwDMALinAddr;

extern ULONG ulPCM_PosSemiBufA;          // Stream position of 1st byte in Semibuffer
extern ULONG ulPCM_PosSemiBufB;          // Stream position of 1st byte in Semibuffer

extern ULONG ulMIDI_BufferCount;         // number of buffers sent for inited stream

extern char far *lpDMAVirtual;

extern PCMDEVICES srate;
extern PCMDEVICES bits_per_sample;
extern PCMDEVICES bsize;
extern PCMDEVICES channels;

/////////////////////////////////////////////////////
/////////// STREAN GLOBAL VARIABLES /////////////////
/////////////////////////////////////////////////////

////extern BOOL fInterruptInUse;   // used to determine whether we expect an interrupt
extern BOOL     fPCMStarved;
extern BOOL     fPCMUnderran;
extern BOOL     fPCMChoked;
extern BOOL     fMIDIStarved;
extern BOOL     fMIDIChoked;

extern ULONG    gulFocusSysFileNum;   // sysfile number of device associated
                                      // with multimedia app with focus

extern DEVICES  operation;
extern DEVICES  ulActiveSysFileNum;
extern DEVICES  ulStreamPosition;
extern DEVICES  flags;

/////////////////////////////////////////////////////
///////// MIDI GLOBAL VARIABLES /////////////////////
/////////////////////////////////////////////////////

extern BOOL     gfMIDIOutPortEnabled;
extern BOOL     gfMIDIOutSynthEnabled;

extern WORD     wMIDIPrescale;
extern WORD     wMIDICompareTime;
extern WORD     wMIDICurrentTime;

extern ULONG    ulTimingDelay;


/////////////////////////////////////////////////////
///////// SYNTH GLOBAL VARIABLES ////////////////////
/////////////////////////////////////////////////////

extern BOOL     sapiEnabled;
extern BOOL     sapiInit;
extern BOOL     fUserRequestPASLocation;  // User has request a location

extern int      first_installed ;
extern int      sapi_pitch_range;

extern WORD     dump_to_do ;

/////////////////////////////////////////////////////
///////// MIXER GLOBAL VARIABLES ////////////////////
/////////////////////////////////////////////////////


extern BYTE     bNumInputs;
extern BYTE     bNumOutputs;

extern BOOL     bForceInit;
extern BOOL     fMuting;
extern BOOL     fSaveSettingsOnWindowsExit;
extern BOOL     fMixFadeActive;
extern BOOL     fMixerInitializing;

extern WORD     wCurrentLeft,wCurrentRight;
extern WORD     wProposedLeft,wProposedRight;
extern WORD     wCurrentBass,wCurrentTreble;
extern WORD     wProposedBass,wProposedTreble;
extern WORD     wmPatchChanged;
extern WORD     wmConnectionChanged;
extern WORD     wmControlChanged;
extern WORD     wmMuteStatusChanged;
extern WORD     lvol,rvol,bass,treb;
extern WORD     wPatch;
extern WORD     wCurrentDevice;
extern WORD     numLines[2];

extern DWORD dwCurrentValue,dwCurrentConnections;
extern DWORD dwProposedValue,dwProposedConnections;
extern DWORD dwAmpConnections,dwPCMConnections;
extern DWORD gdwBalanceMIDI;
extern DWORD gdwBalancePCM;
extern DWORD gdwBalanceMaster;
extern DWORD dwAss;
extern DWORD left,right,hexit;
extern DWORD dwVolume,dwDeviceType,dwAssociation;
extern DWORD dwMixDelayTime;        // delay before fade begin
extern DWORD dwMixFadeTime;         // duration of entire fade
extern DWORD dwMixFadeTotalElapsed; // in milliseconds (max=15 minutes)
extern DWORD dwMixFadeElapsed;      // in milliseconds (max=15 minutes)
extern DWORD dwMixFadeDelay;        // in secs/10, delay between fade increments
extern DWORD dwMixFadeDelaySeed;    // in secs/10,
extern DWORD dwMixFirstDelay;       // in secs/10,

extern PATCHINFO pc;
extern PATCHINFO INpatch[];
extern PATCHINFO OUTpatch[];

extern MIXERSTATE CurrentMixer;
extern MIXERSTATE FadeFromMixer;
extern MIXERSTATE FadeToMixer;
extern MIXERSTATE FadeMixer;
extern MIXERSTATE ResetMixer;
extern MIXERSTATE TempMixer;

extern char initbuf[];
extern char initbuf2[];
extern char devName[];
extern char buf[];
extern char szProductName[];
//extern char  szProfile[];
//extern char  buf2[];

extern LPSTR lpName,lpMode;
extern LPSTR cp1;
extern LPSTR cp2;

extern LPWORD   lpwPatch;
extern LPDWORD  lpdwVolume;
extern LPWORD   lpwVolume;

extern LPMIXERSTATE lpMixer;
extern LPMIXERSTATE lpCurrentMixer,lpFadeFromMixer,lpFadeToMixer,lpFadeMixer,lpTempMixer,lpResetMixer;

/*
** in mvsound.asm
*/
extern char TheDMAChannel;
extern char TheIRQChannel;

extern BYTE bBitsSample;
extern BYTE fStereoMode;                               // in mvsound.asm
extern BYTE TimerRunning;           // in mvsound.asm
extern BYTE PCMRunning;             // in mvsound.asm
extern unsigned char  fStereoMode;  // BYTE BOOLEAN

extern WORD  gwTranslateCode;
extern WORD  PasVersion;            // in midia.asm
extern DWORD TheSampleRate;         // in mvsound.asm

/////////////////////////////////////////////////////
////////////// in audiodat.c ////////////////////////
/////////////////////////////////////////////////////
extern DEVHDR  DevHdr[];
extern FPVOID  DevHlp;

extern GLOBAL  GlobalTable;

extern ADAPTERDATA        AdapterInfo;
extern ADAPTERDATA        SBAdapterInfo;
extern ADAPTERDATA        MPUAdapterInfo;
extern PROTOCOLTABLE      ProtocolTable16[N16PROTOCOLS];
extern PROTOCOLTABLE      ProtocolTable8[N8PROTOCOLS];
extern MCI_AUDIO_IOBUFFER recio;
BYTE   SB_MPU_EMUL_TABLE[];
BYTE   SB_MPU_IRQ_TABLE[];
