/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* globals.c - Global variables
*
* DESCRIPTION
* Variables global to execution of device driver.  Includes variables for
* indexing stream buffers and pointers for calculating stream position.
******************************************************************************/

#include <os2.h>
#include <os2medef.h>

#include <ssm.h>
#include <audio.h>
#define DRV_16
#include "os2mixer.h"
#include "mvprodd.h"
#include "findpas.h"
#include "globals.h"
#include "patch.h"
#include "proto.h"

/*
** CARD INFO GLOBAL VARIABLES
*/

BOOL   fIRQHasBeenSet=FALSE;
BOOL   fAlternateOscillator=FALSE;
BOOL   fWarmBootReset=FALSE;
BOOL   fSBEnabled=FALSE;                 // default to SB DISabled  @14429
BOOL   fMPUEnabled=FALSE;               // default to MPU disabled
BOOL   fDisableFMSynth=FALSE;
BOOL   fDisableJoystick=FALSE;

WORD   gwBoardIndex;                    // index to be used for ProTable &
                                        // I/O xlate
WORD   gwTranslateCode;
USHORT usInUse = AVAILABLE;             // device ready flag

DWORD  dwCaps;

PROFILE pf;                             // Profile Pro AudioSpectrum Hardware

/*
** PCM GLOBAL VARIABLES
*/

int   iEmptyPCMBuffers=2;
SHORT iNextBuffer=0;                   // next buffer to be filled

WORD   wDMABuffLength=0;
///WORD       wDMASemiBuf1=0,wDMASemiBuf2=0;

ULONG  dwDMAPhysAddr=0,dwDMALinAddr=0;
ULONG  ulPCM_PosSemiBufA=0;          // Stream position, 1st byte in Semibuffer
ULONG  ulPCM_PosSemiBufB=0;          // Stream position, 1st byte in Semibuffer

///// MV 037   ULONG  ulPCM_BufferCount=0; // number of buffers sent for inited stream

ULONG  ulMIDI_BufferCount=0;         // number of buffers sent for inited stream
DWORD  dwDMAUnitSize=0;      // size of DMA buffer divisions (2k-64k)
DWORD  gdwSampleRate;
DWORD  gdCurrentDMABufferSize=DMA_BUFFER_MAX;       // DMABufferSize

char far *lpDMAVirtual=NULL;

PCMDEVICES srate;
PCMDEVICES bits_per_sample;
PCMDEVICES bsize;
PCMDEVICES channels;

/*
** STREAN GLOBAL VARIABLES
*/

///BOOL      fInterruptInUse = FALSE;   // used to determine whether we expect an interrupt
BOOL fPCMStarved=FALSE;                 // Will next buffer underrun?
BOOL fPCMUnderran=FALSE;                // Should report underrun?
BOOL fPCMChoked=FALSE;                  // Did we overrun on record?
BOOL fMIDIStarved=FALSE;
BOOL fMIDIChoked=FALSE;

ULONG gulFocusSysFileNum=0;      // sysfile number of device associated
                                 // with multimedia app that has focus

DEVICES operation;
DEVICES ulActiveSysFileNum;
DEVICES ulStreamPosition;        // distanced traversed in bytes
DEVICES flags;

/*
** MIDI GLOBAL VARIABLES
*/

BOOL    gfMIDIOutPortEnabled=FALSE;
BOOL    gfMIDIOutSynthEnabled=FALSE;

WORD    wMIDIPrescale;
WORD    wMIDICompareTime;
WORD    wMIDICurrentTime;

ULONG   ulTimingDelay=0;

/*
** SYNTH GLOBAL VARIABLES
*/
BOOL    sapiEnabled;
BOOL    sapiInit;

int     first_installed = 0;
int     sapi_pitch_range=2;
WORD    dump_to_do = 0;

BOOL    fUserRequestPASLocation=FALSE;  // User has request a location


/*
** MIXER GLOBAL VARIABLES
*/
char    initbuf[LBUFFLEN];
char    initbuf2[LBUFFLEN];
char    devName[MIX_DEVICESHORTNAME];

BYTE    bNumInputs;
BYTE    bNumOutputs;

BOOL    fSaveSettingsOnWindowsExit=TRUE;
BOOL    fMixFadeActive=FALSE;
BOOL    fMixerInitializing=FALSE;
BOOL    bForceInit=FALSE;
BOOL    fMuting=FALSE;

WORD    wCurrentLeft,wCurrentRight;
WORD    wProposedLeft,wProposedRight;
WORD    wCurrentBass,wCurrentTreble;
WORD    wProposedBass,wProposedTreble;
WORD    wmPatchChanged;
WORD    wmConnectionChanged;
WORD    wmControlChanged;
WORD    wmMuteStatusChanged;
WORD    lvol,rvol,bass,treb;
WORD    wPatch;
WORD    wCurrentDevice;
WORD    numLines[2];

DWORD   dwCurrentValue,dwCurrentConnections;
DWORD   dwProposedValue,dwProposedConnections;
DWORD   gdwBalanceMIDI=0x40000000L;
DWORD   gdwBalancePCM=0x40000000L;
DWORD   gdwBalanceMaster=0x40000000L;
DWORD   dwAss;
DWORD   left,right,hexit;
DWORD   dwVolume,dwDeviceType,dwAssociation;
DWORD   dwAmpConnections=0,dwPCMConnections=0;
DWORD   dwMixDelayTime;         // delay before fade begin
DWORD   dwMixFadeTime;          // duration of entire fade
DWORD   dwMixFadeTotalElapsed;  // in milliseconds (max=15 minutes)
DWORD   dwMixFadeElapsed;       // in milliseconds (max=15 minutes)
DWORD   dwMixFadeDelaySeed;     // in secs/10,
DWORD   dwMixFadeDelay;         // in secs/10, delay between fade increments
DWORD   dwMixFirstDelay;        // in secs/10,

PATCHINFO  pc;
MIXERSTATE CurrentMixer;
MIXERSTATE FadeFromMixer;
MIXERSTATE FadeToMixer;
MIXERSTATE FadeMixer;
MIXERSTATE ResetMixer;
MIXERSTATE TempMixer;

LPSTR   lpName,lpMode;
LPSTR   cp1;
LPSTR   cp2;

LPWORD  lpwPatch;
LPWORD  lpwVolume=(LPWORD)&dwVolume;

LPDWORD lpdwVolume=&dwVolume;

LPMIXERSTATE lpMixer=NULL;
LPMIXERSTATE lpCurrentMixer=NULL;
LPMIXERSTATE lpFadeFromMixer=NULL;
LPMIXERSTATE lpFadeToMixer=NULL;
LPMIXERSTATE lpFadeMixer=NULL;
LPMIXERSTATE lpTempMixer=NULL;
LPMIXERSTATE lpResetMixer=NULL;

#ifdef OEM
   char    szProductName [] = "Spectrum Sound";
#else
   char    szProductName [] = "Media Vision Pro Audio/CDPC";
#endif

//char  szProfile[LBUFFLEN];
char    buf[LBUFFLEN];
//char  buf2[LBUFFLEN];
