/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Voyetra Technologies, 1990-1993                             */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*     Voyetra Technologies
*     5 Odell Plaza
*     Yonkers, NY 10701
*     Tel: 914-966-0600
*******************************************************************************
*
* fmparse.c - midi parser
*
*/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include <meerror.h>
#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "parse.cdf"
#include "adlib.h"
#include "parse.ext"
#include "findpas.h"
#include "pasdef.h"
#include "globals.h"
#include "proto.h"
#include "debug.h"
#include "commdbg.h"


/* GLOBAL VARS */
BYTE near last_pgm[MAX_NUMBER_OF_OPERATORS] = {0}; // pgm each operator loaded
BYTE msg_buf[8] = {0};    // with buf for midi message (big enough for sysex)
BYTE sysex_buf[8] = {0};  // don't let sysex stomp msg_buf!
BYTE mchan = 0;           // extracted channel of current message
char percussion = DEF_PERC_MODE;
char init_pgms[NUMBER_OF_CHANNELS] = { 0 };

int gop = 0;                           // global operator #
int max_melo_voice = MAX_MELO_MODE_VX; // maximum melodic voices
int num_slots = NUM_SLOTS_CHIP;        // (init to one adlib chip)
int number_of_operators = NUMBER_OF_OPERATORS_CHIP;
int fm_mode;                           // MODE_MELO or MODE_MELO18

/* keep track of pitch bend val of each op */
long  near      last_bend[MAX_NUMBER_OF_OPERATORS] = {0};
CHANNEL_ENTRY channel_stats[NUMBER_OF_CHANNELS] = {0};  /* channel globals */

/*
** Forward references
*/

BOOL near sysex_deal(BYTE);
static void near set_normalized_voice_volume(int voice, int vel);


/*
** Variables
*/


/********* HERE ARE SOME LOOKUP TABLES TO MAP MIDI PITCHES TO DRUMS *********/

#define MIN_DRUM_PITCH 35
#define MAX_DRUM_PITCH 81
static BYTE xlate_drums[MAX_DRUM_PITCH - MIN_DRUM_PITCH +1] = {
        BD,
        BD,             // 36
        0,              // 37
        SD,             // 38
        0,              // 39

        0,              // 40   0 means DRUM_2OP
        0,              // 41
        HIHAT,          // 42
        0,              // 43
        HIHAT,          // 44
        0,              // 45
        0,              // 46
        0,              // 47
        0,              // 48
        CYMB,           // 49

        0,              // 50
        CYMB,           // 51
        0,              // 52
        0,              // 53
        0,              // 54
        0,              // 55
        0,              // 56
        CYMB,           // 57
        0,              // 58
        CYMB,           // 59 for Tandy, Grey LMH 8/14/92

        0,              // 60
        0,              // 61
        0,              // 62
        0,              // 63
        0,              // 64
        0,              // 65
        0,              // 66
        0,              // 67
        0,              // 68
        0,              // 69

        0,              // 70
        0,              // 71
        0,              // 72
        0,              // 73
        0,              // 74
        0,              // 75
        0,              // 76
        0,              // 77
        0,              // 78
        0,              // 79

        0,              // 80
        0       };      // 81

static int      state = 0;       /* state of midi parser (byte count) */
static int      runstat_ok = 0;  /* running status ok for this message? */
static int      msglen = 0;      /* target length of message */
int     type = 0;                /* type of current message */

int     sysex_recipient= RX_NOBODY;  /* intended recipient of syses message */
int     sysex_state = 0;             /* state of sysex parse */
int     re_route_sysex = 0;          /* flag to re-route sysex data */
int     sysex_count = 0;             /* count of data bytes in sysex msg */
static char *   sysex_ptrp = 0;      /* moving pointer into patch data */

static BYTE Voyetra_sysex_header[SX_HEADER_SIZE] =   /* our sysex header */
                        { 0xF0, 0x03, 0x30, 0x01, 0x01, 0x00 };

static BYTE IBM_sysex_header[SX_HEADER_SIZE]=        /* IBM's sysex header */
                        { 0xF0, 0x00, 0x00, 0x3A, 0x01, 0x00 };

static int nyb_save = 0;   /* place to assemble sysex nybbles */

static char     midi_msg_count_lookup[] =  // used in parsing midi
    {
    /* CHANNEL MESSAGES */
    3,          /* 0x80 */
    3,          /* 0x90 */
    3,          /* 0xA0  */
    3,          /* 0xB0  */
    2,          /* 0xC0  */
    2,          /* 0xD0  */
    3,          /* 0xE0  */

/* SYSTEM COMMON */
    4,          /* 0xF0  */
    2,          /* 0xF1  */
    3,          /* 0xF2  */
    2,          /* 0xF3  */
    1,          /* 0xF4  */
    1,          /* 0xF5  */
    1,          /* 0xF6  */
    1,          /* 0xF7  */
    };


/********** HERE IS WHERE MOST OF THE CODE IN THIS MODULE STARTS ************/


                                        //--------------------- get_midi_type -
int get_midi_type (BYTE code)
{
   if (code >= 0xF0)
      code = (code & (BYTE) 0x0F) + (BYTE) 7; // system common and real time:
                                              // 7 to 22
   else
      code = (BYTE)(code >> (BYTE) 4) - (BYTE)8; /* channel messages: 0 to 6 */
   return (code);
}

//   reset_deal()
//    Reset midi parser.

                                        //------------------------ reset_deal -
void reset_deal ()
{
   runstat_ok = 0;
   state = 0;
   sysex_state = SYSEX_IDLE;
   re_route_sysex = 0;
   sysex_count = 0;
}


/*                                      --------------------------- midi_deal -
** Deals with input bytes one at a time.
** x is the input byte.
**    returns TRUE if F8 has been reached
*/
BOOL midi_deal (BYTE x)
{
   register BYTE b = x;
   BOOL fLT=fLineTerminate;

   if (b == 0xf8)
      return TRUE;

   if (b > 0xf8)
      {                 // must handle real time commands
      return FALSE;     // Currently this is lost
      }

   if (re_route_sysex)  /* if we're re-routing sysex */
      {
      return (sysex_deal(b));
      }

   if (!(b & 0x80))     /* if a data byte */
      {
      if (!state)       /* if finished with previous msg */
         {
         if (runstat_ok)
            state++;    /* then wait for running status */
         }

      if (state)
         {
         if (sysex_state)  /* if we're looking at f0 msg */
            {
            sysex_buf[state++] = (char) b;     /* buffer input byte */
            if ((sysex_buf[state-1] != (BYTE) Voyetra_sysex_header[state-1]) &&    //  someone else's sysex message
                (sysex_buf[state-1] != (BYTE) IBM_sysex_header[state-1]))  /* if in sysex,       subsequent bytes */
               reset_deal();                                                /* start parser over */
            }
         else
            msg_buf[state++] = (char) b;        /* buffer input byte */

            if (state >= msglen)        /* if we have the whole message */
               {
               dispatch();              /* then go deal with event */
               state = 0;
               }
        }
      } /* data */
   else
      {
      if (state)                                                                /* unexpected status byte */
         {
         state = 0;
         runstat_ok = 0;
         }
      type = get_midi_type(b);
      msglen = midi_msg_count_lookup[type]; /* how many bytes in the message */
      switch(type)
         {
         case MTYPE_POLY_PRESS:             /* normal channel messages */
         case MTYPE_CONTROL:
         case MTYPE_PROGRAM:
         case MTYPE_CHAN_PRESS:
         case MTYPE_PITCH_WHEEL:
         case MTYPE_NOTE_ON:
         case MTYPE_NOTE_OFF:
            state = 1;
            runstat_ok = 1;
            msg_buf[0] = b;
            break;

         case MTYPE_SYSEX:
            sysex_state = NOT_SURE;
            state = 1;
            runstat_ok = 0;
            sysex_buf[0] = b;
            break;

         case MTYPE_SONG_POS:               /* system common messages */
            state = 1;
            runstat_ok = 0;
            msg_buf[0] = b;
            break;

         case MTYPE_SONG_SELECT:
         case MTYPE_TUNE_REQ:          // Ignore, don't stop
            break;                     // running status

         case MTYPE_UNDEF_F4:
         case MTYPE_UNDEF_F5:
         case MTYPE_EOX:
         case MTYPE_MTC:
            runstat_ok = 0;             /* block passing these messages */
            state = 0;
            break;

        } /* switch */
      } /* status byte */
   return FALSE;
}



/*                                      ---------------------------- dispatch -
** We now have a complete message in msg_buf.
*/
void dispatch (void)
{
   if (!sysex_state)
      {
      /* extract channel of message */
      mchan = (BYTE) (msg_buf[0] & (BYTE) 0x0F);
      //PrintfOut("Dispatch: msg_buf= %0x %0x %0x",
      //          msg_buf[0],msg_buf[1], msg_buf[2]);
      }
   else
      {
      /* extract channel of message */
      mchan = (BYTE) (sysex_buf[0] & (BYTE) 0x0F);
      //PrintfOut("Dispatch: sysex_buf= %0x %0x %0x",sysex_buf[0],sysex_buf[1],
      //          sysex_buf[2]);
      }

   // Note: if fDisableFMSynth is true, we still need to parse the sysex
   // timing message.

   ///AssertF(load_ok && sapiEnabled);
   switch (type)
      {
      case MTYPE_NOTE_ON:
         if (fDisableFMSynth)
            return;
        if (msg_buf[2] != 0)                    /* zero velocity note-on */
           {
           #ifdef FM_MONITOR
           //StringOut("FMPARSE:Note On");
           #endif
           if (gfMIDIOutSynthEnabled)
              do_note_on();
           break;
           }

      case MTYPE_NOTE_OFF:
         if (fDisableFMSynth)
            return;
         if (gfMIDIOutSynthEnabled)
            do_note_off();
         break;

      case MTYPE_PROGRAM:
         if (fDisableFMSynth)
            return;
         do_pgm_change();
         break;

      case MTYPE_PITCH_WHEEL:
         if (fDisableFMSynth)
            return;
         do_pitch_bend();
         break;

      case MTYPE_CONTROL:
         if (fDisableFMSynth)
            return;
         do_controller();
         break;

      case MTYPE_POLY_PRESS:
      case MTYPE_CHAN_PRESS:
         break;

      case MTYPE_SYSEX:
         re_route_sysex = 1;
         sysex_state = WAIT_OPCODE;
         //StringOut("Waiting for Sysex Opcode");
         if ((sysex_buf[SX_RECIPIENT1]== Voyetra_sysex_header[SX_RECIPIENT1]) &&
             (sysex_buf[SX_RECIPIENT2]== Voyetra_sysex_header[SX_RECIPIENT2]) &&
             (sysex_buf[SX_RECIPIENT3]== Voyetra_sysex_header[SX_RECIPIENT3]))
            sysex_recipient=RX_VOYETRA;
         else
            if ((sysex_buf[SX_RECIPIENT1]== IBM_sysex_header[SX_RECIPIENT1]) &&
                (sysex_buf[SX_RECIPIENT2]== IBM_sysex_header[SX_RECIPIENT2]) &&
                (sysex_buf[SX_RECIPIENT3]== IBM_sysex_header[SX_RECIPIENT3]))
               sysex_recipient=RX_IBM;
            else
               {
               #ifdef DEBUG_CHK
               StringOut("FOREIGN SYSEX!");
               #endif
               reset_deal();
               }

         break;
      }
   return;
}


/************************ SYSEX ROUTINES ******************/


/*                                      ------------------------ check_format -
** looks at mesage buffer to determine if sysex is for us
** returns 0 if for us
*/
static int check_format (void)
{
   int format;

   // look at the top bits (they determine inst)
   // if the format is not for us, return error

   format = msg_buf[SX_OPCODE] & 0xfc;
   return format != THIS_FORMAT;
}

/*                                      -------------------------- sysex_deal -
** Deal with sysex bytes.  Header is already parsed, so first byte
** we will see at this point is the opcode
*/
BOOL near sysex_deal (BYTE x)
{
   BYTE bTemp;
   int  i;

   if (x & 0x80)                                                                /* got a status byte */
      {
      if (sysex_state == ACCEPT_DATA)
         {
         for (i = 0; i < MAX_NUMBER_OF_OPERATORS; i++)
            {
            if (last_pgm[i] == sysex_buf[5])
               last_pgm[i] = (char)0xFF; /* force reload of pgm for these operators */
            }
         reset_deal();          /* start midi parser over */
         midi_deal(x);          /* don't lose this byte (may not be f7) */
         }
      }

   else
      switch (sysex_state)
         {
         case WAIT_OPCODE:
            sysex_buf[SX_OPCODE] = (char)x;
            if (sysex_recipient==RX_VOYETRA)
               sysex_state = WAIT_PGM;
            else     // must be IBM
               {
               switch (sysex_buf[SX_OPCODE])
                  {
                  case OP_IBM_TIMING_COMPRESSION_LONG:
                     sysex_state = WAIT_TIMING_LONG;
                     sysex_count = 0;
                     break;

                  case OP_IBM_DEVICE_DRIVER_CONTROL:
                     #ifdef MIDI_MONITOR
                     StringOut("Awaiting Command Data");
                     #endif
                     sysex_state = WAIT_COMMAND;
                     sysex_count =0;
                     break;

                  default:
                     if (sysex_buf[SX_OPCODE] >= OP_IBM_TIMING_COMPRESSION_SHORT)
                        {
                        ulTimingDelay+= (ULONG) (sysex_buf[SX_TIMING_SHORT] & 0x7f);
                        #ifdef MIDI_MONITOR
                        PrintfOut("sdelay=%ld", ulTimingDelay);
                        #endif
                        reset_deal();
                        return TRUE;         // as if an 0xF8 happened
                        }
                     else
                        {
                        #ifdef DEBUG_CHK
                        StringOut("unsupported opcode");
                        #endif
                        ;
                        }
                     break;
                  }

               }
            break;

         case WAIT_COMMAND:
            sysex_buf[SX_COMMAND+sysex_count] = (char)x;
            sysex_count++;
            switch(sysex_buf[SX_COMMAND])
               {
               case SX_CMD_TIMING:
                  if (sysex_count==3)
                     {
                     PSTREAM pStream;
                     pStream=GetActiveMIDIStream();
                     bTemp=sysex_buf[SX_COMMAND+2];
                     #ifdef MIDI_MONITOR
                     PrintfOut("Sysex Timing Generation value 0x%x",bTemp);
                     #endif
                     if ((bTemp & 0x40) ==0)  // multiply
                        {
                        if (pStream)
                           pStream->usPPQN=((WORD)(bTemp & 0x3f)+1)*24;
                        #ifdef MIDI_MONITOR
                        PrintfOut("Multiplying 24 by %d yields %d",(bTemp&0x3f)+1, pStream->usPPQN);
                        #endif
                        }
                     else     // divide
                        {
                        if (pStream)
                           {
                           pStream->usPPQN= ((24 <<3)/((WORD)((bTemp & 0x3f)+1)*3 ))>>3;
                           if (pStream->usPPQN == 0)
                              pStream->usPPQN=1;   // Haximus Maximus, don't handle fractions
                           }

                        #ifdef MIDI_MONITOR
                        if (pStream)
                           PrintfOut("Dividing 24 by %d yields %d",((bTemp&0x3f)+1)*3, pStream->usPPQN);
                        #endif
                        }
                     if (pStream)
                        {
                        StopMIDIInterrupts();
                        StartMIDIInterrupts(pStream);
                        }
                     reset_deal();
                     }
                  break;

               case SX_CMD_TEMPO:
                  if (sysex_count==4)
                     {
                     PSTREAM pStream;
                     BYTE bLSB=*((BYTE *) (&sysex_buf[SX_COMMAND] +1));
                     BYTE bMSB=*((BYTE *) (&sysex_buf[SX_COMMAND] +2));
                     pStream=GetActiveMIDIStream();
                     if (pStream)
                        pStream->ulTempo= ((WORD) bMSB<<7)+bLSB;

                     #ifdef MIDI_MONITOR
                     if (pStream)
                        PrintfOut("Tempo Set to %ld (LSB=%x, MSB=%x)",pStream->ulTempo,bLSB,bMSB);
                     #endif
                     // note, not handling duration for tempo fade.

                     if (pStream)
                        {
                        StopMIDIInterrupts();
                        StartMIDIInterrupts(pStream);
                        }
                     reset_deal();
                     }
                  break;


               case SX_CMD_SOUND_SELECT:
                  #ifdef MIDI_MONITOR
                  StringOut("Ignoring Sound Select");
                  #endif
                  reset_deal();                                                 /* start midi parser over */
                  break;
               case SX_CMD_VOLUME:
                  #ifdef MIDI_MONITOR
                  StringOut("Ignoring Volume Setting");
                  #endif
                  reset_deal();                                                 /* start midi parser over */
                  break;
               case SX_CMD_BALANCE:
                  #ifdef MIDI_MONITOR
                  StringOut("Ignoring Balance Setting");
                  #endif
                  reset_deal();                                                 /* start midi parser over */
                  break;
               case SX_CMD_MASTER_VOLUME:
                  #ifdef MIDI_MONITOR
                  StringOut("Ignoring Master Volume Setting");
                  #endif
                  reset_deal();                                                 /* start midi parser over */
                  break;

               default:
                  #ifdef MIDI_MONITOR
                  StringOut("Ignoring Unknown IBM Sysex Command");
                  #endif
                  reset_deal();                                                 /* start midi parser over */
                  break;

               }
            break;

         case WAIT_TIMING_LONG:
            sysex_buf[SX_TIMING_LONG_LSB+sysex_count] = x;
            sysex_count++;
            if (sysex_count==2)
               {
               //PrintfOut("long lsb =%d", sysex_buf[SX_TIMING_LONG_LSB]);
               //PrintfOut("long msb =%d", sysex_buf[SX_TIMING_LONG_MSB]);
               ulTimingDelay+=(((long)sysex_buf[SX_TIMING_LONG_MSB])<<7);
               ulTimingDelay+=sysex_buf[SX_TIMING_LONG_LSB];
               //PrintfOut("long delay=%ld", ulTimingDelay);
               reset_deal();
               return TRUE;         // as if an F8 happened
               }
            break;

#ifdef VOYETRA_SYSEX
         case WAIT_PGM:                                 /* if we're waiting for pgm number */
            sysex_buf[SX_PGM_NUM] = (char) x;                            /* then here it is */
            if (check_format())
               reset_deal();
            else
               {
               if (sysex_buf[SX_OPCODE] & SX_DUMP)
                       {
                       sysex_state = ACCEPT_DATA;
                       if (sysex_buf[SX_OPCODE] & SX_COMPRESSED)
                          sysex_ptrp = internal_patches[x];
                       else
                     sysex_ptrp = expand_buf;
                       }
               else
                       {
                       sysex_state = XMIT_HEADER;
                       Voyetra_sysex_header[SX_OPCODE] = THIS_FORMAT | SX_DUMP;
                       if (check_format())
                     reset_deal();

                       if (sysex_buf[SX_OPCODE] & SX_COMPRESSED)
                          Voyetra_sysex_header[SX_OPCODE] |= SX_COMPRESSED;
                       else
                         expand_patch( x );
                       sysex_ptrp = Voyetra_sysex_header;                                       /* point at either header or data */
                       }
               }
            sysex_count = 0;
            if (x >= NUMBER_OF_BUILT_IN_VOICES)
              reset_deal();
            else
               if (sysex_state == XMIT_HEADER)
               {
                Voyetra_sysex_header[SX_PGM_NUM] = (char) x;                            /* insert requested pgm number into header we'll send */
                get_enable(1);                                                  /* enable trapping of vp_get */
               }
            break;

         case ACCEPT_DATA:
            if (sysex_count & 1)
                {
                nyb_save |= (x & 0xf);                                  /* odd - or in the low nybble and store */
                if (sysex_buf[SX_OPCODE] & SX_COMPRESSED)
                       {
                       if (sysex_count < (2 * PATCH_LENGTH))
                         *sysex_ptrp++ = (char) nyb_save;                       /* (prevent overflow) */
                       }
                else
                  if (sysex_count < (2 * OLD_PATCH_LENGTH))
                        *sysex_ptrp++ = (char) nyb_save;
               }
            else
                    {
                    nyb_save = x << 4;                                  /* even - save in top half, wait for low part */
                    }
            sysex_count++;

           if (sysex_count == (2 * OLD_PATCH_LENGTH))
                    compress_patch(sysex_buf[SX_PGM_NUM]);
            break;
#endif

         }
   return FALSE;
}

//#if 0
///* vp_get_byte()
// *      Return the next byte in the patch - called when vp_get intercepted ; see get_enable()
// */
//int  vp_get_byte()
//{
//   int  ret;
//
//   if (sysex_state == XMIT_HEADER)
//      {
//      ret = *sysex_ptrp++;
//      if (++sysex_count >= SX_HEADER_SIZE)
//              {
//              if (msg_buf[SX_OPCODE] & SX_COMPRESSED)
//                 sysex_ptrp = internal_patches[msg_buf[SX_PGM_NUM]];
//              else
//                 sysex_ptrp = expand_buf;
//              sysex_state = XMIT_PATCH;
//        }
//      }
//   else
//      if (sysex_state == XMIT_PATCH)
//         {
//         if (msg_buf[SX_OPCODE] & SX_COMPRESSED)
//                 {
//                 if (sysex_count < (SX_HEADER_SIZE + 2 * PATCH_LENGTH))
//                    if (sysex_count & 1)
//                            ret = *sysex_ptrp++;
//                    else
//                            ret = *sysex_ptrp >> 4;
//
//                 if (++sysex_count >= (SX_HEADER_SIZE + 2 * PATCH_LENGTH))
//                    sysex_state = XMIT_EOX;
//                 }
//         else
//                 {
//                 if (sysex_count < (SX_HEADER_SIZE + 2 * OLD_PATCH_LENGTH))
//                    if (sysex_count & 1)
//                         ret = *sysex_ptrp++;                                   /* odd - send low byte & increment ptr */
//                    else
//                         ret = *sysex_ptrp >> 4;                                        /* even - send high bybble */
//
//                 if (++sysex_count >= (SX_HEADER_SIZE + 2 * OLD_PATCH_LENGTH))
//                    {
//                    sysex_state = XMIT_EOX;
//                    }
//                 }
//         ret &= 0xf;                                                            /* four bits only! */
//         }
//      else
//         if ((sysex_state == XMIT_EOX)||(sysex_state == 0))
//            {
//            ret = 0xf7;
//            get_enable(0);
//            reset_deal();
//            }
//return(ret);
//}
//#endif


/*------------------------------------------------------------------------*/


/*   static int pitch_to_drum(int pitch)
 *
 * accepts a midi pitch, returns a drum define (for Adlib)
 */
int pitch_to_drum(int pitch)
{
   signed int vx = -1;                                          // assume no drum
   if (pitch >= MIN_DRUM_PITCH && pitch <= MAX_DRUM_PITCH)              // if in range of pitches  that our table spans
      {
      vx = xlate_drums[pitch - MIN_DRUM_PITCH];                 // get the drum mapped to this pitch
      if (vx == 0)                                              // voice or patch ?
              vx = pitch - (MIN_DRUM_PITCH +1) + DRUM_PATCH_OFFSET;
      }
   return vx;
}

/*----------------------------------------------------------------------*/

/* init_chan_etc()
 * This routine sets all the channel parameters to default values
 */
void init_chan_etc(void)
{
   register int i;

   for (i = 0; i < NUMBER_OF_CHANNELS; i++)
      {
      channel_stats[i].program = init_pgms[i];
      channel_stats[i].volume = (char) 0x7f;
      channel_stats[i].bender = MID_PITCH;
      channel_stats[i].sus_pedal = 0;
      channel_stats[i].pan = 64;
      coarse_tuning[i] = 0;
      fine_tuning[i] = 0;                               // new pitch bend vars
      cur_bender[i] = 0;                                // hold the final LONG
      }
   for (i = 0; i < MAX_NUMBER_OF_OPERATORS; i++)
      {
      //last_bend[i] = 0x0000;          this value is now scaled around 0
      last_pgm[i] = (char) 0xff;
      }
}


/*                                      -------------------------- get_enable -
** Called from the midi parser when a valid Sysex dump request has
** been received. in DOS this function would hook Vapi MIDI in
** here it sets a flag to be checked by poll_dump()
*/
void get_enable (int flag)
{
   dump_to_do = flag;
}
