/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Voyetra Technologies, 1990-1993                             */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*     Voyetra Technologies
*     5 Odell Plaza
*     Yonkers, NY 10701
*     Tel: 914-966-0600
*******************************************************************************
*
* fmmain.c - LibMain - Start Up and Config Code **
*
*/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include <meerror.h>
#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "cdevhlp.h"
#include "pasdef.h"
#include "findpas.h"
#include "proto.h"
#include "debug.h"
#include "commdbg.h"
#include "globals.h"

// Voyetra includes
#include "parse.cdf"
#include "adlib.h"
#include "parse.ext"
#include "vapi.h"
#include "opl3.h"


/* Defines
*/
#define         MSG1    (DEBUG && 0)


/* Variables
*/
int load_ok;


/* Functions
*/
static int AscToHex (LPSTR lpsz);
static int AscToHexChar (char x);
extern int FAR PASCAL int7f_routine ();
extern void adjust_fm_addr (void);

char STR_DCH[] = "DrumChannel";

#include "heading.h"

char STR_PORT[] = "port";
char STR_INIFILE[] = "system.ini";

//#define GetBend() GetPrivateProfileInt((LPSTR)heading, "Bend", 2, STR_INIFILE)
//#define GetDrumCh() GetPrivateProfileInt((LPSTR)heading, STR_DCH, DEF_PERCUSSION_CHANNEL + 1, STR_INIFILE)
//#define GetAddr() GetPrivateProfileString((LPSTR)heading, STR_PORT, def, lpsz, 5, STR_INIFILE)
//#define GetPath() GetPrivateProfileString((LPSTR)heading, STR_PATCH, def, patch_path, 64, STR_INIFILE)


/*                                      ------------------------------ FMInit -
** SapiMain
**         Synth Driver initialization function
*/
BOOL FMInit()
{
   int  bend;
   BOOL  fRet=TRUE;

   // percussion_channel = GetDrumCh() -1;
   percussion_channel = 10-1;
   bend = 2;
   // bend = GetBend();

   sapi_pitch_range = (int) min (max (bend,1),12);
   ////sapi_pitch_range=1;  //fake_out for compile

   if (fRet)
      {
      #ifdef FM_MONITOR
      StringOut("FMMAIN:Reset OPL-3");
      #endif

      BoardInstalled();

      #ifdef FM_MONITOR
      StringOut("FMMAIN:Reset OPL-3 OK");
      #endif
      }
   load_ok = TRUE;
   sapiEnable();

return (load_ok);
}
/******************* SOME WIN 3.1 FUNCTIONS ******************/
////int read_MIDI_bank(void);

/* BOOL sapiEnable(void)
*/
BOOL sapiEnable(void)
{
   // if (!load_ok)
   //    return FALSE;
   reset_all();
   sapiInit = TRUE;
   sapiEnabled = TRUE;
   // read_MIDI_bank();
   return TRUE;
}

/* BOOL sapiDisable(void)
 */
BOOL sapiDisable(void)
{
   if (sapiInit)
      do_reset(0);
   sapiEnabled = 0;
   reset_close();
   return 1;
}

static void clear_pgms(void)
{
   int i;

   for (i=0; i < MAX_NUMBER_OF_OPERATORS; i++)
      last_pgm[i] = (char) 0xff;
}


/*                                      ---------------------------- do_reset -
** Main reset module.  Initialize the module.
** Flag true means cold init.
*/
void do_reset(int first)
{
   shut_off_all();                      // shut off any notes which are playing
   init_q();                            // reset note queue vars
   reset_deal();                        // reset midi parser
   clear_pgms();
   if (first)
      {
      init_chan_etc();                  // initialize channel stat structure
      SoundColdInit();
      set_pitch_range(sapi_pitch_range);
      }
}


/*                                      -------------------------- reset_all -
** Initialize entire module : cold
*/
void reset_all(void)
{
   max_melo_voice = MAX_PERC_MODE_VX;
   fm_mode = MODE_PERC;
   num_slots = NUM_SLOTS_CHIP;
   number_of_operators = NUMBER_OF_OPERATORS_CHIP; // make sure these are ok
                                                   // 9/9/91
   do_reset(1);
   SetOplMode(fm_mode == MODE_PERC);               // 9/23/91 bgf
}
