;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; findpas.inc
;
;******************************************************************************

MAXCARDS                      equ       5

;;
;; THESE EQUATES FOR CAPABILITIES FILED
;;


NOCD_INTERFACE                equ       0000h
MITSUMI_INTERFACE             equ       0001h
SONY_INTERFACE                equ       0002h
SCSI_INTERFACE                equ       0003h
ENHANCED_SCSI                 equ       0004h
DAC_16                        equ       0008h
OPL_3                         equ       0010h
MIXER_508                     equ       0020h
DUAL_DAC                      equ       0040h
HAS_MPU401                    equ       0080h           ; MPU 401 (might not be enabled)
BUS_SLOT_16                   equ       0100h
MCA_CARD                      equ       0200h
CDPC                          equ       0400h           ; CDPC
HAS_SB                        equ       0800h           ; SoundBlaster (might not be enabled)
SCSI_IO_16                    equ       1000h           ; word I/O capable
DID_HW_INIT                   equ       8000h           ; board just awoke

PAS_VERSION_1                 equ       0000h           ; original
PAS_2                         equ       0001h           ; Pro Audio Spectrum Plus with SCSI
PAS_SIXTEEN                   equ       0001h           ; Pro Audio Spectrum 16   with SCSI
PAS_CDPC                      equ       0007h           ; CDPC 05/06/92 mmq

NO_PAS_INSTALLED              equ       0000h           ; can't find board
DEFAULT_BASE                  equ       0388h           ; default base I/O address of Pro AudioSpectrum

;;;; THESE ARE BASE REGISTER EQUATES

MIXER_508_REG                 equ       0078bh  ; Mixer 508
SERIAL_MIXER                  equ       00b88h  ; for Pas 1 and Pas 8
FEATURE_ENABLE                equ       00b88h  ; for Pas 16 boards only
INTERRUPT_CTRL_REG            equ       00b8bh
TIMEOUT_COUNTER               equ       04388h
TIMEOUT_STATUS                equ       04389h
ENHANCED_SCSI_DETECT_REG      equ       07f89h
PAS_2_WAKE_UP_REG             equ       09a01h  ; aka Master Address Pointer
PAS_CONFIG_REG                equ       08388h
SYSTEM_CONFIG_1               equ       08388h
SYSTEM_CONFIG_2               equ       08389h
SYSTEM_CONFIG_3               equ       0838ah
SYSTEM_CONFIG_4               equ       0838bh
WAIT_STATE                    equ       0bf88h
PRESCALE_DIVIDER              equ       0bf8Ah
SLAVE_MODE_READ               equ       0ef8bh  ; bits D0-D1
IO_PORT_CONFIG_1              equ       0f388h
IO_PORT_CONFIG_2              equ       0f389h
IO_PORT_CONFIG_3              equ       0f38ah
COMPATIBLE_REGISTER_ENABLE    equ       0f788h  ; SB and MPU emulation
EMULATION_ADDRESS_POINTER     equ       0f789h  ; D0-D3 is SB; D4-D7 is MPU
MASTER_MODE_READ              equ       0ff8bh  ; aka Master Address Pointer

;;; BIT FIELDS FOR COMPATIBLE_REGISTER_ENABLE
MPU_ENABLE_BIT          equ     1
SB_ENABLE_BIT           equ     2

;; these version numbers are found in 0B8Bh
BOARD_REV_MASK  equ 07h
VERSION_PAS_1   equ 0
VERSION_PAS_2   equ 1
VERSION_CDPC    equ 7                   ;; 05/06/92 mmq

NO_INTERFACE    equ 0
MITSUMI_TYPE    equ 1
SONY_TYPE       equ 2
SCSI_TYPE       equ 3

FoundInfo STRUC
REV     DW      0       ;; Board Rev: XHML; X=don't care;H=Slave rev; Master rev; Board rev
CAPS    DD      0       ;; Bit field showing hardware capabilities
PROPORT DW      0       ;; Pro Audio Spectrum I/O Base Address
PRODMA  DB      0       ;; Pro Audio Spectrum DAC DMA channel
PROIRQ  DB      0       ;; Pro Audio Spectrum multiplexed IRQ channel
SBPORT  DW      0       ;; Sound Blaster I/O Base Address
SBDMA   DB      0       ;; Sound Blaster DAC DMA channel
SBIRQ   DB      0       ;; Sound Blaster DAC IRQ channel
MPUPORT DW      0       ;; MPU-401 I/O base address
MPUIRQ  DB      0       ;; MPU-401 IRQ channel
CDIRQ   DB      0       ;; CD-ROM interface IRQ channel
RESERVEDW DW    0
RESERVEDB1 DB   0
RESERVEDB2 DB   0
FoundInfo ENDS

O_REV           EQU     0
O_CAPS          EQU     2
O_PROPORT       EQU     6
O_PRODMA        EQU     8
O_PROIRQ        EQU     9
O_SBPORT        EQU    10
O_SBDMA         EQU    12
O_SBIRQ         EQU    13
O_MPUPORT       EQU    14
O_MPUIRQ        EQU    16
O_CDIRQ         EQU    17
O_RESERVEDW     EQU    18
O_RESERVEDB1    EQU    20
O_RESERVEDB2    EQU    21


PROFILE STRUC
NumFound   DW   0
FoundArray DB   ((SIZE FoundInfo)*MAXCARDS) DUP (0)
PROFILE ENDS

PROFILESIZE     EQU     24

O_NUMFOUND      EQU     0
O_FOUNDARRAY    EQU     2

;;; BIT FIELDS FOR FEATURE_ENABLE (0xb88)
PCM_FEATURE_ENABLE      equ     1
FM_FEATURE_ENABLE       equ     2
MIXER_FEATURE_ENABLE    equ     4
SB_FEATURE_ENABLE       equ     8


;;; BIT FIELDS FOR SYSCONFIG1 (0x8388)

SC1_PCSPKR_ENABLE       equ     1
SC1_ALTERNATE_CLOCK     equ     4
