/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* findpas.h
*
******************************************************************************/

#include "types.h"

#define MAXCARDS                5

char *File_select( char *, char * );
typedef unsigned long DWORD;
typedef struct
   {
   WORD   wBoardRev;
   WORD   wChipRev;
   union
      {
      struct
         {
         unsigned long CDInterfaceType:2;
         unsigned long EnhancedSCSI:1;
         unsigned long DAC16:1;
         unsigned long OPL_3:1;
         unsigned long Mixer_508:1;
         unsigned long DualDAC:1;
         unsigned long _MPU401:1;
         unsigned long Slot16:1;
         unsigned long MCA:1;
         unsigned long CDPC:1;
         unsigned long SoundBlaster:1;
         unsigned long SCSI_IO_16:1;
         unsigned long reserved:2;
         unsigned long Did_HW_Init:1;
         unsigned long unused:16;
         } CapsBits;
      DWORD dwCaps;
      } Caps;
   WORD  ProPort;
   BYTE  ProDMA;
   BYTE  ProIRQ;
   WORD  SBPort;
   BYTE  SBDMA;
   BYTE  SBIRQ;
   WORD  MPUPort;
   BYTE  MPUIRQ;
   BYTE  CDIRQ;
   WORD  wTranslateCode;
   BYTE  ReservedB1;
   BYTE  ReservedB2;
   } FOUNDINFO;

typedef struct
   {
   WORD    wNumFound;
   FOUNDINFO ProCard[5];
   } PROFILE;

typedef PROFILE _far *pPROFILE;

extern WORD GetProTable( pPROFILE pPf );
extern BOOL VerifyLegalAddress(WORD wPort);
extern WORD request_locations[MAXCARDS];


// these version numbers are found in 0B8Bh
#define PAS_VERSION_1           0x000           // original
#define PAS_PLUS                0x001           // Pro Audio Spectrum Plus with SCSI
#define PAS_SIXTEEN             0x001           // Pro Audio Spectrum 16
#define PAS_STUDIO              0x003           // Pro Audio Studio 16
#define PAS_CDPC_LC				  0x004		      // aka Memphis
#define PAS_BASIC					  0x005		      // PAS Basic w/508-B mixer
#define PAS_CDPC                0x007           // CDPC 05/06/92 mmq
#define BOARD_REV_MASK             07


#define  CHIP_REV_B             0x002
#define  CHIP_REV_C             0x003    // does this exist?
#define  CHIP_REV_D             0x004


#define NO_PAS_INSTALLED        0x000           // can't find board

// CD interface type definitions
#define NO_INTERFACE     0
#define MITSUMI_TYPE     1      // may also mean LMSI?
#define SONY_TYPE        2
#define SCSI_TYPE        3
