;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; endsegs.asm - Define labels to mark end of data and code segments
;
; To allow segment truncation after initialization, PDDs set two variables
; in their init command request packet to mark the ending segment offsets.
; As this device driver is written primarily in 'C', some additional
; considerations are necessary regarding marking the end of data segment.
;
; For executable code (_TEXT segment), this is no problem.  C code or
; assembler, everything works smoothly.
; Data on the other hand is a bit more complicated.
; In normal cases, variables in the last .OBJ files listed to the linker
; wind up at the end of the data segment.
;
; The C compiler generates three data segments for each file is compiles.
; Where variables land depends on their initialization and other criteria.
; The three segments are: _DATA, CONST and _BSS
;
; During the link processing, the linker combines the 3 data segments into
; one data segment.  The trick is to get your variables placed into the
; proper segment before the linker gets hold.
; I couldn't figure a way to do this in C code, but it is easy in assembler.
; So, this file - which marks the end of the data segment - is in assembler.
; For completeness, the file also defines a label at the end of the code
; segment.  Both are referenced from C code during device driver initialization
;
; MODIFICATION HISTORY:
; DATE      CHANGE DESCRIPTION
; 08/05/93  Initial creation, function previously in audiodat.c and initc.c
; 09/21/93  Header modifications
;******************************************************************************
        .286

_TEXT   SEGMENT  WORD PUBLIC 'CODE'
        PUBLIC _EndOfCode
_EndOfCode PROC NEAR
_EndOfCode ENDP
_TEXT   ENDS

CONST   SEGMENT  WORD PUBLIC 'CONST'    ; Of the 3 C compiler created data
        PUBLIC _EndOfData               ; segments, CONST gets linked last.
_EndOfData dw 0
CONST   ENDS

        END
