/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Voyetra Technologies, 1990-1993                             */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*     Voyetra Technologies
*     5 Odell Plaza
*     Yonkers, NY 10701
*     Tel: 914-966-0600
*******************************************************************************
*
* do.c - execute midi msgs
*
*/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include <meerror.h>
#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "parse.cdf"
#include "findpas.h"
#include "pasdef.h"
#include "globals.h"
#include        "adlib.h"
#include        "parse.ext"
#include        "proto.h"

/******************* Misc. declarations and defines ****************/

int percussion_channel = DEF_PERCUSSION_CHANNEL;

static void near set_normalized_voice_volume(int voice, int vel, int chan);

static long the_bend_val;
        /* when a midi message affects all voices playing on a channel */
        /* the driver calls for_all_ops_on_channel() and hands pointer */
        /* to a function to be called for each operator. (the little guys) */
static void do_handle_pitch_bend(int op);               // the little guy


/****************** data and function protos for FM cards *******/

signed char coarse_tuning[NUMBER_OF_CHANNELS];  // registered paremeters
int fine_tuning[NUMBER_OF_CHANNELS];
long cur_bender[NUMBER_OF_CHANNELS];            // big Global var for easy VIBRO_POLL

/* void cur_bend_sub()
 *      Sums up all the Pitch Bend inputs into cur_bender[]
 */
static void cur_bend_sub(void)
{
cur_bender[mchan] = (long)adlib_pitch_range_step
        * (signed)(channel_stats[mchan].bender - MID_PITCH)
        + (long)fine_tuning[mchan] * NR_STEP_PITCH;
}
extern char internal_patches[NUMBER_OF_BUILT_IN_VOICES][PATCH_LENGTH];

/******************************************************************/
/**                                                              **/
/*******************    BIG BLOCK OF FM STUFF     *****************/
/*      In this module and in ASSIGN.C, an operator is a voice   */
/*      In ADLIB.C a voice is 2 (or 4) operators in the FM chip  */
/**                                                             **/
/*****************************************************************/


/* do_note_on()
 *      Handle a note ON event, implements DRUM CHANNEL
 *      allocates a voice with routines in ASSIGN.C
 *      and uses functions to load FM data int the chip like
            set_normalized_voice_volume()   NoteOn();
            set_pitch_of_this_voice()  and  update_pgm();
 */
void do_note_on(void)
{
   long bend;
   int  pitch, virt_chan = mchan;
   BYTE pgm;

   pitch = msg_buf[1] + coarse_tuning[virt_chan];

   if (percussion && virt_chan ==  PERCUSSION_CHANNEL)
       {
       int vx = pitch_to_drum(pitch);                                   // map to drum type (if any)
       if (vx >= 0)                                                     // if there is one
        {
        if (vx >= DRUM_PATCH_OFFSET)
                 {
                 add_q2(pitch, virt_chan, &gop);
            gop += MAX_PERC_MODE_VX +1;
                 if (last_pgm[gop] != (unsigned char )vx)                               /* if we need to send new dynamic pgm */
                         update_drum_pgm(vx);
           if (last_bend[gop] != 0)                                     /* if it's different */
                         set_pitch_of_this_voice(gop, (last_bend[gop] = 0));
            set_normalized_voice_volume(gop, msg_buf[2], virt_chan);
            NoteOn(gop, -1);                    // lookup in adlib.c
                 }
         else
                 {
                 set_normalized_voice_volume( vx, msg_buf[2], virt_chan );      /* make drums touch-sensitive */
            #ifdef FM_MONITOR
            StringOut("DO: Note On");
            #endif
                 NoteOn( vx, MY_BEST_BD_PITCH );
                 }
         }
      }
   else                                                                 /* melodic voice */
      {
      add_q(pitch, virt_chan, &gop);                                    /* update assignment list */
         {
         pgm = channel_stats[virt_chan].program;                                /* this is the program we need in there */
         if (last_pgm[gop] != pgm)                                              /* if we need to send new dynamic pgm */
                 update_pgm(pgm, virt_chan);
         }
      bend = calc_pitch(virt_chan);                                     /* current bender activity on channel */
      if (last_bend[gop] != bend)                                               /* if it's different */
              set_pitch_of_this_voice(gop, (last_bend[gop] = bend));
      set_normalized_voice_volume(gop, msg_buf[2], virt_chan);          /* always use Note on velocity */
      NoteOn(gop, pitch);
      }
}

/*************************** the following block of code is for FM ******************/

/* update_pgm()
 *      put a patch into a voice in the chip
 *      here a slot is a real operator in the chip
 *      last_pgm[] is used to save reloading patches
 */
void update_pgm(int pgm, int virt_chan)
{
   char * pdata;
   pdata = internal_patches[pgm];

   set_a_param_in_a_slot(voice_slot_map[gop][0], pdata);
   pdata += nbLocParam;
   set_a_param_in_a_slot(voice_slot_map[gop][1], pdata);
   pdata += nbLocParam;
   set_a_param_in_a_slot(voice_slot_map[gop][2], pdata);
   pdata += nbLocParam;
   set_a_param_in_a_slot(voice_slot_map[gop][3], pdata);
   last_pgm[gop] = (char) pgm;
}


/* update_drum_pgm()
 *      put a 2op drum patch into a voice in the chip
 *      here a slot is a real operator in the chip
 */
void update_drum_pgm(int pgm)
{
   char * pdata;

   pdata = internal_drums[pgm - DRUM_PATCH_OFFSET];
   set_a_param_in_a_slot(voice_slot_map[gop][0], pdata);
   pdata += nbLocParam;
   set_a_param_in_a_slot(voice_slot_map[gop][1], pdata);
   last_pgm[gop] = (char) pgm;
}

/************************* the non-asc version of do_note_off follows *************/

/* do_note_off()
 *      Handle a note OFF event, de-allocates the voice, lets the chip release
 */
void do_note_off()
{
   int  pitch;
   int  virt_chan = mchan;

   pitch = msg_buf[1] + coarse_tuning[virt_chan];

   if (percussion && virt_chan == PERCUSSION_CHANNEL)
      {
      int vx = pitch_to_drum(pitch);
      if (vx >= 0)
              {
              if (vx >= DRUM_PATCH_OFFSET)
                 {
              if (remove_target2(pitch, virt_chan, &gop))
                   NoteOff(gop + MAX_PERC_MODE_VX +1, 0);
                 }
           else
                 NoteOff(vx, 0);
              }
      }
   else
      {
      if (remove_target(pitch, virt_chan, &gop))
           NoteOff(gop, 0);
      }
}

/* do_pgm_change()
 *      Handle program changes. implements drum channel switchs
 *      sets channel_stats[] vars but not notes playing
 *      next note-on on the channel will get the new patch
 */
void do_pgm_change(void)
{
   if (
           (msg_buf[0] == (BYTE)(PERCUSSION_CHANNEL | 0xc0) ||
           (msg_buf[0] == ((16 - 1) | 0xc0)))           // catch program changes for old sapi also! (alt -d)
        && msg_buf[1] >= MIN_PGM_FOR_CTRL)              /* if program change channel 16 in the ragne for mode switch */
      {                                                                 /* 7/18/90 bgf */
      int perc;
      switch (msg_buf[1])
        {
        case 126:                                       // drum mode
                 perc = 1;                                      // no perc in this mode
                 max_melo_voice = MAX_PERC_MODE_VX;             // double the number of voices
                 num_slots = NUM_SLOTS_CHIP;
                 number_of_operators = NUMBER_OF_OPERATORS_CHIP;
                 fm_mode = MODE_PERC;
                 break;

         case 127:                                      // melod mode
                 perc = 0;                                      // no perc in this mode
              max_melo_voice = MAX_MELO_MODE_VX;                // double the number of voices
                 num_slots = NUM_SLOTS_CHIP;
                 number_of_operators = NUMBER_OF_OPERATORS_CHIP;
                 fm_mode = MODE_MELO;
                 break;
           }
      do_reset(0);
      SetOplMode(perc);
      }
   else
      {
      register int pgm = msg_buf[1];
      if (pgm < NUMBER_OF_BUILT_IN_VOICES)
              {
              channel_stats[mchan].program = (char)pgm;
              }
      }
}


/**************** The following is the FM version of the volume/pan/velocity routines *********/

static char pan_me_bits[4] = { 0x10, 0x30, 0x30, 0x20 };

/*   static void near set_normalized_voice_volume(int voice, int vel)
 *      Sum up components of the final note volume, Pan on OPL3 or Stereo FM
 * 7/30/90 to make vel work ok
 * 10/24/90 variable comp ratio
 */


static void near set_normalized_voice_volume(int voice, int vel, int chan)
{
   int temp;

   SetVoicePan_and_FB(voice, pan_me_bits[channel_stats[chan].pan >> 5]);
   temp = vel >> 1;                                     // squish the range down
   temp += channel_stats[chan].volume >> 1;             // add in the volume!
   temp &= 0x7f;        //if (temp > 127)temp = 127; // boost range back up to max
   SetVoiceVolume(voice, temp);
}

/************************** The following is the registered parameter / data entry code ************/

/*      Theese messages are nasty to parse */
static int reg_param_lsb = 0;
static int reg_param_msb = 0;
static int ready_reg = 0;
static int last_reg_val_sent = 0;

/*   void handle_data_entry(void)
 */
void
handle_data_entry(void)
{
   // set the variables, do pitch bend
   if ((ready_reg)&&(!reg_param_msb))
      switch (reg_param_lsb)
           {
              case 0: set_pitch_range(last_reg_val_sent >> 7);
           break;
              case 1: fine_tuning[mchan] = last_reg_val_sent - MID_PITCH;
           cur_bend_sub();
                 break;
         case 2: coarse_tuning[mchan] = (signed char)((last_reg_val_sent >> 7) - 64);
                 break;
         }
}


/* do_controller()
 *      Handle controller events. the Bx .. .. cases
 *      store controllers like MIDI Volume and Pan, do controller reset
 */
void do_controller()
{
   switch (msg_buf[1])
      {
      case 6: // last_reg_val_sent &= 0x007F;
              last_reg_val_sent = msg_buf[2] << 7;                      // data entry MSB
              set_it:
            handle_data_entry();
              break;

      case 38: last_reg_val_sent &= 0x3F80;
              last_reg_val_sent |= msg_buf[2];                          // data entry LSB
              goto set_it;

      case 96: last_reg_val_sent ++;
              goto set_it;
      case 97: last_reg_val_sent --;
              goto set_it;

      case 7: channel_stats[mchan].volume = msg_buf[2];         // master vol ctrl MSB
              break;
      case 10: channel_stats[mchan].pan = msg_buf[2];   // pan MSB
              break;
      case 64: if ((channel_stats[mchan].sus_pedal = msg_buf[2]) == 0)
                   {                                    // Sustain LMH 5-22-92
                   for_all_ops_on_chan(mchan, do_sus_off);
                   }
              break;
      case 98 :
      case 99 : ready_reg = 0;
                   break;
      case 100: reg_param_lsb = msg_buf[2];             // save value
                   goto set_2;
      case 101: reg_param_msb = msg_buf[2];             // save value
           set_2:       ready_reg = 1;                          // note reg or not
                   break;
      case 123: if ( msg_buf[2] == 0)                   /* handle all-notes-off */
                      for_all_ops_on_chan(mchan, shut_off_chan_voice);
              break;
      case 124:
              init_chan_etc();
              break;
      }
}


/* do_handle_pitch_bend(op)
 *      Change the pitch of operator op. the little guy called for each voice
 *      if VIBRO_POLL then mchan is used to get the bend of each voice
 *      else the bend val is the same for each voice
 */
static  void do_handle_pitch_bend(int op)
{
   set_pitch_of_this_voice(op, the_bend_val);
   last_bend[op] = the_bend_val;                // this saves time when not VIBRO_POLL ing
}

/* do_pitch_bend()
 *      Handle pitch bends, Ex nn nn messages, the big guy
 */
void do_pitch_bend(void)
{
   channel_stats[mchan].bender = (((unsigned)msg_buf[2]) << 7) + (unsigned)msg_buf[1];
   cur_bend_sub();                                      // update cur_bender[]
   the_bend_val = calc_pitch(mchan);                    /* same for each voice on chan */
   for_all_ops_on_chan(mchan, do_handle_pitch_bend);    /* update all playing voices */
}
