/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* CDEVHLP.H
*
* DISCRIPTIVE NAME: C functional prototype interface for OS/2 DevHlp
*                   services.
******************************************************************************/

USHORT DevHlp_AllocGDTSelector (ULONG ulNumGDTSelectors, PVOID paGDTSel);

USHORT DevHlp_AllocPhys (ULONG BlockSize,
                         USHORT Location,
                         PVOID  pRetAddr);

USHORT DevHlp_AttachDD (PUCHAR TargetDDname,
                        PATTACHAREA AttachDDArea);

USHORT DevHlp_EOI (USHORT IRQnum);

USHORT DevHlp_FreeGDTSelector (USHORT Selector);

USHORT NEAR DevHlp_LinToGDTSelector (USHORT Selector,
                                     ULONG LinearAddress,
                                     ULONG ByteLength);

USHORT DevHlp_Lock (USHORT Selector,
                    USHORT TypeFlag,
                    USHORT WaitFlag,
                    PVOID  pLockHandle);

USHORT DevHlp_PhysToGDTSelector (PVOID  PhysAddress,
                                 USHORT ByteLength,
                                 USHORT Selector);

PVOID  DevHlp_LinToLDTSelOff(PVOID LinAddr);

USHORT DevHlp_PhysToVirt (PVOID  PhysAddress,
                          ULONG  ByteLength,
                          PVOID  VirtAddress);

USHORT DevHlp_ProcBlock (USHORT EventIdHi,
                         USHORT EventIdLo,
                         USHORT TimeLimitHi,
                         USHORT TimeLimitLo,
                         USHORT InterruptibleFlag);

USHORT DevHlp_ProcRun (USHORT EventIdHi,
                       USHORT EventIdLo);

USHORT DevHlp_SemClear (USHORT hSemHi,
                        USHORT hSemLo);

USHORT DevHlp_SemRequest (USHORT hSemHi,
                          USHORT hSemLo,
                          USHORT SemTimeoutHi,
                          USHORT SemTimeoutLo);

USHORT DevHlp_SemHandle (USHORT hSemHi,
                         USHORT hSemLo,
                         USHORT UsageFlag);

USHORT DevHlp_SetIRQ (PVOID IRQVector,
                      USHORT IRQchannel,
                      BOOL fShared);

USHORT DevHlp_UnSetIRQ (USHORT IRQchannel);


USHORT DevHlp_VirtToLin (USHORT Selector,
                         ULONG OffsetAddress,
                         PVOID pRetLinAddress);

USHORT DevHlp_VirtToPhys (PVOID VirtAddress,
                          PVOID pRetPhysAddress);

USHORT DevHlp_VMAlloc (ULONG Flags,
                       ULONG MemSize,
                       ULONG PhysAddress,
                       PVOID pRetLinAddress,
                       PVOID pRetVirtAddress);

#define VMAlloc_BELOW_16M      (1L<<0)
#define VMAlloc_FIXED          (1L<<1)
#define VMAlloc_SWAPPABLE      (1L<<2)
#define VMAlloc_CONTIGUOUS     (1L<<3)
#define VMAlloc_LINEAR_ADDR    (1L<<4)
#define VMAlloc_PROCESS_RANGE  (1L<<5)
#define VMAlloc_SCREEN_GROUP   (1L<<6)
#define VMAlloc_SECRET_VIRTUAL (1L<<7)
#define VMAlloc_RESERVE_MEM    (1L<<8)

USHORT  DevHlp_VMFree (PVOID LinAddress);

#define VMLock_DONT_BLOCK     (1L<<0)
#define VMLock_CONTIGUOUS     (1L<<1)
#define VMLock_BELOW_16M      (1L<<2)
#define VMLock_WRITEABLE      (1L<<3)
#define VMLock_LONG_TERM      (1L<<4)
#define VMLock_VERIFY_ONLY    (1L<<5)

USHORT DevHlp_VMLock (ULONG ActionFlags,
                      ULONG LinearAddress,
                      ULONG LockLength,
                      PVOID pPageList,
                      PVOID pLockHandle);

USHORT DevHlp_VMProcessToGlobal (ULONG ActionFlags,
                                 ULONG LinearAddress,
                                 ULONG ByteLength);

USHORT DevHlp_VMUnlock (ULONG LockHandle);

USHORT DevHlp_Yield (VOID);

USHORT DevHlp_RegisterPDD (NPSZ  pszPDDName,
                           PVOID pfnPDDFunction);

/*
** ABIOS services
*/
USHORT DevHlp_GetLIDEntry (USHORT DevID,
                           USHORT RelID,
                           USHORT DevState,
                           PUSHORT LID);

USHORT DevHlp_FreeLIDEntry (USHORT LID);

USHORT DevHlp_ABIOSCall (USHORT LID,
                         NPVOID RBOffset,
                         USHORT Entry);

ULONG  DwordDivide (ULONG ulDividend, ULONG ulDivisor, USHORT usRoundUpFlg);
ULONG  DwordMult (ULONG ulMultiplicand, ULONG ulMultiplier);

SHORT set_sys_timer(USHORT);

VOID far _saveregs _loadds update_stream_times(VOID);
