;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 Pro AudioSpectrum16 Physical Device Driver
;                     Production code and toolkit sample
;
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation and Media Vision Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM and Media Vision shall not be liable for any damages arising out of
; your use of the sample code, even if they have been advised of the
; possibility of such damages.
;
;******************************************************************************
;
; cdevhlp.asm - template sample - 'C' interface for OS/2 devhelp calls
;
; The routines implemented in this file provide ability for C code
; to call OS/2 PDD DevHelp routines.
; The code translates 'C' stacked based DevHelp calls to MASM register
; based OS/2 DevHelp calls.
;
; MODIFICATION HISTORY:
; DATE      CHANGE DESCRIPTION
; 11/26/90  Original creation
; 07/28/93  Add headers for toolkit
; 09/21/93  More header modifications
;******************************************************************************

        PAGE    80,132
        .386p

        TITLE   CDEVHLP - 'C' INTERFACE FOR DEVHELP CALLS
        NAME    CDEVHLP

;******************************************************************************
;                       E Q U A T E S
;******************************************************************************
SETTIMER equ 01dh

;******************************************************************************
;                       I N C L U D E S
;******************************************************************************
.xlist
include devhlp.inc
include devsym.inc
include basemaca.inc
.list


;******************************************************************************
;                       E X T E R N S
;******************************************************************************
_DATA   SEGMENT WORD PUBLIC  USE16 'DATA'
        EXTRN   _DevHlp:DWORD
_DATA   ENDS

;******************************************************************************
;                   D A T A   D E C L A R A T I O N S
;******************************************************************************

;******************************************************************************
;                           C O D E
;******************************************************************************

_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:_TEXT

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AllocGDTSelector
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AllocGDTSelector
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document ES:DI contains locaton of array
;*               of words of GDT's.
;*
;* EXIT_ERROR: 'Carry flag set' and AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_AllocGDTSelector
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_AllocGDTSelector
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
NumGDTSelectors EQU     <[bp+4]>
paGDTSel        EQU     <[bp+8]>        ; seg:off of GDT array
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    cx
        push    dx
        push    di
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     es,WORD PTR paGDTSel+2          ; get seg.
        mov     di,WORD PTR paGDTSel            ; get off.
        mov     cx,NumGDTSelectors
        mov     dl,DevHlp_AllocGDTSelector
        call    [_DevHlp]
        jc      allocgdt
        xor     ax,ax                           ; clear for no error
allocgdt:
        pop     es
        pop     di
        pop     dx
        pop     cx
        pop     bp
        ret
EndProc _DevHlp_AllocGDTSelector

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AllocPhys
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AllocPhys
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document ax:bx = 32 bit physical addr
;*               AX = 0
;*
;* EXIT_ERROR: AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_AllocPhys
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_AllocPhys proc near
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
BytesLo         EQU     <[bp+4]>        ; memory block size
BytesHi         EQU     <[bp+6]>
Location        EQU     <[bp+8]>        ; above or below 1MB
pRetAddress     EQU     <[bp+10]>       ; 32bit address to allocated memory blk

        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    dx
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     bx,BytesLo
        mov     ax,BytesHi
        mov     dh,BYTE PTR Location            ; 0=above 1MB
        mov     dl,DevHlp_AllocPhys             ; 1=below 1MB
        call    [_DevHlp]
        jc      allocphys

        mov     dx,bx                           ; Need bx for addressing
        les     bx,pRetAddress                  ; Dereference address of
                                                ; callers variable
        mov     es:[bx+2],ax                    ; Return high 16 bits and
        mov     es:[bx],dx                      ; Low 16 bits (flat pointer)

        xor     ax,ax                           ; clear ax => no error
allocphys:
        pop     es
        pop     dx
        pop     bx
        pop     bp                              ; restore callers frame
        ret
_DevHlp_AllocPhys endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AttachDD
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AttachDD
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: seg:offset of target dd name, offset of attach area
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_AttachDD
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_AttachDD
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
TargetDDName    EQU     <[bp+4]>        ; get offset only
AttachDDArea    EQU     <[bp+8]>
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    di
        push    dx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        xor     ax,ax                           ; clear ax for return code
        mov     bx,TargetDDName
        mov     di,AttachDDArea
        mov     dl,DevHlp_AttachDD
        call    [_DevHlp]
        jc      attachdd_err
        jmp     attachdd_ok

attachdd_err:
        mov     ax,-1                           ; set error for 'C' code
        jmp     attachdd_exit

attachdd_ok:
        xor     ax,ax                           ; clear for no error
attachdd_exit:
        pop     dx
        pop     di
        pop     bx
        pop     bp
        ret
EndProc _DevHlp_AttachDD

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_EOI
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_EOI
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: seg:offset of target dd name, offset of attach area
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_EOI
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_EOI
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
IRQnum  EQU     <[bp+4]>        ; get offset only
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    dx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     al,IRQnum
        mov     dl,DevHlp_EOI
        call    [_DevHlp]

        pop     dx
        pop     bx
        pop     bp
        ret
EndProc _DevHlp_EOI



;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_LinToGDTSelector
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_LinToGDTSelector
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_LinToGDTSelector
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_LinToGDTSelector
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
Selector        EQU     <[bp+4]>        ; word
LinearAddress   EQU     <[bp+6]>        ; dword
ByteLength      EQU     <[bp+10]>       ; dword
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    ebx
        push    ecx
        push    edx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR Selector
        mov     ebx,LinearAddress
        mov     ecx,ByteLength
        mov     dl,DevHlp_LinToGDTSelector
        call    DWORD PTR [_DevHlp]      ; return error in ax if CF
        jc      LinToGDT_Err
        xor     eax,eax

LinToGDT_Err:
        pop     edx
        pop     ecx
        pop     ebx
        pop     bp
        ret
EndProc _DevHlp_LinToGDTSelector



Procedure _DevHlp_LinToLDTSelOff
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
FlatAddr        EQU     <[bp+4]>        ; dword
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame

        mov     eax,FlatAddr
        FlatToSel
        mov     dx,ax                   ; prepare return value Segment
        mov     ax,bx                   ; prepare return value offset

        pop     bp
        ret
EndProc _DevHlp_LinToLDTSelOff


;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_PhysToGDTSelector
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_PhysToGDTSelector
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: 32bit physical address, length of segment, selector to setup
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*               ptr that contained 32bit physaddrr is now a sel:off.
;*
;* EXIT_ERROR: 'C' set ax=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_PhysToGDTSelector
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_PhysToGDTSelector
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
PhysAddress     EQU     <[bp+4]>
ByteLength      EQU     <[bp+8]>
Selector        EQU     <[bp+10]>
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    cx
        push    dx
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR PhysAddress+2
        mov     bx,WORD PTR PhysAddress
        mov     cx,ByteLength
        mov     si,Selector
        mov     dl,DevHlp_PhysToGDTSelector
        call    DWORD PTR [_DevHlp]      ; return error in ax if CF
        jc      physToGDT
        xor     ax,ax
physToGDT:
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     bp
        ret
EndProc _DevHlp_PhysToGDTSelector


;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_PhysToVirt
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_PhysVirt
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document ax:bx = 32 bit physical addr
;*              AX = 0
;*
;* EXIT_ERROR: ax=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_PhysToVirt
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_PhysToVirt proc near
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
PhysAddress     EQU     <[bp+4]>        ; physical address
BlockSize       EQU     <[bp+8]>        ; block size
pRetAddress     EQU     <[bp+12]>       ; address of returned virtual pointer
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx
        push    es
        push    di
        push    ds
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR PhysAddress+2
        mov     bx,WORD PTR PhysAddress
        mov     cx,BlockSize
        xor     dh,dh                           ; set DS:SI
        mov     dl,DevHlp_PhysToVirt
        call    [_DevHlp]
        jc      physvirterr

        les     di,pRetAddress                  ; de-reference pointer
        mov     es:[di+2],ds                    ; hi word (return ds:si)
        mov     es:[di],si                      ; lo word
        xor     ax,ax                           ; clear for no error

physvirterr:
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_PhysToVirt endp



;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VMAlloc
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES: CRUISER Api
;*
;* ENTRY POINTS:  _DevHlp_VMAlloc
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VMAlloc
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_VMAlloc
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
Flags           EQU     <[bp+4]>        ;DWORD
MemSize         EQU     <[bp+8]>        ;DWORD
PhysAddress     EQU     <[bp+12]>       ;DWORD
pRetLinAddress  EQU     <[bp+16]>       ;PVOID
pRetVirtAddress EQU     <[bp+20]>       ;PVOID
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    ebx
        push    ecx
        push    edx
        push    edi

;;IFDEF   DEVHLP_DEBUG
        int     3
;;ENDIF
        mov     eax,Flags
        mov     ecx,MemSize
        mov     edi, PhysAddress
        mov     dl,DevHlp_VMAlloc
        call    [_DevHlp]               ; return error in ax if CF
        jc      VMAllocErr

        cmp     DWORD PTR pRetLinAddress,0      ; don't set if null passed in
        je      VMAllocVirt
        xor     ebx,ebx
        push    ds
        lds     bx,pRetLinAddress      ; load offset
        mov     [ebx],eax
        pop     ds
VMAllocVirt:
        test    DWORD PTR Flags,80h             ; only if Flag & bit 7
        jz      VMAllocDone
        xor     ebx,ebx
        push    ds
        lds     bx,pRetVirtAddress              ; load full ptr
        mov     [ebx],ecx                       ; uses ds to load alloc'ed ptr
        pop     ds
VMAllocDone:
        xor     eax,eax                 ; clear for no error in 'C'
VMAllocErr:
        pop     edi
        pop     edx
        pop     ecx
        pop     ebx
        pop     bp
        ret
EndProc _DevHlp_VMAlloc


;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VMLock
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES: CRUISER Api
;*
;* ENTRY POINTS:  _DevHlp_VMLock
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VMLock
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_VMLock
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
Flags           EQU     <[bp+4]>        ;DWORD
LinearAddress   EQU     <[bp+8]>        ;DWORD
LockLength      EQU     <[bp+12]>       ;DWORD
pPageList       EQU     <[bp+16]>       ;PVOID
pLockHandle     EQU     <[bp+20]>       ;PVOID

        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    ebx
        push    ecx
        push    edx
        push    esi
        push    edi

;;IFDEF   DEVHLP_DEBUG
        int     3
;;ENDIF
        mov     eax,Flags
        mov     ebx,LinearAddress
        mov     ecx,LockLength
        mov     esi, pPageList
        mov     edi, pLockHandle
        mov     dl,DevHlp_VMLock
        call    [_DevHlp]               ; return error in ax if CF
        jc      VMLockErr

        xor     eax,eax                 ; clear for no error in 'C'
VMLockErr:
        pop     edi
        pop     esi
        pop     edx
        pop     ecx
        pop     ebx
        pop     bp
        ret
EndProc _DevHlp_VMLock





;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_Lock
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES: CRUISER Api
;*
;* ENTRY POINTS:  _DevHlp_Lock
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_Lock
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_Lock
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
Selector        EQU     <[bp+4]>        ;USHORT
TypeFlag        EQU     <[bp+6]>        ;USHORT
WaitFlag        EQU     <[bp+8]>        ;USHORT
pLockHandle     EQU     <[bp+10]>       ;ULONG
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    dx
        push    di
        push    es

;;IFDEF   DEVHLP_DEBUG
        int     3
;;ENDIF
        mov     ax,Selector
        mov     bl,WaitFlag
        mov     bh,TypeFlag
        mov     dl,DevHlp_Lock
        call    [_DevHlp]               ; return error in ax if CF
        jc      LockErr

        les     di,pLockHandle
        mov     es:[di],bx
        mov     es:[di+2],ax

        xor     ax,ax                   ; clear for no error in 'C'
LockErr:
        pop     es
        pop     di
        pop     dx
        pop     bx
        pop     bp
        ret
EndProc _DevHlp_Lock






;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VMFree
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_VMFree
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VMFree
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_VMFree
        ASSUME cs:_TEXT,ds:_DATA,es:_DATA,ss:NOTHING
LinAddress      EQU     <[bp+4]>        ; PVOID
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame

        mov     ax,ds                   ; clear es, in case it contains the addr
        mov     es,ax                   ; from 'C' that is to be freed.

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     eax,DWORD PTR LinAddress
        mov     dl,DevHlp_VMFree
        call    DWORD PTR [_DevHlp]      ; return error in ax if CF
        jc      VMFreeDone
        xor     eax,eax                 ; clear for no error in 'C'
VMFreeDone:
        pop     bp
        ret
EndProc _DevHlp_VMFree

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VirtToLin
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_VirtToLin
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VirtToLin
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_VirtToLin
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
Selector        EQU     <[bp+4]>                ; word
OffsetAddress   EQU     <[bp+6]>                ; dword
pRetLinAddress  EQU     <[bp+10]>               ; pvoid
        push    bp
        mov     bp,sp                           ; allocate NULL stack frame
        push    ebx
        push    esi
        push    edx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR Selector
        or      ax,ax
        jnz     VirtLinSel
        mov     ax,_DATA
VirtLinSel:
        mov     esi,OffsetAddress
        mov     dl,DevHlp_VirtToLin
        call    DWORD PTR [_DevHlp]             ; return error in ax if CF
        jc      VirtLinErr

        xor     ebx,ebx
        push    ds
        lds     bx,pRetLinAddress               ; load full ptr
        mov     [ebx],eax
        pop     ds
        xor     eax,eax                         ; clear any 'c' error

VirtLinErr:
        pop     edx
        pop     esi
        pop     ebx
        pop     bp
        ret
EndProc _DevHlp_VirtToLin



;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VirtToPhys
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_VirtToPhys
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VirtToLin
;*
;*********************** END OF SPECIFICATIONS **********************

Procedure _DevHlp_VirtToPhys
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
VirtualAddress  EQU     <[bp+4]>                ; dword
pLinearAddress  EQU     <[bp+8]>                ; pvoid
        push    bp
        mov     bp,sp                           ; allocate NULL stack frame

        push    bx
        push    dx
        push    si
        push    di

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     dl,DevHlp_VirtToPhys
        push    ds
        lds     si,VirtualAddress
        call    DWORD PTR [_DevHlp]             ; return error in ax if CF
        pop     ds
        jnc     VirtPhysNoErr

        xor     ax,ax                           ; FFFFFFFF
        dec     ax
        mov     bx,ax
VirtPhysNoErr:
        les     di,pLinearAddress               ; load full ptr
        mov     es:[di],bx                      ; result in AX:BX
        mov     es:[di+2],ax

        cmp     ax,0ffffh
        je      @F
        xor     ax,ax                           ; return code ==0

@@:
        pop     di
        pop     si
        pop     dx
        pop     bx

        pop     bp
        ret
EndProc _DevHlp_VirtToPhys



;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_SetIRQ
;*
;* DESCRIPTIVE NAME:  Hook interrupt vector
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_SetIRQ
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: PVOID  New Interrupt Vector
;*        USHORT Interrupt number to hook
;*        BOOL   Shared Interrupt flag
;*
;* EXIT-NORMAL: AX = 0
;*
;* EXIT_ERROR:  AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_SetIRQ
;*
;* SEE ALSO: _DevHlp_SetIRQ
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_SetIRQ proc near
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
NewVector       EQU     <[bp+4]>        ; IRQ handler address (this CS assumed)
IRQchannel      EQU     <[bp+8]>        ; IRQ number to hook
fShared         EQU     <[bp+10]>       ; non-zero if shared
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx
        push    es
        push    di
        push    ds
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR NewVector
        mov     bx,WORD PTR IRQchannel
        mov     dh,fShared
        mov     dl,DevHlp_SetIRQ
        call    [_DevHlp]
        jc      setirqerr

        xor     ax,ax                           ; clear for no error
        jmp     setirqnoerr

setirqerr:
        mov     ax,-1

setirqnoerr:
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_SetIRQ endp




;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_UnSetIRQ
;*
;* DESCRIPTIVE NAME:  Hook interrupt vector
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_UnSetIRQ
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: USHORT Interrupt number to hook
;*
;* EXIT-NORMAL: AX = 0
;*
;* EXIT_ERROR:  AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_UnSetIRQ
;*
;* SEE ALSO: _DevHlp_UnSetIRQ
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_UnSetIRQ proc near
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
IRQchannel      EQU     <[bp+4]>        ; IRQ number to hook
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx
        push    es
        push    di
        push    ds
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     bx,WORD PTR IRQchannel
        mov     dl,DevHlp_UnSetIRQ
        call    [_DevHlp]
        jc      unsetirqerr

        xor     ax,ax                           ; clear for no error

unsetirqerr:
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_UnSetIRQ endp


;***************************************************************************
;* SUBROUTINE NAME: _DevHlp_GetLIDEntry
;*
;* DESCRIPTION:  Get a Logical ID
;*
;* This routine is used to obtain a Logical ID (LID) for devices that exist
;* (that is, devices that are awake).
;*
;* C PROTOCOL
;*
;*   USHORT GetLIDEntry(USHORT DeviceID,USHORT RelativeLID,USHORT DeviceState,
;*                      PUSHORT pLID);
;***************************************************************************
;*
_DevHlp_GetLIDEntry    PROC    NEAR
        PUBLIC  _DevHlp_GetLIDEntry
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
GL_DeviceID    equ        byte ptr [bp+4]
GL_RelID       equ        byte ptr [bp+6]
GL_DevState    equ        byte ptr [bp+8]
GL_pLID        equ        dword ptr [bp+10]
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx                               ; Save registers
        push    es
        push    bx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     al,GL_DeviceID                   ; DeviceID
        mov     bl,GL_RelID                      ; Relative LID
        mov     dh,GL_DevState                   ; Device State
        mov     dl,DevHlp_GetLIDEntry            ; Select function
        call    [_DevHlp]                   ; Call devhelp
        jc      gle10
        les     bx,GL_pLID                       ; Address of Var Addr
        mov     word ptr es:[bx],ax
        xor     ax,ax
gle10:
        pop     bx
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_GetLIDEntry    ENDP

;***************************************************************************
;* SUBROUTINE NAME: _DevHlp_FreeLIDEntry
;*
;* DESCRIPTION: Release a Logical ID
;*
;* This routine is used to release a Logical ID.  This must be done at
;* DEINSTALL or termination time.
;*
;* C PROTOCOL
;*
;* USHORT FreeLIDEntry(USHORT LID);
;***************************************************************************
;*
_DevHlp_FreeLIDEntry   PROC    NEAR
        PUBLIC  _DevHlp_FreeLIDEntry
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
FL_LID  equ     word ptr [bp+4]
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx                               ; Save registers

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,FL_LID                        ; LogicalID
        mov     dl,DevHlp_FreeLIDEntry           ; Select function
        call    [_DevHlp]                   ; Call devhelp
        jc      fle10
        xor     ax,ax
fle10:
        pop     dx
        pop     bp
        ret
_DevHlp_FreeLIDEntry   ENDP

;***************************************************************************
;* SUBROUTINE NAME: _DevHlp_ABIOSCall
;*
;* DESCRIPTION: Invoke ABIOS Function
;*
;* This routine is used to invoke an ABIOS service for the Operating
;* System Transfer Convention.
;*
;* C PROTOCOL
;*
;* USHORT ABIOSCall(USHORT LID, POINTER RBOffset, USHORT Entry);
;***************************************************************************
;*
_DevHlp_ABIOSCall      PROC    NEAR
        PUBLIC  _DevHlp_ABIOSCall
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
AB_LID        equ   word ptr [bp+4]
AB_RBOffset   equ   word ptr [bp+6]
AB_Entry      equ   byte ptr [bp+8]
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx                               ; Save registers
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,AB_LID                        ; LogicalID
        mov     si,AB_RBOffset                   ; RB Offset
        mov     dh,AB_Entry                      ; Entry
        mov     dl,DevHlp_ABIOSCall              ; Select function
        call    [_DevHlp]                        ; Call devhelp
        jc      abc10
        xor     ax,ax
abc10:
        pop     si
        pop     dx
        pop     bp
        ret
_DevHlp_ABIOSCall      ENDP


;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_RegisterPDD
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_RegisterPDD
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document
;*              AX = 0
;*
;* EXIT_ERROR: ax = -1
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_RegisterPDD
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_RegisterPDD proc near
        PUBLIC  _DevHlp_RegisterPDD
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
pszPDDName      EQU     <[bp+4]>        ; word
pfnPDDFunction  EQU     <[bp+6]>        ; dword
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    si
        push    dx
        push    ds
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     si,pszPDDName           ; DS:SI = ptr to ASCIIZ PDD name
        mov     es,pfnPDDFunction+2     ; ES:DI = ptr to PDD entry point
        mov     di,pfnPDDFunction
        mov     dl,DevHlp_RegisterPDD
        call    DWORD PTR [_DevHlp]     ; return error in ax if CF
        jc      RegisterPDDErr

        xor     ax, ax                  ; Success, RC = zero
        jmp     RegisterPDDDone

RegisterPDDErr:
        mov     ax,-1

RegisterPDDDone:
        pop     es
        pop     ds
        pop     dx
        pop     si
        pop     bp
        ret
_DevHlp_RegisterPDD endp





;********************* START OF SPECIFICATIONS *********************
;
; SUBROUTINE NAME: DwordDivide()
;
; DESCRIPTIVE NAME: Divide two ulongs
;
; FUNCTION: Used to convert stream time in milliseconds to stream time in mmtime, because
;           this is the format that mci expects.
;
; NOTES: This routine is called internally from  SHCSeek(), SHCGetTime(),
;
; ENTRY POINTS:
;     LINKAGE:   CALL near
;
; INPUT:
;
; EXIT-NORMAL: returns Quoient in eax
;
; EXIT_ERROR:
;
; EFFECTS:
;
; INTERNAL REFERENCES: none
;
; EXTERNAL REFERENCES: none
;
;********************** END OF SPECIFICATIONS **********************/
Procedure _DwordDivide,NEAR
        ASSUME cs:_TEXT, ds:_DATA, es:NOTHING, ss:NOTHING
ulDividend      EQU     <[bp+4]>
ulDivisor       EQU     <[bp+8]>
usRoundUpFlg    EQU     <[bp+12]>
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    ebx
        mov     eax,ulDividend
        xor     edx,edx                 ; edx = 0
        mov     ebx,ulDivisor
;;;;    cmp     ebx,0                   ; check for divide by zero
        cmp     ebx,edx                 ; check for divide by zero
        je      Divide_Err

        div     ebx                     ;result in edx:eax
        test    WORD PTR usRoundUpFlg,-1         ;should we round up?
        jz      DontRoundup
;;;;;;  cmp     edx,0                   ;is there a remainder?
        or      edx,edx                 ;is there a remainder?
        je      DontRoundup             ;no, so don't roundup
        inc     eax                     ;round up
;;;;    add     eax,1                   ;round up
DontRoundup:
        mov     edx,eax                 ;eax->edx (trash remainder)
        shr     edx,16                  ;dx = high word of eax
        jmp     Divide_Done

Divide_Err:
        xor     eax,eax                 ; return zero

Divide_Done:
        pop     ebx
        pop     bp
        ret
EndProc _DwordDivide

;********************* START OF SPECIFICATIONS *********************
;
; SUBROUTINE NAME: DwordMult()
;
; DESCRIPTIVE NAME: Muliple two ulongs
;
; FUNCTION: Used to convert stream time in milliseconds to stream time in mmtime, because
;           this is the format that mci expects.
;
; NOTES: This routine is called internally from  SHCSeek(), SHCGetTime(),
;
; ENTRY POINTS:
;     LINKAGE:   CALL near
;
; INPUT:
;
; EXIT-NORMAL: returns resultant in eax
;
; EXIT_ERROR:
;
; EFFECTS:
;
; INTERNAL REFERENCES: none
;
; EXTERNAL REFERENCES: none
;
;********************** END OF SPECIFICATIONS **********************/
Procedure _DwordMult,NEAR
        ASSUME cs:_TEXT, ds:_DATA, es:NOTHING, ss:NOTHING
ulMultiplicand  EQU     <[bp+4]>
ulMultiplier    EQU     <[bp+8]>
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    ebx
        mov     eax,ulMultiplicand
        xor     edx,edx
        mov     ebx,ulMultiplier
        mul     ebx                     ; result in edx:eax
        jno     Result32Bit             ; result less than 64bits?
        jmp     Result64Bit             ; no, so return edx:eax

Result32Bit:                            ; yes, so move 32bits into a 16:16 reg
        mov     edx,eax                 ;eax->edx
        shr     edx,16                  ;dx = high word of eax
Result64Bit:
        pop     ebx                     ; 'c' code will only use dx:ax
        pop     bp
        ret
EndProc _DwordMult

; SHORT set_sys_timer(USHORT service_routine_offset)
public _set_sys_timer
_set_sys_timer proc near
;    This function adds a timer handler to the list of timer handlers to be
; called on every timer tick.
;    The function receives the address of the service routine on the stack.
;    The function returns the value 0 if successful. Otherwise, the function
; returns the value -1.

SERV_ROUTINE_OFFSET equ <[bp+4]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   dx

    ; set up pdd's function address offset in ax
        mov    ax,SERV_ROUTINE_OFFSET

    ; set up code for device help function
        mov    dl,SETTIMER

    ; call device help function
        call   dword ptr [_Devhlp]
        mov    ax,0
        jnc    done2
        mov    ax,-1

   ;restore registers
done2:  pop    dx
        pop    bp

   ;done
        ret
_set_sys_timer endp

_TEXT   ENDS
        END
