/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*                      Copyright Media Vision Corp 1993.
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* audsubs.c - Audio device driver subroutines, based on MMPM/2 sample code
*
* DESCRIPTION:
* Provides routines to assist execution of the primary
* logic of the audio device driver (audiodd.c - for PAS-16, mvprodd.c).
*
*/

#define INCL_DOSINFOSEG
#define INCL_BASE
#include <os2.h>

#include <os2medef.h>
#include <meerror.h>
#include <ssm.h>
#include <audio.h>
#define DRV_16
#include "os2mixer.h"
#include "mvprodd.h"
#include "cdevhlp.h"
#include "pasdef.h"
#include "findpas.h"    // hardware detection
#include "globals.h"
#include "patch.h"
#include "proto.h"      // Function declarations
#include "debug.h"
#include "commdbg.h"


USHORT  usMode=STOP;


/*
** Updates stream position to account for completion
** of present operation and returns a pointer to
** present position (counter).
** Not used in the PAS-16 implementation.
*/
// void ProcessBuffer (void)
// {
// }


//ULONG   lSize;

/*                                      ----------------------- GetStreamTime -
** Returns present time in stream.
** Stream time is always based on some starting point.  That is, the device
** driver has no concept of beginning of file, end of file or seeking.
** When seeks are performed, MMPM/2 will send commands to the device driver
** to set its stream time.
** As data is consumed(play) or produced(record), the device driver updates
** its record of current time.
** MMPM/2 audio stream handler also tracks time, but is only able to do so
** with a resolution equal to the time necessary to consume a DMA buffer.
** The device driver has the ability for finer resolution.
**
** This routine is called when the stream handler wants the current stream time
*/
PULONG GetStreamTime (PSTREAM pStream)
{
   // The conditional compilations below are used to display
   // debug information via the COM: port based on compilation
   // options defined in debug.h


   #ifdef BUF_MONITOR
   #ifdef PROGRESS_MONITOR
   if (operation.pcm == OPERATION_RECORD)
      StringOut("<GST> PCM RECORD");
   else
      StringOut("<GST> PCM PLAY");
   #endif
   #endif

   if (pStream->usMode == PCM)
     return (&pStream->current_time);

   if (pStream->usMode==MIDI) {
     #ifdef PROGRESS_MONITOR
        StringOut("Get Stream Time MIDI PLAY");
     #endif

     if (operation.midi== OPERATION_PLAY) {
         // Accurate MIDI Timing
       pStream->ulCumTime=
            DwordDivide(pStream->ulMIDIStreamTimeX10,10L,FALSE);

       #ifdef MIDI_MONITOR
          lSecs=DwordDivide(pStream->ulCumTime,1000,FALSE);
          lMils=pStream->ulCumTime-DwordMult(lSecs,1000);

          PrintfOut("Time:%ld.%ld", lSecs,lMils);
       #endif
     }
#if 0
     else /*        operation == OPERATION_RECORD (MIDI) */
            {
            }
#endif
   }

   return (&pStream->ulCumTime);
}


VOID SetStreamTime (PSTREAM pStream, ULONG ulSetPos)
{
   ULONG ulDeltaTime;

   ulDeltaTime = pStream->ulCumTime = ulSetPos;      // get time in milliseconds
   pStream->current_time = ulSetPos;

   if (pStream->usMode==PCM) {
     ulDeltaTime=DwordDivide(ulDeltaTime , 100L, TRUE);           // convert to seconds/10.
     ulDeltaTime=DwordMult(ulDeltaTime , DwordDivide(gdwSampleRate, 10L, TRUE));          // convert to seconds.

     if (fStereoMode)
       ulDeltaTime <<= 1;    //double for stereo

     if (bBitsSample == 0x10)
       ulDeltaTime <<= 1;    // double for 16-bit

     ulPCM_PosSemiBufA=ulPCM_PosSemiBufB=ulStreamPosition.pcm=ulDeltaTime;
     if (pStream->ulOperation == OPERATION_RECORD)
       ulPCM_PosSemiBufB+=gdCurrentDMABufferSize/2;
   }
   else if (pStream->usMode==MIDI) {
     pStream->ulCumTimeX10=
     pStream->ulMIDIStreamTimeX10=
     DwordMult(pStream->ulCumTime, 10L);       // x10 for measuring ms/10
     ulStreamPosition.midi=ulDeltaTime;
     ulStreamPosition.synth=ulDeltaTime;
   }

   return;
}

/*
** Hardware specific operations to open this device
*/

BOOL DevOpen (void)
{

        if (pf.wNumFound==0)
                goto DevOpenFail;

        if (fIRQHasBeenSet)
                goto DevOpenSuccess;

   #ifdef PROGRESS_MONITOR
   StringOut( "Setting IRQ  -- first time");
   #endif
        if (DevHlp_SetIRQ((PVOID)InterruptHandler, TheIRQChannel, FALSE))
                goto DevOpenFail;

        DevOpenSuccess:
                fIRQHasBeenSet=TRUE;
      usInUse = NOT_AVAILABLE;
      #ifdef PROGRESS_MONITOR
        StringOut( "Success Set IRQ");
      #endif
                return(TRUE);                                                                           // no error

        DevOpenFail:
                fIRQHasBeenSet=FALSE;
      #ifdef DEBUG_CHK
        StringOut( "Fail Set IRQ");
      #endif
                return(FALSE);

}

/*
** Hardware specific operations to close this device
*/
void DevClose           (void)
{
        BOOL fStreamsRemain=FALSE;
        USHORT  i=0;
   PSTREAM pStream = GlobalTable.paStream;

   for (i=0; i< GlobalTable.usMaxNumStreams; i++,pStream++)
                {
                if (pStream->hStream == -1)            // find stream entry
                        continue;

                fStreamsRemain=TRUE;

        };

        if (pf.wNumFound && !fStreamsRemain)            // if we found our hardware
                if(!DevHlp_UnSetIRQ(TheIRQChannel))
                        fIRQHasBeenSet=FALSE;
   usInUse = AVAILABLE;

}


#define MEANVOLUME(dwVol)  (((ULONG) HIWORD(dwVol) + (ULONG) LOWORD(dwVol))/2)
#define _BALANCE(dwVol)  0x8000L + (((long) (LOWORD(dwVol))/2) - ((long) (HIWORD(dwVol))/2))

void DevChange (LPMCI_AUDIO_CHANGE lpChange)  // Audio Control Change
{
   BOOL             fMicRecording,fLineInRecording,fCDRecording;
   USHORT           i;
   DWORD            dwVolume;
   LPMCI_TRACK_INFO lpTI;
   BOOL             fMIDIOutPortEnabled=FALSE;
   BOOL             fMIDIOutSynthEnabled=FALSE;
   PSTREAM          pStream=0;
   USHORT           usMode=0;
   WORD             wInput;

   for (i=0; i<GlobalTable.usMaxNumStreams; i++)
      if (GlobalTable.paStream[i].hStream != -1) // ignore invalid streams
         if (GlobalTable.paStream[i].ulSysFileNum == gulFocusSysFileNum)
            {
            usMode=GlobalTable.paStream[i].usMode;
            break;
            }

   if (usMode==0)                  // if no stream assume audiochange is for PCM
      usMode=PCM;

   if (lpChange->lVolume != AUDIO_IGNORE)
      {
      #ifdef MIX_MONITOR
      PrintfOut("usMode=%d",usMode);
      StringOut("Audio not Ignore");
      #endif
      if ((usMode==MIDI) || (usMode==PCM))
         {
         if (usMode==MIDI)
            {
            if (lpChange->lBalance==AUDIO_IGNORE)
               lpChange->lBalance=gdwBalanceMIDI;
            else
               gdwBalanceMIDI=lpChange->lBalance;
            }
         else if (usMode==PCM)
            {
            if (lpChange->lBalance==AUDIO_IGNORE)
               lpChange->lBalance=gdwBalancePCM;
            else
               gdwBalancePCM=lpChange->lBalance;
            }

         dwVolume=LRVolumeFromVolumeBalance (lpChange->lVolume,
                                             lpChange->lBalance);
         #ifdef MIX_MONITOR
         PrintfOut("Instance Volume       =%lx",lpChange->lVolume);
         PrintfOut("Instance Balance      =%lx",lpChange->lBalance);
         #endif

         if (usMode==MIDI)
            {
            wInput=IN_SYNTHESIZER;
            #ifdef MIX_MONITOR
            PrintfOut("Synth Instance Volume  L=%0x  R=%0x",
                      HIUSHORT(dwVolume),LOUSHORT(dwVolume));
            #endif
            }
         else
            {
            wInput=IN_PCM;
            #ifdef MIX_MONITOR
            PrintfOut("PCM  Instance Volume  L=%0x  R=%0x",
                      HIUSHORT(dwVolume),LOUSHORT(dwVolume));
            #endif
            }
            SetLineControl(0,wInput,MIX_SUPPORT_VOLUME, dwVolume);
         }
      }
   else
      {
      StringOut("Audio Ignore -no instance volume");
      if (usMode==PCM)
         GetLineControl(0,IN_PCM,MIX_SUPPORT_VOLUME, (DWORD FAR *) &dwVolume);
      }

   if ((usMode==PCM) && (operation.pcm == OPERATION_RECORD))
      {
      SetLineConnections(0,IN_PCM, 1L<<OUT_AMPLIFIER); // never feedback

      switch (LOUSHORT(lpChange->lMonitor))
         {
         case MONITOR_OFF:
            SetLineControl(0,IN_MIXER,MIX_SUPPORT_VOLUME, 0L);
            SetLineControl(0,IN_PCM,MIX_SUPPORT_VOLUME, 0L);
            #ifdef MIX_MONITOR
            StringOut("Record Monitor turned off");
            #endif
            break;

         case MONITOR_UNCOMPRESSED:
            SetLineControl(0,IN_MIXER,MIX_SUPPORT_VOLUME, dwVolume);
            SetLineControl(0,IN_PCM,MIX_SUPPORT_VOLUME, dwVolume);
            #ifdef MIX_MONITOR
            StringOut("Record Monitoring audio input (uncompressed)");
            #endif
            break;

         case MONITOR_COMPRESSED:
            SetLineControl(0,IN_MIXER,MIX_SUPPORT_VOLUME, 0L);
            SetLineControl(0,IN_PCM,MIX_SUPPORT_VOLUME, dwVolume);
            #ifdef MIX_MONITOR
            StringOut("Record Monitoring DAC output (sorta compressed)");
            #endif
            break;
         }
      }

   #ifdef MIX_MONITOR
   //PrintfOut("LONG lInput        =%lx",lpChange->lInput);
   //PrintfOut("LONG lOutput       =%lx",lpChange->lOutput);
   //PrintfOut("LONG lMonitor      =%lx",lpChange->lMonitor);
   //PrintfOut("LONG lVolume       =%lx",lpChange->lVolume);
   //PrintfOut("LONG lVolumeDelay  =%lx",lpChange->lVolumeDelay);
   //PrintfOut("LONG lBalanceDelay =%lx",lpChange->lBalanceDelay);
   //PrintfOut("LONG lTreble       =%lx",lpChange->lTreble);
   //PrintfOut("LONG lBass         =%lx",lpChange->lBass);
   //PrintfOut("LONG lPitch        =%lx",lpChange->lPitch);
   //PrintfOut("LONG lGain         =%lx",lpChange->lGain);
   #endif

   if (lpChange->pvDevInfo != NULL)
      {
      union {
            WORD wWord[2];
            DWORD dwDword;
            } dwConvert;
      lpTI= lpChange->pvDevInfo;

      #ifdef MIX_MONITOR
      PrintfOut("]Master Volume                  =%lx",lpTI->usMasterVolume);
      PrintfOut("]Master Balance (random value)  =%lx",lpTI->usMasterBalance);
      #endif

      if (lpChange->lBalance==AUDIO_IGNORE)
         lpChange->lBalance=gdwBalanceMIDI;
      else
         {
         dwConvert.wWord[1]=lpTI->usMasterBalance;
         dwConvert.wWord[0]=0;
         //gdwBalanceMaster=dwConvert.dwDword;
         gdwBalanceMaster=0x40000000L;       // change this when fixed
         }

         if (lpTI->usMasterVolume != AUDIO_IGNORE)
            {
            dwConvert.wWord[1]=lpTI->usMasterVolume;
            dwConvert.wWord[0]=0;

            dwVolume=LRVolumeFromVolumeBalance( dwConvert.dwDword, gdwBalanceMaster);

                           #ifdef MIX_MONITOR
            dwConvert.dwDword=dwVolume;
                           PrintfOut("]Setting Master Volume Left=%0x  Right=%0x",dwConvert.wWord[1],dwConvert.wWord[0]);
                           #endif

                           SetLineControl(0,(MIX_OUTPUT<<8) | OUT_AMPLIFIER ,MIX_SUPPORT_VOLUME, dwVolume);
            }
      }


   fMicRecording=FALSE;
   fLineInRecording=FALSE;
   fCDRecording=FALSE;

   for  (i=0; i<8; i++)
      {
      if (lpChange->rInputList[i].ulDevType==NULL_INPUT )
         continue;

      if ((lpChange->rInputList[i].ulDevType==MIC_INPUT ) ||
          (lpChange->rInputList[i].ulDevType==BOOSTED_MIC_INPUT ))
         fMicRecording=TRUE;

      if (lpChange->rInputList[i].ulDevType==STEREO_LINE_INPUT )
         {
         fLineInRecording=TRUE;
         fCDRecording=TRUE;
         }
      } // end for

   if (fMicRecording)
      {
      SetLineConnections(0,IN_MICROPHONE,1<<OUT_PCM);
      #ifdef MIX_MONITOR
      StringOut("Recording from MICROPHONE");
      #endif
      }
   else
      SetLineConnections(0,IN_MICROPHONE,1<<OUT_AMPLIFIER);

   if (fCDRecording)
      {
      SetLineConnections(0,IN_INTERNAL        ,1<<OUT_PCM);
      #ifdef MIX_MONITOR
      StringOut("Recording from CD");
      #endif
      }
   else
      SetLineConnections(0,IN_INTERNAL        ,1<<OUT_AMPLIFIER);

   if (fLineInRecording)
      {
      SetLineConnections(0,IN_EXTERNAL        ,1<<OUT_PCM);
      #ifdef MIX_MONITOR
      StringOut("Recording from AUX");
      #endif
      }
   else
      SetLineConnections(0,IN_EXTERNAL        ,1<<OUT_AMPLIFIER);

   for  (i=0; i<8; i++)
      {
      if (lpChange->rOutputList[i].ulDevType==NULL_OUTPUT )
         continue;

      if (lpChange->rOutputList[i].ulDevType==SYNTH_OUTPUT )
         fMIDIOutSynthEnabled=TRUE;

      if (lpChange->rOutputList[i].ulDevType==MIDI_OUT_PORT )
         fMIDIOutPortEnabled=TRUE;

      } // end for

   // don't turn off global variable unless local is turned off!

   // This code is always playing MIDI to both the FM
   // synth and the MIDI out port.  If MMPM is now setting
   // the ulDevType values above, change the following code:

   /*
   ** Define where MIDI out will be sent
   ** gfMIDIOutPortEnabled=fMIDIOutPortEnabled;
   ** gfMIDIOutSynthEnabled=fMIDIOutSynthEnabled;
   */
   gfMIDIOutPortEnabled=fMIDIOutPortEnabled=TRUE;   // Send MIDI to both
   gfMIDIOutSynthEnabled=fMIDIOutSynthEnabled=TRUE;

   #ifdef MIX_MONITOR
   if (fMIDIOutSynthEnabled)
      StringOut("Playing MIDI to Internal Synth (OPL-3)");

   if (fMIDIOutPortEnabled)
      StringOut("Playing MIDI to MIDI out port");
   #endif

}

void DevIOCTLstatus     (LPMCI_AUDIO_STATUS pStatus)
{
   DWORD              dwVol;
   DWORD              dwBMT;
   SHORT              i;
   LPMCI_AUDIO_CHANGE lpChange = (LPMCI_AUDIO_CHANGE) &pStatus->rAudioChange;

   pStatus->lSRate=srate.pcm;
   pStatus->lBitsPerSRate=bits_per_sample.pcm;
   pStatus->lBsize=bsize.pcm;
   pStatus->sChannels=(USHORT)channels.pcm;
   pStatus->ulFlags=flags.pcm;
   pStatus->ulOperation=operation.pcm;

   lpChange->pvDevInfo=NULL;
   lpChange->lInput=0xFFFF;
   lpChange->lOutput=0xFFFF;
   lpChange->lMonitor= MONITOR_UNCOMPRESSED;

   GetLineControl(0,MIX_OUTPUT | OUT_AMPLIFIER ,MIX_SUPPORT_VOLUME, &dwVol);
   lpChange->lVolume=MEANVOLUME(dwVol)<<15; //0 - 7FFFFFFF;
   lpChange->lVolumeDelay=0;
   lpChange->lBalance=_BALANCE(dwVol)<<15;
   lpChange->lBalanceDelay=0;              // meaningless if volumes are changing

   GetLineControl(0,MIX_OUTPUT | OUT_AMPLIFIER ,MIX_SUPPORT_BMT, &dwBMT);
   lpChange->lTreble=((ULONG)BMTTREB(dwBMT))<<24;
   lpChange->lBass=((ULONG)BMTBASS(dwBMT))<<24;
   lpChange->lPitch=(ULONG)NULL;

   lpChange->rInputList[IN_SYNTHESIZER].ulDevType=SYNTH_INPUT;
   lpChange->rInputList[IN_MIXER      ].ulDevType=STEREO_LINE_INPUT;
   lpChange->rInputList[IN_EXTERNAL   ].ulDevType=STEREO_LINE_INPUT;
   lpChange->rInputList[IN_INTERNAL   ].ulDevType=STEREO_LINE_INPUT;

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.Slot16)
      lpChange->rInputList[IN_MICROPHONE].ulDevType=BOOSTED_MIC_INPUT;
   else
      lpChange->rInputList[IN_MICROPHONE].ulDevType=MIC_INPUT;

   lpChange->rInputList[IN_PCM        ].ulDevType=STEREO_LINE_INPUT;
   lpChange->rInputList[IN_PC_SPEAKER ].ulDevType=LEFT_LINE_INPUT;

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.DAC16)
      lpChange->rInputList[IN_SNDBLASTER].ulDevType=STEREO_LINE_INPUT;
   else
      lpChange->rInputList[IN_SNDBLASTER].ulDevType=STEREO_LINE_INPUT;

   for (i=0;i<8;i++)
      lpChange->rInputList[i].ulDevNum=DEFAULT_DEVICE;

   lpChange->rOutputList[OUT_AMPLIFIER].ulDevType=STEREO_LINE_OUTPUT;
   lpChange->rOutputList[OUT_AMPLIFIER].ulDevNum =DEFAULT_DEVICE;
   lpChange->rOutputList[OUT_PCM      ].ulDevType=LEFT_LINE_INPUT;
   lpChange->rOutputList[OUT_PCM      ].ulDevNum =DEFAULT_DEVICE;

   lpChange->prMoreInputs=NULL;
   lpChange->prMoreOutputs=NULL;
   lpChange->rOutputList[8];
   lpChange->prMoreInputs;
   lpChange->prMoreOutputs;

}


/*
** Hardware specific operations
*/
UINT ReadDataFromCard (PSTREAM pStream)
{
   BOOL fBufferFilled=FALSE;
   unsigned long lBufCount,lBufRemaining;
   char far *lpS,far *lpD;

   fPCMChoked=FALSE;                            // Assume no overrun
   switch (iNextBuffer)
      {
      case 0:
         #ifdef BUF_MONITOR
         StringOut( "Retrieve DMA semibuffer A");
         #endif
         lpS= (char far *) lpDMAVirtual;
         iNextBuffer=1;
         break;

      case 1:
         #ifdef BUF_MONITOR
         StringOut( "Retrieve DMA semibuffer B");
         #endif
         lpS = (char far *)lpDMAVirtual + dwDMAUnitSize;
         iNextBuffer=0;
         break;

      default:
         #ifdef DEBUG_CHK
         StringOut("iNextBuffer illegal value");
         #endif
         break;
      } // end switch


   if (pStream->usCurrIOBuffIndex == pStream->usNextIOBuffIndex)
      {
      #ifdef BUF_MONITOR
      StringOut("    No buffer to write data to");
      #endif
      }

  lBufRemaining = dwDMAUnitSize;            // Amount of data card produced

   while (lBufRemaining &&
          (pStream->usCurrIOBuffIndex != pStream->usNextIOBuffIndex) )
   {
      USHORT Curr=pStream->usCurrIOBuffIndex;

      // Get Amount of buffer left to fill
      lBufCount = pStream->IOBuff[Curr].lSize - pStream->IOBuff[Curr].lCount;
      #ifdef BUF_MONITOR
      PrintfOut ("lBufRemaining: %d", lBufRemaining);
      PrintfOut ("lBufCount:     %d", lBufCount);
      PrintfOut ("lSize:         %d", pStream->IOBuff[Curr].lSize);
      PrintfOut ("lCount:        %d", pStream->IOBuff[Curr].lCount);
      #endif

      if (!lBufCount)
         {
         #ifdef DEBUG_CHK
         StringOut("Hey, Buffer already filled!!");
         #endif
         break;
         }

      // Get Destination
      lpD=(char far *) pStream->IOBuff[Curr].pHead;

      if (lBufCount > lBufRemaining)
         {
         lBufCount=lBufRemaining;               // just take what you can get
         fBufferFilled=FALSE;
         }
      else
         fBufferFilled=TRUE;

      LoadBuffer(lpS,lpD, lBufCount);           // Move that data!

      pStream->IOBuff[Curr].pHead+=lBufCount;
      pStream->IOBuff[Curr].lCount+=lBufCount;

      lpD           += lBufCount;
      lBufRemaining -= lBufCount;

      if (fBufferFilled)
         {
         pStream->usCurrIOBuffIndex++;
         if (pStream->usCurrIOBuffIndex>=MAXIOBUFFS)    // CHECK FOR WRAP
            pStream->usCurrIOBuffIndex=0;
         }

   } // end while


   if (lBufRemaining)           // Is buffer partially filed?
      {
      fPCMChoked=TRUE;          // if choking, use international hand signal
      #ifdef PROGRESS_MONITOR
      StringOut("I'm choking and I can't get up!");
      #endif
      }

   return(fPCMChoked);
}


/*
** Hardware specific operations
*/


/*
** Note:  The assumption can be made that all buffers will be full
**        except the last buffer.  Also, the buffers will always be
**        the size I asked for
*/

extern int      DMARunning;

/*                                      ------------------- InitialBufferLoad -
** Preload the dual DMA semibuffers.
** Preload is necessary before audio playback begins.
*/
void InitialBufferLoad(PSTREAM pStream)
{
   #ifdef BUF_MONITOR
   StringOut( "Initial Buffer Load");
   #endif

   fPCMStarved = FALSE;
   fPCMUnderran = FALSE;

   // make sure there's still data in the queue
   while ((iEmptyPCMBuffers) &&
          (pStream->usCurrIOBuffIndex != pStream->usNextIOBuffIndex))
   {
      #ifdef BUF_MONITOR
      PrintfOut ("     Empty PCM Buffers =%d",iEmptyPCMBuffers);
      StringOut ("     Calling WriteDataToCard");
      #endif
      if (WriteDataToCard(pStream))
         {
         StringOut( "Starved for Data");
         break;
         }
   } // end while
}

                                        //------------------- WriteDataToCard -
UINT WriteDataToCard (PSTREAM pStream)
{
   BOOL          fBufferEmptied=FALSE;
   BOOL          fStopPointReached=FALSE;
   UINT          i;
   unsigned long lBufCount,lBufRemaining;
   char far      *lpS,far *lpD;


   if (pStream->usMode==PCM)
      {
      // On PCM playback, we become aware of a pending underrun
      // one buffer before it actually happens.

      switch (iNextBuffer)
         {
         case 0:
            #ifdef BUF_MONITOR
            StringOut( "Fill DMA semibuffer A");
            #endif
            lpD= (char far *) lpDMAVirtual;
            iNextBuffer=1;
            break;

         case 1:
            #ifdef BUF_MONITOR
            StringOut( "Fill DMA semibuffer B");
            #endif
            lpD= (char far *)lpDMAVirtual + dwDMAUnitSize;
            iNextBuffer=0;
            break;

         default:
            #ifdef DEBUG_CHK
            StringOut("iNextBuffer illegal value");
            #endif
            break;
         } // end switch

      lBufRemaining = dwDMAUnitSize;            // Amount of data going to card

      while (lBufRemaining &&
             (pStream->usCurrIOBuffIndex != pStream->usNextIOBuffIndex) )
         {
         USHORT Curr=pStream->usCurrIOBuffIndex;

         // Get Size
         lBufCount=pStream->IOBuff[Curr].lCount;
         #ifdef BUF_MONITOR
         PrintfOut("Size of Current Buffer: %ld",lBufCount);
         #endif

         if (!lBufCount)
            {
            fBufferEmptied=TRUE;
            StringOut("Received an empty buffer!");
            goto EmptyPCMBuffer;          // Handle Buffer length of zero
            }

         // Get Source
         lpS=(char far *) pStream->IOBuff[Curr].pHead;

         if (lBufCount > lBufRemaining)
            {
            lBufCount=lBufRemaining;
            fBufferEmptied=FALSE;
            }
         else
            fBufferEmptied=TRUE;

         LoadBuffer(lpS,lpD, lBufCount);                                              // Move that data!

         pStream->IOBuff[Curr].pHead+=lBufCount;
         pStream->IOBuff[Curr].lCount-=lBufCount;

         lpD+=lBufCount;
         lBufRemaining-=lBufCount;
         #ifdef BUF_MONITOR
         PrintfOut("Remaining DMA buffer to fill: %ld",lBufRemaining);
         #endif

         EmptyPCMBuffer: // Yea haa, a label
         if (fBufferEmptied)
            {
            #ifdef BUF_MONITOR
            StringOut("Buffer Exhausted");
            #endif
            fPCMUnderran = fPCMStarved;         // Starved on earlier fill?
            fPCMStarved = FALSE;
            pStream->usCurrIOBuffIndex++;
            if (pStream->usCurrIOBuffIndex>=MAXIOBUFFS)  // CHECK FOR WRAP
               pStream->usCurrIOBuffIndex=0;
            }

         } // end while

      if (lBufRemaining)           // Is buffer partially filed?
         {
         #ifdef BUF_MONITOR
         PrintfOut("PCM buffer starved, filling %ld bytes of silence",
                   lBufRemaining);
         #endif
         fPCMStarved = TRUE;            // if starved, pad out with silence

         if (bits_per_sample.pcm==8)
            {
            for (i=0; i< (USHORT) lBufRemaining ; i++)
               *((char far *)lpD)++=0x80;
            }
         else
            {
            for (i=0; i< (USHORT) lBufRemaining/2; i++)
               *((WORD far *)lpD)++=0x0000;
            }
         } // if lBufRemaining

      if (iEmptyPCMBuffers)
         iEmptyPCMBuffers--;
      } // end if (pStream->usMode==PCM)

   else  // pStream->usMode==MIDI
      {
      while ((pStream->usCurrIOBuffIndex != pStream->usNextIOBuffIndex) )
         {
         USHORT Curr=pStream->usCurrIOBuffIndex;

         // Get Size
         // for MIDI, lBufRemaining is remaining MIDI data in buffer

         lBufCount=lBufRemaining=pStream->IOBuff[Curr].lCount;

         if (!lBufCount)
            break;

         // Get Source
         lpS=(char far *) pStream->IOBuff[Curr].pHead;

         while (lBufRemaining && (!fStopPointReached))
            {
            if (gfMIDIOutPortEnabled)
               MIDI_Output_Byte(*lpS);
            fStopPointReached=midi_deal(*lpS++);
            lBufRemaining--;
            }

         fBufferEmptied=(lBufRemaining==0);

         pStream->IOBuff[Curr].pHead+=(lBufCount-lBufRemaining);
         pStream->IOBuff[Curr].lCount-=(lBufCount-lBufRemaining);

         if (fBufferEmptied)
            {
            pStream->usCurrIOBuffIndex++;
            if (pStream->usCurrIOBuffIndex>=MAXIOBUFFS)  // CHECK FOR WRAP
            pStream->usCurrIOBuffIndex=0;
            }

         if (fStopPointReached)
            break;
         } // end while

      if (!fStopPointReached)           // ran out of MIDI Data to send?
         fMIDIStarved=TRUE;             // if starved, pad out with silence
      } // end else (midi)

   if (pStream->usMode==PCM)
      return(fPCMStarved);

   if (pStream->usMode==MIDI)
      return(fMIDIStarved);

   #ifdef DEBUG_CHK
   StringOut("Warning! usMode of stream not set prior to WriteDataToCard");
   return(FALSE);    // not starved as catch all
   #endif
}


/*
** Issue End-Of-Interrupt to 8259
** interrupt controller (OS/2 DevHlp)
*/
void EOI (void)
{
   DevHlp_EOI(TheIRQChannel);
}

void ReadStatus (void)
{
}

void WriteStatus (void)
{
}

void FlushInputBuffers (void)
{
}

void FlushOutputBuffers (void)
{
}

/*
** When processing data, the PDD watches for
** specific events.  For example, when data at
** certain stream position is processed, the
** PDD tells the stream handler of the encountered
** event (eg setpositionadvise on every ...)
** The PDD has to have a mechanism of noticing
** these events.
*/
ULONG Enqueue_Event (HEVENT hEvent, ULONG ulCuePoint)
{
   // Generate new event in queue
   // If no room, return error
   // Set event
   return (ERROR_INVALID_REQUEST);
}

ULONG Dequeue_Event (HEVENT hEvent)
{
   // Search queue for specified event
   // If not found, return error
   // Fix pointers to bypass this node.
   // Free the node memory
   return (ERROR_INVALID_REQUEST);
}

/*                                      -------------------------- LoadBuffer -
** Load data from stream manager into one of the 2 DMA semibuffers
** This is a data copy.  Note that the data must be copied from
** the SSM provided location as it is impossible to re-program the
** DMA controller to pull from the new address without audio breakup.
** An adapter with scatter gather capability would not have this restriction
** and would therefore be more efficient.
*/
void LoadBuffer(char far *hpData,char far *lpBuf, DWORD dwCnt)
{
   #define movsd1  _emit 0x66
   #define movsd2  _emit 0xA5

   _asm
   {
      push ds
      push es

      cld

      /*
      ** Ken, FWIW, the MOVSx instructions will work fine with count == 0.
      ** Could save some compares and jumps.  Probably insignificant relative
      ** to the cost of the MOV.  Still, thought I'd mention it.
      ** JHN 29-Jul-93
      */

      mov     cx, word ptr dwCnt+0
      jcxz    exit386           ; make sure count ain't zero

      les     di, lpBuf                                                                ;; destination address
      lds     si, hpData        ; source      address

      mov     dx, cx            ; get byte count
      and     dx, 3             ; odd number of bytes?

      shr     cx, 1             ; convert to # of words
      shr     cx, 1             ; convert to # of dwords

      rep     movsd1            ; REP MOVSD  (CX is the count, not ECX)
      movsd2                    ; Length of count is taken from segment type.
                                ; Here, 16-bit.  It could be overridden.

      mov     cx, dx            ; Move the last few bytes
      jcxz    exit386           ; make sure count ain't zero
      rep     movsb

      exit386:

      pop     es
      pop     ds
   } // end _asm
}

/*                                      ----------------- StartMIDIInterrupts -
**  SOME NOTES ON MIDI TIMING, INTERRUPTS AND THE PAS 16
**
**  Tempo is supplied via IBM defined sysex message in decibeats
**  per minute (dbpm).  The default tempo is 1200 dbpm.
**
**  MIDI needs real-time resoution to 24 parts of each beat (the
**  terms beat and quarter note are synonyms for MIDI) so that
**  0xF8 real-time commands can be sent at a constant rate.
**  MIDI documentation often refers to 24 ppqn (pulses per quarter note).
**
**  The interrupt rate we seek is defined by the formula:
**      Rate = ((Tempo/10)/60) * 24
**
**  Rev D hardware's MIDI Timer decrements at a constant 2 KHz rate.
**  When the MIDI Timer reaches 0, an interrupt is generated if
**  the Time Stamp Interrupt is enabled.  The MIDI Timer is then
**  reloaded with the value in the MIDI Prescale register.  The
**  MIDI Compare Time register interrtup is practically useless
**  though it's register can be used as scratchpad RAM.
**
**  The MIDI time clock is based on a 31250 Hz signal.  With Rev C
**  or earlier hardware, this signal is divided by the Prescale counter
**  (aka MIDI time stamp) and each time Prescale counts to a given number
**  (Prescale) it
**       A) (optionally) generates the time stamp interrupt
**       B) increments the MIDI timer register
**
**  The MIDI compare interrupt occurs when MIDI timer equals the
**  MIDI compare register.  Unfortunately, the compare register
**  on the PAS 16 Rev D of the MV101 Digital Multimedia Audio
**  Controller (DMAC) doesn't work.  This requires
**  simulation of the compare register in software resulting in
**  much higher interrupt use than necessary.
**
**  Formula for Rev C timing is  (31.25KHz * (Prescale / Compare))== rate.
**  Rate is determined by Tempo.
*/
void StartMIDIInterrupts(PSTREAM pStream)
{
   BYTE  bTemp;
   DWORD dwRate;               // wRate is number of pulses per second
   WORD  wDividend, wDivisor;
   DWORD ulBuildPeriod;

   #ifdef MIDI_TIMING_MONITOR
   PrintfOut(" ulTempo=%ld   PPQN=%d",pStream->ulTempo, pStream->usPPQN);
   #endif
   dwRate = (pStream->ulTempo* (DWORD) pStream->usPPQN)/600L;

   #ifdef DEBUG_CHK
   bTemp=PASX_IN(INTERRUPT_STATUS);

   if (bTemp & INT_MIDI_OCCURRED)
      StringOut("MIDI ERROR! MIDI ERROR! INTERRUPT NOT CLEARED");
   #endif

   /*
   ** CALCULATING .1 ms per part
   ** to arrive at  MIDI time stamp (0xF8) interval as
   ** expressed in tenths of milliseconds
   **
   ** Calculation below is number of 1. ms units for each part =
   ** tenths of uS per minute /100 to cause
   ** conversion to .1 ms scale
   */
   pStream->ulPartPeriod=
      DwordDivide(6000000L,
                  DwordMult (pStream->ulTempo, (ULONG) pStream->usPPQN ),
                  TRUE);

   if (!pStream->ulPartPeriod)    // safeguard for super fast tempos
      {
      pStream->ulPartPeriod=1L;
      #ifdef DEBUG_CHK
      StringOut("AUDSUBS: MIDI part period underflow!");
      #endif
      }

   if (pf.ProCard[gwBoardIndex].wChipRev<=3)     // aka REV A thru C
      {
      RationalRateApproximation (31250L,
                                 dwRate,
                                 (WORD FAR *) &wDividend,
                                 (WORD FAR *) &wDivisor);
      wMIDIPrescale=(WORD) max(wDividend, wDivisor);
      wMIDICompareTime=(WORD) min(wDividend, wDivisor);

      if ((wMIDICompareTime==2) && (wMIDIPrescale<=0x7F))
         {
         wMIDICompareTime=1;
         wMIDIPrescale+=wMIDIPrescale;
         }

      // first get number of uS for each tick of MIDI clock
      ulBuildPeriod=32L;          /* 1,000,000 uS / 31,250 ticks */

      // now multiply by product of Prescale and Compare Time to
      // produce number of microseconds per interrupt
      ulBuildPeriod=
         DwordMult (ulBuildPeriod,      // microseconds as base for calc
                   (long) (wMIDIPrescale * wMIDICompareTime) );

      // finally convert uS to .1ms units
      ulBuildPeriod=
         DwordDivide( ulBuildPeriod,    // microseconds as base for calc
                      100L,             // Get period in .1 ms units
                      FALSE);           // Do round up.

      pStream->ulInterruptPeriod= ulBuildPeriod;

      if (!pStream->ulInterruptPeriod)  // safeguard for super fast tempos
         {
         pStream->ulInterruptPeriod=1L;
         #ifdef DEBUG_CHK
         StringOut("AUDSUBS: MIDI interrupt period underflow!");
         #endif
         }

      /// THIS IS A TEST
      /// IF INTERRUPTS OCCUR TOO QUICKLY ON REV C
      /// SLOW THEM DOWN AND DOUBLE INTERRUPT PERIOD


      if (wMIDIPrescale<=0x40)
         {
         wMIDIPrescale+=wMIDIPrescale;
         pStream->ulInterruptPeriod+=pStream->ulInterruptPeriod;
         }

      #ifdef MIDI_TIMING_MONITOR
      PrintfOut ("Interrupts Per Second: %ld", dwRate);
      PrintfOut ("MIDI Prescale: %d", wMIDIPrescale);
      PrintfOut ("MIDI Compare Time: %d", wMIDICompareTime);
      PrintfOut ("MIDI Interrupt Period: %ld in .1 mS",
                 pStream->ulInterruptPeriod);
      PrintfOut ("MIDI Part Period: %ld in .1 mS units",
                 pStream->ulPartPeriod);
      #endif

      PASX_OUT(MIDI_PRESCALE,(BYTE) wMIDIPrescale);   // sets Prescale
      wMIDICurrentTime=0;

      // resets MIDI Timer Port if MIDI compare time worked
      PASX_OUT(MIDI_COMPARE_TIME,(BYTE) wMIDICompareTime);

      bTemp = PASX_IN(MIDI_CONTROL);         // enable interrupt
      bTemp |= ENABLE_COMPARE_TIME_INT;      // Enable specific MIDI interrupt
      bTemp |=  RESET_IN_FIFO;
      //////fInterruptInUse++;
      PASX_OUT(MIDI_CONTROL,bTemp);

      bTemp = PASX_IN(INTERRUPT_ENABLE);
      bTemp |= INT_MIDI;                     // enable Ambiguous MIDI interrupt
      PASX_OUT(INTERRUPT_ENABLE,bTemp);
      }

   else  // aka REV D or later
      {
      RationalRateApproximation (2000L,
                                 dwRate,
                                 (WORD FAR *) &wDividend,
                                 (WORD FAR *) &wDivisor);
      wMIDIPrescale=(WORD) max(wDividend, wDivisor);
      wMIDICompareTime=(WORD) min(wDividend, wDivisor);

      // first get number of uS for each tick of MIDI clock
      ulBuildPeriod=500L;          /* 1,000,000 uS / 2,000 ticks */

      // now multiply by product of Prescale and Compare Time to
      // produce number of microseconds per interrupt
      ulBuildPeriod=
         DwordMult( ulBuildPeriod,      // microseconds as base for calc
                    (long) wMIDIPrescale);

      // finally convert uS to .1ms units
      ulBuildPeriod=
         DwordDivide( ulBuildPeriod,    // microseconds as base for calc
                      100L,             // Get period in .1 ms units
                      FALSE);           // Do round up.

      pStream->ulInterruptPeriod= ulBuildPeriod;
      if (!pStream->ulInterruptPeriod)  // safeguard for super fast tempos
         {
         pStream->ulInterruptPeriod=1L;
         #ifdef DEBUG_CHK
         StringOut("AUDSUBS: MIDI interrupt period underflow!");
         #endif
         }

      #ifdef MIDI_TIMING_MONITOR
      PrintfOut ("Interrupts Per Second: %ld", dwRate);
      PrintfOut ("MIDI Prescale: %d", wMIDIPrescale);
      PrintfOut ("MIDI Compare Time: %d", wMIDICompareTime);
      PrintfOut ("MIDI Interrupt Period: %ld in .1 mS",
                 pStream->ulInterruptPeriod);
      #endif

      PASX_OUT(MIDI_PRESCALE,(BYTE) (wMIDIPrescale-1));   // sets Prescale
      wMIDICurrentTime=0;

      bTemp = PASX_IN(MIDI_CONTROL);    // enable interrupt
      bTemp |= ENABLE_TIME_STAMP_INT;   // required to get any ints!
      bTemp |= RESET_IN_FIFO;
      PASX_OUT(MIDI_CONTROL,bTemp);

      bTemp = PASX_IN(INTERRUPT_ENABLE);
      bTemp |= INT_MIDI;                // enable Ambiguous MIDI interrupt
      PASX_OUT(INTERRUPT_ENABLE,bTemp); // may already be enabled for MIDI IN!
      }
}
void
StopMIDIInterrupts()
{
   BYTE bTemp=PASX_IN(MIDI_CONTROL);    // disable interrupt
   bTemp &= ~(ENABLE_COMPARE_TIME_INT|ENABLE_TIME_STAMP_INT);
   bTemp|= RESET_IN_FIFO;
   PASX_OUT(MIDI_CONTROL,bTemp);

   bTemp = PASX_IN(INTERRUPT_ENABLE);
   bTemp &= ~INT_MIDI;               // disable Ambiguous MIDI interrupt
   PASX_OUT(INTERRUPT_ENABLE,bTemp); // if enabled for MIDI IN, this will break

   // nuke any pending ints
   bTemp=PASX_IN(MIDI_STATUS);       // see if it was a MIDI interrupt
   PASX_OUT(MIDI_STATUS,bTemp);      // if enabled for MIDI IN, this will break
   bTemp &= ~(ENABLE_COMPARE_TIME_INT|ENABLE_TIME_STAMP_INT);
   PASX_OUT(MIDI_STATUS,bTemp);      // if enabled for MIDI IN, this will break
}

/*                                      ----------- RationalRateApproximation -
*/
void RationalRateApproximation (DWORD dwFactor,
                                DWORD dwRate,
                                WORD FAR *pwDividendBest,
                                WORD FAR *pwDivisorBest)
{
   LONG lGoal = ((dwFactor * 1024) + (dwRate /2 )) / dwRate;
   LONG lTrial, lError, lErrorBest = 0x7FFFFFFF;  /* way off */
   WORD wDividend;
   WORD wDivisor;
   WORD wDividendBest=2;
   WORD wDivisorBest=21;     // moved to pointers
   WORD wMinDivisor=2;

   #ifdef MIDI_TIMING_MONITOR
   PrintfOut ("lGoal (number of ticks (*1024) per pulse)= %ld", lGoal);
   #endif

   if (pf.ProCard[gwBoardIndex].wChipRev>3)
      wMinDivisor=1;

   for (wDivisor=(WORD) ((lGoal+512)/1024)/2;
        wDivisor >= wMinDivisor;
        wDivisor--)
      {
      wDividend = (WORD) ( ((lGoal/wDivisor) + 512) /1024);
      #ifdef MIDI_TIMING_MONITOR
      //PrintfOut ("wDividend (top)   = %d", wDividend);
      //PrintfOut ("wDivisor (bottom) = %d", wDivisor);
      #endif

      if (wDividend > 255)
         {
         #ifdef MIDI_TIMING_MONITOR
         PrintfOut("wDividend too big: %d", wDividend);
         #endif
         continue;
         }
      lTrial = (1024L * (LONG)(wDividend) * (LONG)wDivisor);
      lError = (max (lTrial, lGoal) - min (lTrial, lGoal));
      #ifdef MIDI_TIMING_MONITOR
      //PrintfOut ("lTrial (product of Dividend and Divisor) = %ld", lTrial);
      //PrintfOut ("lError (difference from goal)= %ld", lError);
      #endif
      if (lError < lErrorBest)
         {
         StringOut("New Champ on Error Test");
         #ifdef MIDI_TIMING_MONITOR
         PrintfOut("wDividend winner: %d", wDividend);
         PrintfOut("wDivisor winner: %d", wDivisor);
         #endif
         lErrorBest = lError;
         wDivisorBest = wDivisor;
         wDividendBest = wDividend;
         }
      } // end for

   *pwDivisorBest = wDivisorBest;
   *pwDividendBest = wDividendBest;
}

                                        //------------------------------- max -
long max (long l1, long l2)
{
   if (l1 >= l2)
      return l1;
   else
      return l2;
}

                                        //------------------------------- min -
long min (long l1, long l2)
{
   if (l1 <= l2)
      return l1;
   else
      return l2;
}

#define EVEN_BALANCE    0x40000000L

                                        //--------- LRVolumeFromVolumeBalance -
// dwVolume range: 0-7FFFFFFF
// dwBalance range: 0-7FFFFFFF
DWORD LRVolumeFromVolumeBalance( DWORD dwVolume, DWORD dwBalance )
{
   union
      {
      WORD wWord[2];
      DWORD dwDword;
      } dwConvert;
   DWORD dwVolL,dwVolR;

   //PrintfOut(" Volume Enter:  %0lx", dwVolume);
   //PrintfOut(" Balance Enter:  %0lx", dwBalance);

   dwConvert.dwDword=dwVolume;
   dwVolR  = dwConvert.wWord[1];        // range 0-7fff
   dwVolR += dwConvert.wWord[1];        // range 0-fffE
   dwVolL  = dwVolR;                    // range 0-FFFE

   dwConvert.dwDword=dwBalance;
   dwBalance=dwConvert.wWord[1];        // range 0-7FFF
   dwBalance+=dwBalance;                // range 0-FFFF (compiler nonsense)
   dwBalance+=dwBalance;                // range 0-1FFFE (compiler nonsense)

   if (dwBalance < 0x10000L)            // balance toward left
      {
      dwBalance=0x10000L-dwBalance;     // get deviation from equilibrium

      dwVolL += dwBalance;              // add with saturate
      if (dwVolL > 0xffff)
         dwVolL=0xffff;

      if (dwVolR > dwBalance)           // subtract with limit
         dwVolR-=dwBalance;
      else
         dwVolR=0;
      }
   else
      if (dwBalance > 0x10000L)         // balance toward right
         {
         dwBalance=dwBalance-0x10000L;

         dwVolR += dwBalance;
         if (dwVolR > 0xffff)
            dwVolR=0xffff;
         if (dwVolL > dwBalance)
            dwVolL-=dwBalance;
         else
            dwVolL=0;
         }

   //PrintfOut(" Volume Left Exit:  %0lx", dwVolL);
   //PrintfOut(" Volume Right Exit:  %0lx", dwVolR);

   dwVolume=(dwVolL<<16)+dwVolR;
   return (dwVolume);        // 0xLLLLRRRR
}

                                        //---------------- MIDI_All_Notes_Off -
void MIDI_All_Notes_Off()
{
   BYTE  b;

   for (b=0xB0; b< 0xC0; b++)
      {
      MIDI_Output_Byte(b);
      MIDI_Output_Byte(123);            // MIDI's All notes off command
      MIDI_Output_Byte(0);
      }

   //#if 0
   //for (c=0; c<= 0xf; c++)            // this takes too long.
   //   for (b=0; b<= 127; b++)         // Looks like a bug
   //      {
   //      MIDI_Output_Byte(0x80+c);
   //      MIDI_Output_Byte(b);         // MIDI's All notes off command
   //      MIDI_Output_Byte(127);       // release velocity
   //      }
   //#endif
}

                                        //--------------- ToggleMIDIIntEnable -
void ToggleMIDIIntEnable(void)
{
   BYTE  bTemp;

   bTemp=PASX_IN(INTERRUPT_ENABLE);
   bTemp&=~INT_MIDI;
   PASX_OUT(INTERRUPT_ENABLE,bTemp);

   bTemp=PASX_IN(INTERRUPT_ENABLE);             // get again in case it changed
   bTemp|=INT_MIDI;
   PASX_OUT(INTERRUPT_ENABLE,bTemp);
}

                                        //---------------- TogglePCMIntEnable -
void TogglePCMIntEnable(void)
{
   BYTE  bTemp;

   bTemp=PASX_IN(INTERRUPT_ENABLE);
   bTemp &=~INT_SAMPLE_BUFFER;
   PASX_OUT(INTERRUPT_ENABLE,bTemp);

   bTemp=PASX_IN(INTERRUPT_ENABLE);             // get again in case it changed
   bTemp|=INT_SAMPLE_BUFFER;
   PASX_OUT(INTERRUPT_ENABLE,bTemp);
}


extern WORD             samplerate;

BYTE    SampleFilterSetting=0;  // default setting based on sample rate

#define MASTER_CLOCK    ((DWORD)1193180L)


/*                                      ---------------------- calcSampleRate -
** This function will set the sample rate and filter
** filter settings PROPERLY.
**
** There is no return value.
**
** Sets global variables for sample rate, stereo/mono mode
** and number of bits.      Does limited sanity check input parms.
** Sets sample rate hard/ware and filters.
*/
void calcSampleRate(DWORD samplespersec, WORD wNumChannels, WORD wBitsSample)
{
   DWORD dwTicks;                                                                                                // timer value for sample rate
   DWORD mysamplespersec;
   BYTE  bTemp;
   WORD  prescale,timer;

   #ifdef BUF_MONITOR
   PrintfOut("CalcSampleRate Request:  %ldKHz, %dch. %d-bit",
             samplespersec, wNumChannels, wBitsSample);
   #endif

   if (wNumChannels==2)
      fStereoMode=TRUE;
   else
      fStereoMode=FALSE;

   if ((samplespersec <4660) || (samplespersec > 48000))
      return;

   mysamplespersec=samplespersec<<(wNumChannels-1);

   if (pf.ProCard[gwBoardIndex].Caps.CapsBits.DAC16)
      {
      #ifdef DEBUG_CHK
      StringOut("Acccurate timing method");
      #endif

      _asm {
           mov  dx,SYSTEM_CONFIG_2              // defined in findpas.h
           xor  dx,gwTranslateCode              // I/O relocation
           in   al,dx                           // get current bits
           mov  bTemp,al
           }

      bTemp &= (~D4);                           // D4 inverts flatline sense
                                                // (leave this alone!)
                                                                                                // make sure it's off

      switch (wBitsSample)
         {
         case 8:
            bTemp &= (~D2);                     // D2 enables 16 & 12-bit DMA
            bTemp &= (~D3);                     // D3 enables 12-bit DMA
            break;

         case 12:
            bTemp |= D2;                        // D2 enables 16 & 12-bit DMA
            bTemp |= D3;                        // D3 enables 12-bit DMA
            break;

         case 16:
            #ifdef DEBUG_CHK
            StringOut("Requesting 16-bit audio");
            #endif
            bTemp |= D2;                        // D2 enables 16 & 12-bit DMA
            bTemp &= (~D3);                     // D3 enables 12-bit DMA
            break;

         default:
            #ifdef DEBUG_CHK
            StringOut("Illegal bits per sample");
            #endif
            ;
         } // end switch

      _asm {
           mov  dx,SYSTEM_CONFIG_2      // defined in findpas.h
           xor  dx,gwTranslateCode      // I/O relocation
           mov  al,bTemp
           out  dx,al

           mov  dx,SYSTEM_CONFIG_1      // defined in findpas.h
           xor  dx,gwTranslateCode      // I/O relocation
           in   al,dx
           or   al,C1_ACCURATE_TIMING   // D1 disables original PAS emulation
           out  dx,al
           }

      switch (samplespersec)
         {
         case 11025:
            prescale=2;
            timer=80;                           //20;
            break;

         case 22050:
            prescale=2;
            timer=40;
            break;

         case 32000:
            prescale=9;
            timer=124;                                                                              // .03% error
            break;

         case 44100:
            prescale=2;                                                                             //wNumChannels+1;
            timer=20;
            break;

         case 48000:
            prescale=16;                                                                    //wNumChannels+1
            timer=147;
            break;


         default:
            {
            DWORD target_ratio;
            DWORD best_ratio=((DWORD)300) << 10;
            DWORD   test_ratio;
            long    best_diff=((long)7000) << 10;
            long    last_diff;
            long    test_diff;
            int             best_p=0,best_t=0;
            int p,t;

            target_ratio=DwordDivide( ((DWORD)441000) << 10,
                                                                                                                   samplespersec,       TRUE);
            for (p=2; p<256; p++)
               {
               last_diff=((DWORD)300) << 10;
               for (t=p+1; t<256; t++)
                  {
                  test_ratio= DwordDivide( ((DWORD)t) << 10, (DWORD) p,TRUE);
                  if (test_ratio==target_ratio)
                     {
                     best_ratio=test_ratio;
                     best_p=p;
                     best_t=t;
                     goto got_em;
                     }

                  test_diff=test_ratio-target_ratio;
                  if (test_diff <0)
                     test_diff=-test_diff;

                  if (test_diff > last_diff )
                     break;

                  if (test_diff < best_diff)
                     {
                     best_ratio=test_ratio;
                     best_diff=test_diff;
                     best_p=p;
                     best_t=t;
                     }
                  last_diff=test_diff;
                  } // end for
               } // end for
            got_em:
            prescale=best_p;
            timer=best_t;
            } // end default
         } // end switch

      loadPrescale(prescale);
      loadTimer0(timer);
      } // end if (pf.ProCard[gwBoardIndex].Caps.CapsBits.DAC16)

   else
      {
      #ifdef DEBUG_CHK
      StringOut("Inaccurate timing method");
      #endif

      // dwTicks becomes # clock ticks/sample
      dwTicks = DwordDivide(MASTER_CLOCK,mysamplespersec,TRUE);

      samplerate=LOWORD(dwTicks);

      loadTimer0(samplerate);

      if (fStereoMode)                          // STEREO CASE
         mysamplespersec/=2L;

      SampleFilterSetting=1;

      if (mysamplespersec == 11025L)            // kludge!
         SampleFilterSetting=2;

      /*
      ** Calculate based on Nyquist law: max freq is samples/2
      */
      if (mysamplespersec > (5965L*2))
         SampleFilterSetting=2;
      if (mysamplespersec > (8948L*2))
         SampleFilterSetting=3;
      if (mysamplespersec > (11931L*2))
         SampleFilterSetting=4;
      if (mysamplespersec > (15909L*2))
         SampleFilterSetting=5;
      if (mysamplespersec > (17897L*2))
         SampleFilterSetting=6;

      // #if 0
      // mixOpen((LPHMIXER) &hMixer,0,0);
      // // if sample rate is less than 36K make sure filter is patched
      // if (mysamplespersec <= (15909L*2))
      //    mixSetConnections(hMixer,IN_PCM,(DWORD) (1L<<OUT_PCM));
      // else
      //    mixSetConnections(hMixer,IN_PCM,(DWORD) (1L<<OUT_AMPLIFIER));
      // mixClose(hMixer);
      // #endif

      }

   gdwSampleRate=samplespersec;

//   #define BUF_SAMPLE_RATE
   #ifdef BUF_SAMPLE_RATE
      PrintfOut("SampleRate: %ld",gdwSampleRate);
   #endif

   return;
}

