/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* audiovdm.c - template sample - VDM support for Audio PDD communication to VDD
*
* DESCRIPTION:
* This file contains routines for IDC communication with audiovdd.sys VDD.
* See toolkit sample component AVDD for VDD side of communication.
*
* Details of PDD and VDD IDC communication are outlined below:
* - At initialization, the PDD and VDD exchange entry points according to
*   to OS/2 defined DevHelps (RegisterPDD and VDHOpenPDD).
*   The name used for the register comes from the config.sys command line.
*   The PDD's entry point is in a 16:16 segment.  The VDD's is 16:32.
*
* - The PDD and VDD entry points both accept 3 ULONG parameters:
*   ulFunc, ul1 and ul2.  The function code identifies the action.
*   The other two parms are function specific.
*   When the VDD opens the PDD (VDHOpenPDD), the operating system beams
*   message number zero to the PDD and gives the VDD's IDC entry point
*   as the parameters.  All other function codes are PDD/VDD pair specific.
*
* - The IDC routines follow Pascal calling convention.  Parameters
*   are pushed left to right and the callee is responsible for
*   popping parameters from the stack (i.e. use a "ret 12" instruction)
*   This convention puts the first parameter at the highest stack position.
*
* - The PDD IDC entry point is in startup.asm.  That assembler code handles
*   thunking and conversion of Pascal calling conventions to C before calling
*   routines in this file.
*
* - PDD IDC processing (calls PDD can receive at its IDC entry point)
*   ulFunc     Purpose
*     0        Open IDC communication.  Parms have VDD's IDC entry point.
*     1        Query protocol.  VDD pings PDD to make sure the two agree
*              on protocol.  Supposed to keep the VDD from trying to talk
*              to PDDs that don't follow the expected protocol.
*              PDD returns word: high byte and low byte reflect highest ulFunc
*              that the PDD and VDD can receive (e.g. 0501)
*     2        Assing handle to PDD for call backs.  Necessary as the VDD
*              supports multiple PDDs simultaneously.
*     3        Open device.  VDD requests ownership of the audio adapter.
*     4        Close device.  VDD returns ownership to PDD
*     5        Get port info.  VDD asks PDD to give address of a data structure
*              that has information for installing I/O port traps in the VDM.
*
* - VDD IDC processing (calls PDD can make to VDD)
*   ulFunc     Purpose
*     0        Hardware interrupt.  Please virtualize for the DOS session.
*     1        Close device.  PDD calls VDD on final OS/2 session close to
*              give VDD a chance to restart blocked DOS sessions.
*              PDD may be called back on its same thread.
******************************************************************************/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "cdevhlp.h"
#include "findpas.h"
#include "globals.h"


extern ADAPTERDATA AdapterInfo;

PVOID   pRetLinAddress;

ULONG PDDInternalEntryPoint(ULONG ulFunc, ULONG ul1, ULONG ul2)
{

        USHORT  usTemp;

   // _asm int 3
   switch (ulFunc) {
      /*******************************************************/
      /* VDD registering its entry point with PDD            */
      /*******************************************************/
      case 0:
         // get and save VDD entry point
         GlobalTable.VDDIDCSel =(USHORT) ul1;
         GlobalTable.VDDIDCOffset = ul2;
         break;

      /*******************************************************/
      /* Query protocol level                                */
      /*******************************************************/
      case 1:
         return (PDD_VERISON);

      /*******************************************************/
      /* VDD sends PDD a handle to use for IDC communication */
      /*******************************************************/
      case 2:
         GlobalTable.ulPDDHandle = ul1;
         break;

      /*******************************************************/
      /* VDD request open to PDD                             */
      /*******************************************************/
      case 3:
         if (!usInUse) {
            usInUse = NOT_AVAILABLE | VDM;
            return(1);                      // honor open request
            }
         else
            return (0);                     // fail open

      /*******************************************************/
      /* VDD request close to PDD                                    */
      /*******************************************************/
      case 4:
         usInUse = AVAILABLE;
         break;

      /*******************************************************/
      /* Return linear address of I/O port info structure    */
      /*******************************************************/
      case 5:
         // Need to call DevHelp "VirtToLin" to convert
         // 16:16 address to linear address - return linear address to VDD
         // The IOport information should be stored in non-swappable
         // data area with following structure.

         usTemp = (USHORT)(NPVOID)&AdapterInfo;
         if (!DevHlp_VirtToLin( (USHORT) NULL,             // pass null to indicate use DS
                               (ULONG) usTemp,           // 16-bit offset
                               (PVOID) &pRetLinAddress )) // seg:offset
                 return((ULONG)pRetLinAddress);
         else
                return(0);

   }

   /*
   ** Note, the return must be a 16:32 return as we were called
   ** far from 32 bit kernel code.
   ** This code is 16:16 and the compiler would wrongly generate
   ** a 16:16 far return if we used the C return() instruction.
   */
   return (1);
}


/********************* START OF SPECIFICATIONS *********************
* NAME:      VDMInterruptTime()
*
* FUNCTION:  Check if running in a VDM and report interrupt to VDM
*
* NOTES:     If this interrupt is from a VDM session, then we do NOT
*            want the PDD to perform I/O to the adapter - let the DOS
*            application write to the adapter.
*
* LINKAGE:   Call from InterruptHandler (near)
*
* INPUT:
*
* EFFECTS:
*
* INTERNAL REFERENCES:
*
* EXTERNAL REFERENCES:
*
*********************** END OF SPECIFICATIONS **********************/
VOID VDMInterruptTime()
{
        /****************************************************************/
        /* if PDD in use by VDM, then call VDD during interrupt time    */
        /****************************************************************/

        if (usInUse & VDM)
           {
           CallVDD (GlobalTable.VDDIDCOffset,
                    GlobalTable.VDDIDCSel,
                    VDM_INTR,
                    GlobalTable.ulPDDHandle,
                    (ULONG)AdapterInfo.usIRQLevel);
           }
}


/********************* START OF SPECIFICATIONS *********************
* NAME:      VDMClose()
*
* FUNCTION:  To close let the VDD know that the PDD is being closed
*            and available for use by the VDD.
*
* NOTES:     This allows a VDM waiting for access to the adapter to
*            call us back on an OPEN.
*
* LINKAGE:   Call from DosClose code (near)
*
* INPUT:
*
* EFFECTS:
*
* INTERNAL REFERENCES:
*
* EXTERNAL REFERENCES:
*
*********************** END OF SPECIFICATIONS **********************/
VOID VDMClose()
{
        /****************************************************************/
        /* Always call VDD at DosClose time                             */
        /* This will allow a VDM waiting for access to call us back     */
        /****************************************************************/
        if (GlobalTable.VDDIDCSel)
                CallVDD (GlobalTable.VDDIDCOffset,
                         GlobalTable.VDDIDCSel,
                         VDM_CLOSE,
                         GlobalTable.ulPDDHandle,
                         0);
}
