/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* audiodat.c - Based on MMPM/2 template sample source (device driver data)
*
* DESCRIPTION:
* Audio device driver GLOBAL data tables.
* Also includes all discardable global data.
* This file contains the device driver headers (devhdr structures).
* Note that the driver responds by multiple names.  The names of the driver
* are filled in by initialization code.  In most circumstances, the driver
* will respond as "AUDIOn$" (where 'n' is 0..9) and as a name more specific
* to the device.  For primary communication with MMPM/2, the driver is
* assigned a second name on the config.sys command line.  This name helps
* identify the particular adapter.
*
* This file also includes data which is global to the device driver and
* information for stream processing and VDD communication.
*
*/

#define  INCL_NOPMAPI
#define  INCL_DOS
#define  INCL_DOSDEVICES
#define  INCL_ERRORS
#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#define  DRV_16
#include "os2mixer.h"
#include "mvmixer.h"
#include "patch.h"
#include "pasdef.h"
#include "mvprodd.h"

/*
** externs - Assembler functions in STARTUP.ASM
*/
extern  Strategy();             // IOCTL entry point (Amp Mixer)
extern  DDCMDEntryPoint();      // IDC entry point (stream handler)


/*
** Device driver headers
** First header starts off as AUDIO1$.  If some other PDD already
** has that name, the name is changed during initialization.
** The second header is a bit more stable.  By convention, its name
** is also filled in at initialization, but the name comes from the
** config.sys command line.
** This allows the installation utilities to name devices on a basis
** that closely resembles the device.
*/
DEVHDR DevHdr[2] =
   {
   {(FPVOID)&DevHdr[1],      // link (filled in by OS)
   AUDIO_ATTRIB,                 // attribute
   (NPVOID)Strategy,             // Offset of Strategy routine
   (NPVOID)DDCMDEntryPoint,      // Offset of IDC routine
   "AUDIO1$ ",                   // name where n=1-9
   "\0\0\0\0\0\0\0\0"},          // 8 bytes reserved

   {(FPVOID) 0xFFFFFFFF,          // link (filled in by OS)
   AUDIO_ATTRIB,                 // attribute
   (NPVOID)Strategy,             // Offset of Strategy routine
   (NPVOID)DDCMDEntryPoint,      // Offset of IDC routine
   "MVPAS01$",                   // name where n=1-9
   "\0\0\0\0\0\0\0\0"}           // 8 bytes reserved
   };

/*
** 16:16 pointer to OS/2 DevHelp entry point
** Is filled in during initialization and referenced
** every time the PDD wants to ask the kernel for
** some help.
*/
FPVOID DevHlp;


/*
** The life of the device driver.  The global table
** This table holds information telling the driver about the
** open (and closed) streams.
** Its pointers, and the structures referecned are the life of
** maintaining simultaneous application support.
**
** The fields in this structure are filled in during initialization,
** on stream creation/destroy and throughout execution.
*/
GLOBAL GlobalTable = {
             NULL,                  // paStream dynamically allocated
             NULL,                  // DMA buffer ptr
             (DWORD) NULL,          // driver inited
             DEFAULTSTREAMS,        // number of streams
             (ULONG) NULL,          // ulPddHandle (for VDD communication)
             0 /*NULL*/,            // VDD IDC Entry point (offset 32-bits)
             0 /*NULL*/};           // VDD IDC Entry point (segment 16-bits)

/*
** For VDD support (audiovdd.sys), the device driver must define a
** data structure that describes its adapter.  The VDD references
** this table to install DOS session hooks and for interrupt routing.
** Some of the fields have default values listed that may or may not
** be the ones in effect (changed via config.sys).  The driver corrects
** these numbers during initialization.
*/
ADAPTERDATA AdapterInfo =
   {
   DEF_INT_16,        // interrupt
   3,                 // dma (not referenced by the VDD at this time)
   NUM_PORT_RANGES,   // numPorts

   /*
   ** Define pairs of 32-bit numbers (start port and number ports).
   ** One pair for each range (NUM_PORT_RANGES total)
   */
      {
      {FM_BASE,                    4}, // covers OPL-2 and OPL-3
      {ALTERNATE_FM,               4}, // covers OPL-2 and 508 mixer
      {FEATURE_ENABLE,             4}, // also INTERRUPT_STATUS, FILTER_REGISTER,
                                       //      INTERRUPT_ENABLE
      {PCM_CONTROL,                1}, //
      {SAMPLE_RATE,                4}, // also SAMPLE_COUNT, SPEAKER_TIMER,
                                       //      TIMER_CONTROLLER
      {MIDI_PRESCALE,              4}, // also MIDI_TIMER, MIDI_DATA,
                                       //      MIDI_CONTROL
      {MIDI_STATUS,                3}, // also MIDI_FIFO_STATUS,
                                       //      MIDI_COMPARE_TIME
      {SYSTEM_CONFIG_1,            3}, // also SYSTEM_CONFIG_2, SYSTEM_CONFIG_3
      {PRESCALE_DIVIDER,           1},
      {IO_PORT_CONFIG_2,           2}, // also IO_PORT_CONFIG_3
      {COMPATIBLE_REGISTER_ENABLE, 2}  // also EMULATION_ADDRESS_POINTER
      }
   };

ADAPTERDATA SBAdapterInfo =
   {
   5,                 // interrupt
   1,                 // dma
   0x0L,              // numPorts
   0x220L,            // Port
   0x0f,              // range
   0x220L,            // Port
   0x018};            // range

ADAPTERDATA MPUAdapterInfo =
   {
   MPU_IRQ,           // interrupt
   -1,                // dma
   0x0L,              // numPorts
   MPU_ADDR,          // Port
   0x02,              // range
   0x220L,            // Port
   0x018};            // range

/************************************************/
/* Defect 10866 - 03/24/94                      */
/* Use larger buffer size for higher data rates */
/* Prevents underrun condition/noise (vs. 16K)  */
/************************************************/
PROTOCOLTABLE ProtocolTable16[N16PROTOCOLS] =
  {
    { DATATYPE_MIDI,      SUBTYPE_NONE,        512L,  3, 0,     0, 0},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_8M08, 16*1024L, 3,  8000, 1, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_8S08, 16*1024L, 3,  8000, 2, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_8M16, 16*1024L, 4,  8000, 1,16},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_8S16, 16*1024L, 4,  8000, 2,16},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1M08, 16*1024L, 3, 11025, 1, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1S08, 16*1024L, 3, 11025, 2, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1M16, 16*1024L, 4, 11025, 1,16},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1S16, 16*1024L, 4, 11025, 2,16},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2M08, 32*1024L, 3, 22050, 1, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2S08, 32*1024L, 4, 22050, 2, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2M16, 32*1024L, 4, 22050, 1,16},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2S16, 32*1024L, 4, 22050, 2,16},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4M08, 60*1024L, 4, 44100, 1, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4S08, 60*1024L, 8, 44100, 2, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4M16, 60*1024L, 4, 44100, 1,16},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4S16, 60*1024L, 6, 44100, 2,16},
  };

PROTOCOLTABLE ProtocolTable8[N8PROTOCOLS] =
  {
    { DATATYPE_MIDI,      SUBTYPE_NONE,        512L,  3, 0,     0, 0},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_8M08, 16*1024L, 3,  8000, 1, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_8S08, 16*1024L, 3,  8000, 2, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1M08, 16*1024L, 3, 11025, 1, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_1S08, 16*1024L, 3, 11025, 2, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2M08, 32*1024L, 3, 22050, 1, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_2S08, 32*1024L, 4, 22050, 2, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4M08, 64*1024L, 4, 44100, 1, 8},
    { DATATYPE_WAVEFORM,  WAVE_FORMAT_4S08, 64*1024L, 8, 44100, 2, 8},
  };


/*
** IOCTL jump table
** Based on IOCTL number, index appropriate function
*/
ULONG (*IOCTLFuncs[])(PREQPACKET rp) =
   {
   IOCTL_Init,                  // 0    (strategy routine functions)
   IOCTL_Invalid,               // 1
   IOCTL_Invalid,               // 2
   IOCTL_Input,                 // 3
   IOCTL_Read,                  // 4
   IOCTL_NondestructiveRead,    // 5
   IOCTL_ReadStatus,            // 6
   IOCTL_FlushInput,            // 7
   IOCTL_Write,                 // 8
   IOCTL_Invalid,               // 9
   IOCTL_WriteStatus,           // 10
   IOCTL_FlushOutput,           // 11
   IOCTL_Output,                // 12
   IOCTL_Open,                  // 13
   IOCTL_Close,                 // 14
   IOCTL_Invalid,               // 15
   IOCTL_GenIoctl               // 16
   };

/*
** Define a variable (constant) that is the max
** index of the above table
*/
USHORT MaxIOCTLFuncs = sizeof(IOCTLFuncs)/sizeof(USHORT);

/*
** Audio Generic IOCTL jump table
** Based on function code, index appropriate function
*/
ULONG (*AudioIOCTLFuncs[])(PVOID pParm) =
   {
   Audio_IOCTL_Init,            // 0
   Audio_IOCTL_Status,          // 1
   Audio_IOCTL_Control,         // 2
   Audio_IOCTL_Buffer,          // 3
   Audio_IOCTL_Load,            // 4
   Audio_IOCTL_Wait,            // 5
   Audio_IOCTL_Hpi              // 6
   };

/*
** Define a variable (constant) that is the max
** index of the above table
*/
USHORT  MaxAudioIOCTLFuncs = sizeof(AudioIOCTLFuncs)/sizeof(USHORT);

/*
** Define Patch table (PAS-16)
** Patch Number, Device Type, connectable to, name, Association, Reserved
*/
PATCHINFO INpatch[NUM_IN_PATCHES]=
   {
   0, MIX_NO_CONNECT,                       0x7F, "[N/C]", (DWORD)NULL, (DWORD)NULL,
   1, MIX_INSTRUMENT  | MIX_HARD_WIRED,     1<<0, "SYNTH", (DWORD)NULL, (DWORD)NULL,
   2, MIX_MIXER       | MIX_HARD_WIRED,     1<<1, "MIXER", (DWORD)NULL, (DWORD)NULL,
   3, MIX_AUXILLARY   | MIX_USER_CONNECTED, 1<<2, "AUX",   (DWORD)NULL, (DWORD)NULL,
   4, MIX_CD_AUDIO    | MIX_USER_CONNECTED, 1<<3, "CD",    (DWORD)NULL, (DWORD)NULL,
   5, MIX_MICROPHONE  | MIX_USER_CONNECTED, 1<<4, "MIC",   (DWORD)NULL, (DWORD)NULL,
   6, MIX_WAVE        | MIX_HARD_WIRED,     1<<5, "WAVE",  (DWORD)NULL, (DWORD)NULL,
   7, MIX_PC_INT_SPKR | MIX_HARD_WIRED,     1<<6, "SPKR",  (DWORD)NULL, (DWORD)NULL,
   8, MIX_WAVE        | MIX_HARD_WIRED,     1<<7, "BLSTR", (DWORD)NULL, (DWORD)NULL
   };


PATCHINFO OUTpatch[NUM_OUT_PATCHES]=
   {
   0, MIX_NO_CONNECT,                                     0x3,    "[N/C]",  (DWORD)NULL, (DWORD)NULL,
   1, MIX_AMPLIFIER | MIX_LISTENER | MIX_USER_CONNECTED,  1<<0,   "MASTER", (DWORD)NULL, (DWORD)NULL,
   2, MIX_WAVE      | MIX_LISTENER | MIX_HARD_WIRED,      1<<1,   "REC IN", (DWORD)NULL, (DWORD)NULL
   };

//MCI_AUDIO_IOBUFFER xmitio;
MCI_AUDIO_IOBUFFER recio;
