/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*                 Pro AudioSpectrum16 Physical Device Driver
*                     Production code and toolkit sample
*
*
* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
* sample code created by IBM Corporation and Media Vision Corporation.
* It is provided to you solely for the purpose of assisting you in the
* development of your applications.
* The code is provided "AS IS", without warranty of any kind.
* IBM and Media Vision shall not be liable for any damages arising out of
* your use of the sample code, even if they have been advised of the
* possibility of such damages.
*
*******************************************************************************
*
* audintr.c - Modification of IBM template sample - Interrupt handler code
*
* This file contains code originally from the IBM MMPM/2 toolkit Audio
* Physical Device Driver sample.
* The interrupt handler implemented here is for the Media Vision PAS-16.
*
* Processes data stream and calls stream handler via
* IDC (Inter Device Communication) to get/give data buffers.
*
*/

#define  INCL_DOS
#define  INCL_DOSINFOSEG
#include <os2.h>
#include <os2medef.h>
#include <ssm.h>         // Sync Stream Manager
#include <shdd.h>
#include <audio.h>
#include <meerror.h>
#include "mvprodd.h"
#include "pasdef.h"
#define DRV_16
#include "os2mixer.h"
#include "findpas.h"
#include "proto.h"
#include "globals.h"
#include "debug.h"
#include "commdbg.h"
#include "cdevhlp.h"

BYTE  bTemp;         // data segment variable for speed

static USHORT Update_stream_time_counter = 1;


/*                                      -------------------- InterruptHandler -
** This procedure is called at device interrupt time
*/
VOID FAR InterruptHandler()
{
   BOOL  fPCMBuffer, fMIDITimeStamp, fMIDICompareTime;
   BOOL  fMIDIInUse=FALSE;
   BOOL  fPCMInUse=FALSE;
   PSTREAM pStream=0;

   // Always EOI
   // MIDI TIMING INTERRUPT

   bTemp=PASX_IN(MIDI_STATUS);         // see if it was a MIDI interrupt
   if (pf.ProCard[gwBoardIndex].wChipRev<=3)     // aka REV A thru C
      {
      if (fMIDICompareTime= bTemp & INT_COMPARE_TIME_OCCURRED)
         {
         PASX_OUT(MIDI_PRESCALE,(BYTE) wMIDIPrescale);   // resets Prescale
         pStream=GetActiveMIDIStream();
         if (pStream)
            pStream->ulCumTimeX10+=pStream->ulInterruptPeriod;
         fMIDIInUse=TRUE;
         wMIDICurrentTime++;
         if (wMIDICurrentTime>=1)
            {
            // stream position should be in bytes
            // ulStreamPosition.synth++;     // count of ticks.

            if (pStream)
              while (pStream->ulMIDIStreamTimeX10 < pStream->ulCumTimeX10)
               {
               MIDITimerInterrupt(pStream);
               pStream->ulMIDIStreamTimeX10+=pStream->ulPartPeriod;
               }
            wMIDICurrentTime=0;
            }
         PASX_OUT(MIDI_STATUS,bTemp);
         }
      }
   else                              // REV D
      {
      if (fMIDITimeStamp= bTemp & INT_TIME_STAMP_OCCURRED)
         {
         pStream=GetActiveMIDIStream();
         if (pStream)
            pStream->ulCumTimeX10+=pStream->ulInterruptPeriod;
         fMIDIInUse=TRUE;
         wMIDICurrentTime++;
         if (wMIDICurrentTime==(wMIDICompareTime))
            {
            if (pStream)
              while (pStream->ulMIDIStreamTimeX10 < pStream->ulCumTimeX10 )
               {
               MIDITimerInterrupt(pStream);
               pStream->ulMIDIStreamTimeX10+=pStream->ulPartPeriod;
               }
            wMIDICurrentTime=0;
            }
         else  // special handling for Rev D,
            {
            if (!ulTimingDelay)
               if (pStream)
                 if ((pStream->ulMIDIStreamTimeX10+pStream->ulPartPeriod) < (pStream->ulCumTimeX10 + (pStream->ulPartPeriod/2) ))
                   MIDITimerInterrupt(pStream);
            }
         PASX_OUT(MIDI_STATUS,bTemp);
         }
      }
   #ifdef DEBUG_CHK
   bTemp=PASX_IN(MIDI_STATUS);         // see if it was a MIDI interrupt
   // if (bTemp)
   //    PrintfOut("MIDI <int> Status not zero:%x",bTemp);
   #endif

   ///////////////////////////////////////////////////////////////////
   //          PCM BUFFER INTERRUPT                                 //
   ///////////////////////////////////////////////////////////////////

   fPCMBuffer= PASX_IN(INTERRUPT_STATUS) & INT_SAMPLE_BUFFER_OCCURRED;
   if (fPCMBuffer)
      {
      PCMInterrupt();
      fPCMInUse=TRUE;
      // 3/11/93  moved PAS int ack out of EOI()
     PASX_OUT( INTERRUPT_STATUS, 0 );                // a write clears the PCM interrupt
      }

   ///////////////////////////////////////////////////////////////////
   //          MIDI INPUT INTERRUPT                                 //
   ///////////////////////////////////////////////////////////////////

   //fMIDIInput= PASX_IN(MIDI_STATUS) & MIDI_INPUT_FIFO_DATA;
   //if (fMIDIInput)
   //   MIDIInputInterrupt();

   VDMInterruptTime();

   // If second interrupt occurred while processing, make it happen!

   bTemp= PASX_IN(INTERRUPT_ENABLE);

   if (bTemp & INT_SAMPLE_BUFFER)
             TogglePCMIntEnable();
   if (bTemp & INT_MIDI)
             ToggleMIDIIntEnable();

   _asm cli
   EOI();                          // Reset interrupt controller
   return;
}


/*                                      ----------------- GetActiveMIDIStream -
** returns  NULL pointer if stream not found
*/
PSTREAM near GetActiveMIDIStream()
{
   USHORT   i;
   PSTREAM  pStream= (PSTREAM) NULL;

        for (i=0; i<GlobalTable.usMaxNumStreams; i++)
      if (GlobalTable.paStream[i].hStream != -1) // ignore invalid streams
                        {
         if ((GlobalTable.paStream[i].ulFlags & STREAM_STREAMING) &&
               (GlobalTable.paStream[i].usMode== MIDI) )
                                pStream=&GlobalTable.paStream[i];
         }
   return (pStream);
}
void NEAR
MIDITimerInterrupt(PSTREAM pStream)
{
   if (ulTimingDelay)
      {
      ulTimingDelay--;
      return;
      }

        if (!pStream)
                {
                //StringOut( "<NO MIDI STREAM!>");
      PASX_OUT(MIDI_STATUS,PASX_IN(MIDI_STATUS));
                return;
                }
   /*
   ** Do not call stream handler OR get any new buffers
   ** if stream was/is stopped by handler
   **
   ** Definitions:
   **    Overrun  - Happens during "record" if the DSP (card)
   **               does not have an empty buffer to place data.
   **               This is a data loss condition.
   **    Underrun - Happens during "playback" if the DSP (card)
   **               has no more buffers available to read.
   **               (ie No data available to write to hardware).
   **               No data loss, but will experience audio interuption.
   **
   ** So, it is the hardware that detects the error condition.
   ** The method of relaying this information to the PDD is device
   ** specific.  A common method is for the hardware to address flags
   ** in the PDD (writeable addresses set up at initialization time).
   ** Those flags would be interrogated here to determine if all is well.
   ** If things are not well, that information would be passed on to
   ** the stream handler.
   */

   // Code omitted - test overrun/underrun and report to stream handler

   //*****************************************
   // Report interrupt to audio stream handler
   //*****************************************

        #ifdef BUF_MONITOR
        PrintfOut( "Interrupt Before Dispose:  Done: %d   Curr: %d   Next: %d\r\n",
                           pStream->usDoneIOBuffIndex,
                           pStream->usCurrIOBuffIndex,
                           pStream->usNextIOBuffIndex
                           );
        #endif

   DisposeOfPlayedBuffer(pStream);                              // must do before data write

        #ifdef BUF_MONITOR
        PrintfOut( "Interrupt After  Dispose:  Done: %d   Curr: %d   Next: %d\r\n",
                           pStream->usDoneIOBuffIndex,
                           pStream->usCurrIOBuffIndex,
                           pStream->usNextIOBuffIndex
                           );
        if (pStream->usDoneIOBuffIndex == pStream->usCurrIOBuffIndex)
           StringOut( "Last buffer disposed");

        StringOut( "int: call WriteDataToCard");
        #endif

   WriteDataToCard(pStream);

   //************************************
   // If pBuffer is NULL, report UNDERRUN
   // to ADSH, so he can shut me down
   //************************************

   return;
}


/*                                      ------------------------ PCMInterrupt -
** Do not call stream handler OR get any new buffers
** if stream was/is stopped by handler
**
** Definitions:
**    Overrun  - Happens during "record" if the DSP (card)
**               does not have an empty buffer to place data.
**               This is a data loss condition.
**    Underrun - Happens during "playback" if the DSP (card)
**               has no more buffers available to read.
**               (ie No data available to write to hardware).
**               No data loss, but will experience audio interuption.
**
** So, it is the hardware that detects the error condition.
** The method of relaying this information to the PDD is device
** specific.  A common method is for the hardware to address flags
** in the PDD (writeable addresses set up at initialization time).
** Those flags would be interrogated here to determine if all is well.
** If things are not well, that information would be passed on to
** the stream handler.
**
** NOTE: On PCM playback, we are aware that we will underrun one
** interrupt before it actually happens.
** If we report the underrun too early, the final buffer is never
** played as the stream handler shuts us down on the report of underrun.
*/
VOID NEAR PCMInterrupt()
{
   USHORT  i;
   PSTREAM pStream=0;

   #ifdef PROGRESS_MONITOR
   StringOut ("<IRQ>");
   #endif

   bTemp=PASX_IN(INTERRUPT_STATUS);
   bTemp &= ~INT_SAMPLE_BUFFER_OCCURRED;
   PASX_OUT(INTERRUPT_STATUS,bTemp);

   iEmptyPCMBuffers++;

   // Set up the pStream pointer
   for (i=0; i<GlobalTable.usMaxNumStreams; i++)
      if (GlobalTable.paStream[i].hStream != -1) // ignore invalid streams
         {
         // Only one PCM stream at a time can be streaming on our card
         if ((GlobalTable.paStream[i].ulFlags & STREAM_STREAMING)  &&
             (GlobalTable.paStream[i].usMode== PCM) )
            pStream=&GlobalTable.paStream[i];
         }
   if (!pStream)
      {
      StringOut( "<NO PCM STREAM!>");
      return;
      }


   if (pStream->ulFlags & STREAM_STOPPED)
      {
      StringOut( "<STREAM STOPPED>");
      return;
      }

   /*
   ** Increase count of bytes consumed/produced.
   ** Is used by later code to calculate the current stream time.
   ** Byte position stream time is modified on each interrupt.
   ** Don't allow stream position to go beyond the amount
   ** of data that we have received/buffer space to produce.
   */
   ulStreamPosition.pcm += dwDMAUnitSize;

   if (ulStreamPosition.pcm > pStream->ulMaxPosition)
      ulStreamPosition.pcm = pStream->ulMaxPosition;

   //*****************************************
   // Report interrupt to audio stream handler
   //*****************************************

   //*************************************
   // If operation is PLAY, write data out
   // to the card.  If operation is RECORD
   // get data from the card's input jack
   //*************************************

   if (operation.pcm == OPERATION_PLAY)
      {
      #ifdef BUF_MONITOR
      PrintfOut("Interrupt Before Dispose:  Done: %d   Curr: %d   Next: %d\r\n",
                pStream->usDoneIOBuffIndex,
                pStream->usCurrIOBuffIndex,
                pStream->usNextIOBuffIndex
               );
      #endif

      DisposeOfPlayedBuffer(pStream);  // must do before data write

      #ifdef BUF_MONITOR
      PrintfOut( "Interrupt After  Dispose:  Done: %d   Curr: %d   Next: %d\r\n",
                                   pStream->usDoneIOBuffIndex,
                                   pStream->usCurrIOBuffIndex,
                                   pStream->usNextIOBuffIndex
                                   );
      if (pStream->usDoneIOBuffIndex == pStream->usCurrIOBuffIndex)
         StringOut( "Last buffer disposed");
      StringOut( "int: call WriteDataToCard");
      #endif

      WriteDataToCard(pStream);
      }

   else // operation record
      {
      #ifdef BUF_MONITOR
      StringOut( "int: call ReadDataFromCard");
      #endif
      ReadDataFromCard(pStream); // Operation is record

      #ifdef BUF_MONITOR
      PrintfOut( "Interrupt Before Dispose:  Done: %d   Curr: %d   Next: %d\r\n",
                 pStream->usDoneIOBuffIndex,
                 pStream->usCurrIOBuffIndex,
                 pStream->usNextIOBuffIndex
                 );
      #endif

      DisposeOfFilledBuffer( pStream);
      #ifdef BUF_MONITOR
      PrintfOut( "Interrupt After  Dispose:  Done: %d   Curr: %d   Next: %d\r\n",
                 pStream->usDoneIOBuffIndex,
                 pStream->usCurrIOBuffIndex,
                 pStream->usNextIOBuffIndex
                 );
      if (pStream->usDoneIOBuffIndex == pStream->usCurrIOBuffIndex)
         StringOut( "Last buffer disposed");
      #endif
      } /* end else */

   //************************************
   // If pBuffer is NULL, report UNDERRUN
   // to ADSH, so he can shut me down
   //************************************

   return;
}


//*****************************************
// Report done buffer to audio stream handler
// Advance Current and Next Buffer pointers
//*****************************************

SHD_REPORTINT   ShdInt ;
void DisposeOfPlayedBuffer(PSTREAM pStream)
{
   BOOL fStarved;

   #ifdef PROGRESS_MONITOR
   StringOut ("Dispose");
   #endif

   if (pStream->usMode==PCM)
      fStarved=fPCMUnderran;
   else if (pStream->usMode==MIDI)
      fStarved=fMIDIStarved;

   if (pStream->usDoneIOBuffIndex == pStream->usCurrIOBuffIndex)
      {
      #ifdef BUF_MONITOR
      StringOut( "###  INTERNAL ERROR: trying to dispose");
      StringOut( "###  of an unused buffer              ");
      #endif
      #ifdef PROGRESS_MONITOR
      StringOut ("No buffer");
      #endif
      return;
      }

   ShdInt.ulFunction = SHD_REPORT_INT;
   ShdInt.hStream    = pStream->hStream;
   ShdInt.pBuffer    = pStream->IOBuff[pStream->usDoneIOBuffIndex].pBuffer;
   ShdInt.ulFlag     = SHD_WRITE_COMPLETE;

   if (pStream->usMode==PCM)
      {
      // Size of the buffer being returned
      ShdInt.ulStatus = pStream->IOBuff[pStream->usDoneIOBuffIndex].lSize;
      #ifdef BUF_MONITOR
      PrintfOut ("Ret:BufSize = %d", ShdInt.ulStatus);
      #endif
      }
   else if (pStream->usMode==MIDI)
      ShdInt.ulStatus = ulStreamPosition.synth; // return bytes processed!

   if (fStarved)
      {
      ShdInt.ulFlag |= ERROR;
      ShdInt.ulStatus = ERROR_DEVICE_UNDERRUN;
      #ifdef BUF_MONITOR
      StringOut("Returning error as ShdInt status due to underrun (starved)");
      #endif
      #ifdef PROGRESS_MONITOR
      StringOut ("*UnderRUN*");
      #endif
      }


   if (pStream->usMode == PCM)
     ShdInt.ulStreamTime = pStream->current_time;  // cumlative time in milliseconds
   else {
     GetStreamTime(pStream);                    // What is present time in stream
     ShdInt.ulStreamTime = pStream->ulCumTime;     // cumlative time in milliseconds
   }

   #ifdef BUF_MONITOR
   PrintfOut ("Ret:Time = %d", ShdInt.ulStreamTime);
   #endif

   //*****************************************
   // If overrun or underrun flags are set,
   // return error code to stream handler, set ERROR flag
   //*****************************************

   #ifdef PROGRESS_MONITOR
   PrintfOut (".pBuf %lx %lx", ShdInt.pBuffer, ShdInt.ulStatus);
   #endif
   // IDC call to Stream Handler
   ((PSHDFN)pStream->ADSHEntry)(&ShdInt);

   // Advance to next buffer
   pStream->usDoneIOBuffIndex++;
   if (pStream->usDoneIOBuffIndex >= MAXIOBUFFS)   // CHECK FOR WRAP
      pStream->usDoneIOBuffIndex=0;
}

void DisposeOfFilledBuffer(PSTREAM pStream)
{
   if (pStream->usDoneIOBuffIndex == pStream->usCurrIOBuffIndex)
      {
      #ifdef BUF_MONITOR
      StringOut( "<int> No filled buffers to dispose");
      #endif
      return;
      }

   ShdInt.ulFunction = SHD_REPORT_INT;
   ShdInt.hStream    = pStream->hStream;
   ShdInt.ulFlag     = SHD_READ_COMPLETE;
   ShdInt.pBuffer    = pStream->IOBuff[pStream->usDoneIOBuffIndex].pBuffer;

   if (pStream->usMode==PCM)
      {
      // Size of the buffer being returned
      ShdInt.ulStatus = pStream->IOBuff[pStream->usDoneIOBuffIndex].lCount;
      }
   else if (pStream->usMode==MIDI)
      ShdInt.ulStatus = ulStreamPosition.synth; // return bytes processed!


   if (fPCMChoked)                                                                 // suspected of causing problem
      {
      ShdInt.ulFlag |= ERROR;
      ShdInt.ulStatus = ERROR_DEVICE_OVERRUN;
      #ifdef BUF_MONITOR
      StringOut("Returning error as ShdInt status due to overrun");
      #endif
      }


   if (pStream->usMode == PCM)
     ShdInt.ulStreamTime = pStream->current_time;  // cumlative time in milliseconds
   else {
     GetStreamTime(pStream);                    // What is present time in stream
     ShdInt.ulStreamTime = pStream->ulCumTime;  // cumlative time in milliseconds
   }

   //*****************************************
   // If overrun or underrun flags are set,
   // return error code to stream handler, set ERROR flag
   //*****************************************

   // IDC call to Stream Handler
   ((PSHDFN)pStream->ADSHEntry)(&ShdInt);

   // Advance to next buffer
   pStream->usDoneIOBuffIndex++;
   if (pStream->usDoneIOBuffIndex >= MAXIOBUFFS)   // CHECK FOR WRAP
      pStream->usDoneIOBuffIndex=0;
}

VOID far _saveregs _loadds update_stream_times(VOID)
//    This function updates the time for the currentlt active stream.
//    The function does not have parameters.
//    The function does not return a value.
{
   USHORT   i;
   PSTREAM pStream=0;

   if (GlobalTable.paStream == NULL)
     return;

   for (i=0; i<GlobalTable.usMaxNumStreams; i++)
      if (GlobalTable.paStream[i].hStream != -1)  {  // ignore invalid streams
         // Only one PCM stream at a time can be streaming on our card
         if ((GlobalTable.paStream[i].ulFlags & STREAM_STREAMING)  &&
             (GlobalTable.paStream[i].usMode == PCM) ) {
            pStream = &GlobalTable.paStream[i];
         }
      }

        // return if no active stream
   if (pStream == (PSTREAM) 0)
     return;


        // increment the time
    if ((pStream->ulFlags & STREAM_STREAMING)  &&
             (pStream->usMode == PCM) ) {
        if (Update_stream_time_counter == 4) {
            Update_stream_time_counter = 1;
            pStream->current_time += 32L;
        }
        else {
            Update_stream_time_counter++;
            pStream->current_time += 31L;
        }
    }

//        // finished
    return;
}
